# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LoadbalancerBackendArgs', 'LoadbalancerBackend']

@pulumi.input_type
class LoadbalancerBackendArgs:
    def __init__(__self__, *,
                 forward_port: pulumi.Input[int],
                 forward_protocol: pulumi.Input[str],
                 lb_id: pulumi.Input[str],
                 forward_port_algorithm: Optional[pulumi.Input[str]] = None,
                 health_check_delay: Optional[pulumi.Input[str]] = None,
                 health_check_http: Optional[pulumi.Input['LoadbalancerBackendHealthCheckHttpArgs']] = None,
                 health_check_https: Optional[pulumi.Input['LoadbalancerBackendHealthCheckHttpsArgs']] = None,
                 health_check_max_retries: Optional[pulumi.Input[int]] = None,
                 health_check_port: Optional[pulumi.Input[int]] = None,
                 health_check_tcp: Optional[pulumi.Input['LoadbalancerBackendHealthCheckTcpArgs']] = None,
                 health_check_timeout: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 on_marked_down_action: Optional[pulumi.Input[str]] = None,
                 proxy_protocol: Optional[pulumi.Input[str]] = None,
                 send_proxy_v2: Optional[pulumi.Input[bool]] = None,
                 server_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sticky_sessions: Optional[pulumi.Input[str]] = None,
                 sticky_sessions_cookie_name: Optional[pulumi.Input[str]] = None,
                 timeout_connect: Optional[pulumi.Input[str]] = None,
                 timeout_server: Optional[pulumi.Input[str]] = None,
                 timeout_tunnel: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a LoadbalancerBackend resource.
        :param pulumi.Input[int] forward_port: User sessions will be forwarded to this port of backend servers
        :param pulumi.Input[str] forward_protocol: Backend protocol
        :param pulumi.Input[str] lb_id: The load-balancer ID
        :param pulumi.Input[str] forward_port_algorithm: Load balancing algorithm
        :param pulumi.Input[str] health_check_delay: Interval between two HC requests
        :param pulumi.Input[int] health_check_max_retries: Number of allowed failed HC requests before the backend server is marked down
        :param pulumi.Input[int] health_check_port: Port the HC requests will be send to. Default to `forward_port`
        :param pulumi.Input[str] health_check_timeout: Timeout before we consider a HC request failed
        :param pulumi.Input[str] name: The name of the backend
        :param pulumi.Input[str] on_marked_down_action: Modify what occurs when a backend server is marked down
        :param pulumi.Input[str] proxy_protocol: Type of PROXY protocol to enable
        :param pulumi.Input[bool] send_proxy_v2: Enables PROXY protocol version 2
        :param pulumi.Input[Sequence[pulumi.Input[str]]] server_ips: Backend server IP addresses list (IPv4 or IPv6)
        :param pulumi.Input[str] sticky_sessions: Load balancing algorithm
        :param pulumi.Input[str] sticky_sessions_cookie_name: Cookie name for for sticky sessions
        :param pulumi.Input[str] timeout_connect: Maximum initial server connection establishment time
        :param pulumi.Input[str] timeout_server: Maximum server connection inactivity time
        :param pulumi.Input[str] timeout_tunnel: Maximum tunnel inactivity time
        """
        pulumi.set(__self__, "forward_port", forward_port)
        pulumi.set(__self__, "forward_protocol", forward_protocol)
        pulumi.set(__self__, "lb_id", lb_id)
        if forward_port_algorithm is not None:
            pulumi.set(__self__, "forward_port_algorithm", forward_port_algorithm)
        if health_check_delay is not None:
            pulumi.set(__self__, "health_check_delay", health_check_delay)
        if health_check_http is not None:
            pulumi.set(__self__, "health_check_http", health_check_http)
        if health_check_https is not None:
            pulumi.set(__self__, "health_check_https", health_check_https)
        if health_check_max_retries is not None:
            pulumi.set(__self__, "health_check_max_retries", health_check_max_retries)
        if health_check_port is not None:
            pulumi.set(__self__, "health_check_port", health_check_port)
        if health_check_tcp is not None:
            pulumi.set(__self__, "health_check_tcp", health_check_tcp)
        if health_check_timeout is not None:
            pulumi.set(__self__, "health_check_timeout", health_check_timeout)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if on_marked_down_action is not None:
            pulumi.set(__self__, "on_marked_down_action", on_marked_down_action)
        if proxy_protocol is not None:
            pulumi.set(__self__, "proxy_protocol", proxy_protocol)
        if send_proxy_v2 is not None:
            warnings.warn("""Please use proxy_protocol instead""", DeprecationWarning)
            pulumi.log.warn("""send_proxy_v2 is deprecated: Please use proxy_protocol instead""")
        if send_proxy_v2 is not None:
            pulumi.set(__self__, "send_proxy_v2", send_proxy_v2)
        if server_ips is not None:
            pulumi.set(__self__, "server_ips", server_ips)
        if sticky_sessions is not None:
            pulumi.set(__self__, "sticky_sessions", sticky_sessions)
        if sticky_sessions_cookie_name is not None:
            pulumi.set(__self__, "sticky_sessions_cookie_name", sticky_sessions_cookie_name)
        if timeout_connect is not None:
            pulumi.set(__self__, "timeout_connect", timeout_connect)
        if timeout_server is not None:
            pulumi.set(__self__, "timeout_server", timeout_server)
        if timeout_tunnel is not None:
            pulumi.set(__self__, "timeout_tunnel", timeout_tunnel)

    @property
    @pulumi.getter(name="forwardPort")
    def forward_port(self) -> pulumi.Input[int]:
        """
        User sessions will be forwarded to this port of backend servers
        """
        return pulumi.get(self, "forward_port")

    @forward_port.setter
    def forward_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "forward_port", value)

    @property
    @pulumi.getter(name="forwardProtocol")
    def forward_protocol(self) -> pulumi.Input[str]:
        """
        Backend protocol
        """
        return pulumi.get(self, "forward_protocol")

    @forward_protocol.setter
    def forward_protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "forward_protocol", value)

    @property
    @pulumi.getter(name="lbId")
    def lb_id(self) -> pulumi.Input[str]:
        """
        The load-balancer ID
        """
        return pulumi.get(self, "lb_id")

    @lb_id.setter
    def lb_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "lb_id", value)

    @property
    @pulumi.getter(name="forwardPortAlgorithm")
    def forward_port_algorithm(self) -> Optional[pulumi.Input[str]]:
        """
        Load balancing algorithm
        """
        return pulumi.get(self, "forward_port_algorithm")

    @forward_port_algorithm.setter
    def forward_port_algorithm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "forward_port_algorithm", value)

    @property
    @pulumi.getter(name="healthCheckDelay")
    def health_check_delay(self) -> Optional[pulumi.Input[str]]:
        """
        Interval between two HC requests
        """
        return pulumi.get(self, "health_check_delay")

    @health_check_delay.setter
    def health_check_delay(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_delay", value)

    @property
    @pulumi.getter(name="healthCheckHttp")
    def health_check_http(self) -> Optional[pulumi.Input['LoadbalancerBackendHealthCheckHttpArgs']]:
        return pulumi.get(self, "health_check_http")

    @health_check_http.setter
    def health_check_http(self, value: Optional[pulumi.Input['LoadbalancerBackendHealthCheckHttpArgs']]):
        pulumi.set(self, "health_check_http", value)

    @property
    @pulumi.getter(name="healthCheckHttps")
    def health_check_https(self) -> Optional[pulumi.Input['LoadbalancerBackendHealthCheckHttpsArgs']]:
        return pulumi.get(self, "health_check_https")

    @health_check_https.setter
    def health_check_https(self, value: Optional[pulumi.Input['LoadbalancerBackendHealthCheckHttpsArgs']]):
        pulumi.set(self, "health_check_https", value)

    @property
    @pulumi.getter(name="healthCheckMaxRetries")
    def health_check_max_retries(self) -> Optional[pulumi.Input[int]]:
        """
        Number of allowed failed HC requests before the backend server is marked down
        """
        return pulumi.get(self, "health_check_max_retries")

    @health_check_max_retries.setter
    def health_check_max_retries(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "health_check_max_retries", value)

    @property
    @pulumi.getter(name="healthCheckPort")
    def health_check_port(self) -> Optional[pulumi.Input[int]]:
        """
        Port the HC requests will be send to. Default to `forward_port`
        """
        return pulumi.get(self, "health_check_port")

    @health_check_port.setter
    def health_check_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "health_check_port", value)

    @property
    @pulumi.getter(name="healthCheckTcp")
    def health_check_tcp(self) -> Optional[pulumi.Input['LoadbalancerBackendHealthCheckTcpArgs']]:
        return pulumi.get(self, "health_check_tcp")

    @health_check_tcp.setter
    def health_check_tcp(self, value: Optional[pulumi.Input['LoadbalancerBackendHealthCheckTcpArgs']]):
        pulumi.set(self, "health_check_tcp", value)

    @property
    @pulumi.getter(name="healthCheckTimeout")
    def health_check_timeout(self) -> Optional[pulumi.Input[str]]:
        """
        Timeout before we consider a HC request failed
        """
        return pulumi.get(self, "health_check_timeout")

    @health_check_timeout.setter
    def health_check_timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_timeout", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the backend
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="onMarkedDownAction")
    def on_marked_down_action(self) -> Optional[pulumi.Input[str]]:
        """
        Modify what occurs when a backend server is marked down
        """
        return pulumi.get(self, "on_marked_down_action")

    @on_marked_down_action.setter
    def on_marked_down_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "on_marked_down_action", value)

    @property
    @pulumi.getter(name="proxyProtocol")
    def proxy_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Type of PROXY protocol to enable
        """
        return pulumi.get(self, "proxy_protocol")

    @proxy_protocol.setter
    def proxy_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "proxy_protocol", value)

    @property
    @pulumi.getter(name="sendProxyV2")
    def send_proxy_v2(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables PROXY protocol version 2
        """
        return pulumi.get(self, "send_proxy_v2")

    @send_proxy_v2.setter
    def send_proxy_v2(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "send_proxy_v2", value)

    @property
    @pulumi.getter(name="serverIps")
    def server_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Backend server IP addresses list (IPv4 or IPv6)
        """
        return pulumi.get(self, "server_ips")

    @server_ips.setter
    def server_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "server_ips", value)

    @property
    @pulumi.getter(name="stickySessions")
    def sticky_sessions(self) -> Optional[pulumi.Input[str]]:
        """
        Load balancing algorithm
        """
        return pulumi.get(self, "sticky_sessions")

    @sticky_sessions.setter
    def sticky_sessions(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sticky_sessions", value)

    @property
    @pulumi.getter(name="stickySessionsCookieName")
    def sticky_sessions_cookie_name(self) -> Optional[pulumi.Input[str]]:
        """
        Cookie name for for sticky sessions
        """
        return pulumi.get(self, "sticky_sessions_cookie_name")

    @sticky_sessions_cookie_name.setter
    def sticky_sessions_cookie_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sticky_sessions_cookie_name", value)

    @property
    @pulumi.getter(name="timeoutConnect")
    def timeout_connect(self) -> Optional[pulumi.Input[str]]:
        """
        Maximum initial server connection establishment time
        """
        return pulumi.get(self, "timeout_connect")

    @timeout_connect.setter
    def timeout_connect(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timeout_connect", value)

    @property
    @pulumi.getter(name="timeoutServer")
    def timeout_server(self) -> Optional[pulumi.Input[str]]:
        """
        Maximum server connection inactivity time
        """
        return pulumi.get(self, "timeout_server")

    @timeout_server.setter
    def timeout_server(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timeout_server", value)

    @property
    @pulumi.getter(name="timeoutTunnel")
    def timeout_tunnel(self) -> Optional[pulumi.Input[str]]:
        """
        Maximum tunnel inactivity time
        """
        return pulumi.get(self, "timeout_tunnel")

    @timeout_tunnel.setter
    def timeout_tunnel(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timeout_tunnel", value)


@pulumi.input_type
class _LoadbalancerBackendState:
    def __init__(__self__, *,
                 forward_port: Optional[pulumi.Input[int]] = None,
                 forward_port_algorithm: Optional[pulumi.Input[str]] = None,
                 forward_protocol: Optional[pulumi.Input[str]] = None,
                 health_check_delay: Optional[pulumi.Input[str]] = None,
                 health_check_http: Optional[pulumi.Input['LoadbalancerBackendHealthCheckHttpArgs']] = None,
                 health_check_https: Optional[pulumi.Input['LoadbalancerBackendHealthCheckHttpsArgs']] = None,
                 health_check_max_retries: Optional[pulumi.Input[int]] = None,
                 health_check_port: Optional[pulumi.Input[int]] = None,
                 health_check_tcp: Optional[pulumi.Input['LoadbalancerBackendHealthCheckTcpArgs']] = None,
                 health_check_timeout: Optional[pulumi.Input[str]] = None,
                 lb_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 on_marked_down_action: Optional[pulumi.Input[str]] = None,
                 proxy_protocol: Optional[pulumi.Input[str]] = None,
                 send_proxy_v2: Optional[pulumi.Input[bool]] = None,
                 server_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sticky_sessions: Optional[pulumi.Input[str]] = None,
                 sticky_sessions_cookie_name: Optional[pulumi.Input[str]] = None,
                 timeout_connect: Optional[pulumi.Input[str]] = None,
                 timeout_server: Optional[pulumi.Input[str]] = None,
                 timeout_tunnel: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering LoadbalancerBackend resources.
        :param pulumi.Input[int] forward_port: User sessions will be forwarded to this port of backend servers
        :param pulumi.Input[str] forward_port_algorithm: Load balancing algorithm
        :param pulumi.Input[str] forward_protocol: Backend protocol
        :param pulumi.Input[str] health_check_delay: Interval between two HC requests
        :param pulumi.Input[int] health_check_max_retries: Number of allowed failed HC requests before the backend server is marked down
        :param pulumi.Input[int] health_check_port: Port the HC requests will be send to. Default to `forward_port`
        :param pulumi.Input[str] health_check_timeout: Timeout before we consider a HC request failed
        :param pulumi.Input[str] lb_id: The load-balancer ID
        :param pulumi.Input[str] name: The name of the backend
        :param pulumi.Input[str] on_marked_down_action: Modify what occurs when a backend server is marked down
        :param pulumi.Input[str] proxy_protocol: Type of PROXY protocol to enable
        :param pulumi.Input[bool] send_proxy_v2: Enables PROXY protocol version 2
        :param pulumi.Input[Sequence[pulumi.Input[str]]] server_ips: Backend server IP addresses list (IPv4 or IPv6)
        :param pulumi.Input[str] sticky_sessions: Load balancing algorithm
        :param pulumi.Input[str] sticky_sessions_cookie_name: Cookie name for for sticky sessions
        :param pulumi.Input[str] timeout_connect: Maximum initial server connection establishment time
        :param pulumi.Input[str] timeout_server: Maximum server connection inactivity time
        :param pulumi.Input[str] timeout_tunnel: Maximum tunnel inactivity time
        """
        if forward_port is not None:
            pulumi.set(__self__, "forward_port", forward_port)
        if forward_port_algorithm is not None:
            pulumi.set(__self__, "forward_port_algorithm", forward_port_algorithm)
        if forward_protocol is not None:
            pulumi.set(__self__, "forward_protocol", forward_protocol)
        if health_check_delay is not None:
            pulumi.set(__self__, "health_check_delay", health_check_delay)
        if health_check_http is not None:
            pulumi.set(__self__, "health_check_http", health_check_http)
        if health_check_https is not None:
            pulumi.set(__self__, "health_check_https", health_check_https)
        if health_check_max_retries is not None:
            pulumi.set(__self__, "health_check_max_retries", health_check_max_retries)
        if health_check_port is not None:
            pulumi.set(__self__, "health_check_port", health_check_port)
        if health_check_tcp is not None:
            pulumi.set(__self__, "health_check_tcp", health_check_tcp)
        if health_check_timeout is not None:
            pulumi.set(__self__, "health_check_timeout", health_check_timeout)
        if lb_id is not None:
            pulumi.set(__self__, "lb_id", lb_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if on_marked_down_action is not None:
            pulumi.set(__self__, "on_marked_down_action", on_marked_down_action)
        if proxy_protocol is not None:
            pulumi.set(__self__, "proxy_protocol", proxy_protocol)
        if send_proxy_v2 is not None:
            warnings.warn("""Please use proxy_protocol instead""", DeprecationWarning)
            pulumi.log.warn("""send_proxy_v2 is deprecated: Please use proxy_protocol instead""")
        if send_proxy_v2 is not None:
            pulumi.set(__self__, "send_proxy_v2", send_proxy_v2)
        if server_ips is not None:
            pulumi.set(__self__, "server_ips", server_ips)
        if sticky_sessions is not None:
            pulumi.set(__self__, "sticky_sessions", sticky_sessions)
        if sticky_sessions_cookie_name is not None:
            pulumi.set(__self__, "sticky_sessions_cookie_name", sticky_sessions_cookie_name)
        if timeout_connect is not None:
            pulumi.set(__self__, "timeout_connect", timeout_connect)
        if timeout_server is not None:
            pulumi.set(__self__, "timeout_server", timeout_server)
        if timeout_tunnel is not None:
            pulumi.set(__self__, "timeout_tunnel", timeout_tunnel)

    @property
    @pulumi.getter(name="forwardPort")
    def forward_port(self) -> Optional[pulumi.Input[int]]:
        """
        User sessions will be forwarded to this port of backend servers
        """
        return pulumi.get(self, "forward_port")

    @forward_port.setter
    def forward_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "forward_port", value)

    @property
    @pulumi.getter(name="forwardPortAlgorithm")
    def forward_port_algorithm(self) -> Optional[pulumi.Input[str]]:
        """
        Load balancing algorithm
        """
        return pulumi.get(self, "forward_port_algorithm")

    @forward_port_algorithm.setter
    def forward_port_algorithm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "forward_port_algorithm", value)

    @property
    @pulumi.getter(name="forwardProtocol")
    def forward_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Backend protocol
        """
        return pulumi.get(self, "forward_protocol")

    @forward_protocol.setter
    def forward_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "forward_protocol", value)

    @property
    @pulumi.getter(name="healthCheckDelay")
    def health_check_delay(self) -> Optional[pulumi.Input[str]]:
        """
        Interval between two HC requests
        """
        return pulumi.get(self, "health_check_delay")

    @health_check_delay.setter
    def health_check_delay(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_delay", value)

    @property
    @pulumi.getter(name="healthCheckHttp")
    def health_check_http(self) -> Optional[pulumi.Input['LoadbalancerBackendHealthCheckHttpArgs']]:
        return pulumi.get(self, "health_check_http")

    @health_check_http.setter
    def health_check_http(self, value: Optional[pulumi.Input['LoadbalancerBackendHealthCheckHttpArgs']]):
        pulumi.set(self, "health_check_http", value)

    @property
    @pulumi.getter(name="healthCheckHttps")
    def health_check_https(self) -> Optional[pulumi.Input['LoadbalancerBackendHealthCheckHttpsArgs']]:
        return pulumi.get(self, "health_check_https")

    @health_check_https.setter
    def health_check_https(self, value: Optional[pulumi.Input['LoadbalancerBackendHealthCheckHttpsArgs']]):
        pulumi.set(self, "health_check_https", value)

    @property
    @pulumi.getter(name="healthCheckMaxRetries")
    def health_check_max_retries(self) -> Optional[pulumi.Input[int]]:
        """
        Number of allowed failed HC requests before the backend server is marked down
        """
        return pulumi.get(self, "health_check_max_retries")

    @health_check_max_retries.setter
    def health_check_max_retries(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "health_check_max_retries", value)

    @property
    @pulumi.getter(name="healthCheckPort")
    def health_check_port(self) -> Optional[pulumi.Input[int]]:
        """
        Port the HC requests will be send to. Default to `forward_port`
        """
        return pulumi.get(self, "health_check_port")

    @health_check_port.setter
    def health_check_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "health_check_port", value)

    @property
    @pulumi.getter(name="healthCheckTcp")
    def health_check_tcp(self) -> Optional[pulumi.Input['LoadbalancerBackendHealthCheckTcpArgs']]:
        return pulumi.get(self, "health_check_tcp")

    @health_check_tcp.setter
    def health_check_tcp(self, value: Optional[pulumi.Input['LoadbalancerBackendHealthCheckTcpArgs']]):
        pulumi.set(self, "health_check_tcp", value)

    @property
    @pulumi.getter(name="healthCheckTimeout")
    def health_check_timeout(self) -> Optional[pulumi.Input[str]]:
        """
        Timeout before we consider a HC request failed
        """
        return pulumi.get(self, "health_check_timeout")

    @health_check_timeout.setter
    def health_check_timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_timeout", value)

    @property
    @pulumi.getter(name="lbId")
    def lb_id(self) -> Optional[pulumi.Input[str]]:
        """
        The load-balancer ID
        """
        return pulumi.get(self, "lb_id")

    @lb_id.setter
    def lb_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lb_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the backend
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="onMarkedDownAction")
    def on_marked_down_action(self) -> Optional[pulumi.Input[str]]:
        """
        Modify what occurs when a backend server is marked down
        """
        return pulumi.get(self, "on_marked_down_action")

    @on_marked_down_action.setter
    def on_marked_down_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "on_marked_down_action", value)

    @property
    @pulumi.getter(name="proxyProtocol")
    def proxy_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Type of PROXY protocol to enable
        """
        return pulumi.get(self, "proxy_protocol")

    @proxy_protocol.setter
    def proxy_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "proxy_protocol", value)

    @property
    @pulumi.getter(name="sendProxyV2")
    def send_proxy_v2(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables PROXY protocol version 2
        """
        return pulumi.get(self, "send_proxy_v2")

    @send_proxy_v2.setter
    def send_proxy_v2(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "send_proxy_v2", value)

    @property
    @pulumi.getter(name="serverIps")
    def server_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Backend server IP addresses list (IPv4 or IPv6)
        """
        return pulumi.get(self, "server_ips")

    @server_ips.setter
    def server_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "server_ips", value)

    @property
    @pulumi.getter(name="stickySessions")
    def sticky_sessions(self) -> Optional[pulumi.Input[str]]:
        """
        Load balancing algorithm
        """
        return pulumi.get(self, "sticky_sessions")

    @sticky_sessions.setter
    def sticky_sessions(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sticky_sessions", value)

    @property
    @pulumi.getter(name="stickySessionsCookieName")
    def sticky_sessions_cookie_name(self) -> Optional[pulumi.Input[str]]:
        """
        Cookie name for for sticky sessions
        """
        return pulumi.get(self, "sticky_sessions_cookie_name")

    @sticky_sessions_cookie_name.setter
    def sticky_sessions_cookie_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sticky_sessions_cookie_name", value)

    @property
    @pulumi.getter(name="timeoutConnect")
    def timeout_connect(self) -> Optional[pulumi.Input[str]]:
        """
        Maximum initial server connection establishment time
        """
        return pulumi.get(self, "timeout_connect")

    @timeout_connect.setter
    def timeout_connect(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timeout_connect", value)

    @property
    @pulumi.getter(name="timeoutServer")
    def timeout_server(self) -> Optional[pulumi.Input[str]]:
        """
        Maximum server connection inactivity time
        """
        return pulumi.get(self, "timeout_server")

    @timeout_server.setter
    def timeout_server(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timeout_server", value)

    @property
    @pulumi.getter(name="timeoutTunnel")
    def timeout_tunnel(self) -> Optional[pulumi.Input[str]]:
        """
        Maximum tunnel inactivity time
        """
        return pulumi.get(self, "timeout_tunnel")

    @timeout_tunnel.setter
    def timeout_tunnel(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timeout_tunnel", value)


class LoadbalancerBackend(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 forward_port: Optional[pulumi.Input[int]] = None,
                 forward_port_algorithm: Optional[pulumi.Input[str]] = None,
                 forward_protocol: Optional[pulumi.Input[str]] = None,
                 health_check_delay: Optional[pulumi.Input[str]] = None,
                 health_check_http: Optional[pulumi.Input[pulumi.InputType['LoadbalancerBackendHealthCheckHttpArgs']]] = None,
                 health_check_https: Optional[pulumi.Input[pulumi.InputType['LoadbalancerBackendHealthCheckHttpsArgs']]] = None,
                 health_check_max_retries: Optional[pulumi.Input[int]] = None,
                 health_check_port: Optional[pulumi.Input[int]] = None,
                 health_check_tcp: Optional[pulumi.Input[pulumi.InputType['LoadbalancerBackendHealthCheckTcpArgs']]] = None,
                 health_check_timeout: Optional[pulumi.Input[str]] = None,
                 lb_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 on_marked_down_action: Optional[pulumi.Input[str]] = None,
                 proxy_protocol: Optional[pulumi.Input[str]] = None,
                 send_proxy_v2: Optional[pulumi.Input[bool]] = None,
                 server_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sticky_sessions: Optional[pulumi.Input[str]] = None,
                 sticky_sessions_cookie_name: Optional[pulumi.Input[str]] = None,
                 timeout_connect: Optional[pulumi.Input[str]] = None,
                 timeout_server: Optional[pulumi.Input[str]] = None,
                 timeout_tunnel: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a LoadbalancerBackend resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] forward_port: User sessions will be forwarded to this port of backend servers
        :param pulumi.Input[str] forward_port_algorithm: Load balancing algorithm
        :param pulumi.Input[str] forward_protocol: Backend protocol
        :param pulumi.Input[str] health_check_delay: Interval between two HC requests
        :param pulumi.Input[int] health_check_max_retries: Number of allowed failed HC requests before the backend server is marked down
        :param pulumi.Input[int] health_check_port: Port the HC requests will be send to. Default to `forward_port`
        :param pulumi.Input[str] health_check_timeout: Timeout before we consider a HC request failed
        :param pulumi.Input[str] lb_id: The load-balancer ID
        :param pulumi.Input[str] name: The name of the backend
        :param pulumi.Input[str] on_marked_down_action: Modify what occurs when a backend server is marked down
        :param pulumi.Input[str] proxy_protocol: Type of PROXY protocol to enable
        :param pulumi.Input[bool] send_proxy_v2: Enables PROXY protocol version 2
        :param pulumi.Input[Sequence[pulumi.Input[str]]] server_ips: Backend server IP addresses list (IPv4 or IPv6)
        :param pulumi.Input[str] sticky_sessions: Load balancing algorithm
        :param pulumi.Input[str] sticky_sessions_cookie_name: Cookie name for for sticky sessions
        :param pulumi.Input[str] timeout_connect: Maximum initial server connection establishment time
        :param pulumi.Input[str] timeout_server: Maximum server connection inactivity time
        :param pulumi.Input[str] timeout_tunnel: Maximum tunnel inactivity time
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LoadbalancerBackendArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a LoadbalancerBackend resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param LoadbalancerBackendArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoadbalancerBackendArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 forward_port: Optional[pulumi.Input[int]] = None,
                 forward_port_algorithm: Optional[pulumi.Input[str]] = None,
                 forward_protocol: Optional[pulumi.Input[str]] = None,
                 health_check_delay: Optional[pulumi.Input[str]] = None,
                 health_check_http: Optional[pulumi.Input[pulumi.InputType['LoadbalancerBackendHealthCheckHttpArgs']]] = None,
                 health_check_https: Optional[pulumi.Input[pulumi.InputType['LoadbalancerBackendHealthCheckHttpsArgs']]] = None,
                 health_check_max_retries: Optional[pulumi.Input[int]] = None,
                 health_check_port: Optional[pulumi.Input[int]] = None,
                 health_check_tcp: Optional[pulumi.Input[pulumi.InputType['LoadbalancerBackendHealthCheckTcpArgs']]] = None,
                 health_check_timeout: Optional[pulumi.Input[str]] = None,
                 lb_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 on_marked_down_action: Optional[pulumi.Input[str]] = None,
                 proxy_protocol: Optional[pulumi.Input[str]] = None,
                 send_proxy_v2: Optional[pulumi.Input[bool]] = None,
                 server_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sticky_sessions: Optional[pulumi.Input[str]] = None,
                 sticky_sessions_cookie_name: Optional[pulumi.Input[str]] = None,
                 timeout_connect: Optional[pulumi.Input[str]] = None,
                 timeout_server: Optional[pulumi.Input[str]] = None,
                 timeout_tunnel: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoadbalancerBackendArgs.__new__(LoadbalancerBackendArgs)

            if forward_port is None and not opts.urn:
                raise TypeError("Missing required property 'forward_port'")
            __props__.__dict__["forward_port"] = forward_port
            __props__.__dict__["forward_port_algorithm"] = forward_port_algorithm
            if forward_protocol is None and not opts.urn:
                raise TypeError("Missing required property 'forward_protocol'")
            __props__.__dict__["forward_protocol"] = forward_protocol
            __props__.__dict__["health_check_delay"] = health_check_delay
            __props__.__dict__["health_check_http"] = health_check_http
            __props__.__dict__["health_check_https"] = health_check_https
            __props__.__dict__["health_check_max_retries"] = health_check_max_retries
            __props__.__dict__["health_check_port"] = health_check_port
            __props__.__dict__["health_check_tcp"] = health_check_tcp
            __props__.__dict__["health_check_timeout"] = health_check_timeout
            if lb_id is None and not opts.urn:
                raise TypeError("Missing required property 'lb_id'")
            __props__.__dict__["lb_id"] = lb_id
            __props__.__dict__["name"] = name
            __props__.__dict__["on_marked_down_action"] = on_marked_down_action
            __props__.__dict__["proxy_protocol"] = proxy_protocol
            if send_proxy_v2 is not None and not opts.urn:
                warnings.warn("""Please use proxy_protocol instead""", DeprecationWarning)
                pulumi.log.warn("""send_proxy_v2 is deprecated: Please use proxy_protocol instead""")
            __props__.__dict__["send_proxy_v2"] = send_proxy_v2
            __props__.__dict__["server_ips"] = server_ips
            __props__.__dict__["sticky_sessions"] = sticky_sessions
            __props__.__dict__["sticky_sessions_cookie_name"] = sticky_sessions_cookie_name
            __props__.__dict__["timeout_connect"] = timeout_connect
            __props__.__dict__["timeout_server"] = timeout_server
            __props__.__dict__["timeout_tunnel"] = timeout_tunnel
        super(LoadbalancerBackend, __self__).__init__(
            'scaleway:index/loadbalancerBackend:LoadbalancerBackend',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            forward_port: Optional[pulumi.Input[int]] = None,
            forward_port_algorithm: Optional[pulumi.Input[str]] = None,
            forward_protocol: Optional[pulumi.Input[str]] = None,
            health_check_delay: Optional[pulumi.Input[str]] = None,
            health_check_http: Optional[pulumi.Input[pulumi.InputType['LoadbalancerBackendHealthCheckHttpArgs']]] = None,
            health_check_https: Optional[pulumi.Input[pulumi.InputType['LoadbalancerBackendHealthCheckHttpsArgs']]] = None,
            health_check_max_retries: Optional[pulumi.Input[int]] = None,
            health_check_port: Optional[pulumi.Input[int]] = None,
            health_check_tcp: Optional[pulumi.Input[pulumi.InputType['LoadbalancerBackendHealthCheckTcpArgs']]] = None,
            health_check_timeout: Optional[pulumi.Input[str]] = None,
            lb_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            on_marked_down_action: Optional[pulumi.Input[str]] = None,
            proxy_protocol: Optional[pulumi.Input[str]] = None,
            send_proxy_v2: Optional[pulumi.Input[bool]] = None,
            server_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            sticky_sessions: Optional[pulumi.Input[str]] = None,
            sticky_sessions_cookie_name: Optional[pulumi.Input[str]] = None,
            timeout_connect: Optional[pulumi.Input[str]] = None,
            timeout_server: Optional[pulumi.Input[str]] = None,
            timeout_tunnel: Optional[pulumi.Input[str]] = None) -> 'LoadbalancerBackend':
        """
        Get an existing LoadbalancerBackend resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] forward_port: User sessions will be forwarded to this port of backend servers
        :param pulumi.Input[str] forward_port_algorithm: Load balancing algorithm
        :param pulumi.Input[str] forward_protocol: Backend protocol
        :param pulumi.Input[str] health_check_delay: Interval between two HC requests
        :param pulumi.Input[int] health_check_max_retries: Number of allowed failed HC requests before the backend server is marked down
        :param pulumi.Input[int] health_check_port: Port the HC requests will be send to. Default to `forward_port`
        :param pulumi.Input[str] health_check_timeout: Timeout before we consider a HC request failed
        :param pulumi.Input[str] lb_id: The load-balancer ID
        :param pulumi.Input[str] name: The name of the backend
        :param pulumi.Input[str] on_marked_down_action: Modify what occurs when a backend server is marked down
        :param pulumi.Input[str] proxy_protocol: Type of PROXY protocol to enable
        :param pulumi.Input[bool] send_proxy_v2: Enables PROXY protocol version 2
        :param pulumi.Input[Sequence[pulumi.Input[str]]] server_ips: Backend server IP addresses list (IPv4 or IPv6)
        :param pulumi.Input[str] sticky_sessions: Load balancing algorithm
        :param pulumi.Input[str] sticky_sessions_cookie_name: Cookie name for for sticky sessions
        :param pulumi.Input[str] timeout_connect: Maximum initial server connection establishment time
        :param pulumi.Input[str] timeout_server: Maximum server connection inactivity time
        :param pulumi.Input[str] timeout_tunnel: Maximum tunnel inactivity time
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoadbalancerBackendState.__new__(_LoadbalancerBackendState)

        __props__.__dict__["forward_port"] = forward_port
        __props__.__dict__["forward_port_algorithm"] = forward_port_algorithm
        __props__.__dict__["forward_protocol"] = forward_protocol
        __props__.__dict__["health_check_delay"] = health_check_delay
        __props__.__dict__["health_check_http"] = health_check_http
        __props__.__dict__["health_check_https"] = health_check_https
        __props__.__dict__["health_check_max_retries"] = health_check_max_retries
        __props__.__dict__["health_check_port"] = health_check_port
        __props__.__dict__["health_check_tcp"] = health_check_tcp
        __props__.__dict__["health_check_timeout"] = health_check_timeout
        __props__.__dict__["lb_id"] = lb_id
        __props__.__dict__["name"] = name
        __props__.__dict__["on_marked_down_action"] = on_marked_down_action
        __props__.__dict__["proxy_protocol"] = proxy_protocol
        __props__.__dict__["send_proxy_v2"] = send_proxy_v2
        __props__.__dict__["server_ips"] = server_ips
        __props__.__dict__["sticky_sessions"] = sticky_sessions
        __props__.__dict__["sticky_sessions_cookie_name"] = sticky_sessions_cookie_name
        __props__.__dict__["timeout_connect"] = timeout_connect
        __props__.__dict__["timeout_server"] = timeout_server
        __props__.__dict__["timeout_tunnel"] = timeout_tunnel
        return LoadbalancerBackend(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="forwardPort")
    def forward_port(self) -> pulumi.Output[int]:
        """
        User sessions will be forwarded to this port of backend servers
        """
        return pulumi.get(self, "forward_port")

    @property
    @pulumi.getter(name="forwardPortAlgorithm")
    def forward_port_algorithm(self) -> pulumi.Output[Optional[str]]:
        """
        Load balancing algorithm
        """
        return pulumi.get(self, "forward_port_algorithm")

    @property
    @pulumi.getter(name="forwardProtocol")
    def forward_protocol(self) -> pulumi.Output[str]:
        """
        Backend protocol
        """
        return pulumi.get(self, "forward_protocol")

    @property
    @pulumi.getter(name="healthCheckDelay")
    def health_check_delay(self) -> pulumi.Output[Optional[str]]:
        """
        Interval between two HC requests
        """
        return pulumi.get(self, "health_check_delay")

    @property
    @pulumi.getter(name="healthCheckHttp")
    def health_check_http(self) -> pulumi.Output[Optional['outputs.LoadbalancerBackendHealthCheckHttp']]:
        return pulumi.get(self, "health_check_http")

    @property
    @pulumi.getter(name="healthCheckHttps")
    def health_check_https(self) -> pulumi.Output[Optional['outputs.LoadbalancerBackendHealthCheckHttps']]:
        return pulumi.get(self, "health_check_https")

    @property
    @pulumi.getter(name="healthCheckMaxRetries")
    def health_check_max_retries(self) -> pulumi.Output[Optional[int]]:
        """
        Number of allowed failed HC requests before the backend server is marked down
        """
        return pulumi.get(self, "health_check_max_retries")

    @property
    @pulumi.getter(name="healthCheckPort")
    def health_check_port(self) -> pulumi.Output[int]:
        """
        Port the HC requests will be send to. Default to `forward_port`
        """
        return pulumi.get(self, "health_check_port")

    @property
    @pulumi.getter(name="healthCheckTcp")
    def health_check_tcp(self) -> pulumi.Output['outputs.LoadbalancerBackendHealthCheckTcp']:
        return pulumi.get(self, "health_check_tcp")

    @property
    @pulumi.getter(name="healthCheckTimeout")
    def health_check_timeout(self) -> pulumi.Output[Optional[str]]:
        """
        Timeout before we consider a HC request failed
        """
        return pulumi.get(self, "health_check_timeout")

    @property
    @pulumi.getter(name="lbId")
    def lb_id(self) -> pulumi.Output[str]:
        """
        The load-balancer ID
        """
        return pulumi.get(self, "lb_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the backend
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="onMarkedDownAction")
    def on_marked_down_action(self) -> pulumi.Output[Optional[str]]:
        """
        Modify what occurs when a backend server is marked down
        """
        return pulumi.get(self, "on_marked_down_action")

    @property
    @pulumi.getter(name="proxyProtocol")
    def proxy_protocol(self) -> pulumi.Output[Optional[str]]:
        """
        Type of PROXY protocol to enable
        """
        return pulumi.get(self, "proxy_protocol")

    @property
    @pulumi.getter(name="sendProxyV2")
    def send_proxy_v2(self) -> pulumi.Output[Optional[bool]]:
        """
        Enables PROXY protocol version 2
        """
        return pulumi.get(self, "send_proxy_v2")

    @property
    @pulumi.getter(name="serverIps")
    def server_ips(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Backend server IP addresses list (IPv4 or IPv6)
        """
        return pulumi.get(self, "server_ips")

    @property
    @pulumi.getter(name="stickySessions")
    def sticky_sessions(self) -> pulumi.Output[Optional[str]]:
        """
        Load balancing algorithm
        """
        return pulumi.get(self, "sticky_sessions")

    @property
    @pulumi.getter(name="stickySessionsCookieName")
    def sticky_sessions_cookie_name(self) -> pulumi.Output[Optional[str]]:
        """
        Cookie name for for sticky sessions
        """
        return pulumi.get(self, "sticky_sessions_cookie_name")

    @property
    @pulumi.getter(name="timeoutConnect")
    def timeout_connect(self) -> pulumi.Output[Optional[str]]:
        """
        Maximum initial server connection establishment time
        """
        return pulumi.get(self, "timeout_connect")

    @property
    @pulumi.getter(name="timeoutServer")
    def timeout_server(self) -> pulumi.Output[Optional[str]]:
        """
        Maximum server connection inactivity time
        """
        return pulumi.get(self, "timeout_server")

    @property
    @pulumi.getter(name="timeoutTunnel")
    def timeout_tunnel(self) -> pulumi.Output[Optional[str]]:
        """
        Maximum tunnel inactivity time
        """
        return pulumi.get(self, "timeout_tunnel")

