# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'BaremetalServerIp',
    'DatabaseAclAclRule',
    'DatabaseInstanceLoadBalancer',
    'DatabaseInstancePrivateNetwork',
    'DatabaseInstanceReadReplica',
    'DomainRecordGeoIp',
    'DomainRecordGeoIpMatch',
    'DomainRecordHttpService',
    'DomainRecordView',
    'DomainRecordWeighted',
    'InstanceSecurityGroupInboundRule',
    'InstanceSecurityGroupOutboundRule',
    'InstanceSecurityGroupRulesInboundRule',
    'InstanceSecurityGroupRulesOutboundRule',
    'InstanceServerPrivateNetwork',
    'InstanceServerRootVolume',
    'IotDeviceCertificate',
    'IotDeviceMessageFilters',
    'IotDeviceMessageFiltersPublish',
    'IotDeviceMessageFiltersSubscribe',
    'IotRouteDatabase',
    'IotRouteRest',
    'IotRouteS3',
    'KubernetesClusterAutoUpgrade',
    'KubernetesClusterAutoscalerConfig',
    'KubernetesClusterKubeconfig',
    'KubernetesClusterOpenIdConnectConfig',
    'KubernetesNodePoolNode',
    'KubernetesNodePoolUpgradePolicy',
    'LoadbalancerBackendHealthCheckHttp',
    'LoadbalancerBackendHealthCheckHttps',
    'LoadbalancerBackendHealthCheckTcp',
    'LoadbalancerCertificateCustomCertificate',
    'LoadbalancerCertificateLetsencrypt',
    'LoadbalancerFrontendAcl',
    'LoadbalancerFrontendAclAction',
    'LoadbalancerFrontendAclMatch',
    'LoadbalancerPrivateNetwork',
    'ObjectBucketCorsRule',
    'ObjectBucketLifecycleRule',
    'ObjectBucketLifecycleRuleExpiration',
    'ObjectBucketLifecycleRuleTransition',
    'ObjectBucketVersioning',
    'RedisClusterAcl',
    'GetBaremetalOfferCpuResult',
    'GetBaremetalOfferDiskResult',
    'GetBaremetalOfferMemoryResult',
    'GetBaremetalServerIpResult',
    'GetDatabaseAclAclRuleResult',
    'GetDatabaseInstanceLoadBalancerResult',
    'GetDatabaseInstancePrivateNetworkResult',
    'GetDatabaseInstanceReadReplicaResult',
    'GetDomainRecordGeoIpResult',
    'GetDomainRecordGeoIpMatchResult',
    'GetDomainRecordHttpServiceResult',
    'GetDomainRecordViewResult',
    'GetDomainRecordWeightedResult',
    'GetInstanceSecurityGroupInboundRuleResult',
    'GetInstanceSecurityGroupOutboundRuleResult',
    'GetInstanceServerPrivateNetworkResult',
    'GetInstanceServerRootVolumeResult',
    'GetIotDeviceCertificateResult',
    'GetIotDeviceMessageFilterResult',
    'GetIotDeviceMessageFilterPublishResult',
    'GetIotDeviceMessageFilterSubscribeResult',
    'GetKubernetesClusterAutoUpgradeResult',
    'GetKubernetesClusterAutoscalerConfigResult',
    'GetKubernetesClusterKubeconfigResult',
    'GetKubernetesClusterOpenIdConnectConfigResult',
    'GetKubernetesNodePoolNodeResult',
    'GetKubernetesNodePoolUpgradePolicyResult',
    'GetLoadbalancerCertificateCustomCertificateResult',
    'GetLoadbalancerCertificateLetsencryptResult',
    'GetLoadbalancerPrivateNetworkResult',
    'GetObjectBucketCorsRuleResult',
    'GetObjectBucketLifecycleRuleResult',
    'GetObjectBucketLifecycleRuleExpirationResult',
    'GetObjectBucketLifecycleRuleTransitionResult',
    'GetObjectBucketVersioningResult',
    'GetRedisClusterAclResult',
]

@pulumi.output_type
class BaremetalServerIp(dict):
    def __init__(__self__, *,
                 address: Optional[str] = None,
                 id: Optional[str] = None,
                 reverse: Optional[str] = None,
                 version: Optional[str] = None):
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if reverse is not None:
            pulumi.set(__self__, "reverse", reverse)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def address(self) -> Optional[str]:
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def reverse(self) -> Optional[str]:
        return pulumi.get(self, "reverse")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        return pulumi.get(self, "version")


@pulumi.output_type
class DatabaseAclAclRule(dict):
    def __init__(__self__, *,
                 ip: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "ip", ip)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def ip(self) -> str:
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class DatabaseInstanceLoadBalancer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointId":
            suggest = "endpoint_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceLoadBalancer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceLoadBalancer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceLoadBalancer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_id: Optional[str] = None,
                 hostname: Optional[str] = None,
                 ip: Optional[str] = None,
                 name: Optional[str] = None,
                 port: Optional[int] = None):
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[str]:
        return pulumi.get(self, "endpoint_id")

    @property
    @pulumi.getter
    def hostname(self) -> Optional[str]:
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def ip(self) -> Optional[str]:
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        return pulumi.get(self, "port")


@pulumi.output_type
class DatabaseInstancePrivateNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipNet":
            suggest = "ip_net"
        elif key == "pnId":
            suggest = "pn_id"
        elif key == "endpointId":
            suggest = "endpoint_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstancePrivateNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstancePrivateNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstancePrivateNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_net: str,
                 pn_id: str,
                 endpoint_id: Optional[str] = None,
                 hostname: Optional[str] = None,
                 ip: Optional[str] = None,
                 name: Optional[str] = None,
                 port: Optional[int] = None,
                 zone: Optional[str] = None):
        pulumi.set(__self__, "ip_net", ip_net)
        pulumi.set(__self__, "pn_id", pn_id)
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="ipNet")
    def ip_net(self) -> str:
        return pulumi.get(self, "ip_net")

    @property
    @pulumi.getter(name="pnId")
    def pn_id(self) -> str:
        return pulumi.get(self, "pn_id")

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[str]:
        return pulumi.get(self, "endpoint_id")

    @property
    @pulumi.getter
    def hostname(self) -> Optional[str]:
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def ip(self) -> Optional[str]:
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def zone(self) -> Optional[str]:
        return pulumi.get(self, "zone")


@pulumi.output_type
class DatabaseInstanceReadReplica(dict):
    def __init__(__self__, *,
                 ip: Optional[str] = None,
                 name: Optional[str] = None,
                 port: Optional[int] = None):
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def ip(self) -> Optional[str]:
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        return pulumi.get(self, "port")


@pulumi.output_type
class DomainRecordGeoIp(dict):
    def __init__(__self__, *,
                 matches: Sequence['outputs.DomainRecordGeoIpMatch']):
        pulumi.set(__self__, "matches", matches)

    @property
    @pulumi.getter
    def matches(self) -> Sequence['outputs.DomainRecordGeoIpMatch']:
        return pulumi.get(self, "matches")


@pulumi.output_type
class DomainRecordGeoIpMatch(dict):
    def __init__(__self__, *,
                 data: str,
                 continents: Optional[Sequence[str]] = None,
                 countries: Optional[Sequence[str]] = None):
        pulumi.set(__self__, "data", data)
        if continents is not None:
            pulumi.set(__self__, "continents", continents)
        if countries is not None:
            pulumi.set(__self__, "countries", countries)

    @property
    @pulumi.getter
    def data(self) -> str:
        return pulumi.get(self, "data")

    @property
    @pulumi.getter
    def continents(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "continents")

    @property
    @pulumi.getter
    def countries(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "countries")


@pulumi.output_type
class DomainRecordHttpService(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mustContain":
            suggest = "must_contain"
        elif key == "userAgent":
            suggest = "user_agent"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainRecordHttpService. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainRecordHttpService.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainRecordHttpService.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ips: Sequence[str],
                 must_contain: str,
                 strategy: str,
                 url: str,
                 user_agent: Optional[str] = None):
        pulumi.set(__self__, "ips", ips)
        pulumi.set(__self__, "must_contain", must_contain)
        pulumi.set(__self__, "strategy", strategy)
        pulumi.set(__self__, "url", url)
        if user_agent is not None:
            pulumi.set(__self__, "user_agent", user_agent)

    @property
    @pulumi.getter
    def ips(self) -> Sequence[str]:
        return pulumi.get(self, "ips")

    @property
    @pulumi.getter(name="mustContain")
    def must_contain(self) -> str:
        return pulumi.get(self, "must_contain")

    @property
    @pulumi.getter
    def strategy(self) -> str:
        return pulumi.get(self, "strategy")

    @property
    @pulumi.getter
    def url(self) -> str:
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="userAgent")
    def user_agent(self) -> Optional[str]:
        return pulumi.get(self, "user_agent")


@pulumi.output_type
class DomainRecordView(dict):
    def __init__(__self__, *,
                 data: str,
                 subnet: str):
        pulumi.set(__self__, "data", data)
        pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter
    def data(self) -> str:
        return pulumi.get(self, "data")

    @property
    @pulumi.getter
    def subnet(self) -> str:
        return pulumi.get(self, "subnet")


@pulumi.output_type
class DomainRecordWeighted(dict):
    def __init__(__self__, *,
                 ip: str,
                 weight: int):
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def ip(self) -> str:
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def weight(self) -> int:
        return pulumi.get(self, "weight")


@pulumi.output_type
class InstanceSecurityGroupInboundRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipRange":
            suggest = "ip_range"
        elif key == "portRange":
            suggest = "port_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceSecurityGroupInboundRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceSecurityGroupInboundRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceSecurityGroupInboundRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: str,
                 ip: Optional[str] = None,
                 ip_range: Optional[str] = None,
                 port: Optional[int] = None,
                 port_range: Optional[str] = None,
                 protocol: Optional[str] = None):
        pulumi.set(__self__, "action", action)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ip_range is not None:
            pulumi.set(__self__, "ip_range", ip_range)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def action(self) -> str:
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def ip(self) -> Optional[str]:
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> Optional[str]:
        return pulumi.get(self, "ip_range")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[str]:
        return pulumi.get(self, "port_range")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        return pulumi.get(self, "protocol")


@pulumi.output_type
class InstanceSecurityGroupOutboundRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipRange":
            suggest = "ip_range"
        elif key == "portRange":
            suggest = "port_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceSecurityGroupOutboundRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceSecurityGroupOutboundRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceSecurityGroupOutboundRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: str,
                 ip: Optional[str] = None,
                 ip_range: Optional[str] = None,
                 port: Optional[int] = None,
                 port_range: Optional[str] = None,
                 protocol: Optional[str] = None):
        pulumi.set(__self__, "action", action)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ip_range is not None:
            pulumi.set(__self__, "ip_range", ip_range)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def action(self) -> str:
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def ip(self) -> Optional[str]:
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> Optional[str]:
        return pulumi.get(self, "ip_range")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[str]:
        return pulumi.get(self, "port_range")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        return pulumi.get(self, "protocol")


@pulumi.output_type
class InstanceSecurityGroupRulesInboundRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipRange":
            suggest = "ip_range"
        elif key == "portRange":
            suggest = "port_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceSecurityGroupRulesInboundRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceSecurityGroupRulesInboundRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceSecurityGroupRulesInboundRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: str,
                 ip: Optional[str] = None,
                 ip_range: Optional[str] = None,
                 port: Optional[int] = None,
                 port_range: Optional[str] = None,
                 protocol: Optional[str] = None):
        pulumi.set(__self__, "action", action)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ip_range is not None:
            pulumi.set(__self__, "ip_range", ip_range)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def action(self) -> str:
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def ip(self) -> Optional[str]:
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> Optional[str]:
        return pulumi.get(self, "ip_range")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[str]:
        return pulumi.get(self, "port_range")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        return pulumi.get(self, "protocol")


@pulumi.output_type
class InstanceSecurityGroupRulesOutboundRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipRange":
            suggest = "ip_range"
        elif key == "portRange":
            suggest = "port_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceSecurityGroupRulesOutboundRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceSecurityGroupRulesOutboundRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceSecurityGroupRulesOutboundRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: str,
                 ip: Optional[str] = None,
                 ip_range: Optional[str] = None,
                 port: Optional[int] = None,
                 port_range: Optional[str] = None,
                 protocol: Optional[str] = None):
        pulumi.set(__self__, "action", action)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ip_range is not None:
            pulumi.set(__self__, "ip_range", ip_range)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def action(self) -> str:
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def ip(self) -> Optional[str]:
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> Optional[str]:
        return pulumi.get(self, "ip_range")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[str]:
        return pulumi.get(self, "port_range")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        return pulumi.get(self, "protocol")


@pulumi.output_type
class InstanceServerPrivateNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pnId":
            suggest = "pn_id"
        elif key == "macAddress":
            suggest = "mac_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceServerPrivateNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceServerPrivateNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceServerPrivateNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pn_id: str,
                 mac_address: Optional[str] = None,
                 status: Optional[str] = None,
                 zone: Optional[str] = None):
        pulumi.set(__self__, "pn_id", pn_id)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="pnId")
    def pn_id(self) -> str:
        return pulumi.get(self, "pn_id")

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[str]:
        return pulumi.get(self, "mac_address")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def zone(self) -> Optional[str]:
        return pulumi.get(self, "zone")


@pulumi.output_type
class InstanceServerRootVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deleteOnTermination":
            suggest = "delete_on_termination"
        elif key == "sizeInGb":
            suggest = "size_in_gb"
        elif key == "volumeId":
            suggest = "volume_id"
        elif key == "volumeType":
            suggest = "volume_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceServerRootVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceServerRootVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceServerRootVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 boot: Optional[bool] = None,
                 delete_on_termination: Optional[bool] = None,
                 size_in_gb: Optional[int] = None,
                 volume_id: Optional[str] = None,
                 volume_type: Optional[str] = None):
        if boot is not None:
            pulumi.set(__self__, "boot", boot)
        if delete_on_termination is not None:
            pulumi.set(__self__, "delete_on_termination", delete_on_termination)
        if size_in_gb is not None:
            pulumi.set(__self__, "size_in_gb", size_in_gb)
        if volume_id is not None:
            pulumi.set(__self__, "volume_id", volume_id)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter
    def boot(self) -> Optional[bool]:
        return pulumi.get(self, "boot")

    @property
    @pulumi.getter(name="deleteOnTermination")
    def delete_on_termination(self) -> Optional[bool]:
        return pulumi.get(self, "delete_on_termination")

    @property
    @pulumi.getter(name="sizeInGb")
    def size_in_gb(self) -> Optional[int]:
        return pulumi.get(self, "size_in_gb")

    @property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> Optional[str]:
        return pulumi.get(self, "volume_id")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[str]:
        return pulumi.get(self, "volume_type")


@pulumi.output_type
class IotDeviceCertificate(dict):
    def __init__(__self__, *,
                 crt: Optional[str] = None,
                 key: Optional[str] = None):
        if crt is not None:
            pulumi.set(__self__, "crt", crt)
        if key is not None:
            pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def crt(self) -> Optional[str]:
        return pulumi.get(self, "crt")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        return pulumi.get(self, "key")


@pulumi.output_type
class IotDeviceMessageFilters(dict):
    def __init__(__self__, *,
                 publish: Optional['outputs.IotDeviceMessageFiltersPublish'] = None,
                 subscribe: Optional['outputs.IotDeviceMessageFiltersSubscribe'] = None):
        if publish is not None:
            pulumi.set(__self__, "publish", publish)
        if subscribe is not None:
            pulumi.set(__self__, "subscribe", subscribe)

    @property
    @pulumi.getter
    def publish(self) -> Optional['outputs.IotDeviceMessageFiltersPublish']:
        return pulumi.get(self, "publish")

    @property
    @pulumi.getter
    def subscribe(self) -> Optional['outputs.IotDeviceMessageFiltersSubscribe']:
        return pulumi.get(self, "subscribe")


@pulumi.output_type
class IotDeviceMessageFiltersPublish(dict):
    def __init__(__self__, *,
                 policy: Optional[str] = None,
                 topics: Optional[Sequence[str]] = None):
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if topics is not None:
            pulumi.set(__self__, "topics", topics)

    @property
    @pulumi.getter
    def policy(self) -> Optional[str]:
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter
    def topics(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "topics")


@pulumi.output_type
class IotDeviceMessageFiltersSubscribe(dict):
    def __init__(__self__, *,
                 policy: Optional[str] = None,
                 topics: Optional[Sequence[str]] = None):
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if topics is not None:
            pulumi.set(__self__, "topics", topics)

    @property
    @pulumi.getter
    def policy(self) -> Optional[str]:
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter
    def topics(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "topics")


@pulumi.output_type
class IotRouteDatabase(dict):
    def __init__(__self__, *,
                 dbname: str,
                 host: str,
                 password: str,
                 port: int,
                 query: str,
                 username: str):
        pulumi.set(__self__, "dbname", dbname)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def dbname(self) -> str:
        return pulumi.get(self, "dbname")

    @property
    @pulumi.getter
    def host(self) -> str:
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def port(self) -> int:
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def query(self) -> str:
        return pulumi.get(self, "query")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")


@pulumi.output_type
class IotRouteRest(dict):
    def __init__(__self__, *,
                 headers: Mapping[str, str],
                 uri: str,
                 verb: str):
        pulumi.set(__self__, "headers", headers)
        pulumi.set(__self__, "uri", uri)
        pulumi.set(__self__, "verb", verb)

    @property
    @pulumi.getter
    def headers(self) -> Mapping[str, str]:
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter
    def uri(self) -> str:
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter
    def verb(self) -> str:
        return pulumi.get(self, "verb")


@pulumi.output_type
class IotRouteS3(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "bucketRegion":
            suggest = "bucket_region"
        elif key == "objectPrefix":
            suggest = "object_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IotRouteS3. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IotRouteS3.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IotRouteS3.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: str,
                 bucket_region: str,
                 strategy: str,
                 object_prefix: Optional[str] = None):
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "bucket_region", bucket_region)
        pulumi.set(__self__, "strategy", strategy)
        if object_prefix is not None:
            pulumi.set(__self__, "object_prefix", object_prefix)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter(name="bucketRegion")
    def bucket_region(self) -> str:
        return pulumi.get(self, "bucket_region")

    @property
    @pulumi.getter
    def strategy(self) -> str:
        return pulumi.get(self, "strategy")

    @property
    @pulumi.getter(name="objectPrefix")
    def object_prefix(self) -> Optional[str]:
        return pulumi.get(self, "object_prefix")


@pulumi.output_type
class KubernetesClusterAutoUpgrade(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maintenanceWindowDay":
            suggest = "maintenance_window_day"
        elif key == "maintenanceWindowStartHour":
            suggest = "maintenance_window_start_hour"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesClusterAutoUpgrade. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesClusterAutoUpgrade.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesClusterAutoUpgrade.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable: bool,
                 maintenance_window_day: str,
                 maintenance_window_start_hour: int):
        pulumi.set(__self__, "enable", enable)
        pulumi.set(__self__, "maintenance_window_day", maintenance_window_day)
        pulumi.set(__self__, "maintenance_window_start_hour", maintenance_window_start_hour)

    @property
    @pulumi.getter
    def enable(self) -> bool:
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter(name="maintenanceWindowDay")
    def maintenance_window_day(self) -> str:
        return pulumi.get(self, "maintenance_window_day")

    @property
    @pulumi.getter(name="maintenanceWindowStartHour")
    def maintenance_window_start_hour(self) -> int:
        return pulumi.get(self, "maintenance_window_start_hour")


@pulumi.output_type
class KubernetesClusterAutoscalerConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "balanceSimilarNodeGroups":
            suggest = "balance_similar_node_groups"
        elif key == "disableScaleDown":
            suggest = "disable_scale_down"
        elif key == "expendablePodsPriorityCutoff":
            suggest = "expendable_pods_priority_cutoff"
        elif key == "ignoreDaemonsetsUtilization":
            suggest = "ignore_daemonsets_utilization"
        elif key == "maxGracefulTerminationSec":
            suggest = "max_graceful_termination_sec"
        elif key == "scaleDownDelayAfterAdd":
            suggest = "scale_down_delay_after_add"
        elif key == "scaleDownUnneededTime":
            suggest = "scale_down_unneeded_time"
        elif key == "scaleDownUtilizationThreshold":
            suggest = "scale_down_utilization_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesClusterAutoscalerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesClusterAutoscalerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesClusterAutoscalerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 balance_similar_node_groups: Optional[bool] = None,
                 disable_scale_down: Optional[bool] = None,
                 estimator: Optional[str] = None,
                 expander: Optional[str] = None,
                 expendable_pods_priority_cutoff: Optional[int] = None,
                 ignore_daemonsets_utilization: Optional[bool] = None,
                 max_graceful_termination_sec: Optional[int] = None,
                 scale_down_delay_after_add: Optional[str] = None,
                 scale_down_unneeded_time: Optional[str] = None,
                 scale_down_utilization_threshold: Optional[float] = None):
        if balance_similar_node_groups is not None:
            pulumi.set(__self__, "balance_similar_node_groups", balance_similar_node_groups)
        if disable_scale_down is not None:
            pulumi.set(__self__, "disable_scale_down", disable_scale_down)
        if estimator is not None:
            pulumi.set(__self__, "estimator", estimator)
        if expander is not None:
            pulumi.set(__self__, "expander", expander)
        if expendable_pods_priority_cutoff is not None:
            pulumi.set(__self__, "expendable_pods_priority_cutoff", expendable_pods_priority_cutoff)
        if ignore_daemonsets_utilization is not None:
            pulumi.set(__self__, "ignore_daemonsets_utilization", ignore_daemonsets_utilization)
        if max_graceful_termination_sec is not None:
            pulumi.set(__self__, "max_graceful_termination_sec", max_graceful_termination_sec)
        if scale_down_delay_after_add is not None:
            pulumi.set(__self__, "scale_down_delay_after_add", scale_down_delay_after_add)
        if scale_down_unneeded_time is not None:
            pulumi.set(__self__, "scale_down_unneeded_time", scale_down_unneeded_time)
        if scale_down_utilization_threshold is not None:
            pulumi.set(__self__, "scale_down_utilization_threshold", scale_down_utilization_threshold)

    @property
    @pulumi.getter(name="balanceSimilarNodeGroups")
    def balance_similar_node_groups(self) -> Optional[bool]:
        return pulumi.get(self, "balance_similar_node_groups")

    @property
    @pulumi.getter(name="disableScaleDown")
    def disable_scale_down(self) -> Optional[bool]:
        return pulumi.get(self, "disable_scale_down")

    @property
    @pulumi.getter
    def estimator(self) -> Optional[str]:
        return pulumi.get(self, "estimator")

    @property
    @pulumi.getter
    def expander(self) -> Optional[str]:
        return pulumi.get(self, "expander")

    @property
    @pulumi.getter(name="expendablePodsPriorityCutoff")
    def expendable_pods_priority_cutoff(self) -> Optional[int]:
        return pulumi.get(self, "expendable_pods_priority_cutoff")

    @property
    @pulumi.getter(name="ignoreDaemonsetsUtilization")
    def ignore_daemonsets_utilization(self) -> Optional[bool]:
        return pulumi.get(self, "ignore_daemonsets_utilization")

    @property
    @pulumi.getter(name="maxGracefulTerminationSec")
    def max_graceful_termination_sec(self) -> Optional[int]:
        return pulumi.get(self, "max_graceful_termination_sec")

    @property
    @pulumi.getter(name="scaleDownDelayAfterAdd")
    def scale_down_delay_after_add(self) -> Optional[str]:
        return pulumi.get(self, "scale_down_delay_after_add")

    @property
    @pulumi.getter(name="scaleDownUnneededTime")
    def scale_down_unneeded_time(self) -> Optional[str]:
        return pulumi.get(self, "scale_down_unneeded_time")

    @property
    @pulumi.getter(name="scaleDownUtilizationThreshold")
    def scale_down_utilization_threshold(self) -> Optional[float]:
        return pulumi.get(self, "scale_down_utilization_threshold")


@pulumi.output_type
class KubernetesClusterKubeconfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterCaCertificate":
            suggest = "cluster_ca_certificate"
        elif key == "configFile":
            suggest = "config_file"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesClusterKubeconfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesClusterKubeconfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesClusterKubeconfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_ca_certificate: Optional[str] = None,
                 config_file: Optional[str] = None,
                 host: Optional[str] = None,
                 token: Optional[str] = None):
        if cluster_ca_certificate is not None:
            pulumi.set(__self__, "cluster_ca_certificate", cluster_ca_certificate)
        if config_file is not None:
            pulumi.set(__self__, "config_file", config_file)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if token is not None:
            pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter(name="clusterCaCertificate")
    def cluster_ca_certificate(self) -> Optional[str]:
        return pulumi.get(self, "cluster_ca_certificate")

    @property
    @pulumi.getter(name="configFile")
    def config_file(self) -> Optional[str]:
        return pulumi.get(self, "config_file")

    @property
    @pulumi.getter
    def host(self) -> Optional[str]:
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def token(self) -> Optional[str]:
        return pulumi.get(self, "token")


@pulumi.output_type
class KubernetesClusterOpenIdConnectConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "issuerUrl":
            suggest = "issuer_url"
        elif key == "groupsClaims":
            suggest = "groups_claims"
        elif key == "groupsPrefix":
            suggest = "groups_prefix"
        elif key == "requiredClaims":
            suggest = "required_claims"
        elif key == "usernameClaim":
            suggest = "username_claim"
        elif key == "usernamePrefix":
            suggest = "username_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesClusterOpenIdConnectConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesClusterOpenIdConnectConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesClusterOpenIdConnectConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 issuer_url: str,
                 groups_claims: Optional[Sequence[str]] = None,
                 groups_prefix: Optional[str] = None,
                 required_claims: Optional[Sequence[str]] = None,
                 username_claim: Optional[str] = None,
                 username_prefix: Optional[str] = None):
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "issuer_url", issuer_url)
        if groups_claims is not None:
            pulumi.set(__self__, "groups_claims", groups_claims)
        if groups_prefix is not None:
            pulumi.set(__self__, "groups_prefix", groups_prefix)
        if required_claims is not None:
            pulumi.set(__self__, "required_claims", required_claims)
        if username_claim is not None:
            pulumi.set(__self__, "username_claim", username_claim)
        if username_prefix is not None:
            pulumi.set(__self__, "username_prefix", username_prefix)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="issuerUrl")
    def issuer_url(self) -> str:
        return pulumi.get(self, "issuer_url")

    @property
    @pulumi.getter(name="groupsClaims")
    def groups_claims(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "groups_claims")

    @property
    @pulumi.getter(name="groupsPrefix")
    def groups_prefix(self) -> Optional[str]:
        return pulumi.get(self, "groups_prefix")

    @property
    @pulumi.getter(name="requiredClaims")
    def required_claims(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "required_claims")

    @property
    @pulumi.getter(name="usernameClaim")
    def username_claim(self) -> Optional[str]:
        return pulumi.get(self, "username_claim")

    @property
    @pulumi.getter(name="usernamePrefix")
    def username_prefix(self) -> Optional[str]:
        return pulumi.get(self, "username_prefix")


@pulumi.output_type
class KubernetesNodePoolNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicIp":
            suggest = "public_ip"
        elif key == "publicIpV6":
            suggest = "public_ip_v6"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesNodePoolNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesNodePoolNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesNodePoolNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 public_ip: Optional[str] = None,
                 public_ip_v6: Optional[str] = None,
                 status: Optional[str] = None):
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if public_ip_v6 is not None:
            pulumi.set(__self__, "public_ip_v6", public_ip_v6)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[str]:
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter(name="publicIpV6")
    def public_ip_v6(self) -> Optional[str]:
        return pulumi.get(self, "public_ip_v6")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        return pulumi.get(self, "status")


@pulumi.output_type
class KubernetesNodePoolUpgradePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxSurge":
            suggest = "max_surge"
        elif key == "maxUnavailable":
            suggest = "max_unavailable"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesNodePoolUpgradePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesNodePoolUpgradePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesNodePoolUpgradePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_surge: Optional[int] = None,
                 max_unavailable: Optional[int] = None):
        if max_surge is not None:
            pulumi.set(__self__, "max_surge", max_surge)
        if max_unavailable is not None:
            pulumi.set(__self__, "max_unavailable", max_unavailable)

    @property
    @pulumi.getter(name="maxSurge")
    def max_surge(self) -> Optional[int]:
        return pulumi.get(self, "max_surge")

    @property
    @pulumi.getter(name="maxUnavailable")
    def max_unavailable(self) -> Optional[int]:
        return pulumi.get(self, "max_unavailable")


@pulumi.output_type
class LoadbalancerBackendHealthCheckHttp(dict):
    def __init__(__self__, *,
                 uri: str,
                 code: Optional[int] = None,
                 method: Optional[str] = None):
        pulumi.set(__self__, "uri", uri)
        if code is not None:
            pulumi.set(__self__, "code", code)
        if method is not None:
            pulumi.set(__self__, "method", method)

    @property
    @pulumi.getter
    def uri(self) -> str:
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter
    def code(self) -> Optional[int]:
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def method(self) -> Optional[str]:
        return pulumi.get(self, "method")


@pulumi.output_type
class LoadbalancerBackendHealthCheckHttps(dict):
    def __init__(__self__, *,
                 uri: str,
                 code: Optional[int] = None,
                 method: Optional[str] = None):
        pulumi.set(__self__, "uri", uri)
        if code is not None:
            pulumi.set(__self__, "code", code)
        if method is not None:
            pulumi.set(__self__, "method", method)

    @property
    @pulumi.getter
    def uri(self) -> str:
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter
    def code(self) -> Optional[int]:
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def method(self) -> Optional[str]:
        return pulumi.get(self, "method")


@pulumi.output_type
class LoadbalancerBackendHealthCheckTcp(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class LoadbalancerCertificateCustomCertificate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateChain":
            suggest = "certificate_chain"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadbalancerCertificateCustomCertificate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadbalancerCertificateCustomCertificate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadbalancerCertificateCustomCertificate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_chain: str):
        pulumi.set(__self__, "certificate_chain", certificate_chain)

    @property
    @pulumi.getter(name="certificateChain")
    def certificate_chain(self) -> str:
        return pulumi.get(self, "certificate_chain")


@pulumi.output_type
class LoadbalancerCertificateLetsencrypt(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commonName":
            suggest = "common_name"
        elif key == "subjectAlternativeNames":
            suggest = "subject_alternative_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadbalancerCertificateLetsencrypt. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadbalancerCertificateLetsencrypt.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadbalancerCertificateLetsencrypt.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 common_name: str,
                 subject_alternative_names: Optional[Sequence[str]] = None):
        pulumi.set(__self__, "common_name", common_name)
        if subject_alternative_names is not None:
            pulumi.set(__self__, "subject_alternative_names", subject_alternative_names)

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> str:
        return pulumi.get(self, "common_name")

    @property
    @pulumi.getter(name="subjectAlternativeNames")
    def subject_alternative_names(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "subject_alternative_names")


@pulumi.output_type
class LoadbalancerFrontendAcl(dict):
    def __init__(__self__, *,
                 action: 'outputs.LoadbalancerFrontendAclAction',
                 match: 'outputs.LoadbalancerFrontendAclMatch',
                 name: Optional[str] = None):
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "match", match)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def action(self) -> 'outputs.LoadbalancerFrontendAclAction':
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def match(self) -> 'outputs.LoadbalancerFrontendAclMatch':
        return pulumi.get(self, "match")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")


@pulumi.output_type
class LoadbalancerFrontendAclAction(dict):
    def __init__(__self__, *,
                 type: str):
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")


@pulumi.output_type
class LoadbalancerFrontendAclMatch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpFilter":
            suggest = "http_filter"
        elif key == "httpFilterOption":
            suggest = "http_filter_option"
        elif key == "httpFilterValues":
            suggest = "http_filter_values"
        elif key == "ipSubnets":
            suggest = "ip_subnets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadbalancerFrontendAclMatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadbalancerFrontendAclMatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadbalancerFrontendAclMatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_filter: Optional[str] = None,
                 http_filter_option: Optional[str] = None,
                 http_filter_values: Optional[Sequence[str]] = None,
                 invert: Optional[bool] = None,
                 ip_subnets: Optional[Sequence[str]] = None):
        if http_filter is not None:
            pulumi.set(__self__, "http_filter", http_filter)
        if http_filter_option is not None:
            pulumi.set(__self__, "http_filter_option", http_filter_option)
        if http_filter_values is not None:
            pulumi.set(__self__, "http_filter_values", http_filter_values)
        if invert is not None:
            pulumi.set(__self__, "invert", invert)
        if ip_subnets is not None:
            pulumi.set(__self__, "ip_subnets", ip_subnets)

    @property
    @pulumi.getter(name="httpFilter")
    def http_filter(self) -> Optional[str]:
        return pulumi.get(self, "http_filter")

    @property
    @pulumi.getter(name="httpFilterOption")
    def http_filter_option(self) -> Optional[str]:
        return pulumi.get(self, "http_filter_option")

    @property
    @pulumi.getter(name="httpFilterValues")
    def http_filter_values(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "http_filter_values")

    @property
    @pulumi.getter
    def invert(self) -> Optional[bool]:
        return pulumi.get(self, "invert")

    @property
    @pulumi.getter(name="ipSubnets")
    def ip_subnets(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "ip_subnets")


@pulumi.output_type
class LoadbalancerPrivateNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateNetworkId":
            suggest = "private_network_id"
        elif key == "dhcpConfig":
            suggest = "dhcp_config"
        elif key == "staticConfigs":
            suggest = "static_configs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadbalancerPrivateNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadbalancerPrivateNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadbalancerPrivateNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_network_id: str,
                 dhcp_config: Optional[bool] = None,
                 static_configs: Optional[Sequence[str]] = None,
                 status: Optional[str] = None,
                 zone: Optional[str] = None):
        pulumi.set(__self__, "private_network_id", private_network_id)
        if dhcp_config is not None:
            pulumi.set(__self__, "dhcp_config", dhcp_config)
        if static_configs is not None:
            pulumi.set(__self__, "static_configs", static_configs)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> str:
        return pulumi.get(self, "private_network_id")

    @property
    @pulumi.getter(name="dhcpConfig")
    def dhcp_config(self) -> Optional[bool]:
        return pulumi.get(self, "dhcp_config")

    @property
    @pulumi.getter(name="staticConfigs")
    def static_configs(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "static_configs")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def zone(self) -> Optional[str]:
        return pulumi.get(self, "zone")


@pulumi.output_type
class ObjectBucketCorsRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedMethods":
            suggest = "allowed_methods"
        elif key == "allowedOrigins":
            suggest = "allowed_origins"
        elif key == "allowedHeaders":
            suggest = "allowed_headers"
        elif key == "exposeHeaders":
            suggest = "expose_headers"
        elif key == "maxAgeSeconds":
            suggest = "max_age_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectBucketCorsRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectBucketCorsRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectBucketCorsRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_methods: Sequence[str],
                 allowed_origins: Sequence[str],
                 allowed_headers: Optional[Sequence[str]] = None,
                 expose_headers: Optional[Sequence[str]] = None,
                 max_age_seconds: Optional[int] = None):
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        if allowed_headers is not None:
            pulumi.set(__self__, "allowed_headers", allowed_headers)
        if expose_headers is not None:
            pulumi.set(__self__, "expose_headers", expose_headers)
        if max_age_seconds is not None:
            pulumi.set(__self__, "max_age_seconds", max_age_seconds)

    @property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Sequence[str]:
        return pulumi.get(self, "allowed_methods")

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Sequence[str]:
        return pulumi.get(self, "allowed_origins")

    @property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "allowed_headers")

    @property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "expose_headers")

    @property
    @pulumi.getter(name="maxAgeSeconds")
    def max_age_seconds(self) -> Optional[int]:
        return pulumi.get(self, "max_age_seconds")


@pulumi.output_type
class ObjectBucketLifecycleRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "abortIncompleteMultipartUploadDays":
            suggest = "abort_incomplete_multipart_upload_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectBucketLifecycleRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectBucketLifecycleRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectBucketLifecycleRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 abort_incomplete_multipart_upload_days: Optional[int] = None,
                 expiration: Optional['outputs.ObjectBucketLifecycleRuleExpiration'] = None,
                 id: Optional[str] = None,
                 prefix: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None,
                 transitions: Optional[Sequence['outputs.ObjectBucketLifecycleRuleTransition']] = None):
        pulumi.set(__self__, "enabled", enabled)
        if abort_incomplete_multipart_upload_days is not None:
            pulumi.set(__self__, "abort_incomplete_multipart_upload_days", abort_incomplete_multipart_upload_days)
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if transitions is not None:
            pulumi.set(__self__, "transitions", transitions)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="abortIncompleteMultipartUploadDays")
    def abort_incomplete_multipart_upload_days(self) -> Optional[int]:
        return pulumi.get(self, "abort_incomplete_multipart_upload_days")

    @property
    @pulumi.getter
    def expiration(self) -> Optional['outputs.ObjectBucketLifecycleRuleExpiration']:
        return pulumi.get(self, "expiration")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def transitions(self) -> Optional[Sequence['outputs.ObjectBucketLifecycleRuleTransition']]:
        return pulumi.get(self, "transitions")


@pulumi.output_type
class ObjectBucketLifecycleRuleExpiration(dict):
    def __init__(__self__, *,
                 days: int):
        pulumi.set(__self__, "days", days)

    @property
    @pulumi.getter
    def days(self) -> int:
        return pulumi.get(self, "days")


@pulumi.output_type
class ObjectBucketLifecycleRuleTransition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageClass":
            suggest = "storage_class"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectBucketLifecycleRuleTransition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectBucketLifecycleRuleTransition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectBucketLifecycleRuleTransition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_class: str,
                 days: Optional[int] = None):
        pulumi.set(__self__, "storage_class", storage_class)
        if days is not None:
            pulumi.set(__self__, "days", days)

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> str:
        return pulumi.get(self, "storage_class")

    @property
    @pulumi.getter
    def days(self) -> Optional[int]:
        return pulumi.get(self, "days")


@pulumi.output_type
class ObjectBucketVersioning(dict):
    def __init__(__self__, *,
                 enabled: Optional[bool] = None):
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class RedisClusterAcl(dict):
    def __init__(__self__, *,
                 ip: str,
                 description: Optional[str] = None,
                 id: Optional[str] = None):
        pulumi.set(__self__, "ip", ip)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def ip(self) -> str:
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")


@pulumi.output_type
class GetBaremetalOfferCpuResult(dict):
    def __init__(__self__, *,
                 core_count: int,
                 frequency: int,
                 name: str,
                 thread_count: int):
        pulumi.set(__self__, "core_count", core_count)
        pulumi.set(__self__, "frequency", frequency)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "thread_count", thread_count)

    @property
    @pulumi.getter(name="coreCount")
    def core_count(self) -> int:
        return pulumi.get(self, "core_count")

    @property
    @pulumi.getter
    def frequency(self) -> int:
        return pulumi.get(self, "frequency")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="threadCount")
    def thread_count(self) -> int:
        return pulumi.get(self, "thread_count")


@pulumi.output_type
class GetBaremetalOfferDiskResult(dict):
    def __init__(__self__, *,
                 capacity: int,
                 type: str):
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def capacity(self) -> int:
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetBaremetalOfferMemoryResult(dict):
    def __init__(__self__, *,
                 capacity: int,
                 frequency: int,
                 is_ecc: bool,
                 type: str):
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "frequency", frequency)
        pulumi.set(__self__, "is_ecc", is_ecc)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def capacity(self) -> int:
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def frequency(self) -> int:
        return pulumi.get(self, "frequency")

    @property
    @pulumi.getter(name="isEcc")
    def is_ecc(self) -> bool:
        return pulumi.get(self, "is_ecc")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetBaremetalServerIpResult(dict):
    def __init__(__self__, *,
                 address: str,
                 id: str,
                 reverse: str,
                 version: str):
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "reverse", reverse)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def address(self) -> str:
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def reverse(self) -> str:
        return pulumi.get(self, "reverse")

    @property
    @pulumi.getter
    def version(self) -> str:
        return pulumi.get(self, "version")


@pulumi.output_type
class GetDatabaseAclAclRuleResult(dict):
    def __init__(__self__, *,
                 description: str,
                 ip: str):
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "ip", ip)

    @property
    @pulumi.getter
    def description(self) -> str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def ip(self) -> str:
        return pulumi.get(self, "ip")


@pulumi.output_type
class GetDatabaseInstanceLoadBalancerResult(dict):
    def __init__(__self__, *,
                 endpoint_id: str,
                 hostname: str,
                 ip: str,
                 name: str,
                 port: int):
        pulumi.set(__self__, "endpoint_id", endpoint_id)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> str:
        return pulumi.get(self, "endpoint_id")

    @property
    @pulumi.getter
    def hostname(self) -> str:
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def ip(self) -> str:
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> int:
        return pulumi.get(self, "port")


@pulumi.output_type
class GetDatabaseInstancePrivateNetworkResult(dict):
    def __init__(__self__, *,
                 endpoint_id: str,
                 hostname: str,
                 ip: str,
                 ip_net: str,
                 name: str,
                 pn_id: str,
                 port: int,
                 zone: str):
        pulumi.set(__self__, "endpoint_id", endpoint_id)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "ip_net", ip_net)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "pn_id", pn_id)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> str:
        return pulumi.get(self, "endpoint_id")

    @property
    @pulumi.getter
    def hostname(self) -> str:
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def ip(self) -> str:
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter(name="ipNet")
    def ip_net(self) -> str:
        return pulumi.get(self, "ip_net")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pnId")
    def pn_id(self) -> str:
        return pulumi.get(self, "pn_id")

    @property
    @pulumi.getter
    def port(self) -> int:
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def zone(self) -> str:
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetDatabaseInstanceReadReplicaResult(dict):
    def __init__(__self__, *,
                 ip: str,
                 name: str,
                 port: int):
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def ip(self) -> str:
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> int:
        return pulumi.get(self, "port")


@pulumi.output_type
class GetDomainRecordGeoIpResult(dict):
    def __init__(__self__, *,
                 matches: Sequence['outputs.GetDomainRecordGeoIpMatchResult']):
        pulumi.set(__self__, "matches", matches)

    @property
    @pulumi.getter
    def matches(self) -> Sequence['outputs.GetDomainRecordGeoIpMatchResult']:
        return pulumi.get(self, "matches")


@pulumi.output_type
class GetDomainRecordGeoIpMatchResult(dict):
    def __init__(__self__, *,
                 continents: Sequence[str],
                 countries: Sequence[str],
                 data: str):
        pulumi.set(__self__, "continents", continents)
        pulumi.set(__self__, "countries", countries)
        pulumi.set(__self__, "data", data)

    @property
    @pulumi.getter
    def continents(self) -> Sequence[str]:
        return pulumi.get(self, "continents")

    @property
    @pulumi.getter
    def countries(self) -> Sequence[str]:
        return pulumi.get(self, "countries")

    @property
    @pulumi.getter
    def data(self) -> str:
        return pulumi.get(self, "data")


@pulumi.output_type
class GetDomainRecordHttpServiceResult(dict):
    def __init__(__self__, *,
                 ips: Sequence[str],
                 must_contain: str,
                 strategy: str,
                 url: str,
                 user_agent: str):
        pulumi.set(__self__, "ips", ips)
        pulumi.set(__self__, "must_contain", must_contain)
        pulumi.set(__self__, "strategy", strategy)
        pulumi.set(__self__, "url", url)
        pulumi.set(__self__, "user_agent", user_agent)

    @property
    @pulumi.getter
    def ips(self) -> Sequence[str]:
        return pulumi.get(self, "ips")

    @property
    @pulumi.getter(name="mustContain")
    def must_contain(self) -> str:
        return pulumi.get(self, "must_contain")

    @property
    @pulumi.getter
    def strategy(self) -> str:
        return pulumi.get(self, "strategy")

    @property
    @pulumi.getter
    def url(self) -> str:
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="userAgent")
    def user_agent(self) -> str:
        return pulumi.get(self, "user_agent")


@pulumi.output_type
class GetDomainRecordViewResult(dict):
    def __init__(__self__, *,
                 data: str,
                 subnet: str):
        pulumi.set(__self__, "data", data)
        pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter
    def data(self) -> str:
        return pulumi.get(self, "data")

    @property
    @pulumi.getter
    def subnet(self) -> str:
        return pulumi.get(self, "subnet")


@pulumi.output_type
class GetDomainRecordWeightedResult(dict):
    def __init__(__self__, *,
                 ip: str,
                 weight: int):
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def ip(self) -> str:
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def weight(self) -> int:
        return pulumi.get(self, "weight")


@pulumi.output_type
class GetInstanceSecurityGroupInboundRuleResult(dict):
    def __init__(__self__, *,
                 action: str,
                 ip: str,
                 ip_range: str,
                 port: int,
                 port_range: str,
                 protocol: str):
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "ip_range", ip_range)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "port_range", port_range)
        pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def action(self) -> str:
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def ip(self) -> str:
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> str:
        return pulumi.get(self, "ip_range")

    @property
    @pulumi.getter
    def port(self) -> int:
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> str:
        return pulumi.get(self, "port_range")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        return pulumi.get(self, "protocol")


@pulumi.output_type
class GetInstanceSecurityGroupOutboundRuleResult(dict):
    def __init__(__self__, *,
                 action: str,
                 ip: str,
                 ip_range: str,
                 port: int,
                 port_range: str,
                 protocol: str):
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "ip_range", ip_range)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "port_range", port_range)
        pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def action(self) -> str:
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def ip(self) -> str:
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> str:
        return pulumi.get(self, "ip_range")

    @property
    @pulumi.getter
    def port(self) -> int:
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> str:
        return pulumi.get(self, "port_range")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        return pulumi.get(self, "protocol")


@pulumi.output_type
class GetInstanceServerPrivateNetworkResult(dict):
    def __init__(__self__, *,
                 mac_address: str,
                 pn_id: str,
                 status: str,
                 zone: str):
        pulumi.set(__self__, "mac_address", mac_address)
        pulumi.set(__self__, "pn_id", pn_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> str:
        return pulumi.get(self, "mac_address")

    @property
    @pulumi.getter(name="pnId")
    def pn_id(self) -> str:
        return pulumi.get(self, "pn_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def zone(self) -> str:
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetInstanceServerRootVolumeResult(dict):
    def __init__(__self__, *,
                 boot: bool,
                 delete_on_termination: bool,
                 size_in_gb: int,
                 volume_id: str,
                 volume_type: str):
        pulumi.set(__self__, "boot", boot)
        pulumi.set(__self__, "delete_on_termination", delete_on_termination)
        pulumi.set(__self__, "size_in_gb", size_in_gb)
        pulumi.set(__self__, "volume_id", volume_id)
        pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter
    def boot(self) -> bool:
        return pulumi.get(self, "boot")

    @property
    @pulumi.getter(name="deleteOnTermination")
    def delete_on_termination(self) -> bool:
        return pulumi.get(self, "delete_on_termination")

    @property
    @pulumi.getter(name="sizeInGb")
    def size_in_gb(self) -> int:
        return pulumi.get(self, "size_in_gb")

    @property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> str:
        return pulumi.get(self, "volume_id")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> str:
        return pulumi.get(self, "volume_type")


@pulumi.output_type
class GetIotDeviceCertificateResult(dict):
    def __init__(__self__, *,
                 crt: str,
                 key: str):
        pulumi.set(__self__, "crt", crt)
        pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def crt(self) -> str:
        return pulumi.get(self, "crt")

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")


@pulumi.output_type
class GetIotDeviceMessageFilterResult(dict):
    def __init__(__self__, *,
                 publishes: Sequence['outputs.GetIotDeviceMessageFilterPublishResult'],
                 subscribes: Sequence['outputs.GetIotDeviceMessageFilterSubscribeResult']):
        pulumi.set(__self__, "publishes", publishes)
        pulumi.set(__self__, "subscribes", subscribes)

    @property
    @pulumi.getter
    def publishes(self) -> Sequence['outputs.GetIotDeviceMessageFilterPublishResult']:
        return pulumi.get(self, "publishes")

    @property
    @pulumi.getter
    def subscribes(self) -> Sequence['outputs.GetIotDeviceMessageFilterSubscribeResult']:
        return pulumi.get(self, "subscribes")


@pulumi.output_type
class GetIotDeviceMessageFilterPublishResult(dict):
    def __init__(__self__, *,
                 policy: str,
                 topics: Sequence[str]):
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "topics", topics)

    @property
    @pulumi.getter
    def policy(self) -> str:
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter
    def topics(self) -> Sequence[str]:
        return pulumi.get(self, "topics")


@pulumi.output_type
class GetIotDeviceMessageFilterSubscribeResult(dict):
    def __init__(__self__, *,
                 policy: str,
                 topics: Sequence[str]):
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "topics", topics)

    @property
    @pulumi.getter
    def policy(self) -> str:
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter
    def topics(self) -> Sequence[str]:
        return pulumi.get(self, "topics")


@pulumi.output_type
class GetKubernetesClusterAutoUpgradeResult(dict):
    def __init__(__self__, *,
                 enable: bool,
                 maintenance_window_day: str,
                 maintenance_window_start_hour: int):
        pulumi.set(__self__, "enable", enable)
        pulumi.set(__self__, "maintenance_window_day", maintenance_window_day)
        pulumi.set(__self__, "maintenance_window_start_hour", maintenance_window_start_hour)

    @property
    @pulumi.getter
    def enable(self) -> bool:
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter(name="maintenanceWindowDay")
    def maintenance_window_day(self) -> str:
        return pulumi.get(self, "maintenance_window_day")

    @property
    @pulumi.getter(name="maintenanceWindowStartHour")
    def maintenance_window_start_hour(self) -> int:
        return pulumi.get(self, "maintenance_window_start_hour")


@pulumi.output_type
class GetKubernetesClusterAutoscalerConfigResult(dict):
    def __init__(__self__, *,
                 balance_similar_node_groups: bool,
                 disable_scale_down: bool,
                 estimator: str,
                 expander: str,
                 expendable_pods_priority_cutoff: int,
                 ignore_daemonsets_utilization: bool,
                 max_graceful_termination_sec: int,
                 scale_down_delay_after_add: str,
                 scale_down_unneeded_time: str,
                 scale_down_utilization_threshold: float):
        pulumi.set(__self__, "balance_similar_node_groups", balance_similar_node_groups)
        pulumi.set(__self__, "disable_scale_down", disable_scale_down)
        pulumi.set(__self__, "estimator", estimator)
        pulumi.set(__self__, "expander", expander)
        pulumi.set(__self__, "expendable_pods_priority_cutoff", expendable_pods_priority_cutoff)
        pulumi.set(__self__, "ignore_daemonsets_utilization", ignore_daemonsets_utilization)
        pulumi.set(__self__, "max_graceful_termination_sec", max_graceful_termination_sec)
        pulumi.set(__self__, "scale_down_delay_after_add", scale_down_delay_after_add)
        pulumi.set(__self__, "scale_down_unneeded_time", scale_down_unneeded_time)
        pulumi.set(__self__, "scale_down_utilization_threshold", scale_down_utilization_threshold)

    @property
    @pulumi.getter(name="balanceSimilarNodeGroups")
    def balance_similar_node_groups(self) -> bool:
        return pulumi.get(self, "balance_similar_node_groups")

    @property
    @pulumi.getter(name="disableScaleDown")
    def disable_scale_down(self) -> bool:
        return pulumi.get(self, "disable_scale_down")

    @property
    @pulumi.getter
    def estimator(self) -> str:
        return pulumi.get(self, "estimator")

    @property
    @pulumi.getter
    def expander(self) -> str:
        return pulumi.get(self, "expander")

    @property
    @pulumi.getter(name="expendablePodsPriorityCutoff")
    def expendable_pods_priority_cutoff(self) -> int:
        return pulumi.get(self, "expendable_pods_priority_cutoff")

    @property
    @pulumi.getter(name="ignoreDaemonsetsUtilization")
    def ignore_daemonsets_utilization(self) -> bool:
        return pulumi.get(self, "ignore_daemonsets_utilization")

    @property
    @pulumi.getter(name="maxGracefulTerminationSec")
    def max_graceful_termination_sec(self) -> int:
        return pulumi.get(self, "max_graceful_termination_sec")

    @property
    @pulumi.getter(name="scaleDownDelayAfterAdd")
    def scale_down_delay_after_add(self) -> str:
        return pulumi.get(self, "scale_down_delay_after_add")

    @property
    @pulumi.getter(name="scaleDownUnneededTime")
    def scale_down_unneeded_time(self) -> str:
        return pulumi.get(self, "scale_down_unneeded_time")

    @property
    @pulumi.getter(name="scaleDownUtilizationThreshold")
    def scale_down_utilization_threshold(self) -> float:
        return pulumi.get(self, "scale_down_utilization_threshold")


@pulumi.output_type
class GetKubernetesClusterKubeconfigResult(dict):
    def __init__(__self__, *,
                 cluster_ca_certificate: str,
                 config_file: str,
                 host: str,
                 token: str):
        pulumi.set(__self__, "cluster_ca_certificate", cluster_ca_certificate)
        pulumi.set(__self__, "config_file", config_file)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter(name="clusterCaCertificate")
    def cluster_ca_certificate(self) -> str:
        return pulumi.get(self, "cluster_ca_certificate")

    @property
    @pulumi.getter(name="configFile")
    def config_file(self) -> str:
        return pulumi.get(self, "config_file")

    @property
    @pulumi.getter
    def host(self) -> str:
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def token(self) -> str:
        return pulumi.get(self, "token")


@pulumi.output_type
class GetKubernetesClusterOpenIdConnectConfigResult(dict):
    def __init__(__self__, *,
                 client_id: str,
                 groups_claims: Sequence[str],
                 groups_prefix: str,
                 issuer_url: str,
                 required_claims: Sequence[str],
                 username_claim: str,
                 username_prefix: str):
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "groups_claims", groups_claims)
        pulumi.set(__self__, "groups_prefix", groups_prefix)
        pulumi.set(__self__, "issuer_url", issuer_url)
        pulumi.set(__self__, "required_claims", required_claims)
        pulumi.set(__self__, "username_claim", username_claim)
        pulumi.set(__self__, "username_prefix", username_prefix)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="groupsClaims")
    def groups_claims(self) -> Sequence[str]:
        return pulumi.get(self, "groups_claims")

    @property
    @pulumi.getter(name="groupsPrefix")
    def groups_prefix(self) -> str:
        return pulumi.get(self, "groups_prefix")

    @property
    @pulumi.getter(name="issuerUrl")
    def issuer_url(self) -> str:
        return pulumi.get(self, "issuer_url")

    @property
    @pulumi.getter(name="requiredClaims")
    def required_claims(self) -> Sequence[str]:
        return pulumi.get(self, "required_claims")

    @property
    @pulumi.getter(name="usernameClaim")
    def username_claim(self) -> str:
        return pulumi.get(self, "username_claim")

    @property
    @pulumi.getter(name="usernamePrefix")
    def username_prefix(self) -> str:
        return pulumi.get(self, "username_prefix")


@pulumi.output_type
class GetKubernetesNodePoolNodeResult(dict):
    def __init__(__self__, *,
                 name: str,
                 public_ip: str,
                 public_ip_v6: str,
                 status: str):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "public_ip", public_ip)
        pulumi.set(__self__, "public_ip_v6", public_ip_v6)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> str:
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter(name="publicIpV6")
    def public_ip_v6(self) -> str:
        return pulumi.get(self, "public_ip_v6")

    @property
    @pulumi.getter
    def status(self) -> str:
        return pulumi.get(self, "status")


@pulumi.output_type
class GetKubernetesNodePoolUpgradePolicyResult(dict):
    def __init__(__self__, *,
                 max_surge: int,
                 max_unavailable: int):
        pulumi.set(__self__, "max_surge", max_surge)
        pulumi.set(__self__, "max_unavailable", max_unavailable)

    @property
    @pulumi.getter(name="maxSurge")
    def max_surge(self) -> int:
        return pulumi.get(self, "max_surge")

    @property
    @pulumi.getter(name="maxUnavailable")
    def max_unavailable(self) -> int:
        return pulumi.get(self, "max_unavailable")


@pulumi.output_type
class GetLoadbalancerCertificateCustomCertificateResult(dict):
    def __init__(__self__, *,
                 certificate_chain: str):
        pulumi.set(__self__, "certificate_chain", certificate_chain)

    @property
    @pulumi.getter(name="certificateChain")
    def certificate_chain(self) -> str:
        return pulumi.get(self, "certificate_chain")


@pulumi.output_type
class GetLoadbalancerCertificateLetsencryptResult(dict):
    def __init__(__self__, *,
                 common_name: str,
                 subject_alternative_names: Sequence[str]):
        pulumi.set(__self__, "common_name", common_name)
        pulumi.set(__self__, "subject_alternative_names", subject_alternative_names)

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> str:
        return pulumi.get(self, "common_name")

    @property
    @pulumi.getter(name="subjectAlternativeNames")
    def subject_alternative_names(self) -> Sequence[str]:
        return pulumi.get(self, "subject_alternative_names")


@pulumi.output_type
class GetLoadbalancerPrivateNetworkResult(dict):
    def __init__(__self__, *,
                 dhcp_config: bool,
                 private_network_id: str,
                 static_configs: Sequence[str],
                 status: str,
                 zone: str):
        pulumi.set(__self__, "dhcp_config", dhcp_config)
        pulumi.set(__self__, "private_network_id", private_network_id)
        pulumi.set(__self__, "static_configs", static_configs)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="dhcpConfig")
    def dhcp_config(self) -> bool:
        return pulumi.get(self, "dhcp_config")

    @property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> str:
        return pulumi.get(self, "private_network_id")

    @property
    @pulumi.getter(name="staticConfigs")
    def static_configs(self) -> Sequence[str]:
        return pulumi.get(self, "static_configs")

    @property
    @pulumi.getter
    def status(self) -> str:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def zone(self) -> str:
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetObjectBucketCorsRuleResult(dict):
    def __init__(__self__, *,
                 allowed_headers: Sequence[str],
                 allowed_methods: Sequence[str],
                 allowed_origins: Sequence[str],
                 expose_headers: Sequence[str],
                 max_age_seconds: int):
        pulumi.set(__self__, "allowed_headers", allowed_headers)
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        pulumi.set(__self__, "expose_headers", expose_headers)
        pulumi.set(__self__, "max_age_seconds", max_age_seconds)

    @property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Sequence[str]:
        return pulumi.get(self, "allowed_headers")

    @property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Sequence[str]:
        return pulumi.get(self, "allowed_methods")

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Sequence[str]:
        return pulumi.get(self, "allowed_origins")

    @property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Sequence[str]:
        return pulumi.get(self, "expose_headers")

    @property
    @pulumi.getter(name="maxAgeSeconds")
    def max_age_seconds(self) -> int:
        return pulumi.get(self, "max_age_seconds")


@pulumi.output_type
class GetObjectBucketLifecycleRuleResult(dict):
    def __init__(__self__, *,
                 abort_incomplete_multipart_upload_days: int,
                 enabled: bool,
                 expirations: Sequence['outputs.GetObjectBucketLifecycleRuleExpirationResult'],
                 id: str,
                 prefix: str,
                 tags: Mapping[str, str],
                 transitions: Sequence['outputs.GetObjectBucketLifecycleRuleTransitionResult']):
        pulumi.set(__self__, "abort_incomplete_multipart_upload_days", abort_incomplete_multipart_upload_days)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "expirations", expirations)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "prefix", prefix)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "transitions", transitions)

    @property
    @pulumi.getter(name="abortIncompleteMultipartUploadDays")
    def abort_incomplete_multipart_upload_days(self) -> int:
        return pulumi.get(self, "abort_incomplete_multipart_upload_days")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def expirations(self) -> Sequence['outputs.GetObjectBucketLifecycleRuleExpirationResult']:
        return pulumi.get(self, "expirations")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def prefix(self) -> str:
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def transitions(self) -> Sequence['outputs.GetObjectBucketLifecycleRuleTransitionResult']:
        return pulumi.get(self, "transitions")


@pulumi.output_type
class GetObjectBucketLifecycleRuleExpirationResult(dict):
    def __init__(__self__, *,
                 days: int):
        pulumi.set(__self__, "days", days)

    @property
    @pulumi.getter
    def days(self) -> int:
        return pulumi.get(self, "days")


@pulumi.output_type
class GetObjectBucketLifecycleRuleTransitionResult(dict):
    def __init__(__self__, *,
                 days: int,
                 storage_class: str):
        pulumi.set(__self__, "days", days)
        pulumi.set(__self__, "storage_class", storage_class)

    @property
    @pulumi.getter
    def days(self) -> int:
        return pulumi.get(self, "days")

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> str:
        return pulumi.get(self, "storage_class")


@pulumi.output_type
class GetObjectBucketVersioningResult(dict):
    def __init__(__self__, *,
                 enabled: bool):
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetRedisClusterAclResult(dict):
    def __init__(__self__, *,
                 description: str,
                 id: str,
                 ip: str):
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip", ip)

    @property
    @pulumi.getter
    def description(self) -> str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ip(self) -> str:
        return pulumi.get(self, "ip")


