# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['VpcPublicGatewayDhcpReservationArgs', 'VpcPublicGatewayDhcpReservation']

@pulumi.input_type
class VpcPublicGatewayDhcpReservationArgs:
    def __init__(__self__, *,
                 gateway_network_id: pulumi.Input[str],
                 ip_address: pulumi.Input[str],
                 mac_address: pulumi.Input[str],
                 zone: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a VpcPublicGatewayDhcpReservation resource.
        :param pulumi.Input[str] gateway_network_id: The ID of the owning GatewayNetwork (UUID format).
        :param pulumi.Input[str] ip_address: The IP address to give to the machine (IPv4 address).
        :param pulumi.Input[str] mac_address: The MAC address to give a static entry to.
        :param pulumi.Input[str] zone: The zone you want to attach the resource to
        """
        pulumi.set(__self__, "gateway_network_id", gateway_network_id)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "mac_address", mac_address)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="gatewayNetworkId")
    def gateway_network_id(self) -> pulumi.Input[str]:
        """
        The ID of the owning GatewayNetwork (UUID format).
        """
        return pulumi.get(self, "gateway_network_id")

    @gateway_network_id.setter
    def gateway_network_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "gateway_network_id", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Input[str]:
        """
        The IP address to give to the machine (IPv4 address).
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> pulumi.Input[str]:
        """
        The MAC address to give a static entry to.
        """
        return pulumi.get(self, "mac_address")

    @mac_address.setter
    def mac_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "mac_address", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        The zone you want to attach the resource to
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _VpcPublicGatewayDhcpReservationState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[str]] = None,
                 gateway_network_id: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 mac_address: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 updated_at: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering VpcPublicGatewayDhcpReservation resources.
        :param pulumi.Input[str] created_at: The configuration creation date.
        :param pulumi.Input[str] gateway_network_id: The ID of the owning GatewayNetwork (UUID format).
        :param pulumi.Input[str] hostname: The Hostname of the client machine.
        :param pulumi.Input[str] ip_address: The IP address to give to the machine (IPv4 address).
        :param pulumi.Input[str] mac_address: The MAC address to give a static entry to.
        :param pulumi.Input[str] type: The reservation type, either static (DHCP reservation) or dynamic (DHCP lease). Possible values are reservation and
               lease
        :param pulumi.Input[str] updated_at: The configuration last modification date.
        :param pulumi.Input[str] zone: The zone you want to attach the resource to
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if gateway_network_id is not None:
            pulumi.set(__self__, "gateway_network_id", gateway_network_id)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        The configuration creation date.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="gatewayNetworkId")
    def gateway_network_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the owning GatewayNetwork (UUID format).
        """
        return pulumi.get(self, "gateway_network_id")

    @gateway_network_id.setter
    def gateway_network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gateway_network_id", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        The Hostname of the client machine.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address to give to the machine (IPv4 address).
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[pulumi.Input[str]]:
        """
        The MAC address to give a static entry to.
        """
        return pulumi.get(self, "mac_address")

    @mac_address.setter
    def mac_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mac_address", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The reservation type, either static (DHCP reservation) or dynamic (DHCP lease). Possible values are reservation and
        lease
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[str]]:
        """
        The configuration last modification date.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated_at", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        The zone you want to attach the resource to
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


class VpcPublicGatewayDhcpReservation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 gateway_network_id: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 mac_address: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a VpcPublicGatewayDhcpReservation resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] gateway_network_id: The ID of the owning GatewayNetwork (UUID format).
        :param pulumi.Input[str] ip_address: The IP address to give to the machine (IPv4 address).
        :param pulumi.Input[str] mac_address: The MAC address to give a static entry to.
        :param pulumi.Input[str] zone: The zone you want to attach the resource to
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VpcPublicGatewayDhcpReservationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a VpcPublicGatewayDhcpReservation resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param VpcPublicGatewayDhcpReservationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpcPublicGatewayDhcpReservationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 gateway_network_id: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 mac_address: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpcPublicGatewayDhcpReservationArgs.__new__(VpcPublicGatewayDhcpReservationArgs)

            if gateway_network_id is None and not opts.urn:
                raise TypeError("Missing required property 'gateway_network_id'")
            __props__.__dict__["gateway_network_id"] = gateway_network_id
            if ip_address is None and not opts.urn:
                raise TypeError("Missing required property 'ip_address'")
            __props__.__dict__["ip_address"] = ip_address
            if mac_address is None and not opts.urn:
                raise TypeError("Missing required property 'mac_address'")
            __props__.__dict__["mac_address"] = mac_address
            __props__.__dict__["zone"] = zone
            __props__.__dict__["created_at"] = None
            __props__.__dict__["hostname"] = None
            __props__.__dict__["type"] = None
            __props__.__dict__["updated_at"] = None
        super(VpcPublicGatewayDhcpReservation, __self__).__init__(
            'scaleway:index/vpcPublicGatewayDhcpReservation:VpcPublicGatewayDhcpReservation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            gateway_network_id: Optional[pulumi.Input[str]] = None,
            hostname: Optional[pulumi.Input[str]] = None,
            ip_address: Optional[pulumi.Input[str]] = None,
            mac_address: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            updated_at: Optional[pulumi.Input[str]] = None,
            zone: Optional[pulumi.Input[str]] = None) -> 'VpcPublicGatewayDhcpReservation':
        """
        Get an existing VpcPublicGatewayDhcpReservation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] created_at: The configuration creation date.
        :param pulumi.Input[str] gateway_network_id: The ID of the owning GatewayNetwork (UUID format).
        :param pulumi.Input[str] hostname: The Hostname of the client machine.
        :param pulumi.Input[str] ip_address: The IP address to give to the machine (IPv4 address).
        :param pulumi.Input[str] mac_address: The MAC address to give a static entry to.
        :param pulumi.Input[str] type: The reservation type, either static (DHCP reservation) or dynamic (DHCP lease). Possible values are reservation and
               lease
        :param pulumi.Input[str] updated_at: The configuration last modification date.
        :param pulumi.Input[str] zone: The zone you want to attach the resource to
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VpcPublicGatewayDhcpReservationState.__new__(_VpcPublicGatewayDhcpReservationState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["gateway_network_id"] = gateway_network_id
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["ip_address"] = ip_address
        __props__.__dict__["mac_address"] = mac_address
        __props__.__dict__["type"] = type
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["zone"] = zone
        return VpcPublicGatewayDhcpReservation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        The configuration creation date.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="gatewayNetworkId")
    def gateway_network_id(self) -> pulumi.Output[str]:
        """
        The ID of the owning GatewayNetwork (UUID format).
        """
        return pulumi.get(self, "gateway_network_id")

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[str]:
        """
        The Hostname of the client machine.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[str]:
        """
        The IP address to give to the machine (IPv4 address).
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> pulumi.Output[str]:
        """
        The MAC address to give a static entry to.
        """
        return pulumi.get(self, "mac_address")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The reservation type, either static (DHCP reservation) or dynamic (DHCP lease). Possible values are reservation and
        lease
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[str]:
        """
        The configuration last modification date.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[str]:
        """
        The zone you want to attach the resource to
        """
        return pulumi.get(self, "zone")

