import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SqlSourceRepresentationInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
     * The MySQL version running on your source database server. Possible values: ["MYSQL_5_5", "MYSQL_5_6", "MYSQL_5_7", "MYSQL_8_0"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_source_representation_instance.html#database_version SqlSourceRepresentationInstance#database_version}
     *
     * @stability stable
     */
    readonly databaseVersion: string;
    /**
     * The externally accessible IPv4 address for the source database server.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_source_representation_instance.html#host SqlSourceRepresentationInstance#host}
     *
     * @stability stable
     */
    readonly host: string;
    /**
     * The name of the source representation instance. Use any valid Cloud SQL instance name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_source_representation_instance.html#name SqlSourceRepresentationInstance#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The externally accessible port for the source database server. Defaults to 3306.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_source_representation_instance.html#port SqlSourceRepresentationInstance#port}
     *
     * @stability stable
     */
    readonly port?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_source_representation_instance.html#project SqlSourceRepresentationInstance#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The Region in which the created instance should reside. If it is not provided, the provider region is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_source_representation_instance.html#region SqlSourceRepresentationInstance#region}
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_source_representation_instance.html#timeouts SqlSourceRepresentationInstance#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SqlSourceRepresentationInstanceTimeouts;
}
/**
 * @stability stable
 */
export interface SqlSourceRepresentationInstanceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_source_representation_instance.html#create SqlSourceRepresentationInstance#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_source_representation_instance.html#delete SqlSourceRepresentationInstance#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
export declare function sqlSourceRepresentationInstanceTimeoutsToTerraform(struct?: SqlSourceRepresentationInstanceTimeoutsOutputReference | SqlSourceRepresentationInstanceTimeouts): any;
/**
 * @stability stable
 */
export declare class SqlSourceRepresentationInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SqlSourceRepresentationInstanceTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SqlSourceRepresentationInstanceTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/sql_source_representation_instance.html google_sql_source_representation_instance}.
 *
 * @stability stable
 */
export declare class SqlSourceRepresentationInstance extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/sql_source_representation_instance.html google_sql_source_representation_instance} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SqlSourceRepresentationInstanceConfig);
    private _databaseVersion?;
    /**
     * @stability stable
     */
    get databaseVersion(): string;
    /**
     * @stability stable
     */
    set databaseVersion(value: string);
    /**
     * @stability stable
     */
    get databaseVersionInput(): string | undefined;
    private _host?;
    /**
     * @stability stable
     */
    get host(): string;
    /**
     * @stability stable
     */
    set host(value: string);
    /**
     * @stability stable
     */
    get hostInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _port?;
    /**
     * @stability stable
     */
    get port(): number;
    /**
     * @stability stable
     */
    set port(value: number);
    /**
     * @stability stable
     */
    resetPort(): void;
    /**
     * @stability stable
     */
    get portInput(): number | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    set region(value: string);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): SqlSourceRepresentationInstanceTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SqlSourceRepresentationInstanceTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SqlSourceRepresentationInstanceTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
