from .ApiMethod import ApiMethod


class Wall(ApiMethod):
    def __init__(self, access_token, v, session, calls_per_second):
        super(Wall, self).__init__(access_token, v, session, calls_per_second)
        self._base_method = 'wall.'

    def checkCopyrightLink(self, link: str = None) -> dict:
        """
        Проверяет ссылку для указания источника.

        :param link: ссылка на источник. Поддерживаются внешние и внутренние ссылки.

        :return: После успешного выполнения возвращает 1
        """

        params = locals()
        method_name = self._base_method + 'checkCopyrightLink'
        return self._call(method_name, params)

    def closeComments(self, owner_id: str = None, post_id: str = None) -> dict:
        """
        Выключает комментирование записи

        :param owner_id:
        :param post_id:

        :return: Возвращает 1 в случае успех
        """

        params = locals()
        method_name = self._base_method + 'closeComments'
        return self._call(method_name, params)

    def createComment(self, owner_id: str = None, post_id: str = None, from_group: str = None, message: str = None,
                      reply_to_comment: str = None, attachments: str = None, sticker_id: str = None,
                      guid: str = None) -> dict:
        """
        Добавляет комментарий к записи на стене.

        :param owner_id: идентификатор пользователя или сообщества, на чьей стене находится запись, к которой
            необходимо добавить комментарий. Обратите внимание, идентификатор сообщества в параметре owner_id
            необходимо указывать со знаком "-" — например, owner_id=-1 соответствует идентификатору сообщества
            ВКонтакте API (club1)
        :param post_id: идентификатор записи на стене.
        :param from_group: идентификатор сообщества, от имени которого публикуется комментарий. По умолчанию: 0.
        :param message: текст комментария. Обязательный параметр, если не передан параметр attachments.
        :param reply_to_comment: идентификатор комментария, в ответ на который должен быть добавлен новый
            комментарий.
        :param attachments: список объектов, приложенных к комментарию и разделённых символом ",". Поле
            attachments представляется в формате: <type><owner_id>_<media_id>,<type><owner_id>_<media_id> <type> —
            тип медиа-вложения: photo — фотография  video — видеозапись  audio — аудиозапись  doc — документ
            <owner_id> — идентификатор владельца медиа-вложения  <media_id> — идентификатор медиа-вложения.
            Например: photo100172_166443618,photo66748_265827614 Параметр является обязательным, если не задан
            параметр message.
        :param sticker_id: идентификатор стикера.
        :param guid: уникальный идентификатор, предназначенный для предотвращения повторной отправки одинакового
            комментария.

        :return: После успешного выполнения возвращает идентификатор добавленного комментария в поле comment_id
            (integer) и массив идентификаторов родительских комментариев в поле parent_stack (array)
        """

        params = locals()
        method_name = self._base_method + 'createComment'
        return self._call(method_name, params)

    def delete(self, owner_id: str = None, post_id: str = None) -> dict:
        """
        Удаляет запись со стены.

        :param owner_id: идентификатор пользователя или сообщества, на стене которого находится запись. Обратите
            внимание, идентификатор сообщества в параметре owner_id необходимо указывать со знаком "-" — например,
            owner_id=-1 соответствует идентификатору сообщества ВКонтакте API (club1)
        :param post_id: идентификатор записи на стене.

        :return: После успешного выполнения возвращает 1
        """

        params = locals()
        method_name = self._base_method + 'delete'
        return self._call(method_name, params)

    def deleteComment(self, owner_id: str = None, comment_id: str = None) -> dict:
        """
        Удаляет комментарий к записи на стене.

        :param owner_id: идентификатор пользователя, на чьей стене находится комментарий к записи. Обратите
            внимание, идентификатор сообщества в параметре owner_id необходимо указывать со знаком "-" — например,
            owner_id=-1 соответствует идентификатору сообщества ВКонтакте API (club1)
        :param comment_id: идентификатор комментария.

        :return: После успешного выполнения возвращает 1
        """

        params = locals()
        method_name = self._base_method + 'deleteComment'
        return self._call(method_name, params)

    def edit(self, owner_id: str = None, post_id: str = None, friends_only: str = None, message: str = None,
             attachments: str = None, services: str = None, signed: str = None, publish_date: str = None,
             lat: str = None, long: str = None, place_id: str = None, mark_as_ads: str = None,
             close_comments: str = None, poster_bkg_id: str = None, poster_bkg_owner_id: str = None,
             poster_bkg_access_hash: str = None, copyright: str = None) -> dict:
        """
        Редактирует запись на стене.

        :param owner_id: идентификатор пользователя или сообщества, на стене которого находится запись. Обратите
            внимание, идентификатор сообщества в параметре owner_id необходимо указывать со знаком "-" — например,
            owner_id=-1 соответствует идентификатору сообщества ВКонтакте API (club1)
        :param post_id: идентификатор записи на стене.
        :param friends_only: 1 — запись будет доступна только друзьям, 0 — всем пользователям.  Параметр
            учитывается только при редактировании отложенной записи.
        :param message: текст сообщения (является обязательным, если не задан параметр attachments)
        :param attachments: список объектов, приложенных к записи и разделённых символом ",". Поле attachments
            представляется в формате: <type><owner_id>_<media_id>,<type><owner_id>_<media_id>  <type> — тип медиа-
            приложения:    photo — фотография  video — видеозапись  audio — аудиозапись  doc — документ  graffiti —
            граффити  page — wiki-страница  note — заметка  poll — опрос  album — альбом.   <owner_id> —
            идентификатор владельца медиа-приложения; <media_id> — идентификатор медиа-приложения.  Например:
            photo100172_166443618,photo66748_265827614  Также в поле attachments может быть указана ссылка на внешнюю
            страницу, которую Вы хотите разместить в статусе, например: photo66748_265827614,http://habrahabr.ru  При
            попытке приложить больше одной ссылки будет возвращена ошибка.   Параметр является обязательным, если не
            задан параметр message.
        :param services: список сервисов или сайтов, на которые необходимо экспортировать запись, в случае если
            пользователь настроил соответствующую опцию. Например, twitter, facebook.  Параметр учитывается только
            при редактировании отложенной записи.
        :param signed: 1 — у записи, размещенной от имени сообщества будет добавлена подпись (имя пользователя,
            разместившего запись), 0 — подписи добавлено не будет.  Параметр учитывается только при редактировании
            записи на стене сообщества, опубликованной от имени группы.
        :param publish_date: дата публикации записи в формате unixtime. Если параметр не указан, отложенная
            запись будет опубликована.  Параметр учитывается только при редактировании отложенной записи.
        :param lat: географическая широта отметки, заданная в градусах (от -90 до 90).
        :param long: географическая долгота отметки, заданная в градусах (от -180 до 180).
        :param place_id: идентификатор места, в котором отмечен пользователь.
        :param mark_as_ads: 1 — у записи, размещенной от имени сообщества, будет добавлена метка "это реклама", 0
            — метки добавлено не будет/снять установленную метку. Метка может быть снята в течение пяти минут после
            её установки. В сутки может быть опубликовано не более пяти рекламных записей, из которых не более трёх —
            вне Биржи ВКонтакте.
        :param close_comments: 1 — комментарии к записи отключены.  0 — комментарии к записи включены.
        :param poster_bkg_id:
        :param poster_bkg_owner_id:
        :param poster_bkg_access_hash:
        :param copyright: источник материала. Поддерживаются внешние и внутренние ссылки.

        :return: После успешного выполнения возвращает post_id — идентификатор отредактированного поста
        """

        params = locals()
        method_name = self._base_method + 'edit'
        return self._call(method_name, params)

    def editAdsStealth(self, owner_id: str = None, post_id: str = None, message: str = None, attachments: str = None,
                       signed: str = None, lat: str = None, long: str = None, place_id: str = None,
                       link_button: str = None, link_title: str = None, link_image: str = None,
                       link_video: str = None) -> dict:
        """
        Позволяет отредактировать скрытую запись.

        :param owner_id: идентификатор владельца стены (идентификатор сообщества нужно указывать со знаком
            «минус»).
        :param post_id: идентификатор записи.
        :param message: текст записи.
        :param attachments: список объектов, приложенных к записи и разделённых символом ",". Поле attachments
            представляется в формате: <type><owner_id>_<media_id>,<type><owner_id>_<media_id>   <type> — тип медиа-
            приложения:   photo — фотография;  video — видеозапись ;  audio — аудиозапись;  doc — документ;  page —
            wiki-страница;  note — заметка;  poll — опрос;  album — альбом;  market — товар;  market_album — подборка
            товаров.   <owner_id> — идентификатор владельца медиа-приложения (обратите внимание, если объект
            находится в сообществе, этот параметр должен быть отрицательным).  <media_id> — идентификатор медиа-
            приложения.   Например: photo100172_166443618,photo-1_265827614  Также в поле attachments может быть
            указана ссылка на внешнюю страницу, которую Вы хотите разместить в записи, например:
            photo66748_265827614,http://habrahabr.ru  В качестве ссылки может быть использован телефонный номер в
            формате tel:+71234567890  При попытке приложить больше одной ссылки будет возвращена ошибка.   Параметр
            является обязательным, если не задан параметр message.
        :param signed: 1 — у записи, размещенной от имени сообщества, будет добавлена подпись (имя пользователя,
            разместившего запись), 0 — без подписи.
        :param lat: географическая широта отметки, заданная в градусах (от -90 до 90).
        :param long: географическая долгота отметки, заданная в градусах (от -180 до 180).
        :param place_id: идентификатор места.
        :param link_button: идентификатор кнопки, которую необходимо добавить к сниппету для ссылки. Подробнее
            см. документацию метода wall.postAdsStealth.
        :param link_title: заголовок, который должен быть использован для сниппета. Если не указан, будет
            автоматически получен с целевой ссылки. Обязательно указывать в случае, если ссылка является номером
            телефона.
        :param link_image: ссылка на изображение, которое должно быть использовано для сниппета. Минимальное
            разрешение: 537x240. Если не указана, будет автоматически загружена с целевой ссылки. Обязательно
            указывать в случае, если ссылка является номером телефона. Одновременно может быть указан либо параметр
            link_image, либо параметр link_video.
        :param link_video: идентификатор видео в формате "<owner_id>_<media_id>". Одновременно может быть указан
            либо параметр link_image, либо параметр link_video. Кроме того, параметр link_video может быть указан
            только вместе с параметрами link_button, link_title.

        :return: После успешного выполнения возвращает 1
        """

        params = locals()
        method_name = self._base_method + 'editAdsStealth'
        return self._call(method_name, params)

    def editComment(self, owner_id: str = None, comment_id: str = None, message: str = None,
                    attachments: str = None) -> dict:
        """
        Редактирует комментарий на стене.

        :param owner_id: идентификатор владельца стены. Обратите внимание, идентификатор сообщества в параметре
            owner_id необходимо указывать со знаком "-" — например, owner_id=-1 соответствует идентификатору
            сообщества ВКонтакте API (club1)
        :param comment_id: идентификатор комментария, который необходимо отредактировать.
        :param message: новый текст комментария. Обязательный параметр, если не передан параметр attachments.
        :param attachments: новые вложения к комментарию. Список объектов, приложенных к комментарию и
            разделённых символом ",". Поле attachments представляется в формате:
            <type><owner_id>_<media_id>,<type><owner_id>_<media_id> <type> — тип медиа-вложения: photo — фотография
            video — видеозапись  audio — аудиозапись  doc — документ <owner_id> — идентификатор владельца медиа-
            вложения  <media_id> — идентификатор медиа-вложения.   Например:
            photo100172_166443618,photo66748_265827614 Параметр является обязательным, если не задан параметр
            message.

        :return: После успешного выполнения возвращает 1
        """

        params = locals()
        method_name = self._base_method + 'editComment'
        return self._call(method_name, params)

    def get(self, owner_id: str = None, domain: str = None, offset: str = None, count: str = None, filter: str = None,
            extended: str = None, fields: str = None) -> dict:
        """
        Возвращает список записей со стены пользователя или сообщества.

        :param owner_id: идентификатор пользователя или сообщества, со стены которого необходимо получить записи
            (по умолчанию — текущий пользователь). Обратите внимание, идентификатор сообщества в параметре owner_id
            необходимо указывать со знаком "-" — например, owner_id=-1 соответствует идентификатору сообщества
            ВКонтакте API (club1)
        :param domain: короткий адрес пользователя или сообщества.
        :param offset: смещение, необходимое для выборки определенного подмножества записей.
        :param count: количество записей, которое необходимо получить. Максимальное значение: 100.
        :param filter: определяет, какие типы записей на стене необходимо получить. Возможные значения:
            suggests — предложенные записи на стене сообщества (доступно только при вызове с передачей access_token);
            postponed — отложенные записи (доступно только при вызове с передачей access_token);  owner — записи
            владельца стены;  others — записи не от владельца стены;  all — все записи на стене (owner + others).  По
            умолчанию: all.
        :param extended: 1 — в ответе будут возвращены дополнительные поля profiles и groups, содержащие
            информацию о пользователях и сообществах. По умолчанию: 0.
        :param fields: список дополнительных полей для профилей и сообществ, которые необходимо вернуть.
            Обратите внимание, этот параметр учитывается только при extended=1.

        :return: После успешного выполнения возвращает объект, содержащий число результатов в поле count и массив
            объектов записей на стене в поле items.  Если был задан параметр extended=1, возвращает число результатов
            в поле count, отдельно массив объектов записей на стене в поле items, пользователей в поле profiles и
            сообществ в поле groups
        """

        params = locals()
        method_name = self._base_method + 'get'
        return self._call(method_name, params)

    def getById(self, posts: str = None, extended: str = None, copy_history_depth: str = None,
                fields: str = None) -> dict:
        """
        Возвращает список записей со стен пользователей или сообществ по их идентификаторам.

        :param posts: перечисленные через запятую идентификаторы, которые представляют собой идущие через знак
            подчеркивания id владельцев стен и id самих записей на стене. Максимум 100 идентификаторов. Пример
            значения posts: 93388_21539,93388_20904,-1_340364
        :param extended: 1 — в ответе будут возвращены дополнительные поля profiles и groups, содержащие
            информацию о пользователях и сообществах. По умолчанию: 0.
        :param copy_history_depth: определяет размер массива copy_history, возвращаемого в ответе, если запись
            является репостом записи с другой стены.  Например, copy_history_depth=1 — copy_history будет содержать
            один элемент с информацией о записи, прямым репостом которой является текущая.  copy_history_depth=2 —
            copy_history будет содержать два элемента, добавляется информация о записи, репостом которой является
            первый элемент, и так далее (при условии, что иерархия репостов требуемой глубины для текущей записи
            существует).
        :param fields: список дополнительных полей для профилей и групп, которые необходимо вернуть. См. описание
            полей объекта user и описание полей объекта group.  Обратите внимание, этот параметр учитывается только
            при extended=1.

        :return: После успешного выполнения возвращает объект, содержащий массив объектов записей на стене.  Если
            был задан параметр extended=1, возвращает отдельно массив объектов записей на стене в поле items,
            пользователей в поле profiles и сообществ в поле groups
        """

        params = locals()
        method_name = self._base_method + 'getById'
        return self._call(method_name, params)

    def getComment(self, owner_id: str = None, comment_id: str = None, extended: str = None,
                   fields: str = None) -> dict:
        """
        Получает информацию о комментарии на стене.

        :param owner_id: идентификатор владельца стены (для сообществ — со знаком «минус»).
        :param comment_id: идентификатор комментария.
        :param extended: 1 — в ответе будут возвращены дополнительные поля profiles и groups, содержащие
            информацию о пользователях и сообществах. По умолчанию: 0.
        :param fields: список дополнительных полей для профилей и сообществ, которые необходимо вернуть.
            Обратите внимание, этот параметр учитывается только при extended=1.

        :return: Возвращает объект комментария на стене. Если был передан параметр extended = 1, дополнительно
            возвращает поля groups (array) и profiles (array), содержащие информацию о пользователях и сообществах
        """

        params = locals()
        method_name = self._base_method + 'getComment'
        return self._call(method_name, params)

    def getComments(self, owner_id: str = None, post_id: str = None, need_likes: str = None,
                    start_comment_id: str = None, offset: str = None, count: str = None, sort: str = None,
                    preview_length: str = None, extended: str = None, fields: str = None, comment_id: str = None,
                    thread_items_count: str = None) -> dict:
        """
        Возвращает список комментариев к записи на стене.

        :param owner_id: идентификатор владельца страницы (пользователь или сообщество). Обратите внимание,
            идентификатор сообщества в параметре owner_id необходимо указывать со знаком "-" — например, owner_id=-1
            соответствует идентификатору сообщества ВКонтакте API (club1)
        :param post_id: идентификатор записи на стене.
        :param need_likes: 1 — возвращать информацию о лайках.
        :param start_comment_id: идентификатор комментария, начиная с которого нужно вернуть список (подробности
            см. ниже).
        :param offset: сдвиг, необходимый для получения конкретной выборки результатов.
        :param count: число комментариев, которые необходимо получить. По умолчанию: 10, максимальное значение:
            100.
        :param sort: порядок сортировки комментариев. Возможные значения:   asc — от старых к новым;  desc — от
            новых к старым.
        :param preview_length: количество символов, по которому нужно обрезать текст комментария. Укажите 0, если
            Вы не хотите обрезать текст.
        :param extended: 1 — в ответе будут возвращены дополнительные поля profiles и groups, содержащие
            информацию о пользователях и сообществах. По умолчанию: 0.
        :param fields: список дополнительных полей для профилей и сообществ, которые необходимо вернуть.
            Обратите внимание, этот параметр учитывается только при extended=1.
        :param comment_id: идентификатор комментария, ветку которого нужно получить.
        :param thread_items_count: максимальное число элементов в поле thread.

        :return: После успешного выполнения возвращает объект, содержащий число результатов в поле count и массив
            объектов комментариев в поле items, а также поля:   current_level_count (integer) — количество
            комментариев в ветке.  can_post (boolean) – может ли текущий пользователь оставлять комментарии в этой
            ветке.  show_reply_button (boolean) – нужно ли отображать кнопку «ответить» в ветке.  groups_can_post
            (boolean) – могут ли сообщества оставлять комментарии в ветке.   Если был задан параметр need_likes=1, у
            объектов комментариев возвращается дополнительное поле likes, содержащее объект с полями:   count — число
            пользователей, которым понравился комментарий;  user_likes — наличие отметки «Мне нравится» от текущего
            пользователя  (1 — есть, 0 — нет);  can_like — информация о том, может ли текущий пользователь поставить
            отметку «Мне нравится»  (1 — может, 0 — не может).   Если был передан параметр start_comment_id, будет
            также возвращено поле real_offset – итоговое смещение данного подмножества комментариев (оно может быть
            отрицательным, если был указан отрицательный offset).  Если был задан параметр extended=1, возвращает
            число результатов в поле count, отдельно массив объектов комментариев в поле items, пользователей в поле
            profiles и сообществ в поле groups
        """

        params = locals()
        method_name = self._base_method + 'getComments'
        return self._call(method_name, params)

    def getReposts(self, owner_id: str = None, post_id: str = None, offset: str = None, count: str = None) -> dict:
        """
        Позволяет получать список репостов заданной записи.

        :param owner_id: идентификатор пользователя или сообщества, на стене которого находится запись. Если
            параметр не задан, то он считается равным идентификатору текущего пользователя. Обратите внимание,
            идентификатор сообщества в параметре owner_id необходимо указывать со знаком "-" — например, owner_id=-1
            соответствует идентификатору сообщества ВКонтакте API (club1)
        :param post_id: идентификатор записи на стене.
        :param offset: смещение, необходимое для выборки определенного подмножества записей.
        :param count: количество записей, которое необходимо получить.

        :return: После успешного выполнения возвращает объект, содержащий поля:   items — содержит массив
            записей-репостов;  profiles — содержит объекты пользователей с дополнительными полями sex, online, photo,
            photo_medium_rec, screen_name;  groups — содержит информацию о сообществах
        """

        params = locals()
        method_name = self._base_method + 'getReposts'
        return self._call(method_name, params)

    def openComments(self, owner_id: str = None, post_id: str = None) -> dict:
        """
        Включает комментирование записи

        :param owner_id:
        :param post_id:

        :return: Возвращает 1 в случае успех
        """

        params = locals()
        method_name = self._base_method + 'openComments'
        return self._call(method_name, params)

    def pin(self, owner_id: str = None, post_id: str = None) -> dict:
        """
        Закрепляет запись на стене (запись будет отображаться выше остальных).

        :param owner_id: идентификатор пользователя или сообщества, на стене которого находится запись. Обратите
            внимание, идентификатор сообщества в параметре owner_id необходимо указывать со знаком "-" — например,
            owner_id=-1 соответствует идентификатору сообщества ВКонтакте API (club1)
        :param post_id: идентификатор записи на стене.

        :return: После успешного выполнения возвращает 1
        """

        params = locals()
        method_name = self._base_method + 'pin'
        return self._call(method_name, params)

    def post(self, owner_id: str = None, friends_only: str = None, from_group: str = None, message: str = None,
             attachments: str = None, services: str = None, signed: str = None, publish_date: str = None,
             lat: str = None, long: str = None, place_id: str = None, post_id: str = None, guid: str = None,
             mark_as_ads: str = None, close_comments: str = None, mute_notifications: str = None,
             copyright: str = None) -> dict:
        """
        Позволяет создать запись на стене, предложить запись на стене публичной страницы, опубликовать существующую
        отложенную запись.

        :param owner_id: идентификатор пользователя или сообщества, на стене которого должна быть опубликована
            запись. Обратите внимание, идентификатор сообщества в параметре owner_id необходимо указывать со знаком
            "-" — например, owner_id=-1 соответствует идентификатору сообщества ВКонтакте API (club1)
        :param friends_only: 1 — запись будет доступна только друзьям, 0 — всем пользователям. По умолчанию
            публикуемые записи доступны всем пользователям.
        :param from_group: данный параметр учитывается, если owner_id < 0 (запись публикуется на стене группы). 1
            — запись будет опубликована от имени группы, 0 — запись будет опубликована от имени пользователя (по
            умолчанию).
        :param message: текст сообщения (является обязательным, если не задан параметр attachments)
        :param attachments: список объектов, приложенных к записи и разделённых символом ",". Поле attachments
            представляется в формате: <type><owner_id>_<media_id>,<type><owner_id>_<media_id>   <type> — тип медиа-
            приложения:   photo — фотография;  video — видеозапись ;  audio — аудиозапись;  doc — документ;  page —
            wiki-страница;  note — заметка;  poll — опрос;  album — альбом;  market — товар;  market_album — подборка
            товаров;  audio_playlist — плейлист с аудио.   <owner_id> — идентификатор владельца медиа-приложения
            (обратите внимание, если объект находится в сообществе, этот параметр должен быть отрицательным).
            <media_id> — идентификатор медиа-приложения.   Например: photo100172_166443618,photo-1_265827614  Также в
            поле attachments может быть указана ссылка на внешнюю страницу, которую Вы хотите разместить в записи,
            например: photo66748_265827614,http://habrahabr.ru  При попытке приложить больше одной ссылки будет
            возвращена ошибка.   Параметр является обязательным, если не задан параметр message.
        :param services: список сервисов или сайтов, на которые необходимо экспортировать запись, в случае если
            пользователь настроил соответствующую опцию. Например, twitter, facebook.
        :param signed: 1 — у записи, размещенной от имени сообщества, будет добавлена подпись (имя пользователя,
            разместившего запись), 0 — подписи добавлено не будет. Параметр учитывается только при публикации на
            стене сообщества и указании параметра from_group. По умолчанию подпись не добавляется.
        :param publish_date: дата публикации записи в формате unixtime. Если параметр указан, публикация записи
            будет отложена до указанного времени.
        :param lat: географическая широта отметки, заданная в градусах (от -90 до 90).
        :param long: географическая долгота отметки, заданная в градусах (от -180 до 180).
        :param place_id: идентификатор места, в котором отмечен пользователь.
        :param post_id: идентификатор записи, которую необходимо опубликовать. Данный параметр используется для
            публикации отложенных записей и предложенных новостей.
        :param guid: уникальный идентификатор, предназначенный для предотвращения повторной отправки одинаковой
            записи. Действует в течение одного часа.
        :param mark_as_ads: 1 — у записи, размещенной от имени сообщества, будет добавлена метка "это реклама", 0
            — метки добавлено не будет. В сутки может быть опубликовано не более пяти рекламных записей, из которых
            не более трёх — вне Биржи ВКонтакте.
        :param close_comments: 1 — комментарии к записи отключены.  0 — комментарии к записи включены.
        :param mute_notifications: 1 — уведомления к записи отключены.  0 — уведомления к записи включены.
        :param copyright: источник материала. Поддерживаются внешние и внутренние ссылки.

        :return: После успешного выполнения возвращает идентификатор созданной записи (post_id)
        """

        params = locals()
        method_name = self._base_method + 'post'
        return self._call(method_name, params)

    def postAdsStealth(self, owner_id: str = None, message: str = None, attachments: str = None, signed: str = None,
                       lat: str = None, long: str = None, place_id: str = None, guid: str = None,
                       link_button: str = None, link_title: str = None, link_image: str = None,
                       link_video: str = None) -> dict:
        """
        Позволяет создать скрытую запись, которая не попадает на стену сообщества и в дальнейшем может быть
        использована для создания рекламного объявления типа "Запись в сообществе".

        :param owner_id: идентификатор владельца стены (идентификатор сообщества нужно указывать со знаком
            «минус»).
        :param message: текст записи.
        :param attachments: список объектов, приложенных к записи и разделённых символом ",".   В поле может быть
            указана ссылка на страницу, которую Вы хотите разместить в записи, например:
            photo66748_265827614,http://habrahabr.ru   Либо поле attachments представляется в формате:
            <type><owner_id>_<media_id>,<type><owner_id>_<media_id>   <type> — тип медиа-приложения:   photo —
            фотография;  video — видеозапись;  audio — аудиозапись;  doc — документ;  page — wiki-страница;  note —
            заметка;  poll — опрос;  album — альбом;  market — товар;  market_album — подборка товаров,  pretty_card
            — карточка карусели.   <owner_id> — идентификатор владельца медиа-приложения (обратите внимание, если
            объект находится в сообществе, этот параметр должен быть отрицательным).  <media_id> — идентификатор
            медиа-приложения.   Например: photo100172_166443618,photo-1_265827614  В качестве ссылки может быть
            использован телефонный номер в формате tel:+71234567890  При попытке приложить больше одной ссылки будет
            возвращена ошибка.   Параметр является обязательным, если не задан параметр message.
        :param signed: 1 — у записи, размещенной от имени сообщества, будет добавлена подпись (имя пользователя,
            разместившего запись), 0 — без подписи.
        :param lat: географическая широта отметки, заданная в градусах (от -90 до 90).
        :param long: географическая долгота отметки, заданная в градусах (от -180 до 180).
        :param place_id: идентификатор места.
        :param guid: уникальный идентификатор, предназначенный для предотвращения повторной отправки одинаковой
            записи.
        :param link_button: идентификатор кнопки, которую необходимо добавить к сниппету для ссылки.  link_button
            Текст Действие Тип ссылок auto (автовыбор) (автовыбор) Все app_join Запустить Переход по ссылке
            Приложения и игры app_game_join Играть Переход по ссылке Игры open_url Перейти Переход по ссылке Внешние
            сайты, сообщества, приложения open Открыть Переход по ссылке Внешние сайты more Подробнее Переход по
            ссылке Сообщества call Позвонить Набор номера Телефонные номера book Забронировать Набор номера
            Телефонные номера enroll Записаться Переход по ссылке или набор номера Внешние сайты, телефонные номера
            register Зарегистрироваться Набор номера Телефонные номера buy Купить Переход по ссылке Внешние сайты
            buy_ticket Купить билет Переход по ссылке Внешние сайты order Заказать Переход по ссылке Внешние сайты
            create Создать Переход по ссылке Внешние сайты install Установить Переход по ссылке Внешние сайты contact
            Связаться Переход по ссылке Внешние сайты fill Заполнить Переход по ссылке Внешние сайты join_public
            Подписаться Подписка на публичную страницу Публичные страницы join_event Я пойду Участие в мероприятии
            События join Вступить Вступление в сообщество Сообщества im Связаться Переход к диалогу с сообществом
            Сообщества, публичные страницы, события im2 Написать Переход к диалогу с сообществом Сообщества,
            публичные страницы, события begin Начать Переход по ссылке Внешние сайты get Получить Переход по ссылке
            Внешние сайты watch Смотреть Переход по ссылке Внешние сайты download Скачать Переход по ссылке Внешние
            сайты participate Участвовать Переход по ссылке Внешние сайты play Играть Переход по ссылке Внешние сайты
            apply Подать заявку Переход по ссылке Внешние сайты get_an_offer Получить предложение Переход по ссылке
            Внешние сайты to_write Написать Переход по ссылке Внешние сайты reply Откликнуться Переход по ссылке
            Внешние сайты
        :param link_title: заголовок, который должен быть использован для сниппета. Если не указан, будет
            автоматически получен с целевой ссылки. Обязательно указывать в случае, если ссылка является номером
            телефона.
        :param link_image: ссылка на изображение, которое должно быть использовано для сниппета. Минимальное
            разрешение: 537x240. Если не указана, будет автоматически загружена с целевой ссылки. Обязательно
            указывать в случае, если ссылка является номером телефона. Одновременно может быть указан либо параметр
            link_image, либо параметр link_video.
        :param link_video: идентификатор видео в формате "<owner_id>_<media_id>". Одновременно может быть указан
            либо параметр link_image, либо параметр link_video. Кроме того, параметр link_video может быть указан
            только вместе с параметрами link_button, link_title.

        :return: Идентификатор созданной запис
        """

        params = locals()
        method_name = self._base_method + 'postAdsStealth'
        return self._call(method_name, params)

    def reportComment(self, owner_id: str = None, comment_id: str = None, reason: str = None) -> dict:
        """
        Позволяет пожаловаться на комментарий к записи.

        :param owner_id: идентификатор пользователя или сообщества, которому принадлежит комментарий.
        :param comment_id: идентификатор комментария.
        :param reason: причина жалобы:   0 — спам;  1 — детская порнография;  2 — экстремизм;  3 — насилие;  4 —
            пропаганда наркотиков;  5 — материал для взрослых;  6 — оскорбление;  8 — призывы к суициду.

        :return: После успешного выполнения возвращает 1
        """

        params = locals()
        method_name = self._base_method + 'reportComment'
        return self._call(method_name, params)

    def reportPost(self, owner_id: str = None, post_id: str = None, reason: str = None) -> dict:
        """
        Позволяет пожаловаться на запись.

        :param owner_id: идентификатор пользователя или сообщества, которому принадлежит запись.
        :param post_id: идентификатор записи.
        :param reason: причина жалобы:   0 — спам;  1 — детская порнография;  2 — экстремизм;  3 — насилие;  4 —
            пропаганда наркотиков;  5 — материал для взрослых;  6 — оскорбление;  8 — призывы к суициду.

        :return: После успешного выполнения возвращает 1
        """

        params = locals()
        method_name = self._base_method + 'reportPost'
        return self._call(method_name, params)

    def repost(self, object: str = None, message: str = None, group_id: str = None, mark_as_ads: str = None,
               mute_notifications: str = None) -> dict:
        """
        Копирует объект на стену пользователя или сообщества.

        :param object: строковый идентификатор объекта, который необходимо разместить на стене, например,
            wall66748_3675 или wall-1_340364.  Формируется из типа объекта (wall, photo, video и т.п.),
            идентификатора владельца объекта и идентификатора самого объекта.
        :param message: сопроводительный текст, который будет добавлен к записи с объектом.
        :param group_id: идентификатор сообщества, на стене которого будет размещена запись с объектом. Если не
            указан, запись будет размещена на стене текущего пользователя.
        :param mark_as_ads: 1 — пометить запись как рекламную.
        :param mute_notifications:

        :return: После успешного выполнения возвращает объект со следующими полями:   success — всегда содержит
            1;  post_id — идентификатор созданной записи;  reposts_count — количество репостов объекта с учетом
            осуществленного;  likes_count — число отметок «Мне нравится» у объекта
        """

        params = locals()
        method_name = self._base_method + 'repost'
        return self._call(method_name, params)

    def restore(self, owner_id: str = None, post_id: str = None) -> dict:
        """
        Восстанавливает удаленную запись на стене пользователя или сообщества.

        :param owner_id: идентификатор пользователя или сообщества, на стене которого находилась удаленная
            запись. Обратите внимание, идентификатор сообщества в параметре owner_id необходимо указывать со знаком
            "-" — например, owner_id=-1 соответствует идентификатору сообщества ВКонтакте API (club1)
        :param post_id: идентификатор записи на стене.

        :return: После успешного выполнения возвращает 1
        """

        params = locals()
        method_name = self._base_method + 'restore'
        return self._call(method_name, params)

    def restoreComment(self, owner_id: str = None, comment_id: str = None) -> dict:
        """
        Восстанавливает удаленный комментарий к записи на стене.

        :param owner_id: идентификатор пользователя или сообщества, на стене которого находится комментарий к
            записи. Обратите внимание, идентификатор сообщества в параметре owner_id необходимо указывать со знаком
            "-" — например, owner_id=-1 соответствует идентификатору сообщества ВКонтакте API (club1)
        :param comment_id: идентификатор комментария на стене.

        :return: После успешного выполнения возвращает 1
        """

        params = locals()
        method_name = self._base_method + 'restoreComment'
        return self._call(method_name, params)

    def search(self, owner_id: str = None, domain: str = None, query: str = None, owners_only: str = None,
               count: str = None, offset: str = None, extended: str = None, fields: str = None) -> dict:
        """
        Позволяет искать записи на стене в соответствии с заданными критериями.

        :param owner_id: идентификатор пользователя или сообщества. Обратите внимание, идентификатор сообщества в
            параметре owner_id необходимо указывать со знаком "-" — например, owner_id=-1 соответствует
            идентификатору сообщества ВКонтакте API (club1)
        :param domain: короткий адрес пользователя или сообщества.
        :param query: поисковой запрос. Для точного результата запрос необходимо передавать в двойных кавычках.
        :param owners_only: 1 — возвращать только записи от имени владельца стены.
        :param count: количество записей, которые необходимо вернуть.
        :param offset: смещение, необходимо для получения определенного подмножества результатов.
        :param extended: 1 — в ответе будут возвращены дополнительные поля profiles и groups, содержащие
            информацию о пользователях и сообществах. По умолчанию: 0.
        :param fields: список дополнительных полей для профилей и групп, которые необходимо вернуть. См. описание
            полей объекта user и описание полей объекта group.  Обратите внимание, этот параметр учитывается только
            при extended=1.

        :return: После успешного выполнения возвращает объект, содержащий число результатов в поле count и массив
            объектов записей на стене в поле items.  Если был задан параметр extended=1, возвращает число результатов
            в поле count, отдельно массив объектов записей на стене в поле items, пользователей в поле profiles и
            сообществ в поле groups
        """

        params = locals()
        method_name = self._base_method + 'search'
        return self._call(method_name, params)

    def unpin(self, owner_id: str = None, post_id: str = None) -> dict:
        """
        Отменяет закрепление записи на стене.

        :param owner_id: идентификатор пользователя или сообщества, на стене которого находится запись. Обратите
            внимание, идентификатор сообщества в параметре owner_id необходимо указывать со знаком "-" — например,
            owner_id=-1 соответствует идентификатору сообщества ВКонтакте API (club1)
        :param post_id: идентификатор записи на стене.

        :return: После успешного выполнения возвращает 1
        """

        params = locals()
        method_name = self._base_method + 'unpin'
        return self._call(method_name, params)
