# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/02_stata.ipynb.

# %% auto 0
__all__ = ['get_local', 'set_local', 'get_global', 'get_scalar', 'stata_formatted', 'variable_names', 'drop_var', 'obs_count',
           'pwd', 'macro_expand', 'run_direct', 'run_single', 'resolve_macro']

# %% ../nbs/02_stata.ipynb 5
from .misc_utils import print_red

# %% ../nbs/02_stata.ipynb 9
def get_local(name):
    import sfi
    return sfi.Macro.getLocal(name)

# %% ../nbs/02_stata.ipynb 11
def set_local(name, value):
    import sfi
    return sfi.Macro.setLocal(name, value)

# %% ../nbs/02_stata.ipynb 13
def get_global(name):
    import sfi
    return sfi.Macro.getGlobal(name)

# %% ../nbs/02_stata.ipynb 15
def get_scalar(name):
    import sfi
    return sfi.Scalar.getValue(name)

# %% ../nbs/02_stata.ipynb 17
def stata_formatted(value, s_format):
    import sfi
    return sfi.SFIToolkit.formatValue(value, s_format)

# %% ../nbs/02_stata.ipynb 19
def variable_names():
    from sfi import Data
    return [Data.getVarName(i) for i in range(Data.getVarCount())]

# %% ../nbs/02_stata.ipynb 23
def drop_var(name):
    import sfi
    sfi.Data.dropVar(name)

# %% ../nbs/02_stata.ipynb 26
def obs_count():
    """Count the number of observations"""
    import sfi
    return sfi.Data.getObsTotal()

# %% ../nbs/02_stata.ipynb 29
def pwd():
    from sfi import SFIToolkit
    return SFIToolkit.getWorkingDir()

# %% ../nbs/02_stata.ipynb 32
def macro_expand(s):
    from sfi import SFIToolkit
    return SFIToolkit.macroExpand(s)

# %% ../nbs/02_stata.ipynb 35
def run_direct(cmds, quietly=False, echo=False, inline=True):
    import pystata
    return pystata.stata.run(cmds, quietly, echo, inline)

# %% ../nbs/02_stata.ipynb 43
def run_single(cmd, echo=False, show_exc_warning=True):
    import sfi
    try:
        sfi.SFIToolkit.stata(cmd, echo)
    except Exception as e:
        sfi.SFIToolkit.stata("", echo)
        raise e
#         if show_exc_warning:
#             print_red(f"Warning: run_single (sfi.SFIToolkit.stata) error: {repr(e)}\n"
#                       "Re-running code with run_direct.")
#         run_direct(cmd, echo=echo)

# %% ../nbs/02_stata.ipynb 60
def resolve_macro(macro):
    macro = macro.strip()
    if macro.startswith("`") and macro.endswith("'"):
        macro = get_local(macro[1:-1])
    elif macro.startswith("$_"):
        macro = get_local(macro[2:])
    elif macro.startswith("${") and macro.endswith("}"):
        macro = get_global(macro[2:-1])
    elif macro.startswith("$"):
        macro = get_global(macro[1:])
    return macro
