# coding: utf-8

"""
    Smooch

    The Smooch API is a unified interface for powering messaging in your customer experiences across every channel. Our API speeds access to new markets, reduces time to ship, eliminates complexity, and helps you build the best experiences for your customers. For more information, visit our [official documentation](https://docs.smooch.io).

    OpenAPI spec version: 5.30
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class ServiceAccountApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def create_secret_key(self, service_account_id, secret_key_create_body, **kwargs):
        """
        Create a secret key for the specified service account.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_secret_key(service_account_id, secret_key_create_body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str service_account_id: Identifies the service account. (required)
        :param SecretKeyCreate secret_key_create_body: Body for a createSecretKey request. (required)
        :return: SecretKeyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_secret_key_with_http_info(service_account_id, secret_key_create_body, **kwargs)
        else:
            (data) = self.create_secret_key_with_http_info(service_account_id, secret_key_create_body, **kwargs)
            return data

    def create_secret_key_with_http_info(self, service_account_id, secret_key_create_body, **kwargs):
        """
        Create a secret key for the specified service account.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_secret_key_with_http_info(service_account_id, secret_key_create_body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str service_account_id: Identifies the service account. (required)
        :param SecretKeyCreate secret_key_create_body: Body for a createSecretKey request. (required)
        :return: SecretKeyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['service_account_id', 'secret_key_create_body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_secret_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'service_account_id' is set
        if ('service_account_id' not in params) or (params['service_account_id'] is None):
            raise ValueError("Missing the required parameter `service_account_id` when calling `create_secret_key`")
        # verify the required parameter 'secret_key_create_body' is set
        if ('secret_key_create_body' not in params) or (params['secret_key_create_body'] is None):
            raise ValueError("Missing the required parameter `secret_key_create_body` when calling `create_secret_key`")


        collection_formats = {}

        path_params = {}
        if 'service_account_id' in params:
            path_params['serviceAccountId'] = params['service_account_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'secret_key_create_body' in params:
            body_params = params['secret_key_create_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basicAuth', 'jwt']

        return self.api_client.call_api('/v1.1/serviceaccounts/{serviceAccountId}/keys', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='SecretKeyResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_service_account(self, service_account_create_body, **kwargs):
        """
        Create a new service account.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_service_account(service_account_create_body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ServiceAccountCreate service_account_create_body: Body for a createServiceAccount request. (required)
        :return: ServiceAccountResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_service_account_with_http_info(service_account_create_body, **kwargs)
        else:
            (data) = self.create_service_account_with_http_info(service_account_create_body, **kwargs)
            return data

    def create_service_account_with_http_info(self, service_account_create_body, **kwargs):
        """
        Create a new service account.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_service_account_with_http_info(service_account_create_body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ServiceAccountCreate service_account_create_body: Body for a createServiceAccount request. (required)
        :return: ServiceAccountResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['service_account_create_body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_service_account" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'service_account_create_body' is set
        if ('service_account_create_body' not in params) or (params['service_account_create_body'] is None):
            raise ValueError("Missing the required parameter `service_account_create_body` when calling `create_service_account`")


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'service_account_create_body' in params:
            body_params = params['service_account_create_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basicAuth', 'jwt']

        return self.api_client.call_api('/v1.1/serviceaccounts', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ServiceAccountResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_secret_key(self, service_account_id, key_id, **kwargs):
        """
        Delete the specified service account secret key.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_secret_key(service_account_id, key_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str service_account_id: Identifies the service account. (required)
        :param str key_id: Identifies the secret key. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_secret_key_with_http_info(service_account_id, key_id, **kwargs)
        else:
            (data) = self.delete_secret_key_with_http_info(service_account_id, key_id, **kwargs)
            return data

    def delete_secret_key_with_http_info(self, service_account_id, key_id, **kwargs):
        """
        Delete the specified service account secret key.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_secret_key_with_http_info(service_account_id, key_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str service_account_id: Identifies the service account. (required)
        :param str key_id: Identifies the secret key. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['service_account_id', 'key_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_secret_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'service_account_id' is set
        if ('service_account_id' not in params) or (params['service_account_id'] is None):
            raise ValueError("Missing the required parameter `service_account_id` when calling `delete_secret_key`")
        # verify the required parameter 'key_id' is set
        if ('key_id' not in params) or (params['key_id'] is None):
            raise ValueError("Missing the required parameter `key_id` when calling `delete_secret_key`")


        collection_formats = {}

        path_params = {}
        if 'service_account_id' in params:
            path_params['serviceAccountId'] = params['service_account_id']
        if 'key_id' in params:
            path_params['keyId'] = params['key_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basicAuth', 'jwt']

        return self.api_client.call_api('/v1.1/serviceaccounts/{serviceAccountId}/keys/{keyId}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_service_account(self, service_account_id, **kwargs):
        """
        Delete the specified service account.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_service_account(service_account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str service_account_id: Identifies the service account. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_service_account_with_http_info(service_account_id, **kwargs)
        else:
            (data) = self.delete_service_account_with_http_info(service_account_id, **kwargs)
            return data

    def delete_service_account_with_http_info(self, service_account_id, **kwargs):
        """
        Delete the specified service account.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_service_account_with_http_info(service_account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str service_account_id: Identifies the service account. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['service_account_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_service_account" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'service_account_id' is set
        if ('service_account_id' not in params) or (params['service_account_id'] is None):
            raise ValueError("Missing the required parameter `service_account_id` when calling `delete_service_account`")


        collection_formats = {}

        path_params = {}
        if 'service_account_id' in params:
            path_params['serviceAccountId'] = params['service_account_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basicAuth', 'jwt']

        return self.api_client.call_api('/v1.1/serviceaccounts/{serviceAccountId}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_jwt(self, service_account_id, key_id, **kwargs):
        """
        Get an account-scoped JWT for the specified service account secret key.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_jwt(service_account_id, key_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str service_account_id: Identifies the service account. (required)
        :param str key_id: Identifies the secret key. (required)
        :return: JwtResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_jwt_with_http_info(service_account_id, key_id, **kwargs)
        else:
            (data) = self.get_jwt_with_http_info(service_account_id, key_id, **kwargs)
            return data

    def get_jwt_with_http_info(self, service_account_id, key_id, **kwargs):
        """
        Get an account-scoped JWT for the specified service account secret key.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_jwt_with_http_info(service_account_id, key_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str service_account_id: Identifies the service account. (required)
        :param str key_id: Identifies the secret key. (required)
        :return: JwtResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['service_account_id', 'key_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_jwt" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'service_account_id' is set
        if ('service_account_id' not in params) or (params['service_account_id'] is None):
            raise ValueError("Missing the required parameter `service_account_id` when calling `get_jwt`")
        # verify the required parameter 'key_id' is set
        if ('key_id' not in params) or (params['key_id'] is None):
            raise ValueError("Missing the required parameter `key_id` when calling `get_jwt`")


        collection_formats = {}

        path_params = {}
        if 'service_account_id' in params:
            path_params['serviceAccountId'] = params['service_account_id']
        if 'key_id' in params:
            path_params['keyId'] = params['key_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basicAuth', 'jwt']

        return self.api_client.call_api('/v1.1/serviceaccounts/{serviceAccountId}/keys/{keyId}/jwt', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='JwtResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_secret_key(self, service_account_id, key_id, **kwargs):
        """
        Get the specified service account secret key.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_secret_key(service_account_id, key_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str service_account_id: Identifies the service account. (required)
        :param str key_id: Identifies the secret key. (required)
        :return: SecretKeyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_secret_key_with_http_info(service_account_id, key_id, **kwargs)
        else:
            (data) = self.get_secret_key_with_http_info(service_account_id, key_id, **kwargs)
            return data

    def get_secret_key_with_http_info(self, service_account_id, key_id, **kwargs):
        """
        Get the specified service account secret key.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_secret_key_with_http_info(service_account_id, key_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str service_account_id: Identifies the service account. (required)
        :param str key_id: Identifies the secret key. (required)
        :return: SecretKeyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['service_account_id', 'key_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_secret_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'service_account_id' is set
        if ('service_account_id' not in params) or (params['service_account_id'] is None):
            raise ValueError("Missing the required parameter `service_account_id` when calling `get_secret_key`")
        # verify the required parameter 'key_id' is set
        if ('key_id' not in params) or (params['key_id'] is None):
            raise ValueError("Missing the required parameter `key_id` when calling `get_secret_key`")


        collection_formats = {}

        path_params = {}
        if 'service_account_id' in params:
            path_params['serviceAccountId'] = params['service_account_id']
        if 'key_id' in params:
            path_params['keyId'] = params['key_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basicAuth', 'jwt']

        return self.api_client.call_api('/v1.1/serviceaccounts/{serviceAccountId}/keys/{keyId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='SecretKeyResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_service_account(self, service_account_id, **kwargs):
        """
        Get the specified service account.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_service_account(service_account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str service_account_id: Identifies the service account. (required)
        :return: ServiceAccountResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_service_account_with_http_info(service_account_id, **kwargs)
        else:
            (data) = self.get_service_account_with_http_info(service_account_id, **kwargs)
            return data

    def get_service_account_with_http_info(self, service_account_id, **kwargs):
        """
        Get the specified service account.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_service_account_with_http_info(service_account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str service_account_id: Identifies the service account. (required)
        :return: ServiceAccountResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['service_account_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_service_account" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'service_account_id' is set
        if ('service_account_id' not in params) or (params['service_account_id'] is None):
            raise ValueError("Missing the required parameter `service_account_id` when calling `get_service_account`")


        collection_formats = {}

        path_params = {}
        if 'service_account_id' in params:
            path_params['serviceAccountId'] = params['service_account_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basicAuth', 'jwt']

        return self.api_client.call_api('/v1.1/serviceaccounts/{serviceAccountId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ServiceAccountResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_secret_keys(self, service_account_id, **kwargs):
        """
        List the secret keys for the specified service account.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_secret_keys(service_account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str service_account_id: Identifies the service account. (required)
        :return: ListSecretKeysResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_secret_keys_with_http_info(service_account_id, **kwargs)
        else:
            (data) = self.list_secret_keys_with_http_info(service_account_id, **kwargs)
            return data

    def list_secret_keys_with_http_info(self, service_account_id, **kwargs):
        """
        List the secret keys for the specified service account.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_secret_keys_with_http_info(service_account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str service_account_id: Identifies the service account. (required)
        :return: ListSecretKeysResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['service_account_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_secret_keys" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'service_account_id' is set
        if ('service_account_id' not in params) or (params['service_account_id'] is None):
            raise ValueError("Missing the required parameter `service_account_id` when calling `list_secret_keys`")


        collection_formats = {}

        path_params = {}
        if 'service_account_id' in params:
            path_params['serviceAccountId'] = params['service_account_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basicAuth', 'jwt']

        return self.api_client.call_api('/v1.1/serviceaccounts/{serviceAccountId}/keys', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ListSecretKeysResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_service_accounts(self, **kwargs):
        """
        List all service accounts configured.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_service_accounts(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int limit: The number of records to return.
        :param int offset: The number of initial records to skip before picking records to return.
        :return: ListServiceAccountsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_service_accounts_with_http_info(**kwargs)
        else:
            (data) = self.list_service_accounts_with_http_info(**kwargs)
            return data

    def list_service_accounts_with_http_info(self, **kwargs):
        """
        List all service accounts configured.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_service_accounts_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int limit: The number of records to return.
        :param int offset: The number of initial records to skip before picking records to return.
        :return: ListServiceAccountsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'offset']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_service_accounts" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))
        if 'offset' in params:
            query_params.append(('offset', params['offset']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basicAuth', 'jwt']

        return self.api_client.call_api('/v1.1/serviceaccounts', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ListServiceAccountsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_service_account(self, service_account_id, service_account_update_body, **kwargs):
        """
        Update the specified service account.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_service_account(service_account_id, service_account_update_body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str service_account_id: Identifies the service account. (required)
        :param ServiceAccountUpdate service_account_update_body: Body for an updateServiceAccount request. (required)
        :return: ServiceAccountResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_service_account_with_http_info(service_account_id, service_account_update_body, **kwargs)
        else:
            (data) = self.update_service_account_with_http_info(service_account_id, service_account_update_body, **kwargs)
            return data

    def update_service_account_with_http_info(self, service_account_id, service_account_update_body, **kwargs):
        """
        Update the specified service account.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_service_account_with_http_info(service_account_id, service_account_update_body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str service_account_id: Identifies the service account. (required)
        :param ServiceAccountUpdate service_account_update_body: Body for an updateServiceAccount request. (required)
        :return: ServiceAccountResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['service_account_id', 'service_account_update_body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_service_account" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'service_account_id' is set
        if ('service_account_id' not in params) or (params['service_account_id'] is None):
            raise ValueError("Missing the required parameter `service_account_id` when calling `update_service_account`")
        # verify the required parameter 'service_account_update_body' is set
        if ('service_account_update_body' not in params) or (params['service_account_update_body'] is None):
            raise ValueError("Missing the required parameter `service_account_update_body` when calling `update_service_account`")


        collection_formats = {}

        path_params = {}
        if 'service_account_id' in params:
            path_params['serviceAccountId'] = params['service_account_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'service_account_update_body' in params:
            body_params = params['service_account_update_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basicAuth', 'jwt']

        return self.api_client.call_api('/v1.1/serviceaccounts/{serviceAccountId}', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ServiceAccountResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
