# coding: utf-8

"""
    Smooch

    The Smooch API is a unified interface for powering messaging in your customer experiences across every channel. Our API speeds access to new markets, reduces time to ship, eliminates complexity, and helps you build the best experiences for your customers. For more information, visit our [official documentation](https://docs.smooch.io).

    OpenAPI spec version: 5.30
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class NotificationPost(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, destination=None, message_schema=None, author=None, message=None):
        """
        NotificationPost - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'destination': 'NotificationPostDestination',
            'message_schema': 'str',
            'author': 'Author',
            'message': 'object'
        }

        self.attribute_map = {
            'destination': 'destination',
            'message_schema': 'messageSchema',
            'author': 'author',
            'message': 'message'
        }

        self._destination = None
        self._message_schema = None
        self._author = None
        self._message = None

        # TODO: let required properties as mandatory parameter in the constructor.
        #       - to check if required property is not None (e.g. by calling setter)
        #       - ApiClient.__deserialize_model has to be adapted as well
        if destination is not None:
          self.destination = destination
        if message_schema is not None:
          self.message_schema = message_schema
        if author is not None:
          self.author = author
        if message is not None:
          self.message = message

    @property
    def destination(self):
        """
        Gets the destination of this NotificationPost.
        The destination of the notification.

        :return: The destination of this NotificationPost.
        :rtype: NotificationPostDestination
        """
        return self._destination

    @destination.setter
    def destination(self, destination):
        """
        Sets the destination of this NotificationPost.
        The destination of the notification.

        :param destination: The destination of this NotificationPost.
        :type: NotificationPostDestination
        """
        if destination is None:
            raise ValueError("Invalid value for `destination`, must not be `None`")

        self._destination = destination

    @property
    def message_schema(self):
        """
        Gets the message_schema of this NotificationPost.
        If specified, the only accepted value is `whatsapp`. To be included when sending WhatsApp message templates.

        :return: The message_schema of this NotificationPost.
        :rtype: str
        """
        return self._message_schema

    @message_schema.setter
    def message_schema(self, message_schema):
        """
        Sets the message_schema of this NotificationPost.
        If specified, the only accepted value is `whatsapp`. To be included when sending WhatsApp message templates.

        :param message_schema: The message_schema of this NotificationPost.
        :type: str
        """

        self._message_schema = message_schema

    @property
    def author(self):
        """
        Gets the author of this NotificationPost.
        An object containing role, email, name and avatarUrl.

        :return: The author of this NotificationPost.
        :rtype: Author
        """
        return self._author

    @author.setter
    def author(self, author):
        """
        Sets the author of this NotificationPost.
        An object containing role, email, name and avatarUrl.

        :param author: The author of this NotificationPost.
        :type: Author
        """
        if author is None:
            raise ValueError("Invalid value for `author`, must not be `None`")

        self._author = author

    @property
    def message(self):
        """
        Gets the message of this NotificationPost.
        The notification message to send.

        :return: The message of this NotificationPost.
        :rtype: object
        """
        return self._message

    @message.setter
    def message(self, message):
        """
        Sets the message of this NotificationPost.
        The notification message to send.

        :param message: The message of this NotificationPost.
        :type: object
        """
        if message is None:
            raise ValueError("Invalid value for `message`, must not be `None`")

        self._message = message

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, NotificationPost):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
