import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::CodeStar::GitHubRepository`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html
 * @external
 */
export interface CfnGitHubRepositoryProps {
    /**
     * `AWS::CodeStar::GitHubRepository.RepositoryName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html#cfn-codestar-githubrepository-repositoryname
     * @external
     */
    readonly repositoryName: string;
    /**
     * `AWS::CodeStar::GitHubRepository.RepositoryOwner`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html#cfn-codestar-githubrepository-repositoryowner
     * @external
     */
    readonly repositoryOwner: string;
    /**
     * `AWS::CodeStar::GitHubRepository.Code`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html#cfn-codestar-githubrepository-code
     * @external
     */
    readonly code?: CfnGitHubRepository.CodeProperty | cdk.IResolvable;
    /**
     * `AWS::CodeStar::GitHubRepository.ConnectionArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html#cfn-codestar-githubrepository-connectionarn
     * @external
     */
    readonly connectionArn?: string;
    /**
     * `AWS::CodeStar::GitHubRepository.EnableIssues`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html#cfn-codestar-githubrepository-enableissues
     * @external
     */
    readonly enableIssues?: boolean | cdk.IResolvable;
    /**
     * `AWS::CodeStar::GitHubRepository.IsPrivate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html#cfn-codestar-githubrepository-isprivate
     * @external
     */
    readonly isPrivate?: boolean | cdk.IResolvable;
    /**
     * `AWS::CodeStar::GitHubRepository.RepositoryAccessToken`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html#cfn-codestar-githubrepository-repositoryaccesstoken
     * @external
     */
    readonly repositoryAccessToken?: string;
    /**
     * `AWS::CodeStar::GitHubRepository.RepositoryDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html#cfn-codestar-githubrepository-repositorydescription
     * @external
     */
    readonly repositoryDescription?: string;
}
/**
 * A CloudFormation `AWS::CodeStar::GitHubRepository`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html
 * @external
 * @cloudformationResource AWS::CodeStar::GitHubRepository
 */
export declare class CfnGitHubRepository extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CodeStar::GitHubRepository";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnGitHubRepository;
    /**
     * `AWS::CodeStar::GitHubRepository.RepositoryName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html#cfn-codestar-githubrepository-repositoryname
     * @external
     */
    repositoryName: string;
    /**
     * `AWS::CodeStar::GitHubRepository.RepositoryOwner`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html#cfn-codestar-githubrepository-repositoryowner
     * @external
     */
    repositoryOwner: string;
    /**
     * `AWS::CodeStar::GitHubRepository.Code`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html#cfn-codestar-githubrepository-code
     * @external
     */
    code: CfnGitHubRepository.CodeProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::CodeStar::GitHubRepository.ConnectionArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html#cfn-codestar-githubrepository-connectionarn
     * @external
     */
    connectionArn: string | undefined;
    /**
     * `AWS::CodeStar::GitHubRepository.EnableIssues`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html#cfn-codestar-githubrepository-enableissues
     * @external
     */
    enableIssues: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::CodeStar::GitHubRepository.IsPrivate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html#cfn-codestar-githubrepository-isprivate
     * @external
     */
    isPrivate: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::CodeStar::GitHubRepository.RepositoryAccessToken`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html#cfn-codestar-githubrepository-repositoryaccesstoken
     * @external
     */
    repositoryAccessToken: string | undefined;
    /**
     * `AWS::CodeStar::GitHubRepository.RepositoryDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html#cfn-codestar-githubrepository-repositorydescription
     * @external
     */
    repositoryDescription: string | undefined;
    /**
     * Create a new `AWS::CodeStar::GitHubRepository`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnGitHubRepositoryProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::CodeStar::GitHubRepository`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html
 * @external
 * @cloudformationResource AWS::CodeStar::GitHubRepository
 */
export declare namespace CfnGitHubRepository {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codestar-githubrepository-code.html
     * @external
     */
    interface CodeProperty {
        /**
         * `CfnGitHubRepository.CodeProperty.S3`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codestar-githubrepository-code.html#cfn-codestar-githubrepository-code-s3
         * @external
         */
        readonly s3: CfnGitHubRepository.S3Property | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::CodeStar::GitHubRepository`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestar-githubrepository.html
 * @external
 * @cloudformationResource AWS::CodeStar::GitHubRepository
 */
export declare namespace CfnGitHubRepository {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codestar-githubrepository-s3.html
     * @external
     */
    interface S3Property {
        /**
         * `CfnGitHubRepository.S3Property.Bucket`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codestar-githubrepository-s3.html#cfn-codestar-githubrepository-s3-bucket
         * @external
         */
        readonly bucket: string;
        /**
         * `CfnGitHubRepository.S3Property.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codestar-githubrepository-s3.html#cfn-codestar-githubrepository-s3-key
         * @external
         */
        readonly key: string;
        /**
         * `CfnGitHubRepository.S3Property.ObjectVersion`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codestar-githubrepository-s3.html#cfn-codestar-githubrepository-s3-objectversion
         * @external
         */
        readonly objectVersion?: string;
    }
}
