# Generated by Django 2.2.19 on 2021-02-26 07:08

from django.db import migrations, models
import django.db.models.deletion
import django_safe_fields.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='WaringCategory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(max_length=64, unique=True, verbose_name='Warning Category Code')),
                ('name', models.CharField(max_length=64, verbose_name='Warning Category Name')),
                ('display_order', models.IntegerField(blank=True, default=0, null=True, verbose_name='Display Order')),
            ],
            options={
                'verbose_name': 'Warning Category',
                'verbose_name_plural': 'Warning Categories',
            },
        ),
        migrations.CreateModel(
            name='Warning',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.IntegerField(blank=True, choices=[(0, 'Task New'), (10, 'Task Ready'), (20, 'Task Doing'), (30, 'Task Done'), (40, 'Task Failed')], default=0, help_text='Task has New, Ready, Doing, Done and Failed status.', null=True, verbose_name='Status')),
                ('active', models.NullBooleanField(help_text='The task is to be runned or is running...', verbose_name='Active')),
                ('worker', models.CharField(blank=True, max_length=128, null=True, verbose_name='Worker ID')),
                ('success', models.NullBooleanField(help_text='Task success or not.', verbose_name='Success')),
                ('result', models.TextField(blank=True, null=True, verbose_name='Result')),
                ('error_code', models.IntegerField(blank=True, null=True, verbose_name='Error Code')),
                ('error_message', models.TextField(blank=True, null=True, verbose_name='Error Message')),
                ('add_time', models.DateTimeField(auto_now_add=True, help_text='Task add time is the time when the task created.', verbose_name='Add Time')),
                ('mod_time', models.DateTimeField(auto_now=True, help_text='Task modify time is the time when the task modified.', verbose_name='Modify Time')),
                ('ready_time', models.DateTimeField(blank=True, help_text='Task ready time is the time when the task set ready. Task can only start after READY.', null=True, verbose_name='Ready Time')),
                ('start_time', models.DateTimeField(blank=True, help_text='Task start time is the time when the task start to run.', null=True, verbose_name='Start Time')),
                ('expire_time', models.DateTimeField(blank=True, help_text='Task expire time is the time when the task deactived. A task is expired, it will never be runned, even it is not runned yet.', null=True, verbose_name='Expire Time')),
                ('done_time', models.DateTimeField(blank=True, help_text='Task done time is the time when the task finished .', null=True, verbose_name='Done Time')),
                ('title', django_safe_fields.fields.SafeCharField(max_length=256, verbose_name='Warning Title')),
                ('data', django_safe_fields.fields.SafeTextField(blank=True, null=True, verbose_name='Warning Data')),
                ('category', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='django_site_warnings.WaringCategory', verbose_name='Warning Category')),
            ],
            options={
                'verbose_name': 'Warning',
                'verbose_name_plural': 'Warnings',
            },
        ),
    ]
