#
# Copyright (c) 2022, Neptune Labs Sp. z o.o.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
__all__ = [
    "InternalClientError",
    "NeptuneException",
    "NeptuneInvalidApiTokenException",
    "NeptuneApiException",
    "MetadataInconsistency",
    "MissingFieldException",
    "TypeDoesNotSupportAttributeException",
    "MalformedOperation",
    "FileNotFound",
    "FileUploadError",
    "FileSetUploadError",
    "ClientHttpError",
    "MetadataContainerNotFound",
    "ProjectNotFound",
    "RunNotFound",
    "ModelNotFound",
    "ModelVersionNotFound",
    "ExceptionWithProjectsWorkspacesListing",
    "ContainerUUIDNotFound",
    "RunUUIDNotFound",
    "ProjectNotFoundWithSuggestions",
    "AmbiguousProjectName",
    "NeptuneMissingProjectNameException",
    "InactiveContainerException",
    "InactiveRunException",
    "InactiveModelException",
    "InactiveModelVersionException",
    "InactiveProjectException",
    "NeptuneMissingApiTokenException",
    "CannotSynchronizeOfflineRunsWithoutProject",
    "NeedExistingExperimentForReadOnlyMode",
    "NeedExistingRunForReadOnlyMode",
    "NeedExistingModelForReadOnlyMode",
    "NeedExistingModelVersionForReadOnlyMode",
    "NeptuneParametersCollision",
    "NeptuneWrongInitParametersException",
    "NeptuneRunResumeAndCustomIdCollision",
    "NeptuneClientUpgradeRequiredError",
    "NeptuneMissingRequiredInitParameter",
    "CannotResolveHostname",
    "NeptuneSSLVerificationError",
    "NeptuneConnectionLostException",
    "InternalServerError",
    "Unauthorized",
    "Forbidden",
    "NeptuneOfflineModeException",
    "NeptuneOfflineModeFetchException",
    "NeptuneOfflineModeChangeStageException",
    "NeptuneProtectedPathException",
    "NeptuneCannotChangeStageManually",
    "OperationNotSupported",
    "NeptuneLegacyProjectException",
    "NeptuneIntegrationNotInstalledException",
    "NeptuneLimitExceedException",
    "NeptuneFieldCountLimitExceedException",
    "NeptuneStorageLimitException",
    "FetchAttributeNotFoundException",
    "ArtifactNotFoundException",
    "PlotlyIncompatibilityException",
    "NeptunePossibleLegacyUsageException",
    "NeptuneLegacyIncompatibilityException",
    "NeptuneUnhandledArtifactSchemeException",
    "NeptuneUnhandledArtifactTypeException",
    "NeptuneLocalStorageAccessException",
    "NeptuneRemoteStorageCredentialsException",
    "NeptuneRemoteStorageAccessException",
    "ArtifactUploadingError",
    "NeptuneUnsupportedArtifactFunctionalityException",
    "NeptuneEmptyLocationException",
    "NeptuneFeatureNotAvailableException",
    "NeptuneObjectCreationConflict",
    "NeptuneModelKeyAlreadyExistsError",
    "NeptuneSynchronizationAlreadyStoppedException",
    "StreamAlreadyUsedException",
    "NeptuneUserApiInputException",
]

from neptune.exceptions import (
    AmbiguousProjectName,
    ArtifactNotFoundException,
    ArtifactUploadingError,
    CannotResolveHostname,
    CannotSynchronizeOfflineRunsWithoutProject,
    ClientHttpError,
    ContainerUUIDNotFound,
    ExceptionWithProjectsWorkspacesListing,
    FetchAttributeNotFoundException,
    FileNotFound,
    FileSetUploadError,
    FileUploadError,
    Forbidden,
    InactiveContainerException,
    InactiveModelException,
    InactiveModelVersionException,
    InactiveProjectException,
    InactiveRunException,
    InternalClientError,
    InternalServerError,
    MalformedOperation,
    MetadataContainerNotFound,
    MetadataInconsistency,
    MissingFieldException,
    ModelNotFound,
    ModelVersionNotFound,
    NeedExistingExperimentForReadOnlyMode,
    NeedExistingModelForReadOnlyMode,
    NeedExistingModelVersionForReadOnlyMode,
    NeedExistingRunForReadOnlyMode,
    NeptuneApiException,
    NeptuneCannotChangeStageManually,
    NeptuneClientUpgradeRequiredError,
    NeptuneConnectionLostException,
    NeptuneEmptyLocationException,
    NeptuneException,
    NeptuneFeatureNotAvailableException,
    NeptuneFieldCountLimitExceedException,
    NeptuneIntegrationNotInstalledException,
    NeptuneInvalidApiTokenException,
    NeptuneLegacyIncompatibilityException,
    NeptuneLegacyProjectException,
    NeptuneLimitExceedException,
    NeptuneLocalStorageAccessException,
    NeptuneMissingApiTokenException,
    NeptuneMissingProjectNameException,
    NeptuneMissingRequiredInitParameter,
    NeptuneModelKeyAlreadyExistsError,
    NeptuneObjectCreationConflict,
    NeptuneOfflineModeChangeStageException,
    NeptuneOfflineModeException,
    NeptuneOfflineModeFetchException,
    NeptuneParametersCollision,
    NeptunePossibleLegacyUsageException,
    NeptuneProtectedPathException,
    NeptuneRemoteStorageAccessException,
    NeptuneRemoteStorageCredentialsException,
    NeptuneRunResumeAndCustomIdCollision,
    NeptuneSSLVerificationError,
    NeptuneStorageLimitException,
    NeptuneSynchronizationAlreadyStoppedException,
    NeptuneUnhandledArtifactSchemeException,
    NeptuneUnhandledArtifactTypeException,
    NeptuneUnsupportedArtifactFunctionalityException,
    NeptuneUserApiInputException,
    NeptuneWrongInitParametersException,
    OperationNotSupported,
    PlotlyIncompatibilityException,
    ProjectNotFound,
    ProjectNotFoundWithSuggestions,
    RunNotFound,
    RunUUIDNotFound,
    StreamAlreadyUsedException,
    TypeDoesNotSupportAttributeException,
    Unauthorized,
)
