M$ModelName = "VLL_singlet_Y_1_BFM";

M$Information = {
  Authors      -> {"José Santiago"}, 
  Version      -> "1.0",
  Date         -> "13. 12. 2021",
  Institutions -> {"Universidad de Granada"},
  Emails       -> {"jsantiago@ugr.es"}
};

FeynmanGauge = True;

M$ClassesDescription = {
F[105] == {
    ClassName        -> HE,
    SelfConjugate    -> False,
    QuantumNumbers -> {Y -> -1},
    Mass             -> MHE,
    FullName        -> "heavy"
  }
};

M$Parameters = {

lamprime == { 
    ParameterType     -> Internal, 
    Indices           -> {Index[Generation]},
    ComplexParameter  -> True
  },

  MHE == { 
    ParameterType     -> Internal, 
    ComplexParameter  -> False
  }

};

(* ************************** *)
(* *****   Lagrangian   ***** *)
(* ************************** *)

gotoBFM={G[a__]->G[a]+GQuantum[a],Wi[a__]->Wi[a]+WiQuantum[a],B[a__]->B[a]+BQuantum[a]};

LHeavy := Block[{mu}, 
  I*(HEbar.Ga[mu].DC[HE, mu])-MHE*HEbar.HE]/.gotoBFM;



LHeavylight := Block[{sp1,ii,ff1,yuk}, 
  yuk = -lamprime[ff1] LLbar[sp1, ii, ff1].HE [sp1] Phi[ii];
  yuk+HC[yuk]
 ];

LNP := LHeavy + LHeavylight;

Ltot := LSM + LNP;
