(* ************************** *)
(* *****  Information   ***** *)
(* ************************** *)
M$ModelName = "ALP_EFT";

M$Information = {
  Authors      -> {"J. Santiago"}, 
  Version      -> "1.0",
  Date         -> "04. 10. 2021",
  Institutions -> {"CAFPE and Universidad de Granada"},
  Emails       -> {"jsantiago@ugr.es"}
};

FeynmanGauge = True;

(* ************************** *)
(* **** Particle classes **** *)
(* ************************** *)
M$ClassesDescription = {


  S[105] == {
    ClassName        -> s,
    SelfConjugate    -> True,
    Mass             -> 0,
    FullName         -> "light",
    Width            -> 0
  }

};

(* ************************** *)
(* *****   Parameters   ***** *)
(* ************************** *)
M$Parameters = {

  (* External parameters *)

  (* Internal Parameters *)


(* Renormalizable couplings SMEFT *)

  alphaOmuH2 == {
    ParameterType -> Internal,
    ComplexParameter -> False
  },

  alphaKB == {
    ParameterType -> Internal,
    ComplexParameter -> False
  },

  alphaKW == {
    ParameterType -> Internal,
    ComplexParameter -> False
  },

  alphaKG == {
    ParameterType -> Internal,
    ComplexParameter -> False
  },

  alphaKq == {
    ParameterType -> Internal,
    Indices          -> {Index[Generation], Index[Generation]},
    ComplexParameter -> True
  },

  alphaKl == {
    ParameterType -> Internal,
    Indices          -> {Index[Generation], Index[Generation]},
    ComplexParameter -> True
  },

  alphaKu == {
    ParameterType -> Internal,
    Indices          -> {Index[Generation], Index[Generation]},
    ComplexParameter -> True
  },

  alphaKd == {
    ParameterType -> Internal,
    Indices          -> {Index[Generation], Index[Generation]},
    ComplexParameter -> True
  },

  alphaKe == {
    ParameterType -> Internal,
    Indices          -> {Index[Generation], Index[Generation]},
    ComplexParameter -> True
  },

  alphaKH == {
    ParameterType -> Internal,
    ComplexParameter -> False
  },

  alphaOlambda == {
    ParameterType -> Internal,
    ComplexParameter -> False
  },

  alphaOlambdad == {
    ParameterType -> Internal,
    Indices          -> {Index[Generation], Index[Generation]},
    ComplexParameter -> True
  },

  alphaOlambdae == {
    ParameterType -> Internal,
    Indices          -> {Index[Generation], Index[Generation]},
    ComplexParameter -> True
  },

  alphaOlambdau == {
    ParameterType -> Internal,
    Indices          -> {Index[Generation], Index[Generation]},
    ComplexParameter -> True
  },

(* Renormalizable parameters ALP *)
  
  alphaKs == { 
    ParameterType     -> Internal, 
    ComplexParameter  -> False
  },

  alphaOms2 == { 
    ParameterType     -> Internal, 
    ComplexParameter  -> False
  },

  alphaOkappas == { 
    ParameterType     -> Internal, 
    ComplexParameter  -> False
  },

  alphaOlambdas == { 
    ParameterType     -> Internal, 
    ComplexParameter  -> False
  },

  alphaOkappasphi == { 
    ParameterType     -> Internal, 
    ComplexParameter  -> False
  },

  alphaOlambdasphi == { 
    ParameterType     -> Internal, 
    ComplexParameter  -> False
  },


(* dim 5 ops *)

  alphaOs5 == { 
    ParameterType     -> Internal, 
    ComplexParameter  -> False
  },

  alphaOs3 == { 
    ParameterType     -> Internal, 
    ComplexParameter  -> False
  },

  alphaOs == { 
    ParameterType     -> Internal, 
    ComplexParameter  -> False
  },

  alphaOsuphi == {
    ParameterType -> Internal,
    Indices          -> {Index[Generation], Index[Generation]},
    ComplexParameter -> True
  },

  alphaOsdphi == {
    ParameterType -> Internal,
    Indices          -> {Index[Generation], Index[Generation]},
    ComplexParameter -> True
  },

  alphaOsephi == {
    ParameterType -> Internal,
    Indices          -> {Index[Generation], Index[Generation]},
    ComplexParameter -> True
  },

  alphaRsphibox == { 
    ParameterType     -> Internal, 
    ComplexParameter  -> True
  },

  alphaRsq == {
    ParameterType -> Internal,
    Indices          -> {Index[Generation], Index[Generation]},
    ComplexParameter -> True
  },

  alphaRsl == {
    ParameterType -> Internal,
    Indices          -> {Index[Generation], Index[Generation]},
    ComplexParameter -> True
  },

  alphaRsu == {
    ParameterType -> Internal,
    Indices          -> {Index[Generation], Index[Generation]},
    ComplexParameter -> True
  },

  alphaRsd == {
    ParameterType -> Internal,
    Indices          -> {Index[Generation], Index[Generation]},
    ComplexParameter -> True
  },

  alphaRse == {
    ParameterType -> Internal,
    Indices          -> {Index[Generation], Index[Generation]},
    ComplexParameter -> True
  },

  alphaRsbox == { 
    ParameterType     -> Internal, 
    ComplexParameter  -> False
  },

  alphaRphisbox == { 
    ParameterType     -> Internal, 
    ComplexParameter  -> False
  },


  alphaOsGt == { 
    ParameterType     -> Internal, 
    ComplexParameter  -> False
  },

  alphaOsWt == { 
    ParameterType     -> Internal, 
    ComplexParameter  -> False
  },

  alphaOsBt == { 
    ParameterType     -> Internal, 
    ComplexParameter  -> False
  },

  alphaOsG == { 
    ParameterType     -> Internal, 
    ComplexParameter  -> False
  },

  alphaOsW == { 
    ParameterType     -> Internal, 
    ComplexParameter  -> False
  },

  alphaOsB == { 
    ParameterType     -> Internal, 
    ComplexParameter  -> False
  }



};


(* ************************** *)
(* *****   Lagrangian   ***** *)
(* ************************** *)

gotoBFM={G[a__]->G[a]+GQuantum[a],Wi[a__]->Wi[a]+WiQuantum[a],B[a__]->B[a]+BQuantum[a]};


(* L2Higgs *)

L2Higgs := Block[{ii,mu},
  -ExpandIndices[alphaOmuH2 Phibar[ii] Phi[ii]]
 ]; 

(* L4Gauge *)

L4Gauge := Block[{mu,nu,ii,aa}, 
  ExpandIndices[-1/4 alphaKB FS[B,mu,nu] FS[B,mu,nu] - 1/4 alphaKW FS[Wi,mu,nu,ii] FS[Wi,mu,nu,ii] - 1/4 alphaKG FS[G,mu,nu,aa] FS[G,mu,nu,aa]]];

(* L4Fermions *)

L4Fermions := Block[{mu,sp1,sp2,ff1,ff2,cc,ii}, 
  ExpandIndices[I*(
     alphaKq[ff1,ff2] Ga[mu,sp1,sp2]  QLbar[sp1,ii,ff1,cc].DC[QL[sp2,ii,ff2,cc], mu] 
    +alphaKl[ff1,ff2] Ga[mu,sp1,sp2]  LLbar[sp1,ii,ff1].DC[LL[sp2,ii,ff2], mu] 
    +alphaKu[ff1,ff2] Ga[mu,sp1,sp2]  URbar[sp1,ff1,cc].DC[UR[sp2,ff2,cc], mu] 
    +alphaKd[ff1,ff2] Ga[mu,sp1,sp2]  DRbar[sp1,ff1,cc].DC[DR[sp2,ff2,cc], mu] 
    +alphaKe[ff1,ff2] Ga[mu,sp1,sp2]  LRbar[sp1,ff1].DC[LR[sp2,ff2], mu])]];

(* L4Higgs *)

L4Higgs := Block[{ii,mu},
  ExpandIndices[alphaKH DC[Phibar[ii],mu] DC[Phi[ii],mu] -alphaOlambda Phibar[ii] Phi[ii] Phibar[jj] Phi[jj]]]; 

(* L4Yukawa *)


L4Yukawa := Block[{sp,ii,jj,cc,ff1,ff2,ff3,yuk},
  yuk = ExpandIndices[
   - alphaOlambdad[ff1,ff2] QLbar[sp, ii, ff1, cc].DR [sp, ff2, cc] Phi[ii]
   - alphaOlambdae[ff1,ff2] LLbar[sp, ii, ff1].LR [sp, ff2] Phi[ii]
   - alphaOlambdau[ff1,ff2] QLbar[sp, ii, ff1, cc].UR [sp, ff2, cc] Phibar[jj] Eps[ii, jj]];
  yuk+HC[yuk]
 ];


L4ALP := Block[{mu,ii},
    alphaKs*del[s,mu]*del[s,mu]/2-alphaOms2 s^2/2
   -alphaOkappas/6 s^3 - alphaOlambdas/24 s^4 - alphaOkappasphi s Phibar[ii] Phi[ii]
   -alphaOlambdasphi/2  s^2 Phibar[ii] Phi[ii]
];

L5ALP := Block[{ii,jj,ff1,ff2,mu,nu,sp, sp1, sp2, cc,lagh,lagnoh},
     lagh=
      alphaOs5 s^5
     +alphaOs3 s^3 Phibar[ii] Phi[ii] 
     +alphaOs s Phibar[ii] Phi[ii]  Phibar[jj] Phi[jj]
     +alphaOsGt s FS[G,mu,nu,jj] Dual[FS][G,mu,nu,jj]
     +alphaOsWt s FS[Wi,mu,nu,jj] Dual[FS][Wi,mu,nu,jj]
     +alphaOsBt s FS[B,mu,nu] Dual[FS][B,mu,nu]
     +alphaOsG s FS[G,mu,nu,jj] FS[G,mu,nu,jj]
     +alphaOsW s FS[Wi,mu,nu,jj] FS[Wi,mu,nu,jj]
     +alphaOsB s FS[B,mu,nu] FS[B,mu,nu];
     lagnoh=
      alphaOsuphi[ff1,ff2] s QLbar[sp, ii, ff1, cc].UR [sp, ff2, cc] Phitilde[ii]
     +alphaOsdphi[ff1,ff2] s QLbar[sp, ii, ff1, cc].DR [sp, ff2, cc] Phi[ii]
     +alphaOsephi[ff1,ff2] s LLbar[sp, ii, ff1].LR [sp, ff2] Phi[ii]
     +alphaRsphibox s Phibar[ii] DC[DC[Phi[ii],mu],mu]
     +alphaRsq[ff1,ff2] I s Ga[mu,sp1,sp2] QLbar[sp1, ii, ff1, cc].DC[QL[sp2,ii,ff2,cc],mu]
     +alphaRsl[ff1,ff2] I s Ga[mu,sp1,sp2] LLbar[sp1, ii, ff1].DC[LL[sp2,ii,ff2],mu]
     +alphaRsu[ff1,ff2] I s Ga[mu,sp1,sp2] URbar[sp1, ff1, cc].DC[UR[sp2,ff2,cc],mu]
     +alphaRsd[ff1,ff2] I s Ga[mu,sp1,sp2] DRbar[sp1, ff1, cc].DC[DR[sp2,ff2,cc],mu]
     +alphaRse[ff1,ff2] I s Ga[mu,sp1,sp2] LRbar[sp1, ff1].DC[LR[sp2,ff2],mu]
     +alphaRsbox s^2 DC[DC[s,mu],mu]
     +alphaRphisbox Phibar[ii] Phi[ii] DC[DC[s,mu],mu];
     lagh+lagnoh+HC[lagnoh]
];


Ltot := L2Higgs + L4Gauge + L4Fermions + L4Higgs + L4Yukawa + L4ALP + L5ALP;


(*Ltot := LSM + LNP;*)


