"""Constants."""
from __future__ import annotations

BASE_SANDMAN_API_URL = "https://control.sandmandoppler.com"
BASE_COPILOT_API_URL = "https://api.sandmandoppler.bycopilot.com/v4"
BASE_AUTH_URL = f"{BASE_COPILOT_API_URL}/auth"
LOGIN_URL = f"{BASE_AUTH_URL}/login"
REFRESH_URL = f"{BASE_AUTH_URL}/refresh"
LOGOUT_URL = f"{BASE_AUTH_URL}/logout"
THINGS_URL = f"{BASE_COPILOT_API_URL}/things"

DEFAULT_HEADERS = {"content-type": "application/json"}
DEFAULT_APPLICATION_ID = "doppyler"

DEFAULT_TIMEOUT = 10

# Data keys
ATTR_ALARM_SOUNDS = "alarm_sounds"
ATTR_ALARMS = "alarms"
ATTR_ALEXA_TAP_TO_TALK_TONE_ENABLED = "alexa_tap_to_talk_tone_enabled"
ATTR_ALEXA_USE_ASCENDING_ALARMS = "alexa_use_ascending_alarms"
ATTR_ALEXA_WAKE_WORD_TONE_ENABLED = "alexa_wake_word_tone_enabled"
ATTR_COLON_BLINK = "colon_blink"
ATTR_CONNECTED_TO_ALEXA = "connected_to_alexa"
ATTR_DAY_BUTTON_BRIGHTNESS = "day_button_brightness"
ATTR_DAY_BUTTON_COLOR = "day_button_color"
ATTR_DAY_DISPLAY_BRIGHTNESS = "day_display_brightness"
ATTR_DAY_DISPLAY_COLOR = "day_display_color"
ATTR_IS_IN_DAY_MODE = "is_in_day_mode"
ATTR_DAY_TO_NIGHT_TRANSITION_VALUE = "day_to_night_transition_value"
ATTR_DISPLAY_SECONDS = "display_seconds"
ATTR_LIGHT_SENSOR_VALUE = "lightsensor"
ATTR_NIGHT_BUTTON_BRIGHTNESS = "night_button_brightness"
ATTR_NIGHT_BUTTON_COLOR = "night_button_color"
ATTR_NIGHT_DISPLAY_BRIGHTNESS = "night_display_brightness"
ATTR_NIGHT_DISPLAY_COLOR = "night_display_color"
ATTR_NIGHT_TO_DAY_TRANSITION_VALUE = "night_to_day_transition_value"
ATTR_SOUND_PRESET = "sound_preset"
ATTR_SOUND_PRESET_MODE = "sound_preset_mode"
ATTR_SYNC_BUTTON_AND_DISPLAY_BRIGHTNESS = "sync_button_and_display_brightness"
ATTR_SYNC_BUTTON_AND_DISPLAY_COLOR = "sync_button_and_display_color"
ATTR_SYNC_DAY_AND_NIGHT_COLOR = "sync_day_and_night_color"
ATTR_TIME_MODE = "time_mode"
ATTR_TIME_OFFSET = "time_offset"
ATTR_TIMEZONE = "timezone"
ATTR_USE_COLON = "use_colon"
ATTR_USE_FADE_TIME = "use_fade_time"
ATTR_USE_LEADING_ZERO = "use_leading_zero"
ATTR_VOLUME_LEVEL = "volume_level"
ATTR_WEATHER = "weather"
ATTR_WEATHER_WAKE_UP_TIME = "weather_wake_up_time"
ATTR_WIFI = "wifi"
