"""gymBuddyApp URL Configuration

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/3.1/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  path('', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  path('', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.urls import include, path
    2. Add a URL to urlpatterns:  path('blog/', include('blog.urls'))
"""
from django.contrib import admin
from django.contrib.auth import views as auth_views
from django.urls import path, include
from GymBuddyApp.users import views as user_views
#we do not need to import views from pages since pages already has a urls.py file


urlpatterns = [
    path('', include('GymBuddyApp.pages.urls')),
    path('admin/', admin.site.urls),
    path('login/', auth_views.LoginView.as_view(template_name='users/login.html'), name='login'),
    path('logout/', auth_views.LogoutView.as_view(template_name='users/logout.html'), name='logout'),
    path('profile/', user_views.profile, name='profile'),
    path('register/', user_views.register, name='register'),
    path('weight/', user_views.weight, name='weight'),
    path('macros/', user_views.macros, name='macros'),
    path('exercises/', user_views.exercises, name='exercises'),
    path('exercises/<int:active_exercises>', user_views.exercises, name='exercises'),
    path('meals/', user_views.meals, name='meals'),
    path('login/', user_views.login2, name='login')
]
