# This file was generated by mettle.genes.braze.GenPy3 [ver 2.1] on Sun Jan  2 10:48:50 2022
#

import datetime
import uuid
import mettle.braze
import mettle.lib

from mettle.braze.iclient_marshaler import IClientMarshaler
from .fura_client_interface import FuraClientInterface

from bs_fura.db.tables import tConfig
from bs_fura.db.tables import tFunc
from bs_fura.db.tables import tFuncGrp
from bs_fura.db.tables import tRole
from bs_fura.db.tables import tSiteCfg
from bs_fura.db.tables import tSite
from bs_fura.db.tables import tUsr
from bs_fura.db.tables import tUsrType

from .bauth_policy import bAuthPolicy
from .buser_login import bUserLogin
from .brole_func_rel import bRoleFuncRel

class FuraClientMarshaler(IClientMarshaler, FuraClientInterface):

    def __init__(self, client):
        """
        Constructor.

        :param client: braze client object.
        """
        self._client = client

    def _signature(self) -> str:
        """
        Gets the client signature.

        :return: the signature of this client.
        """
        return 'Fura'

    def auth_policy_read(self,
                         auth_type: str,
                         site_code: str) -> bAuthPolicy:
        _i = self._client.get_transport().new_stream()
        _o = None
        _w = None
        _r = None
        _x = None

        _w = self._client.get_transport().new_writer(_i)
        _w.write_start("authPolicyRead_IN")
        _w.write_char("authType", auth_type)
        _w.write_string("siteCode", site_code)
        _w.write_end("authPolicyRead_IN")

        self._client.send(self, 'authPolicyRead', _i)
        _o = self._client.receive(self, 'authPolicyRead')

        _r = self._client.get_transport().new_reader(_o)
        _r.read_start("authPolicyRead_OUT")
        _x = bAuthPolicy()
        _x._deserialize(_r, "returns")
        _r.read_end("authPolicyRead_OUT")

        return _x

    def config_create(self,
                      rec: tConfig) -> tConfig:
        _i = self._client.get_transport().new_stream()
        _o = None
        _w = None
        _r = None
        _x = None

        _w = self._client.get_transport().new_writer(_i)
        _w.write_start("configCreate_IN")
        rec._serialize(_w, "rec")
        _w.write_end("configCreate_IN")

        self._client.send(self, 'configCreate', _i)
        _o = self._client.receive(self, 'configCreate')

        _r = self._client.get_transport().new_reader(_o)
        _r.read_start("configCreate_OUT")
        _x = tConfig()
        _x._deserialize(_r, "returns")
        _r.read_end("configCreate_OUT")

        return _x

    def config_read(self,
                    cfg_id: str) -> tConfig.List:
        _i = self._client.get_transport().new_stream()
        _o = None
        _w = None
        _r = None
        _x = None

        _w = self._client.get_transport().new_writer(_i)
        _w.write_start("configRead_IN")
        _w.write_string("cfgId", cfg_id)
        _w.write_end("configRead_IN")

        self._client.send(self, 'configRead', _i)
        _o = self._client.receive(self, 'configRead')

        _r = self._client.get_transport().new_reader(_o)
        _r.read_start("configRead_OUT")
        _x = tConfig.List()
        _x._deserialize(_r, None)
        _r.read_end("configRead_OUT")

        return _x

    def config_update(self,
                      rec: tConfig) -> tConfig:
        _i = self._client.get_transport().new_stream()
        _o = None
        _w = None
        _r = None
        _x = None

        _w = self._client.get_transport().new_writer(_i)
        _w.write_start("configUpdate_IN")
        rec._serialize(_w, "rec")
        _w.write_end("configUpdate_IN")

        self._client.send(self, 'configUpdate', _i)
        _o = self._client.receive(self, 'configUpdate')

        _r = self._client.get_transport().new_reader(_o)
        _r.read_start("configUpdate_OUT")
        _x = tConfig()
        _x._deserialize(_r, "returns")
        _r.read_end("configUpdate_OUT")

        return _x

    def config_delete(self,
                      cfg_id: str):
        _i = self._client.get_transport().new_stream()
        _o = None
        _w = None

        _w = self._client.get_transport().new_writer(_i)
        _w.write_start("configDelete_IN")
        _w.write_string("cfgId", cfg_id)
        _w.write_end("configDelete_IN")

        self._client.send(self, 'configDelete', _i)
        _o = self._client.receive(self, 'configDelete')

    def func_read(self,
                  func_id: str,
                  func_grp_id: str) -> tFunc.List:
        _i = self._client.get_transport().new_stream()
        _o = None
        _w = None
        _r = None
        _x = None

        _w = self._client.get_transport().new_writer(_i)
        _w.write_start("funcRead_IN")
        _w.write_string("funcId", func_id)
        _w.write_string("funcGrpId", func_grp_id)
        _w.write_end("funcRead_IN")

        self._client.send(self, 'funcRead', _i)
        _o = self._client.receive(self, 'funcRead')

        _r = self._client.get_transport().new_reader(_o)
        _r.read_start("funcRead_OUT")
        _x = tFunc.List()
        _x._deserialize(_r, None)
        _r.read_end("funcRead_OUT")

        return _x

    def func_grp_read(self,
                      func_grp_id: str) -> tFuncGrp.List:
        _i = self._client.get_transport().new_stream()
        _o = None
        _w = None
        _r = None
        _x = None

        _w = self._client.get_transport().new_writer(_i)
        _w.write_start("funcGrpRead_IN")
        _w.write_string("funcGrpId", func_grp_id)
        _w.write_end("funcGrpRead_IN")

        self._client.send(self, 'funcGrpRead', _i)
        _o = self._client.receive(self, 'funcGrpRead')

        _r = self._client.get_transport().new_reader(_o)
        _r.read_start("funcGrpRead_OUT")
        _x = tFuncGrp.List()
        _x._deserialize(_r, None)
        _r.read_end("funcGrpRead_OUT")

        return _x

    def role_create(self,
                    rec: tRole) -> tRole:
        _i = self._client.get_transport().new_stream()
        _o = None
        _w = None
        _r = None
        _x = None

        _w = self._client.get_transport().new_writer(_i)
        _w.write_start("roleCreate_IN")
        rec._serialize(_w, "rec")
        _w.write_end("roleCreate_IN")

        self._client.send(self, 'roleCreate', _i)
        _o = self._client.receive(self, 'roleCreate')

        _r = self._client.get_transport().new_reader(_o)
        _r.read_start("roleCreate_OUT")
        _x = tRole()
        _x._deserialize(_r, "returns")
        _r.read_end("roleCreate_OUT")

        return _x

    def role_read(self,
                  role_id: str) -> tRole.List:
        _i = self._client.get_transport().new_stream()
        _o = None
        _w = None
        _r = None
        _x = None

        _w = self._client.get_transport().new_writer(_i)
        _w.write_start("roleRead_IN")
        _w.write_string("roleId", role_id)
        _w.write_end("roleRead_IN")

        self._client.send(self, 'roleRead', _i)
        _o = self._client.receive(self, 'roleRead')

        _r = self._client.get_transport().new_reader(_o)
        _r.read_start("roleRead_OUT")
        _x = tRole.List()
        _x._deserialize(_r, None)
        _r.read_end("roleRead_OUT")

        return _x

    def role_update(self,
                    rec: tRole) -> tRole:
        _i = self._client.get_transport().new_stream()
        _o = None
        _w = None
        _r = None
        _x = None

        _w = self._client.get_transport().new_writer(_i)
        _w.write_start("roleUpdate_IN")
        rec._serialize(_w, "rec")
        _w.write_end("roleUpdate_IN")

        self._client.send(self, 'roleUpdate', _i)
        _o = self._client.receive(self, 'roleUpdate')

        _r = self._client.get_transport().new_reader(_o)
        _r.read_start("roleUpdate_OUT")
        _x = tRole()
        _x._deserialize(_r, "returns")
        _r.read_end("roleUpdate_OUT")

        return _x

    def role_delete(self,
                    role_id: str):
        _i = self._client.get_transport().new_stream()
        _o = None
        _w = None

        _w = self._client.get_transport().new_writer(_i)
        _w.write_start("roleDelete_IN")
        _w.write_string("roleId", role_id)
        _w.write_end("roleDelete_IN")

        self._client.send(self, 'roleDelete', _i)
        _o = self._client.receive(self, 'roleDelete')

    def role_func_add(self,
                      role_id: str,
                      rfs: mettle.braze.StringList):
        _i = self._client.get_transport().new_stream()
        _o = None
        _w = None

        _w = self._client.get_transport().new_writer(_i)
        _w.write_start("roleFuncAdd_IN")
        _w.write_string("roleId", role_id)
        rfs._serialize(_w, "rfs")
        _w.write_end("roleFuncAdd_IN")

        self._client.send(self, 'roleFuncAdd', _i)
        _o = self._client.receive(self, 'roleFuncAdd')

    def role_func_rem(self,
                      role_id: str,
                      rfs: mettle.braze.StringList):
        _i = self._client.get_transport().new_stream()
        _o = None
        _w = None

        _w = self._client.get_transport().new_writer(_i)
        _w.write_start("roleFuncRem_IN")
        _w.write_string("roleId", role_id)
        rfs._serialize(_w, "rfs")
        _w.write_end("roleFuncRem_IN")

        self._client.send(self, 'roleFuncRem', _i)
        _o = self._client.receive(self, 'roleFuncRem')

    def role_func_read(self,
                       role_id: str,
                       func_grp_id: str) -> bRoleFuncRel.List:
        _i = self._client.get_transport().new_stream()
        _o = None
        _w = None
        _r = None
        _x = None

        _w = self._client.get_transport().new_writer(_i)
        _w.write_start("roleFuncRead_IN")
        _w.write_string("roleId", role_id)
        _w.write_string("funcGrpId", func_grp_id)
        _w.write_end("roleFuncRead_IN")

        self._client.send(self, 'roleFuncRead', _i)
        _o = self._client.receive(self, 'roleFuncRead')

        _r = self._client.get_transport().new_reader(_o)
        _r.read_start("roleFuncRead_OUT")
        _x = bRoleFuncRel.List()
        _x._deserialize(_r, None)
        _r.read_end("roleFuncRead_OUT")

        return _x

    def site_cfg_create(self,
                        rec: tSiteCfg) -> tSiteCfg:
        _i = self._client.get_transport().new_stream()
        _o = None
        _w = None
        _r = None
        _x = None

        _w = self._client.get_transport().new_writer(_i)
        _w.write_start("siteCfgCreate_IN")
        rec._serialize(_w, "rec")
        _w.write_end("siteCfgCreate_IN")

        self._client.send(self, 'siteCfgCreate', _i)
        _o = self._client.receive(self, 'siteCfgCreate')

        _r = self._client.get_transport().new_reader(_o)
        _r.read_start("siteCfgCreate_OUT")
        _x = tSiteCfg()
        _x._deserialize(_r, "returns")
        _r.read_end("siteCfgCreate_OUT")

        return _x

    def site_cfg_read(self,
                      site_cfg_id: str) -> tSiteCfg.List:
        _i = self._client.get_transport().new_stream()
        _o = None
        _w = None
        _r = None
        _x = None

        _w = self._client.get_transport().new_writer(_i)
        _w.write_start("siteCfgRead_IN")
        _w.write_string("siteCfgId", site_cfg_id)
        _w.write_end("siteCfgRead_IN")

        self._client.send(self, 'siteCfgRead', _i)
        _o = self._client.receive(self, 'siteCfgRead')

        _r = self._client.get_transport().new_reader(_o)
        _r.read_start("siteCfgRead_OUT")
        _x = tSiteCfg.List()
        _x._deserialize(_r, None)
        _r.read_end("siteCfgRead_OUT")

        return _x

    def site_cfg_update(self,
                        rec: tSiteCfg) -> tSiteCfg:
        _i = self._client.get_transport().new_stream()
        _o = None
        _w = None
        _r = None
        _x = None

        _w = self._client.get_transport().new_writer(_i)
        _w.write_start("siteCfgUpdate_IN")
        rec._serialize(_w, "rec")
        _w.write_end("siteCfgUpdate_IN")

        self._client.send(self, 'siteCfgUpdate', _i)
        _o = self._client.receive(self, 'siteCfgUpdate')

        _r = self._client.get_transport().new_reader(_o)
        _r.read_start("siteCfgUpdate_OUT")
        _x = tSiteCfg()
        _x._deserialize(_r, "returns")
        _r.read_end("siteCfgUpdate_OUT")

        return _x

    def site_cfg_delete(self,
                        site_cfg_id: str):
        _i = self._client.get_transport().new_stream()
        _o = None
        _w = None

        _w = self._client.get_transport().new_writer(_i)
        _w.write_start("siteCfgDelete_IN")
        _w.write_string("siteCfgId", site_cfg_id)
        _w.write_end("siteCfgDelete_IN")

        self._client.send(self, 'siteCfgDelete', _i)
        _o = self._client.receive(self, 'siteCfgDelete')

    def site_create(self,
                    site_rec: tSite,
                    admin_email: str,
                    admin_passwd: str) -> int:
        _i = self._client.get_transport().new_stream()
        _o = None
        _w = None
        _r = None
        _x = None

        _w = self._client.get_transport().new_writer(_i)
        _w.write_start("siteCreate_IN")
        site_rec._serialize(_w, "siteRec")
        _w.write_string("adminEmail", admin_email)
        _w.write_string("adminPasswd", admin_passwd)
        _w.write_end("siteCreate_IN")

        self._client.send(self, 'siteCreate', _i)
        _o = self._client.receive(self, 'siteCreate')

        _r = self._client.get_transport().new_reader(_o)
        _r.read_start("siteCreate_OUT")
        _x = _r.read_int32("return")
        _r.read_end("siteCreate_OUT")

        return _x

    def site_read(self,
                  site_code: str) -> tSite.List:
        _i = self._client.get_transport().new_stream()
        _o = None
        _w = None
        _r = None
        _x = None

        _w = self._client.get_transport().new_writer(_i)
        _w.write_start("siteRead_IN")
        _w.write_string("siteCode", site_code)
        _w.write_end("siteRead_IN")

        self._client.send(self, 'siteRead', _i)
        _o = self._client.receive(self, 'siteRead')

        _r = self._client.get_transport().new_reader(_o)
        _r.read_start("siteRead_OUT")
        _x = tSite.List()
        _x._deserialize(_r, None)
        _r.read_end("siteRead_OUT")

        return _x

    def site_update(self,
                    rec: tSite) -> tSite:
        _i = self._client.get_transport().new_stream()
        _o = None
        _w = None
        _r = None
        _x = None

        _w = self._client.get_transport().new_writer(_i)
        _w.write_start("siteUpdate_IN")
        rec._serialize(_w, "rec")
        _w.write_end("siteUpdate_IN")

        self._client.send(self, 'siteUpdate', _i)
        _o = self._client.receive(self, 'siteUpdate')

        _r = self._client.get_transport().new_reader(_o)
        _r.read_start("siteUpdate_OUT")
        _x = tSite()
        _x._deserialize(_r, "returns")
        _r.read_end("siteUpdate_OUT")

        return _x

    def site_delete(self,
                    site_id: int):
        _i = self._client.get_transport().new_stream()
        _o = None
        _w = None

        _w = self._client.get_transport().new_writer(_i)
        _w.write_start("siteDelete_IN")
        _w.write_int32("siteId", site_id)
        _w.write_end("siteDelete_IN")

        self._client.send(self, 'siteDelete', _i)
        _o = self._client.receive(self, 'siteDelete')

    def user_create(self,
                    rec: tUsr) -> tUsr:
        _i = self._client.get_transport().new_stream()
        _o = None
        _w = None
        _r = None
        _x = None

        _w = self._client.get_transport().new_writer(_i)
        _w.write_start("userCreate_IN")
        rec._serialize(_w, "rec")
        _w.write_end("userCreate_IN")

        self._client.send(self, 'userCreate', _i)
        _o = self._client.receive(self, 'userCreate')

        _r = self._client.get_transport().new_reader(_o)
        _r.read_start("userCreate_OUT")
        _x = tUsr()
        _x._deserialize(_r, "returns")
        _r.read_end("userCreate_OUT")

        return _x

    def user_read(self,
                  usr_id: str,
                  usr_type: str) -> tUsr.List:
        _i = self._client.get_transport().new_stream()
        _o = None
        _w = None
        _r = None
        _x = None

        _w = self._client.get_transport().new_writer(_i)
        _w.write_start("userRead_IN")
        _w.write_string("usrId", usr_id)
        _w.write_string("usrType", usr_type)
        _w.write_end("userRead_IN")

        self._client.send(self, 'userRead', _i)
        _o = self._client.receive(self, 'userRead')

        _r = self._client.get_transport().new_reader(_o)
        _r.read_start("userRead_OUT")
        _x = tUsr.List()
        _x._deserialize(_r, None)
        _r.read_end("userRead_OUT")

        return _x

    def user_update(self,
                    rec: tUsr) -> tUsr:
        _i = self._client.get_transport().new_stream()
        _o = None
        _w = None
        _r = None
        _x = None

        _w = self._client.get_transport().new_writer(_i)
        _w.write_start("userUpdate_IN")
        rec._serialize(_w, "rec")
        _w.write_end("userUpdate_IN")

        self._client.send(self, 'userUpdate', _i)
        _o = self._client.receive(self, 'userUpdate')

        _r = self._client.get_transport().new_reader(_o)
        _r.read_start("userUpdate_OUT")
        _x = tUsr()
        _x._deserialize(_r, "returns")
        _r.read_end("userUpdate_OUT")

        return _x

    def user_delete(self,
                    usr_id: str):
        _i = self._client.get_transport().new_stream()
        _o = None
        _w = None

        _w = self._client.get_transport().new_writer(_i)
        _w.write_start("userDelete_IN")
        _w.write_string("usrId", usr_id)
        _w.write_end("userDelete_IN")

        self._client.send(self, 'userDelete', _i)
        _o = self._client.receive(self, 'userDelete')

    def user_rec(self) -> tUsr:
        _i = self._client.get_transport().new_stream()
        _o = None
        _r = None
        _x = None

        self._client.send(self, 'userRec', _i)
        _o = self._client.receive(self, 'userRec')

        _r = self._client.get_transport().new_reader(_o)
        _r.read_start("userRec_OUT")
        _x = tUsr()
        _x._deserialize(_r, "returns")
        _r.read_end("userRec_OUT")

        return _x

    def user_funcs(self,
                   func_prefix: str) -> mettle.braze.StringList:
        _i = self._client.get_transport().new_stream()
        _o = None
        _w = None
        _r = None
        _x = None

        _w = self._client.get_transport().new_writer(_i)
        _w.write_start("userFuncs_IN")
        _w.write_string("funcPrefix", func_prefix)
        _w.write_end("userFuncs_IN")

        self._client.send(self, 'userFuncs', _i)
        _o = self._client.receive(self, 'userFuncs')

        _r = self._client.get_transport().new_reader(_o)
        _r.read_start("userFuncs_OUT")
        _x = mettle.braze.StringList()
        _x._deserialize(_r, None)
        _r.read_end("userFuncs_OUT")

        return _x

    def user_login(self,
                   ul_rec: bUserLogin) -> int:
        _i = self._client.get_transport().new_stream()
        _o = None
        _w = None
        _r = None
        _x = None

        _w = self._client.get_transport().new_writer(_i)
        _w.write_start("userLogin_IN")
        ul_rec._serialize(_w, "ulRec")
        _w.write_end("userLogin_IN")

        self._client.send(self, 'userLogin', _i)
        _o = self._client.receive(self, 'userLogin')

        _r = self._client.get_transport().new_reader(_o)
        _r.read_start("userLogin_OUT")
        _x = _r.read_int32("return")
        _r.read_end("userLogin_OUT")

        return _x

    def user_logout(self) -> int:
        _i = self._client.get_transport().new_stream()
        _o = None
        _r = None
        _x = None

        self._client.send(self, 'userLogout', _i)
        _o = self._client.receive(self, 'userLogout')

        _r = self._client.get_transport().new_reader(_o)
        _r.read_start("userLogout_OUT")
        _x = _r.read_int32("return")
        _r.read_end("userLogout_OUT")

        return _x

    def user_role(self) -> tRole:
        _i = self._client.get_transport().new_stream()
        _o = None
        _r = None
        _x = None

        self._client.send(self, 'userRole', _i)
        _o = self._client.receive(self, 'userRole')

        _r = self._client.get_transport().new_reader(_o)
        _r.read_start("userRole_OUT")
        _x = tRole()
        _x._deserialize(_r, "returns")
        _r.read_end("userRole_OUT")

        return _x

    def user_is_super_user(self) -> bool:
        _i = self._client.get_transport().new_stream()
        _o = None
        _r = None
        _x = None

        self._client.send(self, 'userIsSuperUser', _i)
        _o = self._client.receive(self, 'userIsSuperUser')

        _r = self._client.get_transport().new_reader(_o)
        _r.read_start("userIsSuperUser_OUT")
        _x = _r.read_bool("return")
        _r.read_end("userIsSuperUser_OUT")

        return _x

    def user_auth_change(self,
                         auth_type: str,
                         new_data: str,
                         old_data: str):
        _i = self._client.get_transport().new_stream()
        _o = None
        _w = None

        _w = self._client.get_transport().new_writer(_i)
        _w.write_start("userAuthChange_IN")
        _w.write_char("authType", auth_type)
        _w.write_string("newData", new_data)
        _w.write_string("oldData", old_data)
        _w.write_end("userAuthChange_IN")

        self._client.send(self, 'userAuthChange', _i)
        _o = self._client.receive(self, 'userAuthChange')

    def user_auth_reset(self,
                        site_code: str,
                        usr_id: str,
                        auth_type: str,
                        reset_method: str):
        _i = self._client.get_transport().new_stream()
        _o = None
        _w = None

        _w = self._client.get_transport().new_writer(_i)
        _w.write_start("userAuthReset_IN")
        _w.write_string("siteCode", site_code)
        _w.write_string("usrId", usr_id)
        _w.write_char("authType", auth_type)
        _w.write_char("resetMethod", reset_method)
        _w.write_end("userAuthReset_IN")

        self._client.send(self, 'userAuthReset', _i)
        _o = self._client.receive(self, 'userAuthReset')

    def user_token_reset(self,
                         auth_type: str):
        _i = self._client.get_transport().new_stream()
        _o = None
        _w = None

        _w = self._client.get_transport().new_writer(_i)
        _w.write_start("userTokenReset_IN")
        _w.write_char("authType", auth_type)
        _w.write_end("userTokenReset_IN")

        self._client.send(self, 'userTokenReset', _i)
        _o = self._client.receive(self, 'userTokenReset')

    def user_auth_reset_admin(self,
                              usr_id: str,
                              auth_type: str,
                              email_addr: str):
        _i = self._client.get_transport().new_stream()
        _o = None
        _w = None

        _w = self._client.get_transport().new_writer(_i)
        _w.write_start("userAuthResetAdmin_IN")
        _w.write_string("usrId", usr_id)
        _w.write_char("authType", auth_type)
        _w.write_string("emailAddr", email_addr)
        _w.write_end("userAuthResetAdmin_IN")

        self._client.send(self, 'userAuthResetAdmin', _i)
        _o = self._client.receive(self, 'userAuthResetAdmin')

    def user_token_reset_admin(self,
                               usr_id: str,
                               auth_type: str):
        _i = self._client.get_transport().new_stream()
        _o = None
        _w = None

        _w = self._client.get_transport().new_writer(_i)
        _w.write_start("userTokenResetAdmin_IN")
        _w.write_string("usrId", usr_id)
        _w.write_char("authType", auth_type)
        _w.write_end("userTokenResetAdmin_IN")

        self._client.send(self, 'userTokenResetAdmin', _i)
        _o = self._client.receive(self, 'userTokenResetAdmin')

    def user_token_read(self,
                        auth_type: str) -> str:
        _i = self._client.get_transport().new_stream()
        _o = None
        _w = None
        _r = None
        _x = None

        _w = self._client.get_transport().new_writer(_i)
        _w.write_start("userTokenRead_IN")
        _w.write_char("authType", auth_type)
        _w.write_end("userTokenRead_IN")

        self._client.send(self, 'userTokenRead', _i)
        _o = self._client.receive(self, 'userTokenRead')

        _r = self._client.get_transport().new_reader(_o)
        _r.read_start("userTokenRead_OUT")
        _x = _r.read_string("return")
        _r.read_end("userTokenRead_OUT")

        return _x

    def user_set_new_auth(self,
                          ul_rec: bUserLogin,
                          tok: str,
                          reset_method: str):
        _i = self._client.get_transport().new_stream()
        _o = None
        _w = None

        _w = self._client.get_transport().new_writer(_i)
        _w.write_start("userSetNewAuth_IN")
        ul_rec._serialize(_w, "ulRec")
        _w.write_string("tok", tok)
        _w.write_char("resetMethod", reset_method)
        _w.write_end("userSetNewAuth_IN")

        self._client.send(self, 'userSetNewAuth', _i)
        _o = self._client.receive(self, 'userSetNewAuth')

    def user_activate(self,
                      usr_id: str):
        _i = self._client.get_transport().new_stream()
        _o = None
        _w = None

        _w = self._client.get_transport().new_writer(_i)
        _w.write_start("userActivate_IN")
        _w.write_string("usrId", usr_id)
        _w.write_end("userActivate_IN")

        self._client.send(self, 'userActivate', _i)
        _o = self._client.receive(self, 'userActivate')

    def user_disable(self,
                     usr_id: str):
        _i = self._client.get_transport().new_stream()
        _o = None
        _w = None

        _w = self._client.get_transport().new_writer(_i)
        _w.write_start("userDisable_IN")
        _w.write_string("usrId", usr_id)
        _w.write_end("userDisable_IN")

        self._client.send(self, 'userDisable', _i)
        _o = self._client.receive(self, 'userDisable')

    def user_suspend(self,
                     usr_id: str):
        _i = self._client.get_transport().new_stream()
        _o = None
        _w = None

        _w = self._client.get_transport().new_writer(_i)
        _w.write_start("userSuspend_IN")
        _w.write_string("usrId", usr_id)
        _w.write_end("userSuspend_IN")

        self._client.send(self, 'userSuspend', _i)
        _o = self._client.receive(self, 'userSuspend')

    def user_set_role(self,
                      usr_id: str,
                      role_id: str) -> tUsr:
        _i = self._client.get_transport().new_stream()
        _o = None
        _w = None
        _r = None
        _x = None

        _w = self._client.get_transport().new_writer(_i)
        _w.write_start("userSetRole_IN")
        _w.write_string("usrId", usr_id)
        _w.write_string("roleId", role_id)
        _w.write_end("userSetRole_IN")

        self._client.send(self, 'userSetRole', _i)
        _o = self._client.receive(self, 'userSetRole')

        _r = self._client.get_transport().new_reader(_o)
        _r.read_start("userSetRole_OUT")
        _x = tUsr()
        _x._deserialize(_r, "returns")
        _r.read_end("userSetRole_OUT")

        return _x

    def user_confirm_contact(self,
                             otp: str):
        _i = self._client.get_transport().new_stream()
        _o = None
        _w = None

        _w = self._client.get_transport().new_writer(_i)
        _w.write_start("userConfirmContact_IN")
        _w.write_string("otp", otp)
        _w.write_end("userConfirmContact_IN")

        self._client.send(self, 'userConfirmContact', _i)
        _o = self._client.receive(self, 'userConfirmContact')

    def user_confirm_contact_req_otp(self,
                                     contact_addr: str):
        _i = self._client.get_transport().new_stream()
        _o = None
        _w = None

        _w = self._client.get_transport().new_writer(_i)
        _w.write_start("userConfirmContactReqOtp_IN")
        _w.write_string("contactAddr", contact_addr)
        _w.write_end("userConfirmContactReqOtp_IN")

        self._client.send(self, 'userConfirmContactReqOtp', _i)
        _o = self._client.receive(self, 'userConfirmContactReqOtp')

    def user_type_create(self,
                         rec: tUsrType) -> tUsrType:
        _i = self._client.get_transport().new_stream()
        _o = None
        _w = None
        _r = None
        _x = None

        _w = self._client.get_transport().new_writer(_i)
        _w.write_start("userTypeCreate_IN")
        rec._serialize(_w, "rec")
        _w.write_end("userTypeCreate_IN")

        self._client.send(self, 'userTypeCreate', _i)
        _o = self._client.receive(self, 'userTypeCreate')

        _r = self._client.get_transport().new_reader(_o)
        _r.read_start("userTypeCreate_OUT")
        _x = tUsrType()
        _x._deserialize(_r, "returns")
        _r.read_end("userTypeCreate_OUT")

        return _x

    def user_type_read(self,
                       usr_type_id: str) -> tUsrType.List:
        _i = self._client.get_transport().new_stream()
        _o = None
        _w = None
        _r = None
        _x = None

        _w = self._client.get_transport().new_writer(_i)
        _w.write_start("userTypeRead_IN")
        _w.write_string("usrTypeId", usr_type_id)
        _w.write_end("userTypeRead_IN")

        self._client.send(self, 'userTypeRead', _i)
        _o = self._client.receive(self, 'userTypeRead')

        _r = self._client.get_transport().new_reader(_o)
        _r.read_start("userTypeRead_OUT")
        _x = tUsrType.List()
        _x._deserialize(_r, None)
        _r.read_end("userTypeRead_OUT")

        return _x

    def user_type_update(self,
                         rec: tUsrType) -> tUsrType:
        _i = self._client.get_transport().new_stream()
        _o = None
        _w = None
        _r = None
        _x = None

        _w = self._client.get_transport().new_writer(_i)
        _w.write_start("userTypeUpdate_IN")
        rec._serialize(_w, "rec")
        _w.write_end("userTypeUpdate_IN")

        self._client.send(self, 'userTypeUpdate', _i)
        _o = self._client.receive(self, 'userTypeUpdate')

        _r = self._client.get_transport().new_reader(_o)
        _r.read_start("userTypeUpdate_OUT")
        _x = tUsrType()
        _x._deserialize(_r, "returns")
        _r.read_end("userTypeUpdate_OUT")

        return _x

    def user_type_delete(self,
                         usr_type_id: str):
        _i = self._client.get_transport().new_stream()
        _o = None
        _w = None

        _w = self._client.get_transport().new_writer(_i)
        _w.write_start("userTypeDelete_IN")
        _w.write_string("usrTypeId", usr_type_id)
        _w.write_end("userTypeDelete_IN")

        self._client.send(self, 'userTypeDelete', _i)
        _o = self._client.receive(self, 'userTypeDelete')

