# This file was generated by mettle.genes.braze.GenPy3 [ver 2.1] on Sun Jan  2 10:48:50 2022
#

import datetime
import uuid
import mettle.braze
import mettle.lib

from mettle.braze.iserver_interface import IServerInterface

from bs_fura.db.tables import tConfig
from bs_fura.db.tables import tFunc
from bs_fura.db.tables import tFuncGrp
from bs_fura.db.tables import tRole
from bs_fura.db.tables import tSiteCfg
from bs_fura.db.tables import tSite
from bs_fura.db.tables import tUsr
from bs_fura.db.tables import tUsrType

from .bauth_policy import bAuthPolicy
from .buser_login import bUserLogin
from .brole_func_rel import bRoleFuncRel

class FuraServerInterface(IServerInterface):

    def auth_policy_read(self,
                         auth_type: str,
                         site_code: str) -> bAuthPolicy:
        """
        Reads the authentication policy for passwords or other auth types

        :param auth_type: input - The auth type to get for
        :param site_code: input - The site code to check on or empty for default
        :return: bAuthPolicy
        """
        pass

    def config_create(self,
                      rec: tConfig) -> tConfig:
        """
        Create a new fura config

        :param rec: input - New record to save
        :return: The created record
        """
        pass

    def config_read(self,
                    cfg_id: str) -> tConfig.List:
        """
        Read config record(s)

        :param cfg_id: input - Optional, if left empty returns all records. Can do wild card searches with *
        :return: The list of config records matching the input
        """
        pass

    def config_update(self,
                      rec: tConfig) -> tConfig:
        """
        Upate a config value

        :param rec: input - The record to update
        :return: The updated record
        """
        pass

    def config_delete(self,
                      cfg_id: str):
        """
        Delete a fura config record

        :param cfg_id: input - The config identifer to delete
        """
        pass

    def func_read(self,
                  func_id: str,
                  func_grp_id: str) -> tFunc.List:
        """
        Reads function(s) from fura, limited on func_id and optionally func group

        :param func_id: input - Optional specificy a function identifier or wild card
        :param func_grp_id: input - Optional specificy a function group identifier or wild card
        :return: List of matching functions
        """
        pass

    def func_grp_read(self,
                      func_grp_id: str) -> tFuncGrp.List:
        """
        Reads a list or single function group

        :param func_grp_id: input - Optional specificy a function group identifier or wild card
        :return: List of matching function groups
        """
        pass

    def role_create(self,
                    rec: tRole) -> tRole:
        """
        Create a new role

        :param rec: input - The role to create
        :return: The created record
        """
        pass

    def role_read(self,
                  role_id: str) -> tRole.List:
        """
        Read one or many roles

        :param role_id: input - Optionally specificy a role indentifier or wild card
        :return: List of matching roles
        """
        pass

    def role_update(self,
                    rec: tRole) -> tRole:
        """
        Update a role record

        :param rec: input - The role record to update
        :return: The updated record
        """
        pass

    def role_delete(self,
                    role_id: str):
        """
        Delete a role record, will raise an FK error if it has active users

        :param role_id: input - The role identifier to delete
        """
        pass

    def role_func_add(self,
                      role_id: str,
                      rfs: mettle.braze.StringList):
        """
        Add functions to a role

        :param role_id: input - The role identifier
        :param rfs: input - List of function identifiers to add
        """
        pass

    def role_func_rem(self,
                      role_id: str,
                      rfs: mettle.braze.StringList):
        """
        Remove functions from a role

        :param role_id: input - The role identifier
        :param rfs: input - List of function identifiers to remove
        """
        pass

    def role_func_read(self,
                       role_id: str,
                       func_grp_id: str) -> bRoleFuncRel.List:
        """
        Read the role functions belonging to a role and which ones are enabled

        :param role_id: input - The role indentifier
        :param func_grp_id: input - Optionally specifify a function group identifier or wild card
        :return: List of matching role function relationships
        """
        pass

    def site_cfg_create(self,
                        rec: tSiteCfg) -> tSiteCfg:
        """
        Create a new site config record

        :param rec: input - The record to create
        :return: The created record
        """
        pass

    def site_cfg_read(self,
                      site_cfg_id: str) -> tSiteCfg.List:
        """
        Read a single or list of site config records

        :param site_cfg_id: input - Optionally specify the config identifier or wildcard to search on
        :return: The list of matching site config records
        """
        pass

    def site_cfg_update(self,
                        rec: tSiteCfg) -> tSiteCfg:
        """
        Update a site config record

        :param rec: input - The record to update
        :return: The update record
        """
        pass

    def site_cfg_delete(self,
                        site_cfg_id: str):
        """
        Delete a config record

        :param site_cfg_id: input - The site config identifier to delete
        """
        pass

    def site_create(self,
                    site_rec: tSite,
                    admin_email: str,
                    admin_passwd: str) -> int:
        """
        Creates a new site. This also creates the initial admin role and user

        :param site_rec: input - The site record to create
        :param admin_email: input - The site's admin user
        :param admin_passwd: input - The site's admin user password
        :return: The created site identifier
        """
        pass

    def site_read(self,
                  site_code: str) -> tSite.List:
        """
        Reads a site or list of site records

        :param site_code: input - Optionally specify a site code else it returns all site records
        :return: The matching site records
        """
        pass

    def site_update(self,
                    rec: tSite) -> tSite:
        """
        Update a site record

        :param rec: input - The site record to update
        :return: tSite
        """
        pass

    def site_delete(self,
                    site_id: int):
        """
        Delete a site record

        :param site_id: input - The site identifier to delete
        """
        pass

    def user_create(self,
                    rec: tUsr) -> tUsr:
        """
        Create a new user

        :param rec: input - The user record to be created
        :return: The created record
        """
        pass

    def user_read(self,
                  usr_id: str,
                  usr_type: str) -> tUsr.List:
        """
        Read a single or list of users

        :param usr_id: input - Optionally provide a user identifier, this can be a wild card
        :param usr_type: input - Optionally provide a user type identifier, this can be a wild card
        :return: The list of matching user records
        """
        pass

    def user_update(self,
                    rec: tUsr) -> tUsr:
        """
        Update a user record, Note this will not change certain properities like the role

        :param rec: input - The user record to be updated
        :return: The updated user record
        """
        pass

    def user_delete(self,
                    usr_id: str):
        """
        Delete a user record

        :param usr_id: input - The user identifier to delete
        """
        pass

    def user_rec(self) -> tUsr:
        """
        Get the logged in user record

        :return: The currently logged in user's record
        """
        pass

    def user_funcs(self,
                   func_prefix: str) -> mettle.braze.StringList:
        """
        Get all the user functions for the currently loggen in user

        :param func_prefix: input - Optionally specifiy a prefix wild card to search on
        :return: All user functions of
        """
        pass

    def user_login(self,
                   ul_rec: bUserLogin) -> int:
        """
        Used by users to log into the server/site

        :param ul_rec: input - The login credentials
        :return: Maps to the xFura error code as to why the login was rejected, zero = success
        """
        pass

    def user_logout(self) -> int:
        """
        Used by users to log out of the server/site

        :return: Maps to the xFura error code as to why the logout was rejected, zero = success
        """
        pass

    def user_role(self) -> tRole:
        """
        Get the currently loggen in user's role

        :return: Get user's role record
        """
        pass

    def user_is_super_user(self) -> bool:
        """
        Check if the user is a super user or not

        :return: True if a super user else false
        """
        pass

    def user_auth_change(self,
                         auth_type: str,
                         new_data: str,
                         old_data: str):
        """
        Logged in user wants to change their auth data, ie password

        :param auth_type: input - The auth type to change
        :param new_data: input - The new password or token
        :param old_data: input - The old password or token
        """
        pass

    def user_auth_reset(self,
                        site_code: str,
                        usr_id: str,
                        auth_type: str,
                        reset_method: str):
        """
        User want to request an auth reset, ie they forgot their password

        :param site_code: input - The site code
        :param usr_id: input - Their user identifier
        :param auth_type: input - The auth type to reset
        :param reset_method: input - The reset token delivery method
        """
        pass

    def user_token_reset(self,
                         auth_type: str):
        """
        User wants to reset their token for a given auth type

        :param auth_type: input - The auth type to reset for
        """
        pass

    def user_auth_reset_admin(self,
                              usr_id: str,
                              auth_type: str,
                              email_addr: str):
        """
        The admin user requests an auth reset on another users behalf

        :param usr_id: input - The user identifier to reset
        :param auth_type: input - The auth type to reset for
        :param email_addr: input - The email address to send to the reset token to
        """
        pass

    def user_token_reset_admin(self,
                               usr_id: str,
                               auth_type: str):
        """
        Admin user wants to reset a token for a user

        :param usr_id: input - The user indentifier to reset the token for
        :param auth_type: input - The auth type to reset for
        """
        pass

    def user_token_read(self,
                        auth_type: str) -> str:
        """
        User wants to read their auth token

        :param auth_type: input - The auth type to read for
        :return: The uses auth token
        """
        pass

    def user_set_new_auth(self,
                          ul_rec: bUserLogin,
                          tok: str,
                          reset_method: str):
        """
        User is resetting their password/auth with a token.

        :param ul_rec: input - The login credentials
        :param tok: input - The token to reset with
        :param reset_method: input - The reset method used
        """
        pass

    def user_activate(self,
                      usr_id: str):
        """
        Activate a user

        :param usr_id: input - The user identifier to activate
        """
        pass

    def user_disable(self,
                     usr_id: str):
        """
        Disable a user

        :param usr_id: input - The user identifier to disable
        """
        pass

    def user_suspend(self,
                     usr_id: str):
        """
        Suspend a user

        :param usr_id: input - The user identifier to activate
        """
        pass

    def user_set_role(self,
                      usr_id: str,
                      role_id: str) -> tUsr:
        """
        Set or change a users role

        :param usr_id: input - The user identifier to set the role for
        :param role_id: input - The role identifier to be set
        :return: The user record that was update
        """
        pass

    def user_confirm_contact(self,
                             otp: str):
        """
        A user is confirming they received an otp from one of their contact details

        :param otp: input - The otp that was sent to the user contact address
        """
        pass

    def user_confirm_contact_req_otp(self,
                                     contact_addr: str):
        """
        A user wants to confirm a contact address and is requesting an otp

        :param contact_addr: input - The contact address being requested for
        """
        pass

    def user_type_create(self,
                         rec: tUsrType) -> tUsrType:
        """
        Create a new user type record

        :param rec: input - The user type to create
        :return: The created user type record
        """
        pass

    def user_type_read(self,
                       usr_type_id: str) -> tUsrType.List:
        """
        Read a single or list of user types

        :param usr_type_id: input - The user type identifier or wild card
        :return: The matching user type records
        """
        pass

    def user_type_update(self,
                         rec: tUsrType) -> tUsrType:
        """
        Updates a user type record

        :param rec: input - The user type to update
        :return: The updated user type record
        """
        pass

    def user_type_delete(self,
                         usr_type_id: str):
        """
        Delete a user type record

        :param usr_type_id: input - The user type identifier to delete
        """
        pass

