# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Sun Jan  2 10:48:49 2022
#  Target Database = postgresql
#
import asyncio
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_fura.db.tables.role_func_rel import tRoleFuncRel
from bs_fura.db.tables.role_func_rel_key import tRoleFuncRelKey

from .role_func_rel_lock_one import dRoleFuncRelLockOne
from .role_func_rel_select_one import dRoleFuncRelSelectOne
from .role_func_rel_insert import dRoleFuncRelInsert
from .role_func_rel_delete_one import dRoleFuncRelDeleteOne

class dRoleFuncRel:

    def __init__(self, dbcon: mettle.db.IConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self.rec    = tRoleFuncRel()
        self._dbcon = dbcon

    def __enter__(self):
        """
        DAO enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        DAO exit.
        """
        pass

    def lock_one(self, _lock4update: mettle.db.DBLock, _expected: bool = True) -> bool:
        """
        Lock and select the record.

        :param _lock4update: The db lock object to use.
        :param _expected: If set to false, will not raise if record is not found.
        :return: True if selected, False if not found and _expected is set to False
        """
        _key = tRoleFuncRelKey()

        self.rec._write_key(_key)

        return self.lock_one_by_key(_key, _lock4update, _expected)

    def lock_one_with(self, _rec: tRoleFuncRel, _lock4update: mettle.db.DBLock, _expected: bool = True) -> bool:
        """
        Lock and select the record using a record.

        :param _rec: The table rec to select with and into.
        :param _lock4update: The db lock object to use.
        :param _expected: If set to false, will not raise if record is not found.
        :return: True if selected, False if not found and _expected is set to False
        """
        _key = tRoleFuncRelKey()
        _rec._write_key(_key)

        self.lock_one_by_key(_key, _lock4update, _expected)
        _rec._copy_from(self.rec)
        return True

    def lock_one_deft(self,
                      site_id: int,
                      role_id: str,
                      func_id: str,
                      _lock4update: mettle.db.DBLock,
                      _expected: bool = True) -> bool:
        """
        Attempt to lock and select the record by it's primary key columns.

        :param site_id: int
        :param role_id: str
        :param func_id: str
        :param _lock4update:  The db lock object to use. 
        :param _expected: bool
        """
        _key = tRoleFuncRelKey()

        _key.site_id = site_id
        _key.role_id = role_id
        _key.func_id = func_id

        return self.lock_one_by_key(_key, _lock4update, _expected)

    def lock_one_by_key(self, _key: tRoleFuncRelKey, _lock4update: mettle.db.DBLock, _expected: bool = True) -> bool:
        """
        Attempt to lock and select the record with it's primary key.

        :param _key: Primary key of the table record.
        :param _lock4update: The db lock object to use.
        :param _expected: If set to false, will not raise if record is not found.
        :return: True if selected, False if not found and _expected is set to False
        """
        with dRoleFuncRelLockOne(self._dbcon) as _qry:
            _dex = _lock4update.retrys - 1 if _lock4update.retrys > 0 else 0

            while _dex >= 0:
                try:
                    _qry.exec(_key)
                    if not _qry.fetch():
                        if not _expected:
                            return False

                        raise mettle.lib.xMettle("LockOne failed to return a record (dRoleFuncRel)")

                    break
                except mettle.lib.xMettle as _x:
                    if _x.get_error_code() != mettle.lib.xMettle.eCode.DBLockNoWaitFailed:
                        raise _x

                    if _dex == 0:
                        raise mettle.lib.xMettle("Could not lock RoleFuncRel record after %d attempt(s) at %d mili second intervals!" % (
_lock4update.retrys, _lock4update.mili_seconds), errCode = mettle.lib.xMettle.eCode.DBLockNoWaitFailed)

                    if _lock4update.mili_seconds > 0:
                        time.sleep(_lock4update.mili_seconds * 0.001)
                _dex -= 1

            self.rec = _qry.orec

            return True

    def try_select_one(self) -> bool:
        """
        Attempt to select the record.

        :return: True if the record was found.
        """
        _key = tRoleFuncRelKey()

        self.rec._write_key(_key)

        return self.try_select_one_by_key(_key)

    def try_select_one_with(self, _rec: tRoleFuncRel) -> bool:
        """
        Attempt to select the record using a table rec.

        :param _rec: The table rec to select with and into.
        :return: True if the row as selectd.
        """
        _key = tRoleFuncRelKey()
        _rec._write_key(_key)

        if not self.try_select_one_by_key(_key):
            return False

        _rec._copy_from(self.rec)

        return True

    def try_select_one_deft(self,
                            site_id: int,
                            role_id: str,
                            func_id: str) -> bool:
        """
        Attempt to select the record by it's primary key columns.

        :param site_id: int
        :param role_id: str
        :param func_id: str
        :return: True if the row as selectd.
        """
        _key = tRoleFuncRelKey()

        _key.site_id = site_id
        _key.role_id = role_id
        _key.func_id = func_id

        return self.try_select_one_by_key(_key)

    def try_select_one_by_key(self, _key: tRoleFuncRelKey) -> bool:
        """
        Attempt to select the record with it's primary key.

        :param _key: Primary key of the table record.
        :returns: True if row was selected.
        """
        with dRoleFuncRelSelectOne(self._dbcon) as _qry:
            _qry.exec(_key)
            if not _qry.fetch():
                return False

            self.rec = _qry.orec

        return True

    def select_one(self) -> "dRoleFuncRel":
        """
        Selects the record, raises and error if it does not exist.

        :return: Self for convenience.
        """
        if not self.try_select_one():
            raise mettle.lib.xMettle("SelectOne failed to return a record (dRoleFuncRel)")

        return self

    def select_one_with(self, _rec: tRoleFuncRel) -> "dRoleFuncRel":
        """
        Attempt to select the record with the table record.

        :param _rec: Table record.
        :returns: Self for convenience.
        """
        if not self.try_select_one_with(_rec):
            raise mettle.lib.xMettle("SelectOne failed to return a record (dRoleFuncRel)")

        return self

    def select_one_deft(self,
                        site_id: int,
                        role_id: str,
                        func_id: str) -> "dRoleFuncRel":
        """
        Selects the record by its primary key columns, raises and error if it does not exist.

        :param site_id: int
        :param role_id: str
        :param func_id: str
        """
        _key = tRoleFuncRelKey()

        _key.site_id = site_id
        _key.role_id = role_id
        _key.func_id = func_id

        if not self.try_select_one_by_key(_key):
            raise mettle.lib.xMettle("SelectOne failed to return a record (dRoleFuncRel)")

        return self

    def select_one_by_key(self, _key: tRoleFuncRelKey) -> "dRoleFuncRel":
        """
        Attempt to select the record with it's primary key.

        :param _key: Primary key of the table record.
        :return: Self for convenience.
        """
        if not self.try_select_one_by_key(_key):
            raise mettle.lib.xMettle("SelectOne failed to return a record (dRoleFuncRel)")

        return self

    def insert_deft(self,
                    site_id: int,
                    role_id: str,
                    func_id: str,
                    modified_by: str):
        """
        Insert the record setting all column values.

        :param site_id: int
        :param role_id: str
        :param func_id: str
        :param modified_by: str
        :param tm_stamp: datetime.datetime
        """
        self.rec.site_id = site_id
        self.rec.role_id = role_id
        self.rec.func_id = func_id
        self.rec.modified_by = modified_by

        self.insert()

    def insert(self, irec: tRoleFuncRel = None):
        """
        Insert the record in the database with the record or irec if it is not None.

        :param irec: If not None use this record to insert into the database.
        """
        if irec:
            self.rec._copy_from(irec)

        with dRoleFuncRelInsert(self._dbcon) as _qry:
            _qry.exec(self.rec)

        if irec:
            irec._copy_from(self.rec)

    def delete_one_deft(self,
                        site_id: int,
                        role_id: str,
                        func_id: str):
        """
        Delete one record by it's primary key columns.

        :param site_id: int
        :param role_id: str
        :param func_id: str
        """
        _key = tRoleFuncRelKey()

        _key.site_id = site_id
        _key.role_id = role_id
        _key.func_id = func_id

        self.delete_one(_key)

    def delete_one(self, irec: tRoleFuncRelKey = None):
        """
        Delete the record by its primary key or irec if it is not None.

        :param irec: If not None use this record to delete record.
        """
        _key = tRoleFuncRelKey()

        if irec:
            _key._copy_from(irec)
        else:
            self.rec._write_key(_key)

        with dRoleFuncRelDeleteOne(self._dbcon) as _qry:
            _qry.exec(_key)

