# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Sun Jan  2 10:48:49 2022
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_fura.db.tables.irole_func_rel_exists import iRoleFuncRelExists
from bs_fura.db.tables.orole_func_rel_exists import oRoleFuncRelExists

class dRoleFuncRelExists:

    def __init__(self, dbcon: mettle.db.IConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = iRoleFuncRelExists()
        self.orec     = oRoleFuncRelExists()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    def exec_deft(self,
                  site_id: int,
                  func_id: str,
                  role_id: str) -> "dRoleFuncRelExists":
        """
        Execute the query by setting all the inputs.

        :param site_id: int
        :param func_id: str
        :param role_id: str
        :return: Self for convenience.
        """
        self.irec.site_id = site_id
        self.irec.func_id = func_id
        self.irec.role_id = role_id

        return self.exec()

    def exec(self, irec: iRoleFuncRelExists = None) -> "dRoleFuncRelExists":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = self._dbcon.statement("RoleFuncRelExists", self._dbcon.STMNT_TYPE_READ)

        self._dbstmnt.sql("""select
  rfr.site_id
from
  fura.rolefuncrel rfr
where
  rfr.site_id = :siteId and
  rfr.func_id = :funcId and
  rfr.role_id = :roleId""")

        self._dbstmnt.bind_in("siteId", self.irec.site_id, int, 4)
        self._dbstmnt.bind_in("funcId", self.irec.func_id, str, 128)
        self._dbstmnt.bind_in("roleId", self.irec.role_id, str, 128)

        self._dbstmnt.bind_out("siteId", int, 4)

        self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

    def fetch(self) -> bool:
        """
        Fetches the next row from the executed query.

        :return: True if a row is retreived.
        """
        if not self._dbcon.fetch(self._dbstmnt):
            return False

        self.orec.site_id = self._dbstmnt.result[0]

        return True

    def fetch_all(self, outList: oRoleFuncRelExists.List, clearList: bool = True) -> int:
        """
        Fetch all the rows into the specified list and return the list count.

        :param outList:
        :param clearList:
        :return: Number of rows fetched.
        """
        if clearList:
            outList.clear()

        while self.fetch():
            outList.append(copy.deepcopy(self.orec))

        return len(outList)

