# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Sun Jan  2 10:48:49 2022
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_fura.db.tables.irole_func_rel_search import iRoleFuncRelSearch
from bs_fura.db.tables.orole_func_rel_search import oRoleFuncRelSearch

class dRoleFuncRelSearch:

    def __init__(self, dbcon: mettle.db.IConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = iRoleFuncRelSearch()
        self.orec     = oRoleFuncRelSearch()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    def exec_deft(self,
                  site_id: int,
                  role_id: str,
                  criteria: str) -> "dRoleFuncRelSearch":
        """
        Execute the query by setting all the inputs.

        :param site_id: int
        :param role_id: str
        :param criteria: str
        :return: Self for convenience.
        """
        self.irec.site_id = site_id
        self.irec.role_id = role_id
        self.irec.criteria = criteria

        return self.exec()

    def exec(self, irec: iRoleFuncRelSearch = None) -> "dRoleFuncRelSearch":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = self._dbcon.statement("RoleFuncRelSearch", self._dbcon.STMNT_TYPE_READ)

        self._dbstmnt.sql("""select
  f.id,
  f.descr,
  f.action,
  fg.id,
  fg.descr
from
  fura.role r
    cross join
  fura.func f
    join
  fura.funcgrp fg
    on fg.id = f.funcgrp_id
where
  r.site_id  = :siteId and
  r.id       = :roleId and
  r.status   = 's'     and
  ( :siteId = 1 or f.funcgrp_id != 'fura-admin' )
  [criteria]
union
select
  f.id,
  f.descr,
  f.action,
  fg.id,
  fg.descr
from
  fura.role r
    join
  fura.rolefuncrel rfr
    on rfr.site_id = r.site_id and
       rfr.role_id = r.id
    join
  fura.func f
    on f.id = rfr.func_id
    join
  fura.funcgrp fg
    on fg.id = f.funcgrp_id
where
  r.site_id  = :siteId and
  r.id       = :roleId and
  r.status  != 's'    and
  ( :siteId = 1 or f.funcgrpid != 'fura-admin' )
  [criteria]
order by
  4, 2""")

        self._dbstmnt.dynamic("[criteria]", self.irec.criteria)

        self._dbstmnt.bind_in("siteId", self.irec.site_id, int, 4)
        self._dbstmnt.bind_in("roleId", self.irec.role_id, str, 128)

        self._dbstmnt.bind_out("funcId", str)
        self._dbstmnt.bind_out("funcDescr", str)
        self._dbstmnt.bind_out("funcAction", str, 1)
        self._dbstmnt.bind_out("funcgrpId", str)
        self._dbstmnt.bind_out("funcgrpDescr", str)

        self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

    def fetch(self) -> bool:
        """
        Fetches the next row from the executed query.

        :return: True if a row is retreived.
        """
        if not self._dbcon.fetch(self._dbstmnt):
            return False

        self.orec.func_id = self._dbstmnt.result[0]
        self.orec.func_descr = self._dbstmnt.result[1]
        self.orec.func_action = self._dbstmnt.result[2]
        self.orec.funcgrp_id = self._dbstmnt.result[3]
        self.orec.funcgrp_descr = self._dbstmnt.result[4]

        return True

    def fetch_all(self, outList: oRoleFuncRelSearch.List, clearList: bool = True) -> int:
        """
        Fetch all the rows into the specified list and return the list count.

        :param outList:
        :param clearList:
        :return: Number of rows fetched.
        """
        if clearList:
            outList.clear()

        while self.fetch():
            outList.append(copy.deepcopy(self.orec))

        return len(outList)

