# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Sun Jan  2 10:48:49 2022
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_fura.db.tables.itoken_expired import iTokenExpired
from bs_fura.db.tables.token import tToken

class dTokenExpired:

    def __init__(self, dbcon: mettle.db.IAConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = iTokenExpired()
        self.orec     = tToken()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    async def exec_deft(self,
                        site_id: int,
                        curr_time: datetime.datetime) -> "dTokenExpired":
        """
        Execute the query by setting all the inputs.

        :param site_id: int
        :param curr_time: datetime.datetime
        :return: Self for convenience.
        """
        self.irec.site_id = site_id
        self.irec.curr_time = curr_time

        return await self.exec()

    async def exec(self, irec: iTokenExpired = None) -> "dTokenExpired":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = await self._dbcon.statement("TokenExpired", self._dbcon.STMNT_TYPE_READ)

        self._dbstmnt.sql("""select
  t.*
from
  fura.token t
where
  t.expires <= :currtime and
  (:siteId = 0 or t.site_id = :siteId)""")

        self._dbstmnt.bind_in("siteId", self.irec.site_id, int, 4)
        self._dbstmnt.bind_in("currTime", self.irec.curr_time, datetime.datetime)

        self._dbstmnt.bind_out("site_id", int, 4)
        self._dbstmnt.bind_out("id", str, 64)
        self._dbstmnt.bind_out("usr_id", str, 128)
        self._dbstmnt.bind_out("date_created", datetime.datetime)
        self._dbstmnt.bind_out("expires", datetime.datetime)
        self._dbstmnt.bind_out("use_cnt", int, 4)
        self._dbstmnt.bind_out("audId", str)
        self._dbstmnt.bind_out("tmStamp", datetime.datetime)

        await self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

    async def fetch(self) -> bool:
        """
        Fetches the next row from the executed query.

        :return: True if a row is retreived.
        """
        if not await self._dbcon.fetch(self._dbstmnt):
            return False

        self.orec.site_id = self._dbstmnt.result[0]
        self.orec.id = self._dbstmnt.result[1]
        self.orec.usr_id = self._dbstmnt.result[2]
        self.orec.date_created = self._dbstmnt.result[3]
        self.orec.expires = self._dbstmnt.result[4]
        self.orec.use_cnt = self._dbstmnt.result[5]
        self.orec.aud_id = self._dbstmnt.result[6]
        self.orec.tm_stamp = self._dbstmnt.result[7]

        return True

    async def fetch_all(self, outList: tToken.List, clearList: bool = True) -> int:
        """
        Fetch all the rows into the specified list and return the list count.

        :param outList:
        :param clearList:
        :return: Number of rows fetched.
        """
        if clearList:
            outList.clear()

        while await self.fetch():
            outList.append(copy.deepcopy(self.orec))

        return len(outList)

