# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Sun Jan  2 10:48:49 2022
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_fura.db.tables.token_hist import tTokenHist

class dTokenHistInsert:

    def __init__(self, dbcon: mettle.db.IAConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tTokenHist()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    async def exec_deft(self,
                        site_id: int,
                        id: str,
                        usr_id: str,
                        date_created: datetime.datetime,
                        expires: datetime.datetime,
                        use_cnt: int,
                        aud_id: str,
                        tm_stamp: datetime.datetime) -> "dTokenHistInsert":
        """
        Execute the query by setting all the inputs.

        :param site_id: int
        :param id: str
        :param usr_id: str
        :param date_created: datetime.datetime
        :param expires: datetime.datetime
        :param use_cnt: int
        :param aud_id: str
        :param tm_stamp: datetime.datetime
        :return: Self for convenience.
        """
        self.irec.site_id = site_id
        self.irec.id = id
        self.irec.usr_id = usr_id
        self.irec.date_created = date_created
        self.irec.expires = expires
        self.irec.use_cnt = use_cnt
        self.irec.aud_id = aud_id
        self.irec.tm_stamp = tm_stamp

        return await self.exec()

    async def exec(self, irec: tTokenHist = None) -> "dTokenHistInsert":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = await self._dbcon.statement("TokenHistInsert", self._dbcon.STMNT_TYPE_CUD)

        self._dbstmnt.sql("""insert into fura.TokenHist (
  site_id,
  id,
  usr_id,
  date_created,
  expires,
  use_cnt,
  audId,
  tmStamp
) values (
  :site_id,
  :id,
  :usr_id,
  :date_created,
  :expires,
  :use_cnt,
  :audId,
  :tmStamp
)""")

        self.irec.tm_stamp = await self._dbcon.get_timestamp()

        self._dbstmnt.bind_in("site_id", self.irec.site_id, int, 4)
        self._dbstmnt.bind_in("id", self.irec.id, str, 64)
        self._dbstmnt.bind_in("usr_id", self.irec.usr_id, str, 128)
        self._dbstmnt.bind_in("date_created", self.irec.date_created, datetime.datetime)
        self._dbstmnt.bind_in("expires", self.irec.expires, datetime.datetime)
        self._dbstmnt.bind_in("use_cnt", self.irec.use_cnt, int, 4)
        self._dbstmnt.bind_in("audId", self.irec.aud_id, str)
        self._dbstmnt.bind_in("tmStamp", self.irec.tm_stamp, datetime.datetime)

        await self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

