# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Sun Jan  2 10:48:49 2022
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_fura.db.tables.token_key import tTokenKey
from bs_fura.db.tables.token import tToken

class dTokenSelectOne:

    def __init__(self, dbcon: mettle.db.IAConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tTokenKey()
        self.orec     = tToken()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    async def exec_deft(self,
                        site_id: int,
                        id: str) -> "dTokenSelectOne":
        """
        Execute the query by setting all the inputs.

        :param site_id: int
        :param id: str
        :return: Self for convenience.
        """
        self.irec.site_id = site_id
        self.irec.id = id

        return await self.exec()

    async def exec(self, irec: tTokenKey = None) -> "dTokenSelectOne":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = await self._dbcon.statement("TokenSelectOne", self._dbcon.STMNT_TYPE_READ)

        self._dbstmnt.sql("""select
  site_id,
  id,
  usr_id,
  date_created,
  expires,
  use_cnt,
  audId,
  tmStamp
from
  fura.Token
where
  site_id = :site_id and
  id = :id""")

        self._dbstmnt.bind_in("site_id", self.irec.site_id, int, 4)
        self._dbstmnt.bind_in("id", self.irec.id, str, 64)

        self._dbstmnt.bind_out("site_id", int, 4)
        self._dbstmnt.bind_out("id", str, 64)
        self._dbstmnt.bind_out("usr_id", str, 128)
        self._dbstmnt.bind_out("date_created", datetime.datetime)
        self._dbstmnt.bind_out("expires", datetime.datetime)
        self._dbstmnt.bind_out("use_cnt", int, 4)
        self._dbstmnt.bind_out("audId", str)
        self._dbstmnt.bind_out("tmStamp", datetime.datetime)

        await self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

    async def fetch(self) -> bool:
        """
        Fetches the next row from the executed query.

        :return: True if a row is retreived.
        """
        if not await self._dbcon.fetch(self._dbstmnt):
            return False

        self.orec.site_id = self._dbstmnt.result[0]
        self.orec.id = self._dbstmnt.result[1]
        self.orec.usr_id = self._dbstmnt.result[2]
        self.orec.date_created = self._dbstmnt.result[3]
        self.orec.expires = self._dbstmnt.result[4]
        self.orec.use_cnt = self._dbstmnt.result[5]
        self.orec.aud_id = self._dbstmnt.result[6]
        self.orec.tm_stamp = self._dbstmnt.result[7]

        return True

    async def fetch_all(self, outList: tToken.List, clearList: bool = True) -> int:
        """
        Fetch all the rows into the specified list and return the list count.

        :param outList:
        :param clearList:
        :return: Number of rows fetched.
        """
        if clearList:
            outList.clear()

        while await self.fetch():
            outList.append(copy.deepcopy(self.orec))

        return len(outList)

