# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Sun Jan  2 10:48:49 2022
#  Target Database = postgresql
#
import asyncio
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_fura.db.tables.usr import tUsr
from bs_fura.db.tables.usr_key import tUsrKey

from .usr_lock_one import dUsrLockOne
from .usr_select_one import dUsrSelectOne
from .usr_update import dUsrUpdate
from .usr_insert import dUsrInsert
from .usr_delete_one import dUsrDeleteOne

class dUsr:

    def __init__(self, dbcon: mettle.db.IAConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self.rec    = tUsr()
        self._dbcon = dbcon

    def __enter__(self):
        """
        DAO enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        DAO exit.
        """
        pass

    async def lock_one(self, _lock4update: mettle.db.DBLock, _expected: bool = True) -> bool:
        """
        Lock and select the record.

        :param _lock4update: The db lock object to use.
        :param _expected: If set to false, will not raise if record is not found.
        :return: True if selected, False if not found and _expected is set to False
        """
        _key = tUsrKey()

        self.rec._write_key(_key)

        return await self.lock_one_by_key(_key, _lock4update, _expected)

    async def lock_one_with(self, _rec: tUsr, _lock4update: mettle.db.DBLock, _expected: bool = True) -> bool:
        """
        Lock and select the record using a record.

        :param _rec: The table rec to select with and into.
        :param _lock4update: The db lock object to use.
        :param _expected: If set to false, will not raise if record is not found.
        :return: True if selected, False if not found and _expected is set to False
        """
        _key = tUsrKey()
        _rec._write_key(_key)

        await self.lock_one_by_key(_key, _lock4update, _expected)
        _rec._copy_from(self.rec)
        return True

    async def lock_one_deft(self,
                            site_id: int,
                            id: str,
                            _lock4update: mettle.db.DBLock,
                            _expected: bool = True) -> bool:
        """
        Attempt to lock and select the record by it's primary key columns.

        :param site_id: int
        :param id: str
        :param _lock4update:  The db lock object to use. 
        :param _expected: bool
        """
        _key = tUsrKey()

        _key.site_id = site_id
        _key.id = id

        return await self.lock_one_by_key(_key, _lock4update, _expected)

    async def lock_one_by_key(self, _key: tUsrKey, _lock4update: mettle.db.DBLock, _expected: bool = True) -> bool:
        """
        Attempt to lock and select the record with it's primary key.

        :param _key: Primary key of the table record.
        :param _lock4update: The db lock object to use.
        :param _expected: If set to false, will not raise if record is not found.
        :return: True if selected, False if not found and _expected is set to False
        """
        with dUsrLockOne(self._dbcon) as _qry:
            _dex = _lock4update.retrys - 1 if _lock4update.retrys > 0 else 0

            while _dex >= 0:
                try:
                    await _qry.exec(_key)
                    if not await _qry.fetch():
                        if not _expected:
                            return False

                        raise mettle.lib.xMettle("LockOne failed to return a record (dUsr)")

                    break
                except mettle.lib.xMettle as _x:
                    if _x.get_error_code() != mettle.lib.xMettle.eCode.DBLockNoWaitFailed:
                        raise _x

                    if _dex == 0:
                        raise mettle.lib.xMettle("Could not lock Usr record after %d attempt(s) at %d mili second intervals!" % (
_lock4update.retrys, _lock4update.mili_seconds), errCode = mettle.lib.xMettle.eCode.DBLockNoWaitFailed)

                    if _lock4update.mili_seconds > 0:
                        await asyncio.sleep(_lock4update.mili_seconds * 0.001)
                _dex -= 1

            self.rec = _qry.orec

            return True

    async def try_select_one(self) -> bool:
        """
        Attempt to select the record.

        :return: True if the record was found.
        """
        _key = tUsrKey()

        self.rec._write_key(_key)

        return await self.try_select_one_by_key(_key)

    async def try_select_one_with(self, _rec: tUsr) -> bool:
        """
        Attempt to select the record using a table rec.

        :param _rec: The table rec to select with and into.
        :return: True if the row as selectd.
        """
        _key = tUsrKey()
        _rec._write_key(_key)

        if not await self.try_select_one_by_key(_key):
            return False

        _rec._copy_from(self.rec)

        return True

    async def try_select_one_deft(self,
                                  site_id: int,
                                  id: str) -> bool:
        """
        Attempt to select the record by it's primary key columns.

        :param site_id: int
        :param id: str
        :return: True if the row as selectd.
        """
        _key = tUsrKey()

        _key.site_id = site_id
        _key.id = id

        return await self.try_select_one_by_key(_key)

    async def try_select_one_by_key(self, _key: tUsrKey) -> bool:
        """
        Attempt to select the record with it's primary key.

        :param _key: Primary key of the table record.
        :returns: True if row was selected.
        """
        with dUsrSelectOne(self._dbcon) as _qry:
            await _qry.exec(_key)
            if not await _qry.fetch():
                return False

            self.rec = _qry.orec

        return True

    async def select_one(self) -> "dUsr":
        """
        Selects the record, raises and error if it does not exist.

        :return: Self for convenience.
        """
        if not await self.try_select_one():
            raise mettle.lib.xMettle("SelectOne failed to return a record (dUsr)")

        return self

    async def select_one_with(self, _rec: tUsr) -> "dUsr":
        """
        Attempt to select the record with the table record.

        :param _rec: Table record.
        :returns: Self for convenience.
        """
        if not await self.try_select_one_with(_rec):
            raise mettle.lib.xMettle("SelectOne failed to return a record (dUsr)")

        return self

    async def select_one_deft(self,
                              site_id: int,
                              id: str) -> "dUsr":
        """
        Selects the record by its primary key columns, raises and error if it does not exist.

        :param site_id: int
        :param id: str
        """
        _key = tUsrKey()

        _key.site_id = site_id
        _key.id = id

        if not await self.try_select_one_by_key(_key):
            raise mettle.lib.xMettle("SelectOne failed to return a record (dUsr)")

        return self

    async def select_one_by_key(self, _key: tUsrKey) -> "dUsr":
        """
        Attempt to select the record with it's primary key.

        :param _key: Primary key of the table record.
        :return: Self for convenience.
        """
        if not await self.try_select_one_by_key(_key):
            raise mettle.lib.xMettle("SelectOne failed to return a record (dUsr)")

        return self

    async def update_deft(self,
                          site_id: int,
                          id: str,
                          role_id: str,
                          status: str,
                          name_first: str,
                          name_last: str,
                          title: str,
                          date_activate: datetime.date,
                          date_expire: datetime.date,
                          email1: str,
                          email2: str,
                          cellno1: str,
                          cellno2: str,
                          modified_by: str,
                          usrtype_id: str,
                          email1_conf: bool,
                          email2_conf: bool,
                          cellno1_conf: bool,
                          cellno2_conf: bool,
                          opt_system: bool,
                          opt_market: bool,
                          opt_fail_login: bool):
        """
        Update the record by setting all column values.

        :param site_id: int
        :param id: str
        :param role_id: str
        :param status: str
        :param name_first: str
        :param name_last: str
        :param title: str
        :param date_activate: datetime.date
        :param date_expire: datetime.date
        :param email1: str
        :param email2: str
        :param cellno1: str
        :param cellno2: str
        :param modified_by: str
        :param tm_stamp: datetime.datetime
        :param usrtype_id: str
        :param email1_conf: bool
        :param email2_conf: bool
        :param cellno1_conf: bool
        :param cellno2_conf: bool
        :param opt_system: bool
        :param opt_market: bool
        :param opt_fail_login: bool
        """
        self.rec.site_id = site_id
        self.rec.id = id
        self.rec.role_id = role_id
        self.rec.status = status
        self.rec.name_first = name_first
        self.rec.name_last = name_last
        self.rec.title = title
        self.rec.date_activate = date_activate
        self.rec.date_expire = date_expire
        self.rec.email1 = email1
        self.rec.email2 = email2
        self.rec.cellno1 = cellno1
        self.rec.cellno2 = cellno2
        self.rec.modified_by = modified_by
        self.rec.usrtype_id = usrtype_id
        self.rec.email1_conf = email1_conf
        self.rec.email2_conf = email2_conf
        self.rec.cellno1_conf = cellno1_conf
        self.rec.cellno2_conf = cellno2_conf
        self.rec.opt_system = opt_system
        self.rec.opt_market = opt_market
        self.rec.opt_fail_login = opt_fail_login

        await self.update()

    async def update(self, irec: tUsr = None):
        """
        Update the record in the database with the record or irec if it is not None.

        :param irec: If not None use this record to update the database.
        """
        if irec:
            self.rec._copy_from(irec)

        with dUsrUpdate(self._dbcon) as _qry:
            await _qry.exec(self.rec)

        if irec:
            irec._copy_from(self.rec)

    async def insert_deft(self,
                          site_id: int,
                          id: str,
                          role_id: str,
                          status: str,
                          name_first: str,
                          name_last: str,
                          title: str,
                          date_activate: datetime.date,
                          date_expire: datetime.date,
                          email1: str,
                          email2: str,
                          cellno1: str,
                          cellno2: str,
                          modified_by: str,
                          usrtype_id: str,
                          email1_conf: bool,
                          email2_conf: bool,
                          cellno1_conf: bool,
                          cellno2_conf: bool,
                          opt_system: bool,
                          opt_market: bool,
                          opt_fail_login: bool):
        """
        Insert the record setting all column values.

        :param site_id: int
        :param id: str
        :param role_id: str
        :param status: str
        :param name_first: str
        :param name_last: str
        :param title: str
        :param date_activate: datetime.date
        :param date_expire: datetime.date
        :param email1: str
        :param email2: str
        :param cellno1: str
        :param cellno2: str
        :param modified_by: str
        :param tm_stamp: datetime.datetime
        :param usrtype_id: str
        :param email1_conf: bool
        :param email2_conf: bool
        :param cellno1_conf: bool
        :param cellno2_conf: bool
        :param opt_system: bool
        :param opt_market: bool
        :param opt_fail_login: bool
        """
        self.rec.site_id = site_id
        self.rec.id = id
        self.rec.role_id = role_id
        self.rec.status = status
        self.rec.name_first = name_first
        self.rec.name_last = name_last
        self.rec.title = title
        self.rec.date_activate = date_activate
        self.rec.date_expire = date_expire
        self.rec.email1 = email1
        self.rec.email2 = email2
        self.rec.cellno1 = cellno1
        self.rec.cellno2 = cellno2
        self.rec.modified_by = modified_by
        self.rec.usrtype_id = usrtype_id
        self.rec.email1_conf = email1_conf
        self.rec.email2_conf = email2_conf
        self.rec.cellno1_conf = cellno1_conf
        self.rec.cellno2_conf = cellno2_conf
        self.rec.opt_system = opt_system
        self.rec.opt_market = opt_market
        self.rec.opt_fail_login = opt_fail_login

        await self.insert()

    async def insert(self, irec: tUsr = None):
        """
        Insert the record in the database with the record or irec if it is not None.

        :param irec: If not None use this record to insert into the database.
        """
        if irec:
            self.rec._copy_from(irec)

        with dUsrInsert(self._dbcon) as _qry:
            await _qry.exec(self.rec)

        if irec:
            irec._copy_from(self.rec)

    async def delete_one_deft(self,
                              site_id: int,
                              id: str):
        """
        Delete one record by it's primary key columns.

        :param site_id: int
        :param id: str
        """
        _key = tUsrKey()

        _key.site_id = site_id
        _key.id = id

        await self.delete_one(_key)

    async def delete_one(self, irec: tUsrKey = None):
        """
        Delete the record by its primary key or irec if it is not None.

        :param irec: If not None use this record to delete record.
        """
        _key = tUsrKey()

        if irec:
            _key._copy_from(irec)
        else:
            self.rec._write_key(_key)

        with dUsrDeleteOne(self._dbcon) as _qry:
            await _qry.exec(_key)

