# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Sun Jan  2 10:48:49 2022
#

import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from .func_key import tFuncKey

class tFunc(mettle.io.ISerializable, mettle.db.IPrimaryKey):

    def __init__(self,
                 id: str = '',
                 funcgrp_id: str = '',
                 descr: str = '',
                 action: str = '',
                 oride: str = '',
                 audit_lvl: int = 0,
                 modified_by: str = ''):
        """
        Constructor.

        :param id: str
        :param funcgrp_id: str
        :param descr: str
        :param action: str
        :param oride: str
        :param audit_lvl: int
        :param modified_by: str
        :param tm_stamp: datetime.datetime
        """
        self.id = id
        self.funcgrp_id = funcgrp_id
        self.descr = descr
        self.action = action
        self.oride = oride
        self.audit_lvl = audit_lvl
        self.modified_by = modified_by
        self.tm_stamp = None

    def clear(self):
        """
        Clears all member variables for this database record.
        """
        self.id = ''
        self.funcgrp_id = ''
        self.descr = ''
        self.action = ''
        self.oride = ''
        self.audit_lvl = 0
        self.modified_by = ''
        self.tm_stamp = None

    def _name(self) -> str:
        """
        Name of the record.

        :return: The name.
        """
        return 'tFunc'

    def _serialize(self, _w: mettle.io.IWriter, _oname: str = None):
        """
        Serialize record to a stream.

        :param _w:
        :param _oname:
        """
        if _oname == None:
            _oname = self._name()

        _w.write_start(_oname)
        _w.write_string("id", self.id)
        _w.write_string("funcgrp_id", self.funcgrp_id)
        _w.write_string("descr", self.descr)
        _w.write_char("action", self.action)
        _w.write_char("oride", self.oride)
        _w.write_int32("audit_lvl", self.audit_lvl)
        _w.write_string("modified_by", self.modified_by)
        _w.write_datetime("tm_stamp", self.tm_stamp)
        _w.write_end(_oname)

    def _deserialize(self, _r: mettle.io.IReader, _oname: str = None):
        """
        Deserialize record from a stream.

        :param _r:
        :param _oname:
        """
        if _oname == None:
            _oname = self._name()

        _r.read_start(_oname)
        self.id = _r.read_string("id")
        self.funcgrp_id = _r.read_string("funcgrp_id")
        self.descr = _r.read_string("descr")
        self.action = _r.read_char("action")
        self.oride = _r.read_char("oride")
        self.audit_lvl = _r.read_int32("audit_lvl")
        self.modified_by = _r.read_string("modified_by")
        self.tm_stamp = _r.read_datetime("tm_stamp")
        _r.read_end(_oname)

    def _copy_from(self, rec: "tFunc"):
        """
        Copies the column from the rec into this record.

        :param rec: The source record.
        """
        self.id = rec.id
        self.funcgrp_id = rec.funcgrp_id
        self.descr = rec.descr
        self.action = rec.action
        self.oride = rec.oride
        self.audit_lvl = rec.audit_lvl
        self.modified_by = rec.modified_by
        self.tm_stamp = rec.tm_stamp

    def _write_pk(self, _key: "tFunc"):
        """
        Write the primary key columns to the key object.

        :param _key:
        """
        self._write_key(_key)

    def _read_pk(self, _key: "tFunc"):
        """
        Read the primary key columns from the key object.

        :param _key:
        """
        self._read_key(_key)

    def _serialize_key(self, _w: mettle.io.IWriter):
        """
        Serialize the primary key to a stream.

        :param _w:
        """
        _key = tFuncKey()

        self._write_key(_key)
        _key._serialize(_w)

    def _deserialize_key(self, _r: mettle.io.IReader):
        """
        Deserialize the primary key from a stream.

        :param _r:
        """
        _key = tFuncKey()

        _key._deserialize(_r)
        self._read_key(_key)

    @staticmethod
    def _cache_davs(dvc=None, for_ins: bool = False, key_only: bool = False):
        """
        Cache the DAV into the dav cache (or create one) and return it.

        :param dvc: (mettle.lib.DavCache), target cache, if None a new one is created and returned.
        :param for_ins: Davs for insert.
        :param key_only: Davs by key only, ie for delete/selectone.
        """
        if dvc is None:
            dvc = mettle.lib.DavCache()

        dvc.add_targ("id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 128))
        if key_only:
            return dvc

        dvc.add_targ("funcgrp_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("funcgrp_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 128))
        dvc.add_targ("descr", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("descr", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 256))
        dvc.add_targ("action", mettle.lib.Dav(mettle.lib.Dav.eDavType.Min, 1))
        dvc.add_targ("action", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 1))
        dvc.add_targ("action", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("action", mettle.lib.Dav(mettle.lib.Dav.eDavType.In, ['C','R','U','D','O','A','N']))
        dvc.add_targ("oride", mettle.lib.Dav(mettle.lib.Dav.eDavType.Min, 1))
        dvc.add_targ("oride", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 1))
        dvc.add_targ("oride", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("oride", mettle.lib.Dav(mettle.lib.Dav.eDavType.In, ['N','Y','S','H']))
        dvc.add_targ("audit_lvl", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("audit_lvl", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 20))
        dvc.add_targ("audit_lvl", mettle.lib.Dav(mettle.lib.Dav.eDavType.Min, 1))
        dvc.add_targ("modified_by", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("modified_by", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 128))

        return dvc

    def _get_davs(self, dvc=None, for_ins: bool = False, key_only: bool = False):
        tFunc._cache_davs(dvc, for_ins, key_only)

    def _write_key(self, _key: tFuncKey):
        """
        Write primary key columns to _key.

        :param _key:
        """
        _key.id = self.id

    def _read_key(self, _key: tFuncKey):
        """
        Read the primary key columns from _key.

        :param _key:
        """
        self.id = _key.id

    class Action_Couplet(dict):
        key_create = "C"
        key_read = "R"
        key_update = "U"
        key_delete = "D"
        key_other = "O"
        key_authorize = "A"
        key_navigation = "N"

        value_create = "Create"
        value_read = "Read"
        value_update = "Update"
        value_delete = "Delete"
        value_other = "Other"
        value_authorize = "Authorize"
        value_navigation = "Navigation"

        def __init__(self):
            self[self.key_create] = self.value_create
            self[self.key_read] = self.value_read
            self[self.key_update] = self.value_update
            self[self.key_delete] = self.value_delete
            self[self.key_other] = self.value_other
            self[self.key_authorize] = self.value_authorize
            self[self.key_navigation] = self.value_navigation

        @staticmethod
        def get_value(key):
            if key == tFunc.Action_Couplet.key_create:
                return tFunc.Action_Couplet.value_create

            if key == tFunc.Action_Couplet.key_read:
                return tFunc.Action_Couplet.value_read

            if key == tFunc.Action_Couplet.key_update:
                return tFunc.Action_Couplet.value_update

            if key == tFunc.Action_Couplet.key_delete:
                return tFunc.Action_Couplet.value_delete

            if key == tFunc.Action_Couplet.key_other:
                return tFunc.Action_Couplet.value_other

            if key == tFunc.Action_Couplet.key_authorize:
                return tFunc.Action_Couplet.value_authorize

            if key == tFunc.Action_Couplet.key_navigation:
                return tFunc.Action_Couplet.value_navigation

            return ""

    class Oride_Couplet(dict):
        key_no = "N"
        key_yes = "Y"
        key_second_level = "S"
        key_higher_level = "H"

        value_no = "No"
        value_yes = "Yes"
        value_second_level = "Second Level"
        value_higher_level = "Higher Level"

        def __init__(self):
            self[self.key_no] = self.value_no
            self[self.key_yes] = self.value_yes
            self[self.key_second_level] = self.value_second_level
            self[self.key_higher_level] = self.value_higher_level

        @staticmethod
        def get_value(key):
            if key == tFunc.Oride_Couplet.key_no:
                return tFunc.Oride_Couplet.value_no

            if key == tFunc.Oride_Couplet.key_yes:
                return tFunc.Oride_Couplet.value_yes

            if key == tFunc.Oride_Couplet.key_second_level:
                return tFunc.Oride_Couplet.value_second_level

            if key == tFunc.Oride_Couplet.key_higher_level:
                return tFunc.Oride_Couplet.value_higher_level

            return ""

    @staticmethod
    def _pk_compare(x, y) -> int:
        """
        Compare function do primary key comparisons for list sorts and searches.

        :return: zero for x == y, negative for x < y, positive for x > y
        """
        return (x.id > y.id) - (x.id < y.id)

    def __lt__(self, other):
        return other and self._pk_compare(self, other) < 0

    def __gt__(self, other):
        return other and self._pk_compare(self, other) > 0

    def __eq__(self, other):
        return other and self._pk_compare(self, other) == 0

    def __le__(self, other):
        return other and self._pk_compare(self, other) <= 0

    def __ge__(self, other):
        return other and self._pk_compare(self, other) >= 0

    def __ne__(self, other):
        return other == None or self._pk_compare(self, other)

    def __repr__(self) -> str:
        return '<Func [id:%.32s, funcgrp_id:%.32s, descr:%.32s, action:%.32s, oride:%.32s, audit_lvl:%r, modified_by:%.32s, tm_stamp:%s]>' % (
            self.id, self.funcgrp_id, self.descr, self.action, self.oride, self.audit_lvl, self.modified_by, self.tm_stamp)


    class List(list, mettle.io.ISerializable):
        """
        List Class
        """

        def _name(self) -> str:
            """
            Name of the list.

            :return: The name
            """
            return 'tFunc.List'

        def _serialize(self, _w: mettle.io.IWriter, _oname: str = None):
            """
            Serialize the list to a stream.

            :param _w:
            :param _oname:
            """
            if _oname == None:
                _oname = self._name()

            _w.write_start_list(_oname, len(self))

            for _rec in self:
                _rec._serialize(_w)

            _w.write_end(_oname)

        def _deserialize(self, _r: mettle.io.IReader, _oname: str = None):
            """
            Deserialize the list from a stream.

            :param _r:
            :param _oname:
            """
            if _oname == None:
                _oname = self._name()

            _cnt = _r.read_start_list(_oname)

            while _cnt >= 1:
                _rec  = tFunc()
                _cnt -= 1
                _rec._deserialize(_r)
                self.append(_rec)

            _r.read_end(_oname)

        def __repr__(self) -> str:
            return '<tFunc.List[%d]>' % (len(self))

        def _get_davs(self, dvc=None, for_ins: bool = False, key_only: bool = False):
            return tFunc._cache_davs(dvc, for_ins, key_only)

