# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Sun Jan  2 10:48:49 2022
#

import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

class tRoleFuncRelKey(mettle.io.ISerializable):

    def __init__(self,
                 site_id: int = 0,
                 role_id: str = '',
                 func_id: str = ''):
        """
        Constructor.

        :param site_id: int
        :param role_id: str
        :param func_id: str
        """
        self.site_id = site_id
        self.role_id = role_id
        self.func_id = func_id

    def clear(self):
        """
        Clears all member variables for this database record.
        """
        self.site_id = 0
        self.role_id = ''
        self.func_id = ''

    def _name(self) -> str:
        """
        Name of the record.

        :return: The name.
        """
        return 'tRoleFuncRelKey'

    def _serialize(self, _w: mettle.io.IWriter, _oname: str = None):
        """
        Serialize record to a stream.

        :param _w:
        :param _oname:
        """
        if _oname == None:
            _oname = self._name()

        _w.write_start(_oname)
        _w.write_int32("site_id", self.site_id)
        _w.write_string("role_id", self.role_id)
        _w.write_string("func_id", self.func_id)
        _w.write_end(_oname)

    def _deserialize(self, _r: mettle.io.IReader, _oname: str = None):
        """
        Deserialize record from a stream.

        :param _r:
        :param _oname:
        """
        if _oname == None:
            _oname = self._name()

        _r.read_start(_oname)
        self.site_id = _r.read_int32("site_id")
        self.role_id = _r.read_string("role_id")
        self.func_id = _r.read_string("func_id")
        _r.read_end(_oname)

    def _copy_from(self, rec: "tRoleFuncRelKey"):
        """
        Copies the column from the rec into this record.

        :param rec: The source record.
        """
        self.site_id = rec.site_id
        self.role_id = rec.role_id
        self.func_id = rec.func_id

    @staticmethod
    def _cache_davs(dvc=None):
        """
        Cache the DAV into the dav cache (or create one) and return it.

        :param dvc: (mettle.lib.DavCache), target cache, if None a new one is created and returned.
        """
        if dvc is None:
            dvc = mettle.lib.DavCache()

        dvc.add_targ("site_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("role_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("role_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 128))
        dvc.add_targ("func_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("func_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 128))

        return dvc

    def _get_davs(self, dvc=None):
        tRoleFuncRelKey._cache_davs(dvc)

    @staticmethod
    def _pk_compare(x, y) -> int:
        """
        Compare function do primary key comparisons for list sorts and searches.

        :return: zero for x == y, negative for x < y, positive for x > y
        """
        rc = x.site_id - y.site_id

        if rc != 0:
            return rc

        rc = (x.role_id > y.role_id) - (x.role_id < y.role_id)

        if rc != 0:
            return rc

        rc = (x.func_id > y.func_id) - (x.func_id < y.func_id)

        return rc

    def __lt__(self, other):
        return other and self._pk_compare(self, other) < 0

    def __gt__(self, other):
        return other and self._pk_compare(self, other) > 0

    def __eq__(self, other):
        return other and self._pk_compare(self, other) == 0

    def __le__(self, other):
        return other and self._pk_compare(self, other) <= 0

    def __ge__(self, other):
        return other and self._pk_compare(self, other) >= 0

    def __ne__(self, other):
        return other == None or self._pk_compare(self, other)

    def __repr__(self) -> str:
        return '<RoleFuncRel [site_id:%r, role_id:%.32s, func_id:%.32s]>' % (
            self.site_id, self.role_id, self.func_id)


    class List(list, mettle.io.ISerializable):
        """
        List Class
        """

        def _name(self) -> str:
            """
            Name of the list.

            :return: The name
            """
            return 'tRoleFuncRelKey.List'

        def _serialize(self, _w: mettle.io.IWriter, _oname: str = None):
            """
            Serialize the list to a stream.

            :param _w:
            :param _oname:
            """
            if _oname == None:
                _oname = self._name()

            _w.write_start_list(_oname, len(self))

            for _rec in self:
                _rec._serialize(_w)

            _w.write_end(_oname)

        def _deserialize(self, _r: mettle.io.IReader, _oname: str = None):
            """
            Deserialize the list from a stream.

            :param _r:
            :param _oname:
            """
            if _oname == None:
                _oname = self._name()

            _cnt = _r.read_start_list(_oname)

            while _cnt >= 1:
                _rec  = tRoleFuncRelKey()
                _cnt -= 1
                _rec._deserialize(_r)
                self.append(_rec)

            _r.read_end(_oname)

        def __repr__(self) -> str:
            return '<tRoleFuncRelKey.List[%d]>' % (len(self))

        def _get_davs(self, dvc=None):
            return tRoleFuncRelKey._cache_davs(dvc)

