# AUTOGENERATED! DO NOT EDIT! File to edit: notebooks/97_Helpers.ipynb (unless otherwise specified).

__all__ = ['ensure', 'ensure_equal', 'ensure_exists', 'fix_readme']

# Cell

from pathlib import Path
import re

# Internal Cell

from fastcore.script import *

# Cell

def ensure(p, msg: str=None):
    """ Ensures that p value is True
    """
    if not p:
        raise ValueError(msg)

def ensure_equal(x, y, msg: str=None):
    """ Ensures that two objects are equal
    """

    if msg is None:
        msg = f"{x} != {y}"
    ensure(x == y, msg)

def ensure_exists(f: Path, msg: str=None):
    """ Ensures that path exists
    """

    if msg is None:
        msg = f"{f} does not exist"
    ensure(f.exists(), msg)

# Cell


@call_parse
def fix_readme(
    file_path: Param("path to README.md file", Path), verbose: Param("", bool) = False
):

    file = open(file_path, "r")
    list_of_lines = file.readlines()
    for i in range(len(list_of_lines)):
        r1 = re.search("{% include note.html content='(.*?)' %}", list_of_lines[i])
        if r1:
            list_of_lines[i] = r1.group(1) + "\n"
            if verbose:
                print(list_of_lines[i])

    file = open(file_path, "w")
    file.writelines(list_of_lines)
    file.close()