import * as ec2 from '@aws-cdk/aws-ec2';
import * as iam from '@aws-cdk/aws-iam';
import * as kms from '@aws-cdk/aws-kms';
import { Duration, IResource, RemovalPolicy, Resource } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { Endpoint } from './endpoint';
import { InstanceType } from './instance';
import { IClusterParameterGroup, IParameterGroup } from './parameter-group';
import { ISubnetGroup } from './subnet-group';
/**
 * (experimental) Possible Instances Types to use in Neptune cluster used for defining {@link DatabaseClusterProps.engineVersion}.
 *
 * @experimental
 */
export declare class EngineVersion {
    readonly version: string;
    /**
     * (experimental) Neptune engine version 1.0.1.0.
     *
     * @experimental
     */
    static readonly V1_0_1_0: EngineVersion;
    /**
     * (experimental) Neptune engine version 1.0.1.1.
     *
     * @experimental
     */
    static readonly V1_0_1_1: EngineVersion;
    /**
     * (experimental) Neptune engine version 1.0.1.2.
     *
     * @experimental
     */
    static readonly V1_0_1_2: EngineVersion;
    /**
     * (experimental) Neptune engine version 1.0.2.1.
     *
     * @experimental
     */
    static readonly V1_0_2_1: EngineVersion;
    /**
     * (experimental) Neptune engine version 1.0.2.2.
     *
     * @experimental
     */
    static readonly V1_0_2_2: EngineVersion;
    /**
     * (experimental) Neptune engine version 1.0.3.0.
     *
     * @experimental
     */
    static readonly V1_0_3_0: EngineVersion;
    /**
     * (experimental) Neptune engine version 1.0.4.0.
     *
     * @experimental
     */
    static readonly V1_0_4_0: EngineVersion;
    /**
     * (experimental) Neptune engine version 1.0.4.1.
     *
     * @experimental
     */
    static readonly V1_0_4_1: EngineVersion;
    /**
     * (experimental) Neptune engine version 1.0.5.0.
     *
     * @experimental
     */
    static readonly V1_0_5_0: EngineVersion;
    /**
     * (experimental) Neptune engine version 1.1.0.0.
     *
     * @experimental
     */
    static readonly V1_1_0_0: EngineVersion;
    /**
     * (experimental) Constructor for specifying a custom engine version.
     *
     * @param version the engine version of Neptune.
     * @experimental
     */
    constructor(version: string);
}
/**
 * (experimental) Properties for a new database cluster.
 *
 * @experimental
 */
export interface DatabaseClusterProps {
    /**
     * (experimental) What version of the database to start.
     *
     * @default - The default engine version.
     * @experimental
     */
    readonly engineVersion?: EngineVersion;
    /**
     * (experimental) The port the Neptune cluster will listen on.
     *
     * @default - The default engine port
     * @experimental
     */
    readonly port?: number;
    /**
     * (experimental) How many days to retain the backup.
     *
     * @default - cdk.Duration.days(1)
     * @experimental
     */
    readonly backupRetention?: Duration;
    /**
     * (experimental) A daily time range in 24-hours UTC format in which backups preferably execute.
     *
     * Must be at least 30 minutes long.
     *
     * Example: '01:00-02:00'
     *
     * @default - a 30-minute window selected at random from an 8-hour block of
     * time for each AWS Region. To see the time blocks available, see
     * @experimental
     */
    readonly preferredBackupWindow?: string;
    /**
     * (experimental) The KMS key for storage encryption.
     *
     * @default - default master key.
     * @experimental
     */
    readonly kmsKey?: kms.IKey;
    /**
     * (experimental) Whether to enable storage encryption.
     *
     * @default true
     * @experimental
     */
    readonly storageEncrypted?: boolean;
    /**
     * (experimental) Number of Neptune compute instances.
     *
     * @default 1
     * @experimental
     */
    readonly instances?: number;
    /**
     * (experimental) An optional identifier for the cluster.
     *
     * @default - A name is automatically generated.
     * @experimental
     */
    readonly dbClusterName?: string;
    /**
     * (experimental) Map AWS Identity and Access Management (IAM) accounts to database accounts.
     *
     * @default - `false`
     * @experimental
     */
    readonly iamAuthentication?: boolean;
    /**
     * (experimental) Base identifier for instances.
     *
     * Every replica is named by appending the replica number to this string, 1-based.
     *
     * @default - `dbClusterName` is used with the word "Instance" appended. If `dbClusterName` is not provided, the
     * identifier is automatically generated.
     * @experimental
     */
    readonly instanceIdentifierBase?: string;
    /**
     * (experimental) What type of instance to start for the replicas.
     *
     * @experimental
     */
    readonly instanceType: InstanceType;
    /**
     * (experimental) A list of AWS Identity and Access Management (IAM) role that can be used by the cluster to access other AWS services.
     *
     * @default - No role is attached to the cluster.
     * @experimental
     */
    readonly associatedRoles?: iam.IRole[];
    /**
     * (experimental) Indicates whether the DB cluster should have deletion protection enabled.
     *
     * @default - true if ``removalPolicy`` is RETAIN, false otherwise
     * @experimental
     */
    readonly deletionProtection?: boolean;
    /**
     * (experimental) A weekly time range in which maintenance should preferably execute.
     *
     * Must be at least 30 minutes long.
     *
     * Example: 'tue:04:17-tue:04:47'
     *
     * @default - 30-minute window selected at random from an 8-hour block of time for
     * each AWS Region, occurring on a random day of the week.
     * @experimental
     */
    readonly preferredMaintenanceWindow?: string;
    /**
     * (experimental) Additional parameters to pass to the database engine.
     *
     * @default - No parameter group.
     * @experimental
     */
    readonly clusterParameterGroup?: IClusterParameterGroup;
    /**
     * (experimental) The DB parameter group to associate with the instance.
     *
     * @default no parameter group
     * @experimental
     */
    readonly parameterGroup?: IParameterGroup;
    /**
     * (experimental) Existing subnet group for the cluster.
     *
     * @default - a new subnet group will be created.
     * @experimental
     */
    readonly subnetGroup?: ISubnetGroup;
    /**
     * (experimental) What subnets to run the Neptune instances in.
     *
     * Must be at least 2 subnets in two different AZs.
     *
     * @experimental
     */
    readonly vpc: ec2.IVpc;
    /**
     * (experimental) Where to place the instances within the VPC.
     *
     * @default private subnets
     * @experimental
     */
    readonly vpcSubnets?: ec2.SubnetSelection;
    /**
     * (experimental) Security group.
     *
     * @default a new security group is created.
     * @experimental
     */
    readonly securityGroups?: ec2.ISecurityGroup[];
    /**
     * (experimental) The removal policy to apply when the cluster and its instances are removed or replaced during a stack update, or when the stack is deleted.
     *
     * This
     * removal policy also applies to the implicit security group created for the
     * cluster if one is not supplied as a parameter.
     *
     * @default - Retain cluster.
     * @experimental
     */
    readonly removalPolicy?: RemovalPolicy;
    /**
     * (experimental) If set to true, Neptune will automatically update the engine of the entire cluster to the latest minor version after a stabilization window of 2 to 3 weeks.
     *
     * @default - false
     * @experimental
     */
    readonly autoMinorVersionUpgrade?: boolean;
}
/**
 * (experimental) Create a clustered database with a given number of instances.
 *
 * @experimental
 */
export interface IDatabaseCluster extends IResource, ec2.IConnectable {
    /**
     * (experimental) Identifier of the cluster.
     *
     * @experimental
     */
    readonly clusterIdentifier: string;
    /**
     * (experimental) Resource identifier of the cluster.
     *
     * @experimental
     * @attribute ClusterResourceId
     */
    readonly clusterResourceIdentifier: string;
    /**
     * (experimental) The endpoint to use for read/write operations.
     *
     * @experimental
     * @attribute Endpoint,Port
     */
    readonly clusterEndpoint: Endpoint;
    /**
     * (experimental) Endpoint to use for load-balanced read-only operations.
     *
     * @experimental
     * @attribute ReadEndpoint
     */
    readonly clusterReadEndpoint: Endpoint;
    /**
     * (experimental) Grant the given identity connection access to the database.
     *
     * @experimental
     */
    grantConnect(grantee: iam.IGrantable): iam.Grant;
}
/**
 * (experimental) Properties that describe an existing cluster instance.
 *
 * @experimental
 */
export interface DatabaseClusterAttributes {
    /**
     * (experimental) The database port.
     *
     * @experimental
     */
    readonly port: number;
    /**
     * (experimental) The security group of the database cluster.
     *
     * @experimental
     */
    readonly securityGroup: ec2.ISecurityGroup;
    /**
     * (experimental) Identifier for the cluster.
     *
     * @experimental
     */
    readonly clusterIdentifier: string;
    /**
     * (experimental) Resource Identifier for the cluster.
     *
     * @experimental
     */
    readonly clusterResourceIdentifier: string;
    /**
     * (experimental) Cluster endpoint address.
     *
     * @experimental
     */
    readonly clusterEndpointAddress: string;
    /**
     * (experimental) Reader endpoint address.
     *
     * @experimental
     */
    readonly readerEndpointAddress: string;
}
/**
 * (experimental) A new or imported database cluster.
 *
 * @experimental
 */
export declare abstract class DatabaseClusterBase extends Resource implements IDatabaseCluster {
    /**
     * (experimental) Import an existing DatabaseCluster from properties.
     *
     * @experimental
     */
    static fromDatabaseClusterAttributes(scope: Construct, id: string, attrs: DatabaseClusterAttributes): IDatabaseCluster;
    /**
     * (experimental) Identifier of the cluster.
     *
     * @experimental
     */
    abstract readonly clusterIdentifier: string;
    /**
     * (experimental) Resource identifier of the cluster.
     *
     * @experimental
     */
    abstract readonly clusterResourceIdentifier: string;
    /**
     * (experimental) The endpoint to use for read/write operations.
     *
     * @experimental
     */
    abstract readonly clusterEndpoint: Endpoint;
    /**
     * (experimental) Endpoint to use for load-balanced read-only operations.
     *
     * @experimental
     */
    abstract readonly clusterReadEndpoint: Endpoint;
    /**
     * (experimental) The connections object to implement IConnectable.
     *
     * @experimental
     */
    abstract readonly connections: ec2.Connections;
    /**
     * @experimental
     */
    protected abstract enableIamAuthentication?: boolean;
    /**
     * (experimental) Grant the given identity connection access to the database.
     *
     * @experimental
     */
    grantConnect(grantee: iam.IGrantable): iam.Grant;
}
/**
 * (experimental) Create a clustered database with a given number of instances.
 *
 * @experimental
 * @resource AWS::Neptune::DBCluster
 */
export declare class DatabaseCluster extends DatabaseClusterBase implements IDatabaseCluster {
    /**
     * (experimental) The default number of instances in the Neptune cluster if none are specified.
     *
     * @experimental
     */
    static readonly DEFAULT_NUM_INSTANCES = 1;
    /**
     * (experimental) Identifier of the cluster.
     *
     * @experimental
     */
    readonly clusterIdentifier: string;
    /**
     * (experimental) The endpoint to use for read/write operations.
     *
     * @experimental
     */
    readonly clusterEndpoint: Endpoint;
    /**
     * (experimental) Endpoint to use for load-balanced read-only operations.
     *
     * @experimental
     */
    readonly clusterReadEndpoint: Endpoint;
    /**
     * (experimental) The connections object to implement IConnectable.
     *
     * @experimental
     */
    readonly connections: ec2.Connections;
    /**
     * (experimental) The resource id for the cluster;
     *
     * for example: cluster-ABCD1234EFGH5678IJKL90MNOP. The cluster ID uniquely
     * identifies the cluster and is used in things like IAM authentication policies.
     *
     * @experimental
     * @attribute ClusterResourceId
     */
    readonly clusterResourceIdentifier: string;
    /**
     * (experimental) The VPC where the DB subnet group is created.
     *
     * @experimental
     */
    readonly vpc: ec2.IVpc;
    /**
     * (experimental) The subnets used by the DB subnet group.
     *
     * @experimental
     */
    readonly vpcSubnets: ec2.SubnetSelection;
    /**
     * (experimental) Subnet group used by the DB.
     *
     * @experimental
     */
    readonly subnetGroup: ISubnetGroup;
    /**
     * (experimental) Identifiers of the instance.
     *
     * @experimental
     */
    readonly instanceIdentifiers: string[];
    /**
     * (experimental) Endpoints which address each individual instance.
     *
     * @experimental
     */
    readonly instanceEndpoints: Endpoint[];
    /**
     * @experimental
     */
    protected enableIamAuthentication?: boolean;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: DatabaseClusterProps);
}
