import * as eks from '@aws-cdk/aws-eks';
import * as cdk from '@aws-cdk/core';
/**
 * The construct properties for KubeSphere.
 *
 * @stability stable
 */
export interface KubeSphereProps {
    /**
     * The existing Amazon EKS cluster(if any).
     *
     * @default - create a default new cluster
     * @stability stable
     */
    readonly cluster?: eks.ICluster;
    /**
     * whether to enable the KubeSphere Application Store(openpitrix).
     *
     * @default false
     * @stability stable
     */
    readonly appStore?: boolean;
    /**
     * Options to create the Amazon EKS managed nodegroup.
     *
     * @default - 2x m5.large on-demand instances
     * @stability stable
     */
    readonly nodegroupOptions?: eks.NodegroupOptions;
}
/**
 * The KubeSphere workload.
 *
 * @stability stable
 */
export declare class KubeSphere extends cdk.Construct {
    private readonly nodegroupOptions?;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props?: KubeSphereProps);
    private _createEksCluster;
}
