import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IdentityOidcScopeConfig extends cdktf.TerraformMetaArguments {
    /**
    * The scope's description.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_scope#description IdentityOidcScope#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_scope#id IdentityOidcScope#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the scope. The openid scope name is reserved.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_scope#name IdentityOidcScope#name}
    */
    readonly name: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_scope#namespace IdentityOidcScope#namespace}
    */
    readonly namespace?: string;
    /**
    * The template string for the scope. This may be provided as escaped JSON or base64 encoded JSON.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_scope#template IdentityOidcScope#template}
    */
    readonly template?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_scope vault_identity_oidc_scope}
*/
export declare class IdentityOidcScope extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_identity_oidc_scope";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_scope vault_identity_oidc_scope} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IdentityOidcScopeConfig
    */
    constructor(scope: Construct, id: string, config: IdentityOidcScopeConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _template?;
    get template(): string;
    set template(value: string);
    resetTemplate(): void;
    get templateInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
