"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KmipSecretRole = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_role vault_kmip_secret_role}
*/
class KmipSecretRole extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_role vault_kmip_secret_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KmipSecretRoleConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'vault_kmip_secret_role',
            terraformGeneratorMetadata: {
                providerName: 'vault',
                providerVersion: '3.7.0',
                providerVersionConstraint: '~> 3.7'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._id = config.id;
        this._namespace = config.namespace;
        this._operationActivate = config.operationActivate;
        this._operationAddAttribute = config.operationAddAttribute;
        this._operationAll = config.operationAll;
        this._operationCreate = config.operationCreate;
        this._operationDestroy = config.operationDestroy;
        this._operationDiscoverVersions = config.operationDiscoverVersions;
        this._operationGet = config.operationGet;
        this._operationGetAttributeList = config.operationGetAttributeList;
        this._operationGetAttributes = config.operationGetAttributes;
        this._operationLocate = config.operationLocate;
        this._operationNone = config.operationNone;
        this._operationRegister = config.operationRegister;
        this._operationRekey = config.operationRekey;
        this._operationRevoke = config.operationRevoke;
        this._path = config.path;
        this._role = config.role;
        this._scope = config.scope;
        this._tlsClientKeyBits = config.tlsClientKeyBits;
        this._tlsClientKeyType = config.tlsClientKeyType;
        this._tlsClientTtl = config.tlsClientTtl;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get namespace() {
        return this.getStringAttribute('namespace');
    }
    set namespace(value) {
        this._namespace = value;
    }
    resetNamespace() {
        this._namespace = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get namespaceInput() {
        return this._namespace;
    }
    get operationActivate() {
        return this.getBooleanAttribute('operation_activate');
    }
    set operationActivate(value) {
        this._operationActivate = value;
    }
    resetOperationActivate() {
        this._operationActivate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get operationActivateInput() {
        return this._operationActivate;
    }
    get operationAddAttribute() {
        return this.getBooleanAttribute('operation_add_attribute');
    }
    set operationAddAttribute(value) {
        this._operationAddAttribute = value;
    }
    resetOperationAddAttribute() {
        this._operationAddAttribute = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get operationAddAttributeInput() {
        return this._operationAddAttribute;
    }
    get operationAll() {
        return this.getBooleanAttribute('operation_all');
    }
    set operationAll(value) {
        this._operationAll = value;
    }
    resetOperationAll() {
        this._operationAll = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get operationAllInput() {
        return this._operationAll;
    }
    get operationCreate() {
        return this.getBooleanAttribute('operation_create');
    }
    set operationCreate(value) {
        this._operationCreate = value;
    }
    resetOperationCreate() {
        this._operationCreate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get operationCreateInput() {
        return this._operationCreate;
    }
    get operationDestroy() {
        return this.getBooleanAttribute('operation_destroy');
    }
    set operationDestroy(value) {
        this._operationDestroy = value;
    }
    resetOperationDestroy() {
        this._operationDestroy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get operationDestroyInput() {
        return this._operationDestroy;
    }
    get operationDiscoverVersions() {
        return this.getBooleanAttribute('operation_discover_versions');
    }
    set operationDiscoverVersions(value) {
        this._operationDiscoverVersions = value;
    }
    resetOperationDiscoverVersions() {
        this._operationDiscoverVersions = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get operationDiscoverVersionsInput() {
        return this._operationDiscoverVersions;
    }
    get operationGet() {
        return this.getBooleanAttribute('operation_get');
    }
    set operationGet(value) {
        this._operationGet = value;
    }
    resetOperationGet() {
        this._operationGet = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get operationGetInput() {
        return this._operationGet;
    }
    get operationGetAttributeList() {
        return this.getBooleanAttribute('operation_get_attribute_list');
    }
    set operationGetAttributeList(value) {
        this._operationGetAttributeList = value;
    }
    resetOperationGetAttributeList() {
        this._operationGetAttributeList = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get operationGetAttributeListInput() {
        return this._operationGetAttributeList;
    }
    get operationGetAttributes() {
        return this.getBooleanAttribute('operation_get_attributes');
    }
    set operationGetAttributes(value) {
        this._operationGetAttributes = value;
    }
    resetOperationGetAttributes() {
        this._operationGetAttributes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get operationGetAttributesInput() {
        return this._operationGetAttributes;
    }
    get operationLocate() {
        return this.getBooleanAttribute('operation_locate');
    }
    set operationLocate(value) {
        this._operationLocate = value;
    }
    resetOperationLocate() {
        this._operationLocate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get operationLocateInput() {
        return this._operationLocate;
    }
    get operationNone() {
        return this.getBooleanAttribute('operation_none');
    }
    set operationNone(value) {
        this._operationNone = value;
    }
    resetOperationNone() {
        this._operationNone = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get operationNoneInput() {
        return this._operationNone;
    }
    get operationRegister() {
        return this.getBooleanAttribute('operation_register');
    }
    set operationRegister(value) {
        this._operationRegister = value;
    }
    resetOperationRegister() {
        this._operationRegister = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get operationRegisterInput() {
        return this._operationRegister;
    }
    get operationRekey() {
        return this.getBooleanAttribute('operation_rekey');
    }
    set operationRekey(value) {
        this._operationRekey = value;
    }
    resetOperationRekey() {
        this._operationRekey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get operationRekeyInput() {
        return this._operationRekey;
    }
    get operationRevoke() {
        return this.getBooleanAttribute('operation_revoke');
    }
    set operationRevoke(value) {
        this._operationRevoke = value;
    }
    resetOperationRevoke() {
        this._operationRevoke = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get operationRevokeInput() {
        return this._operationRevoke;
    }
    get path() {
        return this.getStringAttribute('path');
    }
    set path(value) {
        this._path = value;
    }
    // Temporarily expose input value. Use with caution.
    get pathInput() {
        return this._path;
    }
    get role() {
        return this.getStringAttribute('role');
    }
    set role(value) {
        this._role = value;
    }
    // Temporarily expose input value. Use with caution.
    get roleInput() {
        return this._role;
    }
    get scope() {
        return this.getStringAttribute('scope');
    }
    set scope(value) {
        this._scope = value;
    }
    // Temporarily expose input value. Use with caution.
    get scopeInput() {
        return this._scope;
    }
    get tlsClientKeyBits() {
        return this.getNumberAttribute('tls_client_key_bits');
    }
    set tlsClientKeyBits(value) {
        this._tlsClientKeyBits = value;
    }
    resetTlsClientKeyBits() {
        this._tlsClientKeyBits = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tlsClientKeyBitsInput() {
        return this._tlsClientKeyBits;
    }
    get tlsClientKeyType() {
        return this.getStringAttribute('tls_client_key_type');
    }
    set tlsClientKeyType(value) {
        this._tlsClientKeyType = value;
    }
    resetTlsClientKeyType() {
        this._tlsClientKeyType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tlsClientKeyTypeInput() {
        return this._tlsClientKeyType;
    }
    get tlsClientTtl() {
        return this.getNumberAttribute('tls_client_ttl');
    }
    set tlsClientTtl(value) {
        this._tlsClientTtl = value;
    }
    resetTlsClientTtl() {
        this._tlsClientTtl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tlsClientTtlInput() {
        return this._tlsClientTtl;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            id: cdktf.stringToTerraform(this._id),
            namespace: cdktf.stringToTerraform(this._namespace),
            operation_activate: cdktf.booleanToTerraform(this._operationActivate),
            operation_add_attribute: cdktf.booleanToTerraform(this._operationAddAttribute),
            operation_all: cdktf.booleanToTerraform(this._operationAll),
            operation_create: cdktf.booleanToTerraform(this._operationCreate),
            operation_destroy: cdktf.booleanToTerraform(this._operationDestroy),
            operation_discover_versions: cdktf.booleanToTerraform(this._operationDiscoverVersions),
            operation_get: cdktf.booleanToTerraform(this._operationGet),
            operation_get_attribute_list: cdktf.booleanToTerraform(this._operationGetAttributeList),
            operation_get_attributes: cdktf.booleanToTerraform(this._operationGetAttributes),
            operation_locate: cdktf.booleanToTerraform(this._operationLocate),
            operation_none: cdktf.booleanToTerraform(this._operationNone),
            operation_register: cdktf.booleanToTerraform(this._operationRegister),
            operation_rekey: cdktf.booleanToTerraform(this._operationRekey),
            operation_revoke: cdktf.booleanToTerraform(this._operationRevoke),
            path: cdktf.stringToTerraform(this._path),
            role: cdktf.stringToTerraform(this._role),
            scope: cdktf.stringToTerraform(this._scope),
            tls_client_key_bits: cdktf.numberToTerraform(this._tlsClientKeyBits),
            tls_client_key_type: cdktf.stringToTerraform(this._tlsClientKeyType),
            tls_client_ttl: cdktf.numberToTerraform(this._tlsClientTtl),
        };
    }
}
exports.KmipSecretRole = KmipSecretRole;
_a = JSII_RTTI_SYMBOL_1;
KmipSecretRole[_a] = { fqn: "@cdktf/provider-vault.KmipSecretRole", version: "1.0.1" };
// =================
// STATIC PROPERTIES
// =================
KmipSecretRole.tfResourceType = "vault_kmip_secret_role";
//# sourceMappingURL=data:application/json;base64,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