<p align="center"><img src="https://wagtail.github.io/wagtail-live/images/wagtail-live-logo.svg" width="320px" style="max-width: 100%"></p>
<p align="center">
<a href="https://github.com/wagtail/wagtail-live/actions/workflows/test.yml">
    <img src="https://github.com/wagtail/wagtail-live/actions/workflows/test.yml/badge.svg"/>
</a>
<a href="https://codecov.io/gh/wagtail/wagtail-live">
    <img src="https://codecov.io/gh/wagtail/wagtail-live/branch/main/graph/badge.svg?token=C2PNLG02P0"/>
</a>
<a href="https://lgtm.com/projects/g/wagtail/wagtail-live/alerts/">
    <img alt="Total alerts" src="https://img.shields.io/lgtm/alerts/g/wagtail/wagtail-live.svg?logo=lgtm&logoWidth=18"/>
</a>
<a href="https://lgtm.com/projects/g/wagtail/wagtail-live/context:python">
    <img alt="Language grade: Python" src="https://img.shields.io/lgtm/grade/python/g/wagtail/wagtail-live.svg?logo=lgtm&logoWidth=18"/>
</a>
<a href="https://lgtm.com/projects/g/wagtail/wagtail-live/context:javascript">
    <img alt="Language grade: JavaScript" src="https://img.shields.io/lgtm/grade/javascript/g/wagtail/wagtail-live.svg?logo=lgtm&logoWidth=18"/>
</a>
<a href="https://pypi.org/project/wagtail-live/">
    <img src="https://badge.fury.io/py/wagtail-live.svg" alt="Package version">
</a>
<a href="https://opensource.org/licenses/BSD-3-Clause">
    <img src="https://img.shields.io/badge/license-BSD-blue.svg"/>
</a>
</p>

# Wagtail Live

_Wagtail Live_ is a Wagtail CMS package to create live blog pages.

## About

With Wagtail Live:

- Reporters can _instantly publish to a live blog_ by submitting messages via mobile apps.
- Audience can read the posts right away as the live blog page instantly updates. 
- Content editors can edit messages via the Wagtail Admin. The internal format is a normal Wagtail page with streamfield and blocks.
- Create, update, delete operations. 
- Rich text, images, emojis, URLs are converted to embeds.

Slack and a Live blog page:

![Wagtail Live: Slack and live blog page](https://wagtail.github.io/wagtail-live/images/slack-and-live-blog-page.jpg)

Content is also editable via the Wagtail admin:

![Wagtail Live: Page edit view](https://wagtail.github.io/wagtail-live/images/wagtail-admin.jpg)

## Compatibility

Wagtail Live works with:

- Wagtail 2.12 or higher
- Django 2.2 or higher
- Python 3.7 or higher

## Getting started

To get started with Wagtail Live, check out the [Wagtail Live tutorial](https://wagtail.github.io/wagtail-live/getting_started/tutorial/).

## Documentation

All documentation is in the "docs" directory and online at [wagtail.github.io/wagtail-live/](https://wagtail.github.io/wagtail-live/).

## Community

We have a `wagtail-live` channel in [Wagtail's Slack workspace](https://github.com/wagtail/wagtail/wiki/Slack) for discussions about the project.

## Contributing - Testing

To contribute to Wagtail Live or run the test suite, refer to the [development section](https://wagtail.github.io/wagtail-live/development/) of the docs.

## Google Summer of Code

This project is part of Google Summer of Code 2021 by Tidiane Dia. Check out the [GSOC report](https://wagtail.github.io/wagtail-live/gsoc_report/).

## Sponsors

Wagtail-live provides a [publisher based on PieSocket](https://wagtail.github.io/wagtail-live/getting_started/publishers/setup_piesocket/). 

PieSocket offers a 'free-plus' plan to all our users. See the link above for details.
