# Generated by Django 3.2 on 2021-07-07 17:39

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="Channel",
            fields=[
                (
                    "channel_name",
                    models.CharField(
                        help_text="Channel name",
                        max_length=124,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        auto_now_add=True, help_text="Date and time of channel creation"
                    ),
                ),
            ],
            options={
                "ordering": ["-created"],
            },
        ),
        migrations.CreateModel(
            name="Message",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        auto_now_add=True, help_text="Date and time of message creation"
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, help_text="Date and time of last update", null=True
                    ),
                ),
                (
                    "show",
                    models.BooleanField(
                        blank=True,
                        default=True,
                        help_text="Indicates if this message is shown/hidden",
                    ),
                ),
                ("content", models.TextField(help_text="Content of the message")),
                (
                    "channel",
                    models.ForeignKey(
                        help_text="Channel this message was posted to.",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="messages",
                        to="webapp.channel",
                    ),
                ),
            ],
            options={
                "ordering": ["-created"],
            },
        ),
        migrations.CreateModel(
            name="Image",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "image",
                    models.ImageField(help_text="Image of a message", upload_to=""),
                ),
                (
                    "message",
                    models.ForeignKey(
                        help_text="Message this image was posted to.",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="files",
                        to="webapp.message",
                    ),
                ),
            ],
        ),
    ]
