"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const aws_cdk_lib_1 = require("aws-cdk-lib");
const lib_1 = require("../lib");
const iam = require("aws-cdk-lib/aws-iam");
const kms = require("aws-cdk-lib/aws-kms");
const core_1 = require("@aws-solutions-constructs/core");
// Setup
const app = new aws_cdk_lib_1.App();
const stack = new aws_cdk_lib_1.Stack(app, core_1.generateIntegStackName(__filename));
stack.templateOptions.description = 'Integration Test for aws-iot-sqs';
// Definitions
const kmsKey = new kms.Key(stack, 'existing-key', {
    enableKeyRotation: true,
    alias: 'existing-key-alias'
});
const props = {
    encryptionKey: kmsKey,
    iotTopicRuleProps: {
        topicRulePayload: {
            ruleDisabled: false,
            description: "Processing messages from IoT devices or factory machines",
            sql: "SELECT * FROM 'test/topic/#'",
            actions: []
        }
    }
};
const iotToSqsStack = new lib_1.IotToSqs(stack, 'test-iot-sqs-stack', props);
// Grant yourself permissions to use the Customer Managed KMS Key
const policyStatement = new iam.PolicyStatement({
    actions: ["kms:Encrypt", "kms:Decrypt"],
    effect: iam.Effect.ALLOW,
    principals: [new iam.AccountRootPrincipal()],
    resources: ["*"]
});
iotToSqsStack.encryptionKey?.addToResourcePolicy(policyStatement);
// Synth
app.synth();
//# sourceMappingURL=data:application/json;base64,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