# Generated by Django 2.2.24 on 2021-12-05 12:23

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import tendenci.apps.base.fields
import tendenci.apps.chapters.models
import tendenci.libs.tinymce.models


class Migration(migrations.Migration):

    dependencies = [
        ('invoices', '0006_auto_20200902_1545'),
        ('files', '0007_auto_20200902_1545'),
        ('payments', '0003_payment_check_number'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('user_groups', '0005_auto_20210916_1726'),
        ('contenttypes', '0002_remove_content_type_name'),
        ('entities', '0005_entity_show_for_donation'),
        ('chapters', '0008_chapter_county'),
    ]

    operations = [
        migrations.CreateModel(
            name='ChapterMembership',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('allow_anonymous_view', models.BooleanField(default=True, verbose_name='Public can view')),
                ('allow_user_view', models.BooleanField(default=True, verbose_name='Signed in user can view')),
                ('allow_member_view', models.BooleanField(default=True)),
                ('allow_user_edit', models.BooleanField(default=False, verbose_name='Signed in user can change')),
                ('allow_member_edit', models.BooleanField(default=False)),
                ('create_dt', models.DateTimeField(auto_now_add=True, verbose_name='Created On')),
                ('update_dt', models.DateTimeField(auto_now=True, verbose_name='Last Updated')),
                ('creator_username', models.CharField(max_length=150)),
                ('owner_username', models.CharField(max_length=150)),
                ('status', models.BooleanField(default=True, verbose_name='Active')),
                ('status_detail', models.CharField(default='active', max_length=50)),
                ('guid', models.CharField(editable=False, max_length=50)),
                ('member_number', models.CharField(blank=True, max_length=50)),
                ('renewal', models.BooleanField(blank=True, default=False)),
                ('renew_from_id', models.IntegerField(blank=True, null=True)),
                ('certifications', models.CharField(blank=True, default='', max_length=500)),
                ('work_experience', models.TextField(blank=True, default='')),
                ('referral', models.CharField(blank=True, default='', max_length=500)),
                ('expertise', models.CharField(blank=True, default='', max_length=1000)),
                ('occupation', models.CharField(blank=True, default='', max_length=100)),
                ('volunteer_availability', models.BooleanField(default=False)),
                ('social_media_links', models.CharField(blank=True, default='', max_length=500)),
                ('school_type', models.CharField(blank=True, max_length=50)),
                ('school_name', models.CharField(blank=True, default='', max_length=200)),
                ('ud1', models.TextField(blank=True, default='')),
                ('ud2', models.TextField(blank=True, default='')),
                ('ud3', models.TextField(blank=True, default='')),
                ('ud4', models.TextField(blank=True, default='')),
                ('ud5', models.TextField(blank=True, default='')),
                ('ud6', models.TextField(blank=True, default='')),
                ('ud7', models.TextField(blank=True, default='')),
                ('ud8', models.TextField(blank=True, default='')),
                ('ud9', models.TextField(blank=True, default='')),
                ('ud10', models.TextField(blank=True, default='')),
                ('ud11', models.TextField(blank=True, default='')),
                ('ud12', models.TextField(blank=True, default='')),
                ('ud13', models.TextField(blank=True, default='')),
                ('ud14', models.TextField(blank=True, default='')),
                ('ud15', models.TextField(blank=True, default='')),
                ('notes', models.TextField(blank=True)),
                ('admin_notes', models.TextField(blank=True)),
                ('join_dt', models.DateTimeField(blank=True, null=True, verbose_name='Join Date')),
                ('expire_dt', models.DateTimeField(blank=True, null=True, verbose_name='Expire Date')),
                ('renew_dt', models.DateTimeField(blank=True, null=True, verbose_name='Renew Date')),
                ('approved', models.BooleanField(default=False)),
                ('approve_dt', models.DateTimeField(blank=True, null=True, verbose_name='Approved Date')),
                ('rejected', models.BooleanField(default=False)),
                ('rejected_dt', models.DateTimeField(blank=True, null=True, verbose_name='Rejected Date')),
                ('payment_received_dt', models.DateTimeField(null=True)),
            ],
            options={
                'verbose_name': 'Chapter Membership',
                'verbose_name_plural': 'Chapter Memberships',
            },
        ),
        migrations.CreateModel(
            name='ChapterMembershipApp',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('allow_anonymous_view', models.BooleanField(default=True, verbose_name='Public can view')),
                ('allow_user_view', models.BooleanField(default=True, verbose_name='Signed in user can view')),
                ('allow_member_view', models.BooleanField(default=True)),
                ('allow_user_edit', models.BooleanField(default=False, verbose_name='Signed in user can change')),
                ('allow_member_edit', models.BooleanField(default=False)),
                ('create_dt', models.DateTimeField(auto_now_add=True, verbose_name='Created On')),
                ('update_dt', models.DateTimeField(auto_now=True, verbose_name='Last Updated')),
                ('creator_username', models.CharField(max_length=150)),
                ('owner_username', models.CharField(max_length=150)),
                ('status', models.BooleanField(default=True, verbose_name='Active')),
                ('status_detail', models.CharField(default='active', max_length=50)),
                ('guid', models.CharField(editable=False, max_length=50)),
                ('name', models.CharField(max_length=155, verbose_name='Name')),
                ('slug', models.SlugField(max_length=200, unique=True)),
                ('description', models.TextField(blank=True, help_text='Description of this application. Displays at top of application.')),
                ('confirmation_text', tendenci.libs.tinymce.models.HTMLField()),
                ('renewal_description', tendenci.libs.tinymce.models.HTMLField(blank=True, default='')),
                ('renewal_confirmation_text', tendenci.libs.tinymce.models.HTMLField(blank=True, default='')),
                ('notes', models.TextField(blank=True, default='')),
                ('use_captcha', models.BooleanField(default=True, verbose_name='Use Captcha')),
                ('creator', models.ForeignKey(default=None, editable=False, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='chapters_chaptermembershipapp_creator', to=settings.AUTH_USER_MODEL)),
                ('entity', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='chapters_chaptermembershipapp_entity', to='entities.Entity')),
            ],
            options={
                'verbose_name': 'Chapter Membership Application',
            },
        ),
        migrations.CreateModel(
            name='ChapterMembershipAppField',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('position', models.IntegerField(blank=True, default=0, null=True, verbose_name='Position')),
                ('label', models.CharField(max_length=2000, verbose_name='Label')),
                ('field_name', models.CharField(blank=True, default='', max_length=100)),
                ('required', models.BooleanField(blank=True, default=False, verbose_name='Required')),
                ('display', models.BooleanField(blank=True, default=True, verbose_name='Show')),
                ('customizable', models.BooleanField(blank=True, default=False, help_text='Chapter leaders can customize this field.')),
                ('admin_only', models.BooleanField(default=False, verbose_name='Admin Only')),
                ('field_type', models.CharField(blank=True, choices=[('', 'Set to Default'), ('CharField', 'Text'), ('CharField/django.forms.Textarea', 'Paragraph Text'), ('BooleanField', 'Checkbox'), ('ChoiceField', 'Select One (Drop Down)'), ('ChoiceField/django.forms.RadioSelect', 'Select One (Radio Buttons)'), ('MultipleChoiceField', 'Multi select (Drop Down)'), ('MultipleChoiceField/django.forms.CheckboxSelectMultiple', 'Multi select (Checkboxes)'), ('CountrySelectField', 'Countries Drop Down'), ('EmailField', 'Email'), ('FileField', 'File upload'), ('DateField/django.forms.widgets.SelectDateWidget', 'Date'), ('DateTimeField', 'Date/time'), ('section_break', 'Section Break')], max_length=64, verbose_name='Field Type')),
                ('description', models.TextField(blank=True, default='', max_length=200, verbose_name='Description')),
                ('help_text', models.CharField(blank=True, default='', max_length=300, verbose_name='Help Text')),
                ('choices', models.CharField(blank=True, help_text='Comma separated options where applicable', max_length=1000, verbose_name='Choices')),
                ('default_value', models.CharField(blank=True, default='', max_length=200, verbose_name='Default Value')),
                ('css_class', models.CharField(blank=True, default='', max_length=200, verbose_name='CSS Class')),
                ('content_type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType')),
                ('membership_app', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='fields', to='chapters.ChapterMembershipApp')),
            ],
            options={
                'verbose_name': 'Field',
                'verbose_name_plural': 'Fields',
                'ordering': ('position',),
            },
        ),
        migrations.CreateModel(
            name='ChapterMembershipImport',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('header_line', models.CharField(default='', max_length=3000, verbose_name='Header Line')),
                ('override', models.IntegerField(choices=[(0, 'Blank Fields'), (1, 'All Fields (override)')], default=0)),
                ('total_rows', models.IntegerField(default=0)),
                ('num_processed', models.IntegerField(default=0)),
                ('summary', models.CharField(default='', max_length=500, null=True, verbose_name='Summary')),
                ('status', models.CharField(choices=[('not_started', 'Not Started'), ('preprocessing', 'Pre_processing'), ('preprocess_done', 'Pre_process Done'), ('processing', 'Processing'), ('completed', 'Completed')], default='not_started', max_length=50)),
                ('complete_dt', models.DateTimeField(null=True)),
                ('create_dt', models.DateTimeField(auto_now_add=True)),
                ('upload_file', models.FileField(max_length=260, null=True, upload_to=tendenci.apps.chapters.models.get_import_file_path, verbose_name='Upload File')),
                ('recap_file', models.FileField(max_length=260, null=True, upload_to='', verbose_name='Recap File')),
                ('key', models.CharField(default='', max_length=50, verbose_name='Key')),
            ],
        ),
        migrations.CreateModel(
            name='ChapterMembershipType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('allow_anonymous_view', models.BooleanField(default=True, verbose_name='Public can view')),
                ('allow_user_view', models.BooleanField(default=True, verbose_name='Signed in user can view')),
                ('allow_member_view', models.BooleanField(default=True)),
                ('allow_user_edit', models.BooleanField(default=False, verbose_name='Signed in user can change')),
                ('allow_member_edit', models.BooleanField(default=False)),
                ('create_dt', models.DateTimeField(auto_now_add=True, verbose_name='Created On')),
                ('update_dt', models.DateTimeField(auto_now=True, verbose_name='Last Updated')),
                ('creator_username', models.CharField(max_length=150)),
                ('owner_username', models.CharField(max_length=150)),
                ('status', models.BooleanField(default=True, verbose_name='Active')),
                ('status_detail', models.CharField(default='active', max_length=50)),
                ('position', models.IntegerField(blank=True, default=0, null=True, verbose_name='Position')),
                ('guid', models.CharField(max_length=50)),
                ('name', models.CharField(max_length=255, unique=True, verbose_name='Name')),
                ('description', models.CharField(max_length=500, verbose_name='Description')),
                ('price', models.DecimalField(blank=True, decimal_places=2, default=0, help_text='Set 0 for free membership.', max_digits=15, verbose_name='Price')),
                ('renewal_price', models.DecimalField(blank=True, decimal_places=2, default=0, help_text='Set 0 for free membership.', max_digits=15, null=True, verbose_name='Renewal Price')),
                ('require_approval', models.BooleanField(default=True, verbose_name='Require Approval')),
                ('require_payment_approval', models.BooleanField(default=True, help_text='If checked, auto-approved memberships will require a successful online payment to be auto-approved.', verbose_name='Auto-approval requires payment')),
                ('allow_renewal', models.BooleanField(default=True, help_text='If not selected, then this membership type cannot be renewed.', verbose_name='Allow Renewal')),
                ('renewal', models.BooleanField(default=False, help_text='Reserve this membership type for renewals only, not available to new members.', verbose_name='Renewal Only')),
                ('renewal_require_approval', models.BooleanField(default=True, verbose_name='Renewal Requires Approval')),
                ('admin_only', models.BooleanField(default=False, verbose_name='Admin Only')),
                ('never_expires', models.BooleanField(default=False, help_text='If selected, skip the Renewal Options.', verbose_name='Never Expires')),
                ('period', models.IntegerField(default=0, verbose_name='Period')),
                ('period_unit', models.CharField(choices=[('days', 'Days'), ('months', 'Months'), ('years', 'Years')], max_length=10)),
                ('period_type', models.CharField(choices=[('fixed', 'Fixed'), ('rolling', 'Rolling')], default='rolling', max_length=10, verbose_name='Period Type')),
                ('rolling_option', models.CharField(max_length=50, verbose_name='Expires On')),
                ('rolling_option1_day', models.IntegerField(default=0, verbose_name='Expiration Day')),
                ('rolling_renew_option', models.CharField(max_length=50, verbose_name='Renewal Expires On')),
                ('rolling_renew_option1_day', models.IntegerField(default=0)),
                ('rolling_renew_option2_day', models.IntegerField(default=0)),
                ('fixed_option', models.CharField(max_length=50, verbose_name='Expires On')),
                ('fixed_option1_day', models.IntegerField(default=0)),
                ('fixed_option1_month', models.IntegerField(default=0)),
                ('fixed_option1_year', models.IntegerField(default=0)),
                ('fixed_option2_day', models.IntegerField(default=0)),
                ('fixed_option2_month', models.IntegerField(default=0)),
                ('fixed_option2_can_rollover', models.BooleanField(default=False, verbose_name='Allow Rollover')),
                ('fixed_option2_rollover_days', models.IntegerField(default=0, help_text='Membership signups after this date covers the following calendar year as well.')),
                ('renewal_period_start', models.IntegerField(default=30, help_text='How long (in days) before the memberships expires can the member renew their membership.', verbose_name='Renewal Period Start')),
                ('renewal_period_end', models.IntegerField(default=30, help_text='How long (in days) after the memberships expires can the member renew their membership.', verbose_name='Renewal Period End')),
                ('expiration_grace_period', models.IntegerField(default=0, help_text='The number of days (maximum 100) after the membership expires their membership is still active.', verbose_name='Expiration Grace Period')),
                ('creator', models.ForeignKey(default=None, editable=False, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='chapters_chaptermembershiptype_creator', to=settings.AUTH_USER_MODEL)),
                ('entity', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='chapters_chaptermembershiptype_entity', to='entities.Entity')),
                ('owner', models.ForeignKey(default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='chapters_chaptermembershiptype_owner', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Chapter Membership Type',
            },
        ),
        migrations.CreateModel(
            name='Notice',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('guid', models.CharField(editable=False, max_length=50)),
                ('notice_name', models.CharField(max_length=250, verbose_name='Name')),
                ('num_days', models.IntegerField(default=0)),
                ('notice_time', models.CharField(choices=[('before', 'Before'), ('after', 'After'), ('attimeof', 'At Time Of')], max_length=20, verbose_name='Notice Time')),
                ('notice_type', models.CharField(choices=[('apply', 'Apply Date'), ('renewal', 'Renewal Date'), ('expiration', 'Expiration Date'), ('approve', 'Approval Date'), ('reject', 'Reject Date'), ('approve_renewal', 'Renewal Approval Date'), ('reject_renewal', 'Renewal Reject Date')], max_length=20, verbose_name='For Notice Type')),
                ('subject', models.CharField(max_length=255)),
                ('content_type', models.CharField(choices=[('html', 'HTML')], default='html', max_length=10, verbose_name='Content Type')),
                ('sender', models.EmailField(blank=True, max_length=255, null=True)),
                ('sender_display', models.CharField(blank=True, max_length=255, null=True)),
                ('email_content', tendenci.libs.tinymce.models.HTMLField(verbose_name='Email Content')),
                ('create_dt', models.DateTimeField(auto_now_add=True)),
                ('update_dt', models.DateTimeField(auto_now=True)),
                ('creator_username', models.CharField(max_length=150, null=True)),
                ('owner_username', models.CharField(max_length=150, null=True)),
                ('status_detail', models.CharField(choices=[('active', 'Active'), ('admin_hold', 'Admin Hold')], default='active', max_length=50)),
                ('status', models.BooleanField(default=True)),
            ],
        ),
        migrations.AddField(
            model_name='chapter',
            name='newsletter_group',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='ng_chapters', to='user_groups.Group'),
        ),
        migrations.CreateModel(
            name='NoticeLog',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('guid', models.CharField(editable=False, max_length=50)),
                ('notice_sent_dt', models.DateTimeField(auto_now_add=True)),
                ('num_sent', models.IntegerField()),
                ('notice', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='logs', to='chapters.Notice')),
            ],
            options={
                'verbose_name': 'Notice Log',
                'verbose_name_plural': 'Notice Logs',
            },
        ),
        migrations.CreateModel(
            name='NoticeDefaultLogRecord',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('guid', models.CharField(editable=False, max_length=50)),
                ('emails_sent', models.CharField(default='', max_length=500)),
                ('create_dt', models.DateTimeField(auto_now_add=True)),
                ('chapter_membership', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='default_log_records', to='chapters.ChapterMembership')),
                ('notice_log', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='default_log_records', to='chapters.NoticeLog')),
            ],
            options={
                'verbose_name': 'Notice Log Record',
                'verbose_name_plural': 'Notice Log Records',
            },
        ),
        migrations.AddField(
            model_name='notice',
            name='chapter',
            field=models.ForeignKey(blank=True, help_text="Note that if you don't select a chapter, the notice will go out to all chapter members.", null=True, on_delete=django.db.models.deletion.CASCADE, to='chapters.Chapter'),
        ),
        migrations.AddField(
            model_name='notice',
            name='creator',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='chapter_membership_creator_notices', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='notice',
            name='membership_type',
            field=models.ForeignKey(blank=True, help_text="Note that if you don't select a membership type, the notice will go out to all members.", null=True, on_delete=django.db.models.deletion.CASCADE, to='chapters.ChapterMembershipType'),
        ),
        migrations.AddField(
            model_name='notice',
            name='owner',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='chapter_membership_owner_notices', to=settings.AUTH_USER_MODEL),
        ),
        migrations.CreateModel(
            name='ChapterMembershipImportData',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('row_data', tendenci.apps.base.fields.DictField(verbose_name='Row Data')),
                ('row_num', models.IntegerField(verbose_name='Row #')),
                ('action_taken', models.CharField(max_length=20, null=True, verbose_name='Action Taken')),
                ('error', models.CharField(default='', max_length=500, verbose_name='Error')),
                ('mimport', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='import_data', to='chapters.ChapterMembershipImport')),
            ],
        ),
        migrations.AddField(
            model_name='chaptermembershipimport',
            name='chapter',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='chapters.Chapter'),
        ),
        migrations.AddField(
            model_name='chaptermembershipimport',
            name='creator',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='chaptermembershipapp',
            name='membership_types',
            field=models.ManyToManyField(to='chapters.ChapterMembershipType', verbose_name='Chapter Membership Types'),
        ),
        migrations.AddField(
            model_name='chaptermembershipapp',
            name='owner',
            field=models.ForeignKey(default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='chapters_chaptermembershipapp_owner', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='chaptermembershipapp',
            name='payment_methods',
            field=models.ManyToManyField(to='payments.PaymentMethod', verbose_name='Payment Methods'),
        ),
        migrations.AddField(
            model_name='chaptermembership',
            name='app',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='chapters.ChapterMembershipApp'),
        ),
        migrations.AddField(
            model_name='chaptermembership',
            name='approved_user',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='chaptermembership_approved_set', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='chaptermembership',
            name='chapter',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='chapters.Chapter'),
        ),
        migrations.AddField(
            model_name='chaptermembership',
            name='creator',
            field=models.ForeignKey(default=None, editable=False, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='chapters_chaptermembership_creator', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='chaptermembership',
            name='entity',
            field=models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='chapters_chaptermembership_entity', to='entities.Entity'),
        ),
        migrations.AddField(
            model_name='chaptermembership',
            name='invoice',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='invoices.Invoice'),
        ),
        migrations.AddField(
            model_name='chaptermembership',
            name='membership_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='chapters.ChapterMembershipType'),
        ),
        migrations.AddField(
            model_name='chaptermembership',
            name='owner',
            field=models.ForeignKey(default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='chapters_chaptermembership_owner', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='chaptermembership',
            name='payment_method',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='payments.PaymentMethod'),
        ),
        migrations.AddField(
            model_name='chaptermembership',
            name='rejected_user',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='chaptermembership_rejected_set', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='chaptermembership',
            name='user',
            field=models.ForeignKey(editable=False, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.CreateModel(
            name='CustomizedAppField',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('help_text', models.CharField(blank=True, default='', max_length=300, verbose_name='Help Text')),
                ('choices', models.CharField(blank=True, help_text='Comma separated options where applicable', max_length=1000, verbose_name='Choices')),
                ('default_value', models.CharField(blank=True, default='', max_length=200, verbose_name='Default Value')),
                ('app_field', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='customized_fields', to='chapters.ChapterMembershipAppField')),
                ('chapter', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='chapters.Chapter')),
            ],
            options={
                'unique_together': {('app_field', 'chapter')},
            },
        ),
    ]
