# Generated by Django 3.2.8 on 2023-10-04 11:14

import django.core.validators
import django.db.models.deletion
import django_countries.fields
from django.conf import settings
from django.db import migrations, models

import ob_dj_store.utils.model


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("otp", "0004_onetruepairing_meta"),
        ("stores", "0088_alter_paymentmethod_payment_provider"),
    ]

    operations = [
        migrations.CreateModel(
            name="Discount",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "discount_rate",
                    models.DecimalField(
                        decimal_places=2,
                        max_digits=3,
                        validators=[
                            django.core.validators.MaxValueValidator(limit_value=1)
                        ],
                    ),
                ),
                ("is_active", models.BooleanField(default=True)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name="Partner",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(max_length=255, verbose_name="Partner's Name"),
                ),
                (
                    "promotion_code",
                    models.PositiveBigIntegerField(
                        blank=True, null=True, verbose_name="Promotion code"
                    ),
                ),
                (
                    "auth_method",
                    models.CharField(
                        choices=[
                            ("OTP", "One True Pairing"),
                            ("CODE", "Promotion code"),
                        ],
                        max_length=255,
                        verbose_name="Authentication method",
                    ),
                ),
                (
                    "country",
                    django_countries.fields.CountryField(
                        help_text="Partner's country.", max_length=2
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "discount",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="partners",
                        to="stores.discount",
                    ),
                ),
            ],
            bases=(ob_dj_store.utils.model.DjangoModelCleanMixin, models.Model),
        ),
        migrations.CreateModel(
            name="PartnerOTPAuth",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "email",
                    models.EmailField(max_length=254, verbose_name="Partner's Email"),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "otp",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="otp.onetruepairing",
                    ),
                ),
                (
                    "partner",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="otp_auths",
                        to="stores.partner",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="PartnerEmailDomain",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("email_domain", models.CharField(max_length=255)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "partner",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="domains",
                        to="stores.partner",
                    ),
                ),
            ],
            bases=(ob_dj_store.utils.model.DjangoModelCleanMixin, models.Model),
        ),
        migrations.CreateModel(
            name="PartnerAuthInfo",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "email",
                    models.EmailField(max_length=254, verbose_name="Partner's Email"),
                ),
                ("authentication_details", models.JSONField(blank=True, null=True)),
                ("authentication_expires", models.DateTimeField()),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                (
                    "updated_at",
                    models.DateTimeField(
                        auto_now=True, verbose_name="Last Authentifacation"
                    ),
                ),
                (
                    "partner",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="stores.partner"
                    ),
                ),
                (
                    "user",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
    ]
