#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""The pdbqt for the receptors with PDB id: : 6lu7, x0131.
"""
r_6lu7 = """
ATOM      1  N   SER U   1     -32.073   9.085  33.695 -0.32  2.00    -0.064 N
ATOM      2  CA  SER U   1     -32.156   8.073  34.741  0.30  2.00     0.297 C
ATOM      3  C   SER U   1     -30.857   8.000  35.536  0.55  1.70     0.250 C
ATOM      4  O   SER U   1     -30.047   8.926  35.507 -0.55  1.40    -0.271 OA
ATOM      5  CB  SER U   1     -32.483   6.704  34.140  0.13  2.00     0.206 C
ATOM      6  OG  SER U   1     -31.312   6.067  33.660 -0.49  1.40    -0.398 OA
ATOM      7  H   SER U   1     -31.994   8.646  32.798  0.33  0.00     0.275 HD
ATOM      8  H2  SER U   1     -32.896   9.657  33.705  0.33  0.00     0.275 HD
ATOM      9  H3  SER U   1     -31.271   9.667  33.843  0.33  0.00     0.275 HD
ATOM     10  HG  SER U   1     -30.841   5.620  34.419  0.49  1.00     0.209 HD
ATOM     11  N   GLY U   2     -30.665   6.892  36.240 -0.40  1.50    -0.350 N
ATOM     12  CA  GLY U   2     -29.510   6.712  37.092  0.15  2.00     0.225 C
ATOM     13  C   GLY U   2     -29.828   6.998  38.551  0.55  1.70     0.236 C
ATOM     14  O   GLY U   2     -30.810   7.663  38.892 -0.55  1.40    -0.272 OA
ATOM     15  H   GLY U   2     -31.413   6.173  36.124  0.40  1.00     0.163 HD
ATOM     16  N   PHE U   3     -28.974   6.479  39.430 -0.40  1.50    -0.346 N
ATOM     17  CA  PHE U   3     -29.155   6.661  40.866  0.18  2.00     0.180 C
ATOM     18  C   PHE U   3     -27.790   6.744  41.527  0.55  1.70     0.241 C
ATOM     19  O   PHE U   3     -26.981   5.820  41.399 -0.55  1.40    -0.271 OA
ATOM     20  CB  PHE U   3     -29.978   5.522  41.468  0.03  2.00     0.073 C
ATOM     21  CG  PHE U   3     -30.635   5.875  42.770 -0.12  1.70    -0.056 A
ATOM     22  CD1 PHE U   3     -31.642   6.824  42.816  0.01  1.70     0.007 A
ATOM     23  CD2 PHE U   3     -30.247   5.261  43.949  0.01  1.70     0.007 A
ATOM     24  CE1 PHE U   3     -32.251   7.155  44.012  0.00  1.70     0.001 A
ATOM     25  CE2 PHE U   3     -30.851   5.586  45.148  0.00  1.70     0.001 A
ATOM     26  CZ  PHE U   3     -31.854   6.534  45.179  0.00  1.70     0.000 A
ATOM     27  H   PHE U   3     -28.188   5.947  39.014  0.40  1.00     0.163 HD
ATOM     28  N   ARG U   4     -27.541   7.844  42.233 -0.40  1.50    -0.346 N
ATOM     29  CA  ARG U   4     -26.277   8.066  42.915  0.18  2.00     0.176 C
ATOM     30  C   ARG U   4     -26.545   8.642  44.296  0.55  1.70     0.241 C
ATOM     31  O   ARG U   4     -27.552   9.320  44.517 -0.55  1.40    -0.271 OA
ATOM     32  CB  ARG U   4     -25.367   9.020  42.127  0.00  2.00     0.036 C
ATOM     33  CG  ARG U   4     -24.669   8.388  40.936 -0.01  2.00     0.023 C
ATOM     34  CD  ARG U   4     -23.342   7.771  41.340  0.07  2.00     0.138 C
ATOM     35  NE  ARG U   4     -22.460   7.579  40.193 -0.35  1.50    -0.227 N
ATOM     36  CZ  ARG U   4     -21.235   7.068  40.270  0.35  1.70     0.665 C
ATOM     37  NH1 ARG U   4     -20.744   6.693  41.443 -0.70  1.50    -0.235 N
ATOM     38  NH2 ARG U   4     -20.502   6.930  39.173 -0.70  1.50    -0.235 N
ATOM     39  H   ARG U   4     -28.330   8.529  42.253  0.40  1.00     0.163 HD
ATOM     40  HE  ARG U   4     -22.801   7.851  39.286  0.45  1.00     0.177 HD
ATOM     41 1HH1 ARG U   4     -21.283   6.766  42.277  0.40  1.00     0.174 HD
ATOM     42 2HH1 ARG U   4     -19.806   6.324  41.494  0.40  1.00     0.174 HD
ATOM     43 1HH2 ARG U   4     -20.886   7.195  38.285  0.40  1.00     0.174 HD
ATOM     44 2HH2 ARG U   4     -19.576   6.564  39.228  0.40  1.00     0.174 HD
ATOM     45  N   LYS U   5     -25.636   8.362  45.227 -0.40  1.50    -0.346 N
ATOM     46  CA  LYS U   5     -25.667   9.020  46.528  0.18  2.00     0.176 C
ATOM     47  C   LYS U   5     -25.399  10.504  46.317  0.55  1.70     0.241 C
ATOM     48  O   LYS U   5     -24.261  10.908  46.053 -0.55  1.40    -0.271 OA
ATOM     49  CB  LYS U   5     -24.643   8.396  47.471 -0.00  2.00     0.035 C
ATOM     50  CG  LYS U   5     -25.062   8.413  48.934 -0.03  2.00     0.004 C
ATOM     51  CD  LYS U   5     -24.326   7.353  49.740 -0.01  2.00     0.027 C
ATOM     52  CE  LYS U   5     -24.965   5.984  49.571  0.15  2.00     0.229 C
ATOM     53  NZ  LYS U   5     -24.162   4.914  50.226 -0.32  2.00    -0.079 N
ATOM     54  H   LYS U   5     -24.929   7.659  44.954  0.40  1.00     0.163 HD
ATOM     55  HZ1 LYS U   5     -24.570   4.024  50.025  0.33  0.00     0.274 HD
ATOM     56  HZ2 LYS U   5     -23.226   4.941  49.875  0.33  0.00     0.274 HD
ATOM     57  HZ3 LYS U   5     -24.154   5.064  51.214  0.33  0.00     0.274 HD
ATOM     58  N   MET U   6     -26.446  11.316  46.414 -0.40  1.50    -0.346 N
ATOM     59  CA  MET U   6     -26.400  12.716  46.023  0.18  2.00     0.177 C
ATOM     60  C   MET U   6     -26.467  13.607  47.255  0.55  1.70     0.241 C
ATOM     61  O   MET U   6     -27.368  13.459  48.088 -0.55  1.40    -0.271 OA
ATOM     62  CB  MET U   6     -27.548  13.047  45.068  0.01  2.00     0.045 C
ATOM     63  CG  MET U   6     -27.370  14.341  44.297  0.03  2.00     0.076 C
ATOM     64  SD  MET U   6     -28.586  14.521  42.977 -0.53  1.85    -0.173 SA
ATOM     65  CE  MET U   6     -28.245  13.061  41.999  0.01  2.00     0.089 C
ATOM     66  H   MET U   6     -27.308  10.859  46.797  0.40  1.00     0.163 HD
ATOM     67  N   ALA U   7     -25.516  14.525  47.363 -0.40  1.50    -0.346 N
ATOM     68  CA  ALA U   7     -25.496  15.526  48.417  0.17  2.00     0.172 C
ATOM     69  C   ALA U   7     -26.118  16.824  47.917  0.55  1.70     0.240 C
ATOM     70  O   ALA U   7     -26.143  17.108  46.717 -0.55  1.40    -0.271 OA
ATOM     71  CB  ALA U   7     -24.065  15.781  48.898 -0.02  2.00     0.042 C
ATOM     72  H   ALA U   7     -24.777  14.466  46.620  0.40  1.00     0.163 HD
ATOM     73  N   PHE U   8     -26.629  17.612  48.859 -0.40  1.50    -0.346 N
ATOM     74  CA  PHE U   8     -27.182  18.909  48.513  0.18  2.00     0.181 C
ATOM     75  C   PHE U   8     -26.060  19.874  48.132  0.55  1.70     0.243 C
ATOM     76  O   PHE U   8     -24.929  19.740  48.607 -0.55  1.40    -0.271 OA
ATOM     77  CB  PHE U   8     -27.983  19.479  49.680  0.03  2.00     0.073 C
ATOM     78  CG  PHE U   8     -29.339  18.855  49.850 -0.12  1.70    -0.056 A
ATOM     79  CD1 PHE U   8     -30.396  19.234  49.041  0.01  1.70     0.007 A
ATOM     80  CD2 PHE U   8     -29.557  17.893  50.822  0.01  1.70     0.007 A
ATOM     81  CE1 PHE U   8     -31.646  18.663  49.196  0.00  1.70     0.001 A
ATOM     82  CE2 PHE U   8     -30.804  17.319  50.982  0.00  1.70     0.001 A
ATOM     83  CZ  PHE U   8     -31.849  17.705  50.168  0.00  1.70     0.000 A
ATOM     84  H   PHE U   8     -26.597  17.232  49.817  0.40  1.00     0.163 HD
ATOM     85  N   PRO U   9     -26.342  20.843  47.261 -0.56  1.50    -0.337 N
ATOM     86  CA  PRO U   9     -25.340  21.872  46.956  0.18  2.00     0.179 C
ATOM     87  C   PRO U   9     -24.923  22.612  48.219  0.55  1.70     0.241 C
ATOM     88  O   PRO U   9     -25.761  23.012  49.030 -0.55  1.40    -0.271 OA
ATOM     89  CB  PRO U   9     -26.066  22.790  45.966  0.00  2.00     0.037 C
ATOM     90  CG  PRO U   9     -27.105  21.918  45.343 -0.01  2.00     0.022 C
ATOM     91  CD  PRO U   9     -27.551  20.986  46.433  0.06  2.00     0.127 C
ATOM     92  N   SER U  10     -23.613  22.787  48.383 -0.40  1.50    -0.344 N
ATOM     93  CA  SER U  10     -23.037  23.278  49.626  0.20  2.00     0.200 C
ATOM     94  C   SER U  10     -22.730  24.770  49.600  0.55  1.70     0.242 C
ATOM     95  O   SER U  10     -22.106  25.275  50.538 -0.55  1.40    -0.271 OA
ATOM     96  CB  SER U  10     -21.762  22.498  49.953  0.12  2.00     0.199 C
ATOM     97  OG  SER U  10     -20.780  22.691  48.950 -0.49  1.40    -0.398 OA
ATOM     98  H   SER U  10     -23.039  22.542  47.544  0.40  1.00     0.163 HD
ATOM     99  HG  SER U  10     -20.526  23.657  48.914  0.49  1.00     0.209 HD
ATOM    100  N   GLY U  11     -23.156  25.485  48.556 -0.40  1.50    -0.350 N
ATOM    101  CA  GLY U  11     -22.802  26.892  48.440  0.15  2.00     0.225 C
ATOM    102  C   GLY U  11     -23.316  27.735  49.592  0.55  1.70     0.236 C
ATOM    103  O   GLY U  11     -22.598  28.590  50.117 -0.55  1.40    -0.272 OA
ATOM    104  H   GLY U  11     -23.730  24.972  47.875  0.40  1.00     0.163 HD
ATOM    105  N   LYS U  12     -24.564  27.505  50.005 -0.40  1.50    -0.346 N
ATOM    106  CA  LYS U  12     -25.146  28.293  51.086  0.18  2.00     0.176 C
ATOM    107  C   LYS U  12     -24.552  27.946  52.445  0.55  1.70     0.241 C
ATOM    108  O   LYS U  12     -24.652  28.754  53.375 -0.55  1.40    -0.271 OA
ATOM    109  CB  LYS U  12     -26.663  28.106  51.107 -0.00  2.00     0.035 C
ATOM    110  CG  LYS U  12     -27.354  28.626  49.856 -0.03  2.00     0.004 C
ATOM    111  CD  LYS U  12     -28.638  27.867  49.562 -0.01  2.00     0.027 C
ATOM    112  CE  LYS U  12     -29.857  28.610  50.085  0.15  2.00     0.229 C
ATOM    113  NZ  LYS U  12     -30.058  28.392  51.544 -0.32  2.00    -0.079 N
ATOM    114  H   LYS U  12     -25.059  26.749  49.510  0.40  1.00     0.163 HD
ATOM    115  HZ1 LYS U  12     -30.127  29.276  52.005  0.33  0.00     0.274 HD
ATOM    116  HZ2 LYS U  12     -30.900  27.872  51.689  0.33  0.00     0.274 HD
ATOM    117  HZ3 LYS U  12     -29.282  27.882  51.913  0.33  0.00     0.274 HD
ATOM    118  N   VAL U  13     -23.940  26.773  52.582 -0.40  1.50    -0.346 N
ATOM    119  CA  VAL U  13     -23.264  26.421  53.825  0.18  2.00     0.180 C
ATOM    120  C   VAL U  13     -21.793  26.832  53.796  0.55  1.70     0.241 C
ATOM    121  O   VAL U  13     -21.223  27.157  54.843 -0.55  1.40    -0.271 OA
ATOM    122  CB  VAL U  13     -23.418  24.915  54.103  0.01  2.00     0.009 C
ATOM    123  CG1 VAL U  13     -22.767  24.538  55.426 -0.04  2.00     0.012 C
ATOM    124  CG2 VAL U  13     -24.889  24.527  54.104 -0.04  2.00     0.012 C
ATOM    125  H   VAL U  13     -23.985  26.154  51.756  0.40  1.00     0.163 HD
ATOM    126  N   GLU U  14     -21.172  26.840  52.613 -0.40  1.50    -0.346 N
ATOM    127  CA  GLU U  14     -19.769  27.233  52.505  0.18  2.00     0.177 C
ATOM    128  C   GLU U  14     -19.544  28.649  53.024  0.55  1.70     0.240 C
ATOM    129  O   GLU U  14     -18.514  28.932  53.648 -0.55  1.40    -0.271 OA
ATOM    130  CB  GLU U  14     -19.305  27.122  51.052  0.01  2.00     0.045 C
ATOM    131  CG  GLU U  14     -18.957  25.712  50.607  0.07  2.00     0.116 C
ATOM    132  CD  GLU U  14     -18.897  25.579  49.098  0.10  1.70     0.172 C
ATOM    133  OE1 GLU U  14     -19.869  25.067  48.504 -0.55  1.40    -0.648 OA
ATOM    134  OE2 GLU U  14     -17.877  25.989  48.505 -0.55  1.40    -0.648 OA
ATOM    135  H   GLU U  14     -21.754  26.553  51.811  0.40  1.00     0.163 HD
ATOM    136  N   GLY U  15     -20.495  29.549  52.781 -0.40  1.50    -0.351 N
ATOM    137  CA  GLY U  15     -20.362  30.928  53.211  0.15  2.00     0.225 C
ATOM    138  C   GLY U  15     -20.501  31.162  54.700  0.55  1.70     0.236 C
ATOM    139  O   GLY U  15     -20.387  32.309  55.140 -0.55  1.40    -0.272 OA
ATOM    140  H   GLY U  15     -21.320  29.181  52.268  0.40  1.00     0.163 HD
ATOM    141  N   CYS U  16     -20.739  30.114  55.488 -0.40  1.50    -0.346 N
ATOM    142  CA  CYS U  16     -20.917  30.244  56.927  0.19  2.00     0.185 C
ATOM    143  C   CYS U  16     -19.815  29.573  57.732  0.55  1.70     0.241 C
ATOM    144  O   CYS U  16     -19.841  29.644  58.965 -0.55  1.40    -0.271 OA
ATOM    145  CB  CYS U  16     -22.275  29.667  57.345  0.05  2.00     0.105 C
ATOM    146  SG  CYS U  16     -23.654  30.190  56.312 -0.29  1.85    -0.180 SA
ATOM    147  H   CYS U  16     -20.786  29.200  54.986  0.40  1.00     0.163 HD
ATOM    148  HG  CYS U  16     -23.730  29.583  55.520  0.29  1.00     0.101 HD
ATOM    149  N   MET U  17     -18.852  28.928  57.079 -0.40  1.50    -0.346 N
ATOM    150  CA  MET U  17     -17.799  28.220  57.794  0.18  2.00     0.177 C
ATOM    151  C   MET U  17     -16.675  29.177  58.171  0.55  1.70     0.241 C
ATOM    152  O   MET U  17     -16.188  29.942  57.332 -0.55  1.40    -0.271 OA
ATOM    153  CB  MET U  17     -17.256  27.071  56.946  0.01  2.00     0.045 C
ATOM    154  CG  MET U  17     -18.289  26.004  56.621  0.03  2.00     0.076 C
ATOM    155  SD  MET U  17     -19.267  25.517  58.058 -0.53  1.85    -0.173 SA
ATOM    156  CE  MET U  17     -17.998  24.861  59.141  0.01  2.00     0.089 C
ATOM    157  H   MET U  17     -18.917  28.973  56.047  0.40  1.00     0.163 HD
ATOM    158  N   VAL U  18     -16.269  29.134  59.440 -0.40  1.50    -0.346 N
ATOM    159  CA  VAL U  18     -15.179  29.950  59.953  0.18  2.00     0.180 C
ATOM    160  C   VAL U  18     -14.221  29.049  60.721  0.55  1.70     0.241 C
ATOM    161  O   VAL U  18     -14.511  27.885  60.999 -0.55  1.40    -0.271 OA
ATOM    162  CB  VAL U  18     -15.676  31.100  60.854  0.01  2.00     0.009 C
ATOM    163  CG1 VAL U  18     -16.514  32.083  60.052 -0.04  2.00     0.012 C
ATOM    164  CG2 VAL U  18     -16.465  30.548  62.031 -0.04  2.00     0.012 C
ATOM    165  H   VAL U  18     -16.806  28.459  60.036  0.40  1.00     0.163 HD
ATOM    166  N   GLN U  19     -13.064  29.608  61.058 -0.40  1.50    -0.346 N
ATOM    167  CA  GLN U  19     -12.057  28.923  61.855  0.18  2.00     0.177 C
ATOM    168  C   GLN U  19     -12.040  29.523  63.253  0.55  1.70     0.241 C
ATOM    169  O   GLN U  19     -11.925  30.743  63.408 -0.55  1.40    -0.271 OA
ATOM    170  CB  GLN U  19     -10.673  29.035  61.211  0.01  2.00     0.044 C
ATOM    171  CG  GLN U  19      -9.561  28.393  62.024  0.06  2.00     0.105 C
ATOM    172  CD  GLN U  19      -8.189  28.636  61.429  0.55  1.70     0.215 C
ATOM    173  H   GLN U  19     -12.939  30.585  60.700  0.40  1.00     0.163 HD
ATOM    174  OE1 GLN U  19      -7.581  27.734  60.852 -0.55  1.40    -0.274 OA
ATOM    175  NE2 GLN U  19      -7.693  29.860  61.566 -0.78  1.50    -0.370 N
ATOM    176 1HE2 GLN U  19      -6.771  30.095  61.205  0.39  1.00     0.159 HD
ATOM    177 2HE2 GLN U  19      -8.253  30.567  62.041  0.39  1.00     0.159 HD
ATOM    178  N   VAL U  20     -12.162  28.667  64.263 -0.40  1.50    -0.346 N
ATOM    179  CA  VAL U  20     -12.179  29.083  65.661  0.18  2.00     0.180 C
ATOM    180  C   VAL U  20     -10.928  28.533  66.329  0.55  1.70     0.241 C
ATOM    181  O   VAL U  20     -10.678  27.322  66.294 -0.55  1.40    -0.271 OA
ATOM    182  CB  VAL U  20     -13.447  28.601  66.381  0.01  2.00     0.009 C
ATOM    183  CG1 VAL U  20     -13.469  29.112  67.814 -0.04  2.00     0.012 C
ATOM    184  CG2 VAL U  20     -14.688  29.051  65.627 -0.04  2.00     0.012 C
ATOM    185  H   VAL U  20     -12.245  27.665  63.968  0.40  1.00     0.163 HD
ATOM    186  N   THR U  21     -10.144  29.419  66.937 -0.40  1.50    -0.344 N
ATOM    187  CA  THR U  21      -8.913  29.045  67.619  0.20  2.00     0.205 C
ATOM    188  C   THR U  21      -8.969  29.519  69.064  0.55  1.70     0.243 C
ATOM    189  O   THR U  21      -9.258  30.691  69.327 -0.55  1.40    -0.271 OA
ATOM    190  CB  THR U  21      -7.684  29.636  66.921  0.15  2.00     0.146 C
ATOM    191  OG1 THR U  21      -7.653  29.201  65.555 -0.49  1.40    -0.393 OA
ATOM    192  CG2 THR U  21      -6.406  29.187  67.616 -0.02  2.00     0.042 C
ATOM    193  H   THR U  21     -10.489  30.406  66.882  0.40  1.00     0.163 HD
ATOM    194  HG1 THR U  21      -8.424  29.596  65.045  0.49  1.00     0.210 HD
ATOM    195  N   CYS U  22      -8.699  28.605  69.992 -0.40  1.50    -0.345 N
ATOM    196  CA  CYS U  22      -8.591  28.916  71.416  0.19  2.00     0.185 C
ATOM    197  C   CYS U  22      -7.289  28.291  71.905  0.55  1.70     0.241 C
ATOM    198  O   CYS U  22      -7.209  27.073  72.087 -0.55  1.40    -0.271 OA
ATOM    199  CB  CYS U  22      -9.794  28.394  72.196  0.05  2.00     0.105 C
ATOM    200  SG  CYS U  22      -9.850  28.921  73.924 -0.29  1.85    -0.180 SA
ATOM    201  H   CYS U  22      -8.569  27.636  69.613  0.40  1.00     0.163 HD
ATOM    202  HG  CYS U  22      -9.441  28.214  74.501  0.29  1.00     0.101 HD
ATOM    203  N   GLY U  23      -6.271  29.123  72.106 -0.40  1.50    -0.351 N
ATOM    204  CA  GLY U  23      -4.951  28.628  72.441  0.15  2.00     0.225 C
ATOM    205  C   GLY U  23      -4.291  27.961  71.253  0.55  1.70     0.236 C
ATOM    206  O   GLY U  23      -4.089  28.592  70.211 -0.55  1.40    -0.272 OA
ATOM    207  H   GLY U  23      -6.504  30.128  72.004  0.40  1.00     0.163 HD
ATOM    208  N   THR U  24      -3.956  26.681  71.392 -0.40  1.50    -0.344 N
ATOM    209  CA  THR U  24      -3.402  25.902  70.294  0.20  2.00     0.205 C
ATOM    210  C   THR U  24      -4.429  24.989  69.640  0.55  1.70     0.243 C
ATOM    211  O   THR U  24      -4.066  24.193  68.768 -0.55  1.40    -0.271 OA
ATOM    212  CB  THR U  24      -2.213  25.067  70.778  0.15  2.00     0.146 C
ATOM    213  OG1 THR U  24      -2.574  24.354  71.966 -0.49  1.40    -0.393 OA
ATOM    214  CG2 THR U  24      -1.016  25.962  71.073 -0.02  2.00     0.042 C
ATOM    215  H   THR U  24      -4.123  26.291  72.344  0.40  1.00     0.163 HD
ATOM    216  HG1 THR U  24      -3.575  24.296  72.049  0.49  1.00     0.210 HD
ATOM    217  N   THR U  25      -5.695  25.080  70.036 -0.40  1.50    -0.344 N
ATOM    218  CA  THR U  25      -6.750  24.247  69.473  0.20  2.00     0.205 C
ATOM    219  C   THR U  25      -7.468  25.013  68.371  0.55  1.70     0.243 C
ATOM    220  O   THR U  25      -7.907  26.147  68.585 -0.55  1.40    -0.271 OA
ATOM    221  CB  THR U  25      -7.747  23.818  70.551  0.15  2.00     0.146 C
ATOM    222  OG1 THR U  25      -7.040  23.274  71.673 -0.49  1.40    -0.393 OA
ATOM    223  CG2 THR U  25      -8.709  22.779  70.002 -0.02  2.00     0.042 C
ATOM    224  H   THR U  25      -5.865  25.793  70.778  0.40  1.00     0.163 HD
ATOM    225  HG1 THR U  25      -6.270  23.870  71.923  0.49  1.00     0.210 HD
ATOM    226  N   THR U  26      -7.589  24.392  67.200 -0.40  1.50    -0.344 N
ATOM    227  CA  THR U  26      -8.224  25.031  66.060  0.20  2.00     0.205 C
ATOM    228  C   THR U  26      -9.218  24.075  65.426  0.55  1.70     0.243 C
ATOM    229  O   THR U  26      -8.883  22.919  65.137 -0.55  1.40    -0.271 OA
ATOM    230  CB  THR U  26      -7.184  25.490  65.034  0.15  2.00     0.146 C
ATOM    231  OG1 THR U  26      -7.836  25.859  63.814 -0.49  1.40    -0.393 OA
ATOM    232  CG2 THR U  26      -6.155  24.392  64.757 -0.02  2.00     0.042 C
ATOM    233  H   THR U  26      -7.197  23.430  67.176  0.40  1.00     0.163 HD
ATOM    234  HG1 THR U  26      -8.383  26.692  63.948  0.49  1.00     0.210 HD
ATOM    235  N   LEU U  27     -10.433  24.568  65.192 -0.40  1.50    -0.346 N
ATOM    236  CA  LEU U  27     -11.471  23.771  64.549  0.18  2.00     0.177 C
ATOM    237  C   LEU U  27     -12.390  24.710  63.786  0.55  1.70     0.241 C
ATOM    238  O   LEU U  27     -12.154  25.920  63.720 -0.55  1.40    -0.271 OA
ATOM    239  CB  LEU U  27     -12.225  22.902  65.570  0.00  2.00     0.038 C
ATOM    240  CG  LEU U  27     -12.639  23.447  66.937 -0.02  2.00    -0.020 C
ATOM    241  CD1 LEU U  27     -13.847  24.364  66.831 -0.05  2.00     0.009 C
ATOM    242  CD2 LEU U  27     -12.936  22.285  67.873 -0.05  2.00     0.009 C
ATOM    243  H   LEU U  27     -10.572  25.549  65.502  0.40  1.00     0.163 HD
ATOM    244  N   ASN U  28     -13.448  24.141  63.222 -0.40  1.50    -0.346 N
ATOM    245  CA  ASN U  28     -14.372  24.876  62.380  0.18  2.00     0.185 C
ATOM    246  C   ASN U  28     -15.551  25.393  63.193  0.55  1.70     0.241 C
ATOM    247  O   ASN U  28     -15.959  24.793  64.189 -0.55  1.40    -0.271 OA
ATOM    248  CB  ASN U  28     -14.877  23.989  61.240  0.09  2.00     0.137 C
ATOM    249  CG  ASN U  28     -13.749  23.365  60.446  0.55  1.70     0.217 C
ATOM    250  H   ASN U  28     -13.555  23.123  63.438  0.40  1.00     0.163 HD
ATOM    251  OD1 ASN U  28     -13.172  24.000  59.565 -0.55  1.40    -0.274 OA
ATOM    252  ND2 ASN U  28     -13.426  22.114  60.755 -0.78  1.50    -0.370 N
ATOM    253 1HD2 ASN U  28     -13.928  21.635  61.478  0.39  1.00     0.159 HD
ATOM    254 2HD2 ASN U  28     -12.687  21.651  60.269  0.39  1.00     0.159 HD
ATOM    255  N   GLY U  29     -16.098  26.525  62.749 -0.40  1.50    -0.351 N
ATOM    256  CA  GLY U  29     -17.267  27.095  63.375  0.15  2.00     0.225 C
ATOM    257  C   GLY U  29     -18.309  27.457  62.335  0.55  1.70     0.236 C
ATOM    258  O   GLY U  29     -18.006  27.655  61.159 -0.55  1.40    -0.272 OA
ATOM    259  H   GLY U  29     -15.613  26.945  61.931  0.40  1.00     0.163 HD
ATOM    260  N   LEU U  30     -19.555  27.536  62.795 -0.40  1.50    -0.346 N
ATOM    261  CA  LEU U  30     -20.692  27.883  61.949  0.18  2.00     0.177 C
ATOM    262  C   LEU U  30     -21.108  29.312  62.273  0.55  1.70     0.241 C
ATOM    263  O   LEU U  30     -21.612  29.586  63.367 -0.55  1.40    -0.271 OA
ATOM    264  CB  LEU U  30     -21.848  26.907  62.161  0.00  2.00     0.038 C
ATOM    265  CG  LEU U  30     -22.986  26.989  61.143 -0.02  2.00    -0.020 C
ATOM    266  CD1 LEU U  30     -22.489  26.629  59.750 -0.05  2.00     0.009 C
ATOM    267  CD2 LEU U  30     -24.140  26.089  61.552 -0.05  2.00     0.009 C
ATOM    268  H   LEU U  30     -19.649  27.328  63.817  0.40  1.00     0.163 HD
ATOM    269  N   TRP U  31     -20.902  30.218  61.319 -0.40  1.50    -0.346 N
ATOM    270  CA  TRP U  31     -21.166  31.644  61.503  0.18  2.00     0.181 C
ATOM    271  C   TRP U  31     -22.534  31.965  60.907  0.55  1.70     0.241 C
ATOM    272  O   TRP U  31     -22.679  32.092  59.688 -0.55  1.40    -0.271 OA
ATOM    273  CB  TRP U  31     -20.062  32.478  60.860  0.03  2.00     0.075 C
ATOM    274  CG  TRP U  31     -20.199  33.957  61.074 -0.12  1.70    -0.028 A
ATOM    275  CD1 TRP U  31     -20.963  34.587  62.015  0.10  1.70     0.096 A
ATOM    276  CD2 TRP U  31     -19.548  34.993  60.329 -0.00  1.70    -0.002 A
ATOM    277  NE1 TRP U  31     -20.829  35.949  61.899 -0.40  1.50    -0.365 N
ATOM    278  CE2 TRP U  31     -19.965  36.225  60.871  0.00  1.70     0.042 A
ATOM    279  CE3 TRP U  31     -18.654  34.998  59.254  0.01  1.70     0.014 A
ATOM    280  CZ2 TRP U  31     -19.519  37.448  60.376  0.03  1.70     0.030 A
ATOM    281  CZ3 TRP U  31     -18.212  36.214  58.763  0.00  1.70     0.001 A
ATOM    282  CH2 TRP U  31     -18.645  37.421  59.324  0.00  1.70     0.002 A
ATOM    283  H   TRP U  31     -20.534  29.820  60.423  0.40  1.00     0.163 HD
ATOM    284  HE1 TRP U  31     -21.286  36.630  62.470  0.40  1.00     0.165 HD
ATOM    285  N   LEU U  32     -23.535  32.098  61.773 -0.40  1.50    -0.346 N
ATOM    286  CA  LEU U  32     -24.892  32.456  61.377  0.18  2.00     0.177 C
ATOM    287  C   LEU U  32     -25.290  33.722  62.120  0.55  1.70     0.241 C
ATOM    288  O   LEU U  32     -25.246  33.758  63.355 -0.55  1.40    -0.271 OA
ATOM    289  CB  LEU U  32     -25.874  31.323  61.679  0.00  2.00     0.038 C
ATOM    290  CG  LEU U  32     -25.647  30.004  60.938 -0.02  2.00    -0.020 C
ATOM    291  CD1 LEU U  32     -26.558  28.924  61.493 -0.05  2.00     0.009 C
ATOM    292  CD2 LEU U  32     -25.868  30.181  59.445 -0.05  2.00     0.009 C
ATOM    293  H   LEU U  32     -23.262  31.922  62.771  0.40  1.00     0.163 HD
ATOM    294  N   ASP U  33     -25.681  34.750  61.369 -0.40  1.50    -0.346 N
ATOM    295  CA  ASP U  33     -26.000  36.076  61.916  0.19  2.00     0.186 C
ATOM    296  C   ASP U  33     -24.764  36.546  62.682  0.55  1.70     0.241 C
ATOM    297  O   ASP U  33     -23.659  36.526  62.117 -0.55  1.40    -0.271 OA
ATOM    298  CB  ASP U  33     -27.293  36.008  62.721  0.10  2.00     0.147 C
ATOM    299  CG  ASP U  33     -28.466  35.509  61.898  0.10  1.70     0.175 C
ATOM    300  OD1 ASP U  33     -28.621  35.962  60.745 -0.55  1.40    -0.648 OA
ATOM    301  OD2 ASP U  33     -29.231  34.661  62.404 -0.55  1.40    -0.648 OA
ATOM    302  H   ASP U  33     -25.743  34.534  60.345  0.40  1.00     0.163 HD
ATOM    303  N   ASP U  34     -24.885  36.953  63.945 -0.40  1.50    -0.345 N
ATOM    304  CA  ASP U  34     -23.749  37.410  64.736  0.19  2.00     0.186 C
ATOM    305  C   ASP U  34     -23.337  36.386  65.790  0.55  1.70     0.241 C
ATOM    306  O   ASP U  34     -22.807  36.750  66.843 -0.55  1.40    -0.271 OA
ATOM    307  CB  ASP U  34     -24.063  38.754  65.393  0.10  2.00     0.147 C
ATOM    308  CG  ASP U  34     -25.304  38.701  66.263  0.10  1.70     0.175 C
ATOM    309  OD1 ASP U  34     -26.354  38.231  65.777 -0.55  1.40    -0.648 OA
ATOM    310  OD2 ASP U  34     -25.229  39.131  67.434 -0.55  1.40    -0.648 OA
ATOM    311  H   ASP U  34     -25.861  36.916  64.316  0.40  1.00     0.163 HD
ATOM    312  N   VAL U  35     -23.574  35.103  65.523 -0.40  1.50    -0.346 N
ATOM    313  CA  VAL U  35     -23.243  34.028  66.449  0.18  2.00     0.180 C
ATOM    314  C   VAL U  35     -22.415  32.985  65.712  0.55  1.70     0.241 C
ATOM    315  O   VAL U  35     -22.720  32.631  64.568 -0.55  1.40    -0.271 OA
ATOM    316  CB  VAL U  35     -24.510  33.385  67.055  0.01  2.00     0.009 C
ATOM    317  CG1 VAL U  35     -24.134  32.278  68.031 -0.04  2.00     0.012 C
ATOM    318  CG2 VAL U  35     -25.366  34.437  67.745 -0.04  2.00     0.012 C
ATOM    319  H   VAL U  35     -24.019  34.935  64.590  0.40  1.00     0.163 HD
ATOM    320  N   VAL U  36     -21.366  32.496  66.369 -0.40  1.50    -0.346 N
ATOM    321  CA  VAL U  36     -20.511  31.442  65.835  0.18  2.00     0.180 C
ATOM    322  C   VAL U  36     -20.680  30.210  66.712  0.55  1.70     0.241 C
ATOM    323  O   VAL U  36     -20.465  30.269  67.929 -0.55  1.40    -0.271 OA
ATOM    324  CB  VAL U  36     -19.039  31.878  65.775  0.01  2.00     0.009 C
ATOM    325  CG1 VAL U  36     -18.153  30.695  65.414 -0.04  2.00     0.012 C
ATOM    326  CG2 VAL U  36     -18.862  33.006  64.773 -0.04  2.00     0.012 C
ATOM    327  H   VAL U  36     -21.207  32.936  67.308  0.40  1.00     0.163 HD
ATOM    328  N   TYR U  37     -21.067  29.096  66.097 -0.40  1.50    -0.346 N
ATOM    329  CA  TYR U  37     -21.262  27.834  66.796  0.18  2.00     0.180 C
ATOM    330  C   TYR U  37     -20.089  26.911  66.499  0.55  1.70     0.241 C
ATOM    331  O   TYR U  37     -19.680  26.776  65.342 -0.55  1.40    -0.271 OA
ATOM    332  CB  TYR U  37     -22.573  27.166  66.374  0.03  2.00     0.073 C
ATOM    333  CG  TYR U  37     -23.799  28.049  66.479 -0.12  1.70    -0.056 A
ATOM    334  CD1 TYR U  37     -24.106  28.970  65.485  0.01  1.70     0.010 A
ATOM    335  CD2 TYR U  37     -24.657  27.951  67.567  0.01  1.70     0.010 A
ATOM    336  CE1 TYR U  37     -25.225  29.775  65.576  0.04  1.70     0.037 A
ATOM    337  CE2 TYR U  37     -25.780  28.750  67.665  0.04  1.70     0.037 A
ATOM    338  CZ  TYR U  37     -26.059  29.660  66.667  0.06  1.70     0.065 A
ATOM    339  OH  TYR U  37     -27.174  30.458  66.762 -0.49  1.40    -0.361 OA
ATOM    340  H   TYR U  37     -21.219  29.206  65.067  0.40  1.00     0.163 HD
ATOM    341  HH  TYR U  37     -26.897  31.416  66.720  0.43  1.00     0.217 HD
ATOM    342  N   CYS U  38     -19.555  26.277  67.537 -0.40  1.50    -0.345 N
ATOM    343  CA  CYS U  38     -18.419  25.382  67.383  0.19  2.00     0.185 C
ATOM    344  C   CYS U  38     -18.436  24.379  68.527  0.55  1.70     0.244 C
ATOM    345  O   CYS U  38     -19.055  24.631  69.566 -0.55  1.40    -0.271 OA
ATOM    346  CB  CYS U  38     -17.094  26.158  67.362  0.05  2.00     0.105 C
ATOM    347  SG  CYS U  38     -16.612  26.882  68.946 -0.29  1.85    -0.180 SA
ATOM    348  H   CYS U  38     -20.012  26.474  68.450  0.40  1.00     0.163 HD
ATOM    349  HG  CYS U  38     -16.410  26.152  69.599  0.29  1.00     0.101 HD
ATOM    350  N   PRO U  39     -17.786  23.226  68.357 -0.56  1.50    -0.337 N
ATOM    351  CA  PRO U  39     -17.701  22.266  69.465  0.18  2.00     0.179 C
ATOM    352  C   PRO U  39     -16.998  22.878  70.667  0.55  1.70     0.241 C
ATOM    353  O   PRO U  39     -16.035  23.635  70.530 -0.55  1.40    -0.271 OA
ATOM    354  CB  PRO U  39     -16.894  21.107  68.869  0.00  2.00     0.037 C
ATOM    355  CG  PRO U  39     -17.094  21.224  67.394 -0.01  2.00     0.022 C
ATOM    356  CD  PRO U  39     -17.189  22.695  67.120  0.06  2.00     0.127 C
ATOM    357  N   ARG U  40     -17.494  22.542  71.859 -0.40  1.50    -0.346 N
ATOM    358  CA  ARG U  40     -16.988  23.157  73.078  0.18  2.00     0.176 C
ATOM    359  C   ARG U  40     -15.606  22.656  73.474  0.55  1.70     0.241 C
ATOM    360  O   ARG U  40     -14.947  23.300  74.296 -0.55  1.40    -0.271 OA
ATOM    361  CB  ARG U  40     -17.967  22.928  74.233  0.00  2.00     0.036 C
ATOM    362  CG  ARG U  40     -18.007  21.502  74.755 -0.01  2.00     0.023 C
ATOM    363  CD  ARG U  40     -18.840  21.416  76.025  0.07  2.00     0.138 C
ATOM    364  NE  ARG U  40     -19.094  20.034  76.424 -0.35  1.50    -0.227 N
ATOM    365  CZ  ARG U  40     -19.794  19.685  77.498  0.35  1.70     0.665 C
ATOM    366  NH1 ARG U  40     -20.308  20.617  78.289 -0.70  1.50    -0.235 N
ATOM    367  NH2 ARG U  40     -19.975  18.403  77.785 -0.70  1.50    -0.235 N
ATOM    368  H   ARG U  40     -18.242  21.831  71.837  0.40  1.00     0.163 HD
ATOM    369  HE  ARG U  40     -18.715  19.301  75.849  0.45  1.00     0.177 HD
ATOM    370 1HH1 ARG U  40     -20.198  21.586  78.086  0.40  1.00     0.174 HD
ATOM    371 2HH1 ARG U  40     -20.821  20.342  79.112  0.40  1.00     0.174 HD
ATOM    372 1HH2 ARG U  40     -19.597  17.701  77.176  0.40  1.00     0.174 HD
ATOM    373 2HH2 ARG U  40     -20.484  18.136  78.600  0.40  1.00     0.174 HD
ATOM    374  N   HIS U  41     -15.145  21.538  72.916 -0.40  1.50    -0.346 N
ATOM    375  CA  HIS U  41     -13.820  21.037  73.265  0.18  2.00     0.182 C
ATOM    376  C   HIS U  41     -12.697  21.814  72.589  0.55  1.70     0.241 C
ATOM    377  O   HIS U  41     -11.539  21.391  72.668 -0.55  1.40    -0.271 OA
ATOM    378  CB  HIS U  41     -13.705  19.545  72.937  0.05  2.00     0.093 C
ATOM    379  CG  HIS U  41     -13.826  19.231  71.479 -0.12  1.70     0.030 A
ATOM    380  ND1 HIS U  41     -12.825  19.513  70.574 -0.40  1.50    -0.353 N
ATOM    381  CD2 HIS U  41     -14.833  18.673  70.766  0.14  1.70     0.143 A
ATOM    382  CE1 HIS U  41     -13.206  19.134  69.368  0.21  1.70     0.207 A
ATOM    383  NE2 HIS U  41     -14.420  18.621  69.457 -0.56  1.50    -0.254 NA
ATOM    384  H   HIS U  41     -15.778  21.082  72.248  0.40  1.00     0.163 HD
ATOM    385  HD1 HIS U  41     -11.948  19.937  70.800  0.40  1.00     0.166 HD
ATOM    386  N   VAL U  42     -13.011  22.932  71.930 -0.40  1.50    -0.346 N
ATOM    387  CA  VAL U  42     -11.972  23.826  71.436  0.18  2.00     0.180 C
ATOM    388  C   VAL U  42     -11.252  24.518  72.587  0.55  1.70     0.241 C
ATOM    389  O   VAL U  42     -10.132  25.010  72.411 -0.55  1.40    -0.271 OA
ATOM    390  CB  VAL U  42     -12.576  24.854  70.458  0.01  2.00     0.009 C
ATOM    391  CG1 VAL U  42     -13.447  25.854  71.200 -0.04  2.00     0.012 C
ATOM    392  CG2 VAL U  42     -11.482  25.565  69.669 -0.04  2.00     0.012 C
ATOM    393  H   VAL U  42     -14.023  23.098  71.808  0.40  1.00     0.163 HD
ATOM    394  N   ILE U  43     -11.866  24.557  73.776 -0.40  1.50    -0.346 N
ATOM    395  CA  ILE U  43     -11.235  25.160  74.945  0.18  2.00     0.180 C
ATOM    396  C   ILE U  43     -10.322  24.190  75.681  0.55  1.70     0.241 C
ATOM    397  O   ILE U  43      -9.723  24.569  76.697 -0.55  1.40    -0.271 OA
ATOM    398  CB  ILE U  43     -12.293  25.705  75.927  0.01  2.00     0.013 C
ATOM    399  CG1 ILE U  43     -13.044  24.551  76.594 -0.03  2.00     0.002 C
ATOM    400  CG2 ILE U  43     -13.257  26.636  75.211 -0.04  2.00     0.012 C
ATOM    401  CD1 ILE U  43     -14.181  24.995  77.490 -0.05  2.00     0.005 C
ATOM    402  H   ILE U  43     -12.810  24.128  73.789  0.40  1.00     0.163 HD
ATOM    403  N   CYS U  44     -10.196  22.955  75.208 -0.40  1.50    -0.345 N
ATOM    404  CA  CYS U  44      -9.356  21.954  75.847  0.19  2.00     0.185 C
ATOM    405  C   CYS U  44      -8.022  21.818  75.124  0.55  1.70     0.242 C
ATOM    406  O   CYS U  44      -7.859  22.241  73.976 -0.55  1.40    -0.271 OA
ATOM    407  CB  CYS U  44     -10.057  20.592  75.883  0.05  2.00     0.105 C
ATOM    408  SG  CYS U  44     -11.790  20.639  76.366 -0.29  1.85    -0.180 SA
ATOM    409  H   CYS U  44     -10.750  22.767  74.342  0.40  1.00     0.163 HD
ATOM    410  HG  CYS U  44     -12.352  20.898  75.579  0.29  1.00     0.101 HD
ATOM    411  N   THR U  45      -7.064  21.219  75.820 -0.40  1.50    -0.344 N
ATOM    412  CA  THR U  45      -5.783  20.824  75.253  0.20  2.00     0.205 C
ATOM    413  C   THR U  45      -5.623  19.313  75.424  0.55  1.70     0.243 C
ATOM    414  O   THR U  45      -6.547  18.617  75.855 -0.55  1.40    -0.271 OA
ATOM    415  CB  THR U  45      -4.635  21.607  75.896  0.15  2.00     0.146 C
ATOM    416  OG1 THR U  45      -3.438  21.416  75.131 -0.49  1.40    -0.393 OA
ATOM    417  CG2 THR U  45      -4.399  21.145  77.328 -0.02  2.00     0.042 C
ATOM    418  H   THR U  45      -7.312  21.052  76.829  0.40  1.00     0.163 HD
ATOM    419  HG1 THR U  45      -3.664  21.121  74.197  0.49  1.00     0.210 HD
ATOM    420  N   SER U  46      -4.437  18.804  75.082 -0.40  1.50    -0.344 N
ATOM    421  CA  SER U  46      -4.225  17.360  75.096  0.20  2.00     0.200 C
ATOM    422  C   SER U  46      -4.359  16.773  76.496  0.55  1.70     0.243 C
ATOM    423  O   SER U  46      -4.830  15.640  76.649 -0.55  1.40    -0.271 OA
ATOM    424  CB  SER U  46      -2.855  17.028  74.504  0.12  2.00     0.199 C
ATOM    425  OG  SER U  46      -2.750  17.507  73.174 -0.49  1.40    -0.398 OA
ATOM    426  H   SER U  46      -3.720  19.492  74.820  0.40  1.00     0.163 HD
ATOM    427  HG  SER U  46      -3.344  18.302  73.058  0.49  1.00     0.209 HD
ATOM    428  N   GLU U  47      -3.965  17.521  77.527 -0.40  1.50    -0.346 N
ATOM    429  CA  GLU U  47      -4.049  17.023  78.895  0.18  2.00     0.177 C
ATOM    430  C   GLU U  47      -5.452  17.117  79.482  0.55  1.70     0.241 C
ATOM    431  O   GLU U  47      -5.693  16.560  80.559 -0.55  1.40    -0.271 OA
ATOM    432  CB  GLU U  47      -3.065  17.782  79.791  0.01  2.00     0.045 C
ATOM    433  CG  GLU U  47      -2.573  16.982  80.987  0.07  2.00     0.116 C
ATOM    434  CD  GLU U  47      -1.180  17.384  81.429  0.10  1.70     0.172 C
ATOM    435  OE1 GLU U  47      -1.058  18.045  82.481 -0.55  1.40    -0.648 OA
ATOM    436  OE2 GLU U  47      -0.209  17.036  80.725 -0.55  1.40    -0.648 OA
ATOM    437  H   GLU U  47      -3.606  18.457  77.276  0.40  1.00     0.163 HD
ATOM    438  N   ASP U  48      -6.379  17.796  78.807 -0.40  1.50    -0.346 N
ATOM    439  CA  ASP U  48      -7.738  17.946  79.309  0.19  2.00     0.186 C
ATOM    440  C   ASP U  48      -8.702  16.904  78.758  0.55  1.70     0.241 C
ATOM    441  O   ASP U  48      -9.706  16.606  79.414 -0.55  1.40    -0.271 OA
ATOM    442  CB  ASP U  48      -8.281  19.339  78.967  0.10  2.00     0.147 C
ATOM    443  CG  ASP U  48      -7.577  20.447  79.727  0.10  1.70     0.175 C
ATOM    444  OD1 ASP U  48      -7.511  20.368  80.972 -0.55  1.40    -0.648 OA
ATOM    445  OD2 ASP U  48      -7.100  21.402  79.079 -0.55  1.40    -0.648 OA
ATOM    446  H   ASP U  48      -6.051  18.201  77.908  0.40  1.00     0.163 HD
ATOM    447  N   MET U  49      -8.413  16.332  77.588 -0.40  1.50    -0.346 N
ATOM    448  CA  MET U  49      -9.418  15.600  76.823  0.18  2.00     0.177 C
ATOM    449  C   MET U  49      -9.793  14.249  77.421  0.55  1.70     0.241 C
ATOM    450  O   MET U  49     -10.736  13.623  76.925 -0.55  1.40    -0.271 OA
ATOM    451  CB  MET U  49      -8.930  15.410  75.386  0.01  2.00     0.045 C
ATOM    452  CG  MET U  49      -8.934  16.691  74.567  0.03  2.00     0.076 C
ATOM    453  SD  MET U  49      -8.229  16.487  72.920 -0.53  1.85    -0.173 SA
ATOM    454  CE  MET U  49      -8.703  18.038  72.158  0.01  2.00     0.089 C
ATOM    455  H   MET U  49      -7.430  16.452  77.277  0.40  1.00     0.163 HD
ATOM    456  N   LEU U  50      -9.098  13.777  78.459 -0.40  1.50    -0.346 N
ATOM    457  CA  LEU U  50      -9.472  12.497  79.056  0.18  2.00     0.177 C
ATOM    458  C   LEU U  50     -10.771  12.620  79.843  0.55  1.70     0.241 C
ATOM    459  O   LEU U  50     -11.702  11.828  79.656 -0.55  1.40    -0.271 OA
ATOM    460  CB  LEU U  50      -8.348  11.972  79.949  0.00  2.00     0.038 C
ATOM    461  CG  LEU U  50      -8.686  10.683  80.706 -0.02  2.00    -0.020 C
ATOM    462  CD1 LEU U  50      -9.083   9.574  79.738 -0.05  2.00     0.009 C
ATOM    463  CD2 LEU U  50      -7.524  10.242  81.582 -0.05  2.00     0.009 C
ATOM    464  H   LEU U  50      -8.323  14.362  78.779  0.40  1.00     0.163 HD
ATOM    465  N   ASN U  51     -10.852  13.606  80.734 -0.40  1.50    -0.346 N
ATOM    466  CA  ASN U  51     -12.073  13.874  81.495  0.19  2.00     0.185 C
ATOM    467  C   ASN U  51     -12.099  15.344  81.875  0.55  1.70     0.243 C
ATOM    468  O   ASN U  51     -11.754  15.724  83.001 -0.55  1.40    -0.271 OA
ATOM    469  CB  ASN U  51     -12.165  12.987  82.737  0.09  2.00     0.137 C
ATOM    470  CG  ASN U  51     -13.429  13.238  83.538  0.55  1.70     0.217 C
ATOM    471  H   ASN U  51      -9.980  14.165  80.842  0.40  1.00     0.163 HD
ATOM    472  OD1 ASN U  51     -14.540  13.012  83.056 -0.55  1.40    -0.274 OA
ATOM    473  ND2 ASN U  51     -13.266  13.713  84.768 -0.78  1.50    -0.370 N
ATOM    474 1HD2 ASN U  51     -12.343  13.891  85.115  0.39  1.00     0.159 HD
ATOM    475 2HD2 ASN U  51     -14.060  13.893  85.346  0.39  1.00     0.159 HD
ATOM    476  N   PRO U  52     -12.498  16.214  80.948 -0.56  1.50    -0.337 N
ATOM    477  CA  PRO U  52     -12.552  17.645  81.255  0.18  2.00     0.179 C
ATOM    478  C   PRO U  52     -13.895  18.065  81.828  0.55  1.70     0.241 C
ATOM    479  O   PRO U  52     -14.959  17.609  81.403 -0.55  1.40    -0.271 OA
ATOM    480  CB  PRO U  52     -12.320  18.290  79.883  0.00  2.00     0.037 C
ATOM    481  CG  PRO U  52     -12.940  17.322  78.923 -0.01  2.00     0.022 C
ATOM    482  CD  PRO U  52     -12.813  15.939  79.534  0.06  2.00     0.127 C
ATOM    483  N   ASN U  53     -13.837  18.944  82.824 -0.40  1.50    -0.346 N
ATOM    484  CA  ASN U  53     -15.027  19.629  83.318  0.18  2.00     0.185 C
ATOM    485  C   ASN U  53     -15.147  20.918  82.518  0.55  1.70     0.241 C
ATOM    486  O   ASN U  53     -14.410  21.880  82.750 -0.55  1.40    -0.271 OA
ATOM    487  CB  ASN U  53     -14.935  19.889  84.817  0.09  2.00     0.137 C
ATOM    488  CG  ASN U  53     -16.245  20.385  85.400  0.55  1.70     0.217 C
ATOM    489  H   ASN U  53     -12.885  19.098  83.214  0.40  1.00     0.163 HD
ATOM    490  OD1 ASN U  53     -16.730  21.458  85.043 -0.55  1.40    -0.274 OA
ATOM    491  ND2 ASN U  53     -16.830  19.598  86.295 -0.78  1.50    -0.370 N
ATOM    492 1HD2 ASN U  53     -16.400  18.731  86.555  0.39  1.00     0.159 HD
ATOM    493 2HD2 ASN U  53     -17.698  19.868  86.711  0.39  1.00     0.159 HD
ATOM    494  N   TYR U  54     -16.074  20.929  81.559 -0.40  1.50    -0.346 N
ATOM    495  CA  TYR U  54     -16.130  22.020  80.594  0.18  2.00     0.180 C
ATOM    496  C   TYR U  54     -16.556  23.333  81.234  0.55  1.70     0.241 C
ATOM    497  O   TYR U  54     -16.115  24.400  80.794 -0.55  1.40    -0.271 OA
ATOM    498  CB  TYR U  54     -17.070  21.652  79.448  0.03  2.00     0.073 C
ATOM    499  CG  TYR U  54     -16.478  20.641  78.495 -0.12  1.70    -0.056 A
ATOM    500  CD1 TYR U  54     -15.662  21.044  77.448  0.01  1.70     0.010 A
ATOM    501  CD2 TYR U  54     -16.725  19.284  78.648  0.01  1.70     0.010 A
ATOM    502  CE1 TYR U  54     -15.118  20.125  76.574  0.04  1.70     0.037 A
ATOM    503  CE2 TYR U  54     -16.184  18.357  77.779  0.04  1.70     0.037 A
ATOM    504  CZ  TYR U  54     -15.380  18.784  76.744  0.06  1.70     0.065 A
ATOM    505  OH  TYR U  54     -14.835  17.868  75.874 -0.49  1.40    -0.361 OA
ATOM    506  H   TYR U  54     -16.721  20.127  81.563  0.40  1.00     0.163 HD
ATOM    507  HH  TYR U  54     -15.303  16.993  75.984  0.43  1.00     0.217 HD
ATOM    508  N   GLU U  55     -17.407  23.288  82.262 -0.40  1.50    -0.346 N
ATOM    509  CA  GLU U  55     -17.793  24.529  82.925  0.18  2.00     0.177 C
ATOM    510  C   GLU U  55     -16.624  25.125  83.697  0.55  1.70     0.241 C
ATOM    511  O   GLU U  55     -16.481  26.352  83.769 -0.55  1.40    -0.271 OA
ATOM    512  CB  GLU U  55     -18.986  24.296  83.851  0.01  2.00     0.045 C
ATOM    513  CG  GLU U  55     -20.340  24.679  83.246  0.07  2.00     0.116 C
ATOM    514  CD  GLU U  55     -20.351  26.046  82.565  0.10  1.70     0.172 C
ATOM    515  OE1 GLU U  55     -19.654  26.974  83.035 -0.55  1.40    -0.648 OA
ATOM    516  OE2 GLU U  55     -21.061  26.193  81.549 -0.55  1.40    -0.648 OA
ATOM    517  H   GLU U  55     -17.742  22.360  82.524  0.40  1.00     0.163 HD
ATOM    518  N   ASP U  56     -15.777  24.274  84.281 -0.40  1.50    -0.346 N
ATOM    519  CA  ASP U  56     -14.560  24.768  84.913  0.19  2.00     0.186 C
ATOM    520  C   ASP U  56     -13.630  25.396  83.885  0.55  1.70     0.241 C
ATOM    521  O   ASP U  56     -13.065  26.470  84.120 -0.55  1.40    -0.271 OA
ATOM    522  CB  ASP U  56     -13.852  23.632  85.650  0.10  2.00     0.147 C
ATOM    523  CG  ASP U  56     -14.054  23.692  87.150  0.10  1.70     0.175 C
ATOM    524  OD1 ASP U  56     -14.694  24.652  87.627 -0.55  1.40    -0.648 OA
ATOM    525  OD2 ASP U  56     -13.573  22.778  87.852 -0.55  1.40    -0.648 OA
ATOM    526  H   ASP U  56     -16.051  23.284  84.245  0.40  1.00     0.163 HD
ATOM    527  N   LEU U  57     -13.470  24.746  82.729 -0.40  1.50    -0.346 N
ATOM    528  CA  LEU U  57     -12.561  25.256  81.710  0.18  2.00     0.177 C
ATOM    529  C   LEU U  57     -13.090  26.528  81.064  0.55  1.70     0.241 C
ATOM    530  O   LEU U  57     -12.300  27.389  80.662 -0.55  1.40    -0.271 OA
ATOM    531  CB  LEU U  57     -12.313  24.186  80.646  0.00  2.00     0.038 C
ATOM    532  CG  LEU U  57     -11.561  22.936  81.105 -0.02  2.00    -0.020 C
ATOM    533  CD1 LEU U  57     -11.538  21.886  80.006 -0.05  2.00     0.009 C
ATOM    534  CD2 LEU U  57     -10.148  23.290  81.543 -0.05  2.00     0.009 C
ATOM    535  H   LEU U  57     -14.027  23.885  82.629  0.40  1.00     0.163 HD
ATOM    536  N   LEU U  58     -14.413  26.670  80.954 -0.40  1.50    -0.346 N
ATOM    537  CA  LEU U  58     -14.972  27.838  80.281  0.18  2.00     0.177 C
ATOM    538  C   LEU U  58     -14.925  29.078  81.165  0.55  1.70     0.241 C
ATOM    539  O   LEU U  58     -14.673  30.183  80.671 -0.55  1.40    -0.271 OA
ATOM    540  CB  LEU U  58     -16.408  27.563  79.840  0.00  2.00     0.038 C
ATOM    541  CG  LEU U  58     -17.019  28.704  79.024 -0.02  2.00    -0.020 C
ATOM    542  CD1 LEU U  58     -16.204  28.953  77.763 -0.05  2.00     0.009 C
ATOM    543  CD2 LEU U  58     -18.469  28.424  78.686 -0.05  2.00     0.009 C
ATOM    544  H   LEU U  58     -14.974  25.916  81.368  0.40  1.00     0.163 HD
ATOM    545  N   ILE U  59     -15.171  28.920  82.469 -0.40  1.50    -0.346 N
ATOM    546  CA  ILE U  59     -15.132  30.065  83.370  0.18  2.00     0.180 C
ATOM    547  C   ILE U  59     -13.727  30.640  83.487  0.55  1.70     0.241 C
ATOM    548  O   ILE U  59     -13.564  31.788  83.915 -0.55  1.40    -0.271 OA
ATOM    549  CB  ILE U  59     -15.689  29.679  84.755  0.01  2.00     0.013 C
ATOM    550  CG1 ILE U  59     -16.261  30.909  85.466 -0.03  2.00     0.002 C
ATOM    551  CG2 ILE U  59     -14.614  29.017  85.607 -0.04  2.00     0.012 C
ATOM    552  CD1 ILE U  59     -17.496  31.479  84.802 -0.05  2.00     0.005 C
ATOM    553  H   ILE U  59     -15.381  27.957  82.763  0.40  1.00     0.163 HD
ATOM    554  N   ARG U  60     -12.704  29.876  83.107 -0.40  1.50    -0.346 N
ATOM    555  CA  ARG U  60     -11.325  30.345  83.122  0.18  2.00     0.176 C
ATOM    556  C   ARG U  60     -10.927  31.042  81.829  0.55  1.70     0.241 C
ATOM    557  O   ARG U  60      -9.770  31.449  81.690 -0.55  1.40    -0.271 OA
ATOM    558  CB  ARG U  60     -10.372  29.178  83.392  0.00  2.00     0.036 C
ATOM    559  CG  ARG U  60     -10.613  28.483  84.719 -0.01  2.00     0.023 C
ATOM    560  CD  ARG U  60      -9.772  27.226  84.842  0.07  2.00     0.138 C
ATOM    561  NE  ARG U  60     -10.147  26.436  86.010 -0.35  1.50    -0.227 N
ATOM    562  CZ  ARG U  60      -9.663  25.229  86.281  0.35  1.70     0.665 C
ATOM    563  NH1 ARG U  60      -8.779  24.669  85.466 -0.70  1.50    -0.235 N
ATOM    564  NH2 ARG U  60     -10.061  24.583  87.368 -0.70  1.50    -0.235 N
ATOM    565  H   ARG U  60     -12.977  28.915  82.799  0.40  1.00     0.163 HD
ATOM    566  HE  ARG U  60     -10.815  26.831  86.651  0.45  1.00     0.177 HD
ATOM    567 1HH1 ARG U  60      -8.449  25.144  84.656  0.40  1.00     0.174 HD
ATOM    568 2HH1 ARG U  60      -8.432  23.744  85.670  0.40  1.00     0.174 HD
ATOM    569 1HH2 ARG U  60     -10.714  25.019  87.993  0.40  1.00     0.174 HD
ATOM    570 2HH2 ARG U  60      -9.715  23.669  87.567  0.40  1.00     0.174 HD
ATOM    571  N   LYS U  61     -11.851  31.186  80.886 -0.40  1.50    -0.346 N
ATOM    572  CA  LYS U  61     -11.614  31.878  79.631  0.18  2.00     0.176 C
ATOM    573  C   LYS U  61     -12.501  33.114  79.543  0.55  1.70     0.241 C
ATOM    574  O   LYS U  61     -13.520  33.229  80.229 -0.55  1.40    -0.271 OA
ATOM    575  CB  LYS U  61     -11.880  30.960  78.431 -0.00  2.00     0.035 C
ATOM    576  CG  LYS U  61     -11.268  29.575  78.554 -0.03  2.00     0.004 C
ATOM    577  CD  LYS U  61     -10.068  29.419  77.632 -0.01  2.00     0.027 C
ATOM    578  CE  LYS U  61      -9.474  28.023  77.733  0.15  2.00     0.229 C
ATOM    579  NZ  LYS U  61      -9.547  27.496  79.124 -0.32  2.00    -0.079 N
ATOM    580  H   LYS U  61     -12.778  30.751  81.130  0.40  1.00     0.163 HD
ATOM    581  HZ1 LYS U  61      -9.489  26.498  79.104  0.33  0.00     0.274 HD
ATOM    582  HZ2 LYS U  61      -8.787  27.865  79.658  0.33  0.00     0.274 HD
ATOM    583  HZ3 LYS U  61     -10.413  27.773  79.538  0.33  0.00     0.274 HD
ATOM    584  N   SER U  62     -12.092  34.048  78.691 -0.40  1.50    -0.344 N
ATOM    585  CA  SER U  62     -12.873  35.239  78.389  0.20  2.00     0.200 C
ATOM    586  C   SER U  62     -12.968  35.395  76.875  0.55  1.70     0.243 C
ATOM    587  O   SER U  62     -12.510  34.540  76.110 -0.55  1.40    -0.271 OA
ATOM    588  CB  SER U  62     -12.264  36.486  79.042  0.12  2.00     0.199 C
ATOM    589  OG  SER U  62     -10.909  36.647  78.674 -0.49  1.40    -0.398 OA
ATOM    590  H   SER U  62     -11.159  33.853  78.256  0.40  1.00     0.163 HD
ATOM    591  HG  SER U  62     -10.525  35.762  78.413  0.49  1.00     0.209 HD
ATOM    592  N   ASN U  63     -13.570  36.504  76.440 -0.40  1.50    -0.345 N
ATOM    593  CA  ASN U  63     -13.822  36.700  75.016  0.18  2.00     0.185 C
ATOM    594  C   ASN U  63     -12.531  36.844  74.220  0.55  1.70     0.241 C
ATOM    595  O   ASN U  63     -12.477  36.432  73.056 -0.55  1.40    -0.271 OA
ATOM    596  CB  ASN U  63     -14.714  37.922  74.809  0.09  2.00     0.137 C
ATOM    597  CG  ASN U  63     -16.120  37.707  75.325  0.55  1.70     0.217 C
ATOM    598  H   ASN U  63     -13.829  37.180  77.171  0.40  1.00     0.163 HD
ATOM    599  OD1 ASN U  63     -16.538  36.575  75.568 -0.55  1.40    -0.274 OA
ATOM    600  ND2 ASN U  63     -16.859  38.794  75.499 -0.78  1.50    -0.370 N
ATOM    601 1HD2 ASN U  63     -16.480  39.696  75.285  0.39  1.00     0.159 HD
ATOM    602 2HD2 ASN U  63     -17.795  38.717  75.843  0.39  1.00     0.159 HD
ATOM    603  N   HIS U  64     -11.487  37.413  74.824 -0.40  1.50    -0.346 N
ATOM    604  CA  HIS U  64     -10.226  37.603  74.116  0.18  2.00     0.182 C
ATOM    605  C   HIS U  64      -9.485  36.297  73.861  0.55  1.70     0.241 C
ATOM    606  O   HIS U  64      -8.532  36.293  73.074 -0.55  1.40    -0.271 OA
ATOM    607  CB  HIS U  64      -9.326  38.562  74.897  0.05  2.00     0.093 C
ATOM    608  CG  HIS U  64      -8.487  37.890  75.939 -0.12  1.70     0.030 A
ATOM    609  H   HIS U  64     -11.647  37.696  75.803  0.40  1.00     0.163 HD
ATOM    610  ND1 HIS U  64      -9.018  37.366  77.098 -0.40  1.50    -0.353 N
ATOM    611  CD2 HIS U  64      -7.155  37.652  75.995  0.14  1.70     0.143 A
ATOM    612  CE1 HIS U  64      -8.049  36.837  77.824  0.21  1.70     0.207 A
ATOM    613  NE2 HIS U  64      -6.909  36.998  77.177 -0.56  1.50    -0.254 NA
ATOM    614  HD1 HIS U  64      -9.986  37.384  77.348  0.40  1.00     0.166 HD
ATOM    615  N   ASN U  65      -9.891  35.199  74.500 -0.40  1.50    -0.346 N
ATOM    616  CA  ASN U  65      -9.232  33.913  74.312  0.18  2.00     0.185 C
ATOM    617  C   ASN U  65      -9.683  33.191  73.049  0.55  1.70     0.241 C
ATOM    618  O   ASN U  65      -9.116  32.144  72.720 -0.55  1.40    -0.271 OA
ATOM    619  CB  ASN U  65      -9.479  33.014  75.528  0.09  2.00     0.137 C
ATOM    620  CG  ASN U  65      -8.871  33.572  76.800  0.55  1.70     0.217 C
ATOM    621  H   ASN U  65     -10.704  35.341  75.132  0.40  1.00     0.163 HD
ATOM    622  OD1 ASN U  65      -9.554  33.725  77.813 -0.55  1.40    -0.274 OA
ATOM    623  ND2 ASN U  65      -7.579  33.875  76.756 -0.78  1.50    -0.370 N
ATOM    624 1HD2 ASN U  65      -7.063  33.736  75.909  0.39  1.00     0.159 HD
ATOM    625 2HD2 ASN U  65      -7.121  34.241  77.564  0.39  1.00     0.159 HD
ATOM    626  N   PHE U  66     -10.676  33.718  72.338 -0.40  1.50    -0.346 N
ATOM    627  CA  PHE U  66     -11.234  33.076  71.155  0.18  2.00     0.180 C
ATOM    628  C   PHE U  66     -10.905  33.913  69.926  0.55  1.70     0.241 C
ATOM    629  O   PHE U  66     -11.373  35.049  69.799 -0.55  1.40    -0.271 OA
ATOM    630  CB  PHE U  66     -12.747  32.898  71.288  0.03  2.00     0.073 C
ATOM    631  CG  PHE U  66     -13.155  31.991  72.414 -0.12  1.70    -0.056 A
ATOM    632  CD1 PHE U  66     -13.187  30.616  72.245  0.01  1.70     0.007 A
ATOM    633  CD2 PHE U  66     -13.506  32.517  73.646  0.01  1.70     0.007 A
ATOM    634  CE1 PHE U  66     -13.564  29.783  73.286  0.00  1.70     0.001 A
ATOM    635  CE2 PHE U  66     -13.883  31.691  74.689  0.00  1.70     0.001 A
ATOM    636  CZ  PHE U  66     -13.912  30.323  74.509  0.00  1.70     0.000 A
ATOM    637  H   PHE U  66     -11.023  34.637  72.704  0.40  1.00     0.163 HD
ATOM    638  N   LEU U  67     -10.106  33.350  69.026 -0.40  1.50    -0.346 N
ATOM    639  CA  LEU U  67      -9.759  33.989  67.760  0.18  2.00     0.177 C
ATOM    640  C   LEU U  67     -10.605  33.356  66.658  0.55  1.70     0.241 C
ATOM    641  O   LEU U  67     -10.447  32.170  66.353 -0.55  1.40    -0.271 OA
ATOM    642  CB  LEU U  67      -8.267  33.836  67.459  0.00  2.00     0.038 C
ATOM    643  CG  LEU U  67      -7.852  34.306  66.063 -0.02  2.00    -0.020 C
ATOM    644  CD1 LEU U  67      -7.697  35.811  66.075 -0.05  2.00     0.009 C
ATOM    645  CD2 LEU U  67      -6.565  33.632  65.596 -0.05  2.00     0.009 C
ATOM    646  H   LEU U  67      -9.745  32.406  69.303  0.40  1.00     0.163 HD
ATOM    647  N   VAL U  68     -11.503  34.139  66.068 -0.40  1.50    -0.346 N
ATOM    648  CA  VAL U  68     -12.392  33.669  65.012  0.18  2.00     0.180 C
ATOM    649  C   VAL U  68     -11.961  34.319  63.703  0.55  1.70     0.241 C
ATOM    650  O   VAL U  68     -11.912  35.551  63.596 -0.55  1.40    -0.271 OA
ATOM    651  CB  VAL U  68     -13.860  33.983  65.332  0.01  2.00     0.009 C
ATOM    652  CG1 VAL U  68     -14.762  33.503  64.202 -0.04  2.00     0.012 C
ATOM    653  CG2 VAL U  68     -14.269  33.341  66.650 -0.04  2.00     0.012 C
ATOM    654  H   VAL U  68     -11.517  35.123  66.427  0.40  1.00     0.163 HD
ATOM    655  N   GLN U  69     -11.657  33.492  62.708 -0.40  1.50    -0.346 N
ATOM    656  CA  GLN U  69     -11.207  33.957  61.403  0.18  2.00     0.177 C
ATOM    657  C   GLN U  69     -12.207  33.536  60.335  0.55  1.70     0.241 C
ATOM    658  O   GLN U  69     -12.541  32.352  60.222 -0.55  1.40    -0.271 OA
ATOM    659  CB  GLN U  69      -9.818  33.404  61.068  0.01  2.00     0.044 C
ATOM    660  CG  GLN U  69      -8.666  34.243  61.596  0.06  2.00     0.105 C
ATOM    661  CD  GLN U  69      -7.348  33.493  61.584  0.55  1.70     0.215 C
ATOM    662  H   GLN U  69     -11.769  32.478  62.944  0.40  1.00     0.163 HD
ATOM    663  OE1 GLN U  69      -7.203  32.459  62.237 -0.55  1.40    -0.274 OA
ATOM    664  NE2 GLN U  69      -6.378  34.008  60.836 -0.78  1.50    -0.370 N
ATOM    665 1HE2 GLN U  69      -5.464  33.568  60.790  0.39  1.00     0.159 HD
ATOM    666 2HE2 GLN U  69      -6.567  34.857  60.304  0.39  1.00     0.159 HD
ATOM    667  N   ALA U  70     -12.681  34.506  59.560 -0.40  1.50    -0.346 N
ATOM    668  CA  ALA U  70     -13.549  34.265  58.410  0.17  2.00     0.172 C
ATOM    669  C   ALA U  70     -12.748  34.645  57.168  0.55  1.70     0.240 C
ATOM    670  O   ALA U  70     -12.752  35.799  56.736 -0.55  1.40    -0.271 OA
ATOM    671  CB  ALA U  70     -14.847  35.058  58.519 -0.02  2.00     0.042 C
ATOM    672  H   ALA U  70     -12.376  35.469  59.846  0.40  1.00     0.163 HD
ATOM    673  N   GLY U  71     -12.057  33.663  56.597 -0.40  1.50    -0.351 N
ATOM    674  CA  GLY U  71     -11.104  33.933  55.542  0.15  2.00     0.225 C
ATOM    675  C   GLY U  71      -9.906  34.691  56.072  0.55  1.70     0.236 C
ATOM    676  O   GLY U  71      -9.224  34.222  56.987 -0.55  1.40    -0.272 OA
ATOM    677  H   GLY U  71     -12.259  32.716  56.967  0.40  1.00     0.163 HD
ATOM    678  N   ASN U  72      -9.640  35.867  55.512 -0.40  1.50    -0.346 N
ATOM    679  CA  ASN U  72      -8.597  36.742  56.027  0.18  2.00     0.185 C
ATOM    680  C   ASN U  72      -9.132  37.775  57.010  0.55  1.70     0.241 C
ATOM    681  O   ASN U  72      -8.343  38.534  57.581 -0.55  1.40    -0.271 OA
ATOM    682  CB  ASN U  72      -7.880  37.452  54.873  0.09  2.00     0.137 C
ATOM    683  CG  ASN U  72      -6.610  36.741  54.452  0.55  1.70     0.217 C
ATOM    684  H   ASN U  72     -10.232  36.101  54.690  0.40  1.00     0.163 HD
ATOM    685  OD1 ASN U  72      -6.627  35.888  53.564 -0.55  1.40    -0.274 OA
ATOM    686  ND2 ASN U  72      -5.498  37.089  55.090 -0.78  1.50    -0.370 N
ATOM    687 1HD2 ASN U  72      -5.533  37.784  55.811  0.39  1.00     0.159 HD
ATOM    688 2HD2 ASN U  72      -4.628  36.659  54.853  0.39  1.00     0.159 HD
ATOM    689  N   VAL U  73     -10.444  37.816  57.223 -0.40  1.50    -0.346 N
ATOM    690  CA  VAL U  73     -11.062  38.773  58.132  0.18  2.00     0.180 C
ATOM    691  C   VAL U  73     -11.174  38.141  59.513  0.55  1.70     0.241 C
ATOM    692  O   VAL U  73     -11.630  36.999  59.649 -0.55  1.40    -0.271 OA
ATOM    693  CB  VAL U  73     -12.442  39.212  57.614  0.01  2.00     0.009 C
ATOM    694  CG1 VAL U  73     -13.041  40.275  58.524 -0.04  2.00     0.012 C
ATOM    695  CG2 VAL U  73     -12.335  39.721  56.185 -0.04  2.00     0.012 C
ATOM    696  H   VAL U  73     -10.990  37.106  56.685  0.40  1.00     0.163 HD
ATOM    697  N   GLN U  74     -10.758  38.880  60.536 -0.40  1.50    -0.346 N
ATOM    698  CA  GLN U  74     -10.859  38.437  61.918  0.18  2.00     0.177 C
ATOM    699  C   GLN U  74     -12.094  39.047  62.567  0.55  1.70     0.241 C
ATOM    700  O   GLN U  74     -12.364  40.241  62.413 -0.55  1.40    -0.271 OA
ATOM    701  CB  GLN U  74      -9.607  38.823  62.709  0.01  2.00     0.044 C
ATOM    702  CG  GLN U  74      -9.667  38.459  64.183  0.06  2.00     0.105 C
ATOM    703  CD  GLN U  74      -8.486  39.001  64.964  0.55  1.70     0.215 C
ATOM    704  H   GLN U  74     -10.353  39.805  60.261  0.40  1.00     0.163 HD
ATOM    705  OE1 GLN U  74      -7.464  39.373  64.387 -0.55  1.40    -0.274 OA
ATOM    706  NE2 GLN U  74      -8.624  39.053  66.284 -0.78  1.50    -0.370 N
ATOM    707 1HE2 GLN U  74      -7.869  39.392  66.875  0.39  1.00     0.159 HD
ATOM    708 2HE2 GLN U  74      -9.503  38.747  66.699  0.39  1.00     0.159 HD
ATOM    709  N   LEU U  75     -12.844  38.219  63.287 -0.40  1.50    -0.346 N
ATOM    710  CA  LEU U  75     -14.034  38.661  64.001  0.18  2.00     0.177 C
ATOM    711  C   LEU U  75     -13.722  38.758  65.487  0.55  1.70     0.241 C
ATOM    712  O   LEU U  75     -13.122  37.842  66.061 -0.55  1.40    -0.271 OA
ATOM    713  CB  LEU U  75     -15.203  37.701  63.771  0.00  2.00     0.038 C
ATOM    714  CG  LEU U  75     -15.397  37.124  62.366 -0.02  2.00    -0.020 C
ATOM    715  CD1 LEU U  75     -16.637  36.245  62.327 -0.05  2.00     0.009 C
ATOM    716  CD2 LEU U  75     -15.490  38.228  61.323 -0.05  2.00     0.009 C
ATOM    717  H   LEU U  75     -12.507  37.230  63.296  0.40  1.00     0.163 HD
ATOM    718  N   ARG U  76     -14.125  39.864  66.105 -0.40  1.50    -0.346 N
ATOM    719  CA  ARG U  76     -13.924  40.058  67.533  0.18  2.00     0.176 C
ATOM    720  C   ARG U  76     -15.060  39.403  68.306  0.55  1.70     0.241 C
ATOM    721  O   ARG U  76     -16.236  39.687  68.055 -0.55  1.40    -0.271 OA
ATOM    722  CB  ARG U  76     -13.840  41.545  67.879  0.00  2.00     0.036 C
ATOM    723  CG  ARG U  76     -13.612  41.813  69.360 -0.01  2.00     0.023 C
ATOM    724  CD  ARG U  76     -13.416  43.294  69.645  0.07  2.00     0.138 C
ATOM    725  NE  ARG U  76     -14.581  44.088  69.265 -0.35  1.50    -0.227 N
ATOM    726  CZ  ARG U  76     -14.626  44.888  68.204  0.35  1.70     0.665 C
ATOM    727  NH1 ARG U  76     -13.568  45.003  67.413 -0.70  1.50    -0.235 N
ATOM    728  NH2 ARG U  76     -15.728  45.573  67.934 -0.70  1.50    -0.235 N
ATOM    729  H   ARG U  76     -14.587  40.563  65.490  0.40  1.00     0.163 HD
ATOM    730  HE  ARG U  76     -15.402  44.026  69.843  0.45  1.00     0.177 HD
ATOM    731 1HH1 ARG U  76     -12.735  44.484  67.583  0.40  1.00     0.174 HD
ATOM    732 2HH1 ARG U  76     -13.605  45.627  66.621  0.40  1.00     0.174 HD
ATOM    733 1HH2 ARG U  76     -16.533  45.468  68.524  0.40  1.00     0.174 HD
ATOM    734 2HH2 ARG U  76     -15.761  46.188  67.150  0.40  1.00     0.174 HD
ATOM    735  N   VAL U  77     -14.705  38.525  69.239 -0.40  1.50    -0.346 N
ATOM    736  CA  VAL U  77     -15.688  37.865  70.092  0.18  2.00     0.180 C
ATOM    737  C   VAL U  77     -16.126  38.862  71.160  0.55  1.70     0.241 C
ATOM    738  O   VAL U  77     -15.323  39.286  71.994 -0.55  1.40    -0.271 OA
ATOM    739  CB  VAL U  77     -15.122  36.588  70.720  0.01  2.00     0.009 C
ATOM    740  CG1 VAL U  77     -16.166  35.927  71.607 -0.04  2.00     0.012 C
ATOM    741  CG2 VAL U  77     -14.650  35.629  69.637 -0.04  2.00     0.012 C
ATOM    742  H   VAL U  77     -13.682  38.352  69.307  0.40  1.00     0.163 HD
ATOM    743  N   ILE U  78     -17.404  39.247  71.130 -0.40  1.50    -0.346 N
ATOM    744  CA  ILE U  78     -17.956  40.173  72.111  0.18  2.00     0.180 C
ATOM    745  C   ILE U  78     -18.777  39.464  73.176  0.55  1.70     0.241 C
ATOM    746  O   ILE U  78     -19.370  40.129  74.037 -0.55  1.40    -0.271 OA
ATOM    747  CB  ILE U  78     -18.805  41.263  71.426  0.01  2.00     0.013 C
ATOM    748  CG1 ILE U  78     -19.998  40.633  70.705 -0.03  2.00     0.002 C
ATOM    749  CG2 ILE U  78     -17.953  42.068  70.458 -0.04  2.00     0.012 C
ATOM    750  CD1 ILE U  78     -21.254  41.473  70.759 -0.05  2.00     0.005 C
ATOM    751  H   ILE U  78     -17.961  38.833  70.355  0.40  1.00     0.163 HD
ATOM    752  N   GLY U  79     -18.825  38.136  73.148 -0.40  1.50    -0.351 N
ATOM    753  CA  GLY U  79     -19.570  37.368  74.125  0.15  2.00     0.225 C
ATOM    754  C   GLY U  79     -19.483  35.882  73.851  0.55  1.70     0.236 C
ATOM    755  O   GLY U  79     -19.364  35.467  72.694 -0.55  1.40    -0.272 OA
ATOM    756  H   GLY U  79     -18.283  37.702  72.367  0.40  1.00     0.163 HD
ATOM    757  N   HIS U  80     -19.532  35.067  74.901 -0.40  1.50    -0.346 N
ATOM    758  CA  HIS U  80     -19.459  33.623  74.754  0.18  2.00     0.182 C
ATOM    759  C   HIS U  80     -20.447  32.967  75.705  0.55  1.70     0.241 C
ATOM    760  O   HIS U  80     -20.775  33.515  76.761 -0.55  1.40    -0.271 OA
ATOM    761  CB  HIS U  80     -18.040  33.094  75.012  0.05  2.00     0.093 C
ATOM    762  CG  HIS U  80     -17.537  33.357  76.396 -0.12  1.70     0.030 A
ATOM    763  H   HIS U  80     -19.625  35.548  75.819  0.40  1.00     0.163 HD
ATOM    764  ND1 HIS U  80     -16.769  34.457  76.711 -0.40  1.50    -0.353 N
ATOM    765  CD2 HIS U  80     -17.684  32.660  77.547  0.14  1.70     0.143 A
ATOM    766  CE1 HIS U  80     -16.469  34.429  77.998  0.21  1.70     0.207 A
ATOM    767  NE2 HIS U  80     -17.012  33.348  78.528 -0.56  1.50    -0.254 NA
ATOM    768  HD1 HIS U  80     -16.485  35.165  76.065  0.40  1.00     0.166 HD
ATOM    769  N   SER U  81     -20.917  31.785  75.316 -0.40  1.50    -0.344 N
ATOM    770  CA  SER U  81     -21.886  31.042  76.106  0.20  2.00     0.200 C
ATOM    771  C   SER U  81     -21.831  29.580  75.694  0.55  1.70     0.243 C
ATOM    772  O   SER U  81     -21.705  29.270  74.506 -0.55  1.40    -0.271 OA
ATOM    773  CB  SER U  81     -23.301  31.598  75.918  0.12  2.00     0.199 C
ATOM    774  OG  SER U  81     -24.271  30.573  76.035 -0.49  1.40    -0.398 OA
ATOM    775  H   SER U  81     -20.535  31.445  74.409  0.40  1.00     0.163 HD
ATOM    776  HG  SER U  81     -23.884  29.709  75.714  0.49  1.00     0.209 HD
ATOM    777  N   MET U  82     -21.922  28.691  76.677 -0.40  1.50    -0.346 N
ATOM    778  CA  MET U  82     -21.948  27.257  76.429  0.18  2.00     0.177 C
ATOM    779  C   MET U  82     -23.390  26.778  76.399  0.55  1.70     0.241 C
ATOM    780  O   MET U  82     -24.151  27.020  77.342 -0.55  1.40    -0.271 OA
ATOM    781  CB  MET U  82     -21.159  26.492  77.492  0.01  2.00     0.045 C
ATOM    782  CG  MET U  82     -21.076  24.998  77.240  0.03  2.00     0.076 C
ATOM    783  SD  MET U  82     -19.971  24.146  78.382 -0.53  1.85    -0.173 SA
ATOM    784  CE  MET U  82     -18.380  24.771  77.848  0.01  2.00     0.089 C
ATOM    785  H   MET U  82     -21.973  29.107  77.633  0.40  1.00     0.163 HD
ATOM    786  N   GLN U  83     -23.763  26.115  75.310 -0.40  1.50    -0.346 N
ATOM    787  CA  GLN U  83     -25.081  25.506  75.169  0.18  2.00     0.177 C
ATOM    788  C   GLN U  83     -24.859  24.008  75.017  0.55  1.70     0.241 C
ATOM    789  O   GLN U  83     -24.610  23.522  73.909 -0.55  1.40    -0.271 OA
ATOM    790  CB  GLN U  83     -25.835  26.093  73.985  0.01  2.00     0.044 C
ATOM    791  CG  GLN U  83     -27.334  26.150  74.186  0.06  2.00     0.105 C
ATOM    792  CD  GLN U  83     -28.094  25.956  72.894  0.55  1.70     0.215 C
ATOM    793  H   GLN U  83     -23.032  26.067  74.563  0.40  1.00     0.163 HD
ATOM    794  OE1 GLN U  83     -27.511  25.956  71.809 -0.55  1.40    -0.274 OA
ATOM    795  NE2 GLN U  83     -29.407  25.796  73.002 -0.78  1.50    -0.370 N
ATOM    796 1HE2 GLN U  83     -29.990  25.674  72.174  0.39  1.00     0.159 HD
ATOM    797 2HE2 GLN U  83     -29.829  25.796  73.929  0.39  1.00     0.159 HD
ATOM    798  N   ASN U  84     -24.943  23.286  76.135 -0.40  1.50    -0.346 N
ATOM    799  CA  ASN U  84     -24.667  21.854  76.163  0.18  2.00     0.185 C
ATOM    800  C   ASN U  84     -23.255  21.576  75.665  0.55  1.70     0.241 C
ATOM    801  O   ASN U  84     -22.282  21.926  76.339 -0.55  1.40    -0.271 OA
ATOM    802  CB  ASN U  84     -25.704  21.085  75.339  0.09  2.00     0.137 C
ATOM    803  CG  ASN U  84     -27.120  21.394  75.766  0.55  1.70     0.217 C
ATOM    804  H   ASN U  84     -25.221  23.831  76.980  0.40  1.00     0.163 HD
ATOM    805  OD1 ASN U  84     -27.467  21.251  76.939 -0.55  1.40    -0.274 OA
ATOM    806  ND2 ASN U  84     -27.944  21.838  74.824 -0.78  1.50    -0.370 N
ATOM    807 1HD2 ASN U  84     -27.612  21.945  73.884  0.39  1.00     0.159 HD
ATOM    808 2HD2 ASN U  84     -28.890  22.064  75.048  0.39  1.00     0.159 HD
ATOM    809  N   CYS U  85     -23.115  20.964  74.490 -0.40  1.50    -0.345 N
ATOM    810  CA  CYS U  85     -21.798  20.585  73.993  0.19  2.00     0.185 C
ATOM    811  C   CYS U  85     -21.272  21.497  72.891  0.55  1.70     0.241 C
ATOM    812  O   CYS U  85     -20.211  21.212  72.327 -0.55  1.40    -0.271 OA
ATOM    813  CB  CYS U  85     -21.806  19.130  73.517  0.05  2.00     0.105 C
ATOM    814  SG  CYS U  85     -22.241  17.929  74.804 -0.29  1.85    -0.180 SA
ATOM    815  H   CYS U  85     -23.996  20.788  73.980  0.40  1.00     0.163 HD
ATOM    816  HG  CYS U  85     -21.407  17.513  75.163  0.29  1.00     0.101 HD
ATOM    817  N   VAL U  86     -21.956  22.597  72.589 -0.40  1.50    -0.346 N
ATOM    818  CA  VAL U  86     -21.462  23.546  71.599  0.18  2.00     0.180 C
ATOM    819  C   VAL U  86     -21.217  24.889  72.270  0.55  1.70     0.241 C
ATOM    820  O   VAL U  86     -21.880  25.253  73.248 -0.55  1.40    -0.271 OA
ATOM    821  CB  VAL U  86     -22.422  23.712  70.400  0.01  2.00     0.009 C
ATOM    822  CG1 VAL U  86     -22.536  22.411  69.618 -0.04  2.00     0.012 C
ATOM    823  CG2 VAL U  86     -23.786  24.197  70.866 -0.04  2.00     0.012 C
ATOM    824  H   VAL U  86     -22.845  22.716  73.105  0.40  1.00     0.163 HD
ATOM    825  N   LEU U  87     -20.248  25.624  71.735 -0.40  1.50    -0.346 N
ATOM    826  CA  LEU U  87     -19.981  26.989  72.159  0.18  2.00     0.177 C
ATOM    827  C   LEU U  87     -20.746  27.959  71.272  0.55  1.70     0.241 C
ATOM    828  O   LEU U  87     -20.863  27.752  70.060 -0.55  1.40    -0.271 OA
ATOM    829  CB  LEU U  87     -18.483  27.293  72.093  0.00  2.00     0.038 C
ATOM    830  CG  LEU U  87     -17.705  27.345  73.407 -0.02  2.00    -0.020 C
ATOM    831  CD1 LEU U  87     -16.210  27.344  73.135 -0.05  2.00     0.009 C
ATOM    832  CD2 LEU U  87     -18.101  28.566  74.221 -0.05  2.00     0.009 C
ATOM    833  H   LEU U  87     -19.700  25.139  70.990  0.40  1.00     0.163 HD
ATOM    834  N   LYS U  88     -21.273  29.017  71.882 -0.40  1.50    -0.346 N
ATOM    835  CA  LYS U  88     -21.956  30.086  71.160  0.18  2.00     0.176 C
ATOM    836  C   LYS U  88     -21.167  31.370  71.373  0.55  1.70     0.241 C
ATOM    837  O   LYS U  88     -21.201  31.953  72.462 -0.55  1.40    -0.271 OA
ATOM    838  CB  LYS U  88     -23.403  30.235  71.629 -0.00  2.00     0.035 C
ATOM    839  CG  LYS U  88     -24.281  29.038  71.296 -0.03  2.00     0.004 C
ATOM    840  CD  LYS U  88     -25.665  29.167  71.909 -0.01  2.00     0.027 C
ATOM    841  CE  LYS U  88     -26.601  29.951  71.005  0.15  2.00     0.229 C
ATOM    842  NZ  LYS U  88     -27.998  29.944  71.521 -0.32  2.00    -0.079 N
ATOM    843  H   LYS U  88     -21.156  29.017  72.921  0.40  1.00     0.163 HD
ATOM    844  HZ1 LYS U  88     -28.252  29.012  71.776  0.33  0.00     0.274 HD
ATOM    845  HZ2 LYS U  88     -28.058  30.539  72.322  0.33  0.00     0.274 HD
ATOM    846  HZ3 LYS U  88     -28.616  30.277  70.809  0.33  0.00     0.274 HD
ATOM    847  N   LEU U  89     -20.451  31.801  70.337 -0.40  1.50    -0.346 N
ATOM    848  CA  LEU U  89     -19.587  32.974  70.406  0.18  2.00     0.177 C
ATOM    849  C   LEU U  89     -20.274  34.136  69.697  0.55  1.70     0.241 C
ATOM    850  O   LEU U  89     -20.422  34.124  68.471 -0.55  1.40    -0.271 OA
ATOM    851  CB  LEU U  89     -18.225  32.683  69.778  0.00  2.00     0.038 C
ATOM    852  CG  LEU U  89     -17.443  31.484  70.316 -0.02  2.00    -0.020 C
ATOM    853  CD1 LEU U  89     -16.114  31.346  69.590 -0.05  2.00     0.009 C
ATOM    854  CD2 LEU U  89     -17.225  31.612  71.813 -0.05  2.00     0.009 C
ATOM    855  H   LEU U  89     -20.562  31.226  69.470  0.40  1.00     0.163 HD
ATOM    856  N   LYS U  90     -20.694  35.133  70.470 -0.40  1.50    -0.346 N
ATOM    857  CA  LYS U  90     -21.231  36.355  69.888  0.18  2.00     0.176 C
ATOM    858  C   LYS U  90     -20.093  37.183  69.306  0.55  1.70     0.241 C
ATOM    859  O   LYS U  90     -19.088  37.432  69.979 -0.55  1.40    -0.271 OA
ATOM    860  CB  LYS U  90     -21.990  37.156  70.944 -0.00  2.00     0.035 C
ATOM    861  CG  LYS U  90     -23.177  37.940  70.409 -0.03  2.00     0.004 C
ATOM    862  CD  LYS U  90     -24.005  38.518  71.547 -0.01  2.00     0.027 C
ATOM    863  CE  LYS U  90     -25.345  39.037  71.053  0.15  2.00     0.229 C
ATOM    864  NZ  LYS U  90     -26.228  39.447  72.181 -0.32  2.00    -0.079 N
ATOM    865  H   LYS U  90     -20.608  34.968  71.486  0.40  1.00     0.163 HD
ATOM    866  HZ1 LYS U  90     -26.305  38.693  72.832  0.33  0.00     0.274 HD
ATOM    867  HZ2 LYS U  90     -25.834  40.245  72.636  0.33  0.00     0.274 HD
ATOM    868  HZ3 LYS U  90     -27.133  39.677  71.826  0.33  0.00     0.274 HD
ATOM    869  N   VAL U  91     -20.244  37.605  68.052 -0.40  1.50    -0.346 N
ATOM    870  CA  VAL U  91     -19.193  38.332  67.355  0.18  2.00     0.180 C
ATOM    871  C   VAL U  91     -19.715  39.699  66.932  0.55  1.70     0.241 C
ATOM    872  O   VAL U  91     -20.920  39.964  66.930 -0.55  1.40    -0.271 OA
ATOM    873  CB  VAL U  91     -18.655  37.554  66.137  0.01  2.00     0.009 C
ATOM    874  CG1 VAL U  91     -17.792  36.387  66.598 -0.04  2.00     0.012 C
ATOM    875  CG2 VAL U  91     -19.802  37.068  65.267 -0.04  2.00     0.012 C
ATOM    876  H   VAL U  91     -21.163  37.373  67.624  0.40  1.00     0.163 HD
ATOM    877  N   ASP U  92     -18.775  40.571  66.563 -0.40  1.50    -0.345 N
ATOM    878  CA  ASP U  92     -19.097  41.962  66.265  0.19  2.00     0.186 C
ATOM    879  C   ASP U  92     -19.813  42.133  64.931  0.55  1.70     0.241 C
ATOM    880  O   ASP U  92     -20.446  43.172  64.713 -0.55  1.40    -0.271 OA
ATOM    881  CB  ASP U  92     -17.816  42.800  66.282  0.10  2.00     0.147 C
ATOM    882  CG  ASP U  92     -18.082  44.282  66.104  0.10  1.70     0.175 C
ATOM    883  OD1 ASP U  92     -18.456  44.945  67.094 -0.55  1.40    -0.648 OA
ATOM    884  OD2 ASP U  92     -17.917  44.784  64.971 -0.55  1.40    -0.648 OA
ATOM    885  H   ASP U  92     -17.816  40.179  66.509  0.40  1.00     0.163 HD
ATOM    886  N   THR U  93     -19.741  41.146  64.042 -0.40  1.50    -0.344 N
ATOM    887  CA  THR U  93     -20.267  41.272  62.689  0.20  2.00     0.205 C
ATOM    888  C   THR U  93     -21.298  40.186  62.421  0.55  1.70     0.243 C
ATOM    889  O   THR U  93     -21.081  39.019  62.764 -0.55  1.40    -0.271 OA
ATOM    890  CB  THR U  93     -19.142  41.188  61.653  0.15  2.00     0.146 C
ATOM    891  OG1 THR U  93     -17.981  41.863  62.151 -0.49  1.40    -0.393 OA
ATOM    892  CG2 THR U  93     -19.574  41.829  60.342 -0.02  2.00     0.042 C
ATOM    893  H   THR U  93     -19.278  40.280  64.396  0.40  1.00     0.163 HD
ATOM    894  HG1 THR U  93     -18.239  42.520  62.867  0.49  1.00     0.210 HD
ATOM    895  N   ALA U  94     -22.416  40.574  61.812 -0.40  1.50    -0.346 N
ATOM    896  CA  ALA U  94     -23.384  39.608  61.318  0.17  2.00     0.172 C
ATOM    897  C   ALA U  94     -22.932  39.095  59.958  0.55  1.70     0.240 C
ATOM    898  O   ALA U  94     -22.536  39.880  59.092 -0.55  1.40    -0.271 OA
ATOM    899  CB  ALA U  94     -24.773  40.237  61.218 -0.02  2.00     0.042 C
ATOM    900  H   ALA U  94     -22.531  41.601  61.724  0.40  1.00     0.163 HD
ATOM    901  N   ASN U  95     -22.978  37.777  59.777 -0.40  1.50    -0.346 N
ATOM    902  CA  ASN U  95     -22.552  37.160  58.527  0.19  2.00     0.185 C
ATOM    903  C   ASN U  95     -23.452  37.626  57.389  0.55  1.70     0.243 C
ATOM    904  O   ASN U  95     -24.653  37.326  57.383 -0.55  1.40    -0.271 OA
ATOM    905  CB  ASN U  95     -22.572  35.634  58.650  0.09  2.00     0.137 C
ATOM    906  CG  ASN U  95     -21.926  34.936  57.464  0.55  1.70     0.217 C
ATOM    907  H   ASN U  95     -23.337  37.239  60.589  0.40  1.00     0.163 HD
ATOM    908  OD1 ASN U  95     -21.591  35.563  56.459 -0.55  1.40    -0.274 OA
ATOM    909  ND2 ASN U  95     -21.754  33.625  57.578 -0.78  1.50    -0.370 N
ATOM    910 1HD2 ASN U  95     -22.049  33.150  58.408  0.39  1.00     0.159 HD
ATOM    911 2HD2 ASN U  95     -21.329  33.108  56.834  0.39  1.00     0.159 HD
ATOM    912  N   PRO U  96     -22.914  38.362  56.412 -0.56  1.50    -0.337 N
ATOM    913  CA  PRO U  96     -23.755  38.820  55.295  0.18  2.00     0.179 C
ATOM    914  C   PRO U  96     -24.223  37.695  54.392  0.55  1.70     0.241 C
ATOM    915  O   PRO U  96     -25.225  37.868  53.687 -0.55  1.40    -0.271 OA
ATOM    916  CB  PRO U  96     -22.840  39.796  54.544  0.00  2.00     0.037 C
ATOM    917  CG  PRO U  96     -21.459  39.322  54.857 -0.01  2.00     0.022 C
ATOM    918  CD  PRO U  96     -21.512  38.793  56.265  0.06  2.00     0.127 C
ATOM    919  N   LYS U  97     -23.537  36.555  54.387 -0.40  1.50    -0.346 N
ATOM    920  CA  LYS U  97     -23.938  35.402  53.596  0.18  2.00     0.176 C
ATOM    921  C   LYS U  97     -24.868  34.462  54.351  0.55  1.70     0.241 C
ATOM    922  O   LYS U  97     -25.065  33.325  53.911 -0.55  1.40    -0.271 OA
ATOM    923  CB  LYS U  97     -22.704  34.628  53.123 -0.00  2.00     0.035 C
ATOM    924  CG  LYS U  97     -21.662  35.472  52.411 -0.03  2.00     0.004 C
ATOM    925  CD  LYS U  97     -20.651  34.588  51.697 -0.01  2.00     0.027 C
ATOM    926  CE  LYS U  97     -19.319  35.297  51.519  0.15  2.00     0.229 C
ATOM    927  NZ  LYS U  97     -18.351  34.464  50.753 -0.32  2.00    -0.079 N
ATOM    928  H   LYS U  97     -22.689  36.562  54.999  0.40  1.00     0.163 HD
ATOM    929  HZ1 LYS U  97     -17.712  35.060  50.268  0.33  0.00     0.274 HD
ATOM    930  HZ2 LYS U  97     -17.847  33.876  51.385  0.33  0.00     0.274 HD
ATOM    931  HZ3 LYS U  97     -18.848  33.900  50.094  0.33  0.00     0.274 HD
ATOM    932  N   THR U  98     -25.435  34.903  55.468 -0.40  1.50    -0.344 N
ATOM    933  CA  THR U  98     -26.312  34.054  56.263  0.20  2.00     0.205 C
ATOM    934  C   THR U  98     -27.555  33.682  55.465  0.55  1.70     0.245 C
ATOM    935  O   THR U  98     -28.349  34.570  55.120 -0.55  1.40    -0.271 OA
ATOM    936  CB  THR U  98     -26.728  34.751  57.556  0.15  2.00     0.146 C
ATOM    937  OG1 THR U  98     -25.574  34.995  58.365 -0.49  1.40    -0.393 OA
ATOM    938  CG2 THR U  98     -27.706  33.882  58.333 -0.02  2.00     0.042 C
ATOM    939  H   THR U  98     -25.204  35.883  55.719  0.40  1.00     0.163 HD
ATOM    940  HG1 THR U  98     -25.113  35.840  58.073  0.49  1.00     0.210 HD
ATOM    941  N   PRO U  99     -27.766  32.410  55.155 -0.56  1.50    -0.337 N
ATOM    942  CA  PRO U  99     -29.005  32.004  54.492  0.18  2.00     0.179 C
ATOM    943  C   PRO U  99     -30.127  31.867  55.511  0.55  1.70     0.241 C
ATOM    944  O   PRO U  99     -29.914  31.905  56.724 -0.55  1.40    -0.271 OA
ATOM    945  CB  PRO U  99     -28.640  30.650  53.883  0.00  2.00     0.037 C
ATOM    946  CG  PRO U  99     -27.665  30.080  54.873 -0.01  2.00     0.022 C
ATOM    947  CD  PRO U  99     -26.901  31.254  55.452  0.06  2.00     0.127 C
ATOM    948  N   LYS U 100     -31.343  31.718  54.996 -0.40  1.50    -0.346 N
ATOM    949  CA  LYS U 100     -32.447  31.325  55.856  0.18  2.00     0.176 C
ATOM    950  C   LYS U 100     -32.197  29.902  56.336  0.55  1.70     0.241 C
ATOM    951  O   LYS U 100     -31.913  29.008  55.533 -0.55  1.40    -0.271 OA
ATOM    952  CB  LYS U 100     -33.777  31.423  55.113 -0.00  2.00     0.035 C
ATOM    953  CG  LYS U 100     -34.989  31.181  55.998 -0.03  2.00     0.004 C
ATOM    954  CD  LYS U 100     -36.118  30.512  55.235 -0.01  2.00     0.027 C
ATOM    955  CE  LYS U 100     -37.472  30.904  55.803  0.15  2.00     0.229 C
ATOM    956  NZ  LYS U 100     -38.084  29.783  56.571 -0.32  2.00    -0.079 N
ATOM    957  H   LYS U 100     -31.425  31.897  53.989  0.40  1.00     0.163 HD
ATOM    958  HZ1 LYS U 100     -38.087  28.958  56.007  0.33  0.00     0.274 HD
ATOM    959  HZ2 LYS U 100     -37.550  29.620  57.400  0.33  0.00     0.274 HD
ATOM    960  HZ3 LYS U 100     -39.022  30.024  56.817  0.33  0.00     0.274 HD
ATOM    961  N   TYR U 101     -32.267  29.692  57.647 -0.40  1.50    -0.346 N
ATOM    962  CA  TYR U 101     -31.842  28.424  58.217  0.18  2.00     0.180 C
ATOM    963  C   TYR U 101     -32.766  28.016  59.353  0.55  1.70     0.241 C
ATOM    964  O   TYR U 101     -33.559  28.809  59.867 -0.55  1.40    -0.271 OA
ATOM    965  CB  TYR U 101     -30.390  28.492  58.709  0.03  2.00     0.073 C
ATOM    966  CG  TYR U 101     -30.181  29.414  59.891 -0.12  1.70    -0.056 A
ATOM    967  CD1 TYR U 101     -29.935  30.768  59.704  0.01  1.70     0.010 A
ATOM    968  CD2 TYR U 101     -30.223  28.929  61.193  0.01  1.70     0.010 A
ATOM    969  CE1 TYR U 101     -29.742  31.614  60.779  0.04  1.70     0.037 A
ATOM    970  CE2 TYR U 101     -30.032  29.768  62.274  0.04  1.70     0.037 A
ATOM    971  CZ  TYR U 101     -29.791  31.108  62.062  0.06  1.70     0.065 A
ATOM    972  OH  TYR U 101     -29.599  31.947  63.136 -0.49  1.40    -0.361 OA
ATOM    973  H   TYR U 101     -32.636  30.481  58.201  0.40  1.00     0.163 HD
ATOM    974  HH  TYR U 101     -29.512  32.886  62.807  0.43  1.00     0.217 HD
ATOM    975  N   LYS U 102     -32.647  26.746  59.734 -0.40  1.50    -0.346 N
ATOM    976  CA  LYS U 102     -33.343  26.180  60.877  0.18  2.00     0.176 C
ATOM    977  C   LYS U 102     -32.405  25.213  61.582  0.55  1.70     0.241 C
ATOM    978  O   LYS U 102     -31.485  24.664  60.972 -0.55  1.40    -0.271 OA
ATOM    979  CB  LYS U 102     -34.628  25.446  60.464 -0.00  2.00     0.035 C
ATOM    980  CG  LYS U 102     -35.760  26.352  60.011 -0.03  2.00     0.004 C
ATOM    981  CD  LYS U 102     -37.092  25.614  60.025 -0.01  2.00     0.027 C
ATOM    982  CE  LYS U 102     -37.465  25.108  58.640  0.15  2.00     0.229 C
ATOM    983  NZ  LYS U 102     -36.684  23.899  58.253 -0.32  2.00    -0.079 N
ATOM    984  H   LYS U 102     -31.997  26.182  59.127  0.40  1.00     0.163 HD
ATOM    985  HZ1 LYS U 102     -37.309  23.132  58.116  0.33  0.00     0.274 HD
ATOM    986  HZ2 LYS U 102     -36.188  24.083  57.406  0.33  0.00     0.274 HD
ATOM    987  HZ3 LYS U 102     -36.036  23.678  58.980  0.33  0.00     0.274 HD
ATOM    988  N   PHE U 103     -32.639  25.016  62.876 -0.40  1.50    -0.346 N
ATOM    989  CA  PHE U 103     -31.916  24.031  63.672  0.18  2.00     0.180 C
ATOM    990  C   PHE U 103     -32.868  22.876  63.951  0.55  1.70     0.241 C
ATOM    991  O   PHE U 103     -33.804  23.015  64.745 -0.55  1.40    -0.271 OA
ATOM    992  CB  PHE U 103     -31.397  24.641  64.973  0.03  2.00     0.073 C
ATOM    993  CG  PHE U 103     -30.156  25.473  64.804 -0.12  1.70    -0.056 A
ATOM    994  CD1 PHE U 103     -29.508  25.539  63.583  0.01  1.70     0.007 A
ATOM    995  CD2 PHE U 103     -29.635  26.186  65.873  0.01  1.70     0.007 A
ATOM    996  CE1 PHE U 103     -28.366  26.303  63.428  0.00  1.70     0.001 A
ATOM    997  CE2 PHE U 103     -28.494  26.951  65.725  0.00  1.70     0.001 A
ATOM    998  CZ  PHE U 103     -27.858  27.010  64.501  0.00  1.70     0.000 A
ATOM    999  H   PHE U 103     -33.388  25.630  63.275  0.40  1.00     0.163 HD
ATOM   1000  N   VAL U 104     -32.639  21.743  63.295 -0.40  1.50    -0.346 N
ATOM   1001  CA  VAL U 104     -33.501  20.580  63.455  0.18  2.00     0.180 C
ATOM   1002  C   VAL U 104     -32.669  19.403  63.943  0.55  1.70     0.241 C
ATOM   1003  O   VAL U 104     -31.476  19.285  63.645 -0.55  1.40    -0.271 OA
ATOM   1004  CB  VAL U 104     -34.243  20.218  62.148  0.01  2.00     0.009 C
ATOM   1005  CG1 VAL U 104     -34.967  21.437  61.592 -0.04  2.00     0.012 C
ATOM   1006  CG2 VAL U 104     -33.279  19.645  61.119 -0.04  2.00     0.012 C
ATOM   1007  H   VAL U 104     -31.809  21.760  62.672  0.40  1.00     0.163 HD
ATOM   1008  N   ARG U 105     -33.310  18.537  64.720 -0.40  1.50    -0.346 N
ATOM   1009  CA  ARG U 105     -32.716  17.283  65.158  0.18  2.00     0.176 C
ATOM   1010  C   ARG U 105     -33.377  16.153  64.381  0.55  1.70     0.241 C
ATOM   1011  O   ARG U 105     -34.589  15.941  64.495 -0.55  1.40    -0.271 OA
ATOM   1012  CB  ARG U 105     -32.889  17.086  66.664  0.00  2.00     0.036 C
ATOM   1013  CG  ARG U 105     -32.252  15.817  67.206 -0.01  2.00     0.023 C
ATOM   1014  CD  ARG U 105     -32.393  15.729  68.718  0.07  2.00     0.138 C
ATOM   1015  NE  ARG U 105     -31.731  14.547  69.267 -0.35  1.50    -0.227 N
ATOM   1016  CZ  ARG U 105     -30.480  14.532  69.716  0.35  1.70     0.665 C
ATOM   1017  NH1 ARG U 105     -29.748  15.638  69.683 -0.70  1.50    -0.235 N
ATOM   1018  NH2 ARG U 105     -29.959  13.412  70.199 -0.70  1.50    -0.235 N
ATOM   1019  H   ARG U 105     -34.277  18.835  64.989  0.40  1.00     0.163 HD
ATOM   1020  HE  ARG U 105     -32.257  13.690  69.307  0.45  1.00     0.177 HD
ATOM   1021 1HH1 ARG U 105     -30.123  16.496  69.344  0.40  1.00     0.174 HD
ATOM   1022 2HH1 ARG U 105     -28.794  15.611  70.008  0.40  1.00     0.174 HD
ATOM   1023 1HH2 ARG U 105     -30.523  12.582  70.241  0.40  1.00     0.174 HD
ATOM   1024 2HH2 ARG U 105     -29.016  13.392  70.520  0.40  1.00     0.174 HD
ATOM   1025  N   ILE U 106     -32.584  15.441  63.587 -0.40  1.50    -0.346 N
ATOM   1026  CA  ILE U 106     -33.120  14.410  62.707  0.18  2.00     0.180 C
ATOM   1027  C   ILE U 106     -33.326  13.118  63.484  0.55  1.70     0.241 C
ATOM   1028  O   ILE U 106     -32.914  13.000  64.644 -0.55  1.40    -0.271 OA
ATOM   1029  CB  ILE U 106     -32.201  14.192  61.492  0.01  2.00     0.013 C
ATOM   1030  CG1 ILE U 106     -30.825  13.704  61.946 -0.03  2.00     0.002 C
ATOM   1031  CG2 ILE U 106     -32.072  15.474  60.686 -0.04  2.00     0.012 C
ATOM   1032  CD1 ILE U 106     -30.830  12.308  62.499 -0.05  2.00     0.005 C
ATOM   1033  H   ILE U 106     -31.577  15.678  63.647  0.40  1.00     0.163 HD
ATOM   1034  N   GLN U 107     -33.961  12.151  62.849 -0.40  1.50    -0.346 N
ATOM   1035  CA  GLN U 107     -34.263  10.844  63.402  0.18  2.00     0.177 C
ATOM   1036  C   GLN U 107     -33.318   9.796  62.837  0.55  1.70     0.243 C
ATOM   1037  O   GLN U 107     -32.727   9.986  61.770 -0.55  1.40    -0.271 OA
ATOM   1038  CB  GLN U 107     -35.711  10.456  63.080  0.01  2.00     0.044 C
ATOM   1039  CG  GLN U 107     -36.752  11.168  63.925  0.06  2.00     0.105 C
ATOM   1040  CD  GLN U 107     -36.793  10.647  65.347  0.55  1.70     0.215 C
ATOM   1041  H   GLN U 107     -34.245  12.419  61.857  0.40  1.00     0.163 HD
ATOM   1042  OE1 GLN U 107     -36.614   9.454  65.587 -0.55  1.40    -0.274 OA
ATOM   1043  NE2 GLN U 107     -37.030  11.542  66.299 -0.78  1.50    -0.370 N
ATOM   1044 1HE2 GLN U 107     -37.086  11.264  67.276  0.39  1.00     0.159 HD
ATOM   1045 2HE2 GLN U 107     -37.155  12.519  66.035  0.39  1.00     0.159 HD
ATOM   1046  N   PRO U 108     -33.136   8.678  63.540 -0.56  1.50    -0.337 N
ATOM   1047  CA  PRO U 108     -32.407   7.553  62.945  0.18  2.00     0.179 C
ATOM   1048  C   PRO U 108     -33.084   7.093  61.663  0.55  1.70     0.241 C
ATOM   1049  O   PRO U 108     -34.312   7.033  61.573 -0.55  1.40    -0.271 OA
ATOM   1050  CB  PRO U 108     -32.466   6.477  64.034  0.00  2.00     0.037 C
ATOM   1051  CG  PRO U 108     -32.630   7.241  65.303 -0.01  2.00     0.022 C
ATOM   1052  CD  PRO U 108     -33.472   8.435  64.954  0.06  2.00     0.127 C
ATOM   1053  N   GLY U 109     -32.267   6.778  60.660 -0.40  1.50    -0.351 N
ATOM   1054  CA  GLY U 109     -32.757   6.413  59.353  0.15  2.00     0.225 C
ATOM   1055  C   GLY U 109     -32.860   7.561  58.373  0.55  1.70     0.236 C
ATOM   1056  O   GLY U 109     -32.925   7.320  57.161 -0.55  1.40    -0.272 OA
ATOM   1057  H   GLY U 109     -31.252   6.820  60.907  0.40  1.00     0.163 HD
ATOM   1058  N   GLN U 110     -32.882   8.799  58.858 -0.40  1.50    -0.346 N
ATOM   1059  CA  GLN U 110     -32.911   9.958  57.984  0.18  2.00     0.177 C
ATOM   1060  C   GLN U 110     -31.503  10.294  57.503  0.55  1.70     0.241 C
ATOM   1061  O   GLN U 110     -30.500   9.919  58.116 -0.55  1.40    -0.271 OA
ATOM   1062  CB  GLN U 110     -33.526  11.160  58.700  0.01  2.00     0.044 C
ATOM   1063  CG  GLN U 110     -35.021  11.034  58.939  0.06  2.00     0.105 C
ATOM   1064  CD  GLN U 110     -35.781  10.671  57.679  0.55  1.70     0.215 C
ATOM   1065  H   GLN U 110     -32.877   8.859  59.895  0.40  1.00     0.163 HD
ATOM   1066  OE1 GLN U 110     -36.293   9.559  57.548 -0.55  1.40    -0.274 OA
ATOM   1067  NE2 GLN U 110     -35.857  11.610  56.743 -0.78  1.50    -0.370 N
ATOM   1068 1HE2 GLN U 110     -36.339  11.435  55.864  0.39  1.00     0.159 HD
ATOM   1069 2HE2 GLN U 110     -35.423  12.515  56.918  0.39  1.00     0.159 HD
ATOM   1070  N   THR U 111     -31.438  11.013  56.388 -0.40  1.50    -0.344 N
ATOM   1071  CA  THR U 111     -30.174  11.341  55.749  0.20  2.00     0.205 C
ATOM   1072  C   THR U 111     -29.918  12.841  55.794  0.55  1.70     0.243 C
ATOM   1073  O   THR U 111     -30.797  13.645  56.118 -0.55  1.40    -0.271 OA
ATOM   1074  CB  THR U 111     -30.151  10.848  54.298  0.15  2.00     0.146 C
ATOM   1075  OG1 THR U 111     -31.279  11.377  53.591 -0.49  1.40    -0.393 OA
ATOM   1076  CG2 THR U 111     -30.191   9.330  54.253 -0.02  2.00     0.042 C
ATOM   1077  H   THR U 111     -32.364  11.318  56.016  0.40  1.00     0.163 HD
ATOM   1078  HG1 THR U 111     -31.501  10.795  52.801  0.49  1.00     0.210 HD
ATOM   1079  N   PHE U 112     -28.683  13.202  55.458 -0.40  1.50    -0.346 N
ATOM   1080  CA  PHE U 112     -28.249  14.590  55.396  0.18  2.00     0.180 C
ATOM   1081  C   PHE U 112     -26.898  14.635  54.701  0.55  1.70     0.241 C
ATOM   1082  O   PHE U 112     -26.188  13.628  54.618 -0.55  1.40    -0.271 OA
ATOM   1083  CB  PHE U 112     -28.162  15.227  56.788  0.03  2.00     0.073 C
ATOM   1084  CG  PHE U 112     -27.238  14.509  57.732 -0.12  1.70    -0.056 A
ATOM   1085  CD1 PHE U 112     -27.672  13.402  58.442  0.01  1.70     0.007 A
ATOM   1086  CD2 PHE U 112     -25.937  14.949  57.918  0.01  1.70     0.007 A
ATOM   1087  CE1 PHE U 112     -26.826  12.742  59.313  0.00  1.70     0.001 A
ATOM   1088  CE2 PHE U 112     -25.087  14.293  58.788  0.00  1.70     0.001 A
ATOM   1089  CZ  PHE U 112     -25.532  13.188  59.486  0.00  1.70     0.000 A
ATOM   1090  H   PHE U 112     -28.047  12.396  55.241  0.40  1.00     0.163 HD
ATOM   1091  N   SER U 113     -26.554  15.817  54.203 -0.40  1.50    -0.344 N
ATOM   1092  CA  SER U 113     -25.286  16.046  53.527  0.20  2.00     0.200 C
ATOM   1093  C   SER U 113     -24.273  16.620  54.508  0.55  1.70     0.243 C
ATOM   1094  O   SER U 113     -24.619  17.427  55.374 -0.55  1.40    -0.271 OA
ATOM   1095  CB  SER U 113     -25.460  16.995  52.340  0.12  2.00     0.199 C
ATOM   1096  OG  SER U 113     -26.449  16.512  51.449 -0.49  1.40    -0.398 OA
ATOM   1097  H   SER U 113     -27.272  16.566  54.339  0.40  1.00     0.163 HD
ATOM   1098  HG  SER U 113     -27.355  16.658  51.845  0.49  1.00     0.209 HD
ATOM   1099  N   VAL U 114     -23.020  16.198  54.367 -0.40  1.50    -0.346 N
ATOM   1100  CA  VAL U 114     -21.937  16.611  55.249  0.18  2.00     0.180 C
ATOM   1101  C   VAL U 114     -20.945  17.436  54.444  0.55  1.70     0.241 C
ATOM   1102  O   VAL U 114     -20.467  16.992  53.395 -0.55  1.40    -0.271 OA
ATOM   1103  CB  VAL U 114     -21.241  15.399  55.891  0.01  2.00     0.009 C
ATOM   1104  CG1 VAL U 114     -19.953  15.834  56.583 -0.04  2.00     0.012 C
ATOM   1105  CG2 VAL U 114     -22.173  14.711  56.873 -0.04  2.00     0.012 C
ATOM   1106  H   VAL U 114     -22.879  15.540  53.563  0.40  1.00     0.163 HD
ATOM   1107  N   LEU U 115     -20.638  18.631  54.934 -0.40  1.50    -0.346 N
ATOM   1108  CA  LEU U 115     -19.599  19.477  54.354  0.18  2.00     0.177 C
ATOM   1109  C   LEU U 115     -18.365  19.348  55.243  0.55  1.70     0.241 C
ATOM   1110  O   LEU U 115     -18.268  19.997  56.286 -0.55  1.40    -0.271 OA
ATOM   1111  CB  LEU U 115     -20.062  20.926  54.246  0.00  2.00     0.038 C
ATOM   1112  CG  LEU U 115     -18.982  21.877  53.731 -0.02  2.00    -0.020 C
ATOM   1113  CD1 LEU U 115     -18.587  21.434  52.340 -0.05  2.00     0.009 C
ATOM   1114  CD2 LEU U 115     -19.451  23.325  53.720 -0.05  2.00     0.009 C
ATOM   1115  H   LEU U 115     -21.201  18.914  55.768  0.40  1.00     0.163 HD
ATOM   1116  N   ALA U 116     -17.429  18.494  54.841 -0.40  1.50    -0.346 N
ATOM   1117  CA  ALA U 116     -16.209  18.305  55.616  0.17  2.00     0.172 C
ATOM   1118  C   ALA U 116     -15.293  19.509  55.429  0.55  1.70     0.240 C
ATOM   1119  O   ALA U 116     -14.879  19.816  54.306 -0.55  1.40    -0.271 OA
ATOM   1120  CB  ALA U 116     -15.506  17.018  55.194 -0.02  2.00     0.042 C
ATOM   1121  H   ALA U 116     -17.636  17.994  53.962  0.40  1.00     0.163 HD
ATOM   1122  N   CYS U 117     -14.976  20.189  56.527 -0.40  1.50    -0.345 N
ATOM   1123  CA  CYS U 117     -14.143  21.380  56.496  0.19  2.00     0.185 C
ATOM   1124  C   CYS U 117     -12.897  21.176  57.345  0.55  1.70     0.241 C
ATOM   1125  O   CYS U 117     -12.895  20.398  58.304 -0.55  1.40    -0.271 OA
ATOM   1126  CB  CYS U 117     -14.908  22.610  56.999  0.05  2.00     0.105 C
ATOM   1127  SG  CYS U 117     -16.563  22.801  56.305 -0.29  1.85    -0.180 SA
ATOM   1128  H   CYS U 117     -15.376  19.794  57.408  0.40  1.00     0.163 HD
ATOM   1129  HG  CYS U 117     -17.047  21.927  56.349  0.29  1.00     0.101 HD
ATOM   1130  N   TYR U 118     -11.833  21.886  56.978 -0.40  1.50    -0.346 N
ATOM   1131  CA  TYR U 118     -10.576  21.862  57.717  0.18  2.00     0.180 C
ATOM   1132  C   TYR U 118     -10.033  23.280  57.770  0.55  1.70     0.241 C
ATOM   1133  O   TYR U 118      -9.813  23.898  56.723 -0.55  1.40    -0.271 OA
ATOM   1134  CB  TYR U 118      -9.566  20.912  57.064  0.03  2.00     0.073 C
ATOM   1135  CG  TYR U 118      -9.998  19.462  57.089 -0.12  1.70    -0.056 A
ATOM   1136  CD1 TYR U 118     -10.765  18.928  56.060  0.01  1.70     0.010 A
ATOM   1137  CD2 TYR U 118      -9.644  18.629  58.142  0.01  1.70     0.010 A
ATOM   1138  CE1 TYR U 118     -11.166  17.606  56.080  0.04  1.70     0.037 A
ATOM   1139  CE2 TYR U 118     -10.039  17.304  58.170  0.04  1.70     0.037 A
ATOM   1140  CZ  TYR U 118     -10.800  16.798  57.136  0.06  1.70     0.065 A
ATOM   1141  OH  TYR U 118     -11.196  15.481  57.160 -0.49  1.40    -0.361 OA
ATOM   1142  H   TYR U 118     -11.976  22.461  56.116  0.40  1.00     0.163 HD
ATOM   1143  HH  TYR U 118     -10.496  14.936  57.619  0.43  1.00     0.217 HD
ATOM   1144  N   ASN U 119      -9.826  23.791  58.986 -0.40  1.50    -0.346 N
ATOM   1145  CA  ASN U 119      -9.350  25.159  59.202  0.18  2.00     0.185 C
ATOM   1146  C   ASN U 119     -10.291  26.181  58.567  0.55  1.70     0.241 C
ATOM   1147  O   ASN U 119      -9.857  27.147  57.936 -0.55  1.40    -0.271 OA
ATOM   1148  CB  ASN U 119      -7.920  25.337  58.687  0.09  2.00     0.137 C
ATOM   1149  CG  ASN U 119      -6.915  24.506  59.460  0.55  1.70     0.217 C
ATOM   1150  H   ASN U 119     -10.033  23.131  59.769  0.40  1.00     0.163 HD
ATOM   1151  OD1 ASN U 119      -6.614  23.372  59.090 -0.55  1.40    -0.274 OA
ATOM   1152  ND2 ASN U 119      -6.392  25.069  60.544 -0.78  1.50    -0.370 N
ATOM   1153 1HD2 ASN U 119      -6.673  25.992  60.812  0.39  1.00     0.159 HD
ATOM   1154 2HD2 ASN U 119      -5.720  24.573  61.092  0.39  1.00     0.159 HD
ATOM   1155  N   GLY U 120     -11.594  25.964  58.736 -0.40  1.50    -0.351 N
ATOM   1156  CA  GLY U 120     -12.598  26.855  58.194  0.15  2.00     0.225 C
ATOM   1157  C   GLY U 120     -12.758  26.823  56.691  0.55  1.70     0.236 C
ATOM   1158  O   GLY U 120     -13.523  27.632  56.153 -0.55  1.40    -0.272 OA
ATOM   1159  H   GLY U 120     -11.819  25.107  59.286  0.40  1.00     0.163 HD
ATOM   1160  N   SER U 121     -12.073  25.920  55.994 -0.40  1.50    -0.344 N
ATOM   1161  CA  SER U 121     -12.134  25.844  54.539  0.20  2.00     0.200 C
ATOM   1162  C   SER U 121     -12.780  24.531  54.120  0.55  1.70     0.245 C
ATOM   1163  O   SER U 121     -12.235  23.454  54.418 -0.55  1.40    -0.271 OA
ATOM   1164  CB  SER U 121     -10.737  25.972  53.929  0.12  2.00     0.199 C
ATOM   1165  OG  SER U 121     -10.804  26.471  52.605 -0.49  1.40    -0.398 OA
ATOM   1166  H   SER U 121     -11.493  25.276  56.575  0.40  1.00     0.163 HD
ATOM   1167  HG  SER U 121     -11.341  25.846  52.040  0.49  1.00     0.209 HD
ATOM   1168  N   PRO U 122     -13.928  24.561  53.445 -0.56  1.50    -0.337 N
ATOM   1169  CA  PRO U 122     -14.554  23.310  52.997  0.18  2.00     0.179 C
ATOM   1170  C   PRO U 122     -13.688  22.585  51.977  0.55  1.70     0.241 C
ATOM   1171  O   PRO U 122     -13.072  23.202  51.104 -0.55  1.40    -0.271 OA
ATOM   1172  CB  PRO U 122     -15.877  23.779  52.379  0.00  2.00     0.037 C
ATOM   1173  CG  PRO U 122     -16.126  25.132  52.974 -0.01  2.00     0.022 C
ATOM   1174  CD  PRO U 122     -14.771  25.736  53.169  0.06  2.00     0.127 C
ATOM   1175  N   SER U 123     -13.646  21.256  52.093 -0.40  1.50    -0.344 N
ATOM   1176  CA  SER U 123     -12.852  20.428  51.199  0.20  2.00     0.200 C
ATOM   1177  C   SER U 123     -13.640  19.332  50.498  0.55  1.70     0.242 C
ATOM   1178  O   SER U 123     -13.140  18.779  49.512 -0.55  1.40    -0.271 OA
ATOM   1179  CB  SER U 123     -11.685  19.777  51.960  0.12  2.00     0.199 C
ATOM   1180  OG  SER U 123     -12.107  18.608  52.639 -0.49  1.40    -0.398 OA
ATOM   1181  H   SER U 123     -14.224  20.873  52.869  0.40  1.00     0.163 HD
ATOM   1182  HG  SER U 123     -12.935  18.807  53.162  0.49  1.00     0.209 HD
ATOM   1183  N   GLY U 124     -14.838  19.001  50.965 -0.40  1.50    -0.350 N
ATOM   1184  CA  GLY U 124     -15.622  17.959  50.331  0.15  2.00     0.225 C
ATOM   1185  C   GLY U 124     -17.024  17.915  50.891  0.55  1.70     0.236 C
ATOM   1186  O   GLY U 124     -17.290  18.400  51.996 -0.55  1.40    -0.272 OA
ATOM   1187  H   GLY U 124     -15.149  19.536  51.794  0.40  1.00     0.163 HD
ATOM   1188  N   VAL U 125     -17.922  17.321  50.108 -0.40  1.50    -0.346 N
ATOM   1189  CA  VAL U 125     -19.322  17.178  50.492  0.18  2.00     0.180 C
ATOM   1190  C   VAL U 125     -19.792  15.780  50.111  0.55  1.70     0.241 C
ATOM   1191  O   VAL U 125     -19.449  15.266  49.041 -0.55  1.40    -0.271 OA
ATOM   1192  CB  VAL U 125     -20.205  18.269  49.846  0.01  2.00     0.009 C
ATOM   1193  CG1 VAL U 125     -20.116  18.216  48.329 -0.04  2.00     0.012 C
ATOM   1194  CG2 VAL U 125     -21.649  18.144  50.315 -0.04  2.00     0.012 C
ATOM   1195  H   VAL U 125     -17.540  16.970  49.203  0.40  1.00     0.163 HD
ATOM   1196  N   TYR U 126     -20.561  15.155  51.001 -0.40  1.50    -0.346 N
ATOM   1197  CA  TYR U 126     -21.078  13.816  50.757  0.18  2.00     0.180 C
ATOM   1198  C   TYR U 126     -22.326  13.610  51.601  0.55  1.70     0.241 C
ATOM   1199  O   TYR U 126     -22.582  14.348  52.557 -0.55  1.40    -0.271 OA
ATOM   1200  CB  TYR U 126     -20.029  12.739  51.064  0.03  2.00     0.073 C
ATOM   1201  CG  TYR U 126     -19.484  12.790  52.475 -0.12  1.70    -0.056 A
ATOM   1202  CD1 TYR U 126     -18.368  13.557  52.782  0.01  1.70     0.010 A
ATOM   1203  CD2 TYR U 126     -20.084  12.070  53.500  0.01  1.70     0.010 A
ATOM   1204  CE1 TYR U 126     -17.866  13.607  54.069  0.04  1.70     0.037 A
ATOM   1205  CE2 TYR U 126     -19.589  12.115  54.789  0.04  1.70     0.037 A
ATOM   1206  CZ  TYR U 126     -18.481  12.884  55.068  0.06  1.70     0.065 A
ATOM   1207  OH  TYR U 126     -17.986  12.931  56.351 -0.49  1.40    -0.361 OA
ATOM   1208  H   TYR U 126     -20.754  15.697  51.865  0.40  1.00     0.163 HD
ATOM   1209  HH  TYR U 126     -18.747  13.009  56.993  0.43  1.00     0.217 HD
ATOM   1210  N   GLN U 127     -23.097  12.590  51.236 -0.40  1.50    -0.346 N
ATOM   1211  CA  GLN U 127     -24.341  12.272  51.923  0.18  2.00     0.177 C
ATOM   1212  C   GLN U 127     -24.090  11.281  53.053  0.55  1.70     0.241 C
ATOM   1213  O   GLN U 127     -23.270  10.367  52.926 -0.55  1.40    -0.271 OA
ATOM   1214  CB  GLN U 127     -25.365  11.701  50.940  0.01  2.00     0.044 C
ATOM   1215  CG  GLN U 127     -26.783  11.617  51.485  0.06  2.00     0.105 C
ATOM   1216  CD  GLN U 127     -27.555  12.914  51.326  0.55  1.70     0.215 C
ATOM   1217  H   GLN U 127     -22.736  12.044  50.424  0.40  1.00     0.163 HD
ATOM   1218  OE1 GLN U 127     -26.970  13.994  51.231 -0.55  1.40    -0.274 OA
ATOM   1219  NE2 GLN U 127     -28.879  12.813  51.296 -0.78  1.50    -0.370 N
ATOM   1220 1HE2 GLN U 127     -29.464  13.640  51.206  0.39  1.00     0.159 HD
ATOM   1221 2HE2 GLN U 127     -29.303  11.889  51.364  0.39  1.00     0.159 HD
ATOM   1222  N   CYS U 128     -24.805  11.471  54.160 -0.40  1.50    -0.345 N
ATOM   1223  CA  CYS U 128     -24.686  10.612  55.328  0.19  2.00     0.185 C
ATOM   1224  C   CYS U 128     -26.075  10.273  55.846  0.55  1.70     0.241 C
ATOM   1225  O   CYS U 128     -27.039  11.008  55.624 -0.55  1.40    -0.271 OA
ATOM   1226  CB  CYS U 128     -23.862  11.274  56.441  0.05  2.00     0.105 C
ATOM   1227  SG  CYS U 128     -22.145  10.732  56.529 -0.29  1.85    -0.180 SA
ATOM   1228  H   CYS U 128     -25.456  12.288  54.115  0.40  1.00     0.163 HD
ATOM   1229  HG  CYS U 128     -21.982  10.275  57.404  0.29  1.00     0.101 HD
ATOM   1230  N   ALA U 129     -26.166   9.147  56.549 -0.40  1.50    -0.346 N
ATOM   1231  CA  ALA U 129     -27.407   8.712  57.171  0.17  2.00     0.172 C
ATOM   1232  C   ALA U 129     -27.171   8.455  58.650  0.55  1.70     0.240 C
ATOM   1233  O   ALA U 129     -26.155   7.867  59.034 -0.55  1.40    -0.271 OA
ATOM   1234  CB  ALA U 129     -27.959   7.447  56.504 -0.02  2.00     0.042 C
ATOM   1235  H   ALA U 129     -25.274   8.607  56.614  0.40  1.00     0.163 HD
ATOM   1236  N   MET U 130     -28.110   8.903  59.478 -0.40  1.50    -0.346 N
ATOM   1237  CA  MET U 130     -28.039   8.638  60.908  0.18  2.00     0.177 C
ATOM   1238  C   MET U 130     -28.416   7.185  61.173  0.55  1.70     0.241 C
ATOM   1239  O   MET U 130     -29.550   6.772  60.908 -0.55  1.40    -0.271 OA
ATOM   1240  CB  MET U 130     -28.963   9.587  61.667  0.01  2.00     0.045 C
ATOM   1241  CG  MET U 130     -28.954   9.416  63.181  0.03  2.00     0.076 C
ATOM   1242  SD  MET U 130     -27.369   9.810  63.951 -0.53  1.85    -0.173 SA
ATOM   1243  CE  MET U 130     -27.092  11.482  63.378  0.01  2.00     0.089 C
ATOM   1244  H   MET U 130     -28.872   9.440  59.029  0.40  1.00     0.163 HD
ATOM   1245  N   ARG U 131     -27.462   6.409  61.682 -0.40  1.50    -0.346 N
ATOM   1246  CA  ARG U 131     -27.706   5.007  61.960  0.18  2.00     0.176 C
ATOM   1247  C   ARG U 131     -28.658   4.859  63.146  0.55  1.70     0.243 C
ATOM   1248  O   ARG U 131     -28.791   5.770  63.966 -0.55  1.40    -0.271 OA
ATOM   1249  CB  ARG U 131     -26.390   4.285  62.245  0.00  2.00     0.036 C
ATOM   1250  CG  ARG U 131     -25.361   4.385  61.129 -0.01  2.00     0.023 C
ATOM   1251  CD  ARG U 131     -25.937   3.938  59.800  0.07  2.00     0.138 C
ATOM   1252  NE  ARG U 131     -26.509   2.598  59.876 -0.35  1.50    -0.227 N
ATOM   1253  CZ  ARG U 131     -27.092   1.978  58.856  0.35  1.70     0.665 C
ATOM   1254  NH1 ARG U 131     -27.182   2.579  57.677 -0.70  1.50    -0.235 N
ATOM   1255  NH2 ARG U 131     -27.587   0.758  59.013 -0.70  1.50    -0.235 N
ATOM   1256  H   ARG U 131     -26.559   6.885  61.855  0.40  1.00     0.163 HD
ATOM   1257  HE  ARG U 131     -26.459   2.113  60.756  0.45  1.00     0.177 HD
ATOM   1258 1HH1 ARG U 131     -26.801   3.487  57.529  0.40  1.00     0.174 HD
ATOM   1259 2HH1 ARG U 131     -27.644   2.108  56.914  0.40  1.00     0.174 HD
ATOM   1260 1HH2 ARG U 131     -27.500   0.300  59.902  0.40  1.00     0.174 HD
ATOM   1261 2HH2 ARG U 131     -28.041   0.296  58.255  0.40  1.00     0.174 HD
ATOM   1262  N   PRO U 132     -29.344   3.717  63.248 -0.56  1.50    -0.337 N
ATOM   1263  CA  PRO U 132     -30.232   3.495  64.402  0.18  2.00     0.179 C
ATOM   1264  C   PRO U 132     -29.533   3.587  65.749  0.55  1.70     0.241 C
ATOM   1265  O   PRO U 132     -30.204   3.849  66.755 -0.55  1.40    -0.271 OA
ATOM   1266  CB  PRO U 132     -30.783   2.086  64.151  0.00  2.00     0.037 C
ATOM   1267  CG  PRO U 132     -30.727   1.929  62.669 -0.01  2.00     0.022 C
ATOM   1268  CD  PRO U 132     -29.499   2.670  62.222  0.06  2.00     0.127 C
ATOM   1269  N   ASN U 133     -28.217   3.378  65.809 -0.40  1.50    -0.346 N
ATOM   1270  CA  ASN U 133     -27.464   3.550  67.044  0.18  2.00     0.185 C
ATOM   1271  C   ASN U 133     -26.894   4.959  67.189  0.55  1.70     0.241 C
ATOM   1272  O   ASN U 133     -25.970   5.166  67.985 -0.55  1.40    -0.271 OA
ATOM   1273  CB  ASN U 133     -26.348   2.504  67.139  0.09  2.00     0.137 C
ATOM   1274  CG  ASN U 133     -25.351   2.592  65.996  0.55  1.70     0.217 C
ATOM   1275  H   ASN U 133     -27.785   3.086  64.909  0.40  1.00     0.163 HD
ATOM   1276  OD1 ASN U 133     -25.406   3.501  65.169 -0.55  1.40    -0.274 OA
ATOM   1277  ND2 ASN U 133     -24.429   1.638  65.948 -0.78  1.50    -0.370 N
ATOM   1278 1HD2 ASN U 133     -24.421   0.912  66.637  0.39  1.00     0.159 HD
ATOM   1279 2HD2 ASN U 133     -23.740   1.642  65.222  0.39  1.00     0.159 HD
ATOM   1280  N   PHE U 134     -27.417   5.918  66.422 -0.40  1.50    -0.346 N
ATOM   1281  CA  PHE U 134     -27.065   7.335  66.535  0.18  2.00     0.180 C
ATOM   1282  C   PHE U 134     -25.603   7.605  66.190  0.55  1.70     0.241 C
ATOM   1283  O   PHE U 134     -24.990   8.534  66.723 -0.55  1.40    -0.271 OA
ATOM   1284  CB  PHE U 134     -27.390   7.880  67.927  0.03  2.00     0.073 C
ATOM   1285  CG  PHE U 134     -28.851   7.841  68.270 -0.12  1.70    -0.056 A
ATOM   1286  CD1 PHE U 134     -29.719   8.797  67.770  0.01  1.70     0.007 A
ATOM   1287  CD2 PHE U 134     -29.356   6.849  69.094  0.01  1.70     0.007 A
ATOM   1288  CE1 PHE U 134     -31.064   8.766  68.084  0.00  1.70     0.001 A
ATOM   1289  CE2 PHE U 134     -30.701   6.812  69.413  0.00  1.70     0.001 A
ATOM   1290  CZ  PHE U 134     -31.556   7.772  68.906  0.00  1.70     0.000 A
ATOM   1291  H   PHE U 134     -28.114   5.564  65.718  0.40  1.00     0.163 HD
ATOM   1292  N   THR U 135     -25.031   6.806  65.298 -0.40  1.50    -0.344 N
ATOM   1293  CA  THR U 135     -23.727   7.085  64.718  0.20  2.00     0.205 C
ATOM   1294  C   THR U 135     -23.886   7.364  63.230  0.55  1.70     0.243 C
ATOM   1295  O   THR U 135     -24.944   7.136  62.639 -0.55  1.40    -0.271 OA
ATOM   1296  CB  THR U 135     -22.756   5.918  64.938  0.15  2.00     0.146 C
ATOM   1297  OG1 THR U 135     -23.259   4.744  64.289 -0.49  1.40    -0.393 OA
ATOM   1298  CG2 THR U 135     -22.584   5.641  66.420 -0.02  2.00     0.042 C
ATOM   1299  H   THR U 135     -25.597   5.962  65.050  0.40  1.00     0.163 HD
ATOM   1300  HG1 THR U 135     -24.097   4.425  64.744  0.49  1.00     0.210 HD
ATOM   1301  N   ILE U 136     -22.820   7.880  62.625 -0.40  1.50    -0.346 N
ATOM   1302  CA  ILE U 136     -22.771   8.078  61.184  0.18  2.00     0.180 C
ATOM   1303  C   ILE U 136     -21.455   7.521  60.664  0.55  1.70     0.241 C
ATOM   1304  O   ILE U 136     -20.433   7.535  61.358 -0.55  1.40    -0.271 OA
ATOM   1305  CB  ILE U 136     -22.935   9.563  60.777  0.01  2.00     0.013 C
ATOM   1306  CG1 ILE U 136     -21.760  10.402  61.281 -0.03  2.00     0.002 C
ATOM   1307  CG2 ILE U 136     -24.257  10.122  61.286 -0.04  2.00     0.012 C
ATOM   1308  CD1 ILE U 136     -21.685  11.774  60.648 -0.05  2.00     0.005 C
ATOM   1309  H   ILE U 136     -22.036   8.126  63.264  0.40  1.00     0.163 HD
ATOM   1310  N   LYS U 137     -21.491   7.011  59.436 -0.40  1.50    -0.346 N
ATOM   1311  CA  LYS U 137     -20.306   6.485  58.764  0.18  2.00     0.176 C
ATOM   1312  C   LYS U 137     -19.824   7.561  57.797  0.55  1.70     0.240 C
ATOM   1313  O   LYS U 137     -20.184   7.575  56.620 -0.55  1.40    -0.271 OA
ATOM   1314  CB  LYS U 137     -20.615   5.173  58.052 -0.00  2.00     0.035 C
ATOM   1315  CG  LYS U 137     -20.622   3.960  58.968 -0.03  2.00     0.004 C
ATOM   1316  CD  LYS U 137     -21.819   3.065  58.694 -0.01  2.00     0.027 C
ATOM   1317  CE  LYS U 137     -21.664   1.713  59.370  0.15  2.00     0.229 C
ATOM   1318  NZ  LYS U 137     -22.790   0.796  59.040 -0.32  2.00    -0.079 N
ATOM   1319  H   LYS U 137     -22.439   7.019  58.994  0.40  1.00     0.163 HD
ATOM   1320  HZ1 LYS U 137     -23.657   1.248  59.248  0.33  0.00     0.274 HD
ATOM   1321  HZ2 LYS U 137     -22.756   0.567  58.068  0.33  0.00     0.274 HD
ATOM   1322  HZ3 LYS U 137     -22.708  -0.038  59.584  0.33  0.00     0.274 HD
ATOM   1323  N   GLY U 138     -19.006   8.480  58.310 -0.40  1.50    -0.351 N
ATOM   1324  CA  GLY U 138     -18.490   9.579  57.540  0.15  2.00     0.225 C
ATOM   1325  C   GLY U 138     -17.015   9.433  57.225  0.55  1.70     0.236 C
ATOM   1326  O   GLY U 138     -16.431   8.347  57.314 -0.55  1.40    -0.272 OA
ATOM   1327  H   GLY U 138     -18.778   8.324  59.322  0.40  1.00     0.163 HD
ATOM   1328  N   SER U 139     -16.406  10.554  56.841 -0.40  1.50    -0.344 N
ATOM   1329  CA  SER U 139     -14.974  10.612  56.546  0.20  2.00     0.200 C
ATOM   1330  C   SER U 139     -14.441  11.890  57.186  0.55  1.70     0.243 C
ATOM   1331  O   SER U 139     -14.612  12.983  56.638 -0.55  1.40    -0.271 OA
ATOM   1332  CB  SER U 139     -14.714  10.584  55.045  0.12  2.00     0.199 C
ATOM   1333  OG  SER U 139     -13.436  11.114  54.738 -0.49  1.40    -0.398 OA
ATOM   1334  H   SER U 139     -17.035  11.384  56.769  0.40  1.00     0.163 HD
ATOM   1335  HG  SER U 139     -13.474  12.112  54.766  0.49  1.00     0.209 HD
ATOM   1336  N   PHE U 140     -13.801  11.748  58.344 -0.40  1.50    -0.346 N
ATOM   1337  CA  PHE U 140     -13.339  12.882  59.131  0.18  2.00     0.180 C
ATOM   1338  C   PHE U 140     -11.914  12.636  59.601  0.55  1.70     0.241 C
ATOM   1339  O   PHE U 140     -11.601  11.554  60.109 -0.55  1.40    -0.271 OA
ATOM   1340  CB  PHE U 140     -14.252  13.122  60.337  0.03  2.00     0.073 C
ATOM   1341  CG  PHE U 140     -15.641  13.561  59.972 -0.12  1.70    -0.056 A
ATOM   1342  CD1 PHE U 140     -15.874  14.835  59.480  0.01  1.70     0.007 A
ATOM   1343  CD2 PHE U 140     -16.716  12.702  60.129  0.01  1.70     0.007 A
ATOM   1344  CE1 PHE U 140     -17.153  15.243  59.148  0.00  1.70     0.001 A
ATOM   1345  CE2 PHE U 140     -17.997  13.103  59.798  0.00  1.70     0.001 A
ATOM   1346  CZ  PHE U 140     -18.215  14.376  59.308  0.00  1.70     0.000 A
ATOM   1347  H   PHE U 140     -13.660  10.754  58.637  0.40  1.00     0.163 HD
ATOM   1348  N   LEU U 141     -11.059  13.638  59.435 -0.40  1.50    -0.346 N
ATOM   1349  CA  LEU U 141      -9.684  13.609  59.906  0.18  2.00     0.177 C
ATOM   1350  C   LEU U 141      -9.519  14.591  61.062  0.55  1.70     0.241 C
ATOM   1351  O   LEU U 141     -10.482  15.206  61.530 -0.55  1.40    -0.271 OA
ATOM   1352  CB  LEU U 141      -8.716  13.934  58.766  0.00  2.00     0.038 C
ATOM   1353  CG  LEU U 141      -8.832  13.083  57.500 -0.02  2.00    -0.020 C
ATOM   1354  CD1 LEU U 141      -7.882  13.589  56.425 -0.05  2.00     0.009 C
ATOM   1355  CD2 LEU U 141      -8.563  11.619  57.811 -0.05  2.00     0.009 C
ATOM   1356  H   LEU U 141     -11.468  14.465  58.927  0.40  1.00     0.163 HD
ATOM   1357  N   ASN U 142      -8.278  14.733  61.524 -0.40  1.50    -0.346 N
ATOM   1358  CA  ASN U 142      -7.978  15.712  62.559  0.18  2.00     0.185 C
ATOM   1359  C   ASN U 142      -8.280  17.118  62.054  0.55  1.70     0.241 C
ATOM   1360  O   ASN U 142      -7.951  17.473  60.919 -0.55  1.40    -0.271 OA
ATOM   1361  CB  ASN U 142      -6.512  15.609  62.983  0.09  2.00     0.137 C
ATOM   1362  CG  ASN U 142      -6.236  14.393  63.847  0.55  1.70     0.217 C
ATOM   1363  H   ASN U 142      -7.576  14.109  61.097  0.40  1.00     0.163 HD
ATOM   1364  OD1 ASN U 142      -7.080  13.508  63.983 -0.55  1.40    -0.274 OA
ATOM   1365  ND2 ASN U 142      -5.048  14.345  64.438 -0.78  1.50    -0.370 N
ATOM   1366 1HD2 ASN U 142      -4.394  15.092  64.305  0.39  1.00     0.159 HD
ATOM   1367 2HD2 ASN U 142      -4.805  13.567  65.016  0.39  1.00     0.159 HD
ATOM   1368  N   GLY U 143      -8.918  17.918  62.905 -0.40  1.50    -0.351 N
ATOM   1369  CA  GLY U 143      -9.293  19.269  62.548  0.15  2.00     0.225 C
ATOM   1370  C   GLY U 143     -10.611  19.402  61.819  0.55  1.70     0.236 C
ATOM   1371  O   GLY U 143     -10.969  20.518  61.421 -0.55  1.40    -0.272 OA
ATOM   1372  H   GLY U 143      -9.118  17.489  63.833  0.40  1.00     0.163 HD
ATOM   1373  N   SER U 144     -11.343  18.306  61.628 -0.40  1.50    -0.344 N
ATOM   1374  CA  SER U 144     -12.628  18.343  60.945  0.20  2.00     0.200 C
ATOM   1375  C   SER U 144     -13.788  18.683  61.871  0.55  1.70     0.243 C
ATOM   1376  O   SER U 144     -14.921  18.811  61.394 -0.55  1.40    -0.271 OA
ATOM   1377  CB  SER U 144     -12.901  16.998  60.267  0.12  2.00     0.199 C
ATOM   1378  OG  SER U 144     -13.231  16.013  61.229 -0.49  1.40    -0.398 OA
ATOM   1379  H   SER U 144     -10.919  17.433  62.006  0.40  1.00     0.163 HD
ATOM   1380  HG  SER U 144     -12.401  15.537  61.518  0.49  1.00     0.209 HD
ATOM   1381  N   CYS U 145     -13.539  18.826  63.171 -0.40  1.50    -0.345 N
ATOM   1382  CA  CYS U 145     -14.607  19.162  64.101  0.19  2.00     0.185 C
ATOM   1383  C   CYS U 145     -15.167  20.542  63.788  0.55  1.70     0.241 C
ATOM   1384  O   CYS U 145     -14.451  21.446  63.350 -0.55  1.40    -0.271 OA
ATOM   1385  CB  CYS U 145     -14.100  19.110  65.541  0.05  2.00     0.105 C
ATOM   1386  SG  CYS U 145     -14.043  17.445  66.228 -0.29  1.85    -0.180 SA
ATOM   1387  H   CYS U 145     -12.555  18.682  63.448  0.40  1.00     0.163 HD
ATOM   1388  HG  CYS U 145     -14.120  17.490  67.225  0.29  1.00     0.101 HD
ATOM   1389  N   GLY U 146     -16.467  20.699  64.023 -0.40  1.50    -0.351 N
ATOM   1390  CA  GLY U 146     -17.189  21.858  63.556  0.15  2.00     0.225 C
ATOM   1391  C   GLY U 146     -17.833  21.683  62.200  0.55  1.70     0.236 C
ATOM   1392  O   GLY U 146     -18.678  22.506  61.824 -0.55  1.40    -0.272 OA
ATOM   1393  H   GLY U 146     -16.903  19.923  64.564  0.40  1.00     0.163 HD
ATOM   1394  N   SER U 147     -17.454  20.646  61.454 -0.40  1.50    -0.344 N
ATOM   1395  CA  SER U 147     -18.140  20.326  60.210  0.20  2.00     0.200 C
ATOM   1396  C   SER U 147     -19.613  20.069  60.492  0.55  1.70     0.243 C
ATOM   1397  O   SER U 147     -19.968  19.419  61.478 -0.55  1.40    -0.271 OA
ATOM   1398  CB  SER U 147     -17.507  19.098  59.554  0.12  2.00     0.199 C
ATOM   1399  OG  SER U 147     -16.269  19.423  58.945 -0.49  1.40    -0.398 OA
ATOM   1400  H   SER U 147     -16.655  20.107  61.827  0.40  1.00     0.163 HD
ATOM   1401  HG  SER U 147     -15.611  18.692  59.118  0.49  1.00     0.209 HD
ATOM   1402  N   VAL U 148     -20.476  20.592  59.628 -0.40  1.50    -0.346 N
ATOM   1403  CA  VAL U 148     -21.911  20.554  59.865  0.18  2.00     0.180 C
ATOM   1404  C   VAL U 148     -22.584  19.656  58.838  0.55  1.70     0.241 C
ATOM   1405  O   VAL U 148     -22.147  19.544  57.686 -0.55  1.40    -0.271 OA
ATOM   1406  CB  VAL U 148     -22.529  21.969  59.846  0.01  2.00     0.009 C
ATOM   1407  CG1 VAL U 148     -21.922  22.824  60.950 -0.04  2.00     0.012 C
ATOM   1408  CG2 VAL U 148     -22.327  22.622  58.490 -0.04  2.00     0.012 C
ATOM   1409  H   VAL U 148     -20.044  21.021  58.786  0.40  1.00     0.163 HD
ATOM   1410  N   GLY U 149     -23.650  18.994  59.276 -0.40  1.50    -0.351 N
ATOM   1411  CA  GLY U 149     -24.540  18.274  58.391  0.15  2.00     0.225 C
ATOM   1412  C   GLY U 149     -25.803  19.086  58.180  0.55  1.70     0.236 C
ATOM   1413  O   GLY U 149     -26.241  19.814  59.068 -0.55  1.40    -0.272 OA
ATOM   1414  H   GLY U 149     -23.786  19.041  60.314  0.40  1.00     0.163 HD
ATOM   1415  N   PHE U 150     -26.389  18.963  56.992 -0.40  1.50    -0.346 N
ATOM   1416  CA  PHE U 150     -27.490  19.848  56.642  0.18  2.00     0.180 C
ATOM   1417  C   PHE U 150     -28.366  19.206  55.578  0.55  1.70     0.241 C
ATOM   1418  O   PHE U 150     -27.928  18.340  54.816 -0.55  1.40    -0.271 OA
ATOM   1419  CB  PHE U 150     -26.972  21.204  56.149  0.03  2.00     0.073 C
ATOM   1420  CG  PHE U 150     -26.192  21.125  54.865 -0.12  1.70    -0.056 A
ATOM   1421  CD1 PHE U 150     -24.842  20.814  54.876  0.01  1.70     0.007 A
ATOM   1422  CD2 PHE U 150     -26.810  21.359  53.646  0.01  1.70     0.007 A
ATOM   1423  CE1 PHE U 150     -24.122  20.737  53.698  0.00  1.70     0.001 A
ATOM   1424  CE2 PHE U 150     -26.096  21.284  52.464  0.00  1.70     0.001 A
ATOM   1425  CZ  PHE U 150     -24.750  20.973  52.491  0.00  1.70     0.000 A
ATOM   1426  H   PHE U 150     -26.015  18.231  56.383  0.40  1.00     0.163 HD
ATOM   1427  N   ASN U 151     -29.619  19.653  55.547 -0.40  1.50    -0.346 N
ATOM   1428  CA  ASN U 151     -30.535  19.417  54.444  0.18  2.00     0.185 C
ATOM   1429  C   ASN U 151     -31.061  20.760  53.956  0.55  1.70     0.241 C
ATOM   1430  O   ASN U 151     -31.091  21.740  54.707 -0.55  1.40    -0.271 OA
ATOM   1431  CB  ASN U 151     -31.705  18.512  54.857  0.09  2.00     0.137 C
ATOM   1432  CG  ASN U 151     -31.300  17.057  54.989  0.55  1.70     0.217 C
ATOM   1433  H   ASN U 151     -29.893  20.201  56.405  0.40  1.00     0.163 HD
ATOM   1434  OD1 ASN U 151     -31.020  16.385  53.996 -0.55  1.40    -0.274 OA
ATOM   1435  ND2 ASN U 151     -31.273  16.559  56.220 -0.78  1.50    -0.370 N
ATOM   1436 1HD2 ASN U 151     -31.519  17.140  56.998  0.39  1.00     0.159 HD
ATOM   1437 2HD2 ASN U 151     -31.009  15.608  56.372  0.39  1.00     0.159 HD
ATOM   1438  N   ILE U 152     -31.466  20.808  52.691 -0.40  1.50    -0.346 N
ATOM   1439  CA  ILE U 152     -31.988  22.025  52.078  0.18  2.00     0.180 C
ATOM   1440  C   ILE U 152     -33.430  21.754  51.677  0.55  1.70     0.241 C
ATOM   1441  O   ILE U 152     -33.688  21.003  50.728 -0.55  1.40    -0.271 OA
ATOM   1442  CB  ILE U 152     -31.150  22.471  50.873  0.01  2.00     0.013 C
ATOM   1443  CG1 ILE U 152     -29.720  22.793  51.311 -0.03  2.00     0.002 C
ATOM   1444  CG2 ILE U 152     -31.784  23.682  50.206 -0.04  2.00     0.012 C
ATOM   1445  CD1 ILE U 152     -28.825  23.255  50.183 -0.05  2.00     0.005 C
ATOM   1446  H   ILE U 152     -31.379  19.903  52.175  0.40  1.00     0.163 HD
ATOM   1447  N   ASP U 153     -34.371  22.360  52.401 -0.40  1.50    -0.345 N
ATOM   1448  CA  ASP U 153     -35.790  22.190  52.117  0.19  2.00     0.186 C
ATOM   1449  C   ASP U 153     -36.142  22.824  50.778  0.55  1.70     0.241 C
ATOM   1450  O   ASP U 153     -36.488  22.124  49.821 -0.55  1.40    -0.271 OA
ATOM   1451  CB  ASP U 153     -36.634  22.799  53.240  0.10  2.00     0.147 C
ATOM   1452  CG  ASP U 153     -37.904  22.015  53.504  0.10  1.70     0.175 C
ATOM   1453  OD1 ASP U 153     -38.568  21.610  52.527 -0.55  1.40    -0.648 OA
ATOM   1454  OD2 ASP U 153     -38.237  21.804  54.689 -0.55  1.40    -0.648 OA
ATOM   1455  H   ASP U 153     -34.007  22.954  53.173  0.40  1.00     0.163 HD
ATOM   1456  N   TYR U 154     -36.061  24.151  50.708 -0.40  1.50    -0.346 N
ATOM   1457  CA  TYR U 154     -36.246  24.881  49.460  0.18  2.00     0.180 C
ATOM   1458  C   TYR U 154     -35.086  25.848  49.280  0.55  1.70     0.241 C
ATOM   1459  O   TYR U 154     -34.151  25.583  48.517 -0.55  1.40    -0.271 OA
ATOM   1460  CB  TYR U 154     -37.580  25.629  49.462  0.03  2.00     0.073 C
ATOM   1461  CG  TYR U 154     -38.651  24.978  48.620 -0.12  1.70    -0.056 A
ATOM   1462  CD1 TYR U 154     -39.239  23.783  49.011  0.01  1.70     0.010 A
ATOM   1463  CD2 TYR U 154     -39.078  25.561  47.434  0.01  1.70     0.010 A
ATOM   1464  CE1 TYR U 154     -40.222  23.184  48.244  0.04  1.70     0.037 A
ATOM   1465  CE2 TYR U 154     -40.060  24.971  46.661  0.04  1.70     0.037 A
ATOM   1466  CZ  TYR U 154     -40.628  23.783  47.070  0.06  1.70     0.065 A
ATOM   1467  OH  TYR U 154     -41.606  23.193  46.302 -0.49  1.40    -0.361 OA
ATOM   1468  H   TYR U 154     -35.855  24.619  51.618  0.40  1.00     0.163 HD
ATOM   1469  HH  TYR U 154     -41.495  23.481  45.353  0.43  1.00     0.217 HD
ATOM   1470  N   ASP U 155     -35.146  26.976  49.984 -0.40  1.50    -0.345 N
ATOM   1471  CA  ASP U 155     -34.013  27.876  50.141  0.19  2.00     0.186 C
ATOM   1472  C   ASP U 155     -33.515  27.902  51.580  0.55  1.70     0.241 C
ATOM   1473  O   ASP U 155     -32.618  28.687  51.905 -0.55  1.40    -0.271 OA
ATOM   1474  CB  ASP U 155     -34.386  29.289  49.689  0.10  2.00     0.147 C
ATOM   1475  CG  ASP U 155     -35.485  29.899  50.537  0.10  1.70     0.175 C
ATOM   1476  OD1 ASP U 155     -36.403  29.158  50.949 -0.55  1.40    -0.648 OA
ATOM   1477  OD2 ASP U 155     -35.432  31.120  50.794 -0.55  1.40    -0.648 OA
ATOM   1478  H   ASP U 155     -36.084  27.160  50.417  0.40  1.00     0.163 HD
ATOM   1479  N   CYS U 156     -34.076  27.059  52.443 -0.40  1.50    -0.345 N
ATOM   1480  CA  CYS U 156     -33.808  27.088  53.873  0.19  2.00     0.185 C
ATOM   1481  C   CYS U 156     -32.890  25.929  54.241  0.55  1.70     0.241 C
ATOM   1482  O   CYS U 156     -33.222  24.765  53.995 -0.55  1.40    -0.271 OA
ATOM   1483  CB  CYS U 156     -35.112  27.015  54.665  0.05  2.00     0.105 C
ATOM   1484  SG  CYS U 156     -34.916  26.550  56.396 -0.29  1.85    -0.180 SA
ATOM   1485  H   CYS U 156     -34.731  26.369  52.000  0.40  1.00     0.163 HD
ATOM   1486  HG  CYS U 156     -33.969  26.274  56.564  0.29  1.00     0.101 HD
ATOM   1487  N   VAL U 157     -31.744  26.248  54.832 -0.40  1.50    -0.346 N
ATOM   1488  CA  VAL U 157     -30.794  25.228  55.263  0.18  2.00     0.180 C
ATOM   1489  C   VAL U 157     -31.224  24.697  56.622  0.55  1.70     0.241 C
ATOM   1490  O   VAL U 157     -31.343  25.457  57.591 -0.55  1.40    -0.271 OA
ATOM   1491  CB  VAL U 157     -29.365  25.786  55.319  0.01  2.00     0.009 C
ATOM   1492  CG1 VAL U 157     -28.378  24.675  55.644 -0.04  2.00     0.012 C
ATOM   1493  CG2 VAL U 157     -29.003  26.458  54.006 -0.04  2.00     0.012 C
ATOM   1494  H   VAL U 157     -31.586  27.267  54.958  0.40  1.00     0.163 HD
ATOM   1495  N   SER U 158     -31.451  23.391  56.703 -0.40  1.50    -0.344 N
ATOM   1496  CA  SER U 158     -31.802  22.730  57.956  0.20  2.00     0.200 C
ATOM   1497  C   SER U 158     -30.540  22.086  58.517  0.55  1.70     0.243 C
ATOM   1498  O   SER U 158     -30.177  20.971  58.135 -0.55  1.40    -0.271 OA
ATOM   1499  CB  SER U 158     -32.911  21.706  57.742  0.12  2.00     0.199 C
ATOM   1500  OG  SER U 158     -34.152  22.344  57.498 -0.49  1.40    -0.398 OA
ATOM   1501  H   SER U 158     -31.357  22.879  55.797  0.40  1.00     0.163 HD
ATOM   1502  HG  SER U 158     -34.114  23.285  57.831  0.49  1.00     0.209 HD
ATOM   1503  N   PHE U 159     -29.865  22.797  59.418 -0.40  1.50    -0.346 N
ATOM   1504  CA  PHE U 159     -28.686  22.252  60.075  0.18  2.00     0.180 C
ATOM   1505  C   PHE U 159     -29.103  21.192  61.086  0.55  1.70     0.241 C
ATOM   1506  O   PHE U 159     -29.973  21.431  61.929 -0.55  1.40    -0.271 OA
ATOM   1507  CB  PHE U 159     -27.896  23.363  60.765  0.03  2.00     0.073 C
ATOM   1508  CG  PHE U 159     -27.286  24.355  59.817 -0.12  1.70    -0.056 A
ATOM   1509  CD1 PHE U 159     -26.139  24.041  59.107  0.01  1.70     0.007 A
ATOM   1510  CD2 PHE U 159     -27.857  25.606  59.642  0.01  1.70     0.007 A
ATOM   1511  CE1 PHE U 159     -25.574  24.954  58.236  0.00  1.70     0.001 A
ATOM   1512  CE2 PHE U 159     -27.298  26.523  58.772  0.00  1.70     0.001 A
ATOM   1513  CZ  PHE U 159     -26.154  26.197  58.069  0.00  1.70     0.000 A
ATOM   1514  H   PHE U 159     -30.243  23.742  59.602  0.40  1.00     0.163 HD
ATOM   1515  N   CYS U 160     -28.477  20.018  61.007 -0.40  1.50    -0.345 N
ATOM   1516  CA  CYS U 160     -28.876  18.893  61.837  0.19  2.00     0.185 C
ATOM   1517  C   CYS U 160     -27.729  18.182  62.538  0.55  1.70     0.241 C
ATOM   1518  O   CYS U 160     -27.997  17.319  63.381 -0.55  1.40    -0.271 OA
ATOM   1519  CB  CYS U 160     -29.647  17.861  61.000  0.05  2.00     0.105 C
ATOM   1520  SG  CYS U 160     -28.664  17.112  59.689 -0.29  1.85    -0.180 SA
ATOM   1521  H   CYS U 160     -27.703  19.983  60.320  0.40  1.00     0.163 HD
ATOM   1522  HG  CYS U 160     -27.937  17.742  59.412  0.29  1.00     0.101 HD
ATOM   1523  N   TYR U 161     -26.476  18.509  62.235 -0.40  1.50    -0.346 N
ATOM   1524  CA  TYR U 161     -25.358  17.750  62.774  0.18  2.00     0.180 C
ATOM   1525  C   TYR U 161     -24.121  18.631  62.848  0.55  1.70     0.241 C
ATOM   1526  O   TYR U 161     -23.894  19.470  61.974 -0.55  1.40    -0.271 OA
ATOM   1527  CB  TYR U 161     -25.074  16.515  61.911  0.03  2.00     0.073 C
ATOM   1528  CG  TYR U 161     -23.908  15.673  62.380 -0.12  1.70    -0.056 A
ATOM   1529  CD1 TYR U 161     -24.061  14.756  63.411  0.01  1.70     0.010 A
ATOM   1530  CD2 TYR U 161     -22.659  15.785  61.783  0.01  1.70     0.010 A
ATOM   1531  CE1 TYR U 161     -23.004  13.980  63.839  0.04  1.70     0.037 A
ATOM   1532  CE2 TYR U 161     -21.594  15.013  62.205  0.04  1.70     0.037 A
ATOM   1533  CZ  TYR U 161     -21.772  14.113  63.234  0.06  1.70     0.065 A
ATOM   1534  OH  TYR U 161     -20.715  13.340  63.658 -0.49  1.40    -0.361 OA
ATOM   1535  H   TYR U 161     -26.373  19.321  61.605  0.40  1.00     0.163 HD
ATOM   1536  HH  TYR U 161     -20.676  12.509  63.107  0.43  1.00     0.217 HD
ATOM   1537  N   MET U 162     -23.334  18.436  63.904 -0.40  1.50    -0.346 N
ATOM   1538  CA  MET U 162     -22.006  19.022  64.028  0.18  2.00     0.177 C
ATOM   1539  C   MET U 162     -21.066  17.931  64.516  0.55  1.70     0.241 C
ATOM   1540  O   MET U 162     -21.362  17.252  65.504 -0.55  1.40    -0.271 OA
ATOM   1541  CB  MET U 162     -22.000  20.218  64.990  0.01  2.00     0.045 C
ATOM   1542  CG  MET U 162     -20.620  20.824  65.217  0.03  2.00     0.076 C
ATOM   1543  SD  MET U 162     -20.661  22.392  66.114 -0.53  1.85    -0.173 SA
ATOM   1544  CE  MET U 162     -21.109  23.529  64.803  0.01  2.00     0.089 C
ATOM   1545  H   MET U 162     -23.756  17.821  64.642  0.40  1.00     0.163 HD
ATOM   1546  N   HIS U 163     -19.947  17.753  63.819 -0.40  1.50    -0.346 N
ATOM   1547  CA  HIS U 163     -19.055  16.637  64.100  0.18  2.00     0.182 C
ATOM   1548  C   HIS U 163     -18.229  16.896  65.353  0.55  1.70     0.241 C
ATOM   1549  O   HIS U 163     -17.765  18.016  65.590 -0.55  1.40    -0.271 OA
ATOM   1550  CB  HIS U 163     -18.129  16.377  62.914  0.05  2.00     0.093 C
ATOM   1551  CG  HIS U 163     -17.215  15.210  63.116 -0.12  1.70     0.030 A
ATOM   1552  ND1 HIS U 163     -15.848  15.303  62.966 -0.40  1.50    -0.353 N
ATOM   1553  CD2 HIS U 163     -17.471  13.922  63.443  0.14  1.70     0.143 A
ATOM   1554  CE1 HIS U 163     -15.301  14.124  63.199  0.21  1.70     0.207 A
ATOM   1555  NE2 HIS U 163     -16.265  13.268  63.489 -0.56  1.50    -0.254 NA
ATOM   1556  H   HIS U 163     -19.773  18.458  63.082  0.40  1.00     0.163 HD
ATOM   1557  HD1 HIS U 163     -15.351  16.135  62.721  0.40  1.00     0.166 HD
ATOM   1558  N   HIS U 164     -18.035  15.849  66.145 -0.40  1.50    -0.346 N
ATOM   1559  CA  HIS U 164     -17.329  15.988  67.414  0.18  2.00     0.182 C
ATOM   1560  C   HIS U 164     -16.213  14.974  67.613  0.55  1.70     0.241 C
ATOM   1561  O   HIS U 164     -15.161  15.336  68.144 -0.55  1.40    -0.271 OA
ATOM   1562  CB  HIS U 164     -18.324  15.889  68.582  0.05  2.00     0.095 C
ATOM   1563  CG  HIS U 164     -19.098  17.148  68.820  0.15  1.70     0.053 A
ATOM   1564  ND1 HIS U 164     -20.077  17.593  67.959 -0.56  1.50    -0.247 NA
ATOM   1565  CD2 HIS U 164     -19.033  18.061  69.818  0.12  1.70     0.116 A
ATOM   1566  CE1 HIS U 164     -20.583  18.724  68.416  0.21  1.70     0.207 A
ATOM   1567  NE2 HIS U 164     -19.967  19.028  69.545 -0.40  1.50    -0.359 N
ATOM   1568  H   HIS U 164     -18.416  14.954  65.795  0.40  1.00     0.163 HD
ATOM   1569  HE2 HIS U 164     -20.154  19.834  70.110  0.40  1.00     0.166 HD
ATOM   1570  N   MET U 165     -16.406  13.719  67.212 -0.40  1.50    -0.346 N
ATOM   1571  CA  MET U 165     -15.411  12.702  67.535  0.18  2.00     0.177 C
ATOM   1572  C   MET U 165     -15.651  11.445  66.709  0.55  1.70     0.241 C
ATOM   1573  O   MET U 165     -16.653  11.315  66.000 -0.55  1.40    -0.271 OA
ATOM   1574  CB  MET U 165     -15.435  12.364  69.027  0.01  2.00     0.045 C
ATOM   1575  CG  MET U 165     -16.781  11.878  69.510  0.03  2.00     0.076 C
ATOM   1576  SD  MET U 165     -16.725  11.270  71.202 -0.53  1.85    -0.173 SA
ATOM   1577  CE  MET U 165     -18.459  10.934  71.465  0.01  2.00     0.089 C
ATOM   1578  H   MET U 165     -17.266  13.544  66.687  0.40  1.00     0.163 HD
ATOM   1579  N   GLU U 166     -14.706  10.515  66.826 -0.40  1.50    -0.346 N
ATOM   1580  CA  GLU U 166     -14.746   9.219  66.167  0.18  2.00     0.177 C
ATOM   1581  C   GLU U 166     -14.686   8.122  67.218  0.55  1.70     0.241 C
ATOM   1582  O   GLU U 166     -13.884   8.192  68.156 -0.55  1.40    -0.271 OA
ATOM   1583  CB  GLU U 166     -13.578   9.064  65.189  0.01  2.00     0.045 C
ATOM   1584  CG  GLU U 166     -13.555   7.770  64.398  0.07  2.00     0.116 C
ATOM   1585  CD  GLU U 166     -12.432   7.748  63.378  0.10  1.70     0.172 C
ATOM   1586  OE1 GLU U 166     -11.440   7.019  63.595 -0.55  1.40    -0.648 OA
ATOM   1587  OE2 GLU U 166     -12.536   8.469  62.363 -0.55  1.40    -0.648 OA
ATOM   1588  H   GLU U 166     -13.906  10.806  67.453  0.40  1.00     0.163 HD
ATOM   1589  N   LEU U 167     -15.536   7.116  67.061 -0.40  1.50    -0.346 N
ATOM   1590  CA  LEU U 167     -15.557   5.995  67.983  0.18  2.00     0.177 C
ATOM   1591  C   LEU U 167     -14.508   4.960  67.582  0.55  1.70     0.243 C
ATOM   1592  O   LEU U 167     -14.042   4.948  66.439 -0.55  1.40    -0.271 OA
ATOM   1593  CB  LEU U 167     -16.951   5.377  68.012  0.00  2.00     0.038 C
ATOM   1594  CG  LEU U 167     -18.065   6.349  68.410 -0.02  2.00    -0.020 C
ATOM   1595  CD1 LEU U 167     -19.406   5.641  68.485 -0.05  2.00     0.009 C
ATOM   1596  CD2 LEU U 167     -17.742   7.034  69.731 -0.05  2.00     0.009 C
ATOM   1597  H   LEU U 167     -16.167   7.200  66.242  0.40  1.00     0.163 HD
ATOM   1598  N   PRO U 168     -14.101   4.090  68.515 -0.56  1.50    -0.337 N
ATOM   1599  CA  PRO U 168     -13.058   3.099  68.191  0.18  2.00     0.179 C
ATOM   1600  C   PRO U 168     -13.368   2.232  66.981  0.55  1.70     0.241 C
ATOM   1601  O   PRO U 168     -12.436   1.774  66.307 -0.55  1.40    -0.271 OA
ATOM   1602  CB  PRO U 168     -12.975   2.260  69.473  0.00  2.00     0.037 C
ATOM   1603  CG  PRO U 168     -13.394   3.190  70.551 -0.01  2.00     0.022 C
ATOM   1604  CD  PRO U 168     -14.451   4.071  69.947  0.06  2.00     0.127 C
ATOM   1605  N   THR U 169     -14.643   1.994  66.680 -0.40  1.50    -0.344 N
ATOM   1606  CA  THR U 169     -15.014   1.178  65.531  0.20  2.00     0.205 C
ATOM   1607  C   THR U 169     -14.893   1.920  64.206  0.55  1.70     0.243 C
ATOM   1608  O   THR U 169     -15.177   1.330  63.158 -0.55  1.40    -0.271 OA
ATOM   1609  CB  THR U 169     -16.446   0.658  65.692  0.15  2.00     0.146 C
ATOM   1610  OG1 THR U 169     -17.318   1.747  66.019 -0.49  1.40    -0.393 OA
ATOM   1611  CG2 THR U 169     -16.511  -0.390  66.795 -0.02  2.00     0.042 C
ATOM   1612  H   THR U 169     -15.331   2.431  67.321  0.40  1.00     0.163 HD
ATOM   1613  HG1 THR U 169     -17.163   2.046  66.966  0.49  1.00     0.210 HD
ATOM   1614  N   GLY U 170     -14.482   3.187  64.220 -0.40  1.50    -0.350 N
ATOM   1615  CA  GLY U 170     -14.354   3.965  63.009  0.15  2.00     0.225 C
ATOM   1616  C   GLY U 170     -15.560   4.807  62.656  0.55  1.70     0.236 C
ATOM   1617  O   GLY U 170     -15.482   5.605  61.713 -0.55  1.40    -0.272 OA
ATOM   1618  H   GLY U 170     -14.265   3.557  65.171  0.40  1.00     0.163 HD
ATOM   1619  N   VAL U 171     -16.673   4.654  63.372 -0.40  1.50    -0.346 N
ATOM   1620  CA  VAL U 171     -17.859   5.467  63.130  0.18  2.00     0.180 C
ATOM   1621  C   VAL U 171     -17.684   6.804  63.837  0.55  1.70     0.241 C
ATOM   1622  O   VAL U 171     -16.757   6.980  64.635 -0.55  1.40    -0.271 OA
ATOM   1623  CB  VAL U 171     -19.140   4.752  63.594  0.01  2.00     0.009 C
ATOM   1624  CG1 VAL U 171     -19.397   3.520  62.739 -0.04  2.00     0.012 C
ATOM   1625  CG2 VAL U 171     -19.039   4.380  65.062 -0.04  2.00     0.012 C
ATOM   1626  H   VAL U 171     -16.621   3.918  64.103  0.40  1.00     0.163 HD
ATOM   1627  N   HIS U 172     -18.573   7.750  63.554 -0.40  1.50    -0.346 N
ATOM   1628  CA  HIS U 172     -18.444   9.111  64.049  0.18  2.00     0.182 C
ATOM   1629  C   HIS U 172     -19.693   9.516  64.819  0.55  1.70     0.241 C
ATOM   1630  O   HIS U 172     -20.794   9.023  64.557 -0.55  1.40    -0.271 OA
ATOM   1631  CB  HIS U 172     -18.188  10.085  62.898  0.05  2.00     0.093 C
ATOM   1632  CG  HIS U 172     -16.989   9.734  62.074 -0.12  1.70     0.030 A
ATOM   1633  H   HIS U 172     -19.364   7.433  62.951  0.40  1.00     0.163 HD
ATOM   1634  ND1 HIS U 172     -17.070   8.967  60.931 -0.40  1.50    -0.353 N
ATOM   1635  CD2 HIS U 172     -15.678  10.030  62.237  0.14  1.70     0.143 A
ATOM   1636  CE1 HIS U 172     -15.861   8.814  60.420  0.21  1.70     0.207 A
ATOM   1637  NE2 HIS U 172     -14.998   9.449  61.194 -0.56  1.50    -0.254 NA
ATOM   1638  HD1 HIS U 172     -17.913   8.588  60.550  0.40  1.00     0.166 HD
ATOM   1639  N   ALA U 173     -19.507  10.418  65.779 -0.40  1.50    -0.346 N
ATOM   1640  CA  ALA U 173     -20.584  10.891  66.630  0.17  2.00     0.172 C
ATOM   1641  C   ALA U 173     -20.528  12.406  66.731  0.55  1.70     0.240 C
ATOM   1642  O   ALA U 173     -19.460  13.014  66.626 -0.55  1.40    -0.271 OA
ATOM   1643  CB  ALA U 173     -20.510  10.272  68.034 -0.02  2.00     0.042 C
ATOM   1644  H   ALA U 173     -18.519  10.754  65.865  0.40  1.00     0.163 HD
ATOM   1645  N   GLY U 174     -21.691  13.009  66.934 -0.40  1.50    -0.351 N
ATOM   1646  CA  GLY U 174     -21.774  14.443  67.066  0.15  2.00     0.225 C
ATOM   1647  C   GLY U 174     -23.081  14.855  67.700  0.55  1.70     0.236 C
ATOM   1648  O   GLY U 174     -23.815  14.031  68.247 -0.55  1.40    -0.272 OA
ATOM   1649  H   GLY U 174     -22.509  12.372  66.987  0.40  1.00     0.163 HD
ATOM   1650  N   THR U 175     -23.363  16.149  67.615 -0.40  1.50    -0.344 N
ATOM   1651  CA  THR U 175     -24.546  16.742  68.216  0.20  2.00     0.205 C
ATOM   1652  C   THR U 175     -25.379  17.433  67.146  0.55  1.70     0.243 C
ATOM   1653  O   THR U 175     -24.942  17.622  66.008 -0.55  1.40    -0.271 OA
ATOM   1654  CB  THR U 175     -24.167  17.756  69.306  0.15  2.00     0.146 C
ATOM   1655  OG1 THR U 175     -23.698  18.964  68.692 -0.49  1.40    -0.393 OA
ATOM   1656  CG2 THR U 175     -23.072  17.203  70.202 -0.02  2.00     0.042 C
ATOM   1657  H   THR U 175     -22.657  16.707  67.076  0.40  1.00     0.163 HD
ATOM   1658  HG1 THR U 175     -24.474  19.512  68.363  0.49  1.00     0.210 HD
ATOM   1659  N   ASP U 176     -26.597  17.810  67.524 -0.40  1.50    -0.345 N
ATOM   1660  CA  ASP U 176     -27.340  18.787  66.746  0.19  2.00     0.186 C
ATOM   1661  C   ASP U 176     -26.767  20.177  67.025  0.55  1.70     0.241 C
ATOM   1662  O   ASP U 176     -25.829  20.342  67.810 -0.55  1.40    -0.271 OA
ATOM   1663  CB  ASP U 176     -28.833  18.706  67.062  0.10  2.00     0.147 C
ATOM   1664  CG  ASP U 176     -29.127  18.779  68.551  0.10  1.70     0.175 C
ATOM   1665  OD1 ASP U 176     -28.308  19.340  69.309 -0.55  1.40    -0.648 OA
ATOM   1666  OD2 ASP U 176     -30.193  18.278  68.967 -0.55  1.40    -0.648 OA
ATOM   1667  H   ASP U 176     -26.950  17.364  68.383  0.40  1.00     0.163 HD
ATOM   1668  N   LEU U 177     -27.336  21.196  66.384 -0.40  1.50    -0.346 N
ATOM   1669  CA  LEU U 177     -26.765  22.531  66.521  0.18  2.00     0.177 C
ATOM   1670  C   LEU U 177     -27.097  23.194  67.852  0.55  1.70     0.241 C
ATOM   1671  O   LEU U 177     -26.627  24.310  68.094 -0.55  1.40    -0.271 OA
ATOM   1672  CB  LEU U 177     -27.213  23.423  65.359  0.00  2.00     0.038 C
ATOM   1673  CG  LEU U 177     -26.192  23.530  64.223 -0.02  2.00    -0.020 C
ATOM   1674  CD1 LEU U 177     -24.893  24.130  64.742 -0.05  2.00     0.009 C
ATOM   1675  CD2 LEU U 177     -25.936  22.174  63.580 -0.05  2.00     0.009 C
ATOM   1676  H   LEU U 177     -28.158  20.970  65.823  0.40  1.00     0.163 HD
ATOM   1677  N   GLU U 178     -27.881  22.545  68.708 -0.40  1.50    -0.346 N
ATOM   1678  CA  GLU U 178     -28.137  23.000  70.069  0.18  2.00     0.177 C
ATOM   1679  C   GLU U 178     -27.211  22.346  71.086  0.55  1.70     0.240 C
ATOM   1680  O   GLU U 178     -27.408  22.527  72.293 -0.55  1.40    -0.271 OA
ATOM   1681  CB  GLU U 178     -29.596  22.728  70.455  0.01  2.00     0.045 C
ATOM   1682  CG  GLU U 178     -30.603  22.994  69.339  0.07  2.00     0.116 C
ATOM   1683  CD  GLU U 178     -31.132  24.411  69.373  0.10  1.70     0.172 C
ATOM   1684  OE1 GLU U 178     -30.472  25.274  69.991 -0.55  1.40    -0.648 OA
ATOM   1685  OE2 GLU U 178     -32.202  24.659  68.777 -0.55  1.40    -0.648 OA
ATOM   1686  H   GLU U 178     -28.305  21.667  68.315  0.40  1.00     0.163 HD
ATOM   1687  N   GLY U 179     -26.234  21.562  70.630 -0.40  1.50    -0.351 N
ATOM   1688  CA  GLY U 179     -25.243  20.969  71.502  0.15  2.00     0.225 C
ATOM   1689  C   GLY U 179     -25.615  19.635  72.107  0.55  1.70     0.236 C
ATOM   1690  O   GLY U 179     -24.836  19.097  72.903 -0.55  1.40    -0.272 OA
ATOM   1691  H   GLY U 179     -26.251  21.418  69.595  0.40  1.00     0.163 HD
ATOM   1692  N   ASN U 180     -26.770  19.079  71.762 -0.40  1.50    -0.346 N
ATOM   1693  CA  ASN U 180     -27.215  17.821  72.345  0.18  2.00     0.185 C
ATOM   1694  C   ASN U 180     -26.740  16.665  71.474  0.55  1.70     0.241 C
ATOM   1695  O   ASN U 180     -27.064  16.602  70.282 -0.55  1.40    -0.271 OA
ATOM   1696  CB  ASN U 180     -28.734  17.811  72.497  0.09  2.00     0.137 C
ATOM   1697  CG  ASN U 180     -29.230  18.923  73.398  0.55  1.70     0.217 C
ATOM   1698  H   ASN U 180     -27.316  19.609  71.055  0.40  1.00     0.163 HD
ATOM   1699  OD1 ASN U 180     -28.937  18.946  74.594 -0.55  1.40    -0.274 OA
ATOM   1700  ND2 ASN U 180     -29.981  19.855  72.827 -0.78  1.50    -0.370 N
ATOM   1701 1HD2 ASN U 180     -30.197  19.795  71.850  0.39  1.00     0.159 HD
ATOM   1702 2HD2 ASN U 180     -30.334  20.618  73.368  0.39  1.00     0.159 HD
ATOM   1703  N   PHE U 181     -25.981  15.753  72.077 -0.40  1.50    -0.346 N
ATOM   1704  CA  PHE U 181     -25.398  14.642  71.338  0.18  2.00     0.180 C
ATOM   1705  C   PHE U 181     -26.479  13.740  70.757  0.55  1.70     0.241 C
ATOM   1706  O   PHE U 181     -27.564  13.582  71.323 -0.55  1.40    -0.271 OA
ATOM   1707  CB  PHE U 181     -24.481  13.819  72.247  0.03  2.00     0.073 C
ATOM   1708  CG  PHE U 181     -23.017  14.038  71.995 -0.12  1.70    -0.056 A
ATOM   1709  CD1 PHE U 181     -22.363  13.354  70.983  0.01  1.70     0.007 A
ATOM   1710  CD2 PHE U 181     -22.293  14.923  72.777  0.01  1.70     0.007 A
ATOM   1711  CE1 PHE U 181     -21.015  13.554  70.752  0.00  1.70     0.001 A
ATOM   1712  CE2 PHE U 181     -20.946  15.127  72.550  0.00  1.70     0.001 A
ATOM   1713  CZ  PHE U 181     -20.306  14.442  71.537  0.00  1.70     0.000 A
ATOM   1714  H   PHE U 181     -25.846  15.901  73.094  0.40  1.00     0.163 HD
ATOM   1715  N   TYR U 182     -26.172  13.150  69.604 -0.40  1.50    -0.346 N
ATOM   1716  CA  TYR U 182     -26.962  12.046  69.071  0.18  2.00     0.180 C
ATOM   1717  C   TYR U 182     -26.467  10.762  69.725  0.55  1.70     0.241 C
ATOM   1718  O   TYR U 182     -25.329  10.342  69.494 -0.55  1.40    -0.271 OA
ATOM   1719  CB  TYR U 182     -26.837  11.965  67.552  0.03  2.00     0.073 C
ATOM   1720  CG  TYR U 182     -27.578  13.040  66.788 -0.12  1.70    -0.056 A
ATOM   1721  CD1 TYR U 182     -28.946  12.945  66.566  0.01  1.70     0.010 A
ATOM   1722  CD2 TYR U 182     -26.905  14.139  66.271  0.01  1.70     0.010 A
ATOM   1723  CE1 TYR U 182     -29.624  13.923  65.860  0.04  1.70     0.037 A
ATOM   1724  CE2 TYR U 182     -27.575  15.121  65.564  0.04  1.70     0.037 A
ATOM   1725  CZ  TYR U 182     -28.934  15.008  65.362  0.06  1.70     0.065 A
ATOM   1726  OH  TYR U 182     -29.603  15.983  64.659 -0.49  1.40    -0.361 OA
ATOM   1727  H   TYR U 182     -25.335  13.539  69.126  0.40  1.00     0.163 HD
ATOM   1728  HH  TYR U 182     -28.947  16.504  64.116  0.43  1.00     0.217 HD
ATOM   1729  N   GLY U 183     -27.305  10.147  70.556 -0.40  1.50    -0.351 N
ATOM   1730  CA  GLY U 183     -26.962   8.895  71.186  0.15  2.00     0.225 C
ATOM   1731  C   GLY U 183     -26.318   9.060  72.547  0.55  1.70     0.238 C
ATOM   1732  O   GLY U 183     -26.182  10.171  73.068 -0.55  1.40    -0.272 OA
ATOM   1733  H   GLY U 183     -28.208  10.643  70.704  0.40  1.00     0.163 HD
ATOM   1734  N   PRO U 184     -25.898   7.935  73.152 -0.56  1.50    -0.337 N
ATOM   1735  CA  PRO U 184     -25.339   7.951  74.509  0.18  2.00     0.179 C
ATOM   1736  C   PRO U 184     -23.844   8.253  74.541  0.55  1.70     0.241 C
ATOM   1737  O   PRO U 184     -23.060   7.562  75.201 -0.55  1.40    -0.271 OA
ATOM   1738  CB  PRO U 184     -25.635   6.528  75.004  0.00  2.00     0.037 C
ATOM   1739  CG  PRO U 184     -25.508   5.698  73.760 -0.01  2.00     0.022 C
ATOM   1740  CD  PRO U 184     -25.977   6.568  72.606  0.06  2.00     0.127 C
ATOM   1741  N   PHE U 185     -23.436   9.298  73.830 -0.40  1.50    -0.346 N
ATOM   1742  CA  PHE U 185     -22.032   9.643  73.683  0.18  2.00     0.180 C
ATOM   1743  C   PHE U 185     -21.727  10.963  74.380  0.55  1.70     0.241 C
ATOM   1744  O   PHE U 185     -22.596  11.829  74.517 -0.55  1.40    -0.271 OA
ATOM   1745  CB  PHE U 185     -21.649   9.727  72.203  0.03  2.00     0.073 C
ATOM   1746  CG  PHE U 185     -22.037   8.512  71.409 -0.12  1.70    -0.056 A
ATOM   1747  CD1 PHE U 185     -21.517   7.268  71.722  0.01  1.70     0.007 A
ATOM   1748  CD2 PHE U 185     -22.924   8.614  70.350  0.01  1.70     0.007 A
ATOM   1749  CE1 PHE U 185     -21.874   6.148  70.995  0.00  1.70     0.001 A
ATOM   1750  CE2 PHE U 185     -23.284   7.499  69.618  0.00  1.70     0.001 A
ATOM   1751  CZ  PHE U 185     -22.759   6.264  69.942  0.00  1.70     0.000 A
ATOM   1752  H   PHE U 185     -24.209   9.847  73.389  0.40  1.00     0.163 HD
ATOM   1753  N   VAL U 186     -20.479  11.103  74.826 -0.40  1.50    -0.346 N
ATOM   1754  CA  VAL U 186     -20.018  12.289  75.535  0.18  2.00     0.180 C
ATOM   1755  C   VAL U 186     -18.704  12.748  74.921  0.55  1.70     0.241 C
ATOM   1756  O   VAL U 186     -17.918  11.941  74.414 -0.55  1.40    -0.271 OA
ATOM   1757  CB  VAL U 186     -19.850  12.026  77.049  0.01  2.00     0.009 C
ATOM   1758  CG1 VAL U 186     -21.209  11.867  77.714 -0.04  2.00     0.012 C
ATOM   1759  CG2 VAL U 186     -18.990  10.794  77.281 -0.04  2.00     0.012 C
ATOM   1760  H   VAL U 186     -19.858  10.284  74.621  0.40  1.00     0.163 HD
ATOM   1761  N   ASP U 187     -18.462  14.058  74.974 -0.40  1.50    -0.345 N
ATOM   1762  CA  ASP U 187     -17.285  14.649  74.335  0.19  2.00     0.186 C
ATOM   1763  C   ASP U 187     -16.080  14.562  75.275  0.55  1.70     0.241 C
ATOM   1764  O   ASP U 187     -15.610  15.547  75.849 -0.55  1.40    -0.271 OA
ATOM   1765  CB  ASP U 187     -17.570  16.085  73.910  0.10  2.00     0.147 C
ATOM   1766  CG  ASP U 187     -18.234  16.899  75.003  0.10  1.70     0.175 C
ATOM   1767  OD1 ASP U 187     -18.687  16.304  76.002 -0.55  1.40    -0.648 OA
ATOM   1768  OD2 ASP U 187     -18.304  18.138  74.859 -0.55  1.40    -0.648 OA
ATOM   1769  H   ASP U 187     -19.166  14.611  75.497  0.40  1.00     0.163 HD
ATOM   1770  N   ARG U 188     -15.579  13.337  75.418 -0.40  1.50    -0.346 N
ATOM   1771  CA  ARG U 188     -14.355  13.079  76.161  0.18  2.00     0.176 C
ATOM   1772  C   ARG U 188     -13.724  11.804  75.623  0.55  1.70     0.241 C
ATOM   1773  O   ARG U 188     -14.419  10.908  75.136 -0.55  1.40    -0.271 OA
ATOM   1774  CB  ARG U 188     -14.612  12.971  77.671  0.00  2.00     0.036 C
ATOM   1775  CG  ARG U 188     -15.279  11.681  78.112 -0.01  2.00     0.023 C
ATOM   1776  CD  ARG U 188     -15.488  11.659  79.620  0.07  2.00     0.138 C
ATOM   1777  NE  ARG U 188     -16.780  12.223  80.002 -0.35  1.50    -0.227 N
ATOM   1778  CZ  ARG U 188     -16.946  13.445  80.498  0.35  1.70     0.665 C
ATOM   1779  NH1 ARG U 188     -15.900  14.242  80.676 -0.70  1.50    -0.235 N
ATOM   1780  NH2 ARG U 188     -18.161  13.872  80.816 -0.70  1.50    -0.235 N
ATOM   1781  H   ARG U 188     -16.137  12.587  74.955  0.40  1.00     0.163 HD
ATOM   1782  HE  ARG U 188     -17.598  11.648  79.882  0.45  1.00     0.177 HD
ATOM   1783 1HH1 ARG U 188     -14.981  13.950  80.425  0.40  1.00     0.174 HD
ATOM   1784 2HH1 ARG U 188     -16.036  15.159  81.071  0.40  1.00     0.174 HD
ATOM   1785 1HH2 ARG U 188     -18.953  13.275  80.661  0.40  1.00     0.174 HD
ATOM   1786 2HH2 ARG U 188     -18.290  14.781  81.206  0.40  1.00     0.174 HD
ATOM   1787  N   GLN U 189     -12.396  11.733  75.709 -0.40  1.50    -0.346 N
ATOM   1788  CA  GLN U 189     -11.641  10.633  75.105  0.18  2.00     0.177 C
ATOM   1789  C   GLN U 189     -11.563   9.455  76.078  0.55  1.70     0.241 C
ATOM   1790  O   GLN U 189     -10.526   9.149  76.671 -0.55  1.40    -0.271 OA
ATOM   1791  CB  GLN U 189     -10.259  11.109  74.679  0.01  2.00     0.044 C
ATOM   1792  CG  GLN U 189     -10.292  12.189  73.610  0.06  2.00     0.105 C
ATOM   1793  CD  GLN U 189      -9.031  12.221  72.770  0.55  1.70     0.215 C
ATOM   1794  H   GLN U 189     -11.951  12.511  76.232  0.40  1.00     0.163 HD
ATOM   1795  OE1 GLN U 189      -9.029  12.743  71.655 -0.55  1.40    -0.274 OA
ATOM   1796  NE2 GLN U 189      -7.950  11.661  73.302 -0.78  1.50    -0.370 N
ATOM   1797 1HE2 GLN U 189      -7.071  11.632  72.792  0.39  1.00     0.159 HD
ATOM   1798 2HE2 GLN U 189      -8.015  11.258  74.236  0.39  1.00     0.159 HD
ATOM   1799  N   THR U 190     -12.702   8.787  76.228 -0.40  1.50    -0.344 N
ATOM   1800  CA  THR U 190     -12.814   7.564  77.007  0.20  2.00     0.205 C
ATOM   1801  C   THR U 190     -13.344   6.446  76.119  0.55  1.70     0.243 C
ATOM   1802  O   THR U 190     -13.749   6.665  74.974 -0.55  1.40    -0.271 OA
ATOM   1803  CB  THR U 190     -13.733   7.754  78.222  0.15  2.00     0.146 C
ATOM   1804  OG1 THR U 190     -15.045   8.123  77.779 -0.49  1.40    -0.393 OA
ATOM   1805  CG2 THR U 190     -13.185   8.833  79.143 -0.02  2.00     0.042 C
ATOM   1806  H   THR U 190     -13.520   9.222  75.732  0.40  1.00     0.163 HD
ATOM   1807  HG1 THR U 190     -14.991   8.874  77.113  0.49  1.00     0.210 HD
ATOM   1808  N   ALA U 191     -13.336   5.232  76.664 -0.40  1.50    -0.346 N
ATOM   1809  CA  ALA U 191     -13.843   4.070  75.942  0.17  2.00     0.172 C
ATOM   1810  C   ALA U 191     -15.358   4.175  75.817  0.55  1.70     0.240 C
ATOM   1811  O   ALA U 191     -16.083   4.018  76.804 -0.55  1.40    -0.271 OA
ATOM   1812  CB  ALA U 191     -13.439   2.785  76.657 -0.02  2.00     0.042 C
ATOM   1813  H   ALA U 191     -12.947   5.186  77.624  0.40  1.00     0.163 HD
ATOM   1814  N   GLN U 192     -15.837   4.449  74.607 -0.40  1.50    -0.346 N
ATOM   1815  CA  GLN U 192     -17.263   4.548  74.333  0.18  2.00     0.177 C
ATOM   1816  C   GLN U 192     -17.611   3.644  73.162  0.55  1.70     0.241 C
ATOM   1817  O   GLN U 192     -16.900   3.617  72.153 -0.55  1.40    -0.271 OA
ATOM   1818  CB  GLN U 192     -17.677   5.991  74.025  0.01  2.00     0.044 C
ATOM   1819  CG  GLN U 192     -17.435   6.959  75.168  0.06  2.00     0.105 C
ATOM   1820  CD  GLN U 192     -17.848   8.375  74.827  0.55  1.70     0.215 C
ATOM   1821  H   GLN U 192     -15.104   4.586  73.875  0.40  1.00     0.163 HD
ATOM   1822  OE1 GLN U 192     -19.034   8.669  74.678 -0.55  1.40    -0.274 OA
ATOM   1823  NE2 GLN U 192     -16.869   9.262  74.699 -0.78  1.50    -0.370 N
ATOM   1824 1HE2 GLN U 192     -17.068  10.230  74.457  0.39  1.00     0.159 HD
ATOM   1825 2HE2 GLN U 192     -15.907   8.959  74.848  0.39  1.00     0.159 HD
ATOM   1826  N   ALA U 193     -18.708   2.907  73.301 -0.40  1.50    -0.346 N
ATOM   1827  CA  ALA U 193     -19.155   1.967  72.287  0.17  2.00     0.172 C
ATOM   1828  C   ALA U 193     -20.565   2.321  71.839  0.55  1.70     0.240 C
ATOM   1829  O   ALA U 193     -21.434   2.620  72.664 -0.55  1.40    -0.271 OA
ATOM   1830  CB  ALA U 193     -19.121   0.528  72.810 -0.02  2.00     0.042 C
ATOM   1831  H   ALA U 193     -19.219   3.063  74.201  0.40  1.00     0.163 HD
ATOM   1832  N   ALA U 194     -20.782   2.292  70.530 -0.40  1.50    -0.346 N
ATOM   1833  CA  ALA U 194     -22.125   2.458  70.000  0.17  2.00     0.172 C
ATOM   1834  C   ALA U 194     -22.943   1.195  70.236  0.55  1.70     0.240 C
ATOM   1835  O   ALA U 194     -22.406   0.087  70.320 -0.55  1.40    -0.271 OA
ATOM   1836  CB  ALA U 194     -22.075   2.776  68.507 -0.02  2.00     0.042 C
ATOM   1837  H   ALA U 194     -19.944   2.147  69.946  0.40  1.00     0.163 HD
ATOM   1838  N   GLY U 195     -24.253   1.373  70.352 -0.40  1.50    -0.351 N
ATOM   1839  CA  GLY U 195     -25.147   0.237  70.444  0.15  2.00     0.225 C
ATOM   1840  C   GLY U 195     -25.122  -0.599  69.179  0.55  1.70     0.236 C
ATOM   1841  O   GLY U 195     -24.599  -0.208  68.136 -0.55  1.40    -0.272 OA
ATOM   1842  H   GLY U 195     -24.563   2.358  70.370  0.40  1.00     0.163 HD
ATOM   1843  N   THR U 196     -25.699  -1.793  69.288 -0.40  1.50    -0.344 N
ATOM   1844  CA  THR U 196     -25.764  -2.699  68.149  0.20  2.00     0.205 C
ATOM   1845  C   THR U 196     -26.551  -2.055  67.016  0.55  1.70     0.243 C
ATOM   1846  O   THR U 196     -27.701  -1.644  67.201 -0.55  1.40    -0.271 OA
ATOM   1847  CB  THR U 196     -26.405  -4.025  68.560  0.15  2.00     0.146 C
ATOM   1848  OG1 THR U 196     -27.692  -3.777  69.141 -0.49  1.40    -0.393 OA
ATOM   1849  CG2 THR U 196     -25.527  -4.749  69.572 -0.02  2.00     0.042 C
ATOM   1850  H   THR U 196     -26.084  -2.012  70.221  0.40  1.00     0.163 HD
ATOM   1851  HG1 THR U 196     -28.257  -3.227  68.517  0.49  1.00     0.210 HD
ATOM   1852  N   ASP U 197     -25.925  -1.955  65.848 -0.40  1.50    -0.345 N
ATOM   1853  CA  ASP U 197     -26.566  -1.321  64.709  0.19  2.00     0.186 C
ATOM   1854  C   ASP U 197     -27.552  -2.279  64.046  0.55  1.70     0.241 C
ATOM   1855  O   ASP U 197     -27.460  -3.503  64.178 -0.55  1.40    -0.271 OA
ATOM   1856  CB  ASP U 197     -25.524  -0.854  63.692  0.10  2.00     0.147 C
ATOM   1857  CG  ASP U 197     -26.014   0.305  62.848  0.10  1.70     0.175 C
ATOM   1858  OD1 ASP U 197     -27.002   0.957  63.247 -0.55  1.40    -0.648 OA
ATOM   1859  OD2 ASP U 197     -25.414   0.563  61.783 -0.55  1.40    -0.648 OA
ATOM   1860  H   ASP U 197     -24.972  -2.356  65.825  0.40  1.00     0.163 HD
ATOM   1861  N   THR U 198     -28.512  -1.699  63.331 -0.40  1.50    -0.344 N
ATOM   1862  CA  THR U 198     -29.509  -2.459  62.593  0.20  2.00     0.205 C
ATOM   1863  C   THR U 198     -29.668  -1.846  61.209  0.55  1.70     0.243 C
ATOM   1864  O   THR U 198     -29.206  -0.734  60.940 -0.55  1.40    -0.271 OA
ATOM   1865  CB  THR U 198     -30.858  -2.491  63.326  0.15  2.00     0.146 C
ATOM   1866  OG1 THR U 198     -31.228  -1.160  63.707 -0.49  1.40    -0.393 OA
ATOM   1867  CG2 THR U 198     -30.774  -3.365  64.569 -0.02  2.00     0.042 C
ATOM   1868  H   THR U 198     -28.487  -0.654  63.346  0.40  1.00     0.163 HD
ATOM   1869  HG1 THR U 198     -30.416  -0.640  63.993  0.49  1.00     0.210 HD
ATOM   1870  N   THR U 199     -30.329  -2.587  60.324 -0.40  1.50    -0.344 N
ATOM   1871  CA  THR U 199     -30.578  -2.128  58.965  0.20  2.00     0.205 C
ATOM   1872  C   THR U 199     -31.920  -1.410  58.905  0.55  1.70     0.243 C
ATOM   1873  O   THR U 199     -32.924  -1.914  59.418 -0.55  1.40    -0.271 OA
ATOM   1874  CB  THR U 199     -30.558  -3.300  57.984  0.15  2.00     0.146 C
ATOM   1875  OG1 THR U 199     -29.278  -3.942  58.029 -0.49  1.40    -0.393 OA
ATOM   1876  CG2 THR U 199     -30.819  -2.814  56.567 -0.02  2.00     0.042 C
ATOM   1877  H   THR U 199     -30.648  -3.511  60.684  0.40  1.00     0.163 HD
ATOM   1878  HG1 THR U 199     -29.013  -4.127  58.981  0.49  1.00     0.210 HD
ATOM   1879  N   ILE U 200     -31.932  -0.232  58.283 -0.40  1.50    -0.346 N
ATOM   1880  CA  ILE U 200     -33.151   0.562  58.139  0.18  2.00     0.180 C
ATOM   1881  C   ILE U 200     -33.977  -0.076  57.025  0.55  1.70     0.241 C
ATOM   1882  O   ILE U 200     -33.675   0.083  55.841 -0.55  1.40    -0.271 OA
ATOM   1883  CB  ILE U 200     -32.842   2.032  57.850  0.01  2.00     0.013 C
ATOM   1884  CG1 ILE U 200     -31.835   2.567  58.872 -0.03  2.00     0.002 C
ATOM   1885  CG2 ILE U 200     -34.118   2.857  57.879 -0.04  2.00     0.012 C
ATOM   1886  CD1 ILE U 200     -30.780   3.474  58.276 -0.05  2.00     0.005 C
ATOM   1887  H   ILE U 200     -31.007   0.071  57.912  0.40  1.00     0.163 HD
ATOM   1888  N   THR U 201     -35.034  -0.798  57.407 -0.40  1.50    -0.344 N
ATOM   1889  CA  THR U 201     -35.790  -1.590  56.441  0.20  2.00     0.205 C
ATOM   1890  C   THR U 201     -36.511  -0.710  55.427  0.55  1.70     0.243 C
ATOM   1891  O   THR U 201     -36.513  -1.014  54.228 -0.55  1.40    -0.271 OA
ATOM   1892  CB  THR U 201     -36.789  -2.490  57.167  0.15  2.00     0.146 C
ATOM   1893  OG1 THR U 201     -36.114  -3.221  58.198 -0.49  1.40    -0.393 OA
ATOM   1894  CG2 THR U 201     -37.429  -3.469  56.193 -0.02  2.00     0.042 C
ATOM   1895  H   THR U 201     -35.259  -0.746  58.413  0.40  1.00     0.163 HD
ATOM   1896  HG1 THR U 201     -36.725  -3.363  58.984  0.49  1.00     0.210 HD
ATOM   1897  N   VAL U 202     -37.131   0.382  55.885 -0.40  1.50    -0.346 N
ATOM   1898  CA  VAL U 202     -37.892   1.234  54.974  0.18  2.00     0.180 C
ATOM   1899  C   VAL U 202     -36.980   1.869  53.933  0.55  1.70     0.241 C
ATOM   1900  O   VAL U 202     -37.407   2.141  52.804 -0.55  1.40    -0.271 OA
ATOM   1901  CB  VAL U 202     -38.685   2.294  55.768  0.01  2.00     0.009 C
ATOM   1902  CG1 VAL U 202     -37.748   3.308  56.412 -0.04  2.00     0.012 C
ATOM   1903  CG2 VAL U 202     -39.700   2.988  54.868 -0.04  2.00     0.012 C
ATOM   1904  H   VAL U 202     -37.027   0.559  56.892  0.40  1.00     0.163 HD
ATOM   1905  N   ASN U 203     -35.710   2.096  54.280 -0.40  1.50    -0.346 N
ATOM   1906  CA  ASN U 203     -34.771   2.653  53.312  0.18  2.00     0.185 C
ATOM   1907  C   ASN U 203     -34.387   1.620  52.260  0.55  1.70     0.241 C
ATOM   1908  O   ASN U 203     -34.223   1.958  51.082 -0.55  1.40    -0.271 OA
ATOM   1909  CB  ASN U 203     -33.528   3.176  54.031  0.09  2.00     0.137 C
ATOM   1910  CG  ASN U 203     -33.765   4.514  54.705  0.55  1.70     0.217 C
ATOM   1911  H   ASN U 203     -35.467   1.853  55.248  0.40  1.00     0.163 HD
ATOM   1912  OD1 ASN U 203     -34.905   4.945  54.874 -0.55  1.40    -0.274 OA
ATOM   1913  ND2 ASN U 203     -32.683   5.179  55.095 -0.78  1.50    -0.370 N
ATOM   1914 1HD2 ASN U 203     -31.774   4.792  54.932  0.39  1.00     0.159 HD
ATOM   1915 2HD2 ASN U 203     -32.774   6.064  55.550  0.39  1.00     0.159 HD
ATOM   1916  N   VAL U 204     -34.234   0.358  52.667 -0.40  1.50    -0.346 N
ATOM   1917  CA  VAL U 204     -33.919  -0.700  51.711  0.18  2.00     0.180 C
ATOM   1918  C   VAL U 204     -35.050  -0.858  50.704  0.55  1.70     0.241 C
ATOM   1919  O   VAL U 204     -34.814  -1.000  49.497 -0.55  1.40    -0.271 OA
ATOM   1920  CB  VAL U 204     -33.630  -2.020  52.449  0.01  2.00     0.009 C
ATOM   1921  CG1 VAL U 204     -33.509  -3.170  51.460 -0.04  2.00     0.012 C
ATOM   1922  CG2 VAL U 204     -32.367  -1.898  53.286 -0.04  2.00     0.012 C
ATOM   1923  H   VAL U 204     -34.354   0.205  53.679  0.40  1.00     0.163 HD
ATOM   1924  N   LEU U 205     -36.297  -0.825  51.181 -0.40  1.50    -0.346 N
ATOM   1925  CA  LEU U 205     -37.438  -0.964  50.284  0.18  2.00     0.177 C
ATOM   1926  C   LEU U 205     -37.516   0.199  49.305  0.55  1.70     0.241 C
ATOM   1927  O   LEU U 205     -37.776  -0.001  48.113 -0.55  1.40    -0.271 OA
ATOM   1928  CB  LEU U 205     -38.729  -1.076  51.094  0.00  2.00     0.038 C
ATOM   1929  CG  LEU U 205     -38.919  -2.390  51.854 -0.02  2.00    -0.020 C
ATOM   1930  CD1 LEU U 205     -40.077  -2.286  52.833 -0.05  2.00     0.009 C
ATOM   1931  CD2 LEU U 205     -39.133  -3.543  50.885 -0.05  2.00     0.009 C
ATOM   1932  H   LEU U 205     -36.374  -0.697  52.200  0.40  1.00     0.163 HD
ATOM   1933  N   ALA U 206     -37.290   1.424  49.789 -0.40  1.50    -0.346 N
ATOM   1934  CA  ALA U 206     -37.275   2.578  48.896  0.17  2.00     0.172 C
ATOM   1935  C   ALA U 206     -36.149   2.464  47.877  0.55  1.70     0.240 C
ATOM   1936  O   ALA U 206     -36.312   2.848  46.713 -0.55  1.40    -0.271 OA
ATOM   1937  CB  ALA U 206     -37.142   3.867  49.707 -0.02  2.00     0.042 C
ATOM   1938  H   ALA U 206     -37.135   1.475  50.804  0.40  1.00     0.163 HD
ATOM   1939  N   TRP U 207     -34.999   1.934  48.298 -0.40  1.50    -0.346 N
ATOM   1940  CA  TRP U 207     -33.892   1.717  47.375  0.18  2.00     0.181 C
ATOM   1941  C   TRP U 207     -34.220   0.636  46.352  0.55  1.70     0.241 C
ATOM   1942  O   TRP U 207     -33.796   0.732  45.194 -0.55  1.40    -0.271 OA
ATOM   1943  CB  TRP U 207     -32.633   1.360  48.164  0.03  2.00     0.075 C
ATOM   1944  CG  TRP U 207     -31.469   0.929  47.333 -0.12  1.70    -0.028 A
ATOM   1945  CD1 TRP U 207     -30.689   1.718  46.539  0.10  1.70     0.096 A
ATOM   1946  CD2 TRP U 207     -30.935  -0.396  47.230 -0.00  1.70    -0.002 A
ATOM   1947  NE1 TRP U 207     -29.709   0.964  45.940 -0.40  1.50    -0.365 N
ATOM   1948  CE2 TRP U 207     -29.839  -0.337  46.348  0.00  1.70     0.042 A
ATOM   1949  CE3 TRP U 207     -31.282  -1.628  47.794  0.01  1.70     0.014 A
ATOM   1950  CZ2 TRP U 207     -29.087  -1.462  46.017  0.03  1.70     0.030 A
ATOM   1951  CZ3 TRP U 207     -30.535  -2.743  47.463  0.00  1.70     0.001 A
ATOM   1952  CH2 TRP U 207     -29.449  -2.652  46.585  0.00  1.70     0.002 A
ATOM   1953  H   TRP U 207     -34.967   1.700  49.303  0.40  1.00     0.163 HD
ATOM   1954  HE1 TRP U 207     -29.014   1.307  45.310  0.40  1.00     0.165 HD
ATOM   1955  N   LEU U 208     -34.974  -0.391  46.754 -0.40  1.50    -0.346 N
ATOM   1956  CA  LEU U 208     -35.429  -1.392  45.794  0.18  2.00     0.177 C
ATOM   1957  C   LEU U 208     -36.387  -0.781  44.781  0.55  1.70     0.241 C
ATOM   1958  O   LEU U 208     -36.365  -1.144  43.599 -0.55  1.40    -0.271 OA
ATOM   1959  CB  LEU U 208     -36.095  -2.559  46.522  0.00  2.00     0.038 C
ATOM   1960  CG  LEU U 208     -35.190  -3.465  47.360 -0.02  2.00    -0.020 C
ATOM   1961  CD1 LEU U 208     -35.997  -4.582  48.006 -0.05  2.00     0.009 C
ATOM   1962  CD2 LEU U 208     -34.061  -4.033  46.516 -0.05  2.00     0.009 C
ATOM   1963  H   LEU U 208     -35.194  -0.410  47.758  0.40  1.00     0.163 HD
ATOM   1964  N   TYR U 209     -37.239   0.145  45.226 -0.40  1.50    -0.346 N
ATOM   1965  CA  TYR U 209     -38.120   0.845  44.298  0.18  2.00     0.180 C
ATOM   1966  C   TYR U 209     -37.319   1.679  43.309  0.55  1.70     0.241 C
ATOM   1967  O   TYR U 209     -37.668   1.753  42.125 -0.55  1.40    -0.271 OA
ATOM   1968  CB  TYR U 209     -39.105   1.723  45.069  0.03  2.00     0.073 C
ATOM   1969  CG  TYR U 209     -40.334   0.986  45.545 -0.12  1.70    -0.056 A
ATOM   1970  CD1 TYR U 209     -41.285   0.526  44.643  0.01  1.70     0.010 A
ATOM   1971  CD2 TYR U 209     -40.544   0.748  46.896  0.01  1.70     0.010 A
ATOM   1972  CE1 TYR U 209     -42.410  -0.151  45.073  0.04  1.70     0.037 A
ATOM   1973  CE2 TYR U 209     -41.666   0.072  47.337  0.04  1.70     0.037 A
ATOM   1974  CZ  TYR U 209     -42.595  -0.374  46.421  0.06  1.70     0.065 A
ATOM   1975  OH  TYR U 209     -43.714  -1.047  46.852 -0.49  1.40    -0.361 OA
ATOM   1976  H   TYR U 209     -37.218   0.312  46.241  0.40  1.00     0.163 HD
ATOM   1977  HH  TYR U 209     -44.324  -1.200  46.076  0.43  1.00     0.217 HD
ATOM   1978  N   ALA U 210     -36.238   2.311  43.774 -0.40  1.50    -0.346 N
ATOM   1979  CA  ALA U 210     -35.374   3.062  42.869  0.17  2.00     0.172 C
ATOM   1980  C   ALA U 210     -34.761   2.159  41.808  0.55  1.70     0.240 C
ATOM   1981  O   ALA U 210     -34.537   2.597  40.674 -0.55  1.40    -0.271 OA
ATOM   1982  CB  ALA U 210     -34.276   3.774  43.659 -0.02  2.00     0.042 C
ATOM   1983  H   ALA U 210     -36.078   2.223  44.786  0.40  1.00     0.163 HD
ATOM   1984  N   ALA U 211     -34.482   0.901  42.156 -0.40  1.50    -0.346 N
ATOM   1985  CA  ALA U 211     -33.960  -0.041  41.173  0.17  2.00     0.172 C
ATOM   1986  C   ALA U 211     -34.998  -0.357  40.104  0.55  1.70     0.240 C
ATOM   1987  O   ALA U 211     -34.666  -0.448  38.917 -0.55  1.40    -0.271 OA
ATOM   1988  CB  ALA U 211     -33.500  -1.321  41.868 -0.02  2.00     0.042 C
ATOM   1989  H   ALA U 211     -34.662   0.667  43.142  0.40  1.00     0.163 HD
ATOM   1990  N   VAL U 212     -36.259  -0.530  40.507 -0.40  1.50    -0.346 N
ATOM   1991  CA  VAL U 212     -37.313  -0.821  39.540  0.18  2.00     0.180 C
ATOM   1992  C   VAL U 212     -37.554   0.381  38.635  0.55  1.70     0.241 C
ATOM   1993  O   VAL U 212     -37.760   0.232  37.424 -0.55  1.40    -0.271 OA
ATOM   1994  CB  VAL U 212     -38.600  -1.251  40.268  0.01  2.00     0.009 C
ATOM   1995  CG1 VAL U 212     -39.731  -1.458  39.272 -0.04  2.00     0.012 C
ATOM   1996  CG2 VAL U 212     -38.353  -2.518  41.074 -0.04  2.00     0.012 C
ATOM   1997  H   VAL U 212     -36.413  -0.443  41.521  0.40  1.00     0.163 HD
ATOM   1998  N   ILE U 213     -37.528   1.589  39.205 -0.40  1.50    -0.346 N
ATOM   1999  CA  ILE U 213     -37.674   2.796  38.398  0.18  2.00     0.180 C
ATOM   2000  C   ILE U 213     -36.529   2.914  37.400  0.55  1.70     0.241 C
ATOM   2001  O   ILE U 213     -36.690   3.498  36.321 -0.55  1.40    -0.271 OA
ATOM   2002  CB  ILE U 213     -37.774   4.035  39.312  0.01  2.00     0.013 C
ATOM   2003  CG1 ILE U 213     -38.956   3.896  40.273 -0.03  2.00     0.002 C
ATOM   2004  CG2 ILE U 213     -37.941   5.297  38.496 -0.04  2.00     0.012 C
ATOM   2005  CD1 ILE U 213     -39.157   5.095  41.178 -0.05  2.00     0.005 C
ATOM   2006  H   ILE U 213     -37.400   1.589  40.227  0.40  1.00     0.163 HD
ATOM   2007  N   ASN U 214     -35.368   2.346  37.726 -0.40  1.50    -0.346 N
ATOM   2008  CA  ASN U 214     -34.215   2.350  36.837  0.18  2.00     0.185 C
ATOM   2009  C   ASN U 214     -34.057   1.051  36.055  0.55  1.70     0.241 C
ATOM   2010  O   ASN U 214     -33.087   0.912  35.304 -0.55  1.40    -0.271 OA
ATOM   2011  CB  ASN U 214     -32.938   2.638  37.632  0.09  2.00     0.137 C
ATOM   2012  CG  ASN U 214     -32.853   4.080  38.091  0.55  1.70     0.217 C
ATOM   2013  H   ASN U 214     -35.360   1.900  38.671  0.40  1.00     0.163 HD
ATOM   2014  OD1 ASN U 214     -32.174   4.900  37.474 -0.55  1.40    -0.274 OA
ATOM   2015  ND2 ASN U 214     -33.549   4.398  39.177 -0.78  1.50    -0.370 N
ATOM   2016 1HD2 ASN U 214     -34.086   3.696  39.648  0.39  1.00     0.159 HD
ATOM   2017 2HD2 ASN U 214     -33.537   5.334  39.525  0.39  1.00     0.159 HD
ATOM   2018  N   GLY U 215     -34.972   0.100  36.216 -0.40  1.50    -0.351 N
ATOM   2019  CA  GLY U 215     -34.999  -1.067  35.358  0.15  2.00     0.225 C
ATOM   2020  C   GLY U 215     -34.272  -2.290  35.860  0.55  1.70     0.236 C
ATOM   2021  O   GLY U 215     -34.046  -3.218  35.076 -0.55  1.40    -0.272 OA
ATOM   2022  H   GLY U 215     -35.643   0.267  36.988  0.40  1.00     0.163 HD
ATOM   2023  N   ASP U 216     -33.883  -2.324  37.129 -0.40  1.50    -0.346 N
ATOM   2024  CA  ASP U 216     -33.368  -3.546  37.740  0.19  2.00     0.186 C
ATOM   2025  C   ASP U 216     -34.560  -4.257  38.365  0.55  1.70     0.241 C
ATOM   2026  O   ASP U 216     -35.069  -3.844  39.409 -0.55  1.40    -0.271 OA
ATOM   2027  CB  ASP U 216     -32.280  -3.237  38.763  0.10  2.00     0.147 C
ATOM   2028  CG  ASP U 216     -30.882  -3.415  38.197  0.10  1.70     0.175 C
ATOM   2029  OD1 ASP U 216     -30.761  -3.766  37.004 -0.55  1.40    -0.648 OA
ATOM   2030  OD2 ASP U 216     -29.903  -3.208  38.946 -0.55  1.40    -0.648 OA
ATOM   2031  H   ASP U 216     -33.975  -1.425  37.639  0.40  1.00     0.163 HD
ATOM   2032  N   ARG U 217     -35.026  -5.318  37.708 -0.40  1.50    -0.346 N
ATOM   2033  CA  ARG U 217     -36.243  -6.010  38.114  0.18  2.00     0.176 C
ATOM   2034  C   ARG U 217     -36.021  -7.493  38.384  0.55  1.70     0.241 C
ATOM   2035  O   ARG U 217     -36.995  -8.217  38.627 -0.55  1.40    -0.271 OA
ATOM   2036  CB  ARG U 217     -37.330  -5.845  37.047  0.00  2.00     0.036 C
ATOM   2037  CG  ARG U 217     -37.746  -4.408  36.784 -0.01  2.00     0.023 C
ATOM   2038  CD  ARG U 217     -38.826  -4.346  35.714  0.07  2.00     0.138 C
ATOM   2039  NE  ARG U 217     -40.026  -5.077  36.111 -0.35  1.50    -0.227 N
ATOM   2040  CZ  ARG U 217     -41.128  -4.504  36.583  0.35  1.70     0.665 C
ATOM   2041  NH1 ARG U 217     -41.187  -3.186  36.717 -0.70  1.50    -0.235 N
ATOM   2042  NH2 ARG U 217     -42.172  -5.248  36.921 -0.70  1.50    -0.235 N
ATOM   2043  H   ARG U 217     -34.450  -5.606  36.889  0.40  1.00     0.163 HD
ATOM   2044  HE  ARG U 217     -40.018  -6.080  36.021  0.45  1.00     0.177 HD
ATOM   2045 1HH1 ARG U 217     -40.424  -2.604  36.451  0.40  1.00     0.174 HD
ATOM   2046 2HH1 ARG U 217     -42.021  -2.762  37.094  0.40  1.00     0.174 HD
ATOM   2047 1HH2 ARG U 217     -42.131  -6.244  36.799  0.40  1.00     0.174 HD
ATOM   2048 2HH2 ARG U 217     -42.995  -4.824  37.293  0.40  1.00     0.174 HD
ATOM   2049  N   TRP U 218     -34.774  -7.966  38.352 -0.40  1.50    -0.346 N
ATOM   2050  CA  TRP U 218     -34.523  -9.396  38.493  0.18  2.00     0.181 C
ATOM   2051  C   TRP U 218     -34.910  -9.926  39.868  0.55  1.70     0.241 C
ATOM   2052  O   TRP U 218     -35.140 -11.132  40.009 -0.55  1.40    -0.271 OA
ATOM   2053  CB  TRP U 218     -33.050  -9.704  38.209  0.03  2.00     0.075 C
ATOM   2054  CG  TRP U 218     -32.097  -9.108  39.201 -0.12  1.70    -0.028 A
ATOM   2055  CD1 TRP U 218     -31.435  -7.920  39.089  0.10  1.70     0.096 A
ATOM   2056  CD2 TRP U 218     -31.690  -9.678  40.451 -0.00  1.70    -0.002 A
ATOM   2057  NE1 TRP U 218     -30.645  -7.713  40.194 -0.40  1.50    -0.365 N
ATOM   2058  CE2 TRP U 218     -30.784  -8.778  41.045  0.00  1.70     0.042 A
ATOM   2059  CE3 TRP U 218     -32.005 -10.862  41.127  0.01  1.70     0.014 A
ATOM   2060  CZ2 TRP U 218     -30.191  -9.023  42.281  0.03  1.70     0.030 A
ATOM   2061  CZ3 TRP U 218     -31.417 -11.102  42.354  0.00  1.70     0.001 A
ATOM   2062  CH2 TRP U 218     -30.519 -10.187  42.918  0.00  1.70     0.002 A
ATOM   2063  H   TRP U 218     -34.037  -7.259  38.224  0.40  1.00     0.163 HD
ATOM   2064  HE1 TRP U 218     -30.064  -6.917  40.353  0.40  1.00     0.165 HD
ATOM   2065  N   PHE U 219     -34.991  -9.062  40.879 -0.40  1.50    -0.346 N
ATOM   2066  CA  PHE U 219     -35.325  -9.491  42.230  0.18  2.00     0.180 C
ATOM   2067  C   PHE U 219     -36.825  -9.558  42.488  0.55  1.70     0.241 C
ATOM   2068  O   PHE U 219     -37.232 -10.074  43.535 -0.55  1.40    -0.271 OA
ATOM   2069  CB  PHE U 219     -34.677  -8.557  43.261  0.03  2.00     0.073 C
ATOM   2070  CG  PHE U 219     -34.950  -7.100  43.018 -0.12  1.70    -0.056 A
ATOM   2071  CD1 PHE U 219     -36.108  -6.507  43.495  0.01  1.70     0.007 A
ATOM   2072  CD2 PHE U 219     -34.047  -6.322  42.315  0.01  1.70     0.007 A
ATOM   2073  CE1 PHE U 219     -36.361  -5.167  43.273  0.00  1.70     0.001 A
ATOM   2074  CE2 PHE U 219     -34.292  -4.982  42.092  0.00  1.70     0.001 A
ATOM   2075  CZ  PHE U 219     -35.452  -4.404  42.569  0.00  1.70     0.000 A
ATOM   2076  H   PHE U 219     -34.798  -8.074  40.621  0.40  1.00     0.163 HD
ATOM   2077  N   LEU U 220     -37.649  -9.047  41.578 -0.40  1.50    -0.346 N
ATOM   2078  CA  LEU U 220     -39.092  -9.102  41.762  0.18  2.00     0.177 C
ATOM   2079  C   LEU U 220     -39.590 -10.539  41.667  0.55  1.70     0.241 C
ATOM   2080  O   LEU U 220     -38.970 -11.395  41.030 -0.55  1.40    -0.271 OA
ATOM   2081  CB  LEU U 220     -39.798  -8.235  40.721  0.00  2.00     0.038 C
ATOM   2082  CG  LEU U 220     -39.579  -6.726  40.837 -0.02  2.00    -0.020 C
ATOM   2083  CD1 LEU U 220     -40.188  -6.006  39.647 -0.05  2.00     0.009 C
ATOM   2084  CD2 LEU U 220     -40.157  -6.201  42.141 -0.05  2.00     0.009 C
ATOM   2085  H   LEU U 220     -37.188  -8.622  40.757  0.40  1.00     0.163 HD
ATOM   2086  N   ASN U 221     -40.724 -10.802  42.312 -0.40  1.50    -0.346 N
ATOM   2087  CA  ASN U 221     -41.298 -12.138  42.314  0.18  2.00     0.185 C
ATOM   2088  C   ASN U 221     -42.815 -12.038  42.374  0.55  1.70     0.241 C
ATOM   2089  O   ASN U 221     -43.382 -10.984  42.674 -0.55  1.40    -0.271 OA
ATOM   2090  CB  ASN U 221     -40.759 -12.979  43.479  0.09  2.00     0.137 C
ATOM   2091  CG  ASN U 221     -40.893 -12.282  44.824  0.55  1.70     0.217 C
ATOM   2092  H   ASN U 221     -41.148  -9.991  42.798  0.40  1.00     0.163 HD
ATOM   2093  OD1 ASN U 221     -41.860 -11.564  45.079 -0.55  1.40    -0.274 OA
ATOM   2094  ND2 ASN U 221     -39.917 -12.500  45.697 -0.78  1.50    -0.370 N
ATOM   2095 1HD2 ASN U 221     -39.147 -13.090  45.452  0.39  1.00     0.159 HD
ATOM   2096 2HD2 ASN U 221     -39.949 -12.075  46.602  0.39  1.00     0.159 HD
ATOM   2097  N   ARG U 222     -43.469 -13.164  42.084 -0.40  1.50    -0.346 N
ATOM   2098  CA  ARG U 222     -44.923 -13.232  42.155  0.18  2.00     0.176 C
ATOM   2099  C   ARG U 222     -45.430 -13.272  43.590  0.55  1.70     0.241 C
ATOM   2100  O   ARG U 222     -46.604 -12.969  43.826 -0.55  1.40    -0.271 OA
ATOM   2101  CB  ARG U 222     -45.425 -14.465  41.404  0.00  2.00     0.036 C
ATOM   2102  CG  ARG U 222     -44.941 -15.773  42.010 -0.01  2.00     0.023 C
ATOM   2103  CD  ARG U 222     -45.221 -16.957  41.105  0.07  2.00     0.138 C
ATOM   2104  NE  ARG U 222     -44.228 -18.013  41.282 -0.35  1.50    -0.227 N
ATOM   2105  CZ  ARG U 222     -44.288 -18.945  42.228  0.35  1.70     0.665 C
ATOM   2106  NH1 ARG U 222     -45.296 -18.954  43.090 -0.70  1.50    -0.235 N
ATOM   2107  NH2 ARG U 222     -43.338 -19.866  42.315 -0.70  1.50    -0.235 N
ATOM   2108  H   ARG U 222     -42.867 -13.961  41.812  0.40  1.00     0.163 HD
ATOM   2109  HE  ARG U 222     -43.447 -18.037  40.647  0.45  1.00     0.177 HD
ATOM   2110 1HH1 ARG U 222     -46.030 -18.283  43.034  0.40  1.00     0.174 HD
ATOM   2111 2HH1 ARG U 222     -45.322 -19.654  43.816  0.40  1.00     0.174 HD
ATOM   2112 1HH2 ARG U 222     -42.586 -19.866  41.651  0.40  1.00     0.174 HD
ATOM   2113 2HH2 ARG U 222     -43.369 -20.556  43.034  0.40  1.00     0.174 HD
ATOM   2114  N   PHE U 223     -44.577 -13.636  44.545 -0.40  1.50    -0.346 N
ATOM   2115  CA  PHE U 223     -45.010 -13.794  45.923  0.18  2.00     0.180 C
ATOM   2116  C   PHE U 223     -45.434 -12.459  46.527  0.55  1.70     0.241 C
ATOM   2117  O   PHE U 223     -45.062 -11.379  46.060 -0.55  1.40    -0.271 OA
ATOM   2118  CB  PHE U 223     -43.897 -14.390  46.789  0.03  2.00     0.073 C
ATOM   2119  CG  PHE U 223     -43.201 -15.568  46.175 -0.12  1.70    -0.056 A
ATOM   2120  CD1 PHE U 223     -43.776 -16.828  46.208  0.01  1.70     0.007 A
ATOM   2121  CD2 PHE U 223     -41.957 -15.421  45.587  0.01  1.70     0.007 A
ATOM   2122  CE1 PHE U 223     -43.128 -17.914  45.650  0.00  1.70     0.001 A
ATOM   2123  CE2 PHE U 223     -41.305 -16.501  45.027  0.00  1.70     0.001 A
ATOM   2124  CZ  PHE U 223     -41.891 -17.750  45.059  0.00  1.70     0.000 A
ATOM   2125  H   PHE U 223     -43.604 -13.792  44.224  0.40  1.00     0.163 HD
ATOM   2126  N   THR U 224     -46.234 -12.555  47.585 -0.40  1.50    -0.344 N
ATOM   2127  CA  THR U 224     -46.495 -11.455  48.498  0.20  2.00     0.205 C
ATOM   2128  C   THR U 224     -46.470 -12.025  49.909  0.55  1.70     0.243 C
ATOM   2129  O   THR U 224     -46.354 -13.238  50.107 -0.55  1.40    -0.271 OA
ATOM   2130  CB  THR U 224     -47.827 -10.759  48.195  0.15  2.00     0.146 C
ATOM   2131  OG1 THR U 224     -47.906  -9.536  48.940 -0.49  1.40    -0.393 OA
ATOM   2132  CG2 THR U 224     -48.995 -11.653  48.574 -0.02  2.00     0.042 C
ATOM   2133  H   THR U 224     -46.666 -13.508  47.704  0.40  1.00     0.163 HD
ATOM   2134  HG1 THR U 224     -47.798  -8.746  48.327  0.49  1.00     0.210 HD
ATOM   2135  N   THR U 225     -46.568 -11.146  50.901 -0.40  1.50    -0.344 N
ATOM   2136  CA  THR U 225     -46.491 -11.579  52.287  0.20  2.00     0.205 C
ATOM   2137  C   THR U 225     -47.276 -10.614  53.160  0.55  1.70     0.243 C
ATOM   2138  O   THR U 225     -47.565  -9.480  52.767 -0.55  1.40    -0.271 OA
ATOM   2139  CB  THR U 225     -45.037 -11.668  52.770  0.15  2.00     0.146 C
ATOM   2140  OG1 THR U 225     -45.002 -12.191  54.104 -0.49  1.40    -0.393 OA
ATOM   2141  CG2 THR U 225     -44.384 -10.294  52.751 -0.02  2.00     0.042 C
ATOM   2142  H   THR U 225     -46.699 -10.165  50.609  0.40  1.00     0.163 HD
ATOM   2143  HG1 THR U 225     -45.305 -11.493  54.761  0.49  1.00     0.210 HD
ATOM   2144  N   THR U 226     -47.630 -11.086  54.350 -0.40  1.50    -0.344 N
ATOM   2145  CA  THR U 226     -48.220 -10.218  55.351  0.20  2.00     0.205 C
ATOM   2146  C   THR U 226     -47.131  -9.399  56.035  0.55  1.70     0.243 C
ATOM   2147  O   THR U 226     -45.949  -9.757  56.027 -0.55  1.40    -0.271 OA
ATOM   2148  CB  THR U 226     -48.995 -11.034  56.387  0.15  2.00     0.146 C
ATOM   2149  OG1 THR U 226     -48.089 -11.880  57.105 -0.49  1.40    -0.393 OA
ATOM   2150  CG2 THR U 226     -50.048 -11.896  55.705 -0.02  2.00     0.042 C
ATOM   2151  H   THR U 226     -47.452 -12.096  54.492  0.40  1.00     0.163 HD
ATOM   2152  HG1 THR U 226     -47.979 -11.553  58.050  0.49  1.00     0.210 HD
ATOM   2153  N   LEU U 227     -47.543  -8.276  56.626 -0.40  1.50    -0.346 N
ATOM   2154  CA  LEU U 227     -46.585  -7.415  57.310  0.18  2.00     0.177 C
ATOM   2155  C   LEU U 227     -45.959  -8.114  58.510  0.55  1.70     0.241 C
ATOM   2156  O   LEU U 227     -44.781  -7.892  58.814 -0.55  1.40    -0.271 OA
ATOM   2157  CB  LEU U 227     -47.265  -6.116  57.743  0.00  2.00     0.038 C
ATOM   2158  CG  LEU U 227     -46.384  -5.090  58.458 -0.02  2.00    -0.020 C
ATOM   2159  CD1 LEU U 227     -45.169  -4.753  57.611 -0.05  2.00     0.009 C
ATOM   2160  CD2 LEU U 227     -47.177  -3.836  58.787 -0.05  2.00     0.009 C
ATOM   2161  H   LEU U 227     -48.549  -8.084  56.558  0.40  1.00     0.163 HD
ATOM   2162  N   ASN U 228     -46.723  -8.969  59.194 -0.40  1.50    -0.346 N
ATOM   2163  CA  ASN U 228     -46.198  -9.644  60.376  0.18  2.00     0.185 C
ATOM   2164  C   ASN U 228     -45.209 -10.740  60.000  0.55  1.70     0.241 C
ATOM   2165  O   ASN U 228     -44.176 -10.902  60.659 -0.55  1.40    -0.271 OA
ATOM   2166  CB  ASN U 228     -47.347 -10.217  61.205  0.09  2.00     0.137 C
ATOM   2167  CG  ASN U 228     -48.001  -9.176  62.089  0.55  1.70     0.217 C
ATOM   2168  H   ASN U 228     -47.674  -9.102  58.826  0.40  1.00     0.163 HD
ATOM   2169  OD1 ASN U 228     -49.181  -8.861  61.930 -0.55  1.40    -0.274 OA
ATOM   2170  ND2 ASN U 228     -47.236  -8.631  63.028 -0.78  1.50    -0.370 N
ATOM   2171 1HD2 ASN U 228     -46.278  -8.912  63.116  0.39  1.00     0.159 HD
ATOM   2172 2HD2 ASN U 228     -47.613  -7.942  63.646  0.39  1.00     0.159 HD
ATOM   2173  N   ASP U 229     -45.508 -11.504  58.946 -0.40  1.50    -0.345 N
ATOM   2174  CA  ASP U 229     -44.587 -12.553  58.521  0.19  2.00     0.186 C
ATOM   2175  C   ASP U 229     -43.296 -11.972  57.962  0.55  1.70     0.241 C
ATOM   2176  O   ASP U 229     -42.241 -12.611  58.052 -0.55  1.40    -0.271 OA
ATOM   2177  CB  ASP U 229     -45.259 -13.460  57.491  0.10  2.00     0.147 C
ATOM   2178  CG  ASP U 229     -46.033 -14.594  58.134  0.10  1.70     0.175 C
ATOM   2179  OD1 ASP U 229     -47.225 -14.397  58.453 -0.55  1.40    -0.648 OA
ATOM   2180  OD2 ASP U 229     -45.449 -15.682  58.325 -0.55  1.40    -0.648 OA
ATOM   2181  H   ASP U 229     -46.401 -11.295  58.487  0.40  1.00     0.163 HD
ATOM   2182  N   PHE U 230     -43.355 -10.770  57.384 -0.40  1.50    -0.346 N
ATOM   2183  CA  PHE U 230     -42.130 -10.100  56.962  0.18  2.00     0.180 C
ATOM   2184  C   PHE U 230     -41.323  -9.630  58.165  0.55  1.70     0.241 C
ATOM   2185  O   PHE U 230     -40.097  -9.789  58.198 -0.55  1.40    -0.271 OA
ATOM   2186  CB  PHE U 230     -42.459  -8.923  56.045  0.03  2.00     0.073 C
ATOM   2187  CG  PHE U 230     -41.269  -8.073  55.703 -0.12  1.70    -0.056 A
ATOM   2188  CD1 PHE U 230     -40.377  -8.472  54.721  0.01  1.70     0.007 A
ATOM   2189  CD2 PHE U 230     -41.040  -6.877  56.364  0.01  1.70     0.007 A
ATOM   2190  CE1 PHE U 230     -39.280  -7.695  54.405  0.00  1.70     0.001 A
ATOM   2191  CE2 PHE U 230     -39.944  -6.095  56.053  0.00  1.70     0.001 A
ATOM   2192  CZ  PHE U 230     -39.063  -6.504  55.072  0.00  1.70     0.000 A
ATOM   2193  H   PHE U 230     -44.298 -10.380  57.270  0.40  1.00     0.163 HD
ATOM   2194  N   ASN U 231     -41.994  -9.049  59.163 -0.40  1.50    -0.346 N
ATOM   2195  CA  ASN U 231     -41.304  -8.588  60.362  0.18  2.00     0.185 C
ATOM   2196  C   ASN U 231     -40.692  -9.738  61.151  0.55  1.70     0.241 C
ATOM   2197  O   ASN U 231     -39.744  -9.517  61.913 -0.55  1.40    -0.271 OA
ATOM   2198  CB  ASN U 231     -42.265  -7.794  61.248  0.09  2.00     0.137 C
ATOM   2199  CG  ASN U 231     -42.510  -6.390  60.729  0.55  1.70     0.217 C
ATOM   2200  H   ASN U 231     -43.011  -8.960  59.012  0.40  1.00     0.163 HD
ATOM   2201  OD1 ASN U 231     -41.604  -5.743  60.206 -0.55  1.40    -0.274 OA
ATOM   2202  ND2 ASN U 231     -43.741  -5.912  60.872 -0.78  1.50    -0.370 N
ATOM   2203 1HD2 ASN U 231     -44.446  -6.473  61.310  0.39  1.00     0.159 HD
ATOM   2204 2HD2 ASN U 231     -43.965  -4.995  60.545  0.39  1.00     0.159 HD
ATOM   2205  N   LEU U 232     -41.212 -10.957  60.990 -0.40  1.50    -0.346 N
ATOM   2206  CA  LEU U 232     -40.596 -12.111  61.635  0.18  2.00     0.177 C
ATOM   2207  C   LEU U 232     -39.250 -12.439  61.000  0.55  1.70     0.241 C
ATOM   2208  O   LEU U 232     -38.296 -12.796  61.702 -0.55  1.40    -0.271 OA
ATOM   2209  CB  LEU U 232     -41.534 -13.316  61.561  0.00  2.00     0.038 C
ATOM   2210  CG  LEU U 232     -42.569 -13.440  62.681 -0.02  2.00    -0.020 C
ATOM   2211  CD1 LEU U 232     -43.539 -14.575  62.391 -0.05  2.00     0.009 C
ATOM   2212  CD2 LEU U 232     -41.886 -13.644  64.024 -0.05  2.00     0.009 C
ATOM   2213  H   LEU U 232     -42.049 -11.004  60.396  0.40  1.00     0.163 HD
ATOM   2214  N   VAL U 233     -39.155 -12.323  59.675 -0.40  1.50    -0.346 N
ATOM   2215  CA  VAL U 233     -37.884 -12.556  59.000  0.18  2.00     0.180 C
ATOM   2216  C   VAL U 233     -36.952 -11.363  59.172  0.55  1.70     0.241 C
ATOM   2217  O   VAL U 233     -35.728 -11.531  59.241 -0.55  1.40    -0.271 OA
ATOM   2218  CB  VAL U 233     -38.124 -12.874  57.514  0.01  2.00     0.009 C
ATOM   2219  CG1 VAL U 233     -36.822 -13.265  56.829 -0.04  2.00     0.012 C
ATOM   2220  CG2 VAL U 233     -39.160 -13.978  57.369 -0.04  2.00     0.012 C
ATOM   2221  H   VAL U 233     -40.027 -12.064  59.192  0.40  1.00     0.163 HD
ATOM   2222  N   ALA U 234     -37.504 -10.150  59.254 -0.40  1.50    -0.346 N
ATOM   2223  CA  ALA U 234     -36.671  -8.965  59.431  0.17  2.00     0.172 C
ATOM   2224  C   ALA U 234     -35.930  -9.001  60.762  0.55  1.70     0.240 C
ATOM   2225  O   ALA U 234     -34.783  -8.550  60.855 -0.55  1.40    -0.271 OA
ATOM   2226  CB  ALA U 234     -37.527  -7.703  59.325 -0.02  2.00     0.042 C
ATOM   2227  H   ALA U 234     -38.531 -10.129  59.184  0.40  1.00     0.163 HD
ATOM   2228  N   MET U 235     -36.570  -9.538  61.803 -0.40  1.50    -0.346 N
ATOM   2229  CA  MET U 235     -35.920  -9.622  63.107  0.18  2.00     0.177 C
ATOM   2230  C   MET U 235     -34.730 -10.573  63.074  0.55  1.70     0.241 C
ATOM   2231  O   MET U 235     -33.694 -10.302  63.693 -0.55  1.40    -0.271 OA
ATOM   2232  CB  MET U 235     -36.929 -10.066  64.166  0.01  2.00     0.045 C
ATOM   2233  CG  MET U 235     -37.574  -8.925  64.933  0.03  2.00     0.076 C
ATOM   2234  SD  MET U 235     -38.598  -9.508  66.297 -0.53  1.85    -0.173 SA
ATOM   2235  CE  MET U 235     -40.140  -8.666  65.948  0.01  2.00     0.089 C
ATOM   2236  H   MET U 235     -37.523  -9.873  61.609  0.40  1.00     0.163 HD
ATOM   2237  N   LYS U 236     -34.859 -11.692  62.356 -0.40  1.50    -0.346 N
ATOM   2238  CA  LYS U 236     -33.779 -12.672  62.308  0.18  2.00     0.176 C
ATOM   2239  C   LYS U 236     -32.551 -12.125  61.592  0.55  1.70     0.241 C
ATOM   2240  O   LYS U 236     -31.424 -12.529  61.901 -0.55  1.40    -0.271 OA
ATOM   2241  CB  LYS U 236     -34.269 -13.953  61.630 -0.00  2.00     0.035 C
ATOM   2242  CG  LYS U 236     -33.263 -15.094  61.637 -0.03  2.00     0.004 C
ATOM   2243  CD  LYS U 236     -33.221 -15.801  60.290 -0.01  2.00     0.027 C
ATOM   2244  CE  LYS U 236     -32.220 -16.946  60.292  0.15  2.00     0.229 C
ATOM   2245  NZ  LYS U 236     -30.849 -16.487  59.928 -0.32  2.00    -0.079 N
ATOM   2246  H   LYS U 236     -35.755 -11.795  61.860  0.40  1.00     0.163 HD
ATOM   2247  HZ1 LYS U 236     -30.894 -15.941  59.092  0.33  0.00     0.274 HD
ATOM   2248  HZ2 LYS U 236     -30.478 -15.932  60.672  0.33  0.00     0.274 HD
ATOM   2249  HZ3 LYS U 236     -30.263 -17.283  59.778  0.33  0.00     0.274 HD
ATOM   2250  N   TYR U 237     -32.741 -11.203  60.647 -0.40  1.50    -0.346 N
ATOM   2251  CA  TYR U 237     -31.645 -10.635  59.874  0.18  2.00     0.180 C
ATOM   2252  C   TYR U 237     -31.255  -9.239  60.351  0.55  1.70     0.241 C
ATOM   2253  O   TYR U 237     -30.624  -8.489  59.598 -0.55  1.40    -0.271 OA
ATOM   2254  CB  TYR U 237     -32.009 -10.612  58.390  0.03  2.00     0.073 C
ATOM   2255  CG  TYR U 237     -32.051 -11.987  57.763 -0.12  1.70    -0.056 A
ATOM   2256  CD1 TYR U 237     -33.224 -12.730  57.749  0.01  1.70     0.010 A
ATOM   2257  CD2 TYR U 237     -30.915 -12.545  57.192  0.01  1.70     0.010 A
ATOM   2258  CE1 TYR U 237     -33.266 -13.989  57.180  0.04  1.70     0.037 A
ATOM   2259  CE2 TYR U 237     -30.947 -13.803  56.621  0.04  1.70     0.037 A
ATOM   2260  CZ  TYR U 237     -32.125 -14.520  56.618  0.06  1.70     0.065 A
ATOM   2261  OH  TYR U 237     -32.160 -15.773  56.050 -0.49  1.40    -0.361 OA
ATOM   2262  H   TYR U 237     -33.739 -10.927  60.512  0.40  1.00     0.163 HD
ATOM   2263  HH  TYR U 237     -32.979 -15.854  55.485  0.43  1.00     0.217 HD
ATOM   2264  N   ASN U 238     -31.619  -8.883  61.584 -0.40  1.50    -0.346 N
ATOM   2265  CA  ASN U 238     -31.241  -7.606  62.194  0.18  2.00     0.185 C
ATOM   2266  C   ASN U 238     -31.773  -6.418  61.394  0.55  1.70     0.241 C
ATOM   2267  O   ASN U 238     -31.087  -5.410  61.210 -0.55  1.40    -0.271 OA
ATOM   2268  CB  ASN U 238     -29.725  -7.504  62.376  0.09  2.00     0.137 C
ATOM   2269  CG  ASN U 238     -29.339  -6.684  63.590  0.55  1.70     0.217 C
ATOM   2270  H   ASN U 238     -32.201  -9.598  62.081  0.40  1.00     0.163 HD
ATOM   2271  OD1 ASN U 238     -30.093  -6.598  64.559 -0.55  1.40    -0.274 OA
ATOM   2272  ND2 ASN U 238     -28.160  -6.076  63.544 -0.78  1.50    -0.370 N
ATOM   2273 1HD2 ASN U 238     -27.582  -6.170  62.731  0.39  1.00     0.159 HD
ATOM   2274 2HD2 ASN U 238     -27.848  -5.525  64.317  0.39  1.00     0.159 HD
ATOM   2275  N   TYR U 239     -33.005  -6.538  60.914 -0.40  1.50    -0.346 N
ATOM   2276  CA  TYR U 239     -33.696  -5.443  60.254  0.18  2.00     0.180 C
ATOM   2277  C   TYR U 239     -34.716  -4.833  61.206  0.55  1.70     0.241 C
ATOM   2278  O   TYR U 239     -35.311  -5.527  62.035 -0.55  1.40    -0.271 OA
ATOM   2279  CB  TYR U 239     -34.400  -5.920  58.980  0.03  2.00     0.073 C
ATOM   2280  CG  TYR U 239     -33.530  -5.922  57.744 -0.12  1.70    -0.056 A
ATOM   2281  CD1 TYR U 239     -32.316  -6.593  57.728  0.01  1.70     0.010 A
ATOM   2282  CD2 TYR U 239     -33.928  -5.258  56.590  0.01  1.70     0.010 A
ATOM   2283  CE1 TYR U 239     -31.519  -6.601  56.600  0.04  1.70     0.037 A
ATOM   2284  CE2 TYR U 239     -33.139  -5.261  55.456  0.04  1.70     0.037 A
ATOM   2285  CZ  TYR U 239     -31.935  -5.934  55.466  0.06  1.70     0.065 A
ATOM   2286  OH  TYR U 239     -31.143  -5.940  54.341 -0.49  1.40    -0.361 OA
ATOM   2287  H   TYR U 239     -33.431  -7.483  61.052  0.40  1.00     0.163 HD
ATOM   2288  HH  TYR U 239     -31.176  -6.845  53.921  0.43  1.00     0.217 HD
ATOM   2289  N   GLU U 240     -34.907  -3.523  61.084 -0.40  1.50    -0.346 N
ATOM   2290  CA  GLU U 240     -35.923  -2.854  61.876  0.18  2.00     0.177 C
ATOM   2291  C   GLU U 240     -37.312  -3.344  61.467  0.55  1.70     0.243 C
ATOM   2292  O   GLU U 240     -37.544  -3.674  60.302 -0.55  1.40    -0.271 OA
ATOM   2293  CB  GLU U 240     -35.836  -1.342  61.700  0.01  2.00     0.045 C
ATOM   2294  CG  GLU U 240     -34.515  -0.739  62.137  0.07  2.00     0.116 C
ATOM   2295  CD  GLU U 240     -34.532   0.776  62.102  0.10  1.70     0.172 C
ATOM   2296  OE1 GLU U 240     -33.846   1.398  62.939 -0.55  1.40    -0.648 OA
ATOM   2297  OE2 GLU U 240     -35.234   1.346  61.239 -0.55  1.40    -0.648 OA
ATOM   2298  H   GLU U 240     -34.294  -3.049  60.405  0.40  1.00     0.163 HD
ATOM   2299  N   PRO U 241     -38.249  -3.410  62.410 -0.56  1.50    -0.337 N
ATOM   2300  CA  PRO U 241     -39.607  -3.838  62.060  0.18  2.00     0.179 C
ATOM   2301  C   PRO U 241     -40.286  -2.823  61.155  0.55  1.70     0.241 C
ATOM   2302  O   PRO U 241     -40.181  -1.611  61.358 -0.55  1.40    -0.271 OA
ATOM   2303  CB  PRO U 241     -40.311  -3.939  63.418  0.00  2.00     0.037 C
ATOM   2304  CG  PRO U 241     -39.537  -3.023  64.311 -0.01  2.00     0.022 C
ATOM   2305  CD  PRO U 241     -38.112  -3.119  63.848  0.06  2.00     0.127 C
ATOM   2306  N   LEU U 242     -40.980  -3.330  60.141 -0.40  1.50    -0.346 N
ATOM   2307  CA  LEU U 242     -41.715  -2.484  59.213  0.18  2.00     0.177 C
ATOM   2308  C   LEU U 242     -43.097  -2.190  59.782  0.55  1.70     0.241 C
ATOM   2309  O   LEU U 242     -43.827  -3.110  60.164 -0.55  1.40    -0.271 OA
ATOM   2310  CB  LEU U 242     -41.834  -3.149  57.842  0.00  2.00     0.038 C
ATOM   2311  CG  LEU U 242     -42.174  -2.196  56.695 -0.02  2.00    -0.020 C
ATOM   2312  CD1 LEU U 242     -40.953  -1.385  56.295 -0.05  2.00     0.009 C
ATOM   2313  CD2 LEU U 242     -42.730  -2.957  55.505 -0.05  2.00     0.009 C
ATOM   2314  H   LEU U 242     -40.951  -4.368  60.071  0.40  1.00     0.163 HD
ATOM   2315  N   THR U 243     -43.447  -0.912  59.839 -0.40  1.50    -0.344 N
ATOM   2316  CA  THR U 243     -44.722  -0.472  60.381  0.20  2.00     0.205 C
ATOM   2317  C   THR U 243     -45.686  -0.117  59.255  0.55  1.70     0.243 C
ATOM   2318  O   THR U 243     -45.311  -0.016  58.084 -0.55  1.40    -0.271 OA
ATOM   2319  CB  THR U 243     -44.526   0.731  61.309  0.15  2.00     0.146 C
ATOM   2320  OG1 THR U 243     -43.999   1.833  60.558 -0.49  1.40    -0.393 OA
ATOM   2321  CG2 THR U 243     -43.562   0.385  62.433 -0.02  2.00     0.042 C
ATOM   2322  H   THR U 243     -42.729  -0.251  59.462  0.40  1.00     0.163 HD
ATOM   2323  HG1 THR U 243     -43.133   1.574  60.119  0.49  1.00     0.210 HD
ATOM   2324  N   GLN U 244     -46.955   0.068  59.629 -0.40  1.50    -0.346 N
ATOM   2325  CA  GLN U 244     -47.948   0.513  58.657  0.18  2.00     0.177 C
ATOM   2326  C   GLN U 244     -47.639   1.916  58.154  0.55  1.70     0.241 C
ATOM   2327  O   GLN U 244     -47.957   2.249  57.006 -0.55  1.40    -0.271 OA
ATOM   2328  CB  GLN U 244     -49.347   0.460  59.273  0.01  2.00     0.044 C
ATOM   2329  CG  GLN U 244     -50.475   0.670  58.275  0.06  2.00     0.105 C
ATOM   2330  CD  GLN U 244     -50.549  -0.432  57.237  0.55  1.70     0.215 C
ATOM   2331  H   GLN U 244     -47.157  -0.123  60.617  0.40  1.00     0.163 HD
ATOM   2332  OE1 GLN U 244     -50.313  -1.602  57.538 -0.55  1.40    -0.274 OA
ATOM   2333  NE2 GLN U 244     -50.878  -0.062  56.005 -0.78  1.50    -0.370 N
ATOM   2334 1HE2 GLN U 244     -50.934  -0.744  55.252  0.39  1.00     0.159 HD
ATOM   2335 2HE2 GLN U 244     -51.076   0.921  55.823  0.39  1.00     0.159 HD
ATOM   2336  N   ASP U 245     -47.015   2.748  58.993 -0.40  1.50    -0.346 N
ATOM   2337  CA  ASP U 245     -46.618   4.082  58.558  0.19  2.00     0.186 C
ATOM   2338  C   ASP U 245     -45.512   4.024  57.512  0.55  1.70     0.241 C
ATOM   2339  O   ASP U 245     -45.474   4.865  56.606 -0.55  1.40    -0.271 OA
ATOM   2340  CB  ASP U 245     -46.171   4.915  59.759  0.10  2.00     0.147 C
ATOM   2341  CG  ASP U 245     -45.823   6.340  59.382  0.10  1.70     0.175 C
ATOM   2342  OD1 ASP U 245     -46.503   6.902  58.497 -0.55  1.40    -0.648 OA
ATOM   2343  OD2 ASP U 245     -44.871   6.900  59.966 -0.55  1.40    -0.648 OA
ATOM   2344  H   ASP U 245     -46.847   2.374  59.938  0.40  1.00     0.163 HD
ATOM   2345  N   HIS U 246     -44.607   3.048  57.621 -0.40  1.50    -0.346 N
ATOM   2346  CA  HIS U 246     -43.579   2.876  56.600  0.18  2.00     0.182 C
ATOM   2347  C   HIS U 246     -44.199   2.517  55.255  0.55  1.70     0.241 C
ATOM   2348  O   HIS U 246     -43.751   2.998  54.207 -0.55  1.40    -0.271 OA
ATOM   2349  CB  HIS U 246     -42.583   1.798  57.030  0.05  2.00     0.095 C
ATOM   2350  CG  HIS U 246     -41.765   2.170  58.227  0.15  1.70     0.053 A
ATOM   2351  H   HIS U 246     -44.698   2.454  58.456  0.40  1.00     0.163 HD
ATOM   2352  ND1 HIS U 246     -41.313   1.238  59.137 -0.56  1.50    -0.247 NA
ATOM   2353  CD2 HIS U 246     -41.312   3.370  58.662  0.12  1.70     0.116 A
ATOM   2354  CE1 HIS U 246     -40.619   1.847  60.081  0.21  1.70     0.207 A
ATOM   2355  NE2 HIS U 246     -40.604   3.142  59.817 -0.40  1.50    -0.359 N
ATOM   2356  HE2 HIS U 246     -40.149   3.843  60.369  0.40  1.00     0.166 HD
ATOM   2357  N   VAL U 247     -45.230   1.670  55.267 -0.40  1.50    -0.346 N
ATOM   2358  CA  VAL U 247     -45.919   1.311  54.031  0.18  2.00     0.180 C
ATOM   2359  C   VAL U 247     -46.585   2.538  53.421  0.55  1.70     0.241 C
ATOM   2360  O   VAL U 247     -46.571   2.728  52.198 -0.55  1.40    -0.271 OA
ATOM   2361  CB  VAL U 247     -46.935   0.185  54.298  0.01  2.00     0.009 C
ATOM   2362  CG1 VAL U 247     -47.749  -0.111  53.048 -0.04  2.00     0.012 C
ATOM   2363  CG2 VAL U 247     -46.221  -1.067  54.786 -0.04  2.00     0.012 C
ATOM   2364  H   VAL U 247     -45.487   1.305  56.197  0.40  1.00     0.163 HD
ATOM   2365  N   ASP U 248     -47.170   3.393  54.262 -0.40  1.50    -0.345 N
ATOM   2366  CA  ASP U 248     -47.792   4.615  53.763  0.19  2.00     0.186 C
ATOM   2367  C   ASP U 248     -46.756   5.559  53.164  0.55  1.70     0.241 C
ATOM   2368  O   ASP U 248     -47.027   6.229  52.161 -0.55  1.40    -0.271 OA
ATOM   2369  CB  ASP U 248     -48.562   5.308  54.888  0.10  2.00     0.147 C
ATOM   2370  CG  ASP U 248     -49.762   4.508  55.353  0.10  1.70     0.175 C
ATOM   2371  OD1 ASP U 248     -50.023   3.433  54.774 -0.55  1.40    -0.648 OA
ATOM   2372  OD2 ASP U 248     -50.445   4.954  56.299 -0.55  1.40    -0.648 OA
ATOM   2373  H   ASP U 248     -47.143   3.122  55.255  0.40  1.00     0.163 HD
ATOM   2374  N   ILE U 249     -45.566   5.625  53.765 -0.40  1.50    -0.346 N
ATOM   2375  CA  ILE U 249     -44.513   6.485  53.235  0.18  2.00     0.180 C
ATOM   2376  C   ILE U 249     -44.048   5.981  51.873  0.55  1.70     0.241 C
ATOM   2377  O   ILE U 249     -43.749   6.772  50.971 -0.55  1.40    -0.271 OA
ATOM   2378  CB  ILE U 249     -43.350   6.582  54.240  0.01  2.00     0.013 C
ATOM   2379  CG1 ILE U 249     -43.793   7.338  55.494 -0.03  2.00     0.002 C
ATOM   2380  CG2 ILE U 249     -42.148   7.270  53.614 -0.04  2.00     0.012 C
ATOM   2381  CD1 ILE U 249     -42.780   7.304  56.619 -0.05  2.00     0.005 C
ATOM   2382  H   ILE U 249     -45.464   5.036  54.604  0.40  1.00     0.163 HD
ATOM   2383  N   LEU U 250     -43.996   4.661  51.697 -0.40  1.50    -0.346 N
ATOM   2384  CA  LEU U 250     -43.636   4.068  50.415  0.18  2.00     0.177 C
ATOM   2385  C   LEU U 250     -44.776   4.105  49.404  0.55  1.70     0.240 C
ATOM   2386  O   LEU U 250     -44.617   3.573  48.299 -0.55  1.40    -0.271 OA
ATOM   2387  CB  LEU U 250     -43.175   2.623  50.618  0.00  2.00     0.038 C
ATOM   2388  CG  LEU U 250     -41.896   2.426  51.436 -0.02  2.00    -0.020 C
ATOM   2389  CD1 LEU U 250     -41.737   0.968  51.836 -0.05  2.00     0.009 C
ATOM   2390  CD2 LEU U 250     -40.681   2.908  50.659 -0.05  2.00     0.009 C
ATOM   2391  H   LEU U 250     -44.231   4.102  52.542  0.40  1.00     0.163 HD
ATOM   2392  N   GLY U 251     -45.907   4.714  49.754 -0.40  1.50    -0.351 N
ATOM   2393  CA  GLY U 251     -47.060   4.795  48.888  0.15  2.00     0.225 C
ATOM   2394  C   GLY U 251     -46.779   5.379  47.516  0.55  1.70     0.238 C
ATOM   2395  O   GLY U 251     -47.056   4.750  46.489 -0.55  1.40    -0.272 OA
ATOM   2396  H   GLY U 251     -45.882   5.130  50.719  0.40  1.00     0.163 HD
ATOM   2397  N   PRO U 252     -46.246   6.607  47.468 -0.56  1.50    -0.337 N
ATOM   2398  CA  PRO U 252     -45.926   7.211  46.161  0.18  2.00     0.179 C
ATOM   2399  C   PRO U 252     -45.035   6.345  45.286  0.55  1.70     0.241 C
ATOM   2400  O   PRO U 252     -45.278   6.240  44.078 -0.55  1.40    -0.271 OA
ATOM   2401  CB  PRO U 252     -45.236   8.524  46.554  0.00  2.00     0.037 C
ATOM   2402  CG  PRO U 252     -45.842   8.874  47.864 -0.01  2.00     0.022 C
ATOM   2403  CD  PRO U 252     -46.072   7.568  48.573  0.06  2.00     0.127 C
ATOM   2404  N   LEU U 253     -44.007   5.717  45.862 -0.40  1.50    -0.346 N
ATOM   2405  CA  LEU U 253     -43.181   4.803  45.081  0.18  2.00     0.177 C
ATOM   2406  C   LEU U 253     -43.956   3.555  44.678  0.55  1.70     0.241 C
ATOM   2407  O   LEU U 253     -43.698   2.984  43.612 -0.55  1.40    -0.271 OA
ATOM   2408  CB  LEU U 253     -41.928   4.420  45.869  0.00  2.00     0.038 C
ATOM   2409  CG  LEU U 253     -40.964   5.563  46.185 -0.02  2.00    -0.020 C
ATOM   2410  CD1 LEU U 253     -39.773   5.057  46.981 -0.05  2.00     0.009 C
ATOM   2411  CD2 LEU U 253     -40.508   6.244  44.904 -0.05  2.00     0.009 C
ATOM   2412  H   LEU U 253     -43.860   5.927  46.855  0.40  1.00     0.163 HD
ATOM   2413  N   SER U 254     -44.904   3.120  45.510 -0.40  1.50    -0.344 N
ATOM   2414  CA  SER U 254     -45.713   1.954  45.171  0.20  2.00     0.200 C
ATOM   2415  C   SER U 254     -46.633   2.244  43.992  0.55  1.70     0.243 C
ATOM   2416  O   SER U 254     -46.858   1.374  43.142 -0.55  1.40    -0.271 OA
ATOM   2417  CB  SER U 254     -46.526   1.510  46.386  0.12  2.00     0.199 C
ATOM   2418  OG  SER U 254     -47.106   0.235  46.173 -0.49  1.40    -0.398 OA
ATOM   2419  H   SER U 254     -45.008   3.662  46.380  0.40  1.00     0.163 HD
ATOM   2420  HG  SER U 254     -46.459  -0.348  45.684  0.49  1.00     0.209 HD
ATOM   2421  N   ALA U 255     -47.174   3.463  43.925 -0.40  1.50    -0.346 N
ATOM   2422  CA  ALA U 255     -48.091   3.809  42.845  0.17  2.00     0.172 C
ATOM   2423  C   ALA U 255     -47.350   4.013  41.529  0.55  1.70     0.240 C
ATOM   2424  O   ALA U 255     -47.828   3.589  40.471 -0.55  1.40    -0.271 OA
ATOM   2425  CB  ALA U 255     -48.883   5.062  43.216 -0.02  2.00     0.042 C
ATOM   2426  H   ALA U 255     -46.895   4.110  44.676  0.40  1.00     0.163 HD
ATOM   2427  N   GLN U 256     -46.183   4.660  41.576 -0.40  1.50    -0.346 N
ATOM   2428  CA  GLN U 256     -45.441   4.942  40.350  0.18  2.00     0.177 C
ATOM   2429  C   GLN U 256     -44.943   3.662  39.691  0.55  1.70     0.241 C
ATOM   2430  O   GLN U 256     -44.931   3.555  38.459 -0.55  1.40    -0.271 OA
ATOM   2431  CB  GLN U 256     -44.273   5.882  40.652  0.01  2.00     0.044 C
ATOM   2432  CG  GLN U 256     -43.358   6.146  39.465  0.06  2.00     0.105 C
ATOM   2433  CD  GLN U 256     -42.163   7.005  39.830  0.55  1.70     0.215 C
ATOM   2434  H   GLN U 256     -45.867   4.931  42.517  0.40  1.00     0.163 HD
ATOM   2435  OE1 GLN U 256     -42.108   7.582  40.916 -0.55  1.40    -0.274 OA
ATOM   2436  NE2 GLN U 256     -41.197   7.092  38.923 -0.78  1.50    -0.370 N
ATOM   2437 1HE2 GLN U 256     -40.371   7.661  39.091  0.39  1.00     0.159 HD
ATOM   2438 2HE2 GLN U 256     -41.295   6.576  38.049  0.39  1.00     0.159 HD
ATOM   2439  N   THR U 257     -44.534   2.678  40.492 -0.40  1.50    -0.344 N
ATOM   2440  CA  THR U 257     -43.998   1.433  39.957  0.20  2.00     0.205 C
ATOM   2441  C   THR U 257     -45.061   0.368  39.730  0.55  1.70     0.243 C
ATOM   2442  O   THR U 257     -44.793  -0.612  39.026 -0.55  1.40    -0.271 OA
ATOM   2443  CB  THR U 257     -42.927   0.869  40.895  0.15  2.00     0.146 C
ATOM   2444  OG1 THR U 257     -43.527   0.514  42.147 -0.49  1.40    -0.393 OA
ATOM   2445  CG2 THR U 257     -41.837   1.898  41.137 -0.02  2.00     0.042 C
ATOM   2446  H   THR U 257     -44.630   2.874  41.506  0.40  1.00     0.163 HD
ATOM   2447  HG1 THR U 257     -43.604   1.323  42.740  0.49  1.00     0.210 HD
ATOM   2448  N   GLY U 258     -46.251   0.530  40.303 -0.40  1.50    -0.350 N
ATOM   2449  CA  GLY U 258     -47.260  -0.503  40.199  0.15  2.00     0.225 C
ATOM   2450  C   GLY U 258     -46.953  -1.753  40.989  0.55  1.70     0.236 C
ATOM   2451  O   GLY U 258     -47.523  -2.810  40.707 -0.55  1.40    -0.272 OA
ATOM   2452  H   GLY U 258     -46.379   1.421  40.805  0.40  1.00     0.163 HD
ATOM   2453  N   ILE U 259     -46.062  -1.663  41.972 -0.40  1.50    -0.346 N
ATOM   2454  CA  ILE U 259     -45.675  -2.794  42.807  0.18  2.00     0.180 C
ATOM   2455  C   ILE U 259     -46.094  -2.484  44.235  0.55  1.70     0.241 C
ATOM   2456  O   ILE U 259     -45.639  -1.492  44.819 -0.55  1.40    -0.271 OA
ATOM   2457  CB  ILE U 259     -44.166  -3.073  42.727  0.01  2.00     0.013 C
ATOM   2458  CG1 ILE U 259     -43.769  -3.441  41.297 -0.03  2.00     0.002 C
ATOM   2459  CG2 ILE U 259     -43.774  -4.177  43.698 -0.04  2.00     0.012 C
ATOM   2460  CD1 ILE U 259     -42.287  -3.351  41.039 -0.05  2.00     0.005 C
ATOM   2461  H   ILE U 259     -45.659  -0.702  42.096  0.40  1.00     0.163 HD
ATOM   2462  N   ALA U 260     -46.962  -3.325  44.793 -0.40  1.50    -0.346 N
ATOM   2463  CA  ALA U 260     -47.414  -3.131  46.162  0.17  2.00     0.172 C
ATOM   2464  C   ALA U 260     -46.246  -3.260  47.133  0.55  1.70     0.240 C
ATOM   2465  O   ALA U 260     -45.269  -3.969  46.875 -0.55  1.40    -0.271 OA
ATOM   2466  CB  ALA U 260     -48.506  -4.143  46.512 -0.02  2.00     0.042 C
ATOM   2467  H   ALA U 260     -47.274  -4.100  44.186  0.40  1.00     0.163 HD
ATOM   2468  N   VAL U 261     -46.354  -2.555  48.262 -0.40  1.50    -0.346 N
ATOM   2469  CA  VAL U 261     -45.277  -2.556  49.249  0.18  2.00     0.180 C
ATOM   2470  C   VAL U 261     -45.039  -3.962  49.781  0.55  1.70     0.241 C
ATOM   2471  O   VAL U 261     -43.893  -4.413  49.896 -0.55  1.40    -0.271 OA
ATOM   2472  CB  VAL U 261     -45.592  -1.565  50.386  0.01  2.00     0.009 C
ATOM   2473  CG1 VAL U 261     -44.536  -1.655  51.477 -0.04  2.00     0.012 C
ATOM   2474  CG2 VAL U 261     -45.685  -0.147  49.843 -0.04  2.00     0.012 C
ATOM   2475  H   VAL U 261     -47.234  -2.030  48.369  0.40  1.00     0.163 HD
ATOM   2476  N   LEU U 262     -46.116  -4.683  50.102 -0.40  1.50    -0.346 N
ATOM   2477  CA  LEU U 262     -45.973  -6.045  50.600  0.18  2.00     0.177 C
ATOM   2478  C   LEU U 262     -45.451  -6.998  49.532  0.55  1.70     0.241 C
ATOM   2479  O   LEU U 262     -44.880  -8.039  49.875 -0.55  1.40    -0.271 OA
ATOM   2480  CB  LEU U 262     -47.307  -6.544  51.153  0.00  2.00     0.038 C
ATOM   2481  CG  LEU U 262     -47.781  -5.814  52.413 -0.02  2.00    -0.020 C
ATOM   2482  CD1 LEU U 262     -49.092  -6.394  52.919 -0.05  2.00     0.009 C
ATOM   2483  CD2 LEU U 262     -46.712  -5.864  53.497 -0.05  2.00     0.009 C
ATOM   2484  H   LEU U 262     -47.019  -4.206  49.970  0.40  1.00     0.163 HD
ATOM   2485  N   ASP U 263     -45.635  -6.671  48.251 -0.40  1.50    -0.346 N
ATOM   2486  CA  ASP U 263     -44.984  -7.444  47.199  0.19  2.00     0.186 C
ATOM   2487  C   ASP U 263     -43.481  -7.200  47.198  0.55  1.70     0.241 C
ATOM   2488  O   ASP U 263     -42.693  -8.133  47.001 -0.55  1.40    -0.271 OA
ATOM   2489  CB  ASP U 263     -45.583  -7.096  45.836  0.10  2.00     0.147 C
ATOM   2490  CG  ASP U 263     -47.021  -7.555  45.695  0.10  1.70     0.175 C
ATOM   2491  OD1 ASP U 263     -47.641  -7.900  46.722 -0.55  1.40    -0.648 OA
ATOM   2492  OD2 ASP U 263     -47.531  -7.573  44.555 -0.55  1.40    -0.648 OA
ATOM   2493  H   ASP U 263     -46.247  -5.865  48.084  0.40  1.00     0.163 HD
ATOM   2494  N   MET U 264     -43.066  -5.950  47.419 -0.40  1.50    -0.346 N
ATOM   2495  CA  MET U 264     -41.642  -5.645  47.502  0.18  2.00     0.177 C
ATOM   2496  C   MET U 264     -41.015  -6.244  48.753  0.55  1.70     0.241 C
ATOM   2497  O   MET U 264     -39.842  -6.633  48.732 -0.55  1.40    -0.271 OA
ATOM   2498  CB  MET U 264     -41.427  -4.132  47.466  0.01  2.00     0.045 C
ATOM   2499  CG  MET U 264     -39.986  -3.717  47.231  0.03  2.00     0.076 C
ATOM   2500  SD  MET U 264     -39.393  -4.188  45.594 -0.53  1.85    -0.173 SA
ATOM   2501  CE  MET U 264     -40.049  -2.855  44.595  0.01  2.00     0.089 C
ATOM   2502  H   MET U 264     -43.814  -5.250  47.521  0.40  1.00     0.163 HD
ATOM   2503  N   CYS U 265     -41.775  -6.325  49.848 -0.40  1.50    -0.345 N
ATOM   2504  CA  CYS U 265     -41.266  -6.973  51.053  0.19  2.00     0.185 C
ATOM   2505  C   CYS U 265     -41.021  -8.458  50.817  0.55  1.70     0.241 C
ATOM   2506  O   CYS U 265     -40.050  -9.022  51.335 -0.55  1.40    -0.271 OA
ATOM   2507  CB  CYS U 265     -42.240  -6.766  52.212  0.05  2.00     0.105 C
ATOM   2508  SG  CYS U 265     -42.478  -5.039  52.677 -0.29  1.85    -0.180 SA
ATOM   2509  H   CYS U 265     -42.711  -5.907  49.767  0.40  1.00     0.163 HD
ATOM   2510  HG  CYS U 265     -42.958  -4.558  51.943  0.29  1.00     0.101 HD
ATOM   2511  N   ALA U 266     -41.892  -9.107  50.039 -0.40  1.50    -0.346 N
ATOM   2512  CA  ALA U 266     -41.666 -10.505  49.688  0.17  2.00     0.172 C
ATOM   2513  C   ALA U 266     -40.402 -10.670  48.857  0.55  1.70     0.240 C
ATOM   2514  O   ALA U 266     -39.728 -11.702  48.951 -0.55  1.40    -0.271 OA
ATOM   2515  CB  ALA U 266     -42.875 -11.062  48.936 -0.02  2.00     0.042 C
ATOM   2516  H   ALA U 266     -42.700  -8.554  49.725  0.40  1.00     0.163 HD
ATOM   2517  N   SER U 267     -40.066  -9.670  48.040 -0.40  1.50    -0.344 N
ATOM   2518  CA  SER U 267     -38.810  -9.712  47.301  0.20  2.00     0.200 C
ATOM   2519  C   SER U 267     -37.622  -9.502  48.230  0.55  1.70     0.243 C
ATOM   2520  O   SER U 267     -36.579 -10.147  48.070 -0.55  1.40    -0.271 OA
ATOM   2521  CB  SER U 267     -38.817  -8.661  46.191  0.12  2.00     0.199 C
ATOM   2522  OG  SER U 267     -39.821  -8.940  45.232 -0.49  1.40    -0.398 OA
ATOM   2523  H   SER U 267     -40.746  -8.900  47.983  0.40  1.00     0.163 HD
ATOM   2524  HG  SER U 267     -40.721  -8.771  45.632  0.49  1.00     0.209 HD
ATOM   2525  N   LEU U 268     -37.760  -8.601  49.206 -0.40  1.50    -0.346 N
ATOM   2526  CA  LEU U 268     -36.692  -8.394  50.178  0.18  2.00     0.177 C
ATOM   2527  C   LEU U 268     -36.489  -9.631  51.043  0.55  1.70     0.241 C
ATOM   2528  O   LEU U 268     -35.353  -9.971  51.394 -0.55  1.40    -0.271 OA
ATOM   2529  CB  LEU U 268     -37.003  -7.174  51.045  0.00  2.00     0.038 C
ATOM   2530  CG  LEU U 268     -36.013  -6.846  52.164 -0.02  2.00    -0.020 C
ATOM   2531  CD1 LEU U 268     -34.598  -6.756  51.616 -0.05  2.00     0.009 C
ATOM   2532  CD2 LEU U 268     -36.402  -5.553  52.864 -0.05  2.00     0.009 C
ATOM   2533  H   LEU U 268     -38.652  -8.088  49.209  0.40  1.00     0.163 HD
ATOM   2534  N   LYS U 269     -37.580 -10.317  51.395 -0.40  1.50    -0.346 N
ATOM   2535  CA  LYS U 269     -37.463 -11.549  52.169  0.18  2.00     0.176 C
ATOM   2536  C   LYS U 269     -36.655 -12.597  51.415  0.55  1.70     0.241 C
ATOM   2537  O   LYS U 269     -35.828 -13.300  52.008 -0.55  1.40    -0.271 OA
ATOM   2538  CB  LYS U 269     -38.852 -12.084  52.513 -0.00  2.00     0.035 C
ATOM   2539  CG  LYS U 269     -38.846 -13.426  53.224 -0.03  2.00     0.004 C
ATOM   2540  CD  LYS U 269     -40.253 -13.987  53.349 -0.01  2.00     0.027 C
ATOM   2541  CE  LYS U 269     -41.180 -13.000  54.039  0.15  2.00     0.229 C
ATOM   2542  NZ  LYS U 269     -42.571 -13.519  54.134 -0.32  2.00    -0.079 N
ATOM   2543  H   LYS U 269     -38.473  -9.913  51.083  0.40  1.00     0.163 HD
ATOM   2544  HZ1 LYS U 269     -43.012 -13.139  54.947  0.33  0.00     0.274 HD
ATOM   2545  HZ2 LYS U 269     -43.082 -13.249  53.319  0.33  0.00     0.274 HD
ATOM   2546  HZ3 LYS U 269     -42.549 -14.516  54.200  0.33  0.00     0.274 HD
ATOM   2547  N   GLU U 270     -36.877 -12.714  50.104 -0.40  1.50    -0.346 N
ATOM   2548  CA  GLU U 270     -36.107 -13.665  49.310  0.18  2.00     0.177 C
ATOM   2549  C   GLU U 270     -34.655 -13.222  49.176  0.55  1.70     0.241 C
ATOM   2550  O   GLU U 270     -33.743 -14.057  49.190 -0.55  1.40    -0.271 OA
ATOM   2551  CB  GLU U 270     -36.747 -13.842  47.933  0.01  2.00     0.045 C
ATOM   2552  CG  GLU U 270     -38.113 -14.505  47.972  0.07  2.00     0.116 C
ATOM   2553  CD  GLU U 270     -38.161 -15.683  48.926  0.10  1.70     0.172 C
ATOM   2554  OE1 GLU U 270     -38.830 -15.573  49.975 -0.55  1.40    -0.648 OA
ATOM   2555  OE2 GLU U 270     -37.529 -16.718  48.627 -0.55  1.40    -0.648 OA
ATOM   2556  H   GLU U 270     -37.608 -12.100  49.723  0.40  1.00     0.163 HD
ATOM   2557  N   LEU U 271     -34.419 -11.914  49.046 -0.40  1.50    -0.346 N
ATOM   2558  CA  LEU U 271     -33.048 -11.415  49.005  0.18  2.00     0.177 C
ATOM   2559  C   LEU U 271     -32.335 -11.666  50.327  0.55  1.70     0.241 C
ATOM   2560  O   LEU U 271     -31.127 -11.929  50.351 -0.55  1.40    -0.271 OA
ATOM   2561  CB  LEU U 271     -33.039  -9.925  48.665  0.00  2.00     0.038 C
ATOM   2562  CG  LEU U 271     -33.507  -9.528  47.264 -0.02  2.00    -0.020 C
ATOM   2563  CD1 LEU U 271     -33.534  -8.014  47.117 -0.05  2.00     0.009 C
ATOM   2564  CD2 LEU U 271     -32.622 -10.159  46.201 -0.05  2.00     0.009 C
ATOM   2565  H   LEU U 271     -35.254 -11.319  48.981  0.40  1.00     0.163 HD
ATOM   2566  N   LEU U 272     -33.068 -11.591  51.440 -0.40  1.50    -0.346 N
ATOM   2567  CA  LEU U 272     -32.461 -11.854  52.740  0.18  2.00     0.177 C
ATOM   2568  C   LEU U 272     -32.172 -13.338  52.926  0.55  1.70     0.241 C
ATOM   2569  O   LEU U 272     -31.127 -13.710  53.472 -0.55  1.40    -0.271 OA
ATOM   2570  CB  LEU U 272     -33.373 -11.343  53.856  0.00  2.00     0.038 C
ATOM   2571  CG  LEU U 272     -33.439  -9.825  54.033 -0.02  2.00    -0.020 C
ATOM   2572  CD1 LEU U 272     -34.425  -9.451  55.129 -0.05  2.00     0.009 C
ATOM   2573  CD2 LEU U 272     -32.058  -9.269  54.332 -0.05  2.00     0.009 C
ATOM   2574  H   LEU U 272     -34.056 -11.342  51.302  0.40  1.00     0.163 HD
ATOM   2575  N   GLN U 273     -33.082 -14.202  52.471 -0.40  1.50    -0.346 N
ATOM   2576  CA  GLN U 273     -32.925 -15.635  52.691  0.18  2.00     0.177 C
ATOM   2577  C   GLN U 273     -31.999 -16.272  51.661  0.55  1.70     0.241 C
ATOM   2578  O   GLN U 273     -31.243 -17.192  51.990 -0.55  1.40    -0.271 OA
ATOM   2579  CB  GLN U 273     -34.292 -16.321  52.672  0.01  2.00     0.044 C
ATOM   2580  CG  GLN U 273     -35.164 -16.003  53.876  0.06  2.00     0.105 C
ATOM   2581  CD  GLN U 273     -36.599 -16.457  53.693  0.55  1.70     0.215 C
ATOM   2582  H   GLN U 273     -33.876 -13.778  51.968  0.40  1.00     0.163 HD
ATOM   2583  OE1 GLN U 273     -37.063 -16.649  52.569 -0.55  1.40    -0.274 OA
ATOM   2584  NE2 GLN U 273     -37.311 -16.631  54.800 -0.78  1.50    -0.370 N
ATOM   2585 1HE2 GLN U 273     -38.285 -16.921  54.756  0.39  1.00     0.159 HD
ATOM   2586 2HE2 GLN U 273     -36.865 -16.469  55.702  0.39  1.00     0.159 HD
ATOM   2587  N   ASN U 274     -32.041 -15.799  50.414 -0.40  1.50    -0.346 N
ATOM   2588  CA  ASN U 274     -31.258 -16.399  49.342  0.18  2.00     0.185 C
ATOM   2589  C   ASN U 274     -29.996 -15.622  48.997  0.55  1.70     0.241 C
ATOM   2590  O   ASN U 274     -29.052 -16.215  48.461 -0.55  1.40    -0.271 OA
ATOM   2591  CB  ASN U 274     -32.108 -16.537  48.071  0.09  2.00     0.137 C
ATOM   2592  CG  ASN U 274     -33.184 -17.594  48.200  0.55  1.70     0.217 C
ATOM   2593  H   ASN U 274     -32.668 -14.983  50.281  0.40  1.00     0.163 HD
ATOM   2594  OD1 ASN U 274     -33.065 -18.687  47.647 -0.55  1.40    -0.274 OA
ATOM   2595  ND2 ASN U 274     -34.247 -17.272  48.928 -0.78  1.50    -0.370 N
ATOM   2596 1HD2 ASN U 274     -34.306 -16.366  49.351  0.39  1.00     0.159 HD
ATOM   2597 2HD2 ASN U 274     -34.988 -17.930  49.054  0.39  1.00     0.159 HD
ATOM   2598  N   GLY U 275     -29.951 -14.326  49.285 -0.40  1.50    -0.351 N
ATOM   2599  CA  GLY U 275     -28.851 -13.511  48.817  0.15  2.00     0.225 C
ATOM   2600  C   GLY U 275     -29.093 -13.035  47.395  0.55  1.70     0.236 C
ATOM   2601  O   GLY U 275     -30.207 -13.098  46.864 -0.55  1.40    -0.272 OA
ATOM   2602  H   GLY U 275     -30.739 -13.972  49.848  0.40  1.00     0.163 HD
ATOM   2603  N   MET U 276     -28.021 -12.553  46.768 -0.40  1.50    -0.346 N
ATOM   2604  CA  MET U 276     -28.094 -12.061  45.399  0.18  2.00     0.177 C
ATOM   2605  C   MET U 276     -27.532 -13.040  44.377  0.55  1.70     0.241 C
ATOM   2606  O   MET U 276     -27.698 -12.811  43.174 -0.55  1.40    -0.271 OA
ATOM   2607  CB  MET U 276     -27.361 -10.720  45.279  0.01  2.00     0.045 C
ATOM   2608  CG  MET U 276     -27.916  -9.635  46.185  0.03  2.00     0.076 C
ATOM   2609  SD  MET U 276     -27.474  -7.976  45.639 -0.53  1.85    -0.173 SA
ATOM   2610  CE  MET U 276     -28.134  -6.996  46.984  0.01  2.00     0.089 C
ATOM   2611  H   MET U 276     -27.149 -12.560  47.331  0.40  1.00     0.163 HD
ATOM   2612  N   ASN U 277     -26.874 -14.113  44.825 -0.40  1.50    -0.346 N
ATOM   2613  CA  ASN U 277     -26.324 -15.145  43.943  0.18  2.00     0.185 C
ATOM   2614  C   ASN U 277     -25.333 -14.571  42.935  0.55  1.70     0.241 C
ATOM   2615  O   ASN U 277     -25.185 -15.093  41.827 -0.55  1.40    -0.271 OA
ATOM   2616  CB  ASN U 277     -27.436 -15.911  43.219  0.09  2.00     0.137 C
ATOM   2617  CG  ASN U 277     -28.562 -16.322  44.148  0.55  1.70     0.217 C
ATOM   2618  H   ASN U 277     -26.785 -14.153  45.868  0.40  1.00     0.163 HD
ATOM   2619  OD1 ASN U 277     -29.702 -15.881  43.995 -0.55  1.40    -0.274 OA
ATOM   2620  ND2 ASN U 277     -28.249 -17.174  45.117 -0.78  1.50    -0.370 N
ATOM   2621 1HD2 ASN U 277     -27.307 -17.504  45.206  0.39  1.00     0.159 HD
ATOM   2622 2HD2 ASN U 277     -28.949 -17.486  45.758  0.39  1.00     0.159 HD
ATOM   2623  N   GLY U 278     -24.644 -13.492  43.306 -0.40  1.50    -0.351 N
ATOM   2624  CA  GLY U 278     -23.637 -12.887  42.462  0.15  2.00     0.225 C
ATOM   2625  C   GLY U 278     -24.118 -11.726  41.617  0.55  1.70     0.236 C
ATOM   2626  O   GLY U 278     -23.292 -11.080  40.961 -0.55  1.40    -0.272 OA
ATOM   2627  H   GLY U 278     -24.897 -13.129  44.253  0.40  1.00     0.163 HD
ATOM   2628  N   ARG U 279     -25.418 -11.444  41.608 -0.40  1.50    -0.346 N
ATOM   2629  CA  ARG U 279     -25.946 -10.330  40.837  0.18  2.00     0.176 C
ATOM   2630  C   ARG U 279     -25.826  -9.033  41.636  0.55  1.70     0.241 C
ATOM   2631  O   ARG U 279     -25.415  -9.020  42.800 -0.55  1.40    -0.271 OA
ATOM   2632  CB  ARG U 279     -27.394 -10.601  40.435  0.00  2.00     0.036 C
ATOM   2633  CG  ARG U 279     -27.543 -11.605  39.305 -0.01  2.00     0.023 C
ATOM   2634  CD  ARG U 279     -28.893 -12.299  39.360  0.07  2.00     0.138 C
ATOM   2635  NE  ARG U 279     -29.126 -12.935  40.653 -0.35  1.50    -0.227 N
ATOM   2636  CZ  ARG U 279     -30.050 -13.865  40.872  0.35  1.70     0.665 C
ATOM   2637  NH1 ARG U 279     -30.832 -14.271  39.881 -0.70  1.50    -0.235 N
ATOM   2638  NH2 ARG U 279     -30.192 -14.388  42.081 -0.70  1.50    -0.235 N
ATOM   2639  H   ARG U 279     -26.005 -12.074  42.186  0.40  1.00     0.163 HD
ATOM   2640  HE  ARG U 279     -28.550 -12.651  41.428  0.45  1.00     0.177 HD
ATOM   2641 1HH1 ARG U 279     -30.731 -13.907  38.960  0.40  1.00     0.174 HD
ATOM   2642 2HH1 ARG U 279     -31.543 -14.963  40.062  0.40  1.00     0.174 HD
ATOM   2643 1HH2 ARG U 279     -29.585 -14.092  42.824  0.40  1.00     0.174 HD
ATOM   2644 2HH2 ARG U 279     -30.896 -15.073  42.255  0.40  1.00     0.174 HD
ATOM   2645  N   THR U 280     -26.187  -7.920  41.000 -0.40  1.50    -0.344 N
ATOM   2646  CA  THR U 280     -26.103  -6.607  41.618  0.20  2.00     0.205 C
ATOM   2647  C   THR U 280     -27.418  -5.863  41.438  0.55  1.70     0.243 C
ATOM   2648  O   THR U 280     -28.215  -6.167  40.546 -0.55  1.40    -0.271 OA
ATOM   2649  CB  THR U 280     -24.955  -5.771  41.030  0.15  2.00     0.146 C
ATOM   2650  OG1 THR U 280     -25.136  -5.632  39.615 -0.49  1.40    -0.393 OA
ATOM   2651  CG2 THR U 280     -23.611  -6.431  41.305 -0.02  2.00     0.042 C
ATOM   2652  H   THR U 280     -26.532  -8.074  40.027  0.40  1.00     0.163 HD
ATOM   2653  HG1 THR U 280     -26.036  -5.230  39.416  0.49  1.00     0.210 HD
ATOM   2654  N   ILE U 281     -27.634  -4.877  42.305 -0.40  1.50    -0.346 N
ATOM   2655  CA  ILE U 281     -28.798  -4.001  42.249  0.18  2.00     0.180 C
ATOM   2656  C   ILE U 281     -28.294  -2.566  42.272  0.55  1.70     0.241 C
ATOM   2657  O   ILE U 281     -27.695  -2.133  43.264 -0.55  1.40    -0.271 OA
ATOM   2658  CB  ILE U 281     -29.770  -4.251  43.414  0.01  2.00     0.013 C
ATOM   2659  CG1 ILE U 281     -30.359  -5.660  43.331 -0.03  2.00     0.002 C
ATOM   2660  CG2 ILE U 281     -30.877  -3.214  43.410 -0.04  2.00     0.012 C
ATOM   2661  CD1 ILE U 281     -31.258  -6.012  44.497 -0.05  2.00     0.005 C
ATOM   2662  H   ILE U 281     -26.888  -4.784  43.038  0.40  1.00     0.163 HD
ATOM   2663  N   LEU U 282     -28.531  -1.834  41.182 -0.40  1.50    -0.346 N
ATOM   2664  CA  LEU U 282     -28.071  -0.451  41.038  0.18  2.00     0.177 C
ATOM   2665  C   LEU U 282     -26.561  -0.343  41.244  0.55  1.70     0.240 C
ATOM   2666  O   LEU U 282     -26.058   0.635  41.801 -0.55  1.40    -0.271 OA
ATOM   2667  CB  LEU U 282     -28.821   0.485  41.990  0.00  2.00     0.038 C
ATOM   2668  CG  LEU U 282     -30.264   0.819  41.604 -0.02  2.00    -0.020 C
ATOM   2669  CD1 LEU U 282     -30.929   1.671  42.675 -0.05  2.00     0.009 C
ATOM   2670  CD2 LEU U 282     -30.310   1.518  40.254 -0.05  2.00     0.009 C
ATOM   2671  H   LEU U 282     -29.073  -2.332  40.440  0.40  1.00     0.163 HD
ATOM   2672  N   GLY U 283     -25.832  -1.362  40.794 -0.40  1.50    -0.351 N
ATOM   2673  CA  GLY U 283     -24.388  -1.368  40.897  0.15  2.00     0.225 C
ATOM   2674  C   GLY U 283     -23.833  -1.782  42.240  0.55  1.70     0.236 C
ATOM   2675  O   GLY U 283     -22.619  -1.676  42.448 -0.55  1.40    -0.272 OA
ATOM   2676  H   GLY U 283     -26.385  -2.135  40.371  0.40  1.00     0.163 HD
ATOM   2677  N   SER U 284     -24.674  -2.251  43.157 -0.40  1.50    -0.344 N
ATOM   2678  CA  SER U 284     -24.242  -2.652  44.488  0.20  2.00     0.200 C
ATOM   2679  C   SER U 284     -24.530  -4.131  44.699  0.55  1.70     0.243 C
ATOM   2680  O   SER U 284     -25.546  -4.651  44.224 -0.55  1.40    -0.271 OA
ATOM   2681  CB  SER U 284     -24.939  -1.822  45.570  0.12  2.00     0.199 C
ATOM   2682  OG  SER U 284     -24.953  -2.511  46.809 -0.49  1.40    -0.398 OA
ATOM   2683  H   SER U 284     -25.669  -2.306  42.839  0.40  1.00     0.163 HD
ATOM   2684  HG  SER U 284     -24.871  -1.853  47.557  0.49  1.00     0.209 HD
ATOM   2685  N   ALA U 285     -23.633  -4.806  45.416 -0.40  1.50    -0.346 N
ATOM   2686  CA  ALA U 285     -23.763  -6.230  45.690  0.17  2.00     0.172 C
ATOM   2687  C   ALA U 285     -24.365  -6.522  47.058  0.55  1.70     0.240 C
ATOM   2688  O   ALA U 285     -24.538  -7.694  47.404 -0.55  1.40    -0.271 OA
ATOM   2689  CB  ALA U 285     -22.401  -6.918  45.562 -0.02  2.00     0.042 C
ATOM   2690  H   ALA U 285     -22.835  -4.228  45.761  0.40  1.00     0.163 HD
ATOM   2691  N   LEU U 286     -24.680  -5.496  47.844 -0.40  1.50    -0.346 N
ATOM   2692  CA  LEU U 286     -25.411  -5.663  49.091  0.18  2.00     0.177 C
ATOM   2693  C   LEU U 286     -26.575  -4.681  49.119  0.55  1.70     0.241 C
ATOM   2694  O   LEU U 286     -26.685  -3.785  48.277 -0.55  1.40    -0.271 OA
ATOM   2695  CB  LEU U 286     -24.505  -5.478  50.320  0.00  2.00     0.038 C
ATOM   2696  CG  LEU U 286     -23.537  -4.295  50.403 -0.02  2.00    -0.020 C
ATOM   2697  CD1 LEU U 286     -24.237  -3.026  50.871 -0.05  2.00     0.009 C
ATOM   2698  CD2 LEU U 286     -22.381  -4.638  51.330 -0.05  2.00     0.009 C
ATOM   2699  H   LEU U 286     -24.359  -4.568  47.489  0.40  1.00     0.163 HD
ATOM   2700  N   LEU U 287     -27.454  -4.861  50.100 -0.40  1.50    -0.346 N
ATOM   2701  CA  LEU U 287     -28.671  -4.065  50.194  0.18  2.00     0.177 C
ATOM   2702  C   LEU U 287     -28.367  -2.731  50.866  0.55  1.70     0.241 C
ATOM   2703  O   LEU U 287     -27.907  -2.696  52.013 -0.55  1.40    -0.271 OA
ATOM   2704  CB  LEU U 287     -29.743  -4.836  50.960  0.00  2.00     0.038 C
ATOM   2705  CG  LEU U 287     -30.148  -6.166  50.315 -0.02  2.00    -0.020 C
ATOM   2706  CD1 LEU U 287     -30.899  -7.046  51.299 -0.05  2.00     0.009 C
ATOM   2707  CD2 LEU U 287     -30.980  -5.927  49.065 -0.05  2.00     0.009 C
ATOM   2708  H   LEU U 287     -27.201  -5.605  50.780  0.40  1.00     0.163 HD
ATOM   2709  N   GLU U 288     -28.626  -1.637  50.153 -0.40  1.50    -0.346 N
ATOM   2710  CA  GLU U 288     -28.346  -0.303  50.666  0.18  2.00     0.177 C
ATOM   2711  C   GLU U 288     -29.501   0.199  51.522  0.55  1.70     0.241 C
ATOM   2712  O   GLU U 288     -30.673   0.001  51.187 -0.55  1.40    -0.271 OA
ATOM   2713  CB  GLU U 288     -28.094   0.667  49.512  0.01  2.00     0.045 C
ATOM   2714  CG  GLU U 288     -27.034   0.202  48.527  0.07  2.00     0.116 C
ATOM   2715  CD  GLU U 288     -25.631   0.311  49.088  0.10  1.70     0.172 C
ATOM   2716  OE1 GLU U 288     -25.415   1.147  49.991 -0.55  1.40    -0.648 OA
ATOM   2717  OE2 GLU U 288     -24.744  -0.438  48.627 -0.55  1.40    -0.648 OA
ATOM   2718  H   GLU U 288     -29.038  -1.817  49.216  0.40  1.00     0.163 HD
ATOM   2719  N   ASP U 289     -29.164   0.864  52.632 -0.40  1.50    -0.346 N
ATOM   2720  CA  ASP U 289     -30.169   1.388  53.551  0.19  2.00     0.186 C
ATOM   2721  C   ASP U 289     -29.940   2.860  53.881  0.55  1.70     0.241 C
ATOM   2722  O   ASP U 289     -30.467   3.352  54.884 -0.55  1.40    -0.271 OA
ATOM   2723  CB  ASP U 289     -30.212   0.557  54.837  0.10  2.00     0.147 C
ATOM   2724  CG  ASP U 289     -29.010   0.794  55.732  0.10  1.70     0.175 C
ATOM   2725  OD1 ASP U 289     -27.932   1.160  55.215 -0.55  1.40    -0.648 OA
ATOM   2726  OD2 ASP U 289     -29.143   0.606  56.960 -0.55  1.40    -0.648 OA
ATOM   2727  H   ASP U 289     -28.141   0.971  52.777  0.40  1.00     0.163 HD
ATOM   2728  N   GLU U 290     -29.171   3.577  53.060 -0.40  1.50    -0.346 N
ATOM   2729  CA  GLU U 290     -28.884   4.986  53.298  0.18  2.00     0.177 C
ATOM   2730  C   GLU U 290     -29.628   5.902  52.332  0.55  1.70     0.241 C
ATOM   2731  O   GLU U 290     -29.228   7.055  52.144 -0.55  1.40    -0.271 OA
ATOM   2732  CB  GLU U 290     -27.377   5.240  53.224  0.01  2.00     0.045 C
ATOM   2733  CG  GLU U 290     -26.565   4.420  54.218  0.07  2.00     0.116 C
ATOM   2734  CD  GLU U 290     -25.689   5.277  55.113  0.10  1.70     0.172 C
ATOM   2735  OE1 GLU U 290     -25.329   6.400  54.700 -0.55  1.40    -0.648 OA
ATOM   2736  OE2 GLU U 290     -25.366   4.829  56.235 -0.55  1.40    -0.648 OA
ATOM   2737  H   GLU U 290     -28.799   3.046  52.245  0.40  1.00     0.163 HD
ATOM   2738  N   PHE U 291     -30.701   5.412  51.714 -0.40  1.50    -0.346 N
ATOM   2739  CA  PHE U 291     -31.556   6.214  50.846  0.18  2.00     0.180 C
ATOM   2740  C   PHE U 291     -32.960   6.229  51.430  0.55  1.70     0.241 C
ATOM   2741  O   PHE U 291     -33.613   5.183  51.508 -0.55  1.40    -0.271 OA
ATOM   2742  CB  PHE U 291     -31.584   5.660  49.419  0.03  2.00     0.073 C
ATOM   2743  CG  PHE U 291     -30.269   5.747  48.702 -0.12  1.70    -0.056 A
ATOM   2744  CD1 PHE U 291     -29.843   6.943  48.148  0.01  1.70     0.007 A
ATOM   2745  CD2 PHE U 291     -29.464   4.628  48.568  0.01  1.70     0.007 A
ATOM   2746  CE1 PHE U 291     -28.634   7.023  47.481  0.00  1.70     0.001 A
ATOM   2747  CE2 PHE U 291     -28.255   4.701  47.904  0.00  1.70     0.001 A
ATOM   2748  CZ  PHE U 291     -27.839   5.900  47.359  0.00  1.70     0.000 A
ATOM   2749  H   PHE U 291     -30.878   4.397  51.906  0.40  1.00     0.163 HD
ATOM   2750  N   THR U 292     -33.421   7.405  51.836 -0.40  1.50    -0.344 N
ATOM   2751  CA  THR U 292     -34.782   7.545  52.324  0.20  2.00     0.205 C
ATOM   2752  C   THR U 292     -35.765   7.531  51.157  0.55  1.70     0.245 C
ATOM   2753  O   THR U 292     -35.377   7.732  50.003 -0.55  1.40    -0.271 OA
ATOM   2754  CB  THR U 292     -34.930   8.843  53.114  0.15  2.00     0.146 C
ATOM   2755  OG1 THR U 292     -34.881   9.960  52.217 -0.49  1.40    -0.393 OA
ATOM   2756  CG2 THR U 292     -33.818   8.973  54.142 -0.02  2.00     0.042 C
ATOM   2757  H   THR U 292     -32.746   8.187  51.776  0.40  1.00     0.163 HD
ATOM   2758  HG1 THR U 292     -33.947  10.087  51.868  0.49  1.00     0.210 HD
ATOM   2759  N   PRO U 293     -37.047   7.272  51.428 -0.56  1.50    -0.337 N
ATOM   2760  CA  PRO U 293     -38.054   7.428  50.366  0.18  2.00     0.179 C
ATOM   2761  C   PRO U 293     -38.059   8.815  49.749  0.55  1.70     0.241 C
ATOM   2762  O   PRO U 293     -38.328   8.948  48.549 -0.55  1.40    -0.271 OA
ATOM   2763  CB  PRO U 293     -39.371   7.119  51.089  0.00  2.00     0.037 C
ATOM   2764  CG  PRO U 293     -38.975   6.190  52.181 -0.01  2.00     0.022 C
ATOM   2765  CD  PRO U 293     -37.614   6.646  52.636  0.06  2.00     0.127 C
ATOM   2766  N   PHE U 294     -37.763   9.854  50.535 -0.40  1.50    -0.346 N
ATOM   2767  CA  PHE U 294     -37.644  11.195  49.974  0.18  2.00     0.180 C
ATOM   2768  C   PHE U 294     -36.470  11.283  49.007  0.55  1.70     0.241 C
ATOM   2769  O   PHE U 294     -36.580  11.898  47.939 -0.55  1.40    -0.271 OA
ATOM   2770  CB  PHE U 294     -37.494  12.222  51.098  0.03  2.00     0.073 C
ATOM   2771  CG  PHE U 294     -37.046  13.579  50.629 -0.12  1.70    -0.056 A
ATOM   2772  CD1 PHE U 294     -37.962  14.491  50.131  0.01  1.70     0.007 A
ATOM   2773  CD2 PHE U 294     -35.710  13.946  50.694  0.01  1.70     0.007 A
ATOM   2774  CE1 PHE U 294     -37.555  15.740  49.699  0.00  1.70     0.001 A
ATOM   2775  CE2 PHE U 294     -35.297  15.193  50.263  0.00  1.70     0.001 A
ATOM   2776  CZ  PHE U 294     -36.221  16.091  49.766  0.00  1.70     0.000 A
ATOM   2777  H   PHE U 294     -37.632   9.629  51.531  0.40  1.00     0.163 HD
ATOM   2778  N   ASP U 295     -35.335  10.677  49.366 -0.40  1.50    -0.345 N
ATOM   2779  CA  ASP U 295     -34.169  10.702  48.488  0.19  2.00     0.186 C
ATOM   2780  C   ASP U 295     -34.461  10.007  47.164  0.55  1.70     0.241 C
ATOM   2781  O   ASP U 295     -33.961  10.422  46.112 -0.55  1.40    -0.271 OA
ATOM   2782  CB  ASP U 295     -32.974  10.046  49.182  0.10  2.00     0.147 C
ATOM   2783  CG  ASP U 295     -32.512  10.817  50.404  0.10  1.70     0.175 C
ATOM   2784  OD1 ASP U 295     -32.531  12.065  50.364 -0.55  1.40    -0.648 OA
ATOM   2785  OD2 ASP U 295     -32.130  10.174  51.406 -0.55  1.40    -0.648 OA
ATOM   2786  H   ASP U 295     -35.358  10.209  50.283  0.40  1.00     0.163 HD
ATOM   2787  N   VAL U 296     -35.273   8.949  47.197 -0.40  1.50    -0.346 N
ATOM   2788  CA  VAL U 296     -35.595   8.217  45.976  0.18  2.00     0.180 C
ATOM   2789  C   VAL U 296     -36.552   9.025  45.107  0.55  1.70     0.241 C
ATOM   2790  O   VAL U 296     -36.359   9.146  43.891 -0.55  1.40    -0.271 OA
ATOM   2791  CB  VAL U 296     -36.174   6.833  46.321  0.01  2.00     0.009 C
ATOM   2792  CG1 VAL U 296     -36.681   6.141  45.066 -0.04  2.00     0.012 C
ATOM   2793  CG2 VAL U 296     -35.128   5.982  47.023 -0.04  2.00     0.012 C
ATOM   2794  H   VAL U 296     -35.639   8.705  48.130  0.40  1.00     0.163 HD
ATOM   2795  N   VAL U 297     -37.598   9.589  45.718 -0.40  1.50    -0.346 N
ATOM   2796  CA  VAL U 297     -38.575  10.374  44.966  0.18  2.00     0.180 C
ATOM   2797  C   VAL U 297     -37.904  11.567  44.297  0.55  1.70     0.241 C
ATOM   2798  O   VAL U 297     -38.184  11.887  43.135 -0.55  1.40    -0.271 OA
ATOM   2799  CB  VAL U 297     -39.724  10.819  45.892  0.01  2.00     0.009 C
ATOM   2800  CG1 VAL U 297     -40.575  11.887  45.220 -0.04  2.00     0.012 C
ATOM   2801  CG2 VAL U 297     -40.577   9.627  46.294 -0.04  2.00     0.012 C
ATOM   2802  H   VAL U 297     -37.651   9.425  46.735  0.40  1.00     0.163 HD
ATOM   2803  N   ARG U 298     -36.998  12.232  45.015 -0.40  1.50    -0.346 N
ATOM   2804  CA  ARG U 298     -36.320  13.412  44.491  0.18  2.00     0.176 C
ATOM   2805  C   ARG U 298     -35.428  13.088  43.296  0.55  1.70     0.241 C
ATOM   2806  O   ARG U 298     -35.115  13.988  42.508 -0.55  1.40    -0.271 OA
ATOM   2807  CB  ARG U 298     -35.529  14.070  45.631  0.00  2.00     0.036 C
ATOM   2808  CG  ARG U 298     -34.202  14.721  45.273 -0.01  2.00     0.023 C
ATOM   2809  CD  ARG U 298     -33.661  15.490  46.472  0.07  2.00     0.138 C
ATOM   2810  NE  ARG U 298     -32.345  16.073  46.226 -0.35  1.50    -0.227 N
ATOM   2811  CZ  ARG U 298     -31.228  15.674  46.826  0.35  1.70     0.665 C
ATOM   2812  NH1 ARG U 298     -31.264  14.684  47.709 -0.70  1.50    -0.235 N
ATOM   2813  NH2 ARG U 298     -30.074  16.264  46.545 -0.70  1.50    -0.235 N
ATOM   2814  H   ARG U 298     -36.823  11.842  45.961  0.40  1.00     0.163 HD
ATOM   2815  HE  ARG U 298     -32.280  16.825  45.560  0.45  1.00     0.177 HD
ATOM   2816 1HH1 ARG U 298     -32.115  14.212  47.922  0.40  1.00     0.174 HD
ATOM   2817 2HH1 ARG U 298     -30.414  14.402  48.173  0.40  1.00     0.174 HD
ATOM   2818 1HH2 ARG U 298     -30.048  17.000  45.862  0.40  1.00     0.174 HD
ATOM   2819 2HH2 ARG U 298     -29.237  15.980  47.006  0.40  1.00     0.174 HD
ATOM   2820  N   GLN U 299     -35.053  11.819  43.113 -0.40  1.50    -0.346 N
ATOM   2821  CA  GLN U 299     -34.139  11.428  42.050  0.18  2.00     0.177 C
ATOM   2822  C   GLN U 299     -34.768  10.576  40.954  0.55  1.70     0.241 C
ATOM   2823  O   GLN U 299     -34.167  10.449  39.884 -0.55  1.40    -0.271 OA
ATOM   2824  CB  GLN U 299     -32.947  10.655  42.635  0.01  2.00     0.044 C
ATOM   2825  CG  GLN U 299     -31.643  11.431  42.674  0.06  2.00     0.105 C
ATOM   2826  CD  GLN U 299     -30.438  10.526  42.853  0.55  1.70     0.215 C
ATOM   2827  H   GLN U 299     -35.468  11.146  43.790  0.40  1.00     0.163 HD
ATOM   2828  OE1 GLN U 299     -29.830  10.082  41.879 -0.55  1.40    -0.274 OA
ATOM   2829  NE2 GLN U 299     -30.087  10.248  44.104 -0.78  1.50    -0.370 N
ATOM   2830 1HE2 GLN U 299     -29.299   9.638  44.302  0.39  1.00     0.159 HD
ATOM   2831 2HE2 GLN U 299     -30.623  10.659  44.867  0.39  1.00     0.159 HD
ATOM   2832  N   CYS U 300     -35.950   9.995  41.181 -0.40  1.50    -0.345 N
ATOM   2833  CA  CYS U 300     -36.463   8.962  40.288  0.19  2.00     0.185 C
ATOM   2834  C   CYS U 300     -37.876   9.184  39.762  0.55  1.70     0.242 C
ATOM   2835  O   CYS U 300     -38.303   8.426  38.886 -0.55  1.40    -0.271 OA
ATOM   2836  CB  CYS U 300     -36.423   7.591  40.983  0.05  2.00     0.105 C
ATOM   2837  SG  CYS U 300     -34.767   7.016  41.416 -0.29  1.85    -0.180 SA
ATOM   2838  H   CYS U 300     -36.449  10.334  42.019  0.40  1.00     0.163 HD
ATOM   2839  HG  CYS U 300     -34.162   7.112  40.625  0.29  1.00     0.101 HD
ATOM   2840  N   SER U 301     -38.616  10.177  40.253 -0.40  1.50    -0.344 N
ATOM   2841  CA  SER U 301     -40.000  10.343  39.824  0.20  2.00     0.200 C
ATOM   2842  C   SER U 301     -40.132  10.916  38.418  0.55  1.70     0.242 C
ATOM   2843  O   SER U 301     -41.234  10.888  37.858 -0.55  1.40    -0.271 OA
ATOM   2844  CB  SER U 301     -40.761  11.225  40.816  0.12  2.00     0.199 C
ATOM   2845  OG  SER U 301     -41.110  10.491  41.978 -0.49  1.40    -0.398 OA
ATOM   2846  H   SER U 301     -38.143  10.788  40.931  0.40  1.00     0.163 HD
ATOM   2847  HG  SER U 301     -41.429   9.582  41.714  0.49  1.00     0.209 HD
ATOM   2848  N   GLY U 302     -39.050  11.428  37.837 -0.40  1.50    -0.350 N
ATOM   2849  CA  GLY U 302     -39.082  11.879  36.459  0.15  2.00     0.225 C
ATOM   2850  C   GLY U 302     -38.753  10.763  35.488  0.55  1.70     0.236 C
ATOM   2851  O   GLY U 302     -38.308  11.013  34.363 -0.55  1.40    -0.272 OA
ATOM   2852  H   GLY U 302     -38.210  11.473  38.441  0.40  1.00     0.163 HD
ATOM   2853  N   VAL U 303     -38.967   9.520  35.922 -0.40  1.50    -0.346 N
ATOM   2854  CA  VAL U 303     -38.671   8.330  35.137  0.18  2.00     0.180 C
ATOM   2855  C   VAL U 303     -39.919   7.456  35.097  0.55  1.70     0.241 C
ATOM   2856  O   VAL U 303     -40.791   7.537  35.964 -0.55  1.40    -0.271 OA
ATOM   2857  CB  VAL U 303     -37.475   7.536  35.717  0.01  2.00     0.009 C
ATOM   2858  CG1 VAL U 303     -36.869   6.615  34.672 -0.04  2.00     0.012 C
ATOM   2859  CG2 VAL U 303     -36.415   8.479  36.278 -0.04  2.00     0.012 C
ATOM   2860  H   VAL U 303     -39.373   9.475  36.892  0.40  1.00     0.163 HD
ATOM   2861  N   THR U 304     -40.002   6.614  34.069 -0.40  1.50    -0.344 N
ATOM   2862  CA  THR U 304     -41.037   5.589  34.051  0.20  2.00     0.205 C
ATOM   2863  C   THR U 304     -40.429   4.204  33.814  0.55  1.70     0.243 C
ATOM   2864  O   THR U 304     -40.511   3.349  34.700 -0.55  1.40    -0.271 OA
ATOM   2865  CB  THR U 304     -42.140   5.955  33.037  0.15  2.00     0.146 C
ATOM   2866  OG1 THR U 304     -43.200   4.988  33.088 -0.49  1.40    -0.393 OA
ATOM   2867  CG2 THR U 304     -41.611   6.143  31.607 -0.02  2.00     0.042 C
ATOM   2868  H   THR U 304     -39.305   6.747  33.328  0.40  1.00     0.163 HD
ATOM   2869  HG1 THR U 304     -43.118   4.341  32.323  0.49  1.00     0.210 HD
ATOM   2870  N   PHE U 305     -39.779   3.983  32.668 -0.40  1.50    -0.346 N
ATOM   2871  CA  PHE U 305     -39.123   2.709  32.349  0.18  2.00     0.180 C
ATOM   2872  C   PHE U 305     -40.037   1.518  32.626  0.55  1.70     0.241 C
ATOM   2873  O   PHE U 305     -39.623   0.503  33.191 -0.55  1.40    -0.271 OA
ATOM   2874  CB  PHE U 305     -37.799   2.567  33.104  0.03  2.00     0.073 C
ATOM   2875  CG  PHE U 305     -36.716   1.894  32.306 -0.12  1.70    -0.056 A
ATOM   2876  CD1 PHE U 305     -36.485   2.260  30.994  0.01  1.70     0.007 A
ATOM   2877  CD2 PHE U 305     -35.930   0.902  32.865  0.01  1.70     0.007 A
ATOM   2878  CE1 PHE U 305     -35.492   1.649  30.250  0.00  1.70     0.001 A
ATOM   2879  CE2 PHE U 305     -34.931   0.285  32.126  0.00  1.70     0.001 A
ATOM   2880  CZ  PHE U 305     -34.712   0.661  30.818  0.00  1.70     0.000 A
ATOM   2881  H   PHE U 305     -39.777   4.799  32.013  0.40  1.00     0.163 HD
ATOM   2882  N   GLN U 306     -41.298   1.653  32.232 -0.40  1.50    -0.345 N
ATOM   2883  CA  GLN U 306     -42.296   0.612  32.439  0.19  2.00     0.186 C
ATOM   2884  C   GLN U 306     -42.032  -0.599  31.550  0.10  1.70     0.196 C
ATOM   2885  O   GLN U 306     -42.774  -1.581  31.583 -0.55  1.40    -0.646 OA
ATOM   2886  CB  GLN U 306     -43.702   1.159  32.175  0.01  2.00     0.045 C
ATOM   2887  CG  GLN U 306     -44.077   1.275  30.699  0.06  2.00     0.105 C
ATOM   2888  CD  GLN U 306     -43.097   2.109  29.893  0.55  1.70     0.215 C
ATOM   2889  OXT GLN U 306     -41.133  -0.796  30.730 -0.55  1.40    -0.646 OA
ATOM   2890  H   GLN U 306     -41.510   2.562  31.765  0.40  1.00     0.163 HD
ATOM   2891  OE1 GLN U 306     -42.557   3.100  30.385 -0.55  1.40    -0.274 OA
ATOM   2892  NE2 GLN U 306     -42.864   1.710  28.648 -0.78  1.50    -0.370 N
ATOM   2893 1HE2 GLN U 306     -42.231   2.226  28.044  0.39  1.00     0.159 HD
ATOM   2894 2HE2 GLN U 306     -43.332   0.872  28.305  0.39  1.00     0.159 HD
TER    2895      GLN UNK 306
"""
r_x0161 = """
ATOM      1  N   SER A   1      -2.549   4.317 -16.895  1.00 46.95    -0.064 N
ATOM      2  CA  SER A   1      -2.256   5.689 -16.439  1.00 45.24     0.297 C
ATOM      3  C   SER A   1      -2.668   5.866 -14.966  1.00 44.79     0.250 C
ATOM      4  O   SER A   1      -3.406   5.045 -14.421  1.00 42.57    -0.271 OA
ATOM      5  CB  SER A   1      -2.914   6.717 -17.385  1.00 53.07     0.206 C
ATOM      6  OG  SER A   1      -2.509   8.042 -17.100  1.00 65.14    -0.398 OA
ATOM      7  H1  SER A   1      -2.238   4.195 -17.848  1.00 46.95     0.275 HD
ATOM      8  H2  SER A   1      -2.071   3.662 -16.292  1.00 46.95     0.275 HD
ATOM      9  H3  SER A   1      -3.544   4.155 -16.832  1.00 46.95     0.275 HD
ATOM     10  HG  SER A   1      -2.934   8.630 -17.708  1.00 65.14     0.209 HD
ATOM     11  N   GLY A   2      -2.157   6.928 -14.326  1.00 44.16    -0.350 N
ATOM     12  CA  GLY A   2      -2.255   7.202 -12.896  1.00 43.64     0.225 C
ATOM     13  C   GLY A   2      -1.007   6.720 -12.148  1.00 42.33     0.236 C
ATOM     14  O   GLY A   2      -0.213   5.941 -12.681  1.00 49.51    -0.272 OA
ATOM     15  H   GLY A   2      -1.556   7.543 -14.861  1.00 44.16     0.163 HD
ATOM     16  N   PHE A   3      -0.835   7.195 -10.906  1.00 41.87    -0.346 N
ATOM     17  CA  PHE A   3       0.313   6.891 -10.056  1.00 38.66     0.180 C
ATOM     18  C   PHE A   3      -0.117   6.817  -8.586  1.00 36.86     0.241 C
ATOM     19  O   PHE A   3      -0.851   7.685  -8.111  1.00 41.81    -0.271 OA
ATOM     20  CB  PHE A   3       1.459   7.885 -10.341  1.00 39.30     0.073 C
ATOM     21  CG  PHE A   3       2.850   7.338 -10.098  1.00 35.71    -0.056 A
ATOM     22  CD1 PHE A   3       3.421   6.440 -11.025  1.00 34.66     0.007 A
ATOM     23  CD2 PHE A   3       3.584   7.731  -8.960  1.00 35.25     0.007 A
ATOM     24  CE1 PHE A   3       4.712   5.923 -10.805  1.00 36.35     0.001 A
ATOM     25  CE2 PHE A   3       4.878   7.224  -8.751  1.00 36.42     0.001 A
ATOM     26  CZ  PHE A   3       5.434   6.304  -9.658  1.00 35.83     0.000 A
ATOM     27  H   PHE A   3      -1.529   7.823 -10.524  1.00 41.87     0.163 HD
ATOM     28  N   ARG A   4       0.338   5.773  -7.879  1.00 36.56    -0.346 N
ATOM     29  CA  ARG A   4       0.006   5.448  -6.492  1.00 35.95     0.176 C
ATOM     30  C   ARG A   4       1.256   5.036  -5.711  1.00 37.16     0.241 C
ATOM     31  O   ARG A   4       2.218   4.536  -6.295  1.00 39.38    -0.271 OA
ATOM     32  CB  ARG A   4      -1.084   4.351  -6.444  1.00 37.67     0.036 C
ATOM     33  CG  ARG A   4      -2.514   4.836  -6.740  1.00 40.24     0.023 C
ATOM     34  CD  ARG A   4      -3.096   5.689  -5.602  1.00 42.39     0.138 C
ATOM     35  NE  ARG A   4      -4.533   5.936  -5.788  1.00 45.68    -0.227 N
ATOM     36  CZ  ARG A   4      -5.397   6.310  -4.828  1.00 46.89     0.665 C
ATOM     37  NH1 ARG A   4      -5.003   6.482  -3.557  1.00 46.70    -0.235 N
ATOM     38  NH2 ARG A   4      -6.680   6.520  -5.148  1.00 44.63    -0.235 N
ATOM     39  H   ARG A   4       0.947   5.116  -8.353  1.00 36.56     0.163 HD
ATOM     40  HE  ARG A   4      -4.871   5.859  -6.737  1.00 45.68     0.177 HD
ATOM     41 HH12 ARG A   4      -5.662   6.766  -2.847  1.00 46.70     0.174 HD
ATOM     42 HH11 ARG A   4      -4.038   6.331  -3.304  1.00 46.70     0.174 HD
ATOM     43 HH22 ARG A   4      -7.343   6.805  -4.442  1.00 44.63     0.174 HD
ATOM     44 HH21 ARG A   4      -6.996   6.398  -6.099  1.00 44.63     0.174 HD
ATOM     45  N   LYS A   5       1.204   5.206  -4.376  1.00 38.48    -0.346 N
ATOM     46  CA  LYS A   5       2.192   4.747  -3.394  1.00 39.57     0.176 C
ATOM     47  C   LYS A   5       1.991   3.232  -3.189  1.00 42.16     0.241 C
ATOM     48  O   LYS A   5       1.347   2.785  -2.239  1.00 46.68    -0.271 OA
ATOM     49  CB  LYS A   5       1.983   5.570  -2.097  1.00 41.42     0.035 C
ATOM     50  CG  LYS A   5       3.044   5.385  -0.987  1.00 41.35     0.004 C
ATOM     51  CD  LYS A   5       4.490   5.791  -1.353  1.00 44.99     0.027 C
ATOM     52  CE  LYS A   5       4.697   7.295  -1.620  1.00 45.32     0.229 C
ATOM     53  NZ  LYS A   5       4.607   8.108  -0.394  1.00 47.07    -0.079 N
ATOM     54  H   LYS A   5       0.368   5.626  -3.997  1.00 38.48     0.163 HD
ATOM     55  HZ1 LYS A   5       4.707   9.090  -0.632  1.00 47.07     0.274 HD
ATOM     56  HZ2 LYS A   5       3.707   7.969   0.041  1.00 47.07     0.274 HD
ATOM     57  HZ3 LYS A   5       5.338   7.842   0.251  1.00 47.07     0.274 HD
ATOM     58  N   MET A   6       2.491   2.466  -4.169  1.00 37.69    -0.346 N
ATOM     59  CA  MET A   6       2.194   1.062  -4.415  1.00 37.47     0.177 C
ATOM     60  C   MET A   6       3.202   0.178  -3.673  1.00 35.81     0.241 C
ATOM     61  O   MET A   6       4.414   0.332  -3.833  1.00 35.45    -0.271 OA
ATOM     62  CB  MET A   6       2.349   0.843  -5.938  1.00 41.01     0.045 C
ATOM     63  CG  MET A   6       1.884  -0.534  -6.438  1.00 48.82     0.076 C
ATOM     64  SD  MET A   6       1.958  -0.724  -8.241  1.00 56.58    -0.173 SA
ATOM     65  CE  MET A   6       0.480   0.205  -8.729  1.00 58.18     0.089 C
ATOM     66  H   MET A   6       3.005   2.939  -4.899  1.00 37.69     0.163 HD
ATOM     67  N   ALA A   7       2.671  -0.770  -2.889  1.00 31.71    -0.346 N
ATOM     68  CA  ALA A   7       3.422  -1.808  -2.197  1.00 30.88     0.172 C
ATOM     69  C   ALA A   7       3.534  -3.068  -3.075  1.00 33.73     0.240 C
ATOM     70  O   ALA A   7       2.720  -3.293  -3.973  1.00 33.68    -0.271 OA
ATOM     71  CB  ALA A   7       2.642  -2.187  -0.925  1.00 34.87     0.042 C
ATOM     72  H   ALA A   7       1.665  -0.822  -2.824  1.00 31.71     0.163 HD
ATOM     73  N   PHE A   8       4.535  -3.908  -2.773  1.00 31.46    -0.346 N
ATOM     74  CA  PHE A   8       4.765  -5.220  -3.376  1.00 34.24     0.181 C
ATOM     75  C   PHE A   8       3.781  -6.249  -2.777  1.00 32.89     0.243 C
ATOM     76  O   PHE A   8       3.538  -6.185  -1.569  1.00 30.19    -0.271 OA
ATOM     77  CB  PHE A   8       6.190  -5.691  -3.009  1.00 33.39     0.073 C
ATOM     78  CG  PHE A   8       7.310  -4.989  -3.750  1.00 36.14    -0.056 A
ATOM     79  CD1 PHE A   8       7.612  -5.355  -5.078  1.00 38.01     0.007 A
ATOM     80  CD2 PHE A   8       8.065  -3.981  -3.115  1.00 37.78     0.007 A
ATOM     81  CE1 PHE A   8       8.668  -4.724  -5.763  1.00 38.84     0.001 A
ATOM     82  CE2 PHE A   8       9.111  -3.341  -3.805  1.00 41.43     0.001 A
ATOM     83  CZ  PHE A   8       9.423  -3.722  -5.123  1.00 42.67     0.000 A
ATOM     84  H   PHE A   8       5.139  -3.651  -2.001  1.00 31.46     0.163 HD
ATOM     85  N   PRO A   9       3.239  -7.204  -3.578  1.00 33.90    -0.337 N
ATOM     86  CA  PRO A   9       2.418  -8.341  -3.115  1.00 34.60     0.179 C
ATOM     87  C   PRO A   9       3.060  -9.110  -1.945  1.00 32.48     0.241 C
ATOM     88  O   PRO A   9       4.100  -9.750  -2.104  1.00 34.77    -0.271 OA
ATOM     89  CB  PRO A   9       2.247  -9.249  -4.345  1.00 34.47     0.037 C
ATOM     90  CG  PRO A   9       2.424  -8.326  -5.536  1.00 36.78     0.022 C
ATOM     91  CD  PRO A   9       3.343  -7.212  -5.040  1.00 33.29     0.127 C
ATOM     92  N   SER A  10       2.450  -8.996  -0.758  1.00 32.54    -0.344 N
ATOM     93  CA  SER A  10       3.003  -9.453   0.514  1.00 31.95     0.200 C
ATOM     94  C   SER A  10       2.743 -10.938   0.825  1.00 30.94     0.242 C
ATOM     95  O   SER A  10       3.187 -11.398   1.872  1.00 28.97    -0.271 OA
ATOM     96  CB  SER A  10       2.405  -8.563   1.624  1.00 34.19     0.199 C
ATOM     97  OG  SER A  10       0.992  -8.617   1.693  1.00 34.07    -0.398 OA
ATOM     98  H   SER A  10       1.598  -8.456  -0.704  1.00 32.54     0.163 HD
ATOM     99  HG  SER A  10       0.711  -9.501   1.906  1.00 34.07     0.209 HD
ATOM    100  N   GLY A  11       2.077 -11.696  -0.065  1.00 31.49    -0.350 N
ATOM    101  CA  GLY A  11       1.676 -13.093   0.139  1.00 30.70     0.225 C
ATOM    102  C   GLY A  11       2.818 -14.099   0.365  1.00 31.56     0.236 C
ATOM    103  O   GLY A  11       2.602 -15.122   1.013  1.00 33.90    -0.272 OA
ATOM    104  H   GLY A  11       1.755 -11.247  -0.909  1.00 31.49     0.163 HD
ATOM    105  N   LYS A  12       4.034 -13.790  -0.118  1.00 31.19    -0.346 N
ATOM    106  CA  LYS A  12       5.255 -14.572   0.099  1.00 34.60     0.176 C
ATOM    107  C   LYS A  12       5.854 -14.336   1.500  1.00 34.00     0.241 C
ATOM    108  O   LYS A  12       6.568 -15.201   2.007  1.00 32.49    -0.271 OA
ATOM    109  CB  LYS A  12       6.309 -14.130  -0.939  1.00 35.28     0.035 C
ATOM    110  CG  LYS A  12       5.980 -14.552  -2.380  1.00 39.33     0.004 C
ATOM    111  CD  LYS A  12       7.005 -14.010  -3.388  1.00 43.94     0.027 C
ATOM    112  CE  LYS A  12       6.674 -14.360  -4.845  1.00 49.29     0.229 C
ATOM    113  NZ  LYS A  12       7.075 -15.739  -5.175  1.00 53.09    -0.079 N
ATOM    114  H   LYS A  12       4.127 -12.928  -0.636  1.00 31.19     0.163 HD
ATOM    115  HZ1 LYS A  12       8.067 -15.847  -5.016  1.00 53.09     0.274 HD
ATOM    116  HZ2 LYS A  12       6.568 -16.388  -4.591  1.00 53.09     0.274 HD
ATOM    117  HZ3 LYS A  12       6.869 -15.928  -6.146  1.00 53.09     0.274 HD
ATOM    118  N   VAL A  13       5.559 -13.180   2.118  1.00 32.14    -0.346 N
ATOM    119  CA  VAL A  13       6.024 -12.777   3.445  1.00 29.62     0.180 C
ATOM    120  C   VAL A  13       4.986 -13.167   4.509  1.00 29.11     0.241 C
ATOM    121  O   VAL A  13       5.394 -13.550   5.601  1.00 29.49    -0.271 OA
ATOM    122  CB  VAL A  13       6.251 -11.240   3.461  1.00 26.97     0.009 C
ATOM    123  CG1 VAL A  13       6.741 -10.713   4.826  1.00 27.59     0.012 C
ATOM    124  CG2 VAL A  13       7.248 -10.836   2.364  1.00 28.52     0.012 C
ATOM    125  H   VAL A  13       4.944 -12.535   1.641  1.00 32.14     0.163 HD
ATOM    126  N   GLU A  14       3.675 -13.126   4.195  1.00 28.58    -0.346 N
ATOM    127  CA  GLU A  14       2.556 -13.501   5.073  1.00 28.06     0.177 C
ATOM    128  C   GLU A  14       2.640 -14.964   5.546  1.00 27.19     0.240 C
ATOM    129  O   GLU A  14       2.318 -15.252   6.698  1.00 30.62    -0.271 OA
ATOM    130  CB  GLU A  14       1.222 -13.297   4.324  1.00 27.42     0.045 C
ATOM    131  CG  GLU A  14       0.793 -11.827   4.160  1.00 27.84     0.116 C
ATOM    132  CD  GLU A  14      -0.446 -11.700   3.276  1.00 26.56     0.172 C
ATOM    133  OE1 GLU A  14      -1.484 -12.283   3.658  1.00 30.11    -0.648 OA
ATOM    134  OE2 GLU A  14      -0.332 -11.028   2.229  1.00 29.69    -0.648 OA
ATOM    135  H   GLU A  14       3.428 -12.781   3.277  1.00 28.58     0.163 HD
ATOM    136  N   GLY A  15       3.120 -15.865   4.671  1.00 28.79    -0.351 N
ATOM    137  CA  GLY A  15       3.362 -17.276   4.960  1.00 28.52     0.225 C
ATOM    138  C   GLY A  15       4.623 -17.548   5.793  1.00 29.37     0.236 C
ATOM    139  O   GLY A  15       4.790 -18.664   6.283  1.00 31.52    -0.272 OA
ATOM    140  H   GLY A  15       3.359 -15.539   3.745  1.00 28.79     0.163 HD
ATOM    141  N   CYS A  16       5.494 -16.540   5.965  1.00 31.05    -0.346 N
ATOM    142  CA  CYS A  16       6.694 -16.592   6.797  1.00 28.89     0.185 C
ATOM    143  C   CYS A  16       6.468 -15.932   8.169  1.00 29.85     0.241 C
ATOM    144  O   CYS A  16       7.291 -16.139   9.055  1.00 29.39    -0.271 OA
ATOM    145  CB  CYS A  16       7.835 -15.831   6.088  1.00 31.10     0.105 C
ATOM    146  SG  CYS A  16       8.315 -16.681   4.563  1.00 31.28    -0.180 SA
ATOM    147  H   CYS A  16       5.279 -15.650   5.536  1.00 31.05     0.163 HD
ATOM    148  HG  CYS A  16       7.141 -16.538   3.940  1.00 31.28     0.101 HD
ATOM    149  N   MET A  17       5.385 -15.160   8.385  1.00 26.83    -0.346 N
ATOM    150  CA  MET A  17       5.142 -14.480   9.660  1.00 25.49     0.177 C
ATOM    151  C   MET A  17       4.626 -15.472  10.713  1.00 28.13     0.241 C
ATOM    152  O   MET A  17       3.682 -16.225  10.468  1.00 28.96    -0.271 OA
ATOM    153  CB  MET A  17       4.101 -13.353   9.504  1.00 26.28     0.045 C
ATOM    154  CG  MET A  17       4.526 -12.213   8.567  1.00 27.45     0.076 C
ATOM    155  SD  MET A  17       6.180 -11.487   8.800  1.00 30.07    -0.173 SA
ATOM    156  CE  MET A  17       6.127 -10.960  10.534  1.00 33.60     0.089 C
ATOM    157  H   MET A  17       4.715 -15.029   7.640  1.00 26.83     0.163 HD
ATOM    158  N   VAL A  18       5.270 -15.443  11.887  1.00 25.68    -0.346 N
ATOM    159  CA  VAL A  18       4.994 -16.260  13.064  1.00 27.56     0.180 C
ATOM    160  C   VAL A  18       4.978 -15.362  14.308  1.00 29.77     0.241 C
ATOM    161  O   VAL A  18       5.508 -14.252  14.292  1.00 28.51    -0.271 OA
ATOM    162  CB  VAL A  18       5.979 -17.461  13.163  1.00 25.32     0.009 C
ATOM    163  CG1 VAL A  18       5.934 -18.366  11.922  1.00 26.04     0.012 C
ATOM    164  CG2 VAL A  18       7.437 -17.061  13.458  1.00 26.19     0.012 C
ATOM    165  H   VAL A  18       6.034 -14.784  11.980  1.00 25.68     0.163 HD
ATOM    166  N   GLN A  19       4.368 -15.851  15.393  1.00 30.41    -0.346 N
ATOM    167  CA  GLN A  19       4.371 -15.226  16.711  1.00 34.90     0.177 C
ATOM    168  C   GLN A  19       5.578 -15.771  17.488  1.00 34.05     0.241 C
ATOM    169  O   GLN A  19       5.895 -16.954  17.371  1.00 34.82    -0.271 OA
ATOM    170  CB  GLN A  19       3.082 -15.670  17.433  1.00 37.78     0.044 C
ATOM    171  CG  GLN A  19       2.765 -14.864  18.713  1.00 41.86     0.105 C
ATOM    172  CD  GLN A  19       1.413 -15.199  19.358  1.00 44.23     0.215 C
ATOM    173  OE1 GLN A  19       0.959 -14.469  20.235  1.00 49.09    -0.274 OA
ATOM    174  NE2 GLN A  19       0.742 -16.272  18.930  1.00 45.28    -0.370 N
ATOM    175  H   GLN A  19       3.953 -16.773  15.332  1.00 30.41     0.163 HD
ATOM    176 2HE2 GLN A  19      -0.151 -16.499  19.342  1.00 45.28     0.159 HD
ATOM    177 1HE2 GLN A  19       1.124 -16.847  18.194  1.00 45.28     0.159 HD
ATOM    178  N   VAL A  20       6.230 -14.916  18.289  1.00 34.34    -0.346 N
ATOM    179  CA  VAL A  20       7.306 -15.279  19.210  1.00 32.23     0.180 C
ATOM    180  C   VAL A  20       7.012 -14.617  20.559  1.00 30.97     0.241 C
ATOM    181  O   VAL A  20       6.956 -13.391  20.649  1.00 28.82    -0.271 OA
ATOM    182  CB  VAL A  20       8.709 -14.927  18.647  1.00 32.98     0.009 C
ATOM    183  CG1 VAL A  20       9.828 -15.394  19.600  1.00 34.45     0.012 C
ATOM    184  CG2 VAL A  20       8.962 -15.497  17.239  1.00 34.52     0.012 C
ATOM    185  H   VAL A  20       5.924 -13.951  18.314  1.00 34.34     0.163 HD
ATOM    186  N   THR A  21       6.855 -15.442  21.603  1.00 34.59    -0.344 N
ATOM    187  CA  THR A  21       6.650 -15.025  22.986  1.00 33.28     0.205 C
ATOM    188  C   THR A  21       7.814 -15.569  23.821  1.00 34.08     0.243 C
ATOM    189  O   THR A  21       8.192 -16.732  23.682  1.00 35.81    -0.271 OA
ATOM    190  CB  THR A  21       5.280 -15.551  23.482  1.00 34.46     0.146 C
ATOM    191  OG1 THR A  21       4.256 -14.962  22.705  1.00 33.74    -0.393 OA
ATOM    192  CG2 THR A  21       4.972 -15.209  24.952  1.00 35.89     0.042 C
ATOM    193  H   THR A  21       6.919 -16.439  21.438  1.00 34.59     0.163 HD
ATOM    194  HG1 THR A  21       4.374 -15.235  21.807  1.00 33.74     0.210 HD
ATOM    195  N   CYS A  22       8.356 -14.727  24.712  1.00 34.52    -0.345 N
ATOM    196  CA  CYS A  22       9.361 -15.089  25.704  1.00 38.93     0.185 C
ATOM    197  C   CYS A  22       9.065 -14.295  26.978  1.00 42.06     0.241 C
ATOM    198  O   CYS A  22       9.075 -13.065  26.961  1.00 41.67    -0.271 OA
ATOM    199  CB  CYS A  22      10.782 -14.934  25.124  1.00 35.89     0.105 C
ATOM    200  SG  CYS A  22      12.003 -15.743  26.189  1.00 41.36    -0.180 SA
ATOM    201  H   CYS A  22       7.991 -13.784  24.762  1.00 34.52     0.163 HD
ATOM    202  HG  CYS A  22      11.471 -16.967  26.093  1.00 41.36     0.101 HD
ATOM    203  N   GLY A  23       8.739 -15.005  28.069  1.00 47.59    -0.351 N
ATOM    204  CA  GLY A  23       8.150 -14.424  29.272  1.00 50.33     0.225 C
ATOM    205  C   GLY A  23       6.695 -14.018  29.006  1.00 50.46     0.236 C
ATOM    206  O   GLY A  23       5.921 -14.811  28.472  1.00 55.10    -0.272 OA
ATOM    207  H   GLY A  23       8.739 -16.013  28.000  1.00 47.59     0.163 HD
ATOM    208  N   THR A  24       6.343 -12.777  29.370  1.00 50.55    -0.344 N
ATOM    209  CA  THR A  24       5.042 -12.154  29.105  1.00 51.98     0.205 C
ATOM    210  C   THR A  24       5.061 -11.277  27.831  1.00 49.67     0.243 C
ATOM    211  O   THR A  24       4.000 -10.831  27.397  1.00 55.80    -0.271 OA
ATOM    212  CB  THR A  24       4.665 -11.277  30.329  1.00 56.39     0.146 C
ATOM    213  OG1 THR A  24       5.596 -10.228  30.539  1.00 55.53    -0.393 OA
ATOM    214  CG2 THR A  24       4.513 -12.081  31.630  1.00 57.51     0.042 C
ATOM    215  H   THR A  24       7.030 -12.196  29.829  1.00 50.55     0.163 HD
ATOM    216  HG1 THR A  24       5.580  -9.654  29.787  1.00 55.53     0.210 HD
ATOM    217  N   THR A  25       6.243 -11.018  27.243  1.00 47.58    -0.344 N
ATOM    218  CA  THR A  25       6.435 -10.130  26.095  1.00 43.66     0.205 C
ATOM    219  C   THR A  25       6.241 -10.948  24.807  1.00 37.96     0.243 C
ATOM    220  O   THR A  25       6.993 -11.887  24.542  1.00 41.55    -0.271 OA
ATOM    221  CB  THR A  25       7.881  -9.572  26.155  1.00 45.26     0.146 C
ATOM    222  OG1 THR A  25       8.004  -8.764  27.310  1.00 44.07    -0.393 OA
ATOM    223  CG2 THR A  25       8.274  -8.684  24.959  1.00 44.48     0.042 C
ATOM    224  H   THR A  25       7.074 -11.436  27.637  1.00 47.58     0.163 HD
ATOM    225  HG1 THR A  25       8.911  -8.507  27.404  1.00 44.07     0.210 HD
ATOM    226  N   THR A  26       5.229 -10.561  24.016  1.00 38.22    -0.344 N
ATOM    227  CA  THR A  26       4.865 -11.153  22.730  1.00 38.38     0.205 C
ATOM    228  C   THR A  26       5.189 -10.140  21.620  1.00 35.81     0.243 C
ATOM    229  O   THR A  26       4.845  -8.961  21.724  1.00 36.28    -0.271 OA
ATOM    230  CB  THR A  26       3.345 -11.459  22.739  1.00 38.15     0.146 C
ATOM    231  OG1 THR A  26       3.079 -12.450  23.713  1.00 43.58    -0.393 OA
ATOM    232  CG2 THR A  26       2.802 -12.000  21.405  1.00 40.31     0.042 C
ATOM    233  H   THR A  26       4.661  -9.785  24.325  1.00 38.22     0.163 HD
ATOM    234  HG1 THR A  26       3.496 -13.259  23.446  1.00 43.58     0.210 HD
ATOM    235  N   LEU A  27       5.811 -10.630  20.539  1.00 31.26    -0.346 N
ATOM    236  CA  LEU A  27       6.078  -9.909  19.297  1.00 29.32     0.177 C
ATOM    237  C   LEU A  27       6.052 -10.862  18.087  1.00 28.14     0.241 C
ATOM    238  O   LEU A  27       5.699 -12.034  18.225  1.00 27.86    -0.271 OA
ATOM    239  CB  LEU A  27       7.291  -8.954  19.449  1.00 26.95     0.038 C
ATOM    240  CG  LEU A  27       8.629  -9.545  19.952  1.00 29.04    -0.020 C
ATOM    241  CD1 LEU A  27       9.280 -10.501  18.943  1.00 30.76     0.009 C
ATOM    242  CD2 LEU A  27       9.602  -8.404  20.290  1.00 28.60     0.009 C
ATOM    243  H   LEU A  27       6.062 -11.611  20.541  1.00 31.26     0.163 HD
ATOM    244  N   ASN A  28       6.384 -10.353  16.891  1.00 28.10    -0.346 N
ATOM    245  CA  ASN A  28       6.394 -11.106  15.632  1.00 27.14     0.185 C
ATOM    246  C   ASN A  28       7.810 -11.640  15.344  1.00 26.50     0.241 C
ATOM    247  O   ASN A  28       8.809 -11.055  15.760  1.00 26.87    -0.271 OA
ATOM    248  CB  ASN A  28       6.031 -10.165  14.458  1.00 27.02     0.137 C
ATOM    249  CG  ASN A  28       4.685  -9.456  14.621  1.00 29.15     0.217 C
ATOM    250  OD1 ASN A  28       3.630 -10.069  14.484  1.00 31.30    -0.274 OA
ATOM    251  ND2 ASN A  28       4.718  -8.158  14.919  1.00 28.89    -0.370 N
ATOM    252  H   ASN A  28       6.672  -9.385  16.843  1.00 28.10     0.163 HD
ATOM    253 2HD2 ASN A  28       3.851  -7.647  15.031  1.00 28.89     0.159 HD
ATOM    254 1HD2 ASN A  28       5.605  -7.699  15.075  1.00 28.89     0.159 HD
ATOM    255  N   GLY A  29       7.881 -12.734  14.578  1.00 27.15    -0.351 N
ATOM    256  CA  GLY A  29       9.092 -13.283  13.982  1.00 26.92     0.225 C
ATOM    257  C   GLY A  29       8.863 -13.610  12.505  1.00 26.37     0.236 C
ATOM    258  O   GLY A  29       7.724 -13.773  12.069  1.00 25.66    -0.272 OA
ATOM    259  H   GLY A  29       7.011 -13.172  14.298  1.00 27.15     0.163 HD
ATOM    260  N   LEU A  30       9.962 -13.730  11.746  1.00 27.63    -0.346 N
ATOM    261  CA  LEU A  30       9.983 -14.120  10.340  1.00 29.40     0.177 C
ATOM    262  C   LEU A  30      10.679 -15.484  10.240  1.00 28.41     0.241 C
ATOM    263  O   LEU A  30      11.877 -15.591  10.490  1.00 29.46    -0.271 OA
ATOM    264  CB  LEU A  30      10.745 -13.038   9.540  1.00 27.84     0.038 C
ATOM    265  CG  LEU A  30      10.697 -13.232   8.008  1.00 29.71    -0.020 C
ATOM    266  CD1 LEU A  30       9.306 -12.919   7.434  1.00 31.12     0.009 C
ATOM    267  CD2 LEU A  30      11.773 -12.398   7.305  1.00 29.37     0.009 C
ATOM    268  H   LEU A  30      10.860 -13.575  12.188  1.00 27.63     0.163 HD
ATOM    269  N   TRP A  31       9.913 -16.518   9.867  1.00 27.33    -0.346 N
ATOM    270  CA  TRP A  31      10.329 -17.905   9.698  1.00 27.71     0.181 C
ATOM    271  C   TRP A  31      10.758 -18.112   8.235  1.00 29.68     0.241 C
ATOM    272  O   TRP A  31       9.928 -18.091   7.327  1.00 29.20    -0.271 OA
ATOM    273  CB  TRP A  31       9.093 -18.779  10.023  1.00 28.09     0.075 C
ATOM    274  CG  TRP A  31       9.261 -20.265  10.179  1.00 27.89    -0.028 A
ATOM    275  CD1 TRP A  31      10.421 -20.940  10.364  1.00 27.72     0.096 A
ATOM    276  CD2 TRP A  31       8.212 -21.284  10.146  1.00 28.03    -0.002 A
ATOM    277  NE1 TRP A  31      10.161 -22.291  10.463  1.00 27.24    -0.365 N
ATOM    278  CE2 TRP A  31       8.819 -22.566  10.322  1.00 27.44     0.042 A
ATOM    279  CE3 TRP A  31       6.812 -21.263   9.939  1.00 30.94     0.014 A
ATOM    280  CZ2 TRP A  31       8.076 -23.758  10.303  1.00 27.11     0.030 A
ATOM    281  CZ3 TRP A  31       6.059 -22.454   9.905  1.00 32.34     0.001 A
ATOM    282  CH2 TRP A  31       6.688 -23.701  10.087  1.00 30.37     0.002 A
ATOM    283  H   TRP A  31       8.939 -16.324   9.664  1.00 27.33     0.163 HD
ATOM    284  HE1 TRP A  31      10.891 -22.981  10.581  1.00 27.24     0.165 HD
ATOM    285  N   LEU A  32      12.067 -18.304   8.025  1.00 28.61    -0.346 N
ATOM    286  CA  LEU A  32      12.705 -18.578   6.739  1.00 30.05     0.177 C
ATOM    287  C   LEU A  32      13.600 -19.799   6.917  1.00 29.98     0.241 C
ATOM    288  O   LEU A  32      14.560 -19.752   7.688  1.00 29.77    -0.271 OA
ATOM    289  CB  LEU A  32      13.519 -17.359   6.269  1.00 30.14     0.038 C
ATOM    290  CG  LEU A  32      12.685 -16.149   5.814  1.00 28.45    -0.020 C
ATOM    291  CD1 LEU A  32      13.592 -14.921   5.717  1.00 28.62     0.009 C
ATOM    292  CD2 LEU A  32      11.968 -16.399   4.477  1.00 27.83     0.009 C
ATOM    293  H   LEU A  32      12.676 -18.317   8.834  1.00 28.61     0.163 HD
ATOM    294  N   ASP A  33      13.240 -20.902   6.240  1.00 30.31    -0.346 N
ATOM    295  CA  ASP A  33      13.823 -22.237   6.400  1.00 31.59     0.186 C
ATOM    296  C   ASP A  33      13.485 -22.761   7.807  1.00 31.39     0.241 C
ATOM    297  O   ASP A  33      12.340 -22.638   8.243  1.00 31.11    -0.271 OA
ATOM    298  CB  ASP A  33      15.332 -22.304   6.021  1.00 30.91     0.147 C
ATOM    299  CG  ASP A  33      15.651 -21.759   4.627  1.00 32.56     0.175 C
ATOM    300  OD1 ASP A  33      15.004 -22.228   3.665  1.00 33.63    -0.648 OA
ATOM    301  OD2 ASP A  33      16.545 -20.889   4.545  1.00 33.62    -0.648 OA
ATOM    302  H   ASP A  33      12.447 -20.833   5.615  1.00 30.31     0.163 HD
ATOM    303  N   ASP A  34      14.471 -23.324   8.517  1.00 29.52    -0.345 N
ATOM    304  CA  ASP A  34      14.361 -23.867   9.869  1.00 30.55     0.186 C
ATOM    305  C   ASP A  34      14.796 -22.833  10.937  1.00 29.42     0.241 C
ATOM    306  O   ASP A  34      15.121 -23.237  12.051  1.00 29.07    -0.271 OA
ATOM    307  CB  ASP A  34      15.234 -25.154   9.937  1.00 30.52     0.147 C
ATOM    308  CG  ASP A  34      16.760 -24.981   9.842  1.00 33.26     0.175 C
ATOM    309  OD1 ASP A  34      17.209 -24.149   9.024  1.00 36.28    -0.648 OA
ATOM    310  OD2 ASP A  34      17.455 -25.705  10.588  1.00 36.77    -0.648 OA
ATOM    311  H   ASP A  34      15.392 -23.372   8.099  1.00 29.52     0.163 HD
ATOM    312  N   VAL A  35      14.793 -21.520  10.629  1.00 29.28    -0.346 N
ATOM    313  CA  VAL A  35      15.202 -20.432  11.528  1.00 30.04     0.180 C
ATOM    314  C   VAL A  35      14.134 -19.327  11.551  1.00 30.52     0.241 C
ATOM    315  O   VAL A  35      13.683 -18.875  10.500  1.00 29.88    -0.271 OA
ATOM    316  CB  VAL A  35      16.621 -19.905  11.169  1.00 32.05     0.009 C
ATOM    317  CG1 VAL A  35      17.095 -18.783  12.116  1.00 33.14     0.012 C
ATOM    318  CG2 VAL A  35      17.683 -21.020  11.142  1.00 31.78     0.012 C
ATOM    319  H   VAL A  35      14.507 -21.253   9.697  1.00 29.28     0.163 HD
ATOM    320  N   VAL A  36      13.777 -18.872  12.763  1.00 29.56    -0.346 N
ATOM    321  CA  VAL A  36      12.853 -17.775  13.040  1.00 28.16     0.180 C
ATOM    322  C   VAL A  36      13.665 -16.596  13.596  1.00 27.12     0.241 C
ATOM    323  O   VAL A  36      14.245 -16.680  14.678  1.00 26.28    -0.271 OA
ATOM    324  CB  VAL A  36      11.754 -18.256  14.024  1.00 29.47     0.009 C
ATOM    325  CG1 VAL A  36      10.824 -17.120  14.493  1.00 29.77     0.012 C
ATOM    326  CG2 VAL A  36      10.918 -19.381  13.392  1.00 30.94     0.012 C
ATOM    327  H   VAL A  36      14.196 -19.315  13.572  1.00 29.56     0.163 HD
ATOM    328  N   TYR A  37      13.684 -15.497  12.832  1.00 26.04    -0.346 N
ATOM    329  CA  TYR A  37      14.396 -14.254  13.108  1.00 28.94     0.180 C
ATOM    330  C   TYR A  37      13.413 -13.280  13.775  1.00 28.68     0.241 C
ATOM    331  O   TYR A  37      12.332 -13.042  13.240  1.00 30.09    -0.271 OA
ATOM    332  CB  TYR A  37      14.830 -13.658  11.747  1.00 30.89     0.073 C
ATOM    333  CG  TYR A  37      15.812 -14.527  10.977  1.00 30.48    -0.056 A
ATOM    334  CD1 TYR A  37      15.343 -15.564  10.139  1.00 30.57     0.010 A
ATOM    335  CD2 TYR A  37      17.199 -14.320  11.113  1.00 31.19     0.010 A
ATOM    336  CE1 TYR A  37      16.249 -16.412   9.477  1.00 32.01     0.037 A
ATOM    337  CE2 TYR A  37      18.106 -15.162  10.441  1.00 30.44     0.037 A
ATOM    338  CZ  TYR A  37      17.634 -16.214   9.632  1.00 29.99     0.065 A
ATOM    339  OH  TYR A  37      18.516 -17.035   8.994  1.00 32.57    -0.361 OA
ATOM    340  H   TYR A  37      13.158 -15.526  11.968  1.00 26.04     0.163 HD
ATOM    341  HH  TYR A  37      18.094 -17.685   8.453  1.00 32.57     0.217 HD
ATOM    342  N   CYS A  38      13.782 -12.720  14.937  1.00 29.30    -0.345 N
ATOM    343  CA  CYS A  38      12.958 -11.799  15.729  1.00 27.95     0.185 C
ATOM    344  C   CYS A  38      13.829 -10.807  16.527  1.00 25.35     0.244 C
ATOM    345  O   CYS A  38      14.943 -11.182  16.890  1.00 28.82    -0.271 OA
ATOM    346  CB  CYS A  38      11.955 -12.588  16.604  1.00 28.79     0.105 C
ATOM    347  SG  CYS A  38      12.797 -13.600  17.861  1.00 30.55    -0.180 SA
ATOM    348  H   CYS A  38      14.679 -12.976  15.331  1.00 29.30     0.163 HD
ATOM    349  HG  CYS A  38      13.436 -12.586  18.452  1.00 30.55     0.101 HD
ATOM    350  N   PRO A  39      13.345  -9.581  16.855  1.00 27.10    -0.337 N
ATOM    351  CA  PRO A  39      14.018  -8.630  17.763  1.00 26.17     0.179 C
ATOM    352  C   PRO A  39      14.370  -9.252  19.125  1.00 27.37     0.241 C
ATOM    353  O   PRO A  39      13.535  -9.937  19.720  1.00 27.59    -0.271 OA
ATOM    354  CB  PRO A  39      13.016  -7.483  17.971  1.00 28.31     0.037 C
ATOM    355  CG  PRO A  39      12.075  -7.549  16.787  1.00 25.44     0.022 C
ATOM    356  CD  PRO A  39      12.113  -9.002  16.321  1.00 24.06     0.127 C
ATOM    357  N   ARG A  40      15.599  -9.013  19.614  1.00 27.10    -0.346 N
ATOM    358  CA  ARG A  40      16.111  -9.615  20.848  1.00 26.54     0.176 C
ATOM    359  C   ARG A  40      15.471  -9.064  22.136  1.00 29.05     0.241 C
ATOM    360  O   ARG A  40      15.620  -9.695  23.179  1.00 27.30    -0.271 OA
ATOM    361  CB  ARG A  40      17.649  -9.474  20.911  1.00 28.12     0.036 C
ATOM    362  CG  ARG A  40      18.186  -8.044  21.082  1.00 25.78     0.023 C
ATOM    363  CD  ARG A  40      19.691  -8.020  21.364  1.00 26.23     0.138 C
ATOM    364  NE  ARG A  40      20.185  -6.641  21.430  1.00 25.53    -0.227 N
ATOM    365  CZ  ARG A  40      21.436  -6.257  21.729  1.00 28.58     0.665 C
ATOM    366  NH1 ARG A  40      22.402  -7.154  21.976  1.00 25.87    -0.235 N
ATOM    367  NH2 ARG A  40      21.716  -4.949  21.781  1.00 29.35    -0.235 N
ATOM    368  H   ARG A  40      16.236  -8.442  19.074  1.00 27.10     0.163 HD
ATOM    369  HE  ARG A  40      19.489  -5.921  21.240  1.00 25.53     0.177 HD
ATOM    370 HH12 ARG A  40      23.344  -6.857  22.184  1.00 25.87     0.174 HD
ATOM    371 HH11 ARG A  40      22.197  -8.140  21.903  1.00 25.87     0.174 HD
ATOM    372 HH22 ARG A  40      22.647  -4.623  21.989  1.00 29.35     0.174 HD
ATOM    373 HH21 ARG A  40      20.972  -4.271  21.623  1.00 29.35     0.174 HD
ATOM    374  N   HIS A  41      14.728  -7.941  22.075  1.00 28.84    -0.346 N
ATOM    375  CA  HIS A  41      13.977  -7.365  23.199  1.00 31.13     0.182 C
ATOM    376  C   HIS A  41      12.688  -8.137  23.553  1.00 32.24     0.241 C
ATOM    377  O   HIS A  41      11.912  -7.669  24.386  1.00 29.90    -0.271 OA
ATOM    378  CB  HIS A  41      13.689  -5.869  22.932  1.00 34.50     0.093 C
ATOM    379  CG  HIS A  41      12.719  -5.535  21.825  1.00 34.53     0.028 A
ATOM    380  ND1 HIS A  41      11.347  -5.633  22.002  1.00 38.93    -0.354 N
ATOM    381  CD2 HIS A  41      12.932  -5.063  20.543  1.00 39.19     0.114 A
ATOM    382  CE1 HIS A  41      10.780  -5.231  20.870  1.00 38.96     0.180 A
ATOM    383  NE2 HIS A  41      11.688  -4.894  19.959  1.00 39.05    -0.360 N
ATOM    384  H   HIS A  41      14.650  -7.482  21.180  1.00 28.84     0.163 HD
ATOM    385  HE2 HIS A  41      11.501  -4.511  19.042  1.00 39.05     0.166 HD
ATOM    386  HD1 HIS A  41      10.872  -5.939  22.841  1.00 38.93     0.166 HD
ATOM    387  N   VAL A  42      12.476  -9.329  22.966  1.00 30.16    -0.346 N
ATOM    388  CA  VAL A  42      11.452 -10.295  23.358  1.00 31.61     0.180 C
ATOM    389  C   VAL A  42      11.770 -10.931  24.729  1.00 32.89     0.241 C
ATOM    390  O   VAL A  42      10.843 -11.313  25.436  1.00 36.50    -0.271 OA
ATOM    391  CB  VAL A  42      11.315 -11.370  22.243  1.00 30.94     0.009 C
ATOM    392  CG1 VAL A  42      12.537 -12.296  22.083  1.00 31.34     0.012 C
ATOM    393  CG2 VAL A  42      10.018 -12.189  22.370  1.00 34.01     0.012 C
ATOM    394  H   VAL A  42      13.141  -9.633  22.269  1.00 30.16     0.163 HD
ATOM    395  N   ILE A  43      13.058 -11.015  25.121  1.00 33.49    -0.346 N
ATOM    396  CA  ILE A  43      13.511 -11.577  26.401  1.00 34.32     0.180 C
ATOM    397  C   ILE A  43      13.415 -10.555  27.551  1.00 35.08     0.241 C
ATOM    398  O   ILE A  43      13.473 -10.957  28.713  1.00 36.35    -0.271 OA
ATOM    399  CB  ILE A  43      14.977 -12.097  26.267  1.00 33.53     0.013 C
ATOM    400  CG1 ILE A  43      16.080 -11.002  26.264  1.00 33.74     0.002 C
ATOM    401  CG2 ILE A  43      15.092 -13.080  25.087  1.00 32.40     0.012 C
ATOM    402  CD1 ILE A  43      17.498 -11.530  26.003  1.00 36.20     0.005 C
ATOM    403  H   ILE A  43      13.771 -10.673  24.492  1.00 33.49     0.163 HD
ATOM    404  N   CYS A  44      13.272  -9.256  27.231  0.64 37.26    -0.345 N
ATOM    405  CA  CYS A  44      13.177  -8.161  28.191  0.64 39.67     0.185 C
ATOM    406  C   CYS A  44      11.737  -8.038  28.697  0.64 43.26     0.242 C
ATOM    407  O   CYS A  44      10.794  -8.012  27.904  0.64 43.89    -0.271 OA
ATOM    408  CB  CYS A  44      13.511  -6.826  27.491  0.64 40.95     0.105 C
ATOM    409  SG  CYS A  44      15.282  -6.723  27.139  0.64 42.00    -0.180 SA
ATOM    410  H   CYS A  44      13.207  -9.014  26.253  1.00 37.26     0.163 HD
ATOM    411  HG  CYS A  44      15.250  -5.502  26.597  1.00 42.00     0.101 HD
ATOM    412  N   THR A  45      11.594  -7.891  30.021  0.64 47.35    -0.344 N
ATOM    413  CA  THR A  45      10.373  -7.435  30.683  0.64 50.74     0.205 C
ATOM    414  C   THR A  45      10.358  -5.889  30.696  0.64 54.28     0.243 C
ATOM    415  O   THR A  45      11.352  -5.240  30.356  0.64 52.12    -0.271 OA
ATOM    416  CB  THR A  45      10.348  -7.992  32.130  0.64 50.14     0.146 C
ATOM    417  OG1 THR A  45      11.419  -7.496  32.905  0.64 51.28    -0.393 OA
ATOM    418  CG2 THR A  45      10.336  -9.527  32.199  0.64 49.60     0.042 C
ATOM    419  H   THR A  45      12.425  -7.937  30.601  1.00 47.35     0.163 HD
ATOM    420  HG1 THR A  45      11.146  -7.474  33.816  1.00 51.28     0.210 HD
ATOM    421  N   SER A  46       9.218  -5.300  31.094  0.64 60.19    -0.344 N
ATOM    422  CA  SER A  46       8.959  -3.855  31.130  0.64 65.61     0.200 C
ATOM    423  C   SER A  46       9.596  -3.164  32.366  0.64 68.57     0.243 C
ATOM    424  O   SER A  46       8.981  -2.312  33.009  0.64 71.67    -0.271 OA
ATOM    425  CB  SER A  46       7.425  -3.660  31.078  0.64 66.87     0.199 C
ATOM    426  OG  SER A  46       7.064  -2.304  30.902  0.64 68.89    -0.398 OA
ATOM    427  H   SER A  46       8.456  -5.898  31.378  1.00 60.19     0.163 HD
ATOM    428  HG  SER A  46       7.395  -1.815  31.642  1.00 68.89     0.209 HD
ATOM    429  N   GLU A  47      10.846  -3.532  32.680  0.64 72.65    -0.346 N
ATOM    430  CA  GLU A  47      11.712  -2.966  33.712  0.64 74.91     0.177 C
ATOM    431  C   GLU A  47      13.202  -3.102  33.344  0.64 72.02     0.241 C
ATOM    432  O   GLU A  47      14.010  -2.292  33.798  0.64 75.08    -0.271 OA
ATOM    433  CB  GLU A  47      11.322  -3.509  35.104  0.64 77.65     0.045 C
ATOM    434  CG  GLU A  47      11.744  -4.970  35.385  0.64 79.97     0.116 C
ATOM    435  CD  GLU A  47      10.616  -5.792  36.010  0.64 80.79     0.172 C
ATOM    436  OE1 GLU A  47      10.216  -6.796  35.380  0.64 80.28    -0.648 OA
ATOM    437  OE2 GLU A  47      10.169  -5.399  37.110  0.64 83.36    -0.648 OA
ATOM    438  H   GLU A  47      11.252  -4.252  32.099  1.00 72.65     0.163 HD
ATOM    439  N   ASP A  48      13.557  -4.075  32.482  0.64 69.19    -0.346 N
ATOM    440  CA  ASP A  48      14.900  -4.258  31.915  0.64 66.76     0.186 C
ATOM    441  C   ASP A  48      15.206  -3.213  30.830  0.64 63.23     0.241 C
ATOM    442  O   ASP A  48      16.373  -2.904  30.603  0.64 62.24    -0.271 OA
ATOM    443  CB  ASP A  48      15.013  -5.646  31.229  0.64 66.55     0.147 C
ATOM    444  CG  ASP A  48      14.715  -6.857  32.116  0.64 67.24     0.175 C
ATOM    445  OD1 ASP A  48      14.989  -6.773  33.333  0.64 68.79    -0.648 OA
ATOM    446  OD2 ASP A  48      14.247  -7.865  31.544  0.64 65.40    -0.648 OA
ATOM    447  H   ASP A  48      12.853  -4.734  32.184  1.00 69.19     0.163 HD
ATOM    448  N   MET A  49      14.158  -2.690  30.169  0.64 60.16    -0.346 N
ATOM    449  CA  MET A  49      14.167  -1.820  28.993  0.64 58.53     0.177 C
ATOM    450  C   MET A  49      15.019  -0.541  29.077  0.64 53.68     0.241 C
ATOM    451  O   MET A  49      15.447  -0.059  28.031  0.64 49.11    -0.271 OA
ATOM    452  CB  MET A  49      12.707  -1.478  28.629  0.64 60.88     0.045 C
ATOM    453  CG  MET A  49      12.000  -2.608  27.865  0.64 63.12     0.076 C
ATOM    454  SD  MET A  49      10.214  -2.388  27.642  0.64 68.43    -0.173 SA
ATOM    455  CE  MET A  49      10.170  -0.871  26.650  0.64 66.21     0.089 C
ATOM    456  H   MET A  49      13.248  -3.008  30.469  1.00 60.16     0.163 HD
ATOM    457  N   LEU A  50      15.284  -0.001  30.279  0.64 52.49    -0.346 N
ATOM    458  CA  LEU A  50      16.040   1.240  30.488  0.64 52.27     0.177 C
ATOM    459  C   LEU A  50      17.539   1.100  30.156  0.64 51.54     0.241 C
ATOM    460  O   LEU A  50      18.111   2.022  29.575  0.64 49.24    -0.271 OA
ATOM    461  CB  LEU A  50      15.880   1.695  31.954  0.64 52.95     0.038 C
ATOM    462  CG  LEU A  50      14.440   2.089  32.355  0.64 53.80    -0.020 C
ATOM    463  CD1 LEU A  50      14.340   2.279  33.875  0.64 52.96     0.009 C
ATOM    464  CD2 LEU A  50      13.948   3.350  31.622  0.64 53.42     0.009 C
ATOM    465  H   LEU A  50      14.915  -0.462  31.099  1.00 52.49     0.163 HD
ATOM    466  N   ASN A  51      18.158  -0.048  30.482  0.64 48.98    -0.346 N
ATOM    467  CA  ASN A  51      19.490  -0.450  30.025  0.64 47.90     0.185 C
ATOM    468  C   ASN A  51      19.620  -1.981  30.157  0.64 45.79     0.243 C
ATOM    469  O   ASN A  51      20.209  -2.449  31.132  0.64 45.12    -0.271 OA
ATOM    470  CB  ASN A  51      20.621   0.355  30.729  0.64 48.36     0.137 C
ATOM    471  CG  ASN A  51      21.888   0.510  29.870  0.64 48.12     0.217 C
ATOM    472  OD1 ASN A  51      22.404   1.615  29.723  0.64 46.94    -0.274 OA
ATOM    473  ND2 ASN A  51      22.421  -0.585  29.323  0.64 48.09    -0.370 N
ATOM    474  H   ASN A  51      17.614  -0.755  30.959  1.00 48.98     0.163 HD
ATOM    475 2HD2 ASN A  51      23.259  -0.503  28.767  1.00 48.09     0.159 HD
ATOM    476 1HD2 ASN A  51      22.001  -1.490  29.480  1.00 48.09     0.159 HD
ATOM    477  N   PRO A  52      19.085  -2.777  29.203  1.00 42.45    -0.337 N
ATOM    478  CA  PRO A  52      19.144  -4.242  29.250  1.00 41.30     0.179 C
ATOM    479  C   PRO A  52      20.521  -4.745  28.784  1.00 35.17     0.241 C
ATOM    480  O   PRO A  52      20.960  -4.421  27.679  1.00 37.35    -0.271 OA
ATOM    481  CB  PRO A  52      18.043  -4.695  28.278  1.00 41.46     0.037 C
ATOM    482  CG  PRO A  52      17.910  -3.560  27.274  1.00 44.01     0.022 C
ATOM    483  CD  PRO A  52      18.321  -2.313  28.046  1.00 43.57     0.127 C
ATOM    484  N   ASN A  53      21.182  -5.565  29.618  1.00 32.21    -0.346 N
ATOM    485  CA  ASN A  53      22.376  -6.320  29.242  1.00 35.46     0.185 C
ATOM    486  C   ASN A  53      21.854  -7.639  28.654  1.00 31.81     0.241 C
ATOM    487  O   ASN A  53      21.449  -8.547  29.381  1.00 33.34    -0.271 OA
ATOM    488  CB  ASN A  53      23.239  -6.588  30.500  1.00 37.04     0.137 C
ATOM    489  CG  ASN A  53      24.647  -7.087  30.144  1.00 37.56     0.217 C
ATOM    490  OD1 ASN A  53      24.804  -8.095  29.457  1.00 37.26    -0.274 OA
ATOM    491  ND2 ASN A  53      25.681  -6.368  30.584  1.00 37.72    -0.370 N
ATOM    492  H   ASN A  53      20.764  -5.781  30.512  1.00 32.21     0.163 HD
ATOM    493 2HD2 ASN A  53      26.620  -6.675  30.378  1.00 37.72     0.159 HD
ATOM    494 1HD2 ASN A  53      25.525  -5.549  31.154  1.00 37.72     0.159 HD
ATOM    495  N   TYR A  54      21.840  -7.710  27.318  1.00 33.32    -0.346 N
ATOM    496  CA  TYR A  54      21.222  -8.782  26.544  1.00 36.27     0.180 C
ATOM    497  C   TYR A  54      21.950 -10.130  26.616  1.00 34.79     0.241 C
ATOM    498  O   TYR A  54      21.317 -11.146  26.344  1.00 33.25    -0.271 OA
ATOM    499  CB  TYR A  54      21.138  -8.328  25.080  1.00 36.17     0.073 C
ATOM    500  CG  TYR A  54      20.005  -7.358  24.832  1.00 33.46    -0.056 A
ATOM    501  CD1 TYR A  54      18.686  -7.848  24.810  1.00 33.71     0.010 A
ATOM    502  CD2 TYR A  54      20.249  -5.987  24.613  1.00 34.68     0.010 A
ATOM    503  CE1 TYR A  54      17.617  -6.976  24.564  1.00 33.10     0.037 A
ATOM    504  CE2 TYR A  54      19.176  -5.119  24.335  1.00 35.14     0.037 A
ATOM    505  CZ  TYR A  54      17.856  -5.612  24.320  1.00 34.41     0.065 A
ATOM    506  OH  TYR A  54      16.805  -4.779  24.079  1.00 30.82    -0.361 OA
ATOM    507  H   TYR A  54      22.184  -6.914  26.801  1.00 33.32     0.163 HD
ATOM    508  HH  TYR A  54      17.075  -3.886  23.906  1.00 30.82     0.217 HD
ATOM    509  N   GLU A  55      23.232 -10.162  27.015  1.00 38.32    -0.346 N
ATOM    510  CA  GLU A  55      23.980 -11.398  27.242  1.00 38.74     0.177 C
ATOM    511  C   GLU A  55      23.558 -12.030  28.579  1.00 35.67     0.241 C
ATOM    512  O   GLU A  55      23.278 -13.227  28.616  1.00 33.16    -0.271 OA
ATOM    513  CB  GLU A  55      25.492 -11.081  27.287  1.00 44.48     0.045 C
ATOM    514  CG  GLU A  55      26.103 -10.690  25.922  1.00 49.86     0.116 C
ATOM    515  CD  GLU A  55      26.137 -11.813  24.876  1.00 55.02     0.172 C
ATOM    516  OE1 GLU A  55      25.982 -12.993  25.262  1.00 59.41    -0.648 OA
ATOM    517  OE2 GLU A  55      26.325 -11.464  23.691  1.00 59.86    -0.648 OA
ATOM    518  H   GLU A  55      23.693  -9.292  27.240  1.00 38.32     0.163 HD
ATOM    519  N   ASP A  56      23.451 -11.225  29.652  1.00 36.82    -0.346 N
ATOM    520  CA  ASP A  56      23.051 -11.662  30.996  1.00 36.88     0.186 C
ATOM    521  C   ASP A  56      21.566 -12.051  31.092  1.00 36.87     0.241 C
ATOM    522  O   ASP A  56      21.224 -12.890  31.925  1.00 31.75    -0.271 OA
ATOM    523  CB  ASP A  56      23.333 -10.549  32.036  1.00 37.25     0.147 C
ATOM    524  CG  ASP A  56      24.803 -10.134  32.182  1.00 38.70     0.175 C
ATOM    525  OD1 ASP A  56      25.685 -10.877  31.696  1.00 35.83    -0.648 OA
ATOM    526  OD2 ASP A  56      25.019  -9.074  32.808  1.00 44.25    -0.648 OA
ATOM    527  H   ASP A  56      23.701 -10.252  29.544  1.00 36.82     0.163 HD
ATOM    528  N   LEU A  57      20.698 -11.481  30.237  1.00 37.55    -0.346 N
ATOM    529  CA  LEU A  57      19.275 -11.812  30.153  1.00 37.41     0.177 C
ATOM    530  C   LEU A  57      19.036 -13.092  29.334  1.00 38.24     0.241 C
ATOM    531  O   LEU A  57      18.118 -13.843  29.662  1.00 37.38    -0.271 OA
ATOM    532  CB  LEU A  57      18.523 -10.656  29.453  1.00 34.52     0.038 C
ATOM    533  CG  LEU A  57      18.361  -9.377  30.303  1.00 37.17    -0.020 C
ATOM    534  CD1 LEU A  57      17.940  -8.192  29.421  1.00 38.63     0.009 C
ATOM    535  CD2 LEU A  57      17.354  -9.562  31.450  1.00 39.51     0.009 C
ATOM    536  H   LEU A  57      21.052 -10.777  29.603  1.00 37.55     0.163 HD
ATOM    537  N   LEU A  58      19.851 -13.354  28.296  1.00 43.04    -0.346 N
ATOM    538  CA  LEU A  58      19.715 -14.507  27.398  1.00 43.52     0.177 C
ATOM    539  C   LEU A  58      20.303 -15.793  28.011  1.00 44.56     0.241 C
ATOM    540  O   LEU A  58      19.865 -16.881  27.644  1.00 42.21    -0.271 OA
ATOM    541  CB  LEU A  58      20.440 -14.171  26.075  1.00 46.03     0.038 C
ATOM    542  CG  LEU A  58      20.210 -15.138  24.892  1.00 44.69    -0.020 C
ATOM    543  CD1 LEU A  58      18.738 -15.152  24.449  1.00 45.15     0.009 C
ATOM    544  CD2 LEU A  58      21.118 -14.751  23.717  1.00 47.95     0.009 C
ATOM    545  H   LEU A  58      20.591 -12.697  28.090  1.00 43.04     0.163 HD
ATOM    546  N   ILE A  59      21.227 -15.676  28.985  1.00 43.64    -0.346 N
ATOM    547  CA  ILE A  59      21.735 -16.764  29.835  1.00 43.85     0.180 C
ATOM    548  C   ILE A  59      20.619 -17.416  30.687  1.00 44.01     0.241 C
ATOM    549  O   ILE A  59      20.732 -18.591  31.036  1.00 45.50    -0.271 OA
ATOM    550  CB  ILE A  59      22.929 -16.214  30.685  1.00 45.84     0.013 C
ATOM    551  CG1 ILE A  59      24.199 -16.126  29.803  1.00 47.97     0.002 C
ATOM    552  CG2 ILE A  59      23.238 -17.006  31.978  1.00 47.03     0.012 C
ATOM    553  CD1 ILE A  59      25.330 -15.260  30.379  1.00 51.29     0.005 C
ATOM    554  H   ILE A  59      21.558 -14.746  29.200  1.00 43.64     0.163 HD
ATOM    555  N   ARG A  60      19.542 -16.673  30.995  1.00 46.58    -0.346 N
ATOM    556  CA  ARG A  60      18.394 -17.137  31.776  1.00 49.58     0.176 C
ATOM    557  C   ARG A  60      17.300 -17.771  30.895  1.00 45.44     0.241 C
ATOM    558  O   ARG A  60      16.352 -18.334  31.443  1.00 47.11    -0.271 OA
ATOM    559  CB  ARG A  60      17.770 -15.925  32.512  1.00 55.96     0.036 C
ATOM    560  CG  ARG A  60      18.770 -15.066  33.312  1.00 63.41     0.023 C
ATOM    561  CD  ARG A  60      19.495 -15.816  34.442  1.00 68.56     0.138 C
ATOM    562  NE  ARG A  60      20.741 -15.131  34.815  1.00 77.57    -0.227 N
ATOM    563  CZ  ARG A  60      21.783 -15.687  35.457  1.00 81.70     0.665 C
ATOM    564  NH1 ARG A  60      22.866 -14.941  35.708  1.00 86.34    -0.235 N
ATOM    565  NH2 ARG A  60      21.765 -16.969  35.850  1.00 79.58    -0.235 N
ATOM    566  H   ARG A  60      19.513 -15.722  30.655  1.00 46.58     0.163 HD
ATOM    567  HE  ARG A  60      20.800 -14.157  34.554  1.00 77.57     0.177 HD
ATOM    568 HH12 ARG A  60      23.663 -15.337  36.186  1.00 86.34     0.174 HD
ATOM    569 HH11 ARG A  60      22.902 -13.977  35.409  1.00 86.34     0.174 HD
ATOM    570 HH22 ARG A  60      22.556 -17.375  36.327  1.00 79.58     0.174 HD
ATOM    571 HH21 ARG A  60      20.953 -17.541  35.663  1.00 79.58     0.174 HD
ATOM    572  N   LYS A  61      17.419 -17.692  29.557  1.00 41.93    -0.346 N
ATOM    573  CA  LYS A  61      16.486 -18.284  28.602  1.00 44.45     0.176 C
ATOM    574  C   LYS A  61      17.119 -19.544  27.996  1.00 41.73     0.241 C
ATOM    575  O   LYS A  61      18.237 -19.506  27.485  1.00 44.39    -0.271 OA
ATOM    576  CB  LYS A  61      16.205 -17.286  27.455  1.00 44.96     0.035 C
ATOM    577  CG  LYS A  61      15.711 -15.895  27.894  1.00 48.77     0.004 C
ATOM    578  CD  LYS A  61      14.508 -15.909  28.853  1.00 51.64     0.027 C
ATOM    579  CE  LYS A  61      13.960 -14.497  29.106  1.00 57.68     0.229 C
ATOM    580  NZ  LYS A  61      12.821 -14.511  30.037  1.00 63.54    -0.079 N
ATOM    581  H   LYS A  61      18.242 -17.246  29.174  1.00 41.93     0.163 HD
ATOM    582  HZ1 LYS A  61      13.114 -14.891  30.926  1.00 63.54     0.274 HD
ATOM    583  HZ2 LYS A  61      12.488 -13.566  30.168  1.00 63.54     0.274 HD
ATOM    584  HZ3 LYS A  61      12.078 -15.078  29.654  1.00 63.54     0.274 HD
ATOM    585  N   SER A  62      16.361 -20.646  28.022  1.00 41.75    -0.344 N
ATOM    586  CA  SER A  62      16.608 -21.876  27.272  1.00 40.81     0.200 C
ATOM    587  C   SER A  62      15.684 -21.895  26.037  1.00 36.46     0.243 C
ATOM    588  O   SER A  62      14.875 -20.985  25.843  1.00 37.47    -0.271 OA
ATOM    589  CB  SER A  62      16.259 -23.067  28.188  1.00 41.17     0.199 C
ATOM    590  OG  SER A  62      17.301 -23.285  29.116  1.00 41.12    -0.398 OA
ATOM    591  H   SER A  62      15.466 -20.590  28.490  1.00 41.75     0.163 HD
ATOM    592  HG  SER A  62      17.067 -24.013  29.670  1.00 41.12     0.209 HD
ATOM    593  N   ASN A  63      15.801 -22.938  25.197  1.00 35.76    -0.345 N
ATOM    594  CA  ASN A  63      15.019 -23.134  23.968  1.00 35.70     0.185 C
ATOM    595  C   ASN A  63      13.498 -23.179  24.200  1.00 35.03     0.241 C
ATOM    596  O   ASN A  63      12.748 -22.613  23.407  1.00 31.95    -0.271 OA
ATOM    597  CB  ASN A  63      15.458 -24.429  23.246  1.00 36.95     0.137 C
ATOM    598  CG  ASN A  63      16.919 -24.423  22.790  1.00 40.30     0.217 C
ATOM    599  OD1 ASN A  63      17.402 -23.427  22.259  1.00 37.48    -0.274 OA
ATOM    600  ND2 ASN A  63      17.638 -25.522  23.021  1.00 40.93    -0.370 N
ATOM    601  H   ASN A  63      16.490 -23.644  25.415  1.00 35.76     0.163 HD
ATOM    602 2HD2 ASN A  63      18.606 -25.554  22.733  1.00 40.93     0.159 HD
ATOM    603 1HD2 ASN A  63      17.214 -26.324  23.463  1.00 40.93     0.159 HD
ATOM    604  N   HIS A  64      13.049 -23.816  25.296  1.00 33.50    -0.346 N
ATOM    605  CA  HIS A  64      11.637 -23.981  25.650  1.00 33.12     0.182 C
ATOM    606  C   HIS A  64      10.973 -22.695  26.186  1.00 32.21     0.241 C
ATOM    607  O   HIS A  64       9.745 -22.636  26.228  1.00 32.15    -0.271 OA
ATOM    608  CB  HIS A  64      11.511 -25.103  26.705  1.00 31.26     0.095 C
ATOM    609  CG  HIS A  64      12.171 -24.855  28.042  1.00 30.98     0.053 A
ATOM    610  ND1 HIS A  64      13.488 -25.241  28.314  1.00 33.90    -0.247 NA
ATOM    611  CD2 HIS A  64      11.643 -24.253  29.167  1.00 29.76     0.116 A
ATOM    612  CE1 HIS A  64      13.691 -24.886  29.577  1.00 33.62     0.207 A
ATOM    613  NE2 HIS A  64      12.638 -24.282  30.127  1.00 29.98    -0.359 N
ATOM    614  H   HIS A  64      13.728 -24.240  25.912  1.00 33.50     0.163 HD
ATOM    615  HE2 HIS A  64      12.577 -23.924  31.069  1.00 29.98     0.166 HD
ATOM    616  N   ASN A  65      11.758 -21.670  26.570  1.00 32.54    -0.346 N
ATOM    617  CA  ASN A  65      11.250 -20.359  26.995  1.00 36.14     0.185 C
ATOM    618  C   ASN A  65      10.859 -19.481  25.792  1.00 34.38     0.241 C
ATOM    619  O   ASN A  65      10.084 -18.542  25.965  1.00 34.18    -0.271 OA
ATOM    620  CB  ASN A  65      12.319 -19.597  27.813  1.00 37.27     0.137 C
ATOM    621  CG  ASN A  65      12.660 -20.290  29.134  1.00 37.35     0.217 C
ATOM    622  OD1 ASN A  65      13.678 -20.966  29.240  1.00 40.76    -0.274 OA
ATOM    623  ND2 ASN A  65      11.821 -20.106  30.156  1.00 37.21    -0.370 N
ATOM    624  H   ASN A  65      12.760 -21.780  26.502  1.00 32.54     0.163 HD
ATOM    625 2HD2 ASN A  65      12.020 -20.539  31.046  1.00 37.21     0.159 HD
ATOM    626 1HD2 ASN A  65      10.991 -19.544  30.038  1.00 37.21     0.159 HD
ATOM    627  N   PHE A  66      11.353 -19.804  24.585  1.00 32.29    -0.346 N
ATOM    628  CA  PHE A  66      10.953 -19.192  23.324  1.00 34.43     0.180 C
ATOM    629  C   PHE A  66       9.799 -20.026  22.753  1.00 35.08     0.241 C
ATOM    630  O   PHE A  66      10.009 -21.081  22.153  1.00 35.65    -0.271 OA
ATOM    631  CB  PHE A  66      12.153 -19.223  22.355  1.00 34.22     0.073 C
ATOM    632  CG  PHE A  66      13.283 -18.313  22.792  1.00 34.48    -0.056 A
ATOM    633  CD1 PHE A  66      13.137 -16.915  22.681  1.00 35.00     0.007 A
ATOM    634  CD2 PHE A  66      14.461 -18.854  23.346  1.00 36.44     0.007 A
ATOM    635  CE1 PHE A  66      14.156 -16.063  23.143  1.00 35.54     0.001 A
ATOM    636  CE2 PHE A  66      15.480 -18.001  23.811  1.00 39.92     0.001 A
ATOM    637  CZ  PHE A  66      15.324 -16.605  23.714  1.00 36.35     0.000 A
ATOM    638  H   PHE A  66      11.974 -20.599  24.524  1.00 32.29     0.163 HD
ATOM    639  N   LEU A  67       8.571 -19.539  22.973  1.00 34.10    -0.346 N
ATOM    640  CA  LEU A  67       7.324 -20.138  22.516  1.00 35.85     0.177 C
ATOM    641  C   LEU A  67       6.992 -19.508  21.158  1.00 38.50     0.241 C
ATOM    642  O   LEU A  67       6.518 -18.373  21.082  1.00 35.72    -0.271 OA
ATOM    643  CB  LEU A  67       6.210 -19.793  23.533  1.00 41.34     0.038 C
ATOM    644  CG  LEU A  67       6.438 -20.338  24.960  1.00 46.25    -0.020 C
ATOM    645  CD1 LEU A  67       5.354 -19.810  25.911  1.00 47.90     0.009 C
ATOM    646  CD2 LEU A  67       6.497 -21.874  25.004  1.00 47.07     0.009 C
ATOM    647  H   LEU A  67       8.493 -18.658  23.467  1.00 34.10     0.163 HD
ATOM    648  N   VAL A  68       7.293 -20.253  20.086  1.00 34.09    -0.346 N
ATOM    649  CA  VAL A  68       7.121 -19.839  18.699  1.00 35.44     0.180 C
ATOM    650  C   VAL A  68       5.875 -20.553  18.147  1.00 36.26     0.241 C
ATOM    651  O   VAL A  68       5.730 -21.762  18.324  1.00 35.90    -0.271 OA
ATOM    652  CB  VAL A  68       8.391 -20.235  17.901  1.00 37.61     0.009 C
ATOM    653  CG1 VAL A  68       8.289 -19.844  16.420  1.00 37.52     0.012 C
ATOM    654  CG2 VAL A  68       9.671 -19.610  18.492  1.00 37.05     0.012 C
ATOM    655  H   VAL A  68       7.673 -21.176  20.241  1.00 34.09     0.163 HD
ATOM    656  N   GLN A  69       4.992 -19.801  17.471  1.00 34.57    -0.346 N
ATOM    657  CA  GLN A  69       3.701 -20.267  16.970  1.00 37.65     0.177 C
ATOM    658  C   GLN A  69       3.418 -19.696  15.578  1.00 39.04     0.241 C
ATOM    659  O   GLN A  69       3.219 -18.491  15.433  1.00 34.44    -0.271 OA
ATOM    660  CB  GLN A  69       2.608 -19.958  18.014  1.00 43.21     0.044 C
ATOM    661  CG  GLN A  69       1.194 -20.446  17.634  1.00 45.07     0.105 C
ATOM    662  CD  GLN A  69       0.157 -20.130  18.716  1.00 46.48     0.215 C
ATOM    663  OE1 GLN A  69       0.450 -20.190  19.908  1.00 53.55    -0.274 OA
ATOM    664  NE2 GLN A  69      -1.063 -19.782  18.306  1.00 47.73    -0.370 N
ATOM    665  H   GLN A  69       5.201 -18.818  17.351  1.00 34.57     0.163 HD
ATOM    666 2HE2 GLN A  69      -1.782 -19.579  18.986  1.00 47.73     0.159 HD
ATOM    667 1HE2 GLN A  69      -1.272 -19.720  17.317  1.00 47.73     0.159 HD
ATOM    668  N   ALA A  70       3.355 -20.577  14.569  1.00 41.29    -0.346 N
ATOM    669  CA  ALA A  70       2.947 -20.265  13.205  1.00 42.78     0.172 C
ATOM    670  C   ALA A  70       1.445 -20.549  13.083  1.00 45.92     0.240 C
ATOM    671  O   ALA A  70       1.035 -21.707  13.007  1.00 46.44    -0.271 OA
ATOM    672  CB  ALA A  70       3.715 -21.206  12.260  1.00 40.06     0.042 C
ATOM    673  H   ALA A  70       3.497 -21.555  14.785  1.00 41.29     0.163 HD
ATOM    674  N   GLY A  71       0.620 -19.489  13.092  1.00 53.72    -0.351 N
ATOM    675  CA  GLY A  71      -0.839 -19.574  13.054  1.00 55.33     0.225 C
ATOM    676  C   GLY A  71      -1.401 -20.121  14.371  1.00 58.49     0.236 C
ATOM    677  O   GLY A  71      -1.455 -19.399  15.364  1.00 58.14    -0.272 OA
ATOM    678  H   GLY A  71       1.025 -18.567  13.174  1.00 53.72     0.163 HD
ATOM    679  N   ASN A  72      -1.793 -21.406  14.359  1.00 63.20    -0.346 N
ATOM    680  CA  ASN A  72      -2.270 -22.190  15.502  1.00 66.57     0.185 C
ATOM    681  C   ASN A  72      -1.607 -23.577  15.564  1.00 63.44     0.241 C
ATOM    682  O   ASN A  72      -2.249 -24.565  15.918  1.00 68.77    -0.271 OA
ATOM    683  CB  ASN A  72      -3.815 -22.179  15.626  1.00 74.36     0.137 C
ATOM    684  CG  ASN A  72      -4.375 -20.842  16.119  1.00 80.54     0.217 C
ATOM    685  OD1 ASN A  72      -4.177 -20.477  17.276  1.00 84.08    -0.274 OA
ATOM    686  ND2 ASN A  72      -5.059 -20.100  15.246  1.00 77.26    -0.370 N
ATOM    687  H   ASN A  72      -1.688 -21.909  13.490  1.00 63.20     0.163 HD
ATOM    688 2HD2 ASN A  72      -5.434 -19.210  15.539  1.00 77.26     0.159 HD
ATOM    689 1HD2 ASN A  72      -5.199 -20.426  14.302  1.00 77.26     0.159 HD
ATOM    690  N   VAL A  73      -0.302 -23.633  15.251  0.38 59.59    -0.346 N
ATOM    691  CA  VAL A  73       0.579 -24.782  15.448  0.38 58.81     0.180 C
ATOM    692  C   VAL A  73       1.915 -24.283  16.014  0.38 54.55     0.241 C
ATOM    693  O   VAL A  73       2.527 -23.367  15.462  0.38 48.89    -0.271 OA
ATOM    694  CB  VAL A  73       0.653 -25.691  14.189  0.38 61.02     0.009 C
ATOM    695  CG1 VAL A  73       1.104 -24.961  12.911  0.38 60.44     0.012 C
ATOM    696  CG2 VAL A  73       1.519 -26.942  14.427  0.38 62.41     0.012 C
ATOM    697  H   VAL A  73       0.145 -22.782  14.937  0.38 59.59     0.163 HD
ATOM    698  N   GLN A  74       2.344 -24.883  17.135  1.00 52.25    -0.346 N
ATOM    699  CA  GLN A  74       3.543 -24.514  17.879  1.00 48.91     0.177 C
ATOM    700  C   GLN A  74       4.770 -25.167  17.220  1.00 44.08     0.241 C
ATOM    701  O   GLN A  74       4.760 -26.368  16.944  1.00 43.63    -0.271 OA
ATOM    702  CB  GLN A  74       3.399 -25.050  19.324  1.00 48.14     0.044 C
ATOM    703  CG  GLN A  74       4.337 -24.361  20.344  1.00 49.04     0.105 C
ATOM    704  CD  GLN A  74       3.905 -22.960  20.807  1.00 50.05     0.215 C
ATOM    705  OE1 GLN A  74       4.688 -22.262  21.446  1.00 45.52    -0.274 OA
ATOM    706  NE2 GLN A  74       2.679 -22.528  20.500  1.00 51.14    -0.370 N
ATOM    707  H   GLN A  74       1.793 -25.643  17.507  1.00 52.25     0.163 HD
ATOM    708 2HE2 GLN A  74       2.380 -21.611  20.799  1.00 51.14     0.159 HD
ATOM    709 1HE2 GLN A  74       2.051 -23.116  19.973  1.00 51.14     0.159 HD
ATOM    710  N   LEU A  75       5.822 -24.370  16.984  1.00 36.42    -0.346 N
ATOM    711  CA  LEU A  75       7.104 -24.825  16.452  1.00 35.27     0.177 C
ATOM    712  C   LEU A  75       8.046 -25.075  17.637  1.00 32.85     0.241 C
ATOM    713  O   LEU A  75       8.201 -24.216  18.507  1.00 31.41    -0.271 OA
ATOM    714  CB  LEU A  75       7.723 -23.720  15.565  1.00 36.08     0.038 C
ATOM    715  CG  LEU A  75       6.826 -23.191  14.424  1.00 37.61    -0.020 C
ATOM    716  CD1 LEU A  75       7.619 -22.218  13.543  1.00 37.31     0.009 C
ATOM    717  CD2 LEU A  75       6.219 -24.309  13.559  1.00 40.84     0.009 C
ATOM    718  H   LEU A  75       5.764 -23.402  17.274  1.00 36.42     0.163 HD
ATOM    719  N   ARG A  76       8.675 -26.260  17.659  1.00 32.24    -0.346 N
ATOM    720  CA  ARG A  76       9.607 -26.688  18.697  1.00 33.20     0.176 C
ATOM    721  C   ARG A  76      10.991 -26.108  18.378  1.00 33.02     0.241 C
ATOM    722  O   ARG A  76      11.608 -26.482  17.380  1.00 33.18    -0.271 OA
ATOM    723  CB  ARG A  76       9.668 -28.230  18.667  1.00 34.65     0.036 C
ATOM    724  CG  ARG A  76      10.611 -28.878  19.704  1.00 34.69     0.023 C
ATOM    725  CD  ARG A  76      10.820 -30.382  19.470  1.00 35.55     0.138 C
ATOM    726  NE  ARG A  76       9.545 -31.113  19.442  1.00 35.99    -0.227 N
ATOM    727  CZ  ARG A  76       8.861 -31.559  20.510  1.00 33.70     0.665 C
ATOM    728  NH1 ARG A  76       9.315 -31.377  21.759  1.00 32.91    -0.235 N
ATOM    729  NH2 ARG A  76       7.697 -32.192  20.322  1.00 35.15    -0.235 N
ATOM    730  H   ARG A  76       8.514 -26.904  16.896  1.00 32.24     0.163 HD
ATOM    731  HE  ARG A  76       9.156 -31.253  18.519  1.00 35.99     0.177 HD
ATOM    732 HH12 ARG A  76       8.791 -31.713  22.553  1.00 32.91     0.174 HD
ATOM    733 HH11 ARG A  76      10.191 -30.899  21.909  1.00 32.91     0.174 HD
ATOM    734 HH22 ARG A  76       7.164 -32.532  21.109  1.00 35.15     0.174 HD
ATOM    735 HH21 ARG A  76       7.341 -32.335  19.387  1.00 35.15     0.174 HD
ATOM    736  N   VAL A  77      11.472 -25.212  19.252  1.00 32.71    -0.346 N
ATOM    737  CA  VAL A  77      12.796 -24.598  19.183  1.00 32.36     0.180 C
ATOM    738  C   VAL A  77      13.833 -25.616  19.695  1.00 33.33     0.241 C
ATOM    739  O   VAL A  77      13.621 -26.279  20.711  1.00 31.90    -0.271 OA
ATOM    740  CB  VAL A  77      12.807 -23.303  20.041  1.00 31.57     0.009 C
ATOM    741  CG1 VAL A  77      14.169 -22.579  20.049  1.00 30.40     0.012 C
ATOM    742  CG2 VAL A  77      11.728 -22.305  19.578  1.00 31.42     0.012 C
ATOM    743  H   VAL A  77      10.894 -24.957  20.040  1.00 32.71     0.163 HD
ATOM    744  N   ILE A  78      14.950 -25.722  18.963  1.00 36.03    -0.346 N
ATOM    745  CA  ILE A  78      16.060 -26.654  19.171  1.00 35.21     0.180 C
ATOM    746  C   ILE A  78      17.416 -25.927  19.271  1.00 34.67     0.241 C
ATOM    747  O   ILE A  78      18.439 -26.574  19.493  1.00 34.06    -0.271 OA
ATOM    748  CB  ILE A  78      16.032 -27.766  18.085  1.00 39.36     0.013 C
ATOM    749  CG1 ILE A  78      16.136 -27.200  16.647  1.00 41.62     0.002 C
ATOM    750  CG2 ILE A  78      14.795 -28.673  18.246  1.00 39.32     0.012 C
ATOM    751  CD1 ILE A  78      16.494 -28.245  15.584  1.00 39.21     0.005 C
ATOM    752  H   ILE A  78      15.017 -25.126  18.146  1.00 36.03     0.163 HD
ATOM    753  N   GLY A  79      17.425 -24.594  19.130  1.00 35.02    -0.351 N
ATOM    754  CA  GLY A  79      18.596 -23.742  19.271  1.00 35.40     0.225 C
ATOM    755  C   GLY A  79      18.186 -22.271  19.330  1.00 32.89     0.236 C
ATOM    756  O   GLY A  79      17.132 -21.893  18.820  1.00 31.35    -0.272 OA
ATOM    757  H   GLY A  79      16.549 -24.125  18.946  1.00 35.02     0.163 HD
ATOM    758  N   HIS A  80      19.043 -21.436  19.933  1.00 33.16    -0.346 N
ATOM    759  CA  HIS A  80      18.923 -19.981  19.960  1.00 33.12     0.182 C
ATOM    760  C   HIS A  80      20.319 -19.350  19.947  1.00 36.54     0.241 C
ATOM    761  O   HIS A  80      21.224 -19.828  20.632  1.00 35.73    -0.271 OA
ATOM    762  CB  HIS A  80      18.002 -19.484  21.097  1.00 33.12     0.093 C
ATOM    763  CG  HIS A  80      18.517 -19.674  22.502  1.00 35.22     0.030 A
ATOM    764  ND1 HIS A  80      18.418 -20.869  23.192  1.00 36.22    -0.353 N
ATOM    765  CD2 HIS A  80      19.181 -18.813  23.347  1.00 34.40     0.143 A
ATOM    766  CE1 HIS A  80      18.994 -20.685  24.382  1.00 35.51     0.207 A
ATOM    767  NE2 HIS A  80      19.477 -19.460  24.547  1.00 36.80    -0.254 NA
ATOM    768  H   HIS A  80      19.882 -21.822  20.344  1.00 33.16     0.163 HD
ATOM    769  HD1 HIS A  80      18.005 -21.730  22.851  1.00 36.22     0.166 HD
ATOM    770  N   SER A  81      20.485 -18.275  19.163  1.00 35.80    -0.344 N
ATOM    771  CA  SER A  81      21.728 -17.523  19.011  1.00 34.03     0.200 C
ATOM    772  C   SER A  81      21.421 -16.061  18.675  1.00 33.97     0.243 C
ATOM    773  O   SER A  81      20.557 -15.788  17.843  1.00 32.32    -0.271 OA
ATOM    774  CB  SER A  81      22.676 -18.232  18.017  1.00 33.84     0.199 C
ATOM    775  OG  SER A  81      22.206 -18.160  16.684  1.00 33.90    -0.398 OA
ATOM    776  H   SER A  81      19.694 -17.952  18.622  1.00 35.80     0.163 HD
ATOM    777  HG  SER A  81      21.369 -18.597  16.640  1.00 33.90     0.209 HD
ATOM    778  N   MET A  82      22.139 -15.127  19.315  1.00 32.82    -0.346 N
ATOM    779  CA  MET A  82      22.004 -13.690  19.104  1.00 35.34     0.177 C
ATOM    780  C   MET A  82      23.072 -13.233  18.104  1.00 33.26     0.241 C
ATOM    781  O   MET A  82      24.267 -13.409  18.339  1.00 35.11    -0.271 OA
ATOM    782  CB  MET A  82      22.228 -12.996  20.463  1.00 34.02     0.045 C
ATOM    783  CG  MET A  82      21.835 -11.511  20.483  1.00 34.54     0.076 C
ATOM    784  SD  MET A  82      21.602 -10.835  22.150  1.00 35.65    -0.173 SA
ATOM    785  CE  MET A  82      23.280 -10.953  22.818  1.00 35.06     0.089 C
ATOM    786  H   MET A  82      22.844 -15.428  19.973  1.00 32.82     0.163 HD
ATOM    787  N   GLN A  83      22.615 -12.620  17.003  1.00 30.89    -0.346 N
ATOM    788  CA  GLN A  83      23.436 -11.937  16.012  1.00 30.61     0.177 C
ATOM    789  C   GLN A  83      23.023 -10.463  16.055  1.00 28.63     0.241 C
ATOM    790  O   GLN A  83      22.011 -10.081  15.468  1.00 28.47    -0.271 OA
ATOM    791  CB  GLN A  83      23.218 -12.577  14.623  1.00 31.15     0.044 C
ATOM    792  CG  GLN A  83      24.146 -12.000  13.530  1.00 33.34     0.105 C
ATOM    793  CD  GLN A  83      23.834 -12.502  12.117  1.00 34.40     0.215 C
ATOM    794  OE1 GLN A  83      23.090 -13.461  11.927  1.00 38.21    -0.274 OA
ATOM    795  NE2 GLN A  83      24.411 -11.849  11.107  1.00 33.08    -0.370 N
ATOM    796  H   GLN A  83      21.613 -12.518  16.900  1.00 30.89     0.163 HD
ATOM    797 2HE2 GLN A  83      24.234 -12.136  10.155  1.00 33.08     0.159 HD
ATOM    798 1HE2 GLN A  83      25.014 -11.060  11.291  1.00 33.08     0.159 HD
ATOM    799  N   ASN A  84      23.798  -9.658  16.799  1.00 25.88    -0.346 N
ATOM    800  CA  ASN A  84      23.662  -8.208  16.955  1.00 27.95     0.185 C
ATOM    801  C   ASN A  84      22.431  -7.861  17.807  1.00 28.11     0.241 C
ATOM    802  O   ASN A  84      22.494  -7.985  19.030  1.00 31.03    -0.271 OA
ATOM    803  CB  ASN A  84      23.778  -7.434  15.617  1.00 28.22     0.137 C
ATOM    804  CG  ASN A  84      25.124  -7.630  14.918  1.00 28.59     0.217 C
ATOM    805  OD1 ASN A  84      26.160  -7.224  15.436  1.00 31.57    -0.274 OA
ATOM    806  ND2 ASN A  84      25.115  -8.273  13.748  1.00 29.98    -0.370 N
ATOM    807  H   ASN A  84      24.583 -10.081  17.273  1.00 25.88     0.163 HD
ATOM    808 2HD2 ASN A  84      25.983  -8.412  13.253  1.00 29.98     0.159 HD
ATOM    809 1HD2 ASN A  84      24.239  -8.587  13.350  1.00 29.98     0.159 HD
ATOM    810  N   CYS A  85      21.318  -7.462  17.165  1.00 26.75    -0.345 N
ATOM    811  CA  CYS A  85      20.061  -7.062  17.804  1.00 26.71     0.185 C
ATOM    812  C   CYS A  85      18.863  -7.941  17.399  1.00 25.68     0.241 C
ATOM    813  O   CYS A  85      17.723  -7.562  17.662  1.00 27.44    -0.271 OA
ATOM    814  CB  CYS A  85      19.792  -5.550  17.640  1.00 26.23     0.105 C
ATOM    815  SG  CYS A  85      21.097  -4.548  18.405  1.00 29.92    -0.180 SA
ATOM    816  H   CYS A  85      21.360  -7.381  16.159  1.00 26.75     0.163 HD
ATOM    817  HG  CYS A  85      20.945  -5.042  19.637  1.00 29.92     0.101 HD
ATOM    818  N   VAL A  86      19.099  -9.133  16.823  1.00 27.31    -0.346 N
ATOM    819  CA  VAL A  86      18.076 -10.149  16.546  1.00 29.40     0.180 C
ATOM    820  C   VAL A  86      18.519 -11.515  17.082  1.00 29.39     0.241 C
ATOM    821  O   VAL A  86      19.702 -11.854  17.034  1.00 29.08    -0.271 OA
ATOM    822  CB  VAL A  86      17.648 -10.183  15.050  1.00 29.86     0.009 C
ATOM    823  CG1 VAL A  86      16.994  -8.869  14.592  1.00 32.10     0.012 C
ATOM    824  CG2 VAL A  86      18.765 -10.628  14.087  1.00 33.09     0.012 C
ATOM    825  H   VAL A  86      20.058  -9.395  16.636  1.00 27.31     0.163 HD
ATOM    826  N   LEU A  87      17.544 -12.301  17.562  1.00 27.43    -0.346 N
ATOM    827  CA  LEU A  87      17.704 -13.697  17.950  1.00 29.85     0.177 C
ATOM    828  C   LEU A  87      17.233 -14.576  16.788  1.00 27.97     0.241 C
ATOM    829  O   LEU A  87      16.111 -14.433  16.298  1.00 25.32    -0.271 OA
ATOM    830  CB  LEU A  87      16.814 -14.003  19.175  1.00 34.24     0.038 C
ATOM    831  CG  LEU A  87      17.261 -13.297  20.470  1.00 38.64    -0.020 C
ATOM    832  CD1 LEU A  87      16.198 -13.437  21.561  1.00 42.10     0.009 C
ATOM    833  CD2 LEU A  87      18.611 -13.803  20.996  1.00 37.87     0.009 C
ATOM    834  H   LEU A  87      16.597 -11.945  17.537  1.00 27.43     0.163 HD
ATOM    835  N   LYS A  88      18.111 -15.498  16.378  1.00 28.78    -0.346 N
ATOM    836  CA  LYS A  88      17.870 -16.541  15.393  1.00 29.22     0.176 C
ATOM    837  C   LYS A  88      17.518 -17.810  16.178  1.00 31.15     0.241 C
ATOM    838  O   LYS A  88      18.396 -18.478  16.728  1.00 29.24    -0.271 OA
ATOM    839  CB  LYS A  88      19.177 -16.778  14.609  1.00 31.14     0.035 C
ATOM    840  CG  LYS A  88      19.624 -15.550  13.804  1.00 34.19     0.004 C
ATOM    841  CD  LYS A  88      20.755 -15.848  12.812  1.00 35.94     0.027 C
ATOM    842  CE  LYS A  88      22.057 -16.311  13.484  1.00 40.42     0.229 C
ATOM    843  NZ  LYS A  88      23.165 -16.358  12.517  1.00 40.64    -0.079 N
ATOM    844  H   LYS A  88      19.007 -15.531  16.850  1.00 28.78     0.163 HD
ATOM    845  HZ1 LYS A  88      23.302 -15.430  12.135  1.00 40.64     0.274 HD
ATOM    846  HZ2 LYS A  88      24.010 -16.659  12.982  1.00 40.64     0.274 HD
ATOM    847  HZ3 LYS A  88      22.940 -17.000  11.770  1.00 40.64     0.274 HD
ATOM    848  N   LEU A  89      16.216 -18.110  16.250  1.00 31.78    -0.346 N
ATOM    849  CA  LEU A  89      15.656 -19.253  16.957  1.00 31.26     0.177 C
ATOM    850  C   LEU A  89      15.506 -20.389  15.938  1.00 31.07     0.241 C
ATOM    851  O   LEU A  89      14.609 -20.360  15.095  1.00 30.55    -0.271 OA
ATOM    852  CB  LEU A  89      14.259 -18.865  17.501  1.00 30.30     0.038 C
ATOM    853  CG  LEU A  89      14.232 -17.634  18.434  1.00 30.43    -0.020 C
ATOM    854  CD1 LEU A  89      12.787 -17.291  18.819  1.00 29.27     0.009 C
ATOM    855  CD2 LEU A  89      15.101 -17.828  19.684  1.00 29.75     0.009 C
ATOM    856  H   LEU A  89      15.559 -17.506  15.771  1.00 31.78     0.163 HD
ATOM    857  N   LYS A  90      16.395 -21.392  16.015  1.00 32.23    -0.346 N
ATOM    858  CA  LYS A  90      16.354 -22.584  15.175  1.00 32.19     0.176 C
ATOM    859  C   LYS A  90      15.227 -23.497  15.678  1.00 31.25     0.241 C
ATOM    860  O   LYS A  90      15.157 -23.792  16.869  1.00 33.94    -0.271 OA
ATOM    861  CB  LYS A  90      17.699 -23.337  15.264  1.00 35.83     0.035 C
ATOM    862  CG  LYS A  90      17.837 -24.434  14.190  1.00 38.38     0.004 C
ATOM    863  CD  LYS A  90      19.082 -25.312  14.375  1.00 46.56     0.027 C
ATOM    864  CE  LYS A  90      19.238 -26.324  13.231  1.00 50.97     0.229 C
ATOM    865  NZ  LYS A  90      20.352 -27.253  13.474  1.00 56.17    -0.079 N
ATOM    866  H   LYS A  90      17.084 -21.366  16.754  1.00 32.23     0.163 HD
ATOM    867  HZ1 LYS A  90      20.182 -27.772  14.323  1.00 56.17     0.274 HD
ATOM    868  HZ2 LYS A  90      20.424 -27.894  12.696  1.00 56.17     0.274 HD
ATOM    869  HZ3 LYS A  90      21.214 -26.733  13.561  1.00 56.17     0.274 HD
ATOM    870  N   VAL A  91      14.368 -23.938  14.752  1.00 32.92    -0.346 N
ATOM    871  CA  VAL A  91      13.232 -24.830  14.968  1.00 33.71     0.180 C
ATOM    872  C   VAL A  91      13.444 -26.130  14.176  1.00 35.04     0.241 C
ATOM    873  O   VAL A  91      14.202 -26.159  13.207  1.00 36.92    -0.271 OA
ATOM    874  CB  VAL A  91      11.903 -24.107  14.612  1.00 31.85     0.009 C
ATOM    875  CG1 VAL A  91      11.507 -23.073  15.680  1.00 32.69     0.012 C
ATOM    876  CG2 VAL A  91      11.909 -23.449  13.221  1.00 32.94     0.012 C
ATOM    877  H   VAL A  91      14.537 -23.663  13.792  1.00 32.92     0.163 HD
ATOM    878  N   ASP A  92      12.795 -27.220  14.617  1.00 36.39    -0.345 N
ATOM    879  CA  ASP A  92      12.945 -28.573  14.063  1.00 38.83     0.186 C
ATOM    880  C   ASP A  92      12.283 -28.740  12.677  1.00 38.90     0.241 C
ATOM    881  O   ASP A  92      12.643 -29.661  11.944  1.00 39.23    -0.271 OA
ATOM    882  CB  ASP A  92      12.354 -29.605  15.067  1.00 39.68     0.147 C
ATOM    883  CG  ASP A  92      10.833 -29.605  15.314  1.00 41.96     0.175 C
ATOM    884  OD1 ASP A  92      10.162 -28.598  14.995  1.00 42.78    -0.648 OA
ATOM    885  OD2 ASP A  92      10.364 -30.626  15.865  1.00 48.31    -0.648 OA
ATOM    886  H   ASP A  92      12.179 -27.121  15.414  1.00 36.39     0.163 HD
ATOM    887  N   THR A  93      11.329 -27.863  12.333  1.00 36.44    -0.344 N
ATOM    888  CA  THR A  93      10.538 -27.893  11.110  1.00 37.50     0.205 C
ATOM    889  C   THR A  93      10.988 -26.717  10.233  1.00 39.25     0.243 C
ATOM    890  O   THR A  93      11.023 -25.574  10.692  1.00 37.18    -0.271 OA
ATOM    891  CB  THR A  93       9.045 -27.731  11.500  1.00 38.73     0.146 C
ATOM    892  OG1 THR A  93       8.663 -28.824  12.315  1.00 36.43    -0.393 OA
ATOM    893  CG2 THR A  93       8.077 -27.725  10.302  1.00 38.09     0.042 C
ATOM    894  H   THR A  93      11.104 -27.140  13.002  1.00 36.44     0.163 HD
ATOM    895  HG1 THR A  93       9.179 -28.802  13.111  1.00 36.43     0.210 HD
ATOM    896  N   ALA A  94      11.281 -27.000   8.955  1.00 37.49    -0.346 N
ATOM    897  CA  ALA A  94      11.517 -25.991   7.929  1.00 37.80     0.172 C
ATOM    898  C   ALA A  94      10.165 -25.511   7.383  1.00 37.93     0.240 C
ATOM    899  O   ALA A  94       9.271 -26.325   7.142  1.00 36.66    -0.271 OA
ATOM    900  CB  ALA A  94      12.314 -26.626   6.780  1.00 39.65     0.042 C
ATOM    901  H   ALA A  94      11.228 -27.961   8.651  1.00 37.49     0.163 HD
ATOM    902  N   ASN A  95      10.020 -24.189   7.192  1.00 36.45    -0.346 N
ATOM    903  CA  ASN A  95       8.806 -23.535   6.704  1.00 33.09     0.185 C
ATOM    904  C   ASN A  95       8.564 -23.922   5.228  1.00 32.13     0.243 C
ATOM    905  O   ASN A  95       9.413 -23.616   4.389  1.00 31.33    -0.271 OA
ATOM    906  CB  ASN A  95       9.003 -22.006   6.834  1.00 31.14     0.137 C
ATOM    907  CG  ASN A  95       7.781 -21.158   6.447  1.00 33.23     0.217 C
ATOM    908  OD1 ASN A  95       6.639 -21.572   6.628  1.00 30.84    -0.274 OA
ATOM    909  ND2 ASN A  95       8.014 -19.982   5.866  1.00 32.47    -0.370 N
ATOM    910  H   ASN A  95      10.801 -23.589   7.428  1.00 36.45     0.163 HD
ATOM    911 2HD2 ASN A  95       7.235 -19.401   5.593  1.00 32.47     0.159 HD
ATOM    912 1HD2 ASN A  95       8.961 -19.645   5.751  1.00 32.47     0.159 HD
ATOM    913  N   PRO A  96       7.415 -24.553   4.889  1.00 33.81    -0.337 N
ATOM    914  CA  PRO A  96       7.094 -24.950   3.509  1.00 36.56     0.179 C
ATOM    915  C   PRO A  96       6.629 -23.771   2.630  1.00 38.17     0.241 C
ATOM    916  O   PRO A  96       6.558 -23.917   1.411  1.00 42.00    -0.271 OA
ATOM    917  CB  PRO A  96       5.977 -25.992   3.669  1.00 35.49     0.037 C
ATOM    918  CG  PRO A  96       5.250 -25.572   4.937  1.00 33.58     0.022 C
ATOM    919  CD  PRO A  96       6.348 -24.963   5.809  1.00 33.39     0.127 C
ATOM    920  N   LYS A  97       6.340 -22.610   3.243  1.00 37.51    -0.346 N
ATOM    921  CA  LYS A  97       5.934 -21.366   2.594  1.00 36.83     0.176 C
ATOM    922  C   LYS A  97       7.115 -20.379   2.456  1.00 35.06     0.241 C
ATOM    923  O   LYS A  97       6.880 -19.190   2.236  1.00 36.01    -0.271 OA
ATOM    924  CB  LYS A  97       4.826 -20.717   3.453  1.00 40.15     0.035 C
ATOM    925  CG  LYS A  97       3.535 -21.548   3.530  1.00 42.01     0.004 C
ATOM    926  CD  LYS A  97       2.414 -20.802   4.267  1.00 49.71     0.027 C
ATOM    927  CE  LYS A  97       1.121 -21.621   4.365  1.00 53.93     0.229 C
ATOM    928  NZ  LYS A  97       0.062 -20.862   5.052  1.00 56.36    -0.079 N
ATOM    929  H   LYS A  97       6.421 -22.582   4.249  1.00 37.51     0.163 HD
ATOM    930  HZ1 LYS A  97      -0.133 -20.014   4.539  1.00 56.36     0.274 HD
ATOM    931  HZ2 LYS A  97      -0.776 -21.423   5.104  1.00 56.36     0.274 HD
ATOM    932  HZ3 LYS A  97       0.367 -20.626   5.986  1.00 56.36     0.274 HD
ATOM    933  N   THR A  98       8.375 -20.847   2.560  1.00 35.46    -0.344 N
ATOM    934  CA  THR A  98       9.577 -20.031   2.360  1.00 34.90     0.205 C
ATOM    935  C   THR A  98       9.726 -19.731   0.853  1.00 38.56     0.245 C
ATOM    936  O   THR A  98       9.814 -20.678   0.068  1.00 37.83    -0.271 OA
ATOM    937  CB  THR A  98      10.832 -20.800   2.860  1.00 33.48     0.146 C
ATOM    938  OG1 THR A  98      10.793 -20.832   4.263  1.00 34.18    -0.393 OA
ATOM    939  CG2 THR A  98      12.186 -20.147   2.528  1.00 32.37     0.042 C
ATOM    940  H   THR A  98       8.507 -21.835   2.726  1.00 35.46     0.163 HD
ATOM    941  HG1 THR A  98      10.089 -21.410   4.518  1.00 34.18     0.210 HD
ATOM    942  N   PRO A  99       9.798 -18.448   0.433  1.00 40.22    -0.337 N
ATOM    943  CA  PRO A  99      10.114 -18.074  -0.950  1.00 38.17     0.179 C
ATOM    944  C   PRO A  99      11.638 -18.146  -1.170  1.00 37.16     0.241 C
ATOM    945  O   PRO A  99      12.401 -18.406  -0.240  1.00 36.28    -0.271 OA
ATOM    946  CB  PRO A  99       9.616 -16.621  -1.052  1.00 38.95     0.037 C
ATOM    947  CG  PRO A  99       9.847 -16.052   0.340  1.00 37.98     0.022 C
ATOM    948  CD  PRO A  99       9.595 -17.249   1.256  1.00 40.99     0.127 C
ATOM    949  N   LYS A 100      12.097 -17.824  -2.388  1.00 40.32    -0.346 N
ATOM    950  CA  LYS A 100      13.494 -17.457  -2.630  1.00 38.51     0.176 C
ATOM    951  C   LYS A 100      13.741 -16.103  -1.944  1.00 35.88     0.241 C
ATOM    952  O   LYS A 100      12.868 -15.233  -1.985  1.00 31.02    -0.271 OA
ATOM    953  CB  LYS A 100      13.734 -17.339  -4.144  1.00 44.01     0.035 C
ATOM    954  CG  LYS A 100      13.592 -18.678  -4.887  1.00 50.65     0.004 C
ATOM    955  CD  LYS A 100      13.755 -18.503  -6.400  1.00 53.10     0.027 C
ATOM    956  CE  LYS A 100      13.349 -19.748  -7.200  1.00 53.52     0.229 C
ATOM    957  NZ  LYS A 100      13.305 -19.455  -8.641  1.00 58.64    -0.079 N
ATOM    958  H   LYS A 100      11.430 -17.613  -3.116  1.00 40.32     0.163 HD
ATOM    959  HZ1 LYS A 100      14.206 -19.125  -8.956  1.00 58.64     0.274 HD
ATOM    960  HZ2 LYS A 100      13.044 -20.284  -9.155  1.00 58.64     0.274 HD
ATOM    961  HZ3 LYS A 100      12.608 -18.731  -8.800  1.00 58.64     0.274 HD
ATOM    962  N   TYR A 101      14.880 -15.949  -1.254  1.00 33.60    -0.346 N
ATOM    963  CA  TYR A 101      15.145 -14.781  -0.420  1.00 36.28     0.180 C
ATOM    964  C   TYR A 101      16.617 -14.379  -0.373  1.00 34.38     0.241 C
ATOM    965  O   TYR A 101      17.512 -15.187  -0.622  1.00 31.85    -0.271 OA
ATOM    966  CB  TYR A 101      14.477 -14.913   0.970  1.00 35.98     0.073 C
ATOM    967  CG  TYR A 101      15.197 -15.796   1.977  1.00 35.31    -0.056 A
ATOM    968  CD1 TYR A 101      16.133 -15.231   2.871  1.00 37.18     0.010 A
ATOM    969  CD2 TYR A 101      14.936 -17.181   2.028  1.00 34.68     0.010 A
ATOM    970  CE1 TYR A 101      16.802 -16.045   3.805  1.00 36.04     0.037 A
ATOM    971  CE2 TYR A 101      15.601 -17.994   2.966  1.00 33.34     0.037 A
ATOM    972  CZ  TYR A 101      16.533 -17.426   3.857  1.00 34.54     0.065 A
ATOM    973  OH  TYR A 101      17.171 -18.206   4.776  1.00 41.40    -0.361 OA
ATOM    974  H   TYR A 101      15.562 -16.695  -1.241  1.00 33.60     0.163 HD
ATOM    975  HH  TYR A 101      16.951 -19.130   4.701  1.00 41.40     0.217 HD
ATOM    976  N   LYS A 102      16.831 -13.111   0.001  1.00 35.68    -0.346 N
ATOM    977  CA  LYS A 102      18.112 -12.486   0.300  1.00 36.50     0.176 C
ATOM    978  C   LYS A 102      17.944 -11.597   1.536  1.00 33.73     0.241 C
ATOM    979  O   LYS A 102      16.874 -11.025   1.747  1.00 32.56    -0.271 OA
ATOM    980  CB  LYS A 102      18.625 -11.687  -0.917  1.00 42.27     0.035 C
ATOM    981  CG  LYS A 102      19.045 -12.546  -2.119  1.00 50.13     0.004 C
ATOM    982  CD  LYS A 102      19.431 -11.693  -3.335  1.00 56.56     0.027 C
ATOM    983  CE  LYS A 102      19.797 -12.547  -4.556  1.00 64.61     0.229 C
ATOM    984  NZ  LYS A 102      20.093 -11.705  -5.727  1.00 69.66    -0.079 N
ATOM    985  H   LYS A 102      16.016 -12.539   0.178  1.00 35.68     0.163 HD
ATOM    986  HZ1 LYS A 102      19.280 -11.150  -5.956  1.00 69.66     0.274 HD
ATOM    987  HZ2 LYS A 102      20.869 -11.094  -5.518  1.00 69.66     0.274 HD
ATOM    988  HZ3 LYS A 102      20.329 -12.292  -6.514  1.00 69.66     0.274 HD
ATOM    989  N   PHE A 103      19.016 -11.451   2.327  1.00 31.33    -0.346 N
ATOM    990  CA  PHE A 103      19.141 -10.433   3.367  1.00 33.36     0.180 C
ATOM    991  C   PHE A 103      20.099  -9.374   2.816  1.00 36.10     0.241 C
ATOM    992  O   PHE A 103      21.258  -9.676   2.529  1.00 33.17    -0.271 OA
ATOM    993  CB  PHE A 103      19.735 -11.065   4.646  1.00 33.13     0.073 C
ATOM    994  CG  PHE A 103      18.845 -12.032   5.419  1.00 30.30    -0.056 A
ATOM    995  CD1 PHE A 103      17.457 -12.140   5.171  1.00 26.24     0.007 A
ATOM    996  CD2 PHE A 103      19.424 -12.824   6.432  1.00 30.54     0.007 A
ATOM    997  CE1 PHE A 103      16.663 -13.021   5.925  1.00 26.72     0.001 A
ATOM    998  CE2 PHE A 103      18.631 -13.714   7.181  1.00 29.74     0.001 A
ATOM    999  CZ  PHE A 103      17.248 -13.811   6.930  1.00 27.17     0.000 A
ATOM   1000  H   PHE A 103      19.855 -11.965   2.097  1.00 31.33     0.163 HD
ATOM   1001  N   VAL A 104      19.590  -8.145   2.642  1.00 36.00    -0.346 N
ATOM   1002  CA  VAL A 104      20.300  -7.012   2.051  1.00 39.09     0.180 C
ATOM   1003  C   VAL A 104      20.150  -5.792   2.964  1.00 37.80     0.241 C
ATOM   1004  O   VAL A 104      19.042  -5.471   3.392  1.00 36.23    -0.271 OA
ATOM   1005  CB  VAL A 104      19.850  -6.766   0.580  1.00 43.21     0.009 C
ATOM   1006  CG1 VAL A 104      20.092  -7.988  -0.323  1.00 44.65     0.012 C
ATOM   1007  CG2 VAL A 104      18.394  -6.283   0.428  1.00 48.17     0.012 C
ATOM   1008  H   VAL A 104      18.627  -7.985   2.908  1.00 36.00     0.163 HD
ATOM   1009  N   ARG A 105      21.265  -5.099   3.241  1.00 36.50    -0.346 N
ATOM   1010  CA  ARG A 105      21.269  -3.832   3.963  1.00 38.11     0.176 C
ATOM   1011  C   ARG A 105      21.151  -2.716   2.914  1.00 37.21     0.241 C
ATOM   1012  O   ARG A 105      22.080  -2.490   2.136  1.00 41.86    -0.271 OA
ATOM   1013  CB  ARG A 105      22.590  -3.704   4.749  1.00 41.37     0.036 C
ATOM   1014  CG  ARG A 105      22.643  -2.447   5.634  1.00 39.36     0.023 C
ATOM   1015  CD  ARG A 105      23.879  -2.410   6.540  1.00 40.87     0.138 C
ATOM   1016  NE  ARG A 105      23.878  -1.211   7.390  1.00 39.45    -0.227 N
ATOM   1017  CZ  ARG A 105      23.212  -1.069   8.549  1.00 39.74     0.665 C
ATOM   1018  NH1 ARG A 105      22.421  -2.038   9.029  1.00 40.89    -0.235 N
ATOM   1019  NH2 ARG A 105      23.342   0.068   9.242  1.00 39.82    -0.235 N
ATOM   1020  H   ARG A 105      22.144  -5.418   2.861  1.00 36.50     0.163 HD
ATOM   1021  HE  ARG A 105      24.429  -0.435   7.052  1.00 39.45     0.177 HD
ATOM   1022 HH12 ARG A 105      21.920  -1.922   9.900  1.00 40.89     0.174 HD
ATOM   1023 HH11 ARG A 105      22.329  -2.923   8.536  1.00 40.89     0.174 HD
ATOM   1024 HH22 ARG A 105      22.889   0.168  10.144  1.00 39.82     0.174 HD
ATOM   1025 HH21 ARG A 105      23.937   0.811   8.904  1.00 39.82     0.174 HD
ATOM   1026  N   ILE A 106      19.991  -2.043   2.882  1.00 38.28    -0.346 N
ATOM   1027  CA  ILE A 106      19.675  -0.978   1.929  1.00 37.00     0.180 C
ATOM   1028  C   ILE A 106      20.313   0.354   2.354  1.00 35.64     0.241 C
ATOM   1029  O   ILE A 106      20.554   0.609   3.534  1.00 35.91    -0.271 OA
ATOM   1030  CB  ILE A 106      18.135  -0.805   1.804  1.00 36.11     0.013 C
ATOM   1031  CG1 ILE A 106      17.403  -0.651   3.160  1.00 36.27     0.002 C
ATOM   1032  CG2 ILE A 106      17.543  -1.937   0.943  1.00 37.28     0.012 C
ATOM   1033  CD1 ILE A 106      15.980  -0.104   3.034  1.00 35.30     0.005 C
ATOM   1034  H   ILE A 106      19.287  -2.272   3.570  1.00 38.28     0.163 HD
ATOM   1035  N   GLN A 107      20.563   1.209   1.356  1.00 39.80    -0.346 N
ATOM   1036  CA  GLN A 107      21.093   2.560   1.506  1.00 40.11     0.177 C
ATOM   1037  C   GLN A 107      19.962   3.536   1.892  1.00 40.50     0.243 C
ATOM   1038  O   GLN A 107      18.789   3.229   1.668  1.00 36.06    -0.271 OA
ATOM   1039  CB  GLN A 107      21.663   2.978   0.126  1.00 44.52     0.044 C
ATOM   1040  CG  GLN A 107      22.870   2.139  -0.347  1.00 45.35     0.105 C
ATOM   1041  CD  GLN A 107      24.064   2.180   0.613  1.00 48.52     0.215 C
ATOM   1042  OE1 GLN A 107      24.376   3.221   1.187  1.00 55.69    -0.274 OA
ATOM   1043  NE2 GLN A 107      24.731   1.040   0.801  1.00 49.29    -0.370 N
ATOM   1044  H   GLN A 107      20.326   0.918   0.418  1.00 39.80     0.163 HD
ATOM   1045 2HE2 GLN A 107      25.522   1.025   1.429  1.00 49.29     0.159 HD
ATOM   1046 1HE2 GLN A 107      24.445   0.199   0.322  1.00 49.29     0.159 HD
ATOM   1047  N   PRO A 108      20.284   4.733   2.433  1.00 37.12    -0.337 N
ATOM   1048  CA  PRO A 108      19.289   5.783   2.673  1.00 39.00     0.179 C
ATOM   1049  C   PRO A 108      18.793   6.379   1.344  1.00 35.22     0.241 C
ATOM   1050  O   PRO A 108      19.575   6.616   0.423  1.00 32.72    -0.271 OA
ATOM   1051  CB  PRO A 108      20.004   6.818   3.546  1.00 39.51     0.037 C
ATOM   1052  CG  PRO A 108      21.482   6.638   3.241  1.00 43.67     0.022 C
ATOM   1053  CD  PRO A 108      21.624   5.171   2.832  1.00 41.68     0.127 C
ATOM   1054  N   GLY A 109      17.473   6.567   1.258  1.00 35.74    -0.351 N
ATOM   1055  CA  GLY A 109      16.737   6.961   0.066  1.00 36.46     0.225 C
ATOM   1056  C   GLY A 109      16.048   5.794  -0.652  1.00 40.34     0.236 C
ATOM   1057  O   GLY A 109      15.236   6.041  -1.543  1.00 38.73    -0.272 OA
ATOM   1058  H   GLY A 109      16.912   6.371   2.079  1.00 35.74     0.163 HD
ATOM   1059  N   GLN A 110      16.347   4.537  -0.276  1.00 40.79    -0.346 N
ATOM   1060  CA  GLN A 110      15.779   3.336  -0.887  1.00 40.39     0.177 C
ATOM   1061  C   GLN A 110      14.453   2.969  -0.210  1.00 35.39     0.241 C
ATOM   1062  O   GLN A 110      14.326   2.999   1.015  1.00 38.25    -0.271 OA
ATOM   1063  CB  GLN A 110      16.754   2.151  -0.707  1.00 44.01     0.044 C
ATOM   1064  CG  GLN A 110      18.076   2.317  -1.491  1.00 49.74     0.105 C
ATOM   1065  CD  GLN A 110      17.965   2.245  -3.022  1.00 55.97     0.215 C
ATOM   1066  OE1 GLN A 110      18.879   2.680  -3.717  1.00 58.76    -0.274 OA
ATOM   1067  NE2 GLN A 110      16.864   1.723  -3.569  1.00 54.53    -0.370 N
ATOM   1068  H   GLN A 110      17.019   4.406   0.467  1.00 40.79     0.163 HD
ATOM   1069 2HE2 GLN A 110      16.782   1.679  -4.574  1.00 54.53     0.159 HD
ATOM   1070 1HE2 GLN A 110      16.126   1.361  -2.982  1.00 54.53     0.159 HD
ATOM   1071  N   THR A 111      13.476   2.615  -1.053  1.00 33.16    -0.344 N
ATOM   1072  CA  THR A 111      12.112   2.241  -0.699  1.00 32.92     0.205 C
ATOM   1073  C   THR A 111      11.981   0.726  -0.474  1.00 31.98     0.243 C
ATOM   1074  O   THR A 111      12.806  -0.063  -0.936  1.00 31.39    -0.271 OA
ATOM   1075  CB  THR A 111      11.188   2.670  -1.859  1.00 32.33     0.146 C
ATOM   1076  OG1 THR A 111      11.637   2.099  -3.074  1.00 33.06    -0.393 OA
ATOM   1077  CG2 THR A 111      11.056   4.194  -1.988  1.00 31.92     0.042 C
ATOM   1078  H   THR A 111      13.680   2.608  -2.042  1.00 33.16     0.163 HD
ATOM   1079  HG1 THR A 111      11.085   2.412  -3.784  1.00 33.06     0.210 HD
ATOM   1080  N   PHE A 112      10.923   0.347   0.258  1.00 34.24    -0.346 N
ATOM   1081  CA  PHE A 112      10.546  -1.021   0.599  1.00 31.78     0.180 C
ATOM   1082  C   PHE A 112       9.114  -1.065   1.149  1.00 32.04     0.241 C
ATOM   1083  O   PHE A 112       8.627  -0.085   1.712  1.00 31.87    -0.271 OA
ATOM   1084  CB  PHE A 112      11.571  -1.645   1.568  1.00 29.99     0.073 C
ATOM   1085  CG  PHE A 112      11.706  -0.969   2.921  1.00 31.01    -0.056 A
ATOM   1086  CD1 PHE A 112      10.949  -1.432   4.014  1.00 30.99     0.007 A
ATOM   1087  CD2 PHE A 112      12.608   0.100   3.100  1.00 31.95     0.007 A
ATOM   1088  CE1 PHE A 112      11.160  -0.894   5.296  1.00 33.14     0.001 A
ATOM   1089  CE2 PHE A 112      12.799   0.655   4.380  1.00 32.08     0.001 A
ATOM   1090  CZ  PHE A 112      12.102   0.130   5.482  1.00 33.36     0.000 A
ATOM   1091  H   PHE A 112      10.312   1.073   0.612  1.00 34.24     0.163 HD
ATOM   1092  N   SER A 113       8.456  -2.224   1.016  1.00 31.00    -0.344 N
ATOM   1093  CA  SER A 113       7.123  -2.501   1.544  1.00 31.90     0.200 C
ATOM   1094  C   SER A 113       7.241  -3.124   2.934  1.00 30.58     0.243 C
ATOM   1095  O   SER A 113       7.893  -4.152   3.083  1.00 29.53    -0.271 OA
ATOM   1096  CB  SER A 113       6.462  -3.549   0.636  1.00 31.57     0.199 C
ATOM   1097  OG  SER A 113       5.973  -2.885  -0.499  1.00 30.75    -0.398 OA
ATOM   1098  H   SER A 113       8.939  -2.999   0.578  1.00 31.00     0.163 HD
ATOM   1099  HG  SER A 113       6.652  -2.313  -0.830  1.00 30.75     0.209 HD
ATOM   1100  N   VAL A 114       6.579  -2.520   3.930  1.00 28.96    -0.346 N
ATOM   1101  CA  VAL A 114       6.426  -3.050   5.283  1.00 26.59     0.180 C
ATOM   1102  C   VAL A 114       5.071  -3.766   5.345  1.00 27.00     0.241 C
ATOM   1103  O   VAL A 114       4.043  -3.144   5.079  1.00 27.28    -0.271 OA
ATOM   1104  CB  VAL A 114       6.411  -1.869   6.294  1.00 27.77     0.009 C
ATOM   1105  CG1 VAL A 114       6.090  -2.313   7.736  1.00 28.98     0.012 C
ATOM   1106  CG2 VAL A 114       7.741  -1.100   6.293  1.00 30.13     0.012 C
ATOM   1107  H   VAL A 114       6.052  -1.684   3.710  1.00 28.96     0.163 HD
ATOM   1108  N   LEU A 115       5.076  -5.041   5.763  1.00 27.64    -0.346 N
ATOM   1109  CA  LEU A 115       3.883  -5.780   6.169  1.00 25.93     0.177 C
ATOM   1110  C   LEU A 115       3.803  -5.676   7.700  1.00 26.67     0.241 C
ATOM   1111  O   LEU A 115       4.601  -6.291   8.410  1.00 25.69    -0.271 OA
ATOM   1112  CB  LEU A 115       4.044  -7.259   5.741  1.00 25.65     0.038 C
ATOM   1113  CG  LEU A 115       2.849  -8.182   6.071  1.00 26.02    -0.020 C
ATOM   1114  CD1 LEU A 115       1.590  -7.802   5.277  1.00 26.97     0.009 C
ATOM   1115  CD2 LEU A 115       3.226  -9.651   5.844  1.00 25.68     0.009 C
ATOM   1116  H   LEU A 115       5.969  -5.471   5.965  1.00 27.64     0.163 HD
ATOM   1117  N   ALA A 116       2.834  -4.891   8.197  1.00 26.24    -0.346 N
ATOM   1118  CA  ALA A 116       2.559  -4.691   9.617  1.00 27.98     0.172 C
ATOM   1119  C   ALA A 116       1.726  -5.868  10.140  1.00 29.49     0.240 C
ATOM   1120  O   ALA A 116       0.700  -6.216   9.557  1.00 30.82    -0.271 OA
ATOM   1121  CB  ALA A 116       1.742  -3.401   9.780  1.00 29.30     0.042 C
ATOM   1122  H   ALA A 116       2.201  -4.449   7.543  1.00 26.24     0.163 HD
ATOM   1123  N   CYS A 117       2.204  -6.488  11.228  1.00 28.34    -0.345 N
ATOM   1124  CA  CYS A 117       1.674  -7.706  11.840  1.00 30.71     0.185 C
ATOM   1125  C   CYS A 117       1.504  -7.507  13.349  1.00 32.57     0.241 C
ATOM   1126  O   CYS A 117       2.230  -6.723  13.957  1.00 31.48    -0.271 OA
ATOM   1127  CB  CYS A 117       2.619  -8.892  11.557  1.00 32.87     0.105 C
ATOM   1128  SG  CYS A 117       2.787  -9.194   9.782  1.00 34.06    -0.180 SA
ATOM   1129  H   CYS A 117       3.063  -6.133  11.630  1.00 28.34     0.163 HD
ATOM   1130  HG  CYS A 117       3.298  -7.994   9.486  1.00 34.06     0.101 HD
ATOM   1131  N   TYR A 118       0.563  -8.247  13.952  1.00 37.46    -0.346 N
ATOM   1132  CA  TYR A 118       0.279  -8.266  15.387  1.00 37.97     0.180 C
ATOM   1133  C   TYR A 118      -0.017  -9.707  15.797  1.00 40.15     0.241 C
ATOM   1134  O   TYR A 118      -0.963 -10.301  15.282  1.00 37.22    -0.271 OA
ATOM   1135  CB  TYR A 118      -0.876  -7.302  15.731  1.00 38.78     0.073 C
ATOM   1136  CG  TYR A 118      -0.562  -5.839  15.480  1.00 40.86    -0.056 A
ATOM   1137  CD1 TYR A 118       0.135  -5.090  16.447  1.00 43.36     0.010 A
ATOM   1138  CD2 TYR A 118      -0.927  -5.239  14.257  1.00 43.19     0.010 A
ATOM   1139  CE1 TYR A 118       0.483  -3.753  16.182  1.00 40.17     0.037 A
ATOM   1140  CE2 TYR A 118      -0.564  -3.907  13.986  1.00 44.32     0.037 A
ATOM   1141  CZ  TYR A 118       0.151  -3.165  14.945  1.00 39.94     0.065 A
ATOM   1142  OH  TYR A 118       0.530  -1.885  14.666  1.00 39.02    -0.361 OA
ATOM   1143  H   TYR A 118       0.007  -8.868  13.377  1.00 37.46     0.163 HD
ATOM   1144  HH  TYR A 118       0.241  -1.595  13.814  1.00 39.02     0.217 HD
ATOM   1145  N   ASN A 119       0.808 -10.274  16.697  1.00 40.75    -0.346 N
ATOM   1146  CA  ASN A 119       0.711 -11.647  17.222  1.00 43.28     0.185 C
ATOM   1147  C   ASN A 119       1.044 -12.703  16.147  1.00 38.59     0.241 C
ATOM   1148  O   ASN A 119       0.486 -13.800  16.153  1.00 39.70    -0.271 OA
ATOM   1149  CB  ASN A 119      -0.628 -11.929  17.961  1.00 47.05     0.137 C
ATOM   1150  CG  ASN A 119      -0.863 -11.016  19.168  1.00 47.31     0.217 C
ATOM   1151  OD1 ASN A 119      -1.285  -9.872  19.016  1.00 50.95    -0.274 OA
ATOM   1152  ND2 ASN A 119      -0.597 -11.523  20.373  1.00 52.82    -0.370 N
ATOM   1153  H   ASN A 119       1.562  -9.707  17.057  1.00 40.75     0.163 HD
ATOM   1154 2HD2 ASN A 119      -0.744 -10.955  21.195  1.00 52.82     0.159 HD
ATOM   1155 1HD2 ASN A 119      -0.250 -12.469  20.461  1.00 52.82     0.159 HD
ATOM   1156  N   GLY A 120       1.916 -12.344  15.191  1.00 34.93    -0.351 N
ATOM   1157  CA  GLY A 120       2.282 -13.131  14.018  1.00 34.06     0.225 C
ATOM   1158  C   GLY A 120       1.296 -13.042  12.845  1.00 34.03     0.236 C
ATOM   1159  O   GLY A 120       1.602 -13.569  11.778  1.00 32.81    -0.272 OA
ATOM   1160  H   GLY A 120       2.329 -11.422  15.252  1.00 34.93     0.163 HD
ATOM   1161  N   SER A 121       0.126 -12.405  13.034  1.00 36.94    -0.344 N
ATOM   1162  CA  SER A 121      -0.944 -12.311  12.044  1.00 39.24     0.200 C
ATOM   1163  C   SER A 121      -0.862 -10.951  11.316  1.00 40.18     0.245 C
ATOM   1164  O   SER A 121      -0.946  -9.921  11.988  1.00 36.15    -0.271 OA
ATOM   1165  CB  SER A 121      -2.298 -12.364  12.783  1.00 43.87     0.199 C
ATOM   1166  OG  SER A 121      -2.550 -13.676  13.240  1.00 54.08    -0.398 OA
ATOM   1167  H   SER A 121      -0.045 -11.979  13.934  1.00 36.94     0.163 HD
ATOM   1168  HG  SER A 121      -1.875 -13.912  13.859  1.00 54.08     0.209 HD
ATOM   1169  N   PRO A 122      -0.729 -10.921   9.967  1.00 40.60    -0.337 N
ATOM   1170  CA  PRO A 122      -0.832  -9.718   9.116  1.00 40.89     0.179 C
ATOM   1171  C   PRO A 122      -2.074  -8.839   9.357  1.00 42.12     0.241 C
ATOM   1172  O   PRO A 122      -3.142  -9.344   9.705  1.00 48.92    -0.271 OA
ATOM   1173  CB  PRO A 122      -0.841 -10.251   7.676  1.00 43.96     0.037 C
ATOM   1174  CG  PRO A 122      -0.112 -11.579   7.750  1.00 46.41     0.022 C
ATOM   1175  CD  PRO A 122      -0.383 -12.092   9.157  1.00 43.67     0.127 C
ATOM   1176  N   SER A 123      -1.915  -7.524   9.143  1.00 36.54    -0.344 N
ATOM   1177  CA  SER A 123      -2.930  -6.489   9.360  1.00 36.37     0.200 C
ATOM   1178  C   SER A 123      -2.992  -5.427   8.245  1.00 34.15     0.242 C
ATOM   1179  O   SER A 123      -3.897  -4.593   8.263  1.00 36.32    -0.271 OA
ATOM   1180  CB  SER A 123      -2.797  -5.919  10.788  1.00 35.96     0.199 C
ATOM   1181  OG  SER A 123      -1.692  -5.042  10.897  1.00 43.98    -0.398 OA
ATOM   1182  H   SER A 123      -0.991  -7.201   8.891  1.00 36.54     0.163 HD
ATOM   1183  HG  SER A 123      -0.909  -5.512  10.648  1.00 43.98     0.209 HD
ATOM   1184  N   GLY A 124      -2.066  -5.468   7.274  1.00 31.94    -0.350 N
ATOM   1185  CA  GLY A 124      -1.988  -4.539   6.150  1.00 30.97     0.225 C
ATOM   1186  C   GLY A 124      -0.542  -4.294   5.714  1.00 32.02     0.236 C
ATOM   1187  O   GLY A 124       0.394  -4.532   6.478  1.00 34.24    -0.272 OA
ATOM   1188  H   GLY A 124      -1.349  -6.177   7.326  1.00 31.94     0.163 HD
ATOM   1189  N   VAL A 125      -0.380  -3.791   4.480  1.00 30.33    -0.346 N
ATOM   1190  CA  VAL A 125       0.899  -3.512   3.827  1.00 29.78     0.180 C
ATOM   1191  C   VAL A 125       0.911  -2.070   3.294  1.00 28.25     0.241 C
ATOM   1192  O   VAL A 125      -0.108  -1.570   2.815  1.00 29.02    -0.271 OA
ATOM   1193  CB  VAL A 125       1.220  -4.607   2.768  1.00 28.59     0.009 C
ATOM   1194  CG1 VAL A 125       0.258  -4.603   1.565  1.00 28.74     0.012 C
ATOM   1195  CG2 VAL A 125       2.683  -4.556   2.287  1.00 28.73     0.012 C
ATOM   1196  H   VAL A 125      -1.208  -3.591   3.937  1.00 30.33     0.163 HD
ATOM   1197  N   TYR A 126       2.078  -1.415   3.379  1.00 29.88    -0.346 N
ATOM   1198  CA  TYR A 126       2.326  -0.047   2.930  1.00 30.19     0.180 C
ATOM   1199  C   TYR A 126       3.767   0.115   2.441  1.00 32.77     0.241 C
ATOM   1200  O   TYR A 126       4.692  -0.431   3.042  1.00 30.82    -0.271 OA
ATOM   1201  CB  TYR A 126       1.901   0.978   4.007  1.00 30.64     0.073 C
ATOM   1202  CG  TYR A 126       2.563   0.828   5.370  1.00 33.28    -0.056 A
ATOM   1203  CD1 TYR A 126       3.831   1.394   5.623  1.00 34.00     0.010 A
ATOM   1204  CD2 TYR A 126       1.903   0.116   6.393  1.00 34.82     0.010 A
ATOM   1205  CE1 TYR A 126       4.439   1.235   6.884  1.00 33.77     0.037 A
ATOM   1206  CE2 TYR A 126       2.502  -0.029   7.658  1.00 37.09     0.037 A
ATOM   1207  CZ  TYR A 126       3.773   0.524   7.902  1.00 36.33     0.065 A
ATOM   1208  OH  TYR A 126       4.359   0.371   9.123  1.00 44.14    -0.361 OA
ATOM   1209  H   TYR A 126       2.863  -1.900   3.795  1.00 29.88     0.163 HD
ATOM   1210  HH  TYR A 126       3.836  -0.130   9.733  1.00 44.14     0.217 HD
ATOM   1211  N   GLN A 127       3.951   0.908   1.372  1.00 33.82    -0.346 N
ATOM   1212  CA  GLN A 127       5.254   1.306   0.845  1.00 35.99     0.177 C
ATOM   1213  C   GLN A 127       5.800   2.461   1.702  1.00 36.96     0.241 C
ATOM   1214  O   GLN A 127       5.074   3.395   2.046  1.00 43.50    -0.271 OA
ATOM   1215  CB  GLN A 127       5.075   1.763  -0.621  1.00 37.72     0.044 C
ATOM   1216  CG  GLN A 127       6.372   2.098  -1.398  1.00 37.11     0.105 C
ATOM   1217  CD  GLN A 127       7.189   0.875  -1.843  1.00 36.51     0.215 C
ATOM   1218  OE1 GLN A 127       7.016  -0.235  -1.344  1.00 37.88    -0.274 OA
ATOM   1219  NE2 GLN A 127       8.084   1.074  -2.811  1.00 37.23    -0.370 N
ATOM   1220  H   GLN A 127       3.140   1.328   0.943  1.00 33.82     0.163 HD
ATOM   1221 2HE2 GLN A 127       8.646   0.301  -3.140  1.00 37.23     0.159 HD
ATOM   1222 1HE2 GLN A 127       8.203   1.993  -3.214  1.00 37.23     0.159 HD
ATOM   1223  N   CYS A 128       7.087   2.358   2.046  1.00 37.96    -0.345 N
ATOM   1224  CA  CYS A 128       7.837   3.231   2.942  1.00 39.04     0.185 C
ATOM   1225  C   CYS A 128       9.238   3.462   2.347  1.00 33.89     0.241 C
ATOM   1226  O   CYS A 128       9.583   2.854   1.331  1.00 36.92    -0.271 OA
ATOM   1227  CB  CYS A 128       7.815   2.583   4.348  1.00 41.68     0.105 C
ATOM   1228  SG  CYS A 128       8.181   3.773   5.666  1.00 59.83    -0.180 SA
ATOM   1229  H   CYS A 128       7.598   1.556   1.700  1.00 37.96     0.163 HD
ATOM   1230  HG  CYS A 128       9.451   3.992   5.312  1.00 59.83     0.101 HD
ATOM   1231  N   ALA A 129      10.051   4.325   2.974  1.00 33.70    -0.346 N
ATOM   1232  CA  ALA A 129      11.449   4.549   2.612  1.00 31.32     0.172 C
ATOM   1233  C   ALA A 129      12.338   4.709   3.838  1.00 29.60     0.240 C
ATOM   1234  O   ALA A 129      11.915   5.261   4.855  1.00 31.26    -0.271 OA
ATOM   1235  CB  ALA A 129      11.592   5.719   1.625  1.00 32.60     0.042 C
ATOM   1236  H   ALA A 129       9.697   4.839   3.769  1.00 33.70     0.163 HD
ATOM   1237  N   MET A 130      13.600   4.268   3.692  1.00 31.57    -0.346 N
ATOM   1238  CA  MET A 130      14.697   4.541   4.609  1.00 31.90     0.177 C
ATOM   1239  C   MET A 130      15.083   6.011   4.421  1.00 31.81     0.241 C
ATOM   1240  O   MET A 130      15.549   6.405   3.353  1.00 34.43    -0.271 OA
ATOM   1241  CB  MET A 130      15.881   3.610   4.263  1.00 35.37     0.045 C
ATOM   1242  CG  MET A 130      17.046   3.659   5.272  1.00 37.32     0.076 C
ATOM   1243  SD  MET A 130      16.637   3.297   7.005  1.00 37.62    -0.173 SA
ATOM   1244  CE  MET A 130      15.918   1.641   6.864  1.00 38.11     0.089 C
ATOM   1245  H   MET A 130      13.846   3.834   2.811  1.00 31.57     0.163 HD
ATOM   1246  N   ARG A 131      14.846   6.820   5.461  1.00 29.46    -0.346 N
ATOM   1247  CA  ARG A 131      15.095   8.256   5.462  1.00 30.75     0.176 C
ATOM   1248  C   ARG A 131      16.612   8.522   5.608  1.00 32.62     0.243 C
ATOM   1249  O   ARG A 131      17.300   7.697   6.207  1.00 30.30    -0.271 OA
ATOM   1250  CB  ARG A 131      14.369   8.876   6.675  1.00 30.10     0.036 C
ATOM   1251  CG  ARG A 131      12.836   8.678   6.729  1.00 32.50     0.023 C
ATOM   1252  CD  ARG A 131      12.056   9.131   5.490  1.00 31.94     0.138 C
ATOM   1253  NE  ARG A 131      12.364  10.519   5.137  1.00 34.67    -0.227 N
ATOM   1254  CZ  ARG A 131      11.950  11.148   4.030  1.00 32.84     0.665 C
ATOM   1255  NH1 ARG A 131      11.102  10.569   3.169  1.00 32.62    -0.235 N
ATOM   1256  NH2 ARG A 131      12.405  12.381   3.786  1.00 30.92    -0.235 N
ATOM   1257  H   ARG A 131      14.467   6.417   6.309  1.00 29.46     0.163 HD
ATOM   1258  HE  ARG A 131      12.955  11.040   5.783  1.00 34.67     0.177 HD
ATOM   1259 HH12 ARG A 131      10.809  11.069   2.332  1.00 32.62     0.174 HD
ATOM   1260 HH11 ARG A 131      10.711   9.650   3.353  1.00 32.62     0.174 HD
ATOM   1261 HH22 ARG A 131      12.196  12.813   2.891  1.00 30.92     0.174 HD
ATOM   1262 HH21 ARG A 131      13.052  12.828   4.424  1.00 30.92     0.174 HD
ATOM   1263  N   PRO A 132      17.157   9.640   5.077  1.00 35.96    -0.337 N
ATOM   1264  CA  PRO A 132      18.553  10.088   5.269  1.00 33.99     0.179 C
ATOM   1265  C   PRO A 132      19.108  10.100   6.710  1.00 35.11     0.241 C
ATOM   1266  O   PRO A 132      20.295   9.832   6.891  1.00 36.11    -0.271 OA
ATOM   1267  CB  PRO A 132      18.592  11.493   4.665  1.00 32.83     0.037 C
ATOM   1268  CG  PRO A 132      17.557  11.431   3.560  1.00 33.41     0.022 C
ATOM   1269  CD  PRO A 132      16.477  10.505   4.111  1.00 32.64     0.127 C
ATOM   1270  N   ASN A 133      18.263  10.362   7.725  1.00 31.67    -0.346 N
ATOM   1271  CA  ASN A 133      18.618  10.298   9.152  1.00 33.91     0.185 C
ATOM   1272  C   ASN A 133      18.502   8.872   9.748  1.00 33.30     0.241 C
ATOM   1273  O   ASN A 133      18.797   8.681  10.927  1.00 29.79    -0.271 OA
ATOM   1274  CB  ASN A 133      17.743  11.294   9.963  1.00 33.41     0.137 C
ATOM   1275  CG  ASN A 133      16.225  11.062   9.968  1.00 32.53     0.217 C
ATOM   1276  OD1 ASN A 133      15.689  10.262   9.206  1.00 28.86    -0.274 OA
ATOM   1277  ND2 ASN A 133      15.521  11.754  10.863  1.00 31.42    -0.370 N
ATOM   1278  H   ASN A 133      17.300  10.573   7.503  1.00 31.67     0.163 HD
ATOM   1279 2HD2 ASN A 133      14.520  11.634  10.915  1.00 31.42     0.159 HD
ATOM   1280 1HD2 ASN A 133      15.985  12.432  11.456  1.00 31.42     0.159 HD
ATOM   1281  N   PHE A 134      18.071   7.893   8.932  1.00 36.46    -0.346 N
ATOM   1282  CA  PHE A 134      18.024   6.445   9.160  1.00 37.94     0.180 C
ATOM   1283  C   PHE A 134      16.769   5.928   9.881  1.00 39.50     0.241 C
ATOM   1284  O   PHE A 134      16.709   4.755  10.250  1.00 40.10    -0.271 OA
ATOM   1285  CB  PHE A 134      19.359   5.857   9.647  1.00 36.97     0.073 C
ATOM   1286  CG  PHE A 134      20.460   5.822   8.604  1.00 38.05    -0.056 A
ATOM   1287  CD1 PHE A 134      20.487   4.786   7.647  1.00 39.14     0.007 A
ATOM   1288  CD2 PHE A 134      21.465   6.810   8.595  1.00 42.27     0.007 A
ATOM   1289  CE1 PHE A 134      21.523   4.729   6.695  1.00 44.73     0.001 A
ATOM   1290  CE2 PHE A 134      22.498   6.756   7.639  1.00 40.47     0.001 A
ATOM   1291  CZ  PHE A 134      22.531   5.712   6.694  1.00 40.70     0.000 A
ATOM   1292  H   PHE A 134      17.842   8.173   7.988  1.00 36.46     0.163 HD
ATOM   1293  N   THR A 135      15.753   6.788  10.046  1.00 38.02    -0.344 N
ATOM   1294  CA  THR A 135      14.427   6.433  10.554  1.00 37.67     0.205 C
ATOM   1295  C   THR A 135      13.524   5.970   9.390  1.00 35.55     0.243 C
ATOM   1296  O   THR A 135      13.940   5.984   8.230  1.00 34.34    -0.271 OA
ATOM   1297  CB  THR A 135      13.809   7.679  11.252  1.00 37.83     0.146 C
ATOM   1298  OG1 THR A 135      13.477   8.722  10.352  1.00 37.14    -0.393 OA
ATOM   1299  CG2 THR A 135      14.688   8.244  12.377  1.00 38.24     0.042 C
ATOM   1300  H   THR A 135      15.880   7.731   9.709  1.00 38.02     0.163 HD
ATOM   1301  HG1 THR A 135      14.273   9.078   9.981  1.00 37.14     0.210 HD
ATOM   1302  N   ILE A 136      12.277   5.585   9.710  1.00 34.28    -0.346 N
ATOM   1303  CA  ILE A 136      11.169   5.378   8.776  1.00 34.60     0.180 C
ATOM   1304  C   ILE A 136       9.887   6.008   9.336  1.00 32.53     0.241 C
ATOM   1305  O   ILE A 136       9.717   6.111  10.551  1.00 32.81    -0.271 OA
ATOM   1306  CB  ILE A 136      11.024   3.905   8.300  1.00 38.06     0.013 C
ATOM   1307  CG1 ILE A 136      10.430   2.933   9.344  1.00 39.33     0.002 C
ATOM   1308  CG2 ILE A 136      12.319   3.359   7.685  1.00 39.88     0.012 C
ATOM   1309  CD1 ILE A 136      10.017   1.578   8.752  1.00 39.79     0.005 C
ATOM   1310  H   ILE A 136      12.038   5.551  10.693  1.00 34.28     0.163 HD
ATOM   1311  N   LYS A 137       8.985   6.421   8.434  1.00 34.68    -0.346 N
ATOM   1312  CA  LYS A 137       7.695   7.035   8.743  1.00 36.24     0.176 C
ATOM   1313  C   LYS A 137       6.593   6.010   8.435  1.00 34.81     0.240 C
ATOM   1314  O   LYS A 137       5.903   6.107   7.419  1.00 33.42    -0.271 OA
ATOM   1315  CB  LYS A 137       7.536   8.301   7.872  1.00 42.44     0.035 C
ATOM   1316  CG  LYS A 137       8.552   9.402   8.216  1.00 44.07     0.004 C
ATOM   1317  CD  LYS A 137       8.410  10.627   7.304  1.00 49.66     0.027 C
ATOM   1318  CE  LYS A 137       9.518  11.655   7.551  1.00 52.87     0.229 C
ATOM   1319  NZ  LYS A 137       9.418  12.789   6.619  1.00 54.05    -0.079 N
ATOM   1320  H   LYS A 137       9.196   6.284   7.455  1.00 34.68     0.163 HD
ATOM   1321  HZ1 LYS A 137       8.571  13.311   6.791  1.00 54.05     0.274 HD
ATOM   1322  HZ2 LYS A 137      10.229  13.382   6.770  1.00 54.05     0.274 HD
ATOM   1323  HZ3 LYS A 137       9.430  12.452   5.667  1.00 54.05     0.274 HD
ATOM   1324  N   GLY A 138       6.458   5.006   9.313  1.00 34.12    -0.351 N
ATOM   1325  CA  GLY A 138       5.502   3.911   9.187  1.00 34.73     0.225 C
ATOM   1326  C   GLY A 138       4.273   4.085  10.082  1.00 34.53     0.236 C
ATOM   1327  O   GLY A 138       3.909   5.198  10.463  1.00 37.00    -0.272 OA
ATOM   1328  H   GLY A 138       7.051   5.003  10.132  1.00 34.12     0.163 HD
ATOM   1329  N   SER A 139       3.638   2.951  10.401  1.00 33.85    -0.344 N
ATOM   1330  CA  SER A 139       2.468   2.810  11.259  1.00 36.36     0.200 C
ATOM   1331  C   SER A 139       2.673   1.556  12.115  1.00 36.26     0.243 C
ATOM   1332  O   SER A 139       2.531   0.436  11.620  1.00 39.85    -0.271 OA
ATOM   1333  CB  SER A 139       1.187   2.824  10.399  1.00 36.68     0.199 C
ATOM   1334  OG  SER A 139       0.026   2.654  11.187  1.00 38.02    -0.398 OA
ATOM   1335  H   SER A 139       4.014   2.090  10.025  1.00 33.85     0.163 HD
ATOM   1336  HG  SER A 139       0.049   1.793  11.577  1.00 38.02     0.209 HD
ATOM   1337  N   PHE A 140       3.056   1.762  13.384  1.00 37.49    -0.346 N
ATOM   1338  CA  PHE A 140       3.529   0.740  14.312  1.00 38.56     0.180 C
ATOM   1339  C   PHE A 140       3.006   1.053  15.722  1.00 39.07     0.241 C
ATOM   1340  O   PHE A 140       3.384   2.072  16.299  1.00 41.58    -0.271 OA
ATOM   1341  CB  PHE A 140       5.071   0.698  14.267  1.00 37.63     0.073 C
ATOM   1342  CG  PHE A 140       5.728   0.227  12.977  1.00 36.48    -0.056 A
ATOM   1343  CD1 PHE A 140       5.856  -1.148  12.686  1.00 39.45     0.007 A
ATOM   1344  CD2 PHE A 140       6.290   1.173  12.097  1.00 38.54     0.007 A
ATOM   1345  CE1 PHE A 140       6.579  -1.568  11.553  1.00 37.66     0.001 A
ATOM   1346  CE2 PHE A 140       7.035   0.755  10.980  1.00 37.04     0.001 A
ATOM   1347  CZ  PHE A 140       7.194  -0.618  10.717  1.00 36.39     0.000 A
ATOM   1348  H   PHE A 140       3.128   2.717  13.705  1.00 37.49     0.163 HD
ATOM   1349  N   LEU A 141       2.160   0.170  16.277  1.00 44.97    -0.346 N
ATOM   1350  CA  LEU A 141       1.636   0.225  17.648  1.00 43.53     0.177 C
ATOM   1351  C   LEU A 141       2.414  -0.777  18.532  1.00 43.44     0.241 C
ATOM   1352  O   LEU A 141       3.465  -1.282  18.138  1.00 40.99    -0.271 OA
ATOM   1353  CB  LEU A 141       0.131  -0.158  17.620  1.00 44.79     0.038 C
ATOM   1354  CG  LEU A 141      -0.760   0.691  16.685  1.00 47.31    -0.020 C
ATOM   1355  CD1 LEU A 141      -2.171   0.089  16.592  1.00 46.44     0.009 C
ATOM   1356  CD2 LEU A 141      -0.827   2.163  17.123  1.00 48.18     0.009 C
ATOM   1357  H   LEU A 141       1.884  -0.631  15.725  1.00 44.97     0.163 HD
ATOM   1358  N   ASN A 142       1.912  -1.076  19.742  1.00 47.30    -0.346 N
ATOM   1359  CA  ASN A 142       2.479  -2.088  20.642  1.00 46.42     0.185 C
ATOM   1360  C   ASN A 142       2.182  -3.499  20.103  1.00 41.58     0.241 C
ATOM   1361  O   ASN A 142       1.056  -3.789  19.698  1.00 39.86    -0.271 OA
ATOM   1362  CB  ASN A 142       1.876  -1.949  22.057  1.00 50.77     0.137 C
ATOM   1363  CG  ASN A 142       2.247  -0.623  22.728  1.00 59.66     0.217 C
ATOM   1364  OD1 ASN A 142       1.525   0.363  22.600  1.00 66.65    -0.274 OA
ATOM   1365  ND2 ASN A 142       3.368  -0.594  23.451  1.00 62.03    -0.370 N
ATOM   1366  H   ASN A 142       1.060  -0.621  20.037  1.00 47.30     0.163 HD
ATOM   1367 2HD2 ASN A 142       3.640   0.265  23.908  1.00 62.03     0.159 HD
ATOM   1368 1HD2 ASN A 142       3.938  -1.422  23.543  1.00 62.03     0.159 HD
ATOM   1369  N   GLY A 143       3.213  -4.357  20.082  1.00 40.00    -0.351 N
ATOM   1370  CA  GLY A 143       3.172  -5.708  19.522  1.00 38.72     0.225 C
ATOM   1371  C   GLY A 143       3.498  -5.779  18.022  1.00 37.94     0.236 C
ATOM   1372  O   GLY A 143       3.475  -6.874  17.461  1.00 37.62    -0.272 OA
ATOM   1373  H   GLY A 143       4.101  -4.041  20.444  1.00 40.00     0.163 HD
ATOM   1374  N   SER A 144       3.808  -4.638  17.377  1.00 36.24    -0.344 N
ATOM   1375  CA  SER A 144       4.165  -4.538  15.958  1.00 35.20     0.200 C
ATOM   1376  C   SER A 144       5.640  -4.879  15.670  1.00 33.83     0.243 C
ATOM   1377  O   SER A 144       6.028  -4.940  14.506  1.00 35.46    -0.271 OA
ATOM   1378  CB  SER A 144       3.897  -3.099  15.469  1.00 34.73     0.199 C
ATOM   1379  OG  SER A 144       4.868  -2.175  15.919  1.00 32.65    -0.398 OA
ATOM   1380  H   SER A 144       3.781  -3.776  17.903  1.00 36.24     0.163 HD
ATOM   1381  HG  SER A 144       4.666  -1.945  16.817  1.00 32.65     0.209 HD
ATOM   1382  N   CYS A 145       6.467  -5.078  16.707  1.00 35.69    -0.345 N
ATOM   1383  CA  CYS A 145       7.902  -5.332  16.598  1.00 35.66     0.185 C
ATOM   1384  C   CYS A 145       8.166  -6.696  15.947  1.00 32.33     0.241 C
ATOM   1385  O   CYS A 145       7.444  -7.659  16.195  1.00 30.52    -0.271 OA
ATOM   1386  CB  CYS A 145       8.525  -5.270  18.000  1.00 38.48     0.105 C
ATOM   1387  SG  CYS A 145       8.456  -3.557  18.599  1.00 40.38    -0.180 SA
ATOM   1388  H   CYS A 145       6.073  -5.035  17.636  1.00 35.69     0.163 HD
ATOM   1389  HG  CYS A 145       7.129  -3.427  18.523  1.00 40.38     0.101 HD
ATOM   1390  N   GLY A 146       9.172  -6.747  15.068  1.00 30.68    -0.351 N
ATOM   1391  CA  GLY A 146       9.494  -7.899  14.238  1.00 32.58     0.225 C
ATOM   1392  C   GLY A 146       8.725  -7.957  12.913  1.00 30.93     0.236 C
ATOM   1393  O   GLY A 146       8.897  -8.922  12.171  1.00 31.18    -0.272 OA
ATOM   1394  H   GLY A 146       9.743  -5.920  14.942  1.00 30.68     0.163 HD
ATOM   1395  N   SER A 147       7.903  -6.936  12.604  1.00 28.68    -0.344 N
ATOM   1396  CA  SER A 147       7.241  -6.747  11.312  1.00 30.22     0.200 C
ATOM   1397  C   SER A 147       8.288  -6.228  10.321  1.00 33.26     0.243 C
ATOM   1398  O   SER A 147       8.949  -5.221  10.588  1.00 28.09    -0.271 OA
ATOM   1399  CB  SER A 147       6.142  -5.680  11.448  1.00 33.09     0.199 C
ATOM   1400  OG  SER A 147       5.015  -6.227  12.094  1.00 33.82    -0.398 OA
ATOM   1401  H   SER A 147       7.804  -6.190  13.278  1.00 28.68     0.163 HD
ATOM   1402  HG  SER A 147       5.244  -6.393  12.997  1.00 33.82     0.209 HD
ATOM   1403  N   VAL A 148       8.468  -6.961   9.214  1.00 29.13    -0.346 N
ATOM   1404  CA  VAL A 148       9.614  -6.807   8.327  1.00 29.34     0.180 C
ATOM   1405  C   VAL A 148       9.280  -5.977   7.086  1.00 28.33     0.241 C
ATOM   1406  O   VAL A 148       8.148  -5.967   6.599  1.00 31.03    -0.271 OA
ATOM   1407  CB  VAL A 148      10.159  -8.204   7.926  1.00 29.75     0.009 C
ATOM   1408  CG1 VAL A 148      10.625  -8.972   9.174  1.00 29.92     0.012 C
ATOM   1409  CG2 VAL A 148       9.201  -9.059   7.073  1.00 29.02     0.012 C
ATOM   1410  H   VAL A 148       7.865  -7.755   9.054  1.00 29.13     0.163 HD
ATOM   1411  N   GLY A 149      10.327  -5.319   6.573  1.00 28.65    -0.351 N
ATOM   1412  CA  GLY A 149      10.351  -4.614   5.308  1.00 27.24     0.225 C
ATOM   1413  C   GLY A 149      11.092  -5.422   4.245  1.00 26.88     0.236 C
ATOM   1414  O   GLY A 149      12.042  -6.143   4.556  1.00 29.73    -0.272 OA
ATOM   1415  H   GLY A 149      11.214  -5.423   7.047  1.00 28.65     0.163 HD
ATOM   1416  N   PHE A 150      10.638  -5.301   2.990  1.00 25.60    -0.346 N
ATOM   1417  CA  PHE A 150      11.064  -6.125   1.864  1.00 30.38     0.180 C
ATOM   1418  C   PHE A 150      10.851  -5.426   0.515  1.00 30.17     0.241 C
ATOM   1419  O   PHE A 150       9.917  -4.644   0.343  1.00 30.83    -0.271 OA
ATOM   1420  CB  PHE A 150      10.376  -7.510   1.928  1.00 30.90     0.073 C
ATOM   1421  CG  PHE A 150       8.861  -7.463   1.790  1.00 30.67    -0.056 A
ATOM   1422  CD1 PHE A 150       8.056  -7.204   2.919  1.00 32.54     0.007 A
ATOM   1423  CD2 PHE A 150       8.254  -7.629   0.527  1.00 33.50     0.007 A
ATOM   1424  CE1 PHE A 150       6.663  -7.068   2.778  1.00 34.75     0.001 A
ATOM   1425  CE2 PHE A 150       6.857  -7.505   0.389  1.00 31.85     0.001 A
ATOM   1426  CZ  PHE A 150       6.062  -7.213   1.513  1.00 33.65     0.000 A
ATOM   1427  H   PHE A 150       9.844  -4.696   2.827  1.00 25.60     0.163 HD
ATOM   1428  N   ASN A 151      11.691  -5.796  -0.457  1.00 30.34    -0.346 N
ATOM   1429  CA  ASN A 151      11.492  -5.610  -1.895  1.00 35.45     0.185 C
ATOM   1430  C   ASN A 151      11.312  -6.996  -2.533  1.00 38.47     0.241 C
ATOM   1431  O   ASN A 151      11.707  -8.000  -1.939  1.00 36.61    -0.271 OA
ATOM   1432  CB  ASN A 151      12.731  -4.912  -2.499  1.00 36.31     0.137 C
ATOM   1433  CG  ASN A 151      12.839  -3.444  -2.080  1.00 35.77     0.217 C
ATOM   1434  OD1 ASN A 151      12.142  -2.595  -2.628  1.00 41.14    -0.274 OA
ATOM   1435  ND2 ASN A 151      13.705  -3.133  -1.114  1.00 34.20    -0.370 N
ATOM   1436  H   ASN A 151      12.435  -6.433  -0.202  1.00 30.34     0.163 HD
ATOM   1437 2HD2 ASN A 151      13.786  -2.167  -0.825  1.00 34.20     0.159 HD
ATOM   1438 1HD2 ASN A 151      14.261  -3.850  -0.672  1.00 34.20     0.159 HD
ATOM   1439  N   ILE A 152      10.734  -7.058  -3.744  1.00 42.55    -0.346 N
ATOM   1440  CA  ILE A 152      10.577  -8.291  -4.526  1.00 46.14     0.180 C
ATOM   1441  C   ILE A 152      11.103  -8.052  -5.947  1.00 49.80     0.241 C
ATOM   1442  O   ILE A 152      10.750  -7.062  -6.588  1.00 45.70    -0.271 OA
ATOM   1443  CB  ILE A 152       9.127  -8.865  -4.475  1.00 47.75     0.013 C
ATOM   1444  CG1 ILE A 152       8.598  -8.987  -3.025  1.00 46.88     0.002 C
ATOM   1445  CG2 ILE A 152       9.031 -10.222  -5.217  1.00 47.83     0.012 C
ATOM   1446  CD1 ILE A 152       7.200  -9.602  -2.882  1.00 48.71     0.005 C
ATOM   1447  H   ILE A 152      10.428  -6.200  -4.182  1.00 42.55     0.163 HD
ATOM   1448  N   ASP A 153      11.920  -8.997  -6.433  1.00 55.73    -0.345 N
ATOM   1449  CA  ASP A 153      12.472  -9.064  -7.780  1.00 58.61     0.186 C
ATOM   1450  C   ASP A 153      12.040 -10.414  -8.366  1.00 57.78     0.241 C
ATOM   1451  O   ASP A 153      12.738 -11.417  -8.205  1.00 55.79    -0.271 OA
ATOM   1452  CB  ASP A 153      14.002  -8.823  -7.707  1.00 66.34     0.147 C
ATOM   1453  CG  ASP A 153      14.714  -8.642  -9.055  1.00 74.79     0.175 C
ATOM   1454  OD1 ASP A 153      15.747  -7.938  -9.043  1.00 76.74    -0.648 OA
ATOM   1455  OD2 ASP A 153      14.237  -9.194 -10.071  1.00 82.51    -0.648 OA
ATOM   1456  H   ASP A 153      12.154  -9.769  -5.821  1.00 55.73     0.163 HD
ATOM   1457  N   TYR A 154      10.838 -10.426  -8.970  1.00 54.82    -0.346 N
ATOM   1458  CA  TYR A 154      10.140 -11.559  -9.584  1.00 64.13     0.180 C
ATOM   1459  C   TYR A 154       9.562 -12.502  -8.517  1.00 58.54     0.241 C
ATOM   1460  O   TYR A 154       8.375 -12.427  -8.199  1.00 58.35    -0.271 OA
ATOM   1461  CB  TYR A 154      10.963 -12.250 -10.706  1.00 75.44     0.073 C
ATOM   1462  CG  TYR A 154      10.313 -13.479 -11.326  1.00 86.64    -0.056 A
ATOM   1463  CD1 TYR A 154       9.005 -13.413 -11.855  1.00 92.00     0.010 A
ATOM   1464  CD2 TYR A 154      11.006 -14.707 -11.343  1.00 91.18     0.010 A
ATOM   1465  CE1 TYR A 154       8.389 -14.571 -12.367  1.00 93.97     0.037 A
ATOM   1466  CE2 TYR A 154      10.390 -15.865 -11.853  1.00 93.86     0.037 A
ATOM   1467  CZ  TYR A 154       9.078 -15.800 -12.359  1.00 95.36     0.065 A
ATOM   1468  OH  TYR A 154       8.478 -16.927 -12.840  1.00 93.57    -0.361 OA
ATOM   1469  H   TYR A 154      10.348  -9.543  -9.007  1.00 54.82     0.163 HD
ATOM   1470  HH  TYR A 154       7.603 -16.774 -13.161  1.00 93.57     0.217 HD
ATOM   1471  N   ASP A 155      10.421 -13.375  -7.970  1.00 57.77    -0.345 N
ATOM   1472  CA  ASP A 155      10.107 -14.396  -6.971  1.00 57.51     0.186 C
ATOM   1473  C   ASP A 155      11.075 -14.354  -5.775  1.00 48.80     0.241 C
ATOM   1474  O   ASP A 155      10.789 -14.983  -4.754  1.00 53.93    -0.271 OA
ATOM   1475  CB  ASP A 155       9.983 -15.789  -7.644  1.00 60.38     0.147 C
ATOM   1476  CG  ASP A 155      11.253 -16.375  -8.284  1.00 63.88     0.175 C
ATOM   1477  OD1 ASP A 155      12.280 -15.666  -8.365  1.00 65.24    -0.648 OA
ATOM   1478  OD2 ASP A 155      11.176 -17.556  -8.687  1.00 66.82    -0.648 OA
ATOM   1479  H   ASP A 155      11.371 -13.368  -8.316  1.00 57.77     0.163 HD
ATOM   1480  N   CYS A 156      12.187 -13.605  -5.887  1.00 46.44    -0.345 N
ATOM   1481  CA  CYS A 156      13.186 -13.413  -4.843  1.00 45.26     0.185 C
ATOM   1482  C   CYS A 156      12.764 -12.212  -3.983  1.00 46.30     0.241 C
ATOM   1483  O   CYS A 156      12.716 -11.084  -4.472  1.00 46.05    -0.271 OA
ATOM   1484  CB  CYS A 156      14.544 -13.123  -5.517  1.00 44.93     0.105 C
ATOM   1485  SG  CYS A 156      15.873 -13.067  -4.278  1.00 49.79    -0.180 SA
ATOM   1486  H   CYS A 156      12.338 -13.110  -6.755  1.00 46.44     0.163 HD
ATOM   1487  HG  CYS A 156      15.386 -12.025  -3.597  1.00 49.79     0.101 HD
ATOM   1488  N   VAL A 157      12.470 -12.470  -2.700  1.00 40.48    -0.346 N
ATOM   1489  CA  VAL A 157      12.071 -11.474  -1.712  1.00 37.62     0.180 C
ATOM   1490  C   VAL A 157      13.336 -11.045  -0.950  1.00 34.82     0.241 C
ATOM   1491  O   VAL A 157      13.822 -11.753  -0.067  1.00 35.04    -0.271 OA
ATOM   1492  CB  VAL A 157      11.031 -12.095  -0.738  1.00 36.06     0.009 C
ATOM   1493  CG1 VAL A 157      10.521 -11.062   0.284  1.00 34.28     0.012 C
ATOM   1494  CG2 VAL A 157       9.830 -12.703  -1.485  1.00 38.21     0.012 C
ATOM   1495  H   VAL A 157      12.538 -13.430  -2.381  1.00 40.48     0.163 HD
ATOM   1496  N   SER A 158      13.857  -9.862  -1.297  1.00 36.39    -0.344 N
ATOM   1497  CA  SER A 158      14.996  -9.223  -0.652  1.00 35.82     0.200 C
ATOM   1498  C   SER A 158      14.496  -8.485   0.602  1.00 33.04     0.243 C
ATOM   1499  O   SER A 158      14.033  -7.346   0.521  1.00 32.78    -0.271 OA
ATOM   1500  CB  SER A 158      15.605  -8.212  -1.645  1.00 36.13     0.199 C
ATOM   1501  OG  SER A 158      16.426  -8.885  -2.578  1.00 37.90    -0.398 OA
ATOM   1502  H   SER A 158      13.384  -9.332  -2.016  1.00 36.39     0.163 HD
ATOM   1503  HG  SER A 158      16.767  -8.251  -3.190  1.00 37.90     0.209 HD
ATOM   1504  N   PHE A 159      14.596  -9.155   1.761  1.00 28.61    -0.346 N
ATOM   1505  CA  PHE A 159      14.261  -8.624   3.081  1.00 28.01     0.180 C
ATOM   1506  C   PHE A 159      15.369  -7.666   3.530  1.00 28.35     0.241 C
ATOM   1507  O   PHE A 159      16.554  -7.949   3.350  1.00 27.22    -0.271 OA
ATOM   1508  CB  PHE A 159      14.175  -9.782   4.092  1.00 28.29     0.073 C
ATOM   1509  CG  PHE A 159      12.994 -10.703   3.878  1.00 25.85    -0.056 A
ATOM   1510  CD1 PHE A 159      11.706 -10.293   4.276  1.00 27.78     0.007 A
ATOM   1511  CD2 PHE A 159      13.174 -11.966   3.276  1.00 28.25     0.007 A
ATOM   1512  CE1 PHE A 159      10.603 -11.142   4.071  1.00 26.95     0.001 A
ATOM   1513  CE2 PHE A 159      12.068 -12.815   3.072  1.00 27.02     0.001 A
ATOM   1514  CZ  PHE A 159      10.783 -12.406   3.477  1.00 28.66     0.000 A
ATOM   1515  H   PHE A 159      15.003 -10.080   1.735  1.00 28.61     0.163 HD
ATOM   1516  N   CYS A 160      14.962  -6.514   4.079  1.00 26.25    -0.345 N
ATOM   1517  CA  CYS A 160      15.839  -5.371   4.315  1.00 27.93     0.185 C
ATOM   1518  C   CYS A 160      15.538  -4.564   5.577  1.00 26.38     0.241 C
ATOM   1519  O   CYS A 160      16.287  -3.638   5.879  1.00 29.63    -0.271 OA
ATOM   1520  CB  CYS A 160      15.959  -4.520   3.035  1.00 28.23     0.105 C
ATOM   1521  SG  CYS A 160      14.364  -3.787   2.560  1.00 33.42    -0.180 SA
ATOM   1522  H   CYS A 160      13.969  -6.368   4.205  1.00 26.25     0.163 HD
ATOM   1523  HG  CYS A 160      13.720  -4.948   2.408  1.00 33.42     0.101 HD
ATOM   1524  N   TYR A 161      14.474  -4.896   6.320  1.00 28.20    -0.346 N
ATOM   1525  CA  TYR A 161      14.099  -4.214   7.552  1.00 27.74     0.180 C
ATOM   1526  C   TYR A 161      13.396  -5.177   8.513  1.00 27.78     0.241 C
ATOM   1527  O   TYR A 161      12.798  -6.165   8.091  1.00 24.74    -0.271 OA
ATOM   1528  CB  TYR A 161      13.341  -2.907   7.237  1.00 27.85     0.073 C
ATOM   1529  CG  TYR A 161      12.948  -2.044   8.422  1.00 26.51    -0.056 A
ATOM   1530  CD1 TYR A 161      13.864  -1.114   8.956  1.00 29.42     0.010 A
ATOM   1531  CD2 TYR A 161      11.657  -2.156   8.982  1.00 25.78     0.010 A
ATOM   1532  CE1 TYR A 161      13.487  -0.290  10.034  1.00 28.31     0.037 A
ATOM   1533  CE2 TYR A 161      11.287  -1.343  10.069  1.00 27.07     0.037 A
ATOM   1534  CZ  TYR A 161      12.198  -0.406  10.592  1.00 27.75     0.065 A
ATOM   1535  OH  TYR A 161      11.823   0.394  11.631  1.00 28.89    -0.361 OA
ATOM   1536  H   TYR A 161      13.898  -5.675   6.032  1.00 28.20     0.163 HD
ATOM   1537  HH  TYR A 161      12.493   1.007  11.891  1.00 28.89     0.217 HD
ATOM   1538  N   MET A 162      13.472  -4.857   9.809  1.00 26.86    -0.346 N
ATOM   1539  CA  MET A 162      12.805  -5.500  10.929  1.00 25.99     0.177 C
ATOM   1540  C   MET A 162      12.615  -4.422  11.998  1.00 27.80     0.241 C
ATOM   1541  O   MET A 162      13.600  -3.835  12.447  1.00 26.95    -0.271 OA
ATOM   1542  CB  MET A 162      13.616  -6.731  11.387  1.00 27.01     0.045 C
ATOM   1543  CG  MET A 162      12.934  -7.525  12.508  1.00 28.19     0.076 C
ATOM   1544  SD  MET A 162      13.714  -9.118  12.879  1.00 31.12    -0.173 SA
ATOM   1545  CE  MET A 162      12.882 -10.143  11.641  1.00 32.73     0.089 C
ATOM   1546  H   MET A 162      14.032  -4.048  10.047  1.00 26.86     0.163 HD
ATOM   1547  N   HIS A 163      11.358  -4.144  12.382  1.00 27.50    -0.346 N
ATOM   1548  CA  HIS A 163      10.997  -3.083  13.324  1.00 26.43     0.182 C
ATOM   1549  C   HIS A 163      11.352  -3.479  14.765  1.00 27.22     0.241 C
ATOM   1550  O   HIS A 163      11.083  -4.606  15.181  1.00 25.19    -0.271 OA
ATOM   1551  CB  HIS A 163       9.481  -2.824  13.224  1.00 26.25     0.093 C
ATOM   1552  CG  HIS A 163       9.010  -1.658  14.061  1.00 26.44     0.030 A
ATOM   1553  ND1 HIS A 163       8.418  -1.805  15.305  1.00 27.07    -0.353 N
ATOM   1554  CD2 HIS A 163       9.100  -0.300  13.855  1.00 27.92     0.143 A
ATOM   1555  CE1 HIS A 163       8.183  -0.579  15.777  1.00 27.90     0.207 A
ATOM   1556  NE2 HIS A 163       8.568   0.384  14.950  1.00 26.74    -0.254 NA
ATOM   1557  H   HIS A 163      10.600  -4.658  11.952  1.00 27.50     0.163 HD
ATOM   1558  HD1 HIS A 163       8.192  -2.673  15.768  1.00 27.07     0.166 HD
ATOM   1559  N   HIS A 164      11.940  -2.536  15.518  1.00 30.06    -0.346 N
ATOM   1560  CA  HIS A 164      12.390  -2.723  16.897  1.00 31.50     0.182 C
ATOM   1561  C   HIS A 164      11.748  -1.725  17.863  1.00 34.63     0.241 C
ATOM   1562  O   HIS A 164      11.454  -2.105  18.995  1.00 35.79    -0.271 OA
ATOM   1563  CB  HIS A 164      13.928  -2.639  16.972  1.00 30.92     0.095 C
ATOM   1564  CG  HIS A 164      14.645  -3.908  16.586  1.00 29.33     0.053 A
ATOM   1565  ND1 HIS A 164      14.427  -4.565  15.372  1.00 28.62    -0.247 NA
ATOM   1566  CD2 HIS A 164      15.585  -4.614  17.308  1.00 28.19     0.116 A
ATOM   1567  CE1 HIS A 164      15.193  -5.642  15.420  1.00 27.21     0.207 A
ATOM   1568  NE2 HIS A 164      15.915  -5.711  16.536  1.00 25.94    -0.359 N
ATOM   1569  H   HIS A 164      12.120  -1.635  15.096  1.00 30.06     0.163 HD
ATOM   1570  HE2 HIS A 164      16.576  -6.438  16.782  1.00 25.94     0.166 HD
ATOM   1571  N   MET A 165      11.556  -0.461  17.452  0.64 32.66    -0.346 N
ATOM   1572  CA  MET A 165      11.083   0.605  18.332  0.64 33.02     0.177 C
ATOM   1573  C   MET A 165      10.534   1.814  17.572  0.64 33.31     0.241 C
ATOM   1574  O   MET A 165      10.914   2.077  16.431  0.64 31.72    -0.271 OA
ATOM   1575  CB  MET A 165      12.180   1.016  19.343  0.64 32.18     0.045 C
ATOM   1576  CG  MET A 165      13.472   1.524  18.686  0.64 32.64     0.076 C
ATOM   1577  SD  MET A 165      14.720   2.082  19.865  0.64 34.74    -0.173 SA
ATOM   1578  CE  MET A 165      15.947   2.651  18.668  0.64 34.00     0.089 C
ATOM   1579  H   MET A 165      11.817  -0.200  16.510  1.00 32.66     0.163 HD
ATOM   1580  N   GLU A 166       9.691   2.582  18.273  1.00 34.87    -0.346 N
ATOM   1581  CA  GLU A 166       9.302   3.945  17.944  1.00 35.31     0.177 C
ATOM   1582  C   GLU A 166      10.140   4.886  18.829  1.00 33.74     0.241 C
ATOM   1583  O   GLU A 166      10.253   4.662  20.036  1.00 31.96    -0.271 OA
ATOM   1584  CB  GLU A 166       7.801   4.088  18.274  1.00 41.50     0.045 C
ATOM   1585  CG  GLU A 166       7.186   5.440  17.871  1.00 47.32     0.116 C
ATOM   1586  CD  GLU A 166       5.659   5.409  17.952  1.00 48.16     0.172 C
ATOM   1587  OE1 GLU A 166       5.153   5.194  19.075  1.00 54.03    -0.648 OA
ATOM   1588  OE2 GLU A 166       5.024   5.590  16.890  1.00 44.24    -0.648 OA
ATOM   1589  H   GLU A 166       9.445   2.272  19.201  1.00 34.87     0.163 HD
ATOM   1590  N   LEU A 167      10.721   5.938  18.233  1.00 37.30    -0.346 N
ATOM   1591  CA  LEU A 167      11.471   6.992  18.926  1.00 38.36     0.177 C
ATOM   1592  C   LEU A 167      10.487   7.991  19.582  1.00 40.50     0.243 C
ATOM   1593  O   LEU A 167       9.338   8.061  19.142  1.00 40.68    -0.271 OA
ATOM   1594  CB  LEU A 167      12.332   7.768  17.896  1.00 40.09     0.038 C
ATOM   1595  CG  LEU A 167      13.374   6.935  17.114  1.00 42.64    -0.020 C
ATOM   1596  CD1 LEU A 167      14.248   7.853  16.246  1.00 45.35     0.009 C
ATOM   1597  CD2 LEU A 167      14.275   6.082  18.021  1.00 42.49     0.009 C
ATOM   1598  H   LEU A 167      10.564   6.072  17.241  1.00 37.30     0.163 HD
ATOM   1599  N   PRO A 168      10.902   8.774  20.610  1.00 41.26    -0.337 N
ATOM   1600  CA  PRO A 168      10.078   9.798  21.292  1.00 44.05     0.179 C
ATOM   1601  C   PRO A 168       9.290  10.798  20.413  1.00 45.05     0.241 C
ATOM   1602  O   PRO A 168       8.266  11.312  20.859  1.00 47.58    -0.271 OA
ATOM   1603  CB  PRO A 168      11.063  10.566  22.185  1.00 47.04     0.037 C
ATOM   1604  CG  PRO A 168      12.166   9.569  22.490  1.00 46.08     0.022 C
ATOM   1605  CD  PRO A 168      12.211   8.657  21.266  1.00 45.79     0.127 C
ATOM   1606  N   THR A 169       9.757  11.064  19.181  1.00 44.00    -0.344 N
ATOM   1607  CA  THR A 169       9.156  11.979  18.204  1.00 41.89     0.205 C
ATOM   1608  C   THR A 169       8.133  11.290  17.267  1.00 40.94     0.243 C
ATOM   1609  O   THR A 169       7.535  11.968  16.431  1.00 38.09    -0.271 OA
ATOM   1610  CB  THR A 169      10.303  12.603  17.367  1.00 44.04     0.146 C
ATOM   1611  OG1 THR A 169      11.027  11.615  16.657  1.00 43.46    -0.393 OA
ATOM   1612  CG2 THR A 169      11.287  13.435  18.204  1.00 47.14     0.042 C
ATOM   1613  H   THR A 169      10.603  10.600  18.885  1.00 44.00     0.163 HD
ATOM   1614  HG1 THR A 169      11.659  12.047  16.103  1.00 43.46     0.210 HD
ATOM   1615  N   GLY A 170       7.903   9.974  17.413  1.00 37.60    -0.350 N
ATOM   1616  CA  GLY A 170       6.881   9.202  16.705  1.00 41.41     0.225 C
ATOM   1617  C   GLY A 170       7.341   8.533  15.402  1.00 40.33     0.236 C
ATOM   1618  O   GLY A 170       6.578   7.749  14.840  1.00 42.36    -0.272 OA
ATOM   1619  H   GLY A 170       8.433   9.477  18.117  1.00 37.60     0.163 HD
ATOM   1620  N   VAL A 171       8.572   8.803  14.929  1.00 37.80    -0.346 N
ATOM   1621  CA  VAL A 171       9.201   8.095  13.806  1.00 33.67     0.180 C
ATOM   1622  C   VAL A 171       9.889   6.825  14.340  1.00 28.65     0.241 C
ATOM   1623  O   VAL A 171      10.177   6.716  15.532  1.00 29.41    -0.271 OA
ATOM   1624  CB  VAL A 171      10.225   9.016  13.085  1.00 36.32     0.009 C
ATOM   1625  CG1 VAL A 171       9.560  10.295  12.549  1.00 43.23     0.012 C
ATOM   1626  CG2 VAL A 171      11.477   9.355  13.912  1.00 34.52     0.012 C
ATOM   1627  H   VAL A 171       9.144   9.458  15.441  1.00 37.80     0.163 HD
ATOM   1628  N   HIS A 172      10.121   5.851  13.453  1.00 26.57    -0.346 N
ATOM   1629  CA  HIS A 172      10.455   4.472  13.804  1.00 29.76     0.182 C
ATOM   1630  C   HIS A 172      11.894   4.127  13.423  1.00 28.53     0.241 C
ATOM   1631  O   HIS A 172      12.461   4.713  12.504  1.00 30.01    -0.271 OA
ATOM   1632  CB  HIS A 172       9.447   3.546  13.102  1.00 30.07     0.095 C
ATOM   1633  CG  HIS A 172       8.021   3.929  13.405  1.00 30.90     0.053 A
ATOM   1634  ND1 HIS A 172       7.237   4.687  12.526  1.00 30.46    -0.247 NA
ATOM   1635  CD2 HIS A 172       7.309   3.713  14.564  1.00 32.93     0.116 A
ATOM   1636  CE1 HIS A 172       6.113   4.920  13.192  1.00 35.86     0.207 A
ATOM   1637  NE2 HIS A 172       6.100   4.366  14.404  1.00 32.87    -0.359 N
ATOM   1638  H   HIS A 172       9.891   6.025  12.482  1.00 26.57     0.163 HD
ATOM   1639  HE2 HIS A 172       5.382   4.480  15.111  1.00 32.87     0.166 HD
ATOM   1640  N   ALA A 173      12.474   3.165  14.152  1.00 27.66    -0.346 N
ATOM   1641  CA  ALA A 173      13.851   2.703  14.033  1.00 26.05     0.172 C
ATOM   1642  C   ALA A 173      13.910   1.178  14.152  1.00 29.32     0.240 C
ATOM   1643  O   ALA A 173      13.180   0.573  14.939  1.00 26.79    -0.271 OA
ATOM   1644  CB  ALA A 173      14.737   3.431  15.053  1.00 26.14     0.042 C
ATOM   1645  H   ALA A 173      11.919   2.727  14.877  1.00 27.66     0.163 HD
ATOM   1646  N   GLY A 174      14.782   0.563  13.345  1.00 30.54    -0.351 N
ATOM   1647  CA  GLY A 174      14.933  -0.879  13.251  1.00 30.08     0.225 C
ATOM   1648  C   GLY A 174      16.252  -1.274  12.596  1.00 29.93     0.236 C
ATOM   1649  O   GLY A 174      17.086  -0.429  12.263  1.00 27.51    -0.272 OA
ATOM   1650  H   GLY A 174      15.375   1.122  12.748  1.00 30.54     0.163 HD
ATOM   1651  N   THR A 175      16.426  -2.590  12.445  1.00 31.36    -0.344 N
ATOM   1652  CA  THR A 175      17.621  -3.255  11.935  1.00 30.76     0.205 C
ATOM   1653  C   THR A 175      17.361  -3.843  10.544  1.00 32.91     0.243 C
ATOM   1654  O   THR A 175      16.215  -3.936  10.116  1.00 30.28    -0.271 OA
ATOM   1655  CB  THR A 175      17.984  -4.397  12.922  1.00 30.07     0.146 C
ATOM   1656  OG1 THR A 175      17.027  -5.440  12.921  1.00 29.47    -0.393 OA
ATOM   1657  CG2 THR A 175      18.192  -3.945  14.372  1.00 29.28     0.042 C
ATOM   1658  H   THR A 175      15.670  -3.201  12.729  1.00 31.36     0.163 HD
ATOM   1659  HG1 THR A 175      17.078  -5.888  12.087  1.00 29.47     0.210 HD
ATOM   1660  N   ASP A 176      18.427  -4.334   9.891  1.00 30.91    -0.345 N
ATOM   1661  CA  ASP A 176      18.350  -5.339   8.824  1.00 30.50     0.186 C
ATOM   1662  C   ASP A 176      18.165  -6.736   9.467  1.00 27.29     0.241 C
ATOM   1663  O   ASP A 176      18.130  -6.875  10.692  1.00 26.11    -0.271 OA
ATOM   1664  CB  ASP A 176      19.643  -5.280   7.957  1.00 30.22     0.147 C
ATOM   1665  CG  ASP A 176      21.001  -5.361   8.673  1.00 28.94     0.175 C
ATOM   1666  OD1 ASP A 176      21.093  -6.034   9.723  1.00 28.55    -0.648 OA
ATOM   1667  OD2 ASP A 176      21.944  -4.733   8.146  1.00 29.98    -0.648 OA
ATOM   1668  H   ASP A 176      19.340  -4.195  10.305  1.00 30.91     0.163 HD
ATOM   1669  N   LEU A 177      18.037  -7.788   8.645  1.00 27.11    -0.346 N
ATOM   1670  CA  LEU A 177      17.803  -9.166   9.098  1.00 29.34     0.177 C
ATOM   1671  C   LEU A 177      19.045  -9.852   9.718  1.00 30.44     0.241 C
ATOM   1672  O   LEU A 177      18.913 -10.951  10.257  1.00 31.79    -0.271 OA
ATOM   1673  CB  LEU A 177      17.262  -9.991   7.906  1.00 28.35     0.038 C
ATOM   1674  CG  LEU A 177      15.725  -9.953   7.728  1.00 29.59    -0.020 C
ATOM   1675  CD1 LEU A 177      15.002 -10.777   8.805  1.00 31.62     0.009 C
ATOM   1676  CD2 LEU A 177      15.144  -8.534   7.614  1.00 30.04     0.009 C
ATOM   1677  H   LEU A 177      18.078  -7.628   7.649  1.00 27.11     0.163 HD
ATOM   1678  N   GLU A 178      20.218  -9.193   9.706  1.00 28.22    -0.346 N
ATOM   1679  CA  GLU A 178      21.423  -9.583  10.445  1.00 31.13     0.177 C
ATOM   1680  C   GLU A 178      21.505  -8.879  11.819  1.00 28.98     0.240 C
ATOM   1681  O   GLU A 178      22.438  -9.143  12.577  1.00 33.80    -0.271 OA
ATOM   1682  CB  GLU A 178      22.657  -9.166   9.620  1.00 32.98     0.045 C
ATOM   1683  CG  GLU A 178      22.792  -9.949   8.301  1.00 38.25     0.116 C
ATOM   1684  CD  GLU A 178      24.182  -9.812   7.678  1.00 41.91     0.172 C
ATOM   1685  OE1 GLU A 178      24.732  -8.689   7.728  1.00 44.62    -0.648 OA
ATOM   1686  OE2 GLU A 178      24.674 -10.840   7.166  1.00 43.07    -0.648 OA
ATOM   1687  H   GLU A 178      20.246  -8.290   9.252  1.00 28.22     0.163 HD
ATOM   1688  N   GLY A 179      20.538  -8.008  12.154  1.00 29.98    -0.351 N
ATOM   1689  CA  GLY A 179      20.401  -7.339  13.443  1.00 28.53     0.225 C
ATOM   1690  C   GLY A 179      21.220  -6.058  13.616  1.00 27.84     0.236 C
ATOM   1691  O   GLY A 179      21.266  -5.534  14.725  1.00 30.16    -0.272 OA
ATOM   1692  H   GLY A 179      19.819  -7.819  11.469  1.00 29.98     0.163 HD
ATOM   1693  N   ASN A 180      21.860  -5.540  12.558  1.00 28.09    -0.346 N
ATOM   1694  CA  ASN A 180      22.605  -4.281  12.602  1.00 29.66     0.185 C
ATOM   1695  C   ASN A 180      21.604  -3.136  12.402  1.00 27.43     0.241 C
ATOM   1696  O   ASN A 180      20.907  -3.095  11.386  1.00 26.30    -0.271 OA
ATOM   1697  CB  ASN A 180      23.631  -4.238  11.446  1.00 29.33     0.137 C
ATOM   1698  CG  ASN A 180      24.691  -5.336  11.542  1.00 29.99     0.217 C
ATOM   1699  OD1 ASN A 180      25.565  -5.281  12.404  1.00 33.57    -0.274 OA
ATOM   1700  ND2 ASN A 180      24.610  -6.336  10.662  1.00 31.59    -0.370 N
ATOM   1701  H   ASN A 180      21.752  -5.989  11.656  1.00 28.09     0.163 HD
ATOM   1702 2HD2 ASN A 180      25.294  -7.078  10.675  1.00 31.59     0.159 HD
ATOM   1703 1HD2 ASN A 180      23.874  -6.341   9.968  1.00 31.59     0.159 HD
ATOM   1704  N   PHE A 181      21.533  -2.210  13.374  1.00 30.23    -0.346 N
ATOM   1705  CA  PHE A 181      20.662  -1.034  13.344  1.00 30.29     0.180 C
ATOM   1706  C   PHE A 181      21.037  -0.070  12.215  1.00 29.72     0.241 C
ATOM   1707  O   PHE A 181      22.216   0.188  11.970  1.00 28.58    -0.271 OA
ATOM   1708  CB  PHE A 181      20.701  -0.291  14.699  1.00 28.29     0.073 C
ATOM   1709  CG  PHE A 181      19.511  -0.593  15.590  1.00 30.88    -0.056 A
ATOM   1710  CD1 PHE A 181      19.620  -1.544  16.624  1.00 31.53     0.007 A
ATOM   1711  CD2 PHE A 181      18.287   0.078  15.382  1.00 31.34     0.007 A
ATOM   1712  CE1 PHE A 181      18.510  -1.826  17.441  1.00 32.48     0.001 A
ATOM   1713  CE2 PHE A 181      17.178  -0.201  16.203  1.00 32.49     0.001 A
ATOM   1714  CZ  PHE A 181      17.291  -1.152  17.235  1.00 31.67     0.000 A
ATOM   1715  H   PHE A 181      22.133  -2.317  14.179  1.00 30.23     0.163 HD
ATOM   1716  N   TYR A 182      20.009   0.491  11.566  1.00 29.54    -0.346 N
ATOM   1717  CA  TYR A 182      20.131   1.616  10.650  1.00 30.00     0.180 C
ATOM   1718  C   TYR A 182      20.262   2.885  11.496  1.00 32.83     0.241 C
ATOM   1719  O   TYR A 182      19.408   3.158  12.338  1.00 30.81    -0.271 OA
ATOM   1720  CB  TYR A 182      18.856   1.693   9.790  1.00 28.63     0.073 C
ATOM   1721  CG  TYR A 182      18.802   0.612   8.730  1.00 28.87    -0.056 A
ATOM   1722  CD1 TYR A 182      19.702   0.659   7.646  1.00 29.81     0.010 A
ATOM   1723  CD2 TYR A 182      17.875  -0.447   8.827  1.00 28.13     0.010 A
ATOM   1724  CE1 TYR A 182      19.683  -0.351   6.670  1.00 30.04     0.037 A
ATOM   1725  CE2 TYR A 182      17.846  -1.448   7.840  1.00 27.49     0.037 A
ATOM   1726  CZ  TYR A 182      18.751  -1.400   6.763  1.00 27.17     0.065 A
ATOM   1727  OH  TYR A 182      18.727  -2.363   5.803  1.00 25.59    -0.361 OA
ATOM   1728  H   TYR A 182      19.071   0.214  11.824  1.00 29.54     0.163 HD
ATOM   1729  HH  TYR A 182      17.982  -2.944   5.894  1.00 25.59     0.217 HD
ATOM   1730  N   GLY A 183      21.348   3.640  11.277  1.00 30.87    -0.351 N
ATOM   1731  CA  GLY A 183      21.687   4.839  12.036  1.00 30.47     0.225 C
ATOM   1732  C   GLY A 183      22.395   4.531  13.365  1.00 32.13     0.238 C
ATOM   1733  O   GLY A 183      22.837   3.401  13.578  1.00 30.82    -0.272 OA
ATOM   1734  H   GLY A 183      22.008   3.341  10.574  1.00 30.87     0.163 HD
ATOM   1735  N   PRO A 184      22.512   5.531  14.266  1.00 32.33    -0.337 N
ATOM   1736  CA  PRO A 184      23.188   5.398  15.568  1.00 34.28     0.179 C
ATOM   1737  C   PRO A 184      22.304   4.765  16.667  1.00 34.75     0.241 C
ATOM   1738  O   PRO A 184      22.730   4.692  17.819  1.00 38.74    -0.271 OA
ATOM   1739  CB  PRO A 184      23.533   6.850  15.937  1.00 34.09     0.037 C
ATOM   1740  CG  PRO A 184      22.394   7.664  15.340  1.00 34.06     0.022 C
ATOM   1741  CD  PRO A 184      22.047   6.907  14.057  1.00 33.30     0.127 C
ATOM   1742  N   PHE A 185      21.078   4.337  16.321  1.00 34.59    -0.346 N
ATOM   1743  CA  PHE A 185      20.032   3.892  17.238  1.00 32.97     0.180 C
ATOM   1744  C   PHE A 185      20.338   2.514  17.853  1.00 31.79     0.241 C
ATOM   1745  O   PHE A 185      21.017   1.687  17.245  1.00 27.93    -0.271 OA
ATOM   1746  CB  PHE A 185      18.705   3.827  16.449  1.00 34.97     0.073 C
ATOM   1747  CG  PHE A 185      18.268   5.138  15.806  1.00 30.23    -0.056 A
ATOM   1748  CD1 PHE A 185      18.252   6.340  16.549  1.00 30.21     0.007 A
ATOM   1749  CD2 PHE A 185      17.891   5.161  14.448  1.00 30.94     0.007 A
ATOM   1750  CE1 PHE A 185      17.906   7.555  15.925  1.00 31.37     0.001 A
ATOM   1751  CE2 PHE A 185      17.553   6.375  13.821  1.00 29.77     0.001 A
ATOM   1752  CZ  PHE A 185      17.570   7.573  14.557  1.00 29.95     0.000 A
ATOM   1753  H   PHE A 185      20.816   4.409  15.349  1.00 34.59     0.163 HD
ATOM   1754  N   VAL A 186      19.833   2.295  19.077  1.00 31.24    -0.346 N
ATOM   1755  CA  VAL A 186      20.032   1.103  19.908  1.00 31.77     0.180 C
ATOM   1756  C   VAL A 186      18.695   0.664  20.519  1.00 31.76     0.241 C
ATOM   1757  O   VAL A 186      17.863   1.508  20.842  1.00 32.58    -0.271 OA
ATOM   1758  CB  VAL A 186      21.142   1.341  20.971  1.00 31.64     0.009 C
ATOM   1759  CG1 VAL A 186      22.534   1.506  20.339  1.00 33.94     0.012 C
ATOM   1760  CG2 VAL A 186      20.842   2.514  21.929  1.00 30.93     0.012 C
ATOM   1761  H   VAL A 186      19.282   3.035  19.491  1.00 31.24     0.163 HD
ATOM   1762  N   ASP A 187      18.493  -0.649  20.711  1.00 31.33    -0.345 N
ATOM   1763  CA  ASP A 187      17.276  -1.244  21.276  1.00 33.46     0.186 C
ATOM   1764  C   ASP A 187      17.267  -1.129  22.817  1.00 35.91     0.241 C
ATOM   1765  O   ASP A 187      17.417  -2.114  23.539  1.00 34.97    -0.271 OA
ATOM   1766  CB  ASP A 187      17.125  -2.724  20.812  1.00 31.85     0.147 C
ATOM   1767  CG  ASP A 187      18.312  -3.689  20.970  1.00 33.16     0.175 C
ATOM   1768  OD1 ASP A 187      19.422  -3.259  21.356  1.00 32.78    -0.648 OA
ATOM   1769  OD2 ASP A 187      18.084  -4.881  20.677  1.00 29.85    -0.648 OA
ATOM   1770  H   ASP A 187      19.235  -1.294  20.473  1.00 31.33     0.163 HD
ATOM   1771  N   ARG A 188      17.046   0.097  23.315  0.64 38.44    -0.346 N
ATOM   1772  CA  ARG A 188      16.773   0.410  24.713  0.64 41.90     0.176 C
ATOM   1773  C   ARG A 188      15.951   1.700  24.835  0.64 40.37     0.241 C
ATOM   1774  O   ARG A 188      16.003   2.567  23.962  0.64 37.68    -0.271 OA
ATOM   1775  CB  ARG A 188      18.052   0.375  25.576  0.64 45.64     0.036 C
ATOM   1776  CG  ARG A 188      19.078   1.506  25.353  0.64 49.05     0.023 C
ATOM   1777  CD  ARG A 188      19.523   2.097  26.696  0.64 55.05     0.138 C
ATOM   1778  NE  ARG A 188      20.683   2.988  26.590  0.64 59.53    -0.227 N
ATOM   1779  CZ  ARG A 188      21.111   3.794  27.578  0.64 63.52     0.665 C
ATOM   1780  NH1 ARG A 188      22.211   4.533  27.393  0.64 66.48    -0.235 N
ATOM   1781  NH2 ARG A 188      20.458   3.872  28.749  0.64 63.58    -0.235 N
ATOM   1782  H   ARG A 188      16.952   0.859  22.656  1.00 38.44     0.163 HD
ATOM   1783  HE  ARG A 188      21.215   2.934  25.734  1.00 59.53     0.177 HD
ATOM   1784 HH12 ARG A 188      22.558   5.125  28.134  1.00 66.48     0.174 HD
ATOM   1785 HH11 ARG A 188      22.721   4.483  26.523  1.00 66.48     0.174 HD
ATOM   1786 HH22 ARG A 188      20.803   4.458  29.495  1.00 63.58     0.174 HD
ATOM   1787 HH21 ARG A 188      19.638   3.300  28.913  1.00 63.58     0.174 HD
ATOM   1788  N   GLN A 189      15.205   1.825  25.941  0.64 42.39    -0.346 N
ATOM   1789  CA  GLN A 189      14.372   2.970  26.286  0.64 44.21     0.177 C
ATOM   1790  C   GLN A 189      15.263   4.055  26.915  0.64 43.15     0.241 C
ATOM   1791  O   GLN A 189      15.614   3.994  28.093  0.64 42.40    -0.271 OA
ATOM   1792  CB  GLN A 189      13.298   2.481  27.283  0.64 45.84     0.044 C
ATOM   1793  CG  GLN A 189      12.279   3.557  27.709  0.64 47.89     0.105 C
ATOM   1794  CD  GLN A 189      11.132   2.979  28.542  0.64 49.07     0.215 C
ATOM   1795  OE1 GLN A 189      11.286   1.966  29.222  0.64 51.43    -0.274 OA
ATOM   1796  NE2 GLN A 189       9.963   3.620  28.485  0.64 50.03    -0.370 N
ATOM   1797  H   GLN A 189      15.245   1.078  26.624  1.00 42.39     0.163 HD
ATOM   1798 2HE2 GLN A 189       9.179   3.271  29.017  1.00 50.03     0.159 HD
ATOM   1799 1HE2 GLN A 189       9.865   4.448  27.915  1.00 50.03     0.159 HD
ATOM   1800  N   THR A 190      15.636   5.040  26.087  1.00 43.24    -0.344 N
ATOM   1801  CA  THR A 190      16.442   6.210  26.426  1.00 46.89     0.205 C
ATOM   1802  C   THR A 190      16.086   7.366  25.471  1.00 51.49     0.243 C
ATOM   1803  O   THR A 190      15.288   7.191  24.546  1.00 51.52    -0.271 OA
ATOM   1804  CB  THR A 190      17.947   5.826  26.521  1.00 44.70     0.146 C
ATOM   1805  OG1 THR A 190      18.702   6.874  27.098  1.00 45.07    -0.393 OA
ATOM   1806  CG2 THR A 190      18.593   5.476  25.170  1.00 43.44     0.042 C
ATOM   1807  H   THR A 190      15.299   5.002  25.136  1.00 43.24     0.163 HD
ATOM   1808  HG1 THR A 190      19.601   6.592  27.174  1.00 45.07     0.210 HD
ATOM   1809  N   ALA A 191      16.694   8.544  25.682  1.00 60.28    -0.346 N
ATOM   1810  CA  ALA A 191      16.578   9.709  24.810  1.00 58.58     0.172 C
ATOM   1811  C   ALA A 191      17.369   9.454  23.516  1.00 50.47     0.240 C
ATOM   1812  O   ALA A 191      18.597   9.364  23.542  1.00 54.89    -0.271 OA
ATOM   1813  CB  ALA A 191      17.160  10.928  25.546  1.00 62.73     0.042 C
ATOM   1814  H   ALA A 191      17.356   8.600  26.444  1.00 60.28     0.163 HD
ATOM   1815  N   GLN A 192      16.640   9.304  22.400  1.00 45.89    -0.346 N
ATOM   1816  CA  GLN A 192      17.167   8.977  21.079  1.00 45.41     0.177 C
ATOM   1817  C   GLN A 192      16.542   9.917  20.051  1.00 44.85     0.241 C
ATOM   1818  O   GLN A 192      15.550   9.579  19.403  1.00 49.44    -0.271 OA
ATOM   1819  CB  GLN A 192      16.960   7.485  20.752  1.00 41.58     0.044 C
ATOM   1820  CG  GLN A 192      17.724   6.543  21.697  1.00 38.88     0.105 C
ATOM   1821  CD  GLN A 192      17.862   5.133  21.130  1.00 35.03     0.215 C
ATOM   1822  OE1 GLN A 192      18.396   4.943  20.041  1.00 35.16    -0.274 OA
ATOM   1823  NE2 GLN A 192      17.394   4.134  21.874  1.00 36.20    -0.370 N
ATOM   1824  H   GLN A 192      15.636   9.381  22.478  1.00 45.89     0.163 HD
ATOM   1825 2HE2 GLN A 192      17.466   3.184  21.530  1.00 36.20     0.159 HD
ATOM   1826 1HE2 GLN A 192      16.944   4.313  22.760  1.00 36.20     0.159 HD
ATOM   1827  N   ALA A 193      17.147  11.105  19.913  1.00 45.83    -0.346 N
ATOM   1828  CA  ALA A 193      16.807  12.096  18.903  1.00 46.77     0.172 C
ATOM   1829  C   ALA A 193      17.484  11.704  17.585  1.00 44.97     0.240 C
ATOM   1830  O   ALA A 193      18.691  11.456  17.546  1.00 47.72    -0.271 OA
ATOM   1831  CB  ALA A 193      17.364  13.458  19.352  1.00 51.23     0.042 C
ATOM   1832  H   ALA A 193      17.952  11.300  20.491  1.00 45.83     0.163 HD
ATOM   1833  N   ALA A 194      16.692  11.665  16.506  1.00 42.45    -0.346 N
ATOM   1834  CA  ALA A 194      17.160  11.436  15.144  1.00 46.88     0.172 C
ATOM   1835  C   ALA A 194      17.740  12.736  14.564  1.00 42.80     0.240 C
ATOM   1836  O   ALA A 194      17.390  13.833  15.004  1.00 44.80    -0.271 OA
ATOM   1837  CB  ALA A 194      15.952  11.018  14.293  1.00 46.66     0.042 C
ATOM   1838  H   ALA A 194      15.713  11.880  16.624  1.00 42.45     0.163 HD
ATOM   1839  N   GLY A 195      18.614  12.601  13.555  1.00 38.11    -0.351 N
ATOM   1840  CA  GLY A 195      19.221  13.714  12.826  1.00 38.22     0.225 C
ATOM   1841  C   GLY A 195      18.231  14.466  11.926  1.00 34.28     0.236 C
ATOM   1842  O   GLY A 195      17.036  14.160  11.904  1.00 33.05    -0.272 OA
ATOM   1843  H   GLY A 195      18.853  11.668  13.252  1.00 38.11     0.163 HD
ATOM   1844  N   THR A 196      18.742  15.450  11.169  1.00 34.57    -0.344 N
ATOM   1845  CA  THR A 196      17.973  16.267  10.228  1.00 33.24     0.205 C
ATOM   1846  C   THR A 196      17.474  15.370   9.083  1.00 33.35     0.243 C
ATOM   1847  O   THR A 196      18.277  14.842   8.311  1.00 29.48    -0.271 OA
ATOM   1848  CB  THR A 196      18.878  17.403   9.685  1.00 34.74     0.146 C
ATOM   1849  OG1 THR A 196      19.242  18.246  10.761  1.00 37.45    -0.393 OA
ATOM   1850  CG2 THR A 196      18.201  18.305   8.634  1.00 34.66     0.042 C
ATOM   1851  H   THR A 196      19.727  15.656  11.248  1.00 34.57     0.163 HD
ATOM   1852  HG1 THR A 196      19.810  18.926  10.433  1.00 37.45     0.210 HD
ATOM   1853  N   ASP A 197      16.145  15.199   8.998  1.00 36.59    -0.345 N
ATOM   1854  CA  ASP A 197      15.474  14.435   7.954  1.00 36.72     0.186 C
ATOM   1855  C   ASP A 197      15.400  15.319   6.700  1.00 37.57     0.241 C
ATOM   1856  O   ASP A 197      14.481  16.125   6.543  1.00 39.61    -0.271 OA
ATOM   1857  CB  ASP A 197      14.060  14.037   8.452  1.00 38.93     0.147 C
ATOM   1858  CG  ASP A 197      13.214  13.280   7.420  1.00 40.04     0.175 C
ATOM   1859  OD1 ASP A 197      13.776  12.395   6.738  1.00 33.34    -0.648 OA
ATOM   1860  OD2 ASP A 197      12.010  13.598   7.331  1.00 44.47    -0.648 OA
ATOM   1861  H   ASP A 197      15.557  15.654   9.682  1.00 36.59     0.163 HD
ATOM   1862  N   THR A 198      16.399  15.165   5.821  1.00 39.11    -0.344 N
ATOM   1863  CA  THR A 198      16.455  15.804   4.513  1.00 39.52     0.205 C
ATOM   1864  C   THR A 198      15.562  15.027   3.526  1.00 36.11     0.243 C
ATOM   1865  O   THR A 198      15.206  13.869   3.757  1.00 33.84    -0.271 OA
ATOM   1866  CB  THR A 198      17.926  15.845   4.021  1.00 40.67     0.146 C
ATOM   1867  OG1 THR A 198      18.477  14.550   3.954  1.00 43.77    -0.393 OA
ATOM   1868  CG2 THR A 198      18.841  16.723   4.887  1.00 39.95     0.042 C
ATOM   1869  H   THR A 198      17.131  14.501   6.031  1.00 39.11     0.163 HD
ATOM   1870  HG1 THR A 198      19.320  14.584   3.514  1.00 43.77     0.210 HD
ATOM   1871  N   THR A 199      15.178  15.693   2.430  1.00 32.73    -0.344 N
ATOM   1872  CA  THR A 199      14.319  15.136   1.392  1.00 31.07     0.205 C
ATOM   1873  C   THR A 199      15.221  14.438   0.359  1.00 32.74     0.243 C
ATOM   1874  O   THR A 199      16.272  14.962  -0.017  1.00 28.48    -0.271 OA
ATOM   1875  CB  THR A 199      13.543  16.287   0.713  1.00 31.18     0.146 C
ATOM   1876  OG1 THR A 199      12.840  17.031   1.691  1.00 30.25    -0.393 OA
ATOM   1877  CG2 THR A 199      12.484  15.786  -0.279  1.00 32.91     0.042 C
ATOM   1878  H   THR A 199      15.512  16.640   2.305  1.00 32.73     0.163 HD
ATOM   1879  HG1 THR A 199      13.465  17.397   2.298  1.00 30.25     0.210 HD
ATOM   1880  N   ILE A 200      14.804  13.245  -0.088  1.00 27.23    -0.346 N
ATOM   1881  CA  ILE A 200      15.556  12.374  -0.989  1.00 29.11     0.180 C
ATOM   1882  C   ILE A 200      15.336  12.897  -2.423  1.00 29.90     0.241 C
ATOM   1883  O   ILE A 200      14.273  12.714  -3.012  1.00 28.37    -0.271 OA
ATOM   1884  CB  ILE A 200      15.038  10.916  -0.830  1.00 30.72     0.013 C
ATOM   1885  CG1 ILE A 200      15.069  10.412   0.638  1.00 32.64     0.002 C
ATOM   1886  CG2 ILE A 200      15.839   9.947  -1.721  1.00 30.48     0.012 C
ATOM   1887  CD1 ILE A 200      13.956   9.401   0.958  1.00 31.72     0.005 C
ATOM   1888  H   ILE A 200      13.917  12.895   0.257  1.00 27.23     0.163 HD
ATOM   1889  N   THR A 201      16.346  13.595  -2.956  1.00 26.69    -0.344 N
ATOM   1890  CA  THR A 201      16.264  14.466  -4.131  1.00 26.48     0.205 C
ATOM   1891  C   THR A 201      16.067  13.694  -5.443  1.00 26.83     0.243 C
ATOM   1892  O   THR A 201      15.267  14.112  -6.279  1.00 30.82    -0.271 OA
ATOM   1893  CB  THR A 201      17.590  15.247  -4.191  1.00 26.34     0.146 C
ATOM   1894  OG1 THR A 201      17.700  15.990  -3.001  1.00 23.20    -0.393 OA
ATOM   1895  CG2 THR A 201      17.717  16.255  -5.338  1.00 26.92     0.042 C
ATOM   1896  H   THR A 201      17.177  13.704  -2.392  1.00 26.69     0.163 HD
ATOM   1897  HG1 THR A 201      18.598  16.287  -2.920  1.00 23.20     0.210 HD
ATOM   1898  N   VAL A 202      16.777  12.565  -5.609  1.00 23.74    -0.346 N
ATOM   1899  CA  VAL A 202      16.691  11.668  -6.763  1.00 27.26     0.180 C
ATOM   1900  C   VAL A 202      15.308  10.985  -6.868  1.00 26.90     0.241 C
ATOM   1901  O   VAL A 202      14.888  10.640  -7.971  1.00 26.58    -0.271 OA
ATOM   1902  CB  VAL A 202      17.863  10.649  -6.683  1.00 27.10     0.009 C
ATOM   1903  CG1 VAL A 202      17.812   9.715  -5.458  1.00 30.62     0.012 C
ATOM   1904  CG2 VAL A 202      18.034   9.831  -7.974  1.00 28.93     0.012 C
ATOM   1905  H   VAL A 202      17.406  12.293  -4.868  1.00 23.74     0.163 HD
ATOM   1906  N   ASN A 203      14.587  10.846  -5.741  1.00 28.74    -0.346 N
ATOM   1907  CA  ASN A 203      13.237  10.288  -5.673  1.00 32.17     0.185 C
ATOM   1908  C   ASN A 203      12.157  11.344  -5.979  1.00 29.55     0.241 C
ATOM   1909  O   ASN A 203      11.098  10.976  -6.487  1.00 29.72    -0.271 OA
ATOM   1910  CB  ASN A 203      12.962   9.734  -4.254  1.00 31.86     0.137 C
ATOM   1911  CG  ASN A 203      13.715   8.446  -3.902  1.00 31.15     0.217 C
ATOM   1912  OD1 ASN A 203      14.761   8.134  -4.466  1.00 30.48    -0.274 OA
ATOM   1913  ND2 ASN A 203      13.173   7.674  -2.959  1.00 29.74    -0.370 N
ATOM   1914  H   ASN A 203      14.993  11.169  -4.874  1.00 28.74     0.163 HD
ATOM   1915 2HD2 ASN A 203      13.658   6.837  -2.664  1.00 29.74     0.159 HD
ATOM   1916 1HD2 ASN A 203      12.344   7.983  -2.470  1.00 29.74     0.159 HD
ATOM   1917  N   VAL A 204      12.415  12.641  -5.718  1.00 29.18    -0.346 N
ATOM   1918  CA  VAL A 204      11.528  13.745  -6.105  1.00 28.94     0.180 C
ATOM   1919  C   VAL A 204      11.639  13.999  -7.618  1.00 29.24     0.241 C
ATOM   1920  O   VAL A 204      10.613  14.194  -8.261  1.00 28.24    -0.271 OA
ATOM   1921  CB  VAL A 204      11.861  15.040  -5.310  1.00 28.80     0.009 C
ATOM   1922  CG1 VAL A 204      11.019  16.251  -5.760  1.00 27.63     0.012 C
ATOM   1923  CG2 VAL A 204      11.649  14.853  -3.802  1.00 28.87     0.012 C
ATOM   1924  H   VAL A 204      13.295  12.879  -5.281  1.00 29.18     0.163 HD
ATOM   1925  N   LEU A 205      12.853  13.942  -8.194  1.00 30.15    -0.346 N
ATOM   1926  CA  LEU A 205      13.100  14.074  -9.634  1.00 30.11     0.177 C
ATOM   1927  C   LEU A 205      12.497  12.911 -10.437  1.00 29.80     0.241 C
ATOM   1928  O   LEU A 205      12.000  13.136 -11.539  1.00 27.70    -0.271 OA
ATOM   1929  CB  LEU A 205      14.619  14.138  -9.891  1.00 28.62     0.038 C
ATOM   1930  CG  LEU A 205      15.293  15.436  -9.403  1.00 29.35    -0.020 C
ATOM   1931  CD1 LEU A 205      16.816  15.274  -9.342  1.00 28.50     0.009 C
ATOM   1932  CD2 LEU A 205      14.921  16.646 -10.272  1.00 28.88     0.009 C
ATOM   1933  H   LEU A 205      13.656  13.785  -7.599  1.00 30.15     0.163 HD
ATOM   1934  N   ALA A 206      12.483  11.697  -9.859  1.00 29.17    -0.346 N
ATOM   1935  CA  ALA A 206      11.859  10.501 -10.417  1.00 30.20     0.172 C
ATOM   1936  C   ALA A 206      10.328  10.597 -10.405  1.00 29.48     0.240 C
ATOM   1937  O   ALA A 206       9.688  10.220 -11.383  1.00 29.16    -0.271 OA
ATOM   1938  CB  ALA A 206      12.278   9.296  -9.568  1.00 31.31     0.042 C
ATOM   1939  H   ALA A 206      12.918  11.603  -8.952  1.00 29.17     0.163 HD
ATOM   1940  N   TRP A 207       9.744  11.126  -9.319  1.00 27.94    -0.346 N
ATOM   1941  CA  TRP A 207       8.310  11.358  -9.162  1.00 30.04     0.181 C
ATOM   1942  C   TRP A 207       7.809  12.544 -10.018  1.00 28.09     0.241 C
ATOM   1943  O   TRP A 207       6.640  12.550 -10.403  1.00 27.89    -0.271 OA
ATOM   1944  CB  TRP A 207       8.045  11.586  -7.661  1.00 30.69     0.075 C
ATOM   1945  CG  TRP A 207       6.701  12.117  -7.267  1.00 33.24    -0.028 A
ATOM   1946  CD1 TRP A 207       5.574  11.400  -7.059  1.00 32.21     0.096 A
ATOM   1947  CD2 TRP A 207       6.347  13.506  -7.025  1.00 32.08    -0.002 A
ATOM   1948  NE1 TRP A 207       4.556  12.250  -6.673  1.00 32.69    -0.365 N
ATOM   1949  CE2 TRP A 207       4.982  13.563  -6.619  1.00 32.68     0.042 A
ATOM   1950  CE3 TRP A 207       7.054  14.727  -7.100  1.00 32.36     0.014 A
ATOM   1951  CZ2 TRP A 207       4.365  14.771  -6.256  1.00 32.75     0.030 A
ATOM   1952  CZ3 TRP A 207       6.430  15.948  -6.792  1.00 33.44     0.001 A
ATOM   1953  CH2 TRP A 207       5.094  15.970  -6.352  1.00 33.34     0.002 A
ATOM   1954  H   TRP A 207      10.337  11.395  -8.545  1.00 27.94     0.163 HD
ATOM   1955  HE1 TRP A 207       3.626  11.925  -6.450  1.00 32.69     0.165 HD
ATOM   1956  N   LEU A 208       8.681  13.507 -10.371  1.00 26.61    -0.346 N
ATOM   1957  CA  LEU A 208       8.387  14.574 -11.330  1.00 27.07     0.177 C
ATOM   1958  C   LEU A 208       8.493  14.073 -12.785  1.00 26.45     0.241 C
ATOM   1959  O   LEU A 208       7.844  14.652 -13.651  1.00 28.10    -0.271 OA
ATOM   1960  CB  LEU A 208       9.366  15.757 -11.141  1.00 27.88     0.038 C
ATOM   1961  CG  LEU A 208       9.142  16.612  -9.874  1.00 29.58    -0.020 C
ATOM   1962  CD1 LEU A 208      10.348  17.529  -9.618  1.00 30.32     0.009 C
ATOM   1963  CD2 LEU A 208       7.851  17.442  -9.935  1.00 27.22     0.009 C
ATOM   1964  H   LEU A 208       9.616  13.471  -9.987  1.00 26.61     0.163 HD
ATOM   1965  N   TYR A 209       9.229  12.977 -13.060  1.00 25.15    -0.346 N
ATOM   1966  CA  TYR A 209       9.175  12.263 -14.341  1.00 27.35     0.180 C
ATOM   1967  C   TYR A 209       7.928  11.368 -14.420  1.00 29.37     0.241 C
ATOM   1968  O   TYR A 209       7.337  11.269 -15.493  1.00 30.57    -0.271 OA
ATOM   1969  CB  TYR A 209      10.416  11.360 -14.523  1.00 26.94     0.073 C
ATOM   1970  CG  TYR A 209      11.659  12.058 -15.038  1.00 29.03    -0.056 A
ATOM   1971  CD1 TYR A 209      11.628  12.700 -16.291  1.00 31.95     0.010 A
ATOM   1972  CD2 TYR A 209      12.860  12.034 -14.300  1.00 29.24     0.010 A
ATOM   1973  CE1 TYR A 209      12.775  13.343 -16.785  1.00 31.63     0.037 A
ATOM   1974  CE2 TYR A 209      14.011  12.678 -14.794  1.00 31.81     0.037 A
ATOM   1975  CZ  TYR A 209      13.963  13.335 -16.037  1.00 29.90     0.065 A
ATOM   1976  OH  TYR A 209      15.066  13.956 -16.533  1.00 30.82    -0.361 OA
ATOM   1977  H   TYR A 209       9.767  12.558 -12.314  1.00 25.15     0.163 HD
ATOM   1978  HH  TYR A 209      14.918  14.342 -17.385  1.00 30.82     0.217 HD
ATOM   1979  N   ALA A 210       7.497  10.769 -13.292  1.00 30.90    -0.346 N
ATOM   1980  CA  ALA A 210       6.276   9.968 -13.166  1.00 29.45     0.172 C
ATOM   1981  C   ALA A 210       5.017  10.812 -13.406  1.00 32.70     0.240 C
ATOM   1982  O   ALA A 210       4.048  10.327 -13.983  1.00 36.57    -0.271 OA
ATOM   1983  CB  ALA A 210       6.200   9.375 -11.749  1.00 30.77     0.042 C
ATOM   1984  H   ALA A 210       8.055  10.885 -12.457  1.00 30.90     0.163 HD
ATOM   1985  N   ALA A 211       5.063  12.088 -12.996  1.00 30.67    -0.346 N
ATOM   1986  CA  ALA A 211       4.027  13.088 -13.195  1.00 31.84     0.172 C
ATOM   1987  C   ALA A 211       3.867  13.465 -14.674  1.00 34.82     0.240 C
ATOM   1988  O   ALA A 211       2.736  13.518 -15.147  1.00 37.12    -0.271 OA
ATOM   1989  CB  ALA A 211       4.403  14.316 -12.365  1.00 32.63     0.042 C
ATOM   1990  H   ALA A 211       5.893  12.389 -12.504  1.00 30.67     0.163 HD
ATOM   1991  N   VAL A 212       4.977  13.660 -15.411  1.00 33.01    -0.346 N
ATOM   1992  CA  VAL A 212       4.988  13.959 -16.850  1.00 36.97     0.180 C
ATOM   1993  C   VAL A 212       4.492  12.770 -17.696  1.00 37.48     0.241 C
ATOM   1994  O   VAL A 212       3.809  12.995 -18.695  1.00 39.96    -0.271 OA
ATOM   1995  CB  VAL A 212       6.413  14.407 -17.281  1.00 36.25     0.009 C
ATOM   1996  CG1 VAL A 212       6.617  14.511 -18.808  1.00 37.47     0.012 C
ATOM   1997  CG2 VAL A 212       6.774  15.758 -16.645  1.00 34.58     0.012 C
ATOM   1998  H   VAL A 212       5.873  13.592 -14.949  1.00 33.01     0.163 HD
ATOM   1999  N   ILE A 213       4.796  11.523 -17.293  1.00 38.44    -0.346 N
ATOM   2000  CA  ILE A 213       4.319  10.288 -17.930  1.00 38.83     0.180 C
ATOM   2001  C   ILE A 213       2.788  10.119 -17.769  1.00 41.06     0.241 C
ATOM   2002  O   ILE A 213       2.157   9.509 -18.632  1.00 42.03    -0.271 OA
ATOM   2003  CB  ILE A 213       5.122   9.074 -17.360  1.00 40.32     0.013 C
ATOM   2004  CG1 ILE A 213       6.605   9.129 -17.807  1.00 41.91     0.002 C
ATOM   2005  CG2 ILE A 213       4.524   7.700 -17.740  1.00 45.85     0.012 C
ATOM   2006  CD1 ILE A 213       7.561   8.276 -16.956  1.00 41.59     0.005 C
ATOM   2007  H   ILE A 213       5.379  11.420 -16.472  1.00 38.44     0.163 HD
ATOM   2008  N   ASN A 214       2.196  10.691 -16.705  1.00 42.80    -0.346 N
ATOM   2009  CA  ASN A 214       0.772  10.603 -16.362  1.00 46.01     0.185 C
ATOM   2010  C   ASN A 214       0.018  11.939 -16.546  1.00 46.26     0.241 C
ATOM   2011  O   ASN A 214      -1.127  12.055 -16.110  1.00 53.40    -0.271 OA
ATOM   2012  CB  ASN A 214       0.626  10.023 -14.934  1.00 46.48     0.137 C
ATOM   2013  CG  ASN A 214       1.046   8.549 -14.859  1.00 50.29     0.217 C
ATOM   2014  OD1 ASN A 214       0.439   7.699 -15.504  1.00 52.59    -0.274 OA
ATOM   2015  ND2 ASN A 214       2.097   8.232 -14.103  1.00 48.84    -0.370 N
ATOM   2016  H   ASN A 214       2.786  11.194 -16.057  1.00 42.80     0.163 HD
ATOM   2017 2HD2 ASN A 214       2.395   7.269 -14.044  1.00 48.84     0.159 HD
ATOM   2018 1HD2 ASN A 214       2.627   8.961 -13.643  1.00 48.84     0.159 HD
ATOM   2019  N   GLY A 215       0.617  12.912 -17.256  1.00 44.89    -0.351 N
ATOM   2020  CA  GLY A 215      -0.049  14.092 -17.810  1.00 44.21     0.225 C
ATOM   2021  C   GLY A 215       0.041  15.396 -17.005  1.00 44.94     0.236 C
ATOM   2022  O   GLY A 215      -0.325  16.439 -17.547  1.00 45.98    -0.272 OA
ATOM   2023  H   GLY A 215       1.570  12.751 -17.549  1.00 44.89     0.163 HD
ATOM   2024  N   ASP A 216       0.547  15.376 -15.759  0.25 44.10    -0.346 N
ATOM   2025  CA  ASP A 216       0.795  16.573 -14.942  0.25 45.24     0.186 C
ATOM   2026  C   ASP A 216       2.141  17.182 -15.362  0.25 45.96     0.241 C
ATOM   2027  O   ASP A 216       3.195  16.577 -15.167  0.25 47.65    -0.271 OA
ATOM   2028  CB  ASP A 216       0.858  16.195 -13.441  0.25 46.08     0.147 C
ATOM   2029  CG  ASP A 216      -0.451  15.651 -12.859  0.25 46.12     0.175 C
ATOM   2030  OD1 ASP A 216      -1.527  16.000 -13.392  0.25 45.93    -0.648 OA
ATOM   2031  OD2 ASP A 216      -0.351  14.911 -11.858  0.25 48.07    -0.648 OA
ATOM   2032  H   ASP A 216       0.857  14.490 -15.384  0.25 44.10     0.163 HD
ATOM   2033  N   ARG A 217       2.085  18.366 -15.993  1.00 45.06    -0.346 N
ATOM   2034  CA  ARG A 217       3.196  19.005 -16.704  1.00 46.38     0.176 C
ATOM   2035  C   ARG A 217       3.306  20.517 -16.440  1.00 40.87     0.241 C
ATOM   2036  O   ARG A 217       4.126  21.173 -17.082  1.00 39.62    -0.271 OA
ATOM   2037  CB  ARG A 217       3.117  18.675 -18.217  1.00 58.32     0.036 C
ATOM   2038  CG  ARG A 217       3.264  17.185 -18.566  1.00 71.63     0.023 C
ATOM   2039  CD  ARG A 217       3.199  16.915 -20.072  1.00 81.65     0.138 C
ATOM   2040  NE  ARG A 217       3.097  15.471 -20.334  1.00 90.79    -0.227 N
ATOM   2041  CZ  ARG A 217       2.128  14.830 -21.011  1.00 92.22     0.665 C
ATOM   2042  NH1 ARG A 217       1.083  15.480 -21.543  1.00 94.14    -0.235 N
ATOM   2043  NH2 ARG A 217       2.206  13.501 -21.149  1.00 90.08    -0.235 N
ATOM   2044  H   ARG A 217       1.172  18.778 -16.119  1.00 45.06     0.163 HD
ATOM   2045  HE  ARG A 217       3.841  14.905 -19.946  1.00 90.79     0.177 HD
ATOM   2046 HH12 ARG A 217       0.364  14.978 -22.045  1.00 94.14     0.174 HD
ATOM   2047 HH11 ARG A 217       1.005  16.481 -21.437  1.00 94.14     0.174 HD
ATOM   2048 HH22 ARG A 217       1.499  12.989 -21.656  1.00 90.08     0.174 HD
ATOM   2049 HH21 ARG A 217       2.957  12.994 -20.699  1.00 90.08     0.174 HD
ATOM   2050  N   TRP A 218       2.500  21.083 -15.521  1.00 37.42    -0.346 N
ATOM   2051  CA  TRP A 218       2.414  22.529 -15.262  1.00 37.23     0.181 C
ATOM   2052  C   TRP A 218       3.702  23.148 -14.685  1.00 34.92     0.241 C
ATOM   2053  O   TRP A 218       3.941  24.342 -14.865  1.00 42.55    -0.271 OA
ATOM   2054  CB  TRP A 218       1.222  22.821 -14.320  1.00 38.17     0.075 C
ATOM   2055  CG  TRP A 218       1.245  22.243 -12.929  1.00 39.08    -0.028 A
ATOM   2056  CD1 TRP A 218       0.556  21.151 -12.525  1.00 39.46     0.096 A
ATOM   2057  CD2 TRP A 218       1.949  22.731 -11.741  1.00 37.36    -0.002 A
ATOM   2058  NE1 TRP A 218       0.774  20.936 -11.180  1.00 40.31    -0.365 N
ATOM   2059  CE2 TRP A 218       1.625  21.878 -10.643  1.00 38.67     0.042 A
ATOM   2060  CE3 TRP A 218       2.826  23.811 -11.472  1.00 37.21     0.014 A
ATOM   2061  CZ2 TRP A 218       2.135  22.090  -9.351  1.00 38.59     0.030 A
ATOM   2062  CZ3 TRP A 218       3.378  24.007 -10.191  1.00 38.09     0.001 A
ATOM   2063  CH2 TRP A 218       3.031  23.149  -9.132  1.00 39.85     0.002 A
ATOM   2064  H   TRP A 218       1.870  20.486 -15.007  1.00 37.42     0.163 HD
ATOM   2065  HE1 TRP A 218       0.333  20.179 -10.669  1.00 40.31     0.165 HD
ATOM   2066  N   PHE A 219       4.519  22.337 -13.997  1.00 35.76    -0.346 N
ATOM   2067  CA  PHE A 219       5.770  22.715 -13.339  1.00 36.26     0.180 C
ATOM   2068  C   PHE A 219       6.984  22.710 -14.287  1.00 35.39     0.241 C
ATOM   2069  O   PHE A 219       8.065  23.133 -13.874  1.00 36.32    -0.271 OA
ATOM   2070  CB  PHE A 219       6.020  21.712 -12.190  1.00 33.82     0.073 C
ATOM   2071  CG  PHE A 219       5.993  20.241 -12.577  1.00 34.56    -0.056 A
ATOM   2072  CD1 PHE A 219       7.143  19.606 -13.095  1.00 33.90     0.007 A
ATOM   2073  CD2 PHE A 219       4.796  19.509 -12.438  1.00 34.10     0.007 A
ATOM   2074  CE1 PHE A 219       7.090  18.255 -13.486  1.00 34.98     0.001 A
ATOM   2075  CE2 PHE A 219       4.747  18.155 -12.814  1.00 34.39     0.001 A
ATOM   2076  CZ  PHE A 219       5.891  17.533 -13.345  1.00 33.58     0.000 A
ATOM   2077  H   PHE A 219       4.245  21.369 -13.909  1.00 35.76     0.163 HD
ATOM   2078  N   LEU A 220       6.820  22.254 -15.543  1.00 37.75    -0.346 N
ATOM   2079  CA  LEU A 220       7.859  22.284 -16.569  1.00 40.76     0.177 C
ATOM   2080  C   LEU A 220       8.012  23.721 -17.082  1.00 42.33     0.241 C
ATOM   2081  O   LEU A 220       7.057  24.315 -17.584  1.00 44.96    -0.271 OA
ATOM   2082  CB  LEU A 220       7.485  21.358 -17.746  1.00 41.54     0.038 C
ATOM   2083  CG  LEU A 220       7.369  19.856 -17.402  1.00 40.27    -0.020 C
ATOM   2084  CD1 LEU A 220       7.056  19.060 -18.679  1.00 39.06     0.009 C
ATOM   2085  CD2 LEU A 220       8.629  19.300 -16.715  1.00 40.18     0.009 C
ATOM   2086  H   LEU A 220       5.903  21.935 -15.824  1.00 37.75     0.163 HD
ATOM   2087  N   ASN A 221       9.229  24.259 -16.928  0.25 41.98    -0.346 N
ATOM   2088  CA  ASN A 221       9.619  25.620 -17.290  0.25 41.46     0.185 C
ATOM   2089  C   ASN A 221      10.602  25.614 -18.470  0.25 43.11     0.241 C
ATOM   2090  O   ASN A 221      11.003  24.561 -18.968  0.25 42.11    -0.271 OA
ATOM   2091  CB  ASN A 221      10.185  26.371 -16.052  0.25 39.67     0.137 C
ATOM   2092  CG  ASN A 221      11.287  25.652 -15.259  0.25 38.78     0.217 C
ATOM   2093  OD1 ASN A 221      12.188  25.036 -15.824  0.25 34.68    -0.274 OA
ATOM   2094  ND2 ASN A 221      11.206  25.721 -13.932  0.25 38.53    -0.370 N
ATOM   2095  H   ASN A 221       9.955  23.679 -16.534  0.25 41.98     0.163 HD
ATOM   2096 2HD2 ASN A 221      11.920  25.283 -13.363  0.25 38.53     0.159 HD
ATOM   2097 1HD2 ASN A 221      10.449  26.227 -13.495  0.25 38.53     0.159 HD
ATOM   2098  N   ARG A 222      10.982  26.821 -18.908  1.00 45.17    -0.346 N
ATOM   2099  CA  ARG A 222      11.913  27.088 -20.003  1.00 49.55     0.176 C
ATOM   2100  C   ARG A 222      13.385  27.100 -19.533  1.00 46.49     0.241 C
ATOM   2101  O   ARG A 222      14.273  27.372 -20.340  1.00 42.80    -0.271 OA
ATOM   2102  CB  ARG A 222      11.578  28.496 -20.549  1.00 55.31     0.036 C
ATOM   2103  CG  ARG A 222      10.148  28.616 -21.106  1.00 58.92     0.023 C
ATOM   2104  CD  ARG A 222       9.843  30.015 -21.653  1.00 59.86     0.138 C
ATOM   2105  NE  ARG A 222       8.509  30.057 -22.269  1.00 60.31    -0.227 N
ATOM   2106  CZ  ARG A 222       8.228  29.799 -23.558  1.00 64.10     0.665 C
ATOM   2107  NH1 ARG A 222       9.188  29.459 -24.432  1.00 62.91    -0.235 N
ATOM   2108  NH2 ARG A 222       6.960  29.877 -23.979  1.00 62.52    -0.235 N
ATOM   2109  H   ARG A 222      10.604  27.628 -18.434  1.00 45.17     0.163 HD
ATOM   2110  HE  ARG A 222       7.747  30.283 -21.646  1.00 60.31     0.177 HD
ATOM   2111 HH12 ARG A 222       8.963  29.267 -25.397  1.00 62.91     0.174 HD
ATOM   2112 HH11 ARG A 222      10.147  29.392 -24.125  1.00 62.91     0.174 HD
ATOM   2113 HH22 ARG A 222       6.727  29.685 -24.943  1.00 62.52     0.174 HD
ATOM   2114 HH21 ARG A 222       6.223  30.130 -23.337  1.00 62.52     0.174 HD
ATOM   2115  N   PHE A 223      13.644  26.842 -18.240  1.00 40.83    -0.346 N
ATOM   2116  CA  PHE A 223      14.936  27.027 -17.583  1.00 39.17     0.180 C
ATOM   2117  C   PHE A 223      15.730  25.711 -17.519  1.00 35.97     0.241 C
ATOM   2118  O   PHE A 223      15.185  24.618 -17.680  1.00 33.56    -0.271 OA
ATOM   2119  CB  PHE A 223      14.675  27.493 -16.130  1.00 43.54     0.073 C
ATOM   2120  CG  PHE A 223      13.790  28.721 -15.946  1.00 47.32    -0.056 A
ATOM   2121  CD1 PHE A 223      13.735  29.753 -16.910  1.00 51.24     0.007 A
ATOM   2122  CD2 PHE A 223      13.004  28.826 -14.780  1.00 55.26     0.007 A
ATOM   2123  CE1 PHE A 223      12.881  30.857 -16.722  1.00 54.18     0.001 A
ATOM   2124  CE2 PHE A 223      12.154  29.932 -14.587  1.00 59.65     0.001 A
ATOM   2125  CZ  PHE A 223      12.088  30.945 -15.562  1.00 57.27     0.000 A
ATOM   2126  H   PHE A 223      12.872  26.565 -17.650  1.00 40.83     0.163 HD
ATOM   2127  N   THR A 224      17.033  25.851 -17.240  1.00 31.18    -0.344 N
ATOM   2128  CA  THR A 224      18.004  24.787 -16.994  1.00 32.33     0.205 C
ATOM   2129  C   THR A 224      18.948  25.216 -15.852  1.00 33.75     0.243 C
ATOM   2130  O   THR A 224      19.009  26.396 -15.500  1.00 33.79    -0.271 OA
ATOM   2131  CB  THR A 224      18.671  24.341 -18.321  1.00 34.22     0.146 C
ATOM   2132  OG1 THR A 224      19.387  23.135 -18.140  1.00 32.88    -0.393 OA
ATOM   2133  CG2 THR A 224      19.630  25.381 -18.925  1.00 36.54     0.042 C
ATOM   2134  H   THR A 224      17.383  26.790 -17.109  1.00 31.18     0.163 HD
ATOM   2135  HG1 THR A 224      18.770  22.417 -18.218  1.00 32.88     0.210 HD
ATOM   2136  N   THR A 225      19.675  24.255 -15.266  1.00 35.27    -0.344 N
ATOM   2137  CA  THR A 225      20.618  24.439 -14.160  1.00 33.48     0.205 C
ATOM   2138  C   THR A 225      21.824  23.497 -14.330  1.00 31.69     0.243 C
ATOM   2139  O   THR A 225      21.781  22.577 -15.144  1.00 31.85    -0.271 OA
ATOM   2140  CB  THR A 225      19.860  24.373 -12.801  1.00 35.32     0.146 C
ATOM   2141  OG1 THR A 225      20.705  24.662 -11.708  1.00 35.38    -0.393 OA
ATOM   2142  CG2 THR A 225      19.225  23.011 -12.497  1.00 37.20     0.042 C
ATOM   2143  H   THR A 225      19.585  23.313 -15.625  1.00 35.27     0.163 HD
ATOM   2144  HG1 THR A 225      20.989  25.568 -11.766  1.00 35.38     0.210 HD
ATOM   2145  N   THR A 226      22.898  23.716 -13.560  1.00 32.15    -0.344 N
ATOM   2146  CA  THR A 226      24.002  22.766 -13.377  1.00 34.83     0.205 C
ATOM   2147  C   THR A 226      23.791  22.031 -12.039  1.00 32.31     0.243 C
ATOM   2148  O   THR A 226      22.958  22.443 -11.228  1.00 28.18    -0.271 OA
ATOM   2149  CB  THR A 226      25.358  23.524 -13.378  1.00 36.65     0.146 C
ATOM   2150  OG1 THR A 226      25.522  24.379 -12.262  1.00 33.65    -0.393 OA
ATOM   2151  CG2 THR A 226      25.610  24.325 -14.665  1.00 40.29     0.042 C
ATOM   2152  H   THR A 226      22.849  24.483 -12.904  1.00 32.15     0.163 HD
ATOM   2153  HG1 THR A 226      24.934  25.112 -12.358  1.00 33.65     0.210 HD
ATOM   2154  N   LEU A 227      24.559  20.954 -11.789  1.00 34.16    -0.346 N
ATOM   2155  CA  LEU A 227      24.537  20.219 -10.518  1.00 33.85     0.177 C
ATOM   2156  C   LEU A 227      24.955  21.093  -9.325  1.00 34.59     0.241 C
ATOM   2157  O   LEU A 227      24.330  20.999  -8.274  1.00 32.89    -0.271 OA
ATOM   2158  CB  LEU A 227      25.446  18.967 -10.580  1.00 37.03     0.038 C
ATOM   2159  CG  LEU A 227      24.916  17.797 -11.436  1.00 38.80    -0.020 C
ATOM   2160  CD1 LEU A 227      25.942  16.652 -11.488  1.00 39.49     0.009 C
ATOM   2161  CD2 LEU A 227      23.567  17.268 -10.923  1.00 39.26     0.009 C
ATOM   2162  H   LEU A 227      25.214  20.648 -12.493  1.00 34.16     0.163 HD
ATOM   2163  N   ASN A 228      25.960  21.969  -9.493  1.00 36.59    -0.346 N
ATOM   2164  CA  ASN A 228      26.463  22.855  -8.440  1.00 35.94     0.185 C
ATOM   2165  C   ASN A 228      25.492  24.010  -8.139  1.00 35.06     0.241 C
ATOM   2166  O   ASN A 228      25.285  24.314  -6.966  1.00 35.19    -0.271 OA
ATOM   2167  CB  ASN A 228      27.834  23.447  -8.852  1.00 40.70     0.137 C
ATOM   2168  CG  ASN A 228      28.986  22.439  -8.991  1.00 41.37     0.217 C
ATOM   2169  OD1 ASN A 228      30.000  22.760  -9.606  1.00 44.40    -0.274 OA
ATOM   2170  ND2 ASN A 228      28.873  21.238  -8.416  1.00 39.36    -0.370 N
ATOM   2171  H   ASN A 228      26.407  22.018 -10.397  1.00 36.59     0.163 HD
ATOM   2172 2HD2 ASN A 228      29.634  20.579  -8.495  1.00 39.36     0.159 HD
ATOM   2173 1HD2 ASN A 228      28.035  20.992  -7.911  1.00 39.36     0.159 HD
ATOM   2174  N   ASP A 229      24.868  24.613  -9.169  1.00 35.36    -0.345 N
ATOM   2175  CA  ASP A 229      23.859  25.674  -9.038  1.00 36.43     0.186 C
ATOM   2176  C   ASP A 229      22.572  25.156  -8.364  1.00 34.22     0.241 C
ATOM   2177  O   ASP A 229      21.993  25.848  -7.526  1.00 32.53    -0.271 OA
ATOM   2178  CB  ASP A 229      23.583  26.283 -10.439  1.00 37.53     0.147 C
ATOM   2179  CG  ASP A 229      22.446  27.315 -10.523  1.00 41.12     0.175 C
ATOM   2180  OD1 ASP A 229      22.347  28.161  -9.609  1.00 41.89    -0.648 OA
ATOM   2181  OD2 ASP A 229      21.683  27.240 -11.512  1.00 40.34    -0.648 OA
ATOM   2182  H   ASP A 229      25.088  24.302 -10.105  1.00 35.36     0.163 HD
ATOM   2183  N   PHE A 230      22.165  23.918  -8.690  1.00 31.80    -0.346 N
ATOM   2184  CA  PHE A 230      21.030  23.234  -8.081  1.00 33.90     0.180 C
ATOM   2185  C   PHE A 230      21.322  22.812  -6.627  1.00 32.11     0.241 C
ATOM   2186  O   PHE A 230      20.419  22.893  -5.797  1.00 30.79    -0.271 OA
ATOM   2187  CB  PHE A 230      20.678  21.992  -8.928  1.00 32.07     0.073 C
ATOM   2188  CG  PHE A 230      19.541  21.174  -8.346  1.00 34.99    -0.056 A
ATOM   2189  CD1 PHE A 230      18.227  21.686  -8.344  1.00 35.02     0.007 A
ATOM   2190  CD2 PHE A 230      19.820  19.951  -7.707  1.00 35.50     0.007 A
ATOM   2191  CE1 PHE A 230      17.199  20.993  -7.675  1.00 34.72     0.001 A
ATOM   2192  CE2 PHE A 230      18.795  19.266  -7.035  1.00 34.45     0.001 A
ATOM   2193  CZ  PHE A 230      17.489  19.789  -7.006  1.00 34.03     0.000 A
ATOM   2194  H   PHE A 230      22.678  23.416  -9.402  1.00 31.80     0.163 HD
ATOM   2195  N   ASN A 231      22.554  22.377  -6.303  1.00 35.24    -0.346 N
ATOM   2196  CA  ASN A 231      22.927  21.927  -4.956  1.00 37.31     0.185 C
ATOM   2197  C   ASN A 231      23.120  23.070  -3.940  1.00 39.22     0.241 C
ATOM   2198  O   ASN A 231      23.156  22.790  -2.743  1.00 39.06    -0.271 OA
ATOM   2199  CB  ASN A 231      24.189  21.027  -4.989  1.00 34.46     0.137 C
ATOM   2200  CG  ASN A 231      23.929  19.618  -5.544  1.00 36.88     0.217 C
ATOM   2201  OD1 ASN A 231      22.796  19.140  -5.570  1.00 39.71    -0.274 OA
ATOM   2202  ND2 ASN A 231      24.983  18.946  -6.014  1.00 28.64    -0.370 N
ATOM   2203  H   ASN A 231      23.253  22.309  -7.031  1.00 35.24     0.163 HD
ATOM   2204 2HD2 ASN A 231      24.852  18.024  -6.411  1.00 28.64     0.159 HD
ATOM   2205 1HD2 ASN A 231      25.901  19.362  -5.988  1.00 28.64     0.159 HD
ATOM   2206  N   LEU A 232      23.155  24.342  -4.380  1.00 39.40    -0.346 N
ATOM   2207  CA  LEU A 232      23.067  25.518  -3.505  1.00 39.15     0.177 C
ATOM   2208  C   LEU A 232      21.617  25.746  -3.035  1.00 41.41     0.241 C
ATOM   2209  O   LEU A 232      21.406  26.168  -1.898  1.00 40.83    -0.271 OA
ATOM   2210  CB  LEU A 232      23.517  26.778  -4.280  1.00 42.48     0.038 C
ATOM   2211  CG  LEU A 232      25.025  26.843  -4.601  1.00 44.02    -0.020 C
ATOM   2212  CD1 LEU A 232      25.308  27.934  -5.644  1.00 46.16     0.009 C
ATOM   2213  CD2 LEU A 232      25.885  27.066  -3.346  1.00 43.55     0.009 C
ATOM   2214  H   LEU A 232      23.143  24.503  -5.377  1.00 39.40     0.163 HD
ATOM   2215  N   VAL A 233      20.628  25.427  -3.888  1.00 42.64    -0.346 N
ATOM   2216  CA  VAL A 233      19.198  25.465  -3.576  1.00 40.03     0.180 C
ATOM   2217  C   VAL A 233      18.817  24.218  -2.753  1.00 37.69     0.241 C
ATOM   2218  O   VAL A 233      17.988  24.323  -1.852  1.00 39.13    -0.271 OA
ATOM   2219  CB  VAL A 233      18.378  25.522  -4.899  1.00 39.23     0.009 C
ATOM   2220  CG1 VAL A 233      16.854  25.604  -4.669  1.00 42.68     0.012 C
ATOM   2221  CG2 VAL A 233      18.820  26.699  -5.789  1.00 37.93     0.012 C
ATOM   2222  H   VAL A 233      20.885  25.083  -4.802  1.00 42.64     0.163 HD
ATOM   2223  N   ALA A 234      19.458  23.060  -3.001  1.00 41.09    -0.346 N
ATOM   2224  CA  ALA A 234      19.237  21.828  -2.245  1.00 42.26     0.172 C
ATOM   2225  C   ALA A 234      19.742  21.942  -0.796  1.00 42.95     0.240 C
ATOM   2226  O   ALA A 234      19.084  21.445   0.113  1.00 44.15    -0.271 OA
ATOM   2227  CB  ALA A 234      19.945  20.651  -2.935  1.00 41.33     0.042 C
ATOM   2228  H   ALA A 234      20.114  23.028  -3.771  1.00 41.09     0.163 HD
ATOM   2229  N   MET A 235      20.858  22.659  -0.573  1.00 47.20    -0.346 N
ATOM   2230  CA  MET A 235      21.421  22.972   0.743  1.00 50.99     0.177 C
ATOM   2231  C   MET A 235      20.478  23.870   1.571  1.00 43.29     0.241 C
ATOM   2232  O   MET A 235      20.351  23.668   2.778  1.00 38.36    -0.271 OA
ATOM   2233  CB  MET A 235      22.777  23.684   0.524  1.00 59.59     0.045 C
ATOM   2234  CG  MET A 235      23.622  23.895   1.793  1.00 69.13     0.076 C
ATOM   2235  SD  MET A 235      24.392  22.399   2.470  1.00 78.21    -0.173 SA
ATOM   2236  CE  MET A 235      25.789  22.218   1.328  1.00 77.58     0.089 C
ATOM   2237  H   MET A 235      21.347  23.030  -1.377  1.00 47.20     0.163 HD
ATOM   2238  N   LYS A 236      19.813  24.838   0.916  1.00 38.04    -0.346 N
ATOM   2239  CA  LYS A 236      18.917  25.822   1.524  1.00 40.98     0.176 C
ATOM   2240  C   LYS A 236      17.587  25.210   2.008  1.00 38.55     0.241 C
ATOM   2241  O   LYS A 236      17.084  25.629   3.049  1.00 37.96    -0.271 OA
ATOM   2242  CB  LYS A 236      18.655  26.927   0.472  1.00 46.67     0.035 C
ATOM   2243  CG  LYS A 236      17.636  28.006   0.885  1.00 55.93     0.004 C
ATOM   2244  CD  LYS A 236      17.597  29.190  -0.093  1.00 67.03     0.027 C
ATOM   2245  CE  LYS A 236      16.399  30.123   0.137  1.00 67.57     0.229 C
ATOM   2246  NZ  LYS A 236      16.442  30.765   1.462  1.00 70.13    -0.079 N
ATOM   2247  H   LYS A 236      19.970  24.922  -0.078  1.00 38.04     0.163 HD
ATOM   2248  HZ1 LYS A 236      16.416  30.053   2.179  1.00 70.13     0.274 HD
ATOM   2249  HZ2 LYS A 236      17.292  31.302   1.553  1.00 70.13     0.274 HD
ATOM   2250  HZ3 LYS A 236      15.643  31.374   1.568  1.00 70.13     0.274 HD
ATOM   2251  N   TYR A 237      17.023  24.246   1.262  1.00 36.18    -0.346 N
ATOM   2252  CA  TYR A 237      15.706  23.655   1.525  1.00 36.96     0.180 C
ATOM   2253  C   TYR A 237      15.783  22.254   2.159  1.00 35.70     0.241 C
ATOM   2254  O   TYR A 237      14.742  21.627   2.356  1.00 35.45    -0.271 OA
ATOM   2255  CB  TYR A 237      14.912  23.622   0.198  1.00 37.48     0.073 C
ATOM   2256  CG  TYR A 237      14.409  24.996  -0.213  1.00 39.53    -0.056 A
ATOM   2257  CD1 TYR A 237      13.357  25.596   0.509  1.00 43.82     0.010 A
ATOM   2258  CD2 TYR A 237      15.002  25.697  -1.284  1.00 38.17     0.010 A
ATOM   2259  CE1 TYR A 237      12.925  26.896   0.186  1.00 44.93     0.037 A
ATOM   2260  CE2 TYR A 237      14.575  26.999  -1.607  1.00 41.83     0.037 A
ATOM   2261  CZ  TYR A 237      13.542  27.602  -0.864  1.00 45.20     0.065 A
ATOM   2262  OH  TYR A 237      13.141  28.871  -1.161  1.00 48.81    -0.361 OA
ATOM   2263  H   TYR A 237      17.498  23.958   0.418  1.00 36.18     0.163 HD
ATOM   2264  HH  TYR A 237      12.357  29.127  -0.698  1.00 48.81     0.217 HD
ATOM   2265  N   ASN A 238      16.994  21.770   2.496  1.00 33.80    -0.346 N
ATOM   2266  CA  ASN A 238      17.271  20.497   3.176  1.00 38.68     0.185 C
ATOM   2267  C   ASN A 238      16.938  19.293   2.283  1.00 35.13     0.241 C
ATOM   2268  O   ASN A 238      16.213  18.386   2.677  1.00 37.88    -0.271 OA
ATOM   2269  CB  ASN A 238      16.672  20.412   4.605  1.00 41.59     0.137 C
ATOM   2270  CG  ASN A 238      17.326  21.402   5.572  1.00 46.12     0.217 C
ATOM   2271  OD1 ASN A 238      16.817  22.500   5.782  1.00 52.36    -0.274 OA
ATOM   2272  ND2 ASN A 238      18.450  21.012   6.174  1.00 45.82    -0.370 N
ATOM   2273  H   ASN A 238      17.793  22.354   2.294  1.00 33.80     0.163 HD
ATOM   2274 2HD2 ASN A 238      18.909  21.639   6.819  1.00 45.82     0.159 HD
ATOM   2275 1HD2 ASN A 238      18.843  20.103   5.980  1.00 45.82     0.159 HD
ATOM   2276  N   TYR A 239      17.458  19.327   1.054  1.00 34.30    -0.346 N
ATOM   2277  CA  TYR A 239      17.448  18.262   0.063  1.00 33.72     0.180 C
ATOM   2278  C   TYR A 239      18.872  17.692  -0.020  1.00 34.95     0.241 C
ATOM   2279  O   TYR A 239      19.852  18.425   0.127  1.00 34.08    -0.271 OA
ATOM   2280  CB  TYR A 239      17.048  18.876  -1.298  1.00 31.42     0.073 C
ATOM   2281  CG  TYR A 239      15.566  18.822  -1.618  1.00 28.94    -0.056 A
ATOM   2282  CD1 TYR A 239      14.626  19.463  -0.785  1.00 29.72     0.010 A
ATOM   2283  CD2 TYR A 239      15.120  18.121  -2.757  1.00 30.38     0.010 A
ATOM   2284  CE1 TYR A 239      13.251  19.361  -1.066  1.00 31.59     0.037 A
ATOM   2285  CE2 TYR A 239      13.749  18.027  -3.046  1.00 27.72     0.037 A
ATOM   2286  CZ  TYR A 239      12.813  18.641  -2.195  1.00 27.80     0.065 A
ATOM   2287  OH  TYR A 239      11.481  18.526  -2.459  1.00 27.30    -0.361 OA
ATOM   2288  H   TYR A 239      18.020  20.136   0.815  1.00 34.30     0.163 HD
ATOM   2289  HH  TYR A 239      11.294  17.982  -3.208  1.00 27.30     0.217 HD
ATOM   2290  N   GLU A 240      18.978  16.381  -0.279  1.00 37.76    -0.346 N
ATOM   2291  CA  GLU A 240      20.231  15.637  -0.430  1.00 40.82     0.177 C
ATOM   2292  C   GLU A 240      21.028  16.131  -1.662  1.00 38.46     0.243 C
ATOM   2293  O   GLU A 240      20.428  16.267  -2.729  1.00 31.92    -0.271 OA
ATOM   2294  CB  GLU A 240      19.880  14.142  -0.618  1.00 46.94     0.045 C
ATOM   2295  CG  GLU A 240      19.445  13.425   0.675  1.00 53.56     0.116 C
ATOM   2296  CD  GLU A 240      20.620  13.197   1.627  1.00 63.84     0.172 C
ATOM   2297  OE1 GLU A 240      21.300  12.164   1.455  1.00 69.51    -0.648 OA
ATOM   2298  OE2 GLU A 240      20.825  14.069   2.501  1.00 63.01    -0.648 OA
ATOM   2299  H   GLU A 240      18.122  15.851  -0.383  1.00 37.76     0.163 HD
ATOM   2300  N   PRO A 241      22.354  16.399  -1.553  1.00 40.92    -0.337 N
ATOM   2301  CA  PRO A 241      23.230  16.750  -2.688  1.00 40.68     0.179 C
ATOM   2302  C   PRO A 241      23.133  15.749  -3.854  1.00 37.84     0.241 C
ATOM   2303  O   PRO A 241      23.366  14.553  -3.670  1.00 40.94    -0.271 OA
ATOM   2304  CB  PRO A 241      24.655  16.767  -2.112  1.00 43.30     0.037 C
ATOM   2305  CG  PRO A 241      24.475  17.017  -0.626  1.00 42.08     0.022 C
ATOM   2306  CD  PRO A 241      23.093  16.460  -0.291  1.00 42.20     0.127 C
ATOM   2307  N   LEU A 242      22.754  16.246  -5.040  1.00 35.46    -0.346 N
ATOM   2308  CA  LEU A 242      22.539  15.444  -6.237  1.00 37.69     0.177 C
ATOM   2309  C   LEU A 242      23.893  15.222  -6.927  1.00 35.64     0.241 C
ATOM   2310  O   LEU A 242      24.552  16.171  -7.356  1.00 32.62    -0.271 OA
ATOM   2311  CB  LEU A 242      21.581  16.209  -7.176  1.00 36.93     0.038 C
ATOM   2312  CG  LEU A 242      21.053  15.382  -8.371  1.00 38.85    -0.020 C
ATOM   2313  CD1 LEU A 242      20.065  14.288  -7.938  1.00 35.88     0.009 C
ATOM   2314  CD2 LEU A 242      20.377  16.301  -9.388  1.00 38.63     0.009 C
ATOM   2315  H   LEU A 242      22.591  17.242  -5.117  1.00 35.46     0.163 HD
ATOM   2316  N   THR A 243      24.290  13.946  -7.009  1.00 36.54    -0.344 N
ATOM   2317  CA  THR A 243      25.517  13.461  -7.638  1.00 38.58     0.205 C
ATOM   2318  C   THR A 243      25.254  13.136  -9.121  1.00 39.10     0.243 C
ATOM   2319  O   THR A 243      24.106  13.112  -9.567  1.00 36.76    -0.271 OA
ATOM   2320  CB  THR A 243      25.970  12.175  -6.891  1.00 37.69     0.146 C
ATOM   2321  OG1 THR A 243      25.059  11.102  -7.046  1.00 37.00    -0.393 OA
ATOM   2322  CG2 THR A 243      26.230  12.394  -5.391  1.00 37.49     0.042 C
ATOM   2323  H   THR A 243      23.669  13.245  -6.630  1.00 36.54     0.163 HD
ATOM   2324  HG1 THR A 243      24.264  11.309  -6.576  1.00 37.00     0.210 HD
ATOM   2325  N   GLN A 244      26.324  12.845  -9.881  1.00 37.74    -0.346 N
ATOM   2326  CA  GLN A 244      26.230  12.355 -11.259  1.00 38.19     0.177 C
ATOM   2327  C   GLN A 244      25.696  10.909 -11.321  1.00 35.57     0.241 C
ATOM   2328  O   GLN A 244      25.067  10.552 -12.313  1.00 34.79    -0.271 OA
ATOM   2329  CB  GLN A 244      27.620  12.454 -11.933  1.00 39.99     0.044 C
ATOM   2330  CG  GLN A 244      27.681  12.006 -13.415  1.00 39.31     0.105 C
ATOM   2331  CD  GLN A 244      26.727  12.784 -14.331  1.00 40.28     0.215 C
ATOM   2332  OE1 GLN A 244      26.640  14.008 -14.252  1.00 43.05    -0.274 OA
ATOM   2333  NE2 GLN A 244      25.995  12.078 -15.195  1.00 40.42    -0.370 N
ATOM   2334  H   GLN A 244      27.243  12.887  -9.466  1.00 37.74     0.163 HD
ATOM   2335 2HE2 GLN A 244      25.356  12.555 -15.813  1.00 40.42     0.159 HD
ATOM   2336 1HE2 GLN A 244      26.038  11.063 -15.203  1.00 40.42     0.159 HD
ATOM   2337  N   ASP A 245      25.874  10.102 -10.258  1.00 34.26    -0.346 N
ATOM   2338  CA  ASP A 245      25.312   8.750 -10.136  1.00 33.88     0.186 C
ATOM   2339  C   ASP A 245      23.775   8.779 -10.096  1.00 31.60     0.241 C
ATOM   2340  O   ASP A 245      23.139   7.919 -10.698  1.00 33.11    -0.271 OA
ATOM   2341  CB  ASP A 245      25.830   8.032  -8.864  1.00 38.87     0.147 C
ATOM   2342  CG  ASP A 245      27.352   7.911  -8.725  1.00 40.81     0.175 C
ATOM   2343  OD1 ASP A 245      28.063   8.106  -9.735  1.00 40.91    -0.648 OA
ATOM   2344  OD2 ASP A 245      27.781   7.602  -7.592  1.00 45.89    -0.648 OA
ATOM   2345  H   ASP A 245      26.408  10.449  -9.474  1.00 34.26     0.163 HD
ATOM   2346  N   HIS A 246      23.185   9.799  -9.450  1.00 30.48    -0.346 N
ATOM   2347  CA  HIS A 246      21.743  10.040  -9.407  1.00 29.71     0.182 C
ATOM   2348  C   HIS A 246      21.180  10.466 -10.775  1.00 30.78     0.241 C
ATOM   2349  O   HIS A 246      20.059  10.082 -11.098  1.00 32.74    -0.271 OA
ATOM   2350  CB  HIS A 246      21.445  11.142  -8.372  1.00 31.78     0.095 C
ATOM   2351  CG  HIS A 246      21.765  10.803  -6.936  1.00 32.45     0.053 A
ATOM   2352  ND1 HIS A 246      22.101  11.787  -5.999  1.00 30.77    -0.247 NA
ATOM   2353  CD2 HIS A 246      21.758   9.578  -6.301  1.00 32.95     0.116 A
ATOM   2354  CE1 HIS A 246      22.282  11.135  -4.860  1.00 31.34     0.207 A
ATOM   2355  NE2 HIS A 246      22.094   9.821  -4.981  1.00 32.23    -0.359 N
ATOM   2356  H   HIS A 246      23.783  10.473  -8.991  1.00 30.48     0.163 HD
ATOM   2357  HE2 HIS A 246      22.180   9.134  -4.245  1.00 32.23     0.166 HD
ATOM   2358  N   VAL A 247      21.963  11.197 -11.592  1.00 28.41    -0.346 N
ATOM   2359  CA  VAL A 247      21.627  11.587 -12.968  1.00 27.44     0.180 C
ATOM   2360  C   VAL A 247      21.626  10.369 -13.913  1.00 28.68     0.241 C
ATOM   2361  O   VAL A 247      20.766  10.292 -14.790  1.00 29.74    -0.271 OA
ATOM   2362  CB  VAL A 247      22.620  12.681 -13.463  1.00 26.72     0.009 C
ATOM   2363  CG1 VAL A 247      22.486  13.038 -14.958  1.00 27.47     0.012 C
ATOM   2364  CG2 VAL A 247      22.513  13.970 -12.633  1.00 28.35     0.012 C
ATOM   2365  H   VAL A 247      22.878  11.463 -11.254  1.00 28.41     0.163 HD
ATOM   2366  N   ASP A 248      22.551   9.412 -13.718  1.00 28.84    -0.345 N
ATOM   2367  CA  ASP A 248      22.664   8.182 -14.510  1.00 30.99     0.186 C
ATOM   2368  C   ASP A 248      21.526   7.188 -14.206  1.00 31.40     0.241 C
ATOM   2369  O   ASP A 248      21.062   6.507 -15.120  1.00 31.13    -0.271 OA
ATOM   2370  CB  ASP A 248      24.021   7.483 -14.237  1.00 32.88     0.147 C
ATOM   2371  CG  ASP A 248      25.269   8.323 -14.545  1.00 33.08     0.175 C
ATOM   2372  OD1 ASP A 248      25.185   9.210 -15.423  1.00 33.35    -0.648 OA
ATOM   2373  OD2 ASP A 248      26.303   8.050 -13.898  1.00 40.47    -0.648 OA
ATOM   2374  H   ASP A 248      23.243   9.558 -12.995  1.00 28.84     0.163 HD
ATOM   2375  N   ILE A 249      21.050   7.134 -12.948  1.00 31.80    -0.346 N
ATOM   2376  CA  ILE A 249      19.934   6.288 -12.504  1.00 36.99     0.180 C
ATOM   2377  C   ILE A 249      18.572   6.924 -12.893  1.00 35.61     0.241 C
ATOM   2378  O   ILE A 249      17.602   6.191 -13.085  1.00 35.75    -0.271 OA
ATOM   2379  CB  ILE A 249      20.060   6.045 -10.966  1.00 41.90     0.013 C
ATOM   2380  CG1 ILE A 249      21.366   5.289 -10.611  1.00 45.39     0.002 C
ATOM   2381  CG2 ILE A 249      18.876   5.251 -10.378  1.00 42.81     0.012 C
ATOM   2382  CD1 ILE A 249      21.774   5.411  -9.133  1.00 46.77     0.005 C
ATOM   2383  H   ILE A 249      21.498   7.710 -12.249  1.00 31.80     0.163 HD
ATOM   2384  N   LEU A 250      18.508   8.256 -13.089  1.00 33.69    -0.346 N
ATOM   2385  CA  LEU A 250      17.371   8.979 -13.679  1.00 33.77     0.177 C
ATOM   2386  C   LEU A 250      17.407   8.972 -15.226  1.00 33.78     0.240 C
ATOM   2387  O   LEU A 250      16.481   9.489 -15.851  1.00 37.45    -0.271 OA
ATOM   2388  CB  LEU A 250      17.410  10.455 -13.205  1.00 30.15     0.038 C
ATOM   2389  CG  LEU A 250      16.939  10.675 -11.751  1.00 29.96    -0.020 C
ATOM   2390  CD1 LEU A 250      17.376  12.055 -11.235  1.00 30.68     0.009 C
ATOM   2391  CD2 LEU A 250      15.416  10.535 -11.612  1.00 29.81     0.009 C
ATOM   2392  H   LEU A 250      19.336   8.800 -12.888  1.00 33.69     0.163 HD
ATOM   2393  N   GLY A 251      18.442   8.370 -15.839  1.00 34.29    -0.351 N
ATOM   2394  CA  GLY A 251      18.665   8.235 -17.279  1.00 34.14     0.225 C
ATOM   2395  C   GLY A 251      17.517   7.583 -18.075  1.00 30.93     0.238 C
ATOM   2396  O   GLY A 251      17.081   8.192 -19.051  1.00 34.64    -0.272 OA
ATOM   2397  H   GLY A 251      19.155   7.972 -15.244  1.00 34.29     0.163 HD
ATOM   2398  N   PRO A 252      17.003   6.388 -17.691  1.00 32.02    -0.337 N
ATOM   2399  CA  PRO A 252      15.834   5.734 -18.314  1.00 32.46     0.179 C
ATOM   2400  C   PRO A 252      14.558   6.597 -18.415  1.00 32.28     0.241 C
ATOM   2401  O   PRO A 252      13.845   6.511 -19.413  1.00 35.22    -0.271 OA
ATOM   2402  CB  PRO A 252      15.548   4.505 -17.435  1.00 31.81     0.037 C
ATOM   2403  CG  PRO A 252      16.879   4.174 -16.787  1.00 31.07     0.022 C
ATOM   2404  CD  PRO A 252      17.610   5.511 -16.687  1.00 32.80     0.127 C
ATOM   2405  N   LEU A 253      14.286   7.431 -17.396  1.00 33.07    -0.346 N
ATOM   2406  CA  LEU A 253      13.118   8.312 -17.321  1.00 34.36     0.177 C
ATOM   2407  C   LEU A 253      13.338   9.622 -18.098  1.00 34.23     0.241 C
ATOM   2408  O   LEU A 253      12.380  10.174 -18.642  1.00 35.71    -0.271 OA
ATOM   2409  CB  LEU A 253      12.869   8.673 -15.841  1.00 33.45     0.038 C
ATOM   2410  CG  LEU A 253      12.470   7.488 -14.936  1.00 35.60    -0.020 C
ATOM   2411  CD1 LEU A 253      12.432   7.918 -13.463  1.00 34.29     0.009 C
ATOM   2412  CD2 LEU A 253      11.122   6.875 -15.348  1.00 39.46     0.009 C
ATOM   2413  H   LEU A 253      14.927   7.453 -16.616  1.00 33.07     0.163 HD
ATOM   2414  N   SER A 254      14.595  10.086 -18.192  1.00 33.59    -0.344 N
ATOM   2415  CA  SER A 254      15.023  11.239 -18.982  1.00 35.70     0.200 C
ATOM   2416  C   SER A 254      14.970  10.947 -20.494  1.00 35.54     0.243 C
ATOM   2417  O   SER A 254      14.654  11.843 -21.276  1.00 40.19    -0.271 OA
ATOM   2418  CB  SER A 254      16.458  11.601 -18.539  1.00 36.72     0.199 C
ATOM   2419  OG  SER A 254      16.983  12.704 -19.246  1.00 41.25    -0.398 OA
ATOM   2420  H   SER A 254      15.319   9.581 -17.700  1.00 33.59     0.163 HD
ATOM   2421  HG  SER A 254      16.354  13.412 -19.204  1.00 41.25     0.209 HD
ATOM   2422  N   ALA A 255      15.223   9.689 -20.892  1.00 35.37    -0.346 N
ATOM   2423  CA  ALA A 255      15.150   9.202 -22.266  1.00 35.78     0.172 C
ATOM   2424  C   ALA A 255      13.707   8.878 -22.696  1.00 39.59     0.240 C
ATOM   2425  O   ALA A 255      13.408   8.954 -23.887  1.00 35.51    -0.271 OA
ATOM   2426  CB  ALA A 255      15.969   7.903 -22.344  1.00 35.14     0.042 C
ATOM   2427  H   ALA A 255      15.499   9.021 -20.185  1.00 35.37     0.163 HD
ATOM   2428  N   GLN A 256      12.818   8.537 -21.745  1.00 42.41    -0.346 N
ATOM   2429  CA  GLN A 256      11.413   8.200 -21.986  1.00 45.57     0.177 C
ATOM   2430  C   GLN A 256      10.566   9.461 -22.244  1.00 45.94     0.241 C
ATOM   2431  O   GLN A 256       9.766   9.470 -23.179  1.00 46.87    -0.271 OA
ATOM   2432  CB  GLN A 256      10.876   7.436 -20.752  1.00 52.12     0.044 C
ATOM   2433  CG  GLN A 256       9.376   7.056 -20.814  1.00 55.50     0.105 C
ATOM   2434  CD  GLN A 256       8.877   6.160 -19.672  1.00 60.89     0.215 C
ATOM   2435  OE1 GLN A 256       7.688   5.855 -19.615  1.00 58.11    -0.274 OA
ATOM   2436  NE2 GLN A 256       9.749   5.735 -18.754  1.00 64.14    -0.370 N
ATOM   2437  H   GLN A 256      13.147   8.483 -20.791  1.00 42.41     0.163 HD
ATOM   2438 2HE2 GLN A 256       9.426   5.145 -18.001  1.00 64.14     0.159 HD
ATOM   2439 1HE2 GLN A 256      10.723   5.990 -18.824  1.00 64.14     0.159 HD
ATOM   2440  N   THR A 257      10.747  10.514 -21.429  1.00 41.75    -0.344 N
ATOM   2441  CA  THR A 257      10.019  11.784 -21.536  1.00 38.20     0.205 C
ATOM   2442  C   THR A 257      10.718  12.787 -22.478  1.00 35.93     0.243 C
ATOM   2443  O   THR A 257      10.075  13.734 -22.930  1.00 32.26    -0.271 OA
ATOM   2444  CB  THR A 257       9.898  12.421 -20.126  1.00 38.49     0.146 C
ATOM   2445  OG1 THR A 257      11.162  12.746 -19.577  1.00 32.78    -0.393 OA
ATOM   2446  CG2 THR A 257       9.104  11.559 -19.133  1.00 35.32     0.042 C
ATOM   2447  H   THR A 257      11.421  10.427 -20.682  1.00 41.75     0.163 HD
ATOM   2448  HG1 THR A 257      11.606  11.944 -19.340  1.00 32.78     0.210 HD
ATOM   2449  N   GLY A 258      12.018  12.594 -22.763  1.00 35.59    -0.350 N
ATOM   2450  CA  GLY A 258      12.847  13.471 -23.590  1.00 37.26     0.225 C
ATOM   2451  C   GLY A 258      13.369  14.730 -22.879  1.00 37.02     0.236 C
ATOM   2452  O   GLY A 258      14.095  15.507 -23.498  1.00 35.62    -0.272 OA
ATOM   2453  H   GLY A 258      12.479  11.796 -22.350  1.00 35.59     0.163 HD
ATOM   2454  N   ILE A 259      13.014  14.936 -21.599  1.00 37.00    -0.346 N
ATOM   2455  CA  ILE A 259      13.434  16.064 -20.765  1.00 33.99     0.180 C
ATOM   2456  C   ILE A 259      14.729  15.636 -20.054  1.00 35.18     0.241 C
ATOM   2457  O   ILE A 259      14.757  14.590 -19.403  1.00 34.96    -0.271 OA
ATOM   2458  CB  ILE A 259      12.321  16.359 -19.710  1.00 34.73     0.013 C
ATOM   2459  CG1 ILE A 259      10.963  16.692 -20.376  1.00 36.85     0.002 C
ATOM   2460  CG2 ILE A 259      12.721  17.483 -18.726  1.00 32.26     0.012 C
ATOM   2461  CD1 ILE A 259       9.778  16.661 -19.402  1.00 39.46     0.005 C
ATOM   2462  H   ILE A 259      12.427  14.241 -21.159  1.00 37.00     0.163 HD
ATOM   2463  N   ALA A 260      15.788  16.459 -20.150  1.00 36.11    -0.346 N
ATOM   2464  CA  ALA A 260      17.076  16.240 -19.485  1.00 35.88     0.172 C
ATOM   2465  C   ALA A 260      16.941  16.398 -17.962  1.00 34.06     0.240 C
ATOM   2466  O   ALA A 260      16.101  17.165 -17.491  1.00 33.30    -0.271 OA
ATOM   2467  CB  ALA A 260      18.093  17.262 -20.013  1.00 33.64     0.042 C
ATOM   2468  H   ALA A 260      15.686  17.312 -20.682  1.00 36.11     0.163 HD
ATOM   2469  N   VAL A 261      17.766  15.670 -17.188  1.00 31.55    -0.346 N
ATOM   2470  CA  VAL A 261      17.758  15.687 -15.717  1.00 33.39     0.180 C
ATOM   2471  C   VAL A 261      18.054  17.086 -15.148  1.00 31.77     0.241 C
ATOM   2472  O   VAL A 261      17.465  17.457 -14.137  1.00 29.46    -0.271 OA
ATOM   2473  CB  VAL A 261      18.730  14.618 -15.149  1.00 35.92     0.009 C
ATOM   2474  CG1 VAL A 261      18.721  14.585 -13.607  1.00 36.64     0.012 C
ATOM   2475  CG2 VAL A 261      18.423  13.206 -15.686  1.00 37.71     0.012 C
ATOM   2476  H   VAL A 261      18.422  15.048 -17.638  1.00 31.55     0.163 HD
ATOM   2477  N   LEU A 262      18.899  17.874 -15.829  1.00 32.52    -0.346 N
ATOM   2478  CA  LEU A 262      19.241  19.249 -15.477  1.00 32.62     0.177 C
ATOM   2479  C   LEU A 262      18.145  20.276 -15.835  1.00 31.61     0.241 C
ATOM   2480  O   LEU A 262      18.185  21.389 -15.315  1.00 32.91    -0.271 OA
ATOM   2481  CB  LEU A 262      20.548  19.617 -16.206  1.00 33.58     0.038 C
ATOM   2482  CG  LEU A 262      21.815  18.923 -15.650  1.00 32.67    -0.020 C
ATOM   2483  CD1 LEU A 262      23.052  19.345 -16.457  1.00 33.24     0.009 C
ATOM   2484  CD2 LEU A 262      22.049  19.182 -14.149  1.00 34.23     0.009 C
ATOM   2485  H   LEU A 262      19.324  17.498 -16.664  1.00 32.52     0.163 HD
ATOM   2486  N   ASP A 263      17.149  19.909 -16.660  1.00 30.63    -0.346 N
ATOM   2487  CA  ASP A 263      15.941  20.709 -16.909  1.00 32.63     0.186 C
ATOM   2488  C   ASP A 263      14.844  20.348 -15.892  1.00 32.05     0.241 C
ATOM   2489  O   ASP A 263      14.044  21.212 -15.535  1.00 32.01    -0.271 OA
ATOM   2490  CB  ASP A 263      15.376  20.429 -18.324  1.00 33.69     0.147 C
ATOM   2491  CG  ASP A 263      16.340  20.688 -19.487  1.00 34.34     0.175 C
ATOM   2492  OD1 ASP A 263      17.366  21.370 -19.271  1.00 31.92    -0.648 OA
ATOM   2493  OD2 ASP A 263      16.025  20.185 -20.588  1.00 33.71    -0.648 OA
ATOM   2494  H   ASP A 263      17.177  18.984 -17.066  1.00 30.63     0.163 HD
ATOM   2495  N   MET A 264      14.829  19.099 -15.388  1.00 33.88    -0.346 N
ATOM   2496  CA  MET A 264      13.935  18.638 -14.324  1.00 31.87     0.177 C
ATOM   2497  C   MET A 264      14.433  19.094 -12.935  1.00 30.87     0.241 C
ATOM   2498  O   MET A 264      13.628  19.227 -12.014  1.00 29.96    -0.271 OA
ATOM   2499  CB  MET A 264      13.855  17.093 -14.377  1.00 31.20     0.045 C
ATOM   2500  CG  MET A 264      12.684  16.500 -13.569  1.00 33.66     0.076 C
ATOM   2501  SD  MET A 264      11.039  17.068 -14.089  1.00 31.41    -0.173 SA
ATOM   2502  CE  MET A 264      10.748  15.976 -15.497  1.00 33.34     0.089 C
ATOM   2503  H   MET A 264      15.501  18.435 -15.748  1.00 33.88     0.163 HD
ATOM   2504  N   CYS A 265      15.735  19.401 -12.798  1.00 29.77    -0.345 N
ATOM   2505  CA  CYS A 265      16.334  20.039 -11.625  1.00 30.79     0.185 C
ATOM   2506  C   CYS A 265      16.001  21.535 -11.580  1.00 30.25     0.241 C
ATOM   2507  O   CYS A 265      15.889  22.089 -10.490  1.00 30.96    -0.271 OA
ATOM   2508  CB  CYS A 265      17.865  19.907 -11.687  1.00 30.44     0.105 C
ATOM   2509  SG  CYS A 265      18.357  18.227 -11.240  1.00 33.19    -0.180 SA
ATOM   2510  H   CYS A 265      16.343  19.224 -13.586  1.00 29.77     0.163 HD
ATOM   2511  HG  CYS A 265      17.769  17.634 -12.286  1.00 33.19     0.101 HD
ATOM   2512  N   ALA A 266      15.802  22.177 -12.744  1.00 33.09    -0.346 N
ATOM   2513  CA  ALA A 266      15.365  23.565 -12.853  1.00 34.54     0.172 C
ATOM   2514  C   ALA A 266      13.855  23.700 -12.593  1.00 35.31     0.240 C
ATOM   2515  O   ALA A 266      13.420  24.746 -12.119  1.00 33.99    -0.271 OA
ATOM   2516  CB  ALA A 266      15.672  24.065 -14.266  1.00 40.49     0.042 C
ATOM   2517  H   ALA A 266      15.913  21.659 -13.604  1.00 33.09     0.163 HD
ATOM   2518  N   SER A 267      13.067  22.636 -12.832  1.00 34.63    -0.344 N
ATOM   2519  CA  SER A 267      11.661  22.532 -12.441  1.00 35.96     0.200 C
ATOM   2520  C   SER A 267      11.522  22.360 -10.922  1.00 34.28     0.243 C
ATOM   2521  O   SER A 267      10.689  23.030 -10.316  1.00 30.95    -0.271 OA
ATOM   2522  CB  SER A 267      11.015  21.330 -13.151  1.00 36.77     0.199 C
ATOM   2523  OG  SER A 267      10.711  21.673 -14.483  1.00 42.04    -0.398 OA
ATOM   2524  H   SER A 267      13.484  21.824 -13.266  1.00 34.63     0.163 HD
ATOM   2525  HG  SER A 267      10.052  22.353 -14.467  1.00 42.04     0.209 HD
ATOM   2526  N   LEU A 268      12.370  21.516 -10.307  1.00 28.65    -0.346 N
ATOM   2527  CA  LEU A 268      12.434  21.291  -8.862  1.00 32.05     0.177 C
ATOM   2528  C   LEU A 268      12.979  22.520  -8.106  1.00 32.81     0.241 C
ATOM   2529  O   LEU A 268      12.507  22.807  -7.009  1.00 34.20    -0.271 OA
ATOM   2530  CB  LEU A 268      13.292  20.030  -8.605  1.00 30.77     0.038 C
ATOM   2531  CG  LEU A 268      13.464  19.592  -7.130  1.00 30.33    -0.020 C
ATOM   2532  CD1 LEU A 268      12.141  19.543  -6.348  1.00 29.88     0.009 C
ATOM   2533  CD2 LEU A 268      14.161  18.224  -7.063  1.00 32.37     0.009 C
ATOM   2534  H   LEU A 268      13.020  20.994 -10.880  1.00 28.65     0.163 HD
ATOM   2535  N   LYS A 269      13.907  23.285  -8.708  1.00 35.41    -0.346 N
ATOM   2536  CA  LYS A 269      14.437  24.553  -8.198  1.00 38.46     0.176 C
ATOM   2537  C   LYS A 269      13.334  25.610  -8.012  1.00 36.18     0.241 C
ATOM   2538  O   LYS A 269      13.262  26.226  -6.950  1.00 38.14    -0.271 OA
ATOM   2539  CB  LYS A 269      15.553  25.037  -9.152  1.00 39.40     0.035 C
ATOM   2540  CG  LYS A 269      16.124  26.437  -8.870  1.00 41.14     0.004 C
ATOM   2541  CD  LYS A 269      17.413  26.718  -9.660  1.00 44.81     0.027 C
ATOM   2542  CE  LYS A 269      17.926  28.152  -9.458  1.00 47.93     0.229 C
ATOM   2543  NZ  LYS A 269      19.176  28.392 -10.200  1.00 48.90    -0.079 N
ATOM   2544  H   LYS A 269      14.263  22.973  -9.601  1.00 35.41     0.163 HD
ATOM   2545  HZ1 LYS A 269      19.907  27.773  -9.876  1.00 48.90     0.274 HD
ATOM   2546  HZ2 LYS A 269      19.030  28.233 -11.187  1.00 48.90     0.274 HD
ATOM   2547  HZ3 LYS A 269      19.480  29.345 -10.060  1.00 48.90     0.274 HD
ATOM   2548  N   GLU A 270      12.455  25.784  -9.014  1.00 36.62    -0.346 N
ATOM   2549  CA  GLU A 270      11.349  26.742  -8.978  1.00 39.45     0.177 C
ATOM   2550  C   GLU A 270      10.144  26.228  -8.165  1.00 36.42     0.241 C
ATOM   2551  O   GLU A 270       9.385  27.052  -7.657  1.00 33.05    -0.271 OA
ATOM   2552  CB  GLU A 270      10.885  27.040 -10.421  1.00 41.47     0.045 C
ATOM   2553  CG  GLU A 270      11.940  27.729 -11.316  1.00 48.54     0.116 C
ATOM   2554  CD  GLU A 270      12.499  29.039 -10.759  1.00 49.16     0.172 C
ATOM   2555  OE1 GLU A 270      11.680  29.939 -10.473  1.00 48.25    -0.648 OA
ATOM   2556  OE2 GLU A 270      13.741  29.118 -10.631  1.00 46.04    -0.648 OA
ATOM   2557  H   GLU A 270      12.574  25.241  -9.858  1.00 36.62     0.163 HD
ATOM   2558  N   LEU A 271       9.983  24.904  -7.978  1.00 36.64    -0.346 N
ATOM   2559  CA  LEU A 271       8.965  24.314  -7.098  1.00 35.23     0.177 C
ATOM   2560  C   LEU A 271       9.312  24.481  -5.606  1.00 35.00     0.241 C
ATOM   2561  O   LEU A 271       8.407  24.440  -4.774  1.00 34.89    -0.271 OA
ATOM   2562  CB  LEU A 271       8.830  22.800  -7.391  1.00 36.29     0.038 C
ATOM   2563  CG  LEU A 271       7.958  22.445  -8.614  1.00 36.82    -0.020 C
ATOM   2564  CD1 LEU A 271       8.191  20.983  -9.030  1.00 35.80     0.009 C
ATOM   2565  CD2 LEU A 271       6.464  22.684  -8.343  1.00 37.86     0.009 C
ATOM   2566  H   LEU A 271      10.624  24.272  -8.437  1.00 36.64     0.163 HD
ATOM   2567  N   LEU A 272      10.596  24.685  -5.269  1.00 31.10    -0.346 N
ATOM   2568  CA  LEU A 272      11.068  24.944  -3.909  1.00 33.54     0.177 C
ATOM   2569  C   LEU A 272      11.107  26.450  -3.607  1.00 37.36     0.241 C
ATOM   2570  O   LEU A 272      10.820  26.839  -2.476  1.00 39.69    -0.271 OA
ATOM   2571  CB  LEU A 272      12.504  24.389  -3.769  1.00 32.55     0.038 C
ATOM   2572  CG  LEU A 272      12.580  22.848  -3.745  1.00 34.70    -0.020 C
ATOM   2573  CD1 LEU A 272      14.022  22.358  -3.956  1.00 35.28     0.009 C
ATOM   2574  CD2 LEU A 272      11.996  22.267  -2.452  1.00 35.67     0.009 C
ATOM   2575  H   LEU A 272      11.289  24.674  -6.004  1.00 31.10     0.163 HD
ATOM   2576  N   GLN A 273      11.444  27.290  -4.600  1.00 37.64    -0.346 N
ATOM   2577  CA  GLN A 273      11.596  28.738  -4.445  1.00 39.31     0.177 C
ATOM   2578  C   GLN A 273      10.251  29.484  -4.487  1.00 40.67     0.241 C
ATOM   2579  O   GLN A 273      10.087  30.448  -3.740  1.00 41.29    -0.271 OA
ATOM   2580  CB  GLN A 273      12.496  29.259  -5.583  1.00 36.42     0.044 C
ATOM   2581  CG  GLN A 273      13.989  28.930  -5.345  1.00 37.84     0.105 C
ATOM   2582  CD  GLN A 273      14.919  29.193  -6.537  1.00 35.81     0.215 C
ATOM   2583  OE1 GLN A 273      16.120  28.956  -6.435  1.00 39.82    -0.274 OA
ATOM   2584  NE2 GLN A 273      14.394  29.668  -7.669  1.00 37.91    -0.370 N
ATOM   2585  H   GLN A 273      11.676  26.895  -5.501  1.00 37.64     0.163 HD
ATOM   2586 2HE2 GLN A 273      14.976  29.814  -8.482  1.00 37.91     0.159 HD
ATOM   2587 1HE2 GLN A 273      13.402  29.844  -7.734  1.00 37.91     0.159 HD
ATOM   2588  N   ASN A 274       9.299  29.047  -5.331  1.00 40.53    -0.346 N
ATOM   2589  CA  ASN A 274       7.976  29.672  -5.493  1.00 44.54     0.185 C
ATOM   2590  C   ASN A 274       6.860  28.849  -4.822  1.00 45.34     0.241 C
ATOM   2591  O   ASN A 274       5.740  29.347  -4.699  1.00 53.43    -0.271 OA
ATOM   2592  CB  ASN A 274       7.627  29.794  -6.997  1.00 45.12     0.137 C
ATOM   2593  CG  ASN A 274       8.670  30.571  -7.806  1.00 46.97     0.217 C
ATOM   2594  OD1 ASN A 274       8.890  31.757  -7.571  1.00 53.52    -0.274 OA
ATOM   2595  ND2 ASN A 274       9.334  29.891  -8.742  1.00 51.29    -0.370 N
ATOM   2596  H   ASN A 274       9.508  28.254  -5.924  1.00 40.53     0.163 HD
ATOM   2597 2HD2 ASN A 274      10.058  30.337  -9.295  1.00 51.29     0.159 HD
ATOM   2598 1HD2 ASN A 274       9.141  28.908  -8.871  1.00 51.29     0.159 HD
ATOM   2599  N   GLY A 275       7.145  27.605  -4.400  1.00 46.99    -0.351 N
ATOM   2600  CA  GLY A 275       6.169  26.664  -3.856  1.00 46.74     0.225 C
ATOM   2601  C   GLY A 275       5.339  25.979  -4.951  1.00 45.88     0.236 C
ATOM   2602  O   GLY A 275       5.695  26.011  -6.130  1.00 49.13    -0.272 OA
ATOM   2603  H   GLY A 275       8.086  27.264  -4.527  1.00 46.99     0.163 HD
ATOM   2604  N   MET A 276       4.226  25.349  -4.542  1.00 44.92    -0.346 N
ATOM   2605  CA  MET A 276       3.286  24.670  -5.438  1.00 49.11     0.177 C
ATOM   2606  C   MET A 276       2.202  25.639  -5.955  1.00 47.80     0.241 C
ATOM   2607  O   MET A 276       1.690  25.441  -7.056  1.00 42.90    -0.271 OA
ATOM   2608  CB  MET A 276       2.579  23.537  -4.659  1.00 54.01     0.045 C
ATOM   2609  CG  MET A 276       3.518  22.396  -4.221  1.00 57.91     0.076 C
ATOM   2610  SD  MET A 276       4.085  21.270  -5.528  1.00 62.29    -0.173 SA
ATOM   2611  CE  MET A 276       2.618  20.226  -5.732  1.00 59.07     0.089 C
ATOM   2612  H   MET A 276       4.014  25.344  -3.555  1.00 44.92     0.163 HD
ATOM   2613  N   ASN A 277       1.858  26.673  -5.162  1.00 48.80    -0.346 N
ATOM   2614  CA  ASN A 277       0.910  27.760  -5.456  1.00 53.50     0.185 C
ATOM   2615  C   ASN A 277      -0.565  27.320  -5.363  1.00 58.25     0.241 C
ATOM   2616  O   ASN A 277      -1.421  27.859  -6.064  1.00 60.62    -0.271 OA
ATOM   2617  CB  ASN A 277       1.251  28.567  -6.739  1.00 53.06     0.137 C
ATOM   2618  CG  ASN A 277       2.656  29.180  -6.720  1.00 59.26     0.217 C
ATOM   2619  OD1 ASN A 277       3.605  28.582  -7.222  1.00 66.18    -0.274 OA
ATOM   2620  ND2 ASN A 277       2.791  30.384  -6.160  1.00 61.23    -0.370 N
ATOM   2621  H   ASN A 277       2.350  26.748  -4.284  1.00 48.80     0.163 HD
ATOM   2622 2HD2 ASN A 277       3.708  30.806  -6.115  1.00 61.23     0.159 HD
ATOM   2623 1HD2 ASN A 277       1.993  30.857  -5.763  1.00 61.23     0.159 HD
ATOM   2624  N   GLY A 278      -0.855  26.321  -4.512  1.00 54.49    -0.351 N
ATOM   2625  CA  GLY A 278      -2.180  25.733  -4.308  1.00 52.21     0.225 C
ATOM   2626  C   GLY A 278      -2.533  24.606  -5.290  1.00 49.47     0.236 C
ATOM   2627  O   GLY A 278      -3.605  24.015  -5.166  1.00 53.94    -0.272 OA
ATOM   2628  H   GLY A 278      -0.096  25.924  -3.978  1.00 54.49     0.163 HD
ATOM   2629  N   ARG A 279      -1.642  24.300  -6.247  1.00 49.37    -0.346 N
ATOM   2630  CA  ARG A 279      -1.779  23.229  -7.234  1.00 51.85     0.176 C
ATOM   2631  C   ARG A 279      -1.214  21.911  -6.672  1.00 46.39     0.241 C
ATOM   2632  O   ARG A 279      -0.564  21.893  -5.625  1.00 46.88    -0.271 OA
ATOM   2633  CB  ARG A 279      -0.966  23.619  -8.487  1.00 55.86     0.036 C
ATOM   2634  CG  ARG A 279      -1.475  24.906  -9.165  1.00 65.10     0.023 C
ATOM   2635  CD  ARG A 279      -0.702  25.264 -10.439  1.00 75.03     0.138 C
ATOM   2636  NE  ARG A 279       0.619  25.827 -10.118  1.00 82.87    -0.227 N
ATOM   2637  CZ  ARG A 279       1.028  27.098 -10.278  1.00 84.21     0.665 C
ATOM   2638  NH1 ARG A 279       2.294  27.412  -9.981  1.00 83.99    -0.235 N
ATOM   2639  NH2 ARG A 279       0.202  28.057 -10.721  1.00 86.02    -0.235 N
ATOM   2640  H   ARG A 279      -0.784  24.832  -6.272  1.00 49.37     0.163 HD
ATOM   2641  HE  ARG A 279       1.284  25.164  -9.744  1.00 82.87     0.177 HD
ATOM   2642 HH12 ARG A 279       2.628  28.360 -10.079  1.00 83.99     0.174 HD
ATOM   2643 HH11 ARG A 279       2.918  26.713  -9.603  1.00 83.99     0.174 HD
ATOM   2644 HH22 ARG A 279       0.527  29.006 -10.833  1.00 86.02     0.174 HD
ATOM   2645 HH21 ARG A 279      -0.758  27.833 -10.938  1.00 86.02     0.174 HD
ATOM   2646  N   THR A 280      -1.479  20.804  -7.383  1.00 43.24    -0.344 N
ATOM   2647  CA  THR A 280      -1.085  19.441  -7.025  1.00 42.17     0.205 C
ATOM   2648  C   THR A 280      -0.364  18.756  -8.194  1.00 40.85     0.243 C
ATOM   2649  O   THR A 280      -0.631  19.044  -9.361  1.00 41.58    -0.271 OA
ATOM   2650  CB  THR A 280      -2.304  18.631  -6.511  1.00 43.39     0.146 C
ATOM   2651  OG1 THR A 280      -3.276  18.455  -7.527  1.00 44.17    -0.393 OA
ATOM   2652  CG2 THR A 280      -2.976  19.223  -5.264  1.00 43.29     0.042 C
ATOM   2653  H   THR A 280      -2.019  20.900  -8.230  1.00 43.24     0.163 HD
ATOM   2654  HG1 THR A 280      -2.875  18.015  -8.261  1.00 44.17     0.210 HD
ATOM   2655  N   ILE A 281       0.533  17.820  -7.852  1.00 39.29    -0.346 N
ATOM   2656  CA  ILE A 281       1.234  16.915  -8.759  1.00 38.92     0.180 C
ATOM   2657  C   ILE A 281       0.911  15.504  -8.251  1.00 39.00     0.241 C
ATOM   2658  O   ILE A 281       1.244  15.173  -7.114  1.00 35.91    -0.271 OA
ATOM   2659  CB  ILE A 281       2.758  17.230  -8.762  1.00 35.68     0.013 C
ATOM   2660  CG1 ILE A 281       3.060  18.656  -9.272  1.00 35.24     0.002 C
ATOM   2661  CG2 ILE A 281       3.557  16.195  -9.578  1.00 39.78     0.012 C
ATOM   2662  CD1 ILE A 281       4.497  19.138  -9.015  1.00 36.95     0.005 C
ATOM   2663  H   ILE A 281       0.679  17.652  -6.864  1.00 39.29     0.163 HD
ATOM   2664  N   LEU A 282       0.215  14.699  -9.072  1.00 39.78    -0.346 N
ATOM   2665  CA  LEU A 282      -0.191  13.312  -8.808  1.00 41.44     0.177 C
ATOM   2666  C   LEU A 282      -1.155  13.179  -7.607  1.00 38.49     0.240 C
ATOM   2667  O   LEU A 282      -1.186  12.148  -6.936  1.00 35.35    -0.271 OA
ATOM   2668  CB  LEU A 282       1.038  12.367  -8.742  1.00 43.17     0.038 C
ATOM   2669  CG  LEU A 282       1.800  12.221 -10.080  1.00 45.01    -0.020 C
ATOM   2670  CD1 LEU A 282       3.128  11.482  -9.864  1.00 43.23     0.009 C
ATOM   2671  CD2 LEU A 282       0.952  11.520 -11.156  1.00 45.37     0.009 C
ATOM   2672  H   LEU A 282      -0.011  15.046  -9.999  1.00 39.78     0.163 HD
ATOM   2673  N   GLY A 283      -1.931  14.243  -7.336  1.00 43.14    -0.351 N
ATOM   2674  CA  GLY A 283      -2.888  14.359  -6.239  1.00 47.17     0.225 C
ATOM   2675  C   GLY A 283      -2.299  14.868  -4.915  1.00 49.53     0.236 C
ATOM   2676  O   GLY A 283      -3.070  15.133  -3.994  1.00 47.25    -0.272 OA
ATOM   2677  H   GLY A 283      -1.838  15.045  -7.942  1.00 43.14     0.163 HD
ATOM   2678  N   SER A 284      -0.966  15.017  -4.807  1.00 47.52    -0.344 N
ATOM   2679  CA  SER A 284      -0.279  15.505  -3.611  1.00 44.32     0.200 C
ATOM   2680  C   SER A 284       0.025  17.005  -3.760  1.00 37.68     0.243 C
ATOM   2681  O   SER A 284       0.514  17.450  -4.800  1.00 32.95    -0.271 OA
ATOM   2682  CB  SER A 284       1.043  14.724  -3.442  1.00 43.61     0.199 C
ATOM   2683  OG  SER A 284       1.698  15.091  -2.242  1.00 45.64    -0.398 OA
ATOM   2684  H   SER A 284      -0.391  14.798  -5.610  1.00 47.52     0.163 HD
ATOM   2685  HG  SER A 284       2.306  14.403  -1.999  1.00 45.64     0.209 HD
ATOM   2686  N   ALA A 285      -0.237  17.765  -2.685  1.00 38.86    -0.346 N
ATOM   2687  CA  ALA A 285       0.046  19.195  -2.539  1.00 37.83     0.172 C
ATOM   2688  C   ALA A 285       1.467  19.458  -1.989  1.00 36.60     0.240 C
ATOM   2689  O   ALA A 285       1.759  20.573  -1.555  1.00 41.85    -0.271 OA
ATOM   2690  CB  ALA A 285      -0.984  19.772  -1.552  1.00 40.02     0.042 C
ATOM   2691  H   ALA A 285      -0.625  17.301  -1.875  1.00 38.86     0.163 HD
ATOM   2692  N   LEU A 286       2.351  18.449  -2.031  1.00 35.24    -0.346 N
ATOM   2693  CA  LEU A 286       3.764  18.507  -1.666  1.00 35.40     0.177 C
ATOM   2694  C   LEU A 286       4.611  17.632  -2.598  1.00 36.97     0.241 C
ATOM   2695  O   LEU A 286       4.080  16.874  -3.411  1.00 32.21    -0.271 OA
ATOM   2696  CB  LEU A 286       3.972  18.287  -0.147  1.00 37.68     0.038 C
ATOM   2697  CG  LEU A 286       3.492  16.938   0.447  1.00 39.63    -0.020 C
ATOM   2698  CD1 LEU A 286       4.437  15.761   0.142  1.00 41.71     0.009 C
ATOM   2699  CD2 LEU A 286       3.307  17.066   1.967  1.00 43.31     0.009 C
ATOM   2700  H   LEU A 286       2.033  17.565  -2.407  1.00 35.24     0.163 HD
ATOM   2701  N   LEU A 287       5.939  17.752  -2.469  1.00 33.98    -0.346 N
ATOM   2702  CA  LEU A 287       6.930  17.046  -3.273  1.00 33.82     0.177 C
ATOM   2703  C   LEU A 287       7.264  15.706  -2.586  1.00 31.66     0.241 C
ATOM   2704  O   LEU A 287       7.932  15.685  -1.552  1.00 31.41    -0.271 OA
ATOM   2705  CB  LEU A 287       8.188  17.947  -3.378  1.00 34.82     0.038 C
ATOM   2706  CG  LEU A 287       7.935  19.347  -4.001  1.00 36.11    -0.020 C
ATOM   2707  CD1 LEU A 287       9.181  20.239  -3.908  1.00 35.34     0.009 C
ATOM   2708  CD2 LEU A 287       7.442  19.279  -5.454  1.00 37.48     0.009 C
ATOM   2709  H   LEU A 287       6.294  18.381  -1.763  1.00 33.98     0.163 HD
ATOM   2710  N   GLU A 288       6.771  14.592  -3.162  1.00 32.12    -0.346 N
ATOM   2711  CA  GLU A 288       6.922  13.224  -2.645  1.00 32.91     0.177 C
ATOM   2712  C   GLU A 288       8.324  12.690  -2.968  1.00 28.51     0.241 C
ATOM   2713  O   GLU A 288       8.827  12.898  -4.073  1.00 26.08    -0.271 OA
ATOM   2714  CB  GLU A 288       5.925  12.290  -3.365  1.00 37.25     0.045 C
ATOM   2715  CG  GLU A 288       4.435  12.552  -3.068  1.00 45.20     0.116 C
ATOM   2716  CD  GLU A 288       3.995  12.110  -1.670  1.00 53.76     0.172 C
ATOM   2717  OE1 GLU A 288       4.440  11.026  -1.228  1.00 55.17    -0.648 OA
ATOM   2718  OE2 GLU A 288       3.184  12.857  -1.081  1.00 63.34    -0.648 OA
ATOM   2719  H   GLU A 288       6.232  14.698  -4.009  1.00 32.12     0.163 HD
ATOM   2720  N   ASP A 289       8.927  11.979  -2.004  1.00 29.61    -0.346 N
ATOM   2721  CA  ASP A 289      10.325  11.543  -2.022  1.00 30.10     0.186 C
ATOM   2722  C   ASP A 289      10.489  10.058  -1.644  1.00 30.80     0.241 C
ATOM   2723  O   ASP A 289      11.599   9.638  -1.322  1.00 31.86    -0.271 OA
ATOM   2724  CB  ASP A 289      11.174  12.524  -1.180  1.00 30.60     0.147 C
ATOM   2725  CG  ASP A 289      11.091  12.357   0.340  1.00 32.89     0.175 C
ATOM   2726  OD1 ASP A 289      10.002  12.020   0.854  1.00 29.21    -0.648 OA
ATOM   2727  OD2 ASP A 289      12.143  12.565   0.978  1.00 32.05    -0.648 OA
ATOM   2728  H   ASP A 289       8.438  11.860  -1.127  1.00 29.61     0.163 HD
ATOM   2729  N   GLU A 290       9.413   9.259  -1.712  1.00 32.37    -0.346 N
ATOM   2730  CA  GLU A 290       9.403   7.825  -1.405  1.00 34.75     0.177 C
ATOM   2731  C   GLU A 290       8.999   7.021  -2.651  1.00 32.34     0.241 C
ATOM   2732  O   GLU A 290       8.221   6.070  -2.574  1.00 29.51    -0.271 OA
ATOM   2733  CB  GLU A 290       8.572   7.542  -0.134  1.00 36.13     0.045 C
ATOM   2734  CG  GLU A 290       9.044   8.371   1.085  1.00 37.88     0.116 C
ATOM   2735  CD  GLU A 290       8.689   7.772   2.449  1.00 44.15     0.172 C
ATOM   2736  OE1 GLU A 290       7.735   6.965   2.510  1.00 39.00    -0.648 OA
ATOM   2737  OE2 GLU A 290       9.390   8.142   3.418  1.00 41.37    -0.648 OA
ATOM   2738  H   GLU A 290       8.537   9.675  -1.995  1.00 32.37     0.163 HD
ATOM   2739  N   PHE A 291       9.579   7.418  -3.796  1.00 30.87    -0.346 N
ATOM   2740  CA  PHE A 291       9.522   6.768  -5.099  1.00 29.96     0.180 C
ATOM   2741  C   PHE A 291      10.912   6.852  -5.723  1.00 29.80     0.241 C
ATOM   2742  O   PHE A 291      11.258   7.904  -6.257  1.00 30.32    -0.271 OA
ATOM   2743  CB  PHE A 291       8.500   7.481  -6.007  1.00 31.04     0.073 C
ATOM   2744  CG  PHE A 291       7.049   7.348  -5.618  1.00 30.42    -0.056 A
ATOM   2745  CD1 PHE A 291       6.409   6.100  -5.733  1.00 32.90     0.007 A
ATOM   2746  CD2 PHE A 291       6.324   8.484  -5.202  1.00 30.15     0.007 A
ATOM   2747  CE1 PHE A 291       5.034   5.998  -5.471  1.00 33.81     0.001 A
ATOM   2748  CE2 PHE A 291       4.944   8.381  -4.948  1.00 32.78     0.001 A
ATOM   2749  CZ  PHE A 291       4.298   7.139  -5.095  1.00 32.59     0.000 A
ATOM   2750  H   PHE A 291      10.181   8.227  -3.742  1.00 30.87     0.163 HD
ATOM   2751  N   THR A 292      11.704   5.768  -5.706  1.00 30.96    -0.344 N
ATOM   2752  CA  THR A 292      12.991   5.708  -6.414  1.00 31.16     0.205 C
ATOM   2753  C   THR A 292      12.759   5.695  -7.942  1.00 30.83     0.245 C
ATOM   2754  O   THR A 292      11.684   5.275  -8.377  1.00 29.55    -0.271 OA
ATOM   2755  CB  THR A 292      13.810   4.461  -5.976  1.00 29.58     0.146 C
ATOM   2756  OG1 THR A 292      13.257   3.240  -6.426  1.00 30.90    -0.393 OA
ATOM   2757  CG2 THR A 292      14.068   4.380  -4.468  1.00 28.93     0.042 C
ATOM   2758  H   THR A 292      11.348   4.913  -5.294  1.00 30.96     0.163 HD
ATOM   2759  HG1 THR A 292      12.442   3.086  -5.967  1.00 30.90     0.210 HD
ATOM   2760  N   PRO A 293      13.744   6.111  -8.772  1.00 29.70    -0.337 N
ATOM   2761  CA  PRO A 293      13.721   5.941 -10.238  1.00 31.09     0.179 C
ATOM   2762  C   PRO A 293      13.344   4.531 -10.740  1.00 34.48     0.241 C
ATOM   2763  O   PRO A 293      12.699   4.416 -11.779  1.00 31.68    -0.271 OA
ATOM   2764  CB  PRO A 293      15.128   6.328 -10.708  1.00 32.62     0.037 C
ATOM   2765  CG  PRO A 293      15.652   7.266  -9.632  1.00 30.88     0.022 C
ATOM   2766  CD  PRO A 293      14.943   6.839  -8.349  1.00 29.33     0.127 C
ATOM   2767  N   PHE A 294      13.688   3.477  -9.977  1.00 39.54    -0.346 N
ATOM   2768  CA  PHE A 294      13.357   2.084 -10.270  1.00 41.35     0.180 C
ATOM   2769  C   PHE A 294      11.894   1.728  -9.939  1.00 38.29     0.241 C
ATOM   2770  O   PHE A 294      11.353   0.841 -10.594  1.00 34.76    -0.271 OA
ATOM   2771  CB  PHE A 294      14.275   1.167  -9.436  1.00 51.21     0.073 C
ATOM   2772  CG  PHE A 294      15.751   1.256  -9.789  1.00 69.29    -0.056 A
ATOM   2773  CD1 PHE A 294      16.189   0.942 -11.093  1.00 76.54     0.007 A
ATOM   2774  CD2 PHE A 294      16.692   1.646  -8.813  1.00 81.42     0.007 A
ATOM   2775  CE1 PHE A 294      17.556   1.021 -11.420  1.00 76.06     0.001 A
ATOM   2776  CE2 PHE A 294      18.061   1.718  -9.139  1.00 82.38     0.001 A
ATOM   2777  CZ  PHE A 294      18.493   1.404 -10.442  1.00 76.40     0.000 A
ATOM   2778  H   PHE A 294      14.208   3.652  -9.130  1.00 39.54     0.163 HD
ATOM   2779  N   ASP A 295      11.238   2.418  -8.985  1.00 35.15    -0.345 N
ATOM   2780  CA  ASP A 295       9.809   2.243  -8.672  1.00 36.27     0.186 C
ATOM   2781  C   ASP A 295       8.918   2.904  -9.727  1.00 36.79     0.241 C
ATOM   2782  O   ASP A 295       7.841   2.386 -10.024  1.00 34.74    -0.271 OA
ATOM   2783  CB  ASP A 295       9.423   2.898  -7.322  1.00 36.29     0.147 C
ATOM   2784  CG  ASP A 295      10.205   2.431  -6.100  1.00 35.75     0.175 C
ATOM   2785  OD1 ASP A 295      10.682   1.275  -6.093  1.00 33.35    -0.648 OA
ATOM   2786  OD2 ASP A 295      10.317   3.256  -5.172  1.00 34.11    -0.648 OA
ATOM   2787  H   ASP A 295      11.734   3.146  -8.490  1.00 35.15     0.163 HD
ATOM   2788  N   VAL A 296       9.373   4.033 -10.295  1.00 34.19    -0.346 N
ATOM   2789  CA  VAL A 296       8.691   4.759 -11.360  1.00 33.78     0.180 C
ATOM   2790  C   VAL A 296       8.778   3.959 -12.667  1.00 33.04     0.241 C
ATOM   2791  O   VAL A 296       7.748   3.782 -13.308  1.00 35.95    -0.271 OA
ATOM   2792  CB  VAL A 296       9.299   6.175 -11.509  1.00 31.04     0.009 C
ATOM   2793  CG1 VAL A 296       8.670   6.968 -12.673  1.00 34.02     0.012 C
ATOM   2794  CG2 VAL A 296       9.156   6.979 -10.203  1.00 31.43     0.012 C
ATOM   2795  H   VAL A 296      10.260   4.400  -9.977  1.00 34.19     0.163 HD
ATOM   2796  N   VAL A 297       9.960   3.421 -13.021  1.00 31.80    -0.346 N
ATOM   2797  CA  VAL A 297      10.164   2.509 -14.154  1.00 36.64     0.180 C
ATOM   2798  C   VAL A 297       9.314   1.225 -14.028  1.00 40.12     0.241 C
ATOM   2799  O   VAL A 297       8.728   0.803 -15.023  1.00 39.57    -0.271 OA
ATOM   2800  CB  VAL A 297      11.685   2.221 -14.329  1.00 38.50     0.009 C
ATOM   2801  CG1 VAL A 297      12.013   1.026 -15.249  1.00 40.41     0.012 C
ATOM   2802  CG2 VAL A 297      12.430   3.461 -14.858  1.00 39.97     0.012 C
ATOM   2803  H   VAL A 297      10.766   3.620 -12.443  1.00 31.80     0.163 HD
ATOM   2804  N   ARG A 298       9.210   0.635 -12.822  1.00 40.63    -0.346 N
ATOM   2805  CA  ARG A 298       8.453  -0.593 -12.547  1.00 44.19     0.176 C
ATOM   2806  C   ARG A 298       6.934  -0.390 -12.708  1.00 41.51     0.241 C
ATOM   2807  O   ARG A 298       6.272  -1.246 -13.293  1.00 42.28    -0.271 OA
ATOM   2808  CB  ARG A 298       8.780  -1.065 -11.110  1.00 47.82     0.036 C
ATOM   2809  CG  ARG A 298       8.237  -2.455 -10.714  1.00 54.17     0.023 C
ATOM   2810  CD  ARG A 298       8.414  -2.782  -9.223  1.00 59.08     0.138 C
ATOM   2811  NE  ARG A 298       9.824  -2.663  -8.813  1.00 67.64    -0.227 N
ATOM   2812  CZ  ARG A 298      10.320  -1.803  -7.906  1.00 73.36     0.665 C
ATOM   2813  NH1 ARG A 298      11.643  -1.730  -7.717  1.00 76.99    -0.235 N
ATOM   2814  NH2 ARG A 298       9.522  -1.001  -7.190  1.00 70.01    -0.235 N
ATOM   2815  H   ARG A 298       9.723   1.039 -12.051  1.00 40.63     0.163 HD
ATOM   2816  HE  ARG A 298      10.471  -3.270  -9.297  1.00 67.64     0.177 HD
ATOM   2817 HH12 ARG A 298      12.019  -1.072  -7.047  1.00 76.99     0.174 HD
ATOM   2818 HH11 ARG A 298      12.273  -2.319  -8.242  1.00 76.99     0.174 HD
ATOM   2819 HH22 ARG A 298       9.926  -0.279  -6.594  1.00 70.01     0.174 HD
ATOM   2820 HH21 ARG A 298       8.520  -1.055  -7.291  1.00 70.01     0.174 HD
ATOM   2821  N   GLN A 299       6.394   0.736 -12.209  1.00 42.10    -0.346 N
ATOM   2822  CA  GLN A 299       4.964   1.051 -12.222  1.00 42.29     0.177 C
ATOM   2823  C   GLN A 299       4.508   1.649 -13.570  1.00 46.82     0.241 C
ATOM   2824  O   GLN A 299       3.373   1.402 -13.975  1.00 46.89    -0.271 OA
ATOM   2825  CB  GLN A 299       4.681   2.035 -11.061  1.00 39.45     0.044 C
ATOM   2826  CG  GLN A 299       3.193   2.432 -10.900  1.00 40.55     0.105 C
ATOM   2827  CD  GLN A 299       2.825   3.141  -9.588  1.00 40.94     0.215 C
ATOM   2828  OE1 GLN A 299       1.669   3.513  -9.406  1.00 45.63    -0.274 OA
ATOM   2829  NE2 GLN A 299       3.771   3.345  -8.668  1.00 39.86    -0.370 N
ATOM   2830  H   GLN A 299       7.007   1.392 -11.743  1.00 42.10     0.163 HD
ATOM   2831 2HE2 GLN A 299       3.525   3.815  -7.806  1.00 39.86     0.159 HD
ATOM   2832 1HE2 GLN A 299       4.719   3.042  -8.834  1.00 39.86     0.159 HD
ATOM   2833  N   CYS A 300       5.383   2.381 -14.286  1.00 48.25    -0.345 N
ATOM   2834  CA  CYS A 300       5.108   2.961 -15.610  1.00 50.42     0.185 C
ATOM   2835  C   CYS A 300       5.432   1.983 -16.764  1.00 56.55     0.242 C
ATOM   2836  O   CYS A 300       5.376   2.386 -17.926  1.00 64.18    -0.271 OA
ATOM   2837  CB  CYS A 300       5.941   4.252 -15.806  1.00 48.92     0.105 C
ATOM   2838  SG  CYS A 300       5.384   5.555 -14.666  1.00 51.07    -0.180 SA
ATOM   2839  H   CYS A 300       6.300   2.551 -13.895  1.00 48.25     0.163 HD
ATOM   2840  HG  CYS A 300       5.718   4.902 -13.549  1.00 51.07     0.101 HD
ATOM   2841  N   SER A 301       5.727   0.704 -16.465  1.00 53.19    -0.344 N
ATOM   2842  CA  SER A 301       5.911  -0.375 -17.443  1.00 57.14     0.200 C
ATOM   2843  C   SER A 301       5.285  -1.721 -17.032  1.00 65.52     0.242 C
ATOM   2844  O   SER A 301       5.367  -2.679 -17.800  1.00 73.00    -0.271 OA
ATOM   2845  CB  SER A 301       7.362  -0.434 -17.968  1.00 57.19     0.199 C
ATOM   2846  OG  SER A 301       8.240  -1.051 -17.051  1.00 50.10    -0.398 OA
ATOM   2847  H   SER A 301       5.791   0.455 -15.489  1.00 53.19     0.163 HD
ATOM   2848  HG  SER A 301       8.338  -0.479 -16.301  1.00 50.10     0.209 HD
ATOM   2849  N   GLY A 302       4.617  -1.790 -15.866  1.00 73.95    -0.350 N
ATOM   2850  CA  GLY A 302       3.798  -2.924 -15.432  1.00 72.65     0.225 C
ATOM   2851  C   GLY A 302       4.565  -4.190 -15.022  1.00 73.07     0.236 C
ATOM   2852  O   GLY A 302       4.016  -5.285 -15.139  1.00 71.02    -0.272 OA
ATOM   2853  H   GLY A 302       4.593  -0.968 -15.280  1.00 73.95     0.163 HD
ATOM   2854  N   VAL A 303       5.823  -4.053 -14.567  1.00 72.60    -0.346 N
ATOM   2855  CA  VAL A 303       6.714  -5.145 -14.160  1.00 75.49     0.180 C
ATOM   2856  C   VAL A 303       6.195  -5.815 -12.871  1.00 75.75     0.241 C
ATOM   2857  O   VAL A 303       6.035  -5.156 -11.842  1.00 78.01    -0.271 OA
ATOM   2858  CB  VAL A 303       8.146  -4.567 -13.974  1.00 74.02     0.009 C
ATOM   2859  CG1 VAL A 303       9.145  -5.540 -13.311  1.00 73.95     0.012 C
ATOM   2860  CG2 VAL A 303       8.728  -4.078 -15.311  1.00 73.89     0.012 C
ATOM   2861  H   VAL A 303       6.188  -3.114 -14.489  1.00 72.60     0.163 HD
ATOM   2862  N   THR A 304       5.953  -7.133 -12.952  1.00 68.10    -0.346 N
ATOM   2863  CA  THR A 304       5.460  -7.993 -11.878  1.00 64.13     0.174 C
ATOM   2864  C   THR A 304       6.660  -8.670 -11.184  1.00 62.87     0.258 C
ATOM   2865  O   THR A 304       6.668  -9.828 -10.765  1.00 69.72    -0.305 OA
ATOM   2866  CB  THR A 304       4.496  -9.045 -12.497  1.00 60.95     0.143 C
ATOM   2867  OG1 THR A 304       5.150  -9.899 -13.420  1.00 57.55    -0.393 OA
ATOM   2868  CG2 THR A 304       3.268  -8.419 -13.178  1.00 54.96     0.042 C
ATOM   2869  H   THR A 304       6.101  -7.583 -13.844  1.00 68.10     0.163 HD
ATOM   2870  HG1 THR A 304       5.811 -10.390 -12.954  1.00 57.55     0.210 HD
TER    2871      THR A 304
"""