import json
import setuptools

kwargs = json.loads(
    """
{
    "name": "cdk-prowler",
    "version": "1.118.1",
    "description": "cdk-prowler",
    "license": "Apache-2.0",
    "url": "https://github.com/mmuller88/cdk-prowler",
    "long_description_content_type": "text/markdown",
    "author": "Martin Mueller<damadden88@googlemail.com>",
    "bdist_wheel": {
        "universal": true
    },
    "project_urls": {
        "Source": "https://github.com/mmuller88/cdk-prowler"
    },
    "package_dir": {
        "": "src"
    },
    "packages": [
        "cdk_prowler",
        "cdk_prowler._jsii"
    ],
    "package_data": {
        "cdk_prowler._jsii": [
            "cdk-prowler@1.118.1.jsii.tgz"
        ],
        "cdk_prowler": [
            "py.typed"
        ]
    },
    "python_requires": ">=3.6",
    "install_requires": [
        "aws-cdk.assertions==1.118.0",
        "aws-cdk.aws-codebuild==1.118.0",
        "aws-cdk.aws-events-targets==1.118.0",
        "aws-cdk.aws-events==1.118.0",
        "aws-cdk.aws-iam==1.118.0",
        "aws-cdk.aws-lambda==1.118.0",
        "aws-cdk.aws-logs==1.118.0",
        "aws-cdk.aws-s3==1.118.0",
        "aws-cdk.core==1.118.0",
        "aws-cdk.custom-resources==1.118.0",
        "cdk-iam-floyd>=0.229.0, <0.230.0",
        "constructs>=3.2.27, <4.0.0",
        "jsii>=1.32.0, <2.0.0",
        "publication>=0.0.3"
    ],
    "classifiers": [
        "Intended Audience :: Developers",
        "Operating System :: OS Independent",
        "Programming Language :: JavaScript",
        "Programming Language :: Python :: 3 :: Only",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Typing :: Typed",
        "Development Status :: 5 - Production/Stable",
        "License :: OSI Approved"
    ],
    "scripts": []
}
"""
)

with open("README.md", encoding="utf8") as fp:
    kwargs["long_description"] = fp.read()


setuptools.setup(**kwargs)
