#! usr/bin/python3.6
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-06-11 12:40:47.360445

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""

from pycatia.in_interfaces.reference import Reference
from pycatia.knowledge_interfaces.length import Length
from pycatia.knowledge_interfaces.real_param import RealParam
from pycatia.mec_mod_interfaces.hybrid_shape import HybridShape


class HybridShapeSpline(HybridShape):
    """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     MecModInterfaces.HybridShape
                |                         HybridShapeSpline
                | 
                | Represents the hybrid shape spline feature object.
                | Role: To access the data of the hybrid shape spline feature object. This data
                | includes:
                | 
                |     The support surface
                |     The control points
                |     The tension at each control point
                |     The curvature radius at each control point
                | 
                | Use the CATIAHybridShapeFactory to create a HybridShapeAffinity
                | object.
                | 
                | See also:
                |     HybridShapeFactory
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.hybrid_shape_spline = com_object

    def add_point(self, ip_ia_point):
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Sub AddPoint(Reference ipIAPoint)
                | 
                |     Add a new point .
                | 
                |     Parameters:
                | 
                |         iPoint
                |             Point element.

        :param Reference ip_ia_point:
        :return: None
        """
        return self.hybrid_shape_spline.AddPoint(ip_ia_point.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'add_point'
        # # vba_code = """
        # # Public Function add_point(hybrid_shape_spline)
        # #     Dim ipIAPoint (2)
        # #     hybrid_shape_spline.AddPoint ipIAPoint
        # #     add_point = ipIAPoint
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def add_point_with_constraint_explicit(
            self,
            ip_ia_point,
            ip_ia_dir_tangency,
            i_tangency_norm,
            i_inverse_tangency,
            ip_ia_dir_curvature,
            i_curvature_radius
    ):
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Sub AddPointWithConstraintExplicit(Reference ipIAPoint,
                | HybridShapeDirection ipIADirTangency,
                | double iTangencyNorm,
                | long iInverseTangency,
                | HybridShapeDirection ipIADirCurvature,
                | double iCurvatureRadius)
                | 
                |     Add a new point with explicit tangency and curvature.
                | 
                |     Parameters:
                | 
                |         ipIAPoint
                |             Point element. 
                |         ipIADirTangency
                |             Tangent direction. 
                |         iTangencyNorm
                |             Tension. 
                |         iInverseTangency
                |             Flag to reverse tangent direction (value can be 1 or -1).
                |             
                |         ipIADirCurvature
                |             Curvature direction. 
                |         iCurvatureRadius
                |             Curvature radius value.

        :param Reference ip_ia_point:
        :param HybridShapeDirection ip_ia_dir_tangency:
        :param float i_tangency_norm:
        :param int i_inverse_tangency:
        :param HybridShapeDirection ip_ia_dir_curvature:
        :param float i_curvature_radius:
        :return: None
        """
        return self.hybrid_shape_spline.AddPointWithConstraintExplicit(ip_ia_point.com_object,
                                                                       ip_ia_dir_tangency.com_object, i_tangency_norm,
                                                                       i_inverse_tangency,
                                                                       ip_ia_dir_curvature.com_object,
                                                                       i_curvature_radius)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'add_point_with_constraint_explicit'
        # # vba_code = """
        # # Public Function add_point_with_constraint_explicit(hybrid_shape_spline)
        # #     Dim ipIAPoint (2)
        # #     hybrid_shape_spline.AddPointWithConstraintExplicit ipIAPoint
        # #     add_point_with_constraint_explicit = ipIAPoint
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def add_point_with_constraint_from_curve(self, ip_ia_point, ip_ia_curve_cst, i_tangency_norm, i_invert_value,
                                             i_crv_cst_type):
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Sub AddPointWithConstraintFromCurve(Reference ipIAPoint,
                | Reference ipIACurveCst,
                | double iTangencyNorm,
                | long iInvertValue,
                | long iCrvCstType)
                | 
                |     Add a new point with tangency/curvature from a curve.
                | 
                |     Parameters:
                | 
                |         ipIAPoint
                |             Point element. 
                |         ipIACurveCst
                |             Curvature direction. 
                |         iTangencyNorm
                |             tension factor for tangency. 
                |         iInvertValue
                |             Orientation for tangent 
                |         iCrvCstType
                |             Continuity type for Curve Constraint (1=Tangency , 2-=
                |             Curvature).

        :param Reference ip_ia_point:
        :param Reference ip_ia_curve_cst:
        :param float i_tangency_norm:
        :param int i_invert_value:
        :param int i_crv_cst_type:
        :return: None
        """
        return self.hybrid_shape_spline.AddPointWithConstraintFromCurve(ip_ia_point.com_object,
                                                                        ip_ia_curve_cst.com_object, i_tangency_norm,
                                                                        i_invert_value, i_crv_cst_type)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'add_point_with_constraint_from_curve'
        # # vba_code = """
        # # Public Function add_point_with_constraint_from_curve(hybrid_shape_spline)
        # #     Dim ipIAPoint (2)
        # #     hybrid_shape_spline.AddPointWithConstraintFromCurve ipIAPoint
        # #     add_point_with_constraint_from_curve = ipIAPoint
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_closure(self):
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Func GetClosure() As long
                | 
                |     Gets whether the curve is closed.
                | 
                |     Parameters:
                | 
                |         oClosed
                |             Closing flag
                | 
                |             1
                |                 for a closed curve
                |             0
                |                 for an open curve

        :return: int
        """
        return self.hybrid_shape_spline.GetClosure()

    def get_constraint_type(self, i_pos):
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Func GetConstraintType(long iPos) As long
                | 
                |     Returns the ControlPoint type at the given position.
                | 
                |     Parameters:
                | 
                |         iPos
                |             The position of the point to retrieve 
                |         oCstType
                |             Type of Control point
                |             (CstType=0 : not defined / CstType=1 : Explicit / CstType=2 : FromCurve)

        :param int i_pos:
        :return: int
        """
        return self.hybrid_shape_spline.GetConstraintType(i_pos)

    def get_curvature_radius(self, i_pos):
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Func GetCurvatureRadius(long iPos) As Length
                | 
                |     Returns the curvature radius value for each point of the
                |     spline.
                | 
                |     Parameters:
                | 
                |         iPos
                |             The position of the point in the spline.
                |             Legal values: first position is 1. The position cannot be 0.
                |             
                |         oRadius
                |             The curvature radius value at this point

        :param int i_pos:
        :return: Length
        """
        return Length(self.hybrid_shape_spline.GetCurvatureRadius(i_pos))

    def get_direction_inversion(self, i_pos):
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Func GetDirectionInversion(long iPos) As long
                | 
                |     Gets the orientation of the tangent direction .
                | 
                |     Parameters:
                | 
                |         oInvertFlag
                |             invert flag = 1 No Inversion = -1 Invert 
                |         iPos
                |             Position of point in spline First Position is 1 Position 0 return
                |             E_FAIL

        :param int i_pos:
        :return: int
        """
        return self.hybrid_shape_spline.GetDirectionInversion(i_pos)

    def get_nb_control_point(self):
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Func GetNbControlPoint() As long
                | 
                |     Returns the number of control points.
                | 
                |     Parameters:
                | 
                |         oNbCtrPt
                |             The number of control points.

        :return: int
        """
        return self.hybrid_shape_spline.GetNbControlPoint()

    def get_point(self, i_pos):
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Func GetPoint(long iPos) As Reference
                | 
                |     Returns the Point at the given position.
                | 
                |     Parameters:
                | 
                |         iPos
                |             The position of the point to retrieve 
                |         opIAPoint
                |             Type of Control point (TypeCtrPoint =1 : Explicit / TypeCtrPoint =2 : FromCurve)

        :param int i_pos:
        :return: Reference
        """
        return Reference(self.hybrid_shape_spline.GetPoint(i_pos))

    def get_point_constraint_explicit(self, i_pos, op_ia_dir_tangency, o_tangency_norm, o_inverse_tangency,
                                      op_ia_dir_curvature, o_curvature_radius):
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Sub GetPointConstraintExplicit(long iPos,
                | HybridShapeDirection opIADirTangency,
                | double oTangencyNorm,
                | long oInverseTangency,
                | HybridShapeDirection opIADirCurvature,
                | double oCurvatureRadius)
                | 
                |     Returns the Constraint of the point at iPos.
                |     Available for Explicit Point Constraint type (CstType =1 from
                |     GetContraintType)
                | 
                |     Parameters:
                | 
                |         iPos
                |             The position of the point to retrieve 
                |         opIADirTangency
                |             Tangent direction. 
                |         oTangencyNorm
                |             Tension. 
                |         oInverseTangency
                |             Flag to reverse tangent direction (value can be 1 or -1).
                |             
                |         opIADirCurvature
                |             Curvature direction. 
                |         oCurvatureRadius
                |             Curvature radius value.

        :param int i_pos:
        :param HybridShapeDirection op_ia_dir_tangency:
        :param float o_tangency_norm:
        :param int o_inverse_tangency:
        :param HybridShapeDirection op_ia_dir_curvature:
        :param float o_curvature_radius:
        :return: None
        """
        return self.hybrid_shape_spline.GetPointConstraintExplicit(i_pos, op_ia_dir_tangency.com_object,
                                                                   o_tangency_norm, o_inverse_tangency,
                                                                   op_ia_dir_curvature.com_object, o_curvature_radius)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_point_constraint_explicit'
        # # vba_code = """
        # # Public Function get_point_constraint_explicit(hybrid_shape_spline)
        # #     Dim iPos (2)
        # #     hybrid_shape_spline.GetPointConstraintExplicit iPos
        # #     get_point_constraint_explicit = iPos
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_point_constraint_from_curve(self, i_pos, op_ia_curve_cst, o_tangency_norm, o_invert_value, o_crv_cst_type):
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Sub GetPointConstraintFromCurve(long iPos,
                | Reference opIACurveCst,
                | double oTangencyNorm,
                | long oInvertValue,
                | long oCrvCstType)
                | 
                |     Returns the Constraint of the point at iPos.
                |     Available for FromCurve Point Constraint type (CstType =2 from
                |     GetContraintType)
                | 
                |     Parameters:
                | 
                |         iPos
                |             The position of the point to retrieve 
                |         opIACurveCst
                |             Curvature direction. 
                |         oTangencyNorm
                |             tension factor for tangency. 
                |         oInvertValue
                |             Orientation for tangent 
                |         oCrvCstType
                |             Continuity type for Curve Constraint (1=Tangency , 2-=
                |             Curvature).

        :param int i_pos:
        :param Reference op_ia_curve_cst:
        :param float o_tangency_norm:
        :param int o_invert_value:
        :param int o_crv_cst_type:
        :return: None
        """
        return self.hybrid_shape_spline.GetPointConstraintFromCurve(i_pos, op_ia_curve_cst.com_object, o_tangency_norm,
                                                                    o_invert_value, o_crv_cst_type)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_point_constraint_from_curve'
        # # vba_code = """
        # # Public Function get_point_constraint_from_curve(hybrid_shape_spline)
        # #     Dim iPos (2)
        # #     hybrid_shape_spline.GetPointConstraintFromCurve iPos
        # #     get_point_constraint_from_curve = iPos
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_point_position(self, ip_ia_point):
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Func GetPointPosition(Reference ipIAPoint) As long
                | 
                |     Returns the position of a given point.
                | 
                |     Parameters:
                | 
                |         ipIAPoint
                |             Point 
                |         oPos
                |             The position of the point (=0 Point Not in Spline)

        :param Reference ip_ia_point:
        :return: int
        """
        return self.hybrid_shape_spline.GetPointPosition(ip_ia_point.com_object)

    def get_spline_type(self):
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Func GetSplineType() As long
                | 
                |     Gets the spline type.
                | 
                |     Parameters:
                | 
                |         oType
                |             = 0 : Cubic Type Spline. = 1 : WilsonFowler Type Spline.

        :return: int
        """
        return self.hybrid_shape_spline.GetSplineType()

    def get_support(self):
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Func GetSupport() As Reference
                | 
                |     Gets the support surface.
                | 
                |     Parameters:
                | 
                |         oSupport
                |             Supporting surface for spline (if exist)

        :return: Reference
        """
        return Reference(self.hybrid_shape_spline.GetSupport())

    def get_tangent_norm(self, i_pos):
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Func GetTangentNorm(long iPos) As RealParam
                | 
                |     Returns the tension for each point of the spline.
                |     The tension is the tangent norm at the given point.
                | 
                |     Parameters:
                | 
                |         iPos
                |             The position of the point in the spline.
                |             Legal values: first position is 1. The position cannot be 0.
                |             
                |         oTension
                |             The tension at this point

        :param int i_pos:
        :return: RealParam
        """
        return RealParam(self.hybrid_shape_spline.GetTangentNorm(i_pos))

    def invert_direction(self, i_pos):
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Sub InvertDirection(long iPos)
                | 
                |     Inverts the orientation of the tangent direction .
                | 
                |     Parameters:
                | 
                |         iPos
                |             Position of point in spline First Position is 1 Position 0 return
                |             E_FAIL

        :param int i_pos:
        :return: None
        """
        return self.hybrid_shape_spline.InvertDirection(i_pos)

    def remove_all(self):
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Sub RemoveAll()
                | 
                |     Removes all elements in the list of points.

        :return: None
        """
        return self.hybrid_shape_spline.RemoveAll()

    def remove_control_point(self, i_pos):
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Sub RemoveControlPoint(long iPos)
                | 
                |     Removes a point at the given position.
                | 
                |     Parameters:
                | 
                |         iPos
                |             The position of the point to remove

        :param int i_pos:
        :return: None
        """
        return self.hybrid_shape_spline.RemoveControlPoint(i_pos)

    def remove_curvature_radius_direction(self, i_pos):
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Sub RemoveCurvatureRadiusDirection(long iPos)
                | 
                |     Removes Curvature Radius Direction for the given point of the
                |     spline.
                | 
                |     Parameters:
                | 
                |         iPos
                |             Position of point in spline First Position is 1 Position 0 return
                |             E_FAIL

        :param int i_pos:
        :return: None
        """
        return self.hybrid_shape_spline.RemoveCurvatureRadiusDirection(i_pos)

    def remove_curvature_radius_value(self, i_pos):
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Sub RemoveCurvatureRadiusValue(long iPos)
                | 
                |     Removes Curvature Radius Value for the given point of the
                |     spline.
                | 
                |     Parameters:
                | 
                |         iPos
                |             Position of point in spline First Position is 1 Position 0 return
                |             E_FAIL

        :param int i_pos:
        :return: None
        """
        return self.hybrid_shape_spline.RemoveCurvatureRadiusValue(i_pos)

    def remove_support(self):
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Sub RemoveSupport()
                | 
                |     Removes the support surface.

        :return: None
        """
        return self.hybrid_shape_spline.RemoveSupport()

    def remove_tangent_direction(self, i_pos):
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Sub RemoveTangentDirection(long iPos)
                | 
                |     Removes tangent Direction for the given point of the
                |     spline.
                | 
                |     Parameters:
                | 
                |         iPos
                |             Position of point in spline First Position is 1 Position 0 return
                |             E_FAIL

        :param int i_pos:
        :return: None
        """
        return self.hybrid_shape_spline.RemoveTangentDirection(i_pos)

    def remove_tension(self, i_pos):
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Sub RemoveTension(long iPos)
                | 
                |     Removes the Tension for the given point of the spline.
                | 
                |     Parameters:
                | 
                |         iPos
                |             Position of point in spline First Position is 1 Position 0 return
                |             E_FAIL

        :param int i_pos:
        :return: None
        """
        return self.hybrid_shape_spline.RemoveTension(i_pos)

    def replace_point_at_position(self, i_pos, i_point):
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Sub ReplacePointAtPosition(long iPos,
                | Reference iPoint)
                | 
                |     Replaces a point in the list at the given position.
                | 
                |     Parameters:
                | 
                |         oPoint
                |             Point 
                |         iPos
                |             Replace position

        :param int i_pos:
        :param Reference i_point:
        :return: None
        """
        return self.hybrid_shape_spline.ReplacePointAtPosition(i_pos, i_point.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'replace_point_at_position'
        # # vba_code = """
        # # Public Function replace_point_at_position(hybrid_shape_spline)
        # #     Dim iPos (2)
        # #     hybrid_shape_spline.ReplacePointAtPosition iPos
        # #     replace_point_at_position = iPos
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def set_closing(self, i_closing_type):
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Sub SetClosing(long iClosingType)
                | 
                |     Activates the closing option of the spline.
                | 
                |     Parameters:
                | 
                |         iClosingType
                |             The spline closing option

        :param int i_closing_type:
        :return: None
        """
        return self.hybrid_shape_spline.SetClosing(i_closing_type)

    def set_point_after(self, i_pos, ip_ia_point):
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Sub SetPointAfter(long iPos,
                | Reference ipIAPoint)
                | 
                |     Sets the Point After a given position.
                | 
                |     Parameters:
                | 
                |         iPos
                |             The position reference (0 < position < Nbpt) 
                |         ipIAPoint
                |             Point

        :param int i_pos:
        :param Reference ip_ia_point:
        :return: None
        """
        return self.hybrid_shape_spline.SetPointAfter(i_pos, ip_ia_point.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_point_after'
        # # vba_code = """
        # # Public Function set_point_after(hybrid_shape_spline)
        # #     Dim iPos (2)
        # #     hybrid_shape_spline.SetPointAfter iPos
        # #     set_point_after = iPos
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def set_point_before(self, i_pos, ip_ia_point):
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Sub SetPointBefore(long iPos,
                | Reference ipIAPoint)
                | 
                |     Sets the Point Before a given position.
                | 
                |     Parameters:
                | 
                |         iPos
                |             The position reference (1 < position < Nbpt+1) 
                |         ipIAPoint
                |             Point

        :param int i_pos:
        :param Reference ip_ia_point:
        :return: None
        """
        return self.hybrid_shape_spline.SetPointBefore(i_pos, ip_ia_point.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_point_before'
        # # vba_code = """
        # # Public Function set_point_before(hybrid_shape_spline)
        # #     Dim iPos (2)
        # #     hybrid_shape_spline.SetPointBefore iPos
        # #     set_point_before = iPos
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def set_point_constraint_explicit(self, i_pos, ip_ia_dir_tangency, i_tangency_norm, i_inverse_tangency,
                                      ip_ia_dir_curvature, i_curvature_radius):
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Sub SetPointConstraintExplicit(long iPos,
                | HybridShapeDirection ipIADirTangency,
                | double iTangencyNorm,
                | long iInverseTangency,
                | HybridShapeDirection ipIADirCurvature,
                | double iCurvatureRadius)
                | 
                |     Sets the Constraint of the point at iPos.
                |     Available for Explicit Point Constraint type (CstType =1 from
                |     GetContraintType)
                | 
                |     Parameters:
                | 
                |         iPos
                |             The position of the point to retrieve 
                |         ipIADirTangency
                |             Tangent direction. 
                |         iTangencyNorm
                |             Tension. 
                |         iInverseTangency
                |             Flag to reverse tangent direction (value can be 1 or -1).
                |             
                |         ipIADirCurvature
                |             Curvature direction. 
                |         iCurvatureRadius
                |             Curvature radius value.

        :param int i_pos:
        :param HybridShapeDirection ip_ia_dir_tangency:
        :param float i_tangency_norm:
        :param int i_inverse_tangency:
        :param HybridShapeDirection ip_ia_dir_curvature:
        :param float i_curvature_radius:
        :return: None
        """
        return self.hybrid_shape_spline.SetPointConstraintExplicit(i_pos, ip_ia_dir_tangency.com_object,
                                                                   i_tangency_norm, i_inverse_tangency,
                                                                   ip_ia_dir_curvature.com_object, i_curvature_radius)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_point_constraint_explicit'
        # # vba_code = """
        # # Public Function set_point_constraint_explicit(hybrid_shape_spline)
        # #     Dim iPos (2)
        # #     hybrid_shape_spline.SetPointConstraintExplicit iPos
        # #     set_point_constraint_explicit = iPos
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def set_point_constraint_from_curve(self, i_pos, ip_ia_curve_cst, i_tangency_norm, i_invert_value, i_crv_cst_type):
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Sub SetPointConstraintFromCurve(long iPos,
                | Reference ipIACurveCst,
                | double iTangencyNorm,
                | long iInvertValue,
                | long iCrvCstType)
                | 
                |     Sets the Constraint of the point at iPos.
                |     Available for From Curve Point Constraint type (CstType =2 from
                |     GetContraintType)
                | 
                |     Parameters:
                | 
                |         iPos
                |             The position of the point to retrieve 
                |         ipIACurveCst
                |             Curvature direction. 
                |         iTangencyNorm
                |             tension factor for tangency. 
                |         iInvertValue
                |             Orientation for tangent 
                |         iCrvCstType
                |             Continuity type for Curve Constraint (1=Tangency , 2-=
                |             Curvature).

        :param int i_pos:
        :param Reference ip_ia_curve_cst:
        :param float i_tangency_norm:
        :param int i_invert_value:
        :param int i_crv_cst_type:
        :return: None
        """
        return self.hybrid_shape_spline.SetPointConstraintFromCurve(i_pos, ip_ia_curve_cst.com_object, i_tangency_norm,
                                                                    i_invert_value, i_crv_cst_type)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_point_constraint_from_curve'
        # # vba_code = """
        # # Public Function set_point_constraint_from_curve(hybrid_shape_spline)
        # #     Dim iPos (2)
        # #     hybrid_shape_spline.SetPointConstraintFromCurve iPos
        # #     set_point_constraint_from_curve = iPos
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def set_spline_type(self, i_spline_type):
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Sub SetSplineType(long iSplineType)
                | 
                |     Sets the spline type.
                | 
                |     Parameters:
                | 
                |         iSplineType
                |             The spline type
                |             Legal values: Cubic spline (0) or WilsonFowler (1)

        :param int i_spline_type:
        :return: None
        """
        return self.hybrid_shape_spline.SetSplineType(i_spline_type)

    def set_support(self, i_support):
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Sub SetSupport(Reference iSupport)
                | 
                |     Sets the spline support surface.
                |     Have your "tangent direction" tangent to this support is
                |     recommended.
                | 
                |     Parameters:
                | 
                |         iSupport
                |             The spline support surface.
                |             Sub-element(s) supported (see 
                | 
                |         Boundary object): Face.

        :param Reference i_support:
        :return: None
        """
        return self.hybrid_shape_spline.SetSupport(i_support.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_support'
        # # vba_code = """
        # # Public Function set_support(hybrid_shape_spline)
        # #     Dim iSupport (2)
        # #     hybrid_shape_spline.SetSupport iSupport
        # #     set_support = iSupport
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'HybridShapeSpline(name="{self.name}")'
