#! usr/bin/python3.6
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-06-11 12:40:47.360445

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.sketcher_interfaces.curve_2D import Curve2D
from pycatia.sketcher_interfaces.point_2D import Point2D


class Circle2D(Curve2D):
    """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     SketcherInterfaces.GeometricElement
                |                         SketcherInterfaces.Geometry2D
                |                             SketcherInterfaces.Curve2D
                |                                 Circle2D
                | 
                | Class defining a circle in 2D Space.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.circle2_d = com_object

    @property
    def center_point(self):
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445)
                | o Property CenterPoint() As Point2D
                | 
                |     Returns the center point of the circle.
                | 
                |     Parameters:
                | 
                |         oCenterPoint
                |             The center point of the circle

        :return: Point2D
        """

        return Point2D(self.circle2_d.CenterPoint)

    @center_point.setter
    def center_point(self, value):
        """
        :param Point2D value:
        """

        self.circle2_d.CenterPoint = value

    @property
    def radius(self):
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445)
                | o Property Radius() As double (Read Only)
                | 
                |     Returns the radius of the circle
                | 
                |     Parameters:
                | 
                |         oRadius
                |             The radius of the circle

        :return: float
        """

        return self.circle2_d.Radius

    def get_center(self, o_data):
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Sub GetCenter(CATSafeArrayVariant oData)
                | 
                |     Returns the center of the circle
                | 
                |     Parameters:
                | 
                |         oData[0]
                |             The X Coordinate of the circle center point 
                |         oData[1]
                |             The Y Coordinate of the circle center point 
                |         Example:
                |             The following example reads the coordinates of the
                |             center
                |             of the circle myCircle: double center(1) myCircle.GetCenter
                |             center

        :param tuple o_data:
        :return: None
        """
        return self.circle2_d.GetCenter(o_data)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_center'
        # # vba_code = """
        # # Public Function get_center(circle2_d)
        # #     Dim oData (2)
        # #     circle2_d.GetCenter oData
        # #     get_center = oData
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def set_data(self, i_center_x, i_center_y, i_radius):
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Sub SetData(double iCenterX,
                | double iCenterY,
                | double iRadius)
                | 
                |     Modifies the caracteristics of the circle
                | 
                |     Parameters:
                | 
                |         iCenterX
                |             The X Coordinate of the circle center 
                |         iCenterY
                |             The Y Coordinate of the circle center 
                |         iRadius
                |             The radius of the circle

        :param float i_center_x:
        :param float i_center_y:
        :param float i_radius:
        :return: None
        """
        return self.circle2_d.SetData(i_center_x, i_center_y, i_radius)

    def __repr__(self):
        return f'Circle2D(name="{self.name}")'
