#! usr/bin/python3.6
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-06-11 12:40:47.360445

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.sketcher_interfaces.curve_2D import Curve2D


class Hyperbola2D(Curve2D):
    """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     SketcherInterfaces.GeometricElement
                |                         SketcherInterfaces.Geometry2D
                |                             SketcherInterfaces.Curve2D
                |                                 Hyperbola2D
                | 
                | Class defining an hyperbola in 2D Space.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.hyperbola2_d = com_object

    @property
    def imaginary_radius(self):
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445)
                | o Property ImaginaryRadius() As double (Read Only)
                | 
                |     Returns the minor radius of the hyperbola in 2D space
                | 
                |     Parameters:
                | 
                |         oMinorRadius
                |             The minor radius of the hyperbola

        :return: float
        """

        return self.hyperbola2_d.ImaginaryRadius

    @property
    def radius(self):
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445)
                | o Property Radius() As double (Read Only)
                | 
                |     Returns the major radius of the hyperbola in 2D space
                | 
                |     Parameters:
                | 
                |         oMajorRadius
                |             The major radius of the hyperbola

        :return: float
        """

        return self.hyperbola2_d.Radius

    def get_axis(self, o_axis):
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Sub GetAxis(CATSafeArrayVariant oAxis)
                | 
                |     Returns the axis vector direction of the hyperbola in 2D
                |     space
                | 
                |     Parameters:
                | 
                |         oAxis[0]
                |             The X coordinate of the axis vector direction 
                |         oAxis[1]
                |             The Y coordinate of the axis vector direction

        :param tuple o_axis:
        :return: None
        """
        return self.hyperbola2_d.GetAxis(o_axis)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_axis'
        # # vba_code = """
        # # Public Function get_axis(hyperbola2_d)
        # #     Dim oAxis (2)
        # #     hyperbola2_d.GetAxis oAxis
        # #     get_axis = oAxis
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_center(self, o_center):
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Sub GetCenter(CATSafeArrayVariant oCenter)
                | 
                |     Returns the center point of the hyperbola in 2D space
                | 
                |     Parameters:
                | 
                |         oCenter[0]
                |             The X Coordinate of the center point of the hyperbola
                |             
                |         oCenter[1]
                |             The Y Coordinate of the center point of the
                |             hyperbola

        :param tuple o_center:
        :return: None
        """
        return self.hyperbola2_d.GetCenter(o_center)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_center'
        # # vba_code = """
        # # Public Function get_center(hyperbola2_d)
        # #     Dim oCenter (2)
        # #     hyperbola2_d.GetCenter oCenter
        # #     get_center = oCenter
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def set_data(self, i_center_x, i_center_y, i_axis_x, i_axis_y, i_major_radius, i_minor_radius):
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Sub SetData(double iCenterX,
                | double iCenterY,
                | double iAxisX,
                | double iAxisY,
                | double iMajorRadius,
                | double iMinorRadius)
                | 
                |     Modifies the caracteristics of the hyperbola
                | 
                |     Parameters:
                | 
                |         iCenterX
                |             The X Coordinate of the hyperbola center 
                |         iCenterY
                |             The Y Coordinate of the hyperbola center 
                |         iAxisX
                |             The X coordinate of the axis vector direction 
                |         iAxisY
                |             The Y coordinate of the axis vector direction 
                |         iMajorRadius
                |             The length of the major radius 
                |         iMinorRadius
                |             The length of the minor radius

        :param float i_center_x:
        :param float i_center_y:
        :param float i_axis_x:
        :param float i_axis_y:
        :param float i_major_radius:
        :param float i_minor_radius:
        :return: None
        """
        return self.hyperbola2_d.SetData(i_center_x, i_center_y, i_axis_x, i_axis_y, i_major_radius, i_minor_radius)

    def __repr__(self):
        return f'Hyperbola2D(name="{self.name}")'
