#! usr/bin/python3.6
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-06-11 12:40:47.360445

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.space_analyses_interfaces.conflicts import Conflicts
from pycatia.system_interfaces.any_object import AnyObject


class ClashResult(AnyObject):

    """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     ClashResult
                | 
                | Represents the ClashResult object.
                | The ClashResult object is a set of conflicts resulting from a clash
                | detection.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.clash_result = com_object

    @property
    def conflicts(self):
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445)
                | o Property Conflicts() As Conflicts (Read Only)
                | 
                |     Returns the collection of computed Conflicts.
                | 
                |     Example:
                | 
                |              This example retrieves the conflicts of NewClashResult
                |              ClashResult.
                |             
                | 
                |             Dim NewConflicts As Conflicts
                |             Set NewConflicts = NewClashResult.Conflicts

        :return: Conflicts
        """

        return Conflicts(self.clash_result.Conflicts)

    def export(self, i_type=None, i_path=None):
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Sub Export(CatClashExportType iType,
                | CATBSTR iPath)
                | 
                |     Exports the results in a XML file.
                | 
                |     Parameters:
                | 
                |         iType
                |             The type of export. 
                |         iPath
                |             The path of the file. 
                | 
                |     Example:
                | 
                |              This example exports the results of NewClashResult
                |              ClashResult.
                |             
                | 
                |             Dim ThePath As String
                |             NewClashResult.Export CatClashExportTypeXMLResultOnly,
                |             "c:\\tmp\\sample.xml"

        :param CatClashExportType i_type:
        :param str i_path:
        :return: None
        """
        return self.clash_result.Export(i_type.com_object, i_path)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'export'
        # # vba_code = """
        # # Public Function export(clash_result)
        # #     Dim iType (2)
        # #     clash_result.Export iType
        # #     export = iType
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'ClashResult(name="{ self.name }")'
