# -*- coding: utf-8 -*-
# Generated by Django 1.11.23 on 2019-09-07 16:18
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import leprikon.models.fields


def create_subject_registration_participants(apps, schema_editor):
    SubjectRegistration = apps.get_model('leprikon', 'SubjectRegistration')
    SubjectRegistrationParticipant = apps.get_model('leprikon', 'SubjectRegistrationParticipant')
    SubjectRegistrationParticipant.objects.bulk_create(
        SubjectRegistrationParticipant(
            registration=reg,
            participant_gender=reg.participant_gender,
            participant_first_name=reg.participant_first_name,
            participant_last_name=reg.participant_last_name,
            participant_birth_num=reg.participant_birth_num,
            participant_street=reg.participant_street,
            participant_city=reg.participant_city,
            participant_postal_code=reg.participant_postal_code,
            participant_phone=reg.participant_phone,
            participant_email=reg.participant_email,
            participant_school_other=reg.participant_school_other,
            participant_school_class=reg.participant_school_class,
            participant_health=reg.participant_health,
            has_parent1=reg.has_parent1,
            parent1_first_name=reg.parent1_first_name,
            parent1_last_name=reg.parent1_last_name,
            parent1_street=reg.parent1_street,
            parent1_city=reg.parent1_city,
            parent1_postal_code=reg.parent1_postal_code,
            parent1_phone=reg.parent1_phone,
            parent1_email=reg.parent1_email,
            has_parent2=reg.has_parent2,
            parent2_first_name=reg.parent2_first_name,
            parent2_last_name=reg.parent2_last_name,
            parent2_street=reg.parent2_street,
            parent2_city=reg.parent2_city,
            parent2_postal_code=reg.parent2_postal_code,
            parent2_phone=reg.parent2_phone,
            parent2_email=reg.parent2_email,
            answers=reg.answers,
            participant_age_group_id=reg.participant_age_group_id,
            participant_citizenship_id=reg.participant_citizenship_id,
            participant_school_id=reg.participant_school_id,
        )
        for reg in SubjectRegistration.objects.iterator()
    )


def create_journalentry_participants(apps, schema_editor):
    JournalEntry = apps.get_model('leprikon', 'JournalEntry')
    SubjectRegistrationParticipant = apps.get_model('leprikon', 'SubjectRegistrationParticipant')
    for journal_entry in JournalEntry.objects.iterator():
        journal_entry.participants.set(SubjectRegistrationParticipant.objects.filter(
            registration__journal_entries=journal_entry,
        ))


class Migration(migrations.Migration):

    dependencies = [
        ('leprikon', '0031_registration_questions_agreements'),
    ]

    operations = [
        migrations.CreateModel(
            name='SubjectRegistrationGroupMember',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('first_name', models.CharField(max_length=30, verbose_name='first name')),
                ('last_name', models.CharField(max_length=30, verbose_name='last name')),
                ('note', models.CharField(blank=True, default='', max_length=150, verbose_name='note')),
            ],
            options={
                'verbose_name': 'group member',
                'verbose_name_plural': 'group members',
            },
        ),
        migrations.CreateModel(
            name='SubjectRegistrationParticipant',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('participant_gender', models.CharField(choices=[('m', 'male'), ('f', 'female')], editable=False, max_length=1, verbose_name='gender')),
                ('participant_first_name', models.CharField(max_length=30, verbose_name='first name')),
                ('participant_last_name', models.CharField(max_length=30, verbose_name='last name')),
                ('participant_birth_num', leprikon.models.fields.BirthNumberField(verbose_name='birth number')),
                ('participant_street', models.CharField(max_length=150, verbose_name='street')),
                ('participant_city', models.CharField(max_length=150, verbose_name='city')),
                ('participant_postal_code', leprikon.models.fields.PostalCodeField(verbose_name='postal code')),
                ('participant_phone', models.CharField(blank=True, default='', max_length=30, verbose_name='phone')),
                ('participant_email', leprikon.models.fields.EmailField(blank=True, default='', max_length=254, verbose_name='email address')),
                ('participant_school_other', models.CharField(blank=True, default='', max_length=150, verbose_name='other school')),
                ('participant_school_class', models.CharField(blank=True, default='', max_length=30, verbose_name='class')),
                ('participant_health', models.TextField(blank=True, default='', verbose_name='health')),
                ('has_parent1', models.BooleanField(default=False, verbose_name='first parent')),
                ('parent1_first_name', models.CharField(blank=True, max_length=30, null=True, verbose_name='first name')),
                ('parent1_last_name', models.CharField(blank=True, max_length=30, null=True, verbose_name='last name')),
                ('parent1_street', models.CharField(blank=True, max_length=150, null=True, verbose_name='street')),
                ('parent1_city', models.CharField(blank=True, max_length=150, null=True, verbose_name='city')),
                ('parent1_postal_code', leprikon.models.fields.PostalCodeField(blank=True, null=True, verbose_name='postal code')),
                ('parent1_phone', models.CharField(blank=True, max_length=30, null=True, verbose_name='phone')),
                ('parent1_email', leprikon.models.fields.EmailField(blank=True, max_length=254, null=True, verbose_name='email address')),
                ('has_parent2', models.BooleanField(default=False, verbose_name='second parent')),
                ('parent2_first_name', models.CharField(blank=True, max_length=30, null=True, verbose_name='first name')),
                ('parent2_last_name', models.CharField(blank=True, max_length=30, null=True, verbose_name='last name')),
                ('parent2_street', models.CharField(blank=True, max_length=150, null=True, verbose_name='street')),
                ('parent2_city', models.CharField(blank=True, max_length=150, null=True, verbose_name='city')),
                ('parent2_postal_code', leprikon.models.fields.PostalCodeField(blank=True, null=True, verbose_name='postal code')),
                ('parent2_phone', models.CharField(blank=True, max_length=30, null=True, verbose_name='phone')),
                ('parent2_email', leprikon.models.fields.EmailField(blank=True, max_length=254, null=True, verbose_name='email address')),
                ('answers', models.TextField(blank=True, default='{}', editable=False, verbose_name='additional answers')),
                ('participant_age_group', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='+', to='leprikon.AgeGroup', verbose_name='age group')),
                ('participant_citizenship', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='+', to='leprikon.Citizenship', verbose_name='citizenship')),
                ('participant_school', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='leprikon.School', verbose_name='school')),
            ],
            options={
                'ordering': ('last_name', 'first_name'),
                'verbose_name': 'participant',
                'verbose_name_plural': 'participants',
            },
        ),
        migrations.AddField(
            model_name='subjectregistration',
            name='group_name',
            field=models.CharField(blank=True, default='', max_length=150, verbose_name='group name'),
        ),
        migrations.AddField(
            model_name='subjectregistrationgroupmember',
            name='registration',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='group_members', to='leprikon.SubjectRegistration', verbose_name='registration'),
        ),
        migrations.AddField(
            model_name='subjectregistrationparticipant',
            name='registration',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='participants', to='leprikon.SubjectRegistration', verbose_name='registration'),
        ),
        migrations.RenameField(
            model_name='subject',
            old_name='max_count',
            new_name='max_registrations_count',
        ),
        migrations.RenameField(
            model_name='subject',
            old_name='min_count',
            new_name='min_registrations_count',
        ),
        migrations.AlterField(
            model_name='subject',
            name='max_registrations_count',
            field=models.PositiveIntegerField(blank=True, null=True, verbose_name='maximal registrations count'),
        ),
        migrations.AlterField(
            model_name='subject',
            name='min_registrations_count',
            field=models.PositiveIntegerField(blank=True, null=True, verbose_name='minimal registrations count'),
        ),
        migrations.AddField(
            model_name='subject',
            name='max_group_members_count',
            field=models.PositiveIntegerField(default=0, help_text='Group member details only include name and note.', verbose_name='maximal group members count per registration'),
        ),
        migrations.AddField(
            model_name='subject',
            name='min_group_members_count',
            field=models.PositiveIntegerField(default=0, help_text='Group member details only include name and note.', verbose_name='minimal group members count per registration'),
        ),
        migrations.AddField(
            model_name='subject',
            name='max_participants_count',
            field=models.PositiveIntegerField(default=1, help_text='Participant details include birth number (birth day), age group, contacts, parent, etc.', verbose_name='maximal participants count per registration'),
        ),
        migrations.AddField(
            model_name='subject',
            name='min_participants_count',
            field=models.PositiveIntegerField(default=1, help_text='Participant details include birth number (birth day), age group, contacts, parent, etc.', verbose_name='minimal participants count per registration'),
        ),
        migrations.RunPython(create_subject_registration_participants),
        migrations.RemoveField(
            model_name='subjectregistration',
            name='answers',
        ),
        migrations.RemoveField(
            model_name='subjectregistration',
            name='has_parent1',
        ),
        migrations.RemoveField(
            model_name='subjectregistration',
            name='has_parent2',
        ),
        migrations.RemoveField(
            model_name='subjectregistration',
            name='parent1_city',
        ),
        migrations.RemoveField(
            model_name='subjectregistration',
            name='parent1_email',
        ),
        migrations.RemoveField(
            model_name='subjectregistration',
            name='parent1_first_name',
        ),
        migrations.RemoveField(
            model_name='subjectregistration',
            name='parent1_last_name',
        ),
        migrations.RemoveField(
            model_name='subjectregistration',
            name='parent1_phone',
        ),
        migrations.RemoveField(
            model_name='subjectregistration',
            name='parent1_postal_code',
        ),
        migrations.RemoveField(
            model_name='subjectregistration',
            name='parent1_street',
        ),
        migrations.RemoveField(
            model_name='subjectregistration',
            name='parent2_city',
        ),
        migrations.RemoveField(
            model_name='subjectregistration',
            name='parent2_email',
        ),
        migrations.RemoveField(
            model_name='subjectregistration',
            name='parent2_first_name',
        ),
        migrations.RemoveField(
            model_name='subjectregistration',
            name='parent2_last_name',
        ),
        migrations.RemoveField(
            model_name='subjectregistration',
            name='parent2_phone',
        ),
        migrations.RemoveField(
            model_name='subjectregistration',
            name='parent2_postal_code',
        ),
        migrations.RemoveField(
            model_name='subjectregistration',
            name='parent2_street',
        ),
        migrations.RemoveField(
            model_name='subjectregistration',
            name='participant_age_group',
        ),
        migrations.RemoveField(
            model_name='subjectregistration',
            name='participant_birth_num',
        ),
        migrations.RemoveField(
            model_name='subjectregistration',
            name='participant_citizenship',
        ),
        migrations.RemoveField(
            model_name='subjectregistration',
            name='participant_city',
        ),
        migrations.RemoveField(
            model_name='subjectregistration',
            name='participant_email',
        ),
        migrations.RemoveField(
            model_name='subjectregistration',
            name='participant_first_name',
        ),
        migrations.RemoveField(
            model_name='subjectregistration',
            name='participant_gender',
        ),
        migrations.RemoveField(
            model_name='subjectregistration',
            name='participant_health',
        ),
        migrations.RemoveField(
            model_name='subjectregistration',
            name='participant_last_name',
        ),
        migrations.RemoveField(
            model_name='subjectregistration',
            name='participant_phone',
        ),
        migrations.RemoveField(
            model_name='subjectregistration',
            name='participant_postal_code',
        ),
        migrations.RemoveField(
            model_name='subjectregistration',
            name='participant_school',
        ),
        migrations.RemoveField(
            model_name='subjectregistration',
            name='participant_school_class',
        ),
        migrations.RemoveField(
            model_name='subjectregistration',
            name='participant_school_other',
        ),
        migrations.RemoveField(
            model_name='subjectregistration',
            name='participant_street',
        ),
        migrations.AddField(
            model_name='journalentry',
            name='participants',
            field=models.ManyToManyField(blank=True, related_name='journal_entries', to='leprikon.SubjectRegistrationParticipant', verbose_name='participants'),
        ),
        migrations.RunPython(create_journalentry_participants),
        migrations.RemoveField(
            model_name='journalentry',
            name='registrations',
        ),
    ]
