# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/00_pipes.ipynb (unless otherwise specified).

__all__ = ['TransformationPipe']

# Cell
class TransformationPipe:
    """
    Transformation pipeline performs a series of transformation processes based on the user's defined functions.

    This is the basic sequenctial pipeline.

    Input:
        steps (list): contains a list of names and functions and an optional third argument for each step is an dictionary of parameters to be passed to that function.

    e.g.
    If the user has defined the following functions - temporalCrop, spatialCrop - then this is how to assemlbe a Transformation pipeline for these:

        transPipe = TransformationPipe(
                steps=[
                    ('time horizon selection', temporalCrop, {"timeLength": 18}),
                    ('region selection', spatialCrop, {"boundingBox": [120, -15, 160, 15]}),
                    ])

    """

    def __init__(self, steps: list):
        """
        Args:
        - steps (list): list of steps to be evaluated sequentially.
            ("step name", step_fuction, <optinal>function_kwargs)
        """
        self.steps = steps
        self.step_names = [s[0] for s in steps]

    def evaluate(self, dataobject):
        """
        Apply transformation steps to the dataobject in sequence.
        """
        assert len(
            self.steps
        ) >= 1, "---| Please define at least one transformation step"
        for step in self.steps:
            if len(step) == 2:
                dataobject = step[1](dataobject)
            elif len(step) == 3:
                # if kwargs are provided as argument #3
                dataobject = step[1](dataobject, **step[2])
        return dataobject