# pyngrok - a Python wrapper for ngrok [![Tweet](https://img.shields.io/twitter/url/http/shields.io.svg?style=social)](https://twitter.com/intent/tweet?text=Unleash+the+power+of+ngrok%2C+programmatically+tunneling+to+localhost%2C+in+your+Python+applications+with+pyngrok.&url=https://github.com/alexdlaird/pyngrok&via=alexdlaird&hashtags=ngrok,tunnel,webhook,localhost,pyngrok)

[![PyPI version](https://badge.fury.io/py/pyngrok.svg)](https://badge.fury.io/py/pyngrok)
[![Build Status](https://travis-ci.org/alexdlaird/pyngrok.svg?branch=master)](https://travis-ci.org/alexdlaird/pyngrok)
[![codecov](https://codecov.io/gh/alexdlaird/pyngrok/branch/master/graph/badge.svg)](https://codecov.io/gh/alexdlaird/pyngrok)
[![Documentation Status](https://readthedocs.org/projects/pyngrok/badge/?version=latest)](https://pyngrok.readthedocs.io/en/latest/?badge=latest)
[![image](https://img.shields.io/pypi/pyversions/pyngrok.svg)](https://pypi.org/project/pyngrok/)
[![PyPI license](https://img.shields.io/pypi/l/pyngrok.svg)](https://pypi.org/project/pyngrok/)

`pyngrok` is a Python wrapper for `ngrok` that manages its own binary and puts
it on your path, making `ngrok` readily available from anywhere on the command line and via a
convenient Python API.

[ngrok](https://ngrok.com) is a reverse proxy tool that opens secure tunnels from public URLs to localhost, perfect
for exposing local web servers, building webhook integrations, enabling SSH access, testing chatbots, demoing from
your own machine, and more, made even more powerful with native Python integration through `pyngrok`.

## Installation

`pyngrok` is available on [PyPI](https://pypi.org/project/pyngrok/) and can be installed
using `pip`.

```sh
pip install pyngrok
```

That's it! `pyngrok` is now available as a package to our Python projects, and `ngrok` is now available from
the command line.

## Basic Usage

To open a tunnel, use the `connect()` method, which returns the public URL generated by `ngrok`.

```python
from pyngrok import ngrok

# Open a HTTP tunnel on the default port 80
public_url = ngrok.connect()
# Open a SSH tunnel
ssh_url = ngrok.connect(22, "tcp")
```

The `connect()` method takes an optional `options` parameter, which allows us to pass additional
options that are [supported by ngrok](https://ngrok.com/docs#tunnel-definitions).

This package puts the default `ngrok` binary on our path, so all features of `ngrok` are
available on the command line.

```sh
ngrok http 80
```

For details on how to fully leverage `ngrok` from the command line, see [ngrok's official documentation](https://ngrok.com/docs).

## Documentation

For more advanced usage, `pyngrok`'s official documentation is available at [http://pyngrok.readthedocs.io](http://pyngrok.readthedocs.io).

## Contributing

If you find issues, [report them on GitHub](https://github.com/alexdlaird/pyngrok/issues). Pull
requests for fixes and features are warmly welcomed.

Be sure to review the [Contribution Guide](https://github.com/alexdlaird/pyngrok/blob/master/CONTRIBUTING.md) and
[Code of Conduct](https://github.com/alexdlaird/pyngrok/blob/master/CODE_OF_CONDUCT.md) before submitting issues
or pull requests.

Want to contribute financially? If you've found `pyngrok` useful, [a donation](https://www.paypal.me/alexdlaird) would
also be greatly appreciated!
