# AUTOGENERATED! DO NOT EDIT! File to edit: 00_core.ipynb (unless otherwise specified).

__all__ = ['D_LEN', 'C_LEN', 'tonal_sum']

# Cell

import itertools

D_LEN = 7  # "Diatonic Length" - The number of tones in a diatonic scale.
C_LEN = 12 # "Chromatic Length" - The number of tones in a chromatic scale.

# Cell
#export

def _tonal_modulo(x):
    """Returns an octave-normalized rendering of x.
    Examples
    --------
    >>> _tonal_modulo((7, 12)) # C + 1 octave, no octave designation
    (0, 0)
    >>> _tonal_modulo((7, 12, 0)) # C + 1 octave
    (0, 0, 1)
    >>> _tonal_modulo((-1, -1)) # B - 1 octave
    (6, 11)
    >>> _tonal_modulo((-1, -1, 0)) # B - 1 octave
    (6, 11, -1)
    >>> _tonal_modulo((-1, 0))
    (6, 0)
    >>> _tonal_modulo((7, 12, 1))
    (0, 0, 2)
    """

    # From (0,0) to (6,11) (inclusive), no modulo is needed.
    if x[0] in range(D_LEN) and x[1] in range(C_LEN):
        return x

    d_val = x[0] % D_LEN # The normalized diatonic value.
    d_oct = x[0] // D_LEN # The additional diatonic octave.
    c_val = x[1] % C_LEN # The normalized chromatic value.

    if len(x) == 2:
        return (d_val, c_val)

    if len(x) == 3:
        return (d_val, c_val, (x[2] + d_oct))

# Cell

def tonal_sum(x, y):
    """Returns the value of x + y.

    Examples
    --------
    >>> tonal_sum((0, 0), (2, 3))
    (2, 3)
    >>> tonal_sum((3, 6), (4, 6))
    (0, 0)
    >>> tonal_sum((0, 0, 0), (2, 3))
    (2, 3, 0)
    >>> tonal_sum((3, 6, 0), (4, 6))
    (0, 0, 1)
    >>> tonal_sum((6, 11, 1), (2, 4))
    (1, 3, 2)
    """

    if len(x) < len(y):
        raise TypeError("An octave designation cannot be added to an abstract tonal value.")

    sum = tuple(xval+yval for xval,yval in itertools.zip_longest(x,y, fillvalue=0))

    sum = _tonal_modulo(sum)

    sum = tuple([round(x, 2) for x in sum])

    return sum