# Generated by Django 3.2.6 on 2022-02-24 15:11

import uuid

import django.contrib.postgres.fields.jsonb
from django.db import migrations
from django.db import models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='BonusPayment',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('bonus_id', models.PositiveIntegerField(verbose_name='ID бонуса в системе Фарм-Заказ')),
                ('bonus_payment_status', models.PositiveSmallIntegerField(blank=True, choices=[(1, 'Акт сформирован в системе дистрибьютора'), (2, 'Акт передан на подписание'), (3, 'Акт подписан аптечным учреждением'), (4, 'Выплата оформлена в системе дистрибьютора'), (5, 'Выплачено'), (6, 'Ошибка')], null=True, verbose_name='Статус выплаты бонусов')),
                ('status_date', models.DateField(blank=True, null=True, verbose_name='Дата обновления статуса')),
                ('comment', models.CharField(blank=True, max_length=500, null=True, verbose_name='Комментарий')),
                ('payment_order', models.CharField(blank=True, max_length=100, null=True, verbose_name='Номер подтверждающего документа (платёжного поручения, кредит-ноты и пр.)')),
                ('ext_id', models.CharField(max_length=100, verbose_name='Внешний id выплаты')),
            ],
            options={
                'verbose_name': 'Бонус',
                'verbose_name_plural': 'Бонусы',
            },
        ),
        migrations.CreateModel(
            name='Branch',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('inn', models.CharField(default=None, max_length=12, null=True, unique=True, verbose_name='ИНН')),
                ('kpp', models.CharField(blank=True, default=None, max_length=9, null=True, verbose_name='КПП')),
                ('name', models.CharField(max_length=255, verbose_name='Название филиала')),
                ('address', models.CharField(max_length=255, verbose_name='Адрес филиала')),
                ('sended', models.BooleanField(default=False, verbose_name='Передан в ФармЗаказ')),
                ('sended_at', models.DateTimeField(null=True, verbose_name='Время отправки в ФЗ')),
                ('created_at', models.DateTimeField(auto_now=True, verbose_name='Время создания')),
                ('warehouse_id', models.PositiveIntegerField(help_text='example: 30', null=True, verbose_name='Id в системе ФЗ')),
                ('ext_data', models.JSONField(blank=True, default=dict, null=True)),
                ('guid', models.UUIDField(default=uuid.uuid4, verbose_name='GUID филиала')),
                ('abbreviation', models.CharField(blank=True, max_length=50, null=True, verbose_name='Сокращенное название (Префикс)')),
            ],
            options={
                'verbose_name': 'Филиал',
                'verbose_name_plural': 'Филиалы',
            },
        ),
        migrations.CreateModel(
            name='ErrorsRequest',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now=True, verbose_name='Время получения ошибки')),
                ('error', models.CharField(max_length=500, verbose_name='Текст ошибки запроса')),
                ('request', models.CharField(max_length=500, null=True, verbose_name='Запрос')),
                ('status_code', models.CharField(max_length=20, null=True, verbose_name='Код ответа')),
            ],
            options={
                'verbose_name': 'Ошибки запроса',
                'verbose_name_plural': 'Ошибки запросов',
            },
        ),
        migrations.CreateModel(
            name='Invoice',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('order_ext_id', models.CharField(max_length=30, verbose_name='Номер заказа')),
                ('invoice_num', models.CharField(editable=False, max_length=30, verbose_name='Номер накладной')),
                ('accepted', models.DateTimeField(auto_now=True, verbose_name='Дата получения накладной')),
                ('delivered', models.DateTimeField(blank=True, null=True, verbose_name='Дата доставки товара')),
                ('created', models.DateTimeField(verbose_name='Дата создания')),
                ('is_accept', models.BooleanField(blank=True, default=False, null=True, verbose_name='Принята аптекой?')),
                ('store_ext_id', models.CharField(max_length=50, verbose_name='Код аптеки в системе дистрибьютора')),
                ('sku_ext_id', models.CharField(help_text='example: 00001', max_length=100, verbose_name='Код товара в системе дистрибьютора')),
                ('delivered_quantity', models.PositiveIntegerField(help_text='example: 30', verbose_name='Количество доставленных упаковок товара (шт.)')),
                ('delivered_sum', models.DecimalField(decimal_places=2, help_text='example: 5000.5', max_digits=10, verbose_name='Стоимость доставленных упаковок товара (С НДС)')),
            ],
            options={
                'verbose_name': 'Накладная',
                'verbose_name_plural': 'Накладные',
            },
        ),
        migrations.CreateModel(
            name='KafkaMsg',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now=True, verbose_name='Время создания')),
                ('topic', models.CharField(max_length=120, verbose_name='Имя топика')),
                ('msg', models.JSONField(default=dict)),
            ],
            options={
                'verbose_name': 'Очередь сообщений',
                'verbose_name_plural': 'Очередь сообщений',
            },
        ),
        migrations.CreateModel(
            name='Nomenclature',
            fields=[
                ('gtin', models.CharField(blank=True, default=None, max_length=14, null=True)),
                ('ean13', models.CharField(blank=True, default=None, max_length=13, null=True)),
                ('code', models.CharField(max_length=5, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=255)),
                ('sended', models.BooleanField(default=False, verbose_name='Передан в ФармЗаказ')),
                ('sended_at', models.DateTimeField(null=True, verbose_name='Время отправки номенклатуры в ФЗ')),
                ('comment', models.CharField(max_length=255, null=True)),
            ],
            options={
                'verbose_name': 'Номенклатура',
                'verbose_name_plural': 'Номенклатуры',
            },
        ),
        migrations.CreateModel(
            name='Order',
            fields=[
                ('order_id', models.BigAutoField(primary_key=True, serialize=False)),
                ('status', models.CharField(choices=[('new', 'Новый'), ('transmitted', 'ПолученДистрибьютором'), ('confirmed', 'Подтвержден'), ('assembly', 'ПереданНаСборку'), ('equipped', 'Укомплектован'), ('sent', 'Отправлен'), ('delivered', 'Доставлен'), ('canceled', 'Отменен'), ('blocked', 'Заблокирован'), ('refund', 'Возврат')], max_length=30, verbose_name='Статус заказа.')),
                ('store_ext_id', models.CharField(max_length=50, verbose_name='id аптеки в системе дистрибьютора')),
                ('updated', models.DateTimeField(blank=True, null=True, verbose_name='Время, когда заказ был обновлен в последний раз в системе Фарм-Заказ')),
                ('created', models.DateTimeField(blank=True, null=True, verbose_name='Время, когда заказ был создан в системе ФармЗаказ')),
                ('warehouse_ext_id', models.CharField(help_text='example: H0312', max_length=100, verbose_name='id склада в системе дистрибьютора')),
                ('total_sum', models.DecimalField(decimal_places=2, help_text='example: 5000.5', max_digits=10, verbose_name='Сумма заказа (С НДС)')),
                ('vat_sum', models.DecimalField(decimal_places=2, help_text='example: 500', max_digits=10, verbose_name='Сумма НДС')),
                ('document_number', models.CharField(blank=True, max_length=11, null=True, verbose_name='Номер заказа в 1С')),
                ('count_positions', models.IntegerField(blank=True, verbose_name='Количество позиций в заказе')),
                ('sended_to_one_c', models.BooleanField(default=False)),
                ('sended_to_pz', models.BooleanField(default=False)),
            ],
            options={
                'verbose_name': 'Заказ',
                'verbose_name_plural': 'Заказы',
            },
        ),
        migrations.CreateModel(
            name='OrderStatusMap',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status_one_c', models.SmallIntegerField(choices=[(1, 'Создан'), (2, 'Отдан на сборку'), (3, 'Принят складом'), (4, 'Подготовка к сборке'), (5, 'Отгружен'), (6, 'Доставлен'), (7, 'Частично доставлен'), (8, 'Расформирован'), (9, 'Консолидирован'), (10, 'Отказной'), (11, 'Не доставлен')], verbose_name='Статус заказа в 1С')),
                ('status_pharm_zakaz', models.SmallIntegerField(choices=[('new', 'Новый'), ('transmitted', 'ПолученДистрибьютором'), ('confirmed', 'Подтвержден'), ('assembly', 'ПереданНаСборку'), ('equipped', 'Укомплектован'), ('sent', 'Отправлен'), ('delivered', 'Доставлен'), ('canceled', 'Отменен'), ('blocked', 'Заблокирован'), ('refund', 'Возврат')], verbose_name='Статус заказа в ФармЗаказ')),
            ],
            options={
                'verbose_name': 'Соответствие статусов',
                'verbose_name_plural': 'Соответствие статусов',
            },
        ),
        migrations.CreateModel(
            name='RateLimit',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('system', models.CharField(max_length=50, verbose_name='Система')),
                ('api_method', models.CharField(blank=True, help_text='<strong>Пример:</strong> <em>GET https://demo.pharm-zakaz.ru/api/distributor/v1/stores/</em>', max_length=255, verbose_name='API метод')),
                ('limit', models.IntegerField(blank=True, help_text='Максимальное количество запросов за временной интервал', null=True, verbose_name='Количество запросов')),
                ('window', models.IntegerField(blank=True, help_text='Интервал в котором будут считаться запросы для limit', null=True, verbose_name='Временной интервал в секундах')),
            ],
        ),
        migrations.CreateModel(
            name='Residue',
            fields=[
                ('gtin', models.CharField(blank=True, help_text=' Если для не существует GTIN, то указывается EAN-13 (для БАДов, косметики и пр). Формат - 14 цифр', max_length=27, null=True, verbose_name='GTIN – код товарной единицы согласно стандарту GS1.')),
                ('series', models.CharField(blank=True, help_text='Указывается номер серии товара, для которой явным образом указана дата производства и дата истечения срока годности', max_length=50, null=True, verbose_name='Номер серии товара.')),
                ('ean13', models.CharField(max_length=13, verbose_name='Код EAN13')),
                ('warehouse_ext_id', models.CharField(max_length=100, verbose_name='Уникальный идентификатор склада в системе дистрибьютора')),
                ('quantity', models.IntegerField(help_text='За исключением товаров в резерве, в транзите и т.п.', verbose_name='Количество упаковок на складе дистрибьютора, доступное для заказа')),
                ('expiration_date', models.DateTimeField(null=True, verbose_name='Дата окончания срока годности')),
                ('ext_id', models.CharField(default=uuid.uuid4, max_length=100, primary_key=True, serialize=False, verbose_name='ID остатка товара в системе дистрибьютора')),
                ('nomenclature', models.CharField(max_length=5, verbose_name='Номенклатура')),
                ('uid_batch', models.CharField(max_length=100, null=True, verbose_name='Идентификатор группы остатков')),
                ('sended', models.BooleanField(default=False, verbose_name='Передан в ФармЗаказ')),
                ('sended_at', models.DateTimeField(null=True, verbose_name='Время отправки в ФЗ')),
                ('created_at', models.DateTimeField(auto_now=True, verbose_name='Время создания записи')),
                ('rest_time', models.DateTimeField(blank=True, null=True, verbose_name='Время среза остатков')),
            ],
            options={
                'verbose_name': 'Остаток',
                'verbose_name_plural': 'Остатки',
            },
        ),
        migrations.CreateModel(
            name='ResidueHistory',
            fields=[
                ('gtin', models.CharField(blank=True, help_text=' Если для не существует GTIN, то указывается EAN-13 (для БАДов, косметики и пр). Формат - 14 цифр', max_length=27, null=True, verbose_name='GTIN – код товарной единицы согласно стандарту GS1.')),
                ('series', models.CharField(blank=True, help_text='Указывается номер серии товара, для которой явным образом указана дата производства и дата истечения срока годности', max_length=50, null=True, verbose_name='Номер серии товара.')),
                ('ean13', models.CharField(max_length=13, verbose_name='Код EAN13')),
                ('warehouse_ext_id', models.CharField(max_length=100, verbose_name='Уникальный идентификатор склада в системе дистрибьютора')),
                ('quantity', models.IntegerField(help_text='За исключением товаров в резерве, в транзите и т.п.', verbose_name='Количество упаковок на складе дистрибьютора, доступное для заказа')),
                ('expiration_date', models.DateTimeField(verbose_name='Дата окончания срока годности')),
                ('ext_id', models.CharField(default=uuid.uuid4, max_length=100, primary_key=True, serialize=False, verbose_name='ID остатка товара в системе дистрибьютора')),
                ('nomenclature', models.CharField(max_length=5, verbose_name='Номенклатура')),
                ('uid_batch', models.CharField(max_length=100, verbose_name='Идентификатор группы остатков')),
                ('created_at', models.DateTimeField(auto_now=True, verbose_name='Время создания записи')),
                ('sended', models.BooleanField(default=False, verbose_name='Передан в ФармЗаказ')),
                ('sended_at', models.DateTimeField(null=True, verbose_name='Время отправки в ФЗ')),
                ('rest_time', models.DateTimeField(blank=True, null=True, verbose_name='Время среза остатков')),
            ],
            options={
                'verbose_name': 'История остатка',
                'verbose_name_plural': 'История остатков',
            },
        ),
        migrations.CreateModel(
            name='Store',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('store_info_id', models.IntegerField(blank=True, null=True, verbose_name='Код аптеки в системе дистрибьютора')),
                ('inn', models.CharField(max_length=100, verbose_name='ИНН юридического лица')),
                ('legal_name', models.CharField(max_length=100, verbose_name='Название юридического лица')),
                ('fias_id', models.CharField(blank=True, help_text='К примеру, 77000000000000004960678', max_length=100, null=True, verbose_name='ФИАС аптеки - номер')),
                ('fias_code', models.CharField(blank=True, help_text='К примеру, 9acd20fe-ac30-45bc-a254-d60aa9b0be4e', max_length=100, null=True, verbose_name='ФИАС аптеки - код')),
                ('federal_district', models.CharField(blank=True, help_text='К примеру, Центральный', max_length=100, null=True, verbose_name='Федеральный округ')),
                ('region', models.CharField(blank=True, help_text='К примеру, Московская обл', max_length=100, null=True, verbose_name='Регион.')),
                ('regional_district', models.CharField(blank=True, help_text='К примеру, Центральный', max_length=100, null=True, verbose_name='Субъект федерации (регион).')),
                ('city', models.CharField(help_text='К примеру, Дмитров г', max_length=100, verbose_name='Город (Населённый пункт)')),
                ('street', models.CharField(help_text='К примеру, им Константина Аверьянова мкр', max_length=100, verbose_name='Улица')),
                ('building', models.CharField(help_text='дом 5', max_length=10, verbose_name='Строение')),
                ('full_address', models.CharField(blank=True, help_text='К примеру, Московская обл, Дмитровский р-н, Дмитров г, им Константина Аверьянова мкр, 3', max_length=300, null=True, verbose_name='Полный адрес аптеки.')),
                ('has_contract', models.BooleanField(default=False, verbose_name='Имеет ли аптека действующий контракт с дистрибьютором?')),
                ('black_list', models.BooleanField(default=False, verbose_name='Находится ли аптека в черном списке дистрибьютора (дебиторы и пр.)?')),
                ('payment_delay', models.PositiveIntegerField(default=0, verbose_name='Размер отсрочки платежа для аптеки (в днях)')),
                ('pos_ext_id', models.CharField(max_length=100, unique=True, verbose_name='Уникальный идентификатор аптеки в системе дистрибьютора.')),
                ('created', models.DateTimeField(blank=True, null=True, verbose_name='Дата создания записи в БД Фарм-Заказ.')),
                ('sended', models.BooleanField(default=False, verbose_name='Передан в ФармЗаказ')),
                ('sended_at', models.DateTimeField(blank=True, null=True, verbose_name='Время отправки в ФЗ')),
                ('created_at', models.DateTimeField(auto_now=True, verbose_name='Время создания')),
                ('branch', models.CharField(default=None, max_length=12, null=True, verbose_name='ИНН РК')),
                ('warehouses', models.CharField(blank=True, help_text="Пример: [{'warehouseId': 103}]", max_length=500, null=True, verbose_name='Склады Пульса')),
            ],
            options={
                'verbose_name': 'Аптека',
                'verbose_name_plural': 'Аптеки',
            },
        ),
        migrations.CreateModel(
            name='Position',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('gtin', models.CharField(help_text='Если для не существует GTIN, то указывается EAN-13 (для БАДов, косметики и пр). Формат - 14 цифр, example: 05907529465615', max_length=14, verbose_name='GTIN – код товарной единицы согласно стандарту GS1.')),
                ('ean13', models.CharField(help_text='example: 5907529465615', max_length=13, verbose_name='Код EAN13')),
                ('series', models.CharField(blank=True, help_text='Указывается номер серии товара, для которой явным образом указана дата производства и дата истечения срока годностиб, example: 040721', max_length=50, null=True, verbose_name='Номер серии товара.')),
                ('item_id', models.CharField(blank=True, help_text='Возможны 2 и более позиции в одинаковым GTIN (товар по обычной цене и товар с акцией)', max_length=100, null=True, verbose_name='Порядковый id позиции в заказе. ')),
                ('quantity', models.PositiveIntegerField(help_text='example: 30', verbose_name='Количество позиции в заказе (шт.)')),
                ('price', models.DecimalField(decimal_places=2, help_text='example: 130.3', max_digits=10, verbose_name='Цена без НДС для позиции в заказе (одной штуки)')),
                ('vat', models.DecimalField(decimal_places=2, help_text='example: 13', max_digits=10, verbose_name='Сумма НДС на данную позицию (одну штуку)')),
                ('expiration_date', models.DateField(help_text='example: 2024-06-30', verbose_name='Дата конца срока годности')),
                ('ext_id', models.CharField(help_text='example: 30', max_length=100, verbose_name='id продукта позиции в системе дистрибьютора')),
                ('invoice_num', models.CharField(blank=True, max_length=100, null=True, verbose_name='Номер накладной в которой отправлена позиция')),
                ('warehouse_ext_id', models.CharField(blank=True, max_length=100, null=True, verbose_name='Уникальный идентификатор склада в системе дистрибьютора')),
                ('position_id', models.CharField(blank=True, max_length=100, verbose_name='Идентификатор позиции в закказе фармзаказа')),
                ('order', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='positions', to='core.order')),
            ],
            options={
                'verbose_name': 'Позиция заказа',
                'verbose_name_plural': 'Позиции заказа',
            },
        ),
    ]
