# Generated by Django 3.2.6 on 2022-04-29 10:11

from django.db import migrations, models
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0009_auto_20220406_1408'),
    ]

    operations = [
        migrations.CreateModel(
            name='ReconciliationResidue',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('gtin', models.CharField(blank=True, max_length=27, null=True, verbose_name='GTIN – код товарной единицы согласно стандарту GS1.')),
                ('series', models.CharField(blank=True, max_length=50, null=True, verbose_name='Номер серии товара.')),
                ('ean13', models.CharField(max_length=13, verbose_name='Код EAN13')),
                ('warehouse_ext_id', models.CharField(max_length=100, verbose_name='Уникальный идентификатор склада в системе дистрибьютора')),
                ('quantity', models.IntegerField(verbose_name='Количество упаковок на складе дистрибьютора, доступное для заказа')),
                ('quantity_in_pz', models.IntegerField(verbose_name='Количество упаковок на складе дистрибьютора, доступное для заказа')),
                ('expiration_date', models.DateField(null=True, verbose_name='Дата окончания срока годности')),
                ('ext_id', models.CharField(default=uuid.uuid4, max_length=100, verbose_name='ID остатка товара в системе дистрибьютора')),
                ('nomenclature', models.CharField(max_length=5, verbose_name='Номенклатура')),
                ('uid_batch', models.CharField(max_length=100, null=True, verbose_name='Идентификатор группы остатков')),
                ('created_at', models.DateTimeField(auto_now=True, verbose_name='Время создания записи')),
                ('rest_time', models.DateTimeField(blank=True, null=True, verbose_name='Время среза остатков')),
                ('not_in_residue', models.BooleanField(default=False, verbose_name='Отсутствуют в нашей БД')),
                ('not_in_pz', models.BooleanField(default=False, verbose_name='Отсутствуют в БД Фарм заказа')),
                ('not_equal_quantity', models.BooleanField(default=False, verbose_name='Не сходится остаток')),
                ('quantity_discrepancies', models.IntegerField(help_text='Количество упаковок большее или меньшее в сравнении нашей БД и Фарм заказа', verbose_name='Количество упаковок расхождения')),
                ('comment', models.CharField(max_length=100, null=True, verbose_name='Комментарий расхождения сверки')),
            ],
            options={
                'verbose_name': 'Сверка остатков',
                'verbose_name_plural': 'Сверка остатков',
            },
        ),
    ]
