# API Reference <a name="API Reference" id="api-reference"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### Bucket <a name="Bucket" id="workshop-code.Bucket"></a>

#### Initializers <a name="Initializers" id="workshop-code.Bucket.Initializer"></a>

```typescript
import { Bucket } from 'workshop-code'

new Bucket(scope: Construct, id: string, config: BucketConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#workshop-code.Bucket.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#workshop-code.Bucket.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#workshop-code.Bucket.Initializer.parameter.config">config</a></code> | <code><a href="#workshop-code.BucketConfig">BucketConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="workshop-code.Bucket.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="workshop-code.Bucket.Initializer.parameter.id"></a>

- *Type:* string

---

##### `config`<sup>Required</sup> <a name="config" id="workshop-code.Bucket.Initializer.parameter.config"></a>

- *Type:* <a href="#workshop-code.BucketConfig">BucketConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#workshop-code.Bucket.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#workshop-code.Bucket.attachBucketPolicy">attachBucketPolicy</a></code> | *No description.* |
| <code><a href="#workshop-code.Bucket.blockAllPublicAccess">blockAllPublicAccess</a></code> | *No description.* |
| <code><a href="#workshop-code.Bucket.enableSSE">enableSSE</a></code> | *No description.* |
| <code><a href="#workshop-code.Bucket.enableVersioning">enableVersioning</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="workshop-code.Bucket.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `attachBucketPolicy` <a name="attachBucketPolicy" id="workshop-code.Bucket.attachBucketPolicy"></a>

```typescript
public attachBucketPolicy(policy: DataAwsIamPolicyDocument): void
```

###### `policy`<sup>Required</sup> <a name="policy" id="workshop-code.Bucket.attachBucketPolicy.parameter.policy"></a>

- *Type:* @cdktf/provider-aws.dataAwsIamPolicyDocument.DataAwsIamPolicyDocument

---

##### `blockAllPublicAccess` <a name="blockAllPublicAccess" id="workshop-code.Bucket.blockAllPublicAccess"></a>

```typescript
public blockAllPublicAccess(): void
```

##### `enableSSE` <a name="enableSSE" id="workshop-code.Bucket.enableSSE"></a>

```typescript
public enableSSE(kmsKeyId?: string): void
```

###### `kmsKeyId`<sup>Optional</sup> <a name="kmsKeyId" id="workshop-code.Bucket.enableSSE.parameter.kmsKeyId"></a>

- *Type:* string

---

##### `enableVersioning` <a name="enableVersioning" id="workshop-code.Bucket.enableVersioning"></a>

```typescript
public enableVersioning(): void
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#workshop-code.Bucket.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="workshop-code.Bucket.isConstruct"></a>

```typescript
import { Bucket } from 'workshop-code'

Bucket.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="workshop-code.Bucket.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#workshop-code.Bucket.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#workshop-code.Bucket.property.bucket">bucket</a></code> | <code>@cdktf/provider-aws.s3Bucket.S3Bucket</code> | *No description.* |
| <code><a href="#workshop-code.Bucket.property.id">id</a></code> | <code>string</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="workshop-code.Bucket.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `bucket`<sup>Required</sup> <a name="bucket" id="workshop-code.Bucket.property.bucket"></a>

```typescript
public readonly bucket: S3Bucket;
```

- *Type:* @cdktf/provider-aws.s3Bucket.S3Bucket

---

##### `id`<sup>Required</sup> <a name="id" id="workshop-code.Bucket.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---


## Structs <a name="Structs" id="Structs"></a>

### BucketConfig <a name="BucketConfig" id="workshop-code.BucketConfig"></a>

#### Initializer <a name="Initializer" id="workshop-code.BucketConfig.Initializer"></a>

```typescript
import { BucketConfig } from 'workshop-code'

const bucketConfig: BucketConfig = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#workshop-code.BucketConfig.property.blockAllPublicAccess">blockAllPublicAccess</a></code> | <code>boolean</code> | The path for the role. |
| <code><a href="#workshop-code.BucketConfig.property.name">name</a></code> | <code>string</code> | The name to identify the bucket. |
| <code><a href="#workshop-code.BucketConfig.property.sseEnabled">sseEnabled</a></code> | <code>boolean</code> | The path for the role. |
| <code><a href="#workshop-code.BucketConfig.property.versioningEnabled">versioningEnabled</a></code> | <code>boolean</code> | Whether to enable versioning or not on the bucket. |

---

##### `blockAllPublicAccess`<sup>Optional</sup> <a name="blockAllPublicAccess" id="workshop-code.BucketConfig.property.blockAllPublicAccess"></a>

```typescript
public readonly blockAllPublicAccess: boolean;
```

- *Type:* boolean
- *Default:* true

The path for the role.

---

##### `name`<sup>Optional</sup> <a name="name" id="workshop-code.BucketConfig.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name to identify the bucket.

Will be appended to the prefix 'secure-bucket-'.

---

##### `sseEnabled`<sup>Optional</sup> <a name="sseEnabled" id="workshop-code.BucketConfig.property.sseEnabled"></a>

```typescript
public readonly sseEnabled: boolean;
```

- *Type:* boolean
- *Default:* false

The path for the role.

---

##### `versioningEnabled`<sup>Optional</sup> <a name="versioningEnabled" id="workshop-code.BucketConfig.property.versioningEnabled"></a>

```typescript
public readonly versioningEnabled: boolean;
```

- *Type:* boolean
- *Default:* false

Whether to enable versioning or not on the bucket.

---



