import { DataAwsIamPolicyDocument } from '@cdktf/provider-aws/lib/data-aws-iam-policy-document';
import { S3Bucket } from '@cdktf/provider-aws/lib/s3-bucket';
import { Construct } from 'constructs';
export interface BucketConfig {
    /**
     * The name to identify the bucket. Will be appended to the prefix 'secure-bucket-'.
     */
    readonly name?: string;
    /**
     * The path for the role
     * @default false
     */
    readonly sseEnabled?: boolean;
    /**
     * The path for the role
     * @default true
     */
    readonly blockAllPublicAccess?: boolean;
    /**
     * Whether to enable versioning or not on the bucket.
     * @default false
     */
    readonly versioningEnabled?: boolean;
}
export declare class Bucket extends Construct {
    readonly bucket: S3Bucket;
    readonly id: string;
    constructor(scope: Construct, id: string, config: BucketConfig);
    attachBucketPolicy(policy: DataAwsIamPolicyDocument): void;
    enableSSE(kmsKeyId?: string): void;
    blockAllPublicAccess(): void;
    enableVersioning(): void;
}
